/* Created by shraddha M
 * Brand prescription: adding prescription for doctor [09-jan-2021] W20ISUN022
 * */
package ibase.webitm.ejb.wsfa.transactions;

import java.net.InetAddress;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.*;
import ibase.utility.CommonConstants;
import javax.sound.sampled.SourceDataLine;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;

public class SprsCampgnRxWiz extends SprsCampgnRxWizard implements  SprsCampgnRxWizardLocal,SprsCampgnRxWizardRemote
{
	E12GenericUtility genericUtility = new E12GenericUtility();

	public String wfValData() throws RemoteException,ITMException
	{
		return "";
	}
	public String itemChanged() throws RemoteException,ITMException
	{
		return "";
	}
	
	public String itemChanged(String xmlString, String xmlString1,String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams, String formName) throws RemoteException,ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;
		System.out.println("xmlString ["+xmlString+"]");
		System.out.println("xmlString1 ["+xmlString1+"]");
		System.out.println("xmlString2 ["+xmlString2+"]");
		try
		{
			if (xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString);
			}
			if (xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1);
			}
			if (xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2);
			}
			errString = itemChanged( dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams,formName );
			System.out.println ( "ErrString::::" + errString);
		}
		catch (Exception e)
		{
			System.out.println ( "Exception :SprsCampgnRxWiz :itemChanged(String,String):" + e.getMessage() + ":" );
			errString = genericUtility.createErrorString(e);
		}
		return errString;
	}
	
	public String itemChanged( Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams, String formName) throws RemoteException,ITMException
	{
		StringBuffer valueXmlString = new StringBuffer();
		Connection connectionObject = null;
		String userId = "";
		int currentFormNo = 0;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "";
		String spName="";
		String campgnDescr="";
		String campgnID="" , salesPerson="", effFrom="", VallidUpto="", brandCode= "",presctranId="";
		String campgnId="";
		String graceDays="";
		String chgTerm ="";
		String campDate = "";
		String objNameDefault = "";
		String doctorDetail="";
		String itemsDetail="";
		String strgCode="";
		String itemSer="";
		String [] temp = new String [10];
		try
		{
			connectionObject = getConnection();
			System.out.println("xtraParams.....["+xtraParams);
			userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );
			if( objContext != null && objContext.trim().length() > 0 )
			{
				currentFormNo = Integer.parseInt( objContext );
			}
			InetAddress ownIP=InetAddress.getLocalHost();
			chgTerm = ownIP.getHostAddress();
			
			DateFormat dtFormat = new SimpleDateFormat(getApplDateFormat());
			java.util.Date date = Calendar.getInstance().getTime();
			String currDate = dtFormat.format( date );
			valueXmlString = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<editFlag>");
			valueXmlString.append(editFlag).append("</editFlag>\r\n</Header>\r\n");
			
			objNameDefault  = checkNull(getObjNameFromDom( dom2 , "objName" , currentFormNo));
			System.out.println("editFlag.....["+editFlag);
			System.out.println("objNameDefault....."+objNameDefault);
			if("header".equalsIgnoreCase(formName))
				{
					String brandDescr ="";
					String campaignID = checkNull(genericUtility.getColumnValue( "campgn_id" , dom2 ,"1"));
					brandCode = checkNull(genericUtility.getColumnValue( "brand_code", dom2 ,"1"));
					
					
					valueXmlString.append( "<Detail"+currentFormNo+" domID='1' selected = 'N' formName='"+formName+"'>\r\n" );
					valueXmlString.append("<attribute pkNames='' status='N' updateFlag='A' selected='N' />\r\n");
					
					if( currentColumn.equalsIgnoreCase( "itm_default" ))
					{
						sql = "SELECT SP_NAME FROM SALES_PERS WHERE SALES_PERS = ?";
						pstmt =  connectionObject.prepareStatement(sql);
						pstmt.setString(1, userId);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							spName = rs.getString("SP_NAME");

						}
						if (rs!= null)
						{
							rs.close();
							rs = null;
						}
						if(pstmt!=null)
						{
							pstmt.close();
							pstmt = null;
						}
						valueXmlString.append( "<tran_id><![CDATA[" ).append("").append( "]]></tran_id>\r\n" );
						valueXmlString.append( "<tran_date protect='1'><![CDATA[" ).append(currDate).append( "]]></tran_date>\r\n" );
						valueXmlString.append( "<sales_pers><![CDATA[" ).append(userId).append( "]]></sales_pers>\r\n" );
						valueXmlString.append( "<sp_name><![CDATA[" ).append(spName).append( "]]></sp_name>\r\n" );
						valueXmlString.append( "<tran_type><![CDATA[" ).append("P").append( "]]></tran_type>\r\n" );
						valueXmlString.append( "<chg_date><![CDATA[" ).append(currDate).append( "]]></chg_date>\r\n" );
						valueXmlString.append( "<chg_user><![CDATA[" ).append(userId).append( "]]></chg_user>\r\n" );
						valueXmlString.append( "<chg_term><![CDATA[" ).append(chgTerm).append( "]]></chg_term>\r\n" );
						valueXmlString.append( "<brand_code><![CDATA[" ).append("").append( "]]></brand_code>\r\n" );
						valueXmlString.append("<host_url><![CDATA[" ).append(CommonConstants.TOMCAT_HOME).append( "]]></host_url>\r\n" );
						// Added By Nilesh form anguler component itshould display Start :: 12-02-2021
						if(campaignID !=null && campaignID.trim().length()>0)
						{
							String campaignId = "";
							String campignDescr="";
							String effFormDate="",validUptoDate="";	
							
							sql = "SELECT DESCR,EFF_FROM,VALID_UPTO FROM STRG_CAMPAIGN WHERE CAMPGN_ID= ? ";
							pstmt = connectionObject.prepareStatement(sql);
							pstmt.setString(1, campaignID);
							rs = pstmt.executeQuery();
							if( rs.next() )
							{
								campignDescr =checkNull(rs.getString("DESCR"));
								effFormDate =checkNull(rs.getString("EFF_FROM"));
								validUptoDate =checkNull(rs.getString("VALID_UPTO"));
							}
							if(rs!=null)
							{
								rs.close();
								rs = null;
							}
							if(pstmt!=null)
							{
								pstmt.close();
								pstmt = null;
							}
							
							System.out.println(" ::: data[" +campignDescr+"]["+effFormDate+"]["+validUptoDate+"]");
							
							if( (effFormDate != "")  || (validUptoDate !="") )
							{
								System.out.println("Inside....");
								effFormDate = genericUtility.getValidDateString(effFormDate.toString(),genericUtility.getDBDateFormat(), genericUtility.getApplDateFormat());
								validUptoDate = genericUtility.getValidDateString(validUptoDate.toString(),genericUtility.getDBDateFormat(), genericUtility.getApplDateFormat());
							}

							valueXmlString.append("<campgn_id><![CDATA[").append(campaignID).append("]]></campgn_id>\r\n");
							valueXmlString.append("<descr><![CDATA[" ).append(campignDescr).append( "]]></descr>\r\n" );
							valueXmlString.append("<eff_from><![CDATA[" ).append(effFormDate).append( "]]></eff_from>\r\n" );
							valueXmlString.append("<valid_upto><![CDATA[").append(validUptoDate).append("]]></valid_upto>\r\n");
						}
						else
						{   
							
							valueXmlString.append("<campgn_id><![CDATA[").append(campaignID).append("]]></campgn_id>\r\n");
							valueXmlString.append("<descr><![CDATA[" ).append("").append( "]]></descr>\r\n" );
							valueXmlString.append("<eff_from protect='1'><![CDATA[" ).append("").append( "]]></eff_from>\r\n" );
							valueXmlString.append("<valid_upto protect='1'><![CDATA[").append("").append("]]></valid_upto>\r\n");
						}
						
						if(brandCode !=null && brandCode.trim().length()>0)
						{
							sql = "SELECT DESCRIPTION FROM BRAND WHERE BRAND_CODE in "+E12GenericUtility.getFormattedProfileId(brandCode);
							pstmt =  connectionObject.prepareStatement(sql);
							rs = pstmt.executeQuery();
							if ( brandCode.indexOf(",")  != -1)
							{
								while( rs.next() )
								{	
									brandDescr = brandDescr + checkNull(rs.getString("DESCRIPTION")) + ", ";
									System.out.println("Description of brand ========>"+brandDescr);
								}

							}

							else
							{	
								if( rs.next() )
								{
									brandDescr = checkNull(rs.getString("DESCRIPTION"));
									System.out.println(" else if loop :::: ="+brandDescr);
								}
							}
							if (rs!= null)
							{
								rs.close();
								rs = null;
							}
							if(pstmt!=null)
							{
								pstmt.close();
								pstmt = null;
							}
							
							valueXmlString.append("<brand_code><![CDATA[").append(brandCode).append("]]></brand_code>\r\n");
							valueXmlString.append("<brand_description><![CDATA[").append(brandDescr).append("]]></brand_description>\r\n");

						}
						
						// Added By Nilesh form anguler component itshould display End :: 12-02-2021
						
						
					}
					else if(currentColumn.trim().equals("campgn_id"))
					{
						campgnId = genericUtility.getColumnValue("campgn_id",dom);
						if(campgnId != null && campgnId.trim().length() > 0)
						{
							sql= "SELECT DESCR,EFF_FROM,VALID_UPTO,GRACE_DAYS,ITEM_SER FROM STRG_CAMPAIGN  WHERE CAMPGN_ID = ? ";
						
							pstmt = connectionObject.prepareStatement(sql);
							pstmt.setString(1, campgnId);
							rs = pstmt.executeQuery();
							while (rs.next())
							{
								campgnDescr = checkNull(rs.getString("DESCR"));
								effFrom = rs.getString("EFF_FROM");
								VallidUpto = rs.getString("VALID_UPTO");
								graceDays = checkNull(rs.getString("GRACE_DAYS"));
								//System.out.println("campgnDescr::["+campgnDescr+"]");
							}
							if ( rs != null )
							{
								rs.close();
								rs = null;
							}
							if ( pstmt != null )
							{
								pstmt.close();
								pstmt = null;
							}
							if( (effFrom != "" && effFrom.trim().length()>0) || (VallidUpto !="" || VallidUpto.trim().length()>0) )
							{
								effFrom = genericUtility.getValidDateString(effFrom.toString(),genericUtility.getDBDateFormat(), genericUtility.getApplDateFormat());
								VallidUpto = genericUtility.getValidDateString(VallidUpto.toString(),genericUtility.getDBDateFormat(), genericUtility.getApplDateFormat());
							}
						//	System.out.println("campgnId["+campgnId+"]["+graceDays+"]");
							valueXmlString.append( "<campgn_id><![CDATA[" ).append(campgnId).append( "]]></campgn_id>\r\n" );
							valueXmlString.append( "<descr>").append(campgnDescr).append("</descr>\r\n");
							valueXmlString.append( "<eff_from protect='1'><![CDATA[" ).append(effFrom).append( "]]></eff_from>\r\n" );
							valueXmlString.append( "<valid_upto protect='1'><![CDATA[" ).append(VallidUpto).append( "]]></valid_upto>\r\n" );
						}
						else
						{
							valueXmlString.append( "<campgn_id><![CDATA[" ).append("").append( "]]></campgn_id>\r\n" );
							valueXmlString.append("<descr>").append("").append("</descr>\r\n");
							valueXmlString.append( "<eff_from><![CDATA[" ).append("").append( "]]></eff_from>\r\n" );
							valueXmlString.append( "<valid_upto><![CDATA[" ).append("").append( "]]></valid_upto>\r\n" );
						}
						
						
						
					}
					valueXmlString.append("</Detail"+currentFormNo+">");
					
				}
				else if("doctor".equalsIgnoreCase(formName))
				{
					if(currentColumn.equalsIgnoreCase("itm_default"))
					{
						String objName = checkNull(getObjNameFromDom(dom2, "objName",currentFormNo));
						String mainFormNo = checkNull(getFormNo(objName, "header", connectionObject));
						String brandItem = checkNull(getFormNo(objName, "item", connectionObject));
						String tranDate =checkNull(genericUtility.getColumnValue("tran_date", dom2, mainFormNo));
						//System.out.println("mainFormNo:::["+mainFormNo+"]["+objName+"]["+brandItem+"]");
						
						salesPerson = checkNull(genericUtility.getColumnValue("sales_pers", dom2, mainFormNo));
						campgnID = checkNull(genericUtility.getColumnValue("campgn_id", dom2, mainFormNo));
						
						System.out.println("salesPerson:::["+salesPerson+"]["+campgnID+"]["+tranDate+"]");
						
						brandCode = checkNull(genericUtility.getColumnValue("brand_code",dom1,mainFormNo));
						
						doctorDetail = getDoctorDetail(dom,dom1,dom2,campgnID,xtraParams, salesPerson, editFlag,objContext,formName,brandCode,brandItem,connectionObject);
						valueXmlString.append( doctorDetail );
						
						String customers = getCustFromDom( genericUtility.parseString("<Root>"+doctorDetail+"</Root>"),objContext ,salesPerson ,"Y",connectionObject);
						temp = customers.split(",");
						
						
						HashMap<String,String> subFormsMap = getSubForms(objContext, objName, connectionObject);
						System.out.println("subFormsMap["+subFormsMap+"]");
						
						if(subFormsMap.containsKey("item"))
						{
							String itemFormNo = subFormsMap.get("item");
							if ( preDomExists( dom2, itemFormNo ) )
							{
								String prevFormValues =  getPrevFormVal( dom2, itemFormNo,new ArrayList<String>(Arrays.asList(temp)), "strg_code" ) ;
								valueXmlString.append( prevFormValues );
							}
							else if( !"".equalsIgnoreCase( customers ) )
							{
								String existingItem = getExistingItemDetail( salesPerson, tranDate , customers,campgnID,brandCode,itemFormNo,"item",connectionObject ) ;
								//System.out.println( "DefaultDatacamp :: existingItem [ " + existingItem + "]" );
								if( existingItem !=null && existingItem.length() > 0 )
								{
									valueXmlString.append( existingItem);
								}
							}
						}
					}
					
					else if(currentColumn.equalsIgnoreCase("brand_code"))
                    {
						String brandDescription ="";
						String domID=checkNull(getDomID(dom1, ""+currentFormNo));
						//brandCode = genericUtility.getColumnValue("brand_code",dom);
						
						brandCode = checkNull(genericUtility.getColumnValue("brand_code", dom1, ""+currentFormNo));
                        brandCode=brandCode.trim();
                        System.out.println("brandCode::"+brandCode);
						if(brandCode != null && brandCode.trim().length() > 0)
						{
							brandDescription = getBrandDescr(brandCode);
							System.out.println("brandDescription:["+brandDescription+"]");
							valueXmlString.append( "<Detail"+currentFormNo+" domID='"+domID+"' selected = 'Y' formName='"+formName+"'>\r\n" );
							valueXmlString.append( "<brand_code><![CDATA[" ).append(brandCode).append( "]]></brand_code>\r\n" );
							valueXmlString.append( "<description><![CDATA[" ).append(brandDescription).append( "]]></description>\r\n" );
						}
						else
						{
							valueXmlString.append( "<Detail"+currentFormNo+" domID='"+domID+"' selected = 'Y' formName='"+formName+"'>\r\n" );
							valueXmlString.append( "<brand_code><![CDATA[" ).append("").append( "]]></brand_code>\r\n" );
							valueXmlString.append( "<description><![CDATA[" ).append("").append( "]]></description>\r\n" );
						}
						
						
						valueXmlString.append("</Detail"+currentFormNo+">\r\n");
					}
					
				}
				else if("item".equalsIgnoreCase(formName))
				{
					
					String objName = checkNull(getObjNameFromDom(dom2, "objName",currentFormNo));
					if(currentColumn.equalsIgnoreCase("itm_default"))
					{
						String parentFormNo = checkNull(getParentformNo(""+currentFormNo, objName, connectionObject ));
						strgCode = checkNull(getSelectedRowValue(dom2, parentFormNo, "strg_code", 0));
						brandCode = checkNull(getSelectedRowValue(dom2, parentFormNo, "brand_code", 0));
						String mainFormNo = checkNull(getFormNo(objName, "header", connectionObject));
						String campignID = checkNull(getSelectedRowValue(dom2, parentFormNo, "campgn_id", 0));
						System.out.println("ItemDetails deault::["+strgCode+"]["+brandCode+"]");
						String editScCode = checkNull(getSelectedYesRowValue(dom2, parentFormNo, "strg_code", 0));
						
						String itmserSql= " SELECT ITEM_SER FROM SALES_PERS WHERE SALES_PERS= ?";
						pstmt =  connectionObject.prepareStatement(itmserSql);
						pstmt.setString(1, userId);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							itemSer = checkNull(rs.getString("ITEM_SER"));

						}
						if (rs!= null)
						{
							rs.close();
							rs = null;
						}
						if(pstmt!=null)
						{
							pstmt.close();
							pstmt = null;
						}
						
						System.out.println("editScCode::["+editScCode+"]");
						if(editScCode==null || editScCode.trim().length()==0)
						{
							editScCode="X";
						}
						itemsDetail= getcampgnItemDetails(dom, dom2 , userId, campDate, strgCode, brandCode,campignID, xtraParams,formName,connectionObject,editScCode,objContext,itemSer);
						
						valueXmlString.append( itemsDetail );
					}
				}
				valueXmlString.append("</Root>");
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if ( connectionObject != null && ! connectionObject.isClosed())
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				throw new ITMException(e);
			}			
		}
		
		
		System.out.println( "\n****ValueXmlString :" + valueXmlString.toString() + ":********" );
		return valueXmlString.toString();
	}
	
	public String wfValData(String xmlString, String xmlString1,String xmlString2, String objContext, String editFlag, String xtraParams,String formName) throws RemoteException,ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String  errString = null;
		//System.out.println("Entering into  wfValData ...................");
		try
		{
			System.out.println("xmlString ........."+xmlString);
			System.out.println("xmlString1 ........."+xmlString1);
			System.out.println("xmlString2 ........."+xmlString2);

			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = parseString(xmlString);
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = parseString(xmlString1); 
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = parseString("<Root>" + xmlString2+ "</Root>");
			}
			errString = wfValData(dom,dom1,dom2,objContext,editFlag,xtraParams,formName);
		}
		catch(Exception e)
		{
			System.out.println("Exception : SprsCampgnRxWiz : wfValData(String xmlString) : ==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		return (errString);
	}
	public String wfValData(Document dom, Document dom1,Document dom2, String objContext, String editFlag, String xtraParams,String formName) throws RemoteException,ITMException
	{
		Connection conn = null;
		boolean isLocalConn= false;
		int count = 0;
		int ctr,currentFormNo=0;
		int childNodeListLength;
		int noOfChilds = 0;
		int campCnt=0;
		String childNodeName = "";
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String campgnId="";
		String errString = "";
		String sql="";
		String columnValue = "";
		String brandCode = "";
		String doctorName="";
		if(conn==null)
		{
			conn = getConnection();
			isLocalConn=true;
		}
		if(objContext != null && objContext.trim().length()>0)
		{
			currentFormNo = Integer.parseInt(objContext);
		}
		ITMDBAccessEJB itmDBAccessLocal = null;
		System.out.println("xtraParams.... valdata.["+xtraParams);
		String userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
		try
		{
			SimpleDateFormat sdf = new SimpleDateFormat(getApplDateFormat());
			itmDBAccessLocal = new ITMDBAccessEJB();
			System.out.println("wfValData currentFormNo:::::"+currentFormNo);
			
			DateFormat dtFormat = new SimpleDateFormat(getApplDateFormat());
			java.util.Date date = Calendar.getInstance().getTime();
			String currDate = dtFormat.format( date );
			
			if("header".equalsIgnoreCase(formName))
			{
				parentNodeList = dom.getElementsByTagName("Detail1");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				for(ctr = 0; ctr < childNodeListLength; ctr++)
				{
					childNode = childNodeList.item(ctr);
					if ( childNode != null && childNode.getFirstChild() != null )
					{
						columnValue = childNode.getFirstChild().getNodeValue();
					}
					childNodeName = childNode.getNodeName();
					if(childNodeName.equalsIgnoreCase("tran_date"))
					{
						String tranDate = genericUtility.getColumnValue("tran_date",dom);
						if(childNode.getFirstChild() == null)				
						{
							errString = itmDBAccessLocal.getErrorString( "tran_date", "CMPDATENUL", userId );
							break;
						}
					}
					else if(childNodeName.equalsIgnoreCase("campgn_id"))
					{
						if(childNode.getFirstChild() == null)				
						{
							errString = itmDBAccessLocal.getErrorString( "campgn_id", "CMPGNIDNUL", userId );
							break;
						}
						else
						{
							campgnId = genericUtility.getColumnValue("campgn_id",dom);
							
							if(campgnId != null && campgnId.trim().length() > 0)
							{
								sql= "SELECT COUNT(*) AS CAMP_CNT FROM STRG_CAMPAIGN  WHERE CAMPGN_ID = ? ";
							
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, campgnId);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									campCnt = rs.getInt("CAMP_CNT");
								}
								if ( rs != null )
								{
									rs.close();
									rs = null;
								}
								if ( pstmt != null )
								{
									pstmt.close();
									pstmt = null;
								}
								
								if(campCnt==0)
								{
									errString = itmDBAccessLocal.getErrorString( "campgn_id", "INVCMPGNID", userId );
									break;
								}
							}
						}
					}
					
					else if(childNodeName.equalsIgnoreCase("sales_pers"))
					{
						String salesPers = genericUtility.getColumnValue("sales_pers",dom);
						if(childNode.getFirstChild() == null)				
						{
							errString = itmDBAccessLocal.getErrorString( "sales_pers", "CMPSLPRNUL", userId );
							break;
						}
						else if(salesPers != null && salesPers.trim().length() > 0)
						{
							sql = "SELECT COUNT(*) AS COUNT FROM SALES_PERS WHERE SALES_PERS = ?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, salesPers);
							rs = pstmt.executeQuery();
							if ( rs.next() )
							{
								count = rs.getInt("COUNT");	
							}
							if ( rs != null )
							{
								rs.close();
								rs = null;
							}
							if ( pstmt != null )
							{
								pstmt.close();
								pstmt = null;
							}
							if(count == 0 )
							{
								errString = itmDBAccessLocal.getErrorString( "sales_pers", "INVCMPSLPR", userId );
								break;
							}
						}
					}
					else if(childNodeName.equalsIgnoreCase("eff_from"))
					{
						String effFrom = genericUtility.getColumnValue("eff_from",dom);
						if((effFrom == null) || effFrom.trim().length() <= 0)			
						{
							errString = itmDBAccessLocal.getErrorString( "eff_from", "CMPEFFNUL", userId );
							break;
						}
					}
					else if(childNodeName.equalsIgnoreCase("valid_upto"))
					{
						String validUpto = genericUtility.getColumnValue("valid_upto",dom);
						String effFrom = genericUtility.getColumnValue("eff_from",dom);
						
						if(childNode.getFirstChild() == null)				
						{
							errString = itmDBAccessLocal.getErrorString( "valid_upto", "CMVLIDTNUL", userId );
							break;
						}
						else if(validUpto != null && validUpto.trim().length()>0)
						{
							java.util.Date toConValidUpTo = sdf.parse(validUpto);
							java.util.Date toConEffDate = sdf.parse(effFrom);
							
							System.out.println("toConValidUpTo::::"+sdf.format(toConValidUpTo));
							System.out.println("toConEffDate::::"+sdf.format(toConEffDate));
							
							if(toConValidUpTo.before(toConEffDate))
							{
								errString = itmDBAccessLocal.getErrorString( "valid_upto", "CMPINVUPT", userId );
								break;
							}
							
							if( (validUpto != null && validUpto.trim().length()>0) && (effFrom != null && effFrom.trim().length()>0))
							{
								campgnId = genericUtility.getColumnValue("campgn_id",dom);
								sql = "SELECT GRACE_DAYS,VALID_UPTO FROM STRG_CAMPAIGN  WHERE CAMPGN_ID = ? ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, campgnId);
								rs = pstmt.executeQuery();
								if ( rs.next() )
								{
									count = rs.getInt("GRACE_DAYS");
								}
								if ( rs != null )
								{
									rs.close();
									rs = null;
								}
								if ( pstmt != null )
								{
									pstmt.close();
									pstmt = null;
								}
								if(count>0)
								{
									Calendar cal = Calendar.getInstance();
									java.util.Date tograceValidUpto = sdf.parse(validUpto);
									cal.setTime(tograceValidUpto);
									cal.add(cal.DATE,count);
									java.util.Date sysDateAftergraceDay = cal.getTime();
									//System.out.println("value of sysDateAftergraceDay"+sysDateAftergraceDay);
									java.util.Date tocurrDate = sdf.parse(currDate);
									if(sysDateAftergraceDay.compareTo(tocurrDate) < 0)
									{
										errString = itmDBAccessLocal.getErrorString( "valid_upto", "INVCMPVUPD", userId );
									}  
									
								}
							}
						}
					}
					else if(childNodeName.equalsIgnoreCase("remarks"))
					{
						if(columnValue != null && columnValue.length() >60)
						{
							errString = itmDBAccessLocal.getErrorString( "remarks", "INVDCPRMRK", userId );
							break;
						}
					}
					
					if (errString != null && errString.trim().length()>0)
					{
						break;
					}
				}
			}	
			else if("doctor".equalsIgnoreCase(formName))
			{
				String updateFlag="";
				parentNodeList = dom1.getElementsByTagName("Detail"+ currentFormNo);
				int parentNodeListLength = parentNodeList.getLength();
				//System.out.println("wfValData parentNodeListLength:::::::"+parentNodeListLength);
				for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
				{
					parentNode = parentNodeList.item(prntCtr);
					childNodeList = parentNode.getChildNodes();
					childNodeListLength = childNodeList.getLength();
					for ( ctr = 0; ctr < childNodeListLength; ctr++)
					{
						childNode = childNodeList.item(ctr);
						if( childNode.getNodeType() != Node.ELEMENT_NODE )
						{
							continue;
						}
						childNodeName = childNode.getNodeName();
						
						if(childNodeName.equalsIgnoreCase("attribute"))
						{
							if(childNode.getAttributes().getNamedItem("updateFlag") != null)
							{
								updateFlag = childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
							}
						}
						
						if(childNodeName.equalsIgnoreCase("brand_code"))
						{
							brandCode = checkNull(genericUtility.getColumnValue("brand_code", dom2, objContext));
							doctorName = checkNull(genericUtility.getColumnValueFromNode("cust_name", parentNode));
							if(childNode.getFirstChild() == null)				
							{
								if((childNode.getFirstChild() == null))
								{
									errString = itmDBAccessLocal.getErrorString( "brand_code", "CMPBRNDNUL", userId );
									break;
								}
							}
						
							else
							{
								if(brandCode != null && brandCode.trim().length() > 0)
								{
									if ( brandCode.indexOf(",")  != -1)
									{
										sql = " SELECT COUNT(*) CNT FROM BRAND WHERE BRAND_CODE in "+ E12GenericUtility.getFormattedProfileId(brandCode)+"";
										pstmt = conn.prepareStatement(sql);
										rs = pstmt.executeQuery();
										while (rs.next())
										{
											count = rs.getInt("CNT");
										}
										if ( rs != null )
										{
											rs.close();
											rs = null;
										}
										if ( pstmt != null )
										{
											pstmt.close();
											pstmt = null;
										}
										if(count == 0)
										{
											errString = itmDBAccessLocal.getErrorString( "brand_code", "INVSTRGBRD", userId );
											break;
										}
									}
									else
									{
										sql = "SELECT COUNT(*) BRAND FROM BRAND WHERE BRAND_CODE = ? ";
										pstmt = conn.prepareStatement(sql);
										pstmt.setString(1, brandCode);
										rs = pstmt.executeQuery();
										if ( rs.next() )
										{
											count = rs.getInt("BRAND");
										}
										if ( rs != null )
										{
											rs.close();
											rs = null;
										}
										if ( pstmt != null )
										{
											pstmt.close();
											pstmt = null;
										}
										if(count == 0)
										{
											errString = itmDBAccessLocal.getErrorString( "brand_code", "INVSTRGBRD", userId );
											break;
										}
									}
								}
							}
						}
						else if(childNodeName.equalsIgnoreCase("description"))
						{
							doctorName = checkNull(genericUtility.getColumnValueFromNode("cust_name", parentNode));
							if(childNode.getFirstChild() == null)				
							{
								errString = itmDBAccessLocal.getErrorString( "description", "BRDESCNULL", userId );
								break;
							}
						}
						if (errString != null && errString.trim().length()>0)
						{
							break;
						}
					}
				}
			
			}
			else if("item".equalsIgnoreCase(formName))
			{
				noOfChilds=0;
				String updateFlag = "",outcomeNum="";
				parentNodeList = dom.getElementsByTagName("Detail"+ currentFormNo);
				int parentNodeListLength = parentNodeList.getLength();
				for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
				{
					parentNode = parentNodeList.item(prntCtr);
					childNodeList = parentNode.getChildNodes();
					noOfChilds = childNodeList.getLength();
					for (int cntr = 0; cntr < noOfChilds; cntr++)
					{
						childNode = childNodeList.item(cntr);
						if( childNode.getNodeType() != Node.ELEMENT_NODE )
						{
							continue;
						}
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							columnValue = childNode.getFirstChild().getNodeValue();
						}
						childNodeName = childNode.getNodeName();
						if(childNodeName.equalsIgnoreCase("attribute"))
						{
							if(childNode.getAttributes().getNamedItem("updateFlag") != null)
							{
								updateFlag = checkNull(childNode.getAttributes().getNamedItem("updateFlag").getNodeValue());
							}
						}
						if(childNodeName.equalsIgnoreCase("outcome_num"))
						{
							if(childNode.getFirstChild() == null)				
							{
								errString = itmDBAccessLocal.getErrorString( "outcome_num", "NULITMQTY", userId );
								break;
							}
							else
							{
								outcomeNum = checkNull(genericUtility.getColumnValue("outcome_num", dom1, objContext));
								int qty = Integer.parseInt(outcomeNum);
								if( qty <= 0 )
								{
									errString = itmDBAccessLocal.getErrorString("outcome_num","INVITMQTY",userId);
									break;
								}
							}
						}

					}
				}
			
			}
			
			if(errString.indexOf("<Errors>")!=-1)
			{
				System.out.println("inside the error");
				if( errString.length() > 0 )
				{
					String msgDescr = "";
					msgDescr = errString.substring(errString.indexOf("<description>")+("<description>").length(),errString.indexOf("</description>")) + doctorName ;
					System.out.println("msgDescr the error["+msgDescr+"]cust name["+doctorName+"]");

					if( doctorName.length() != 0 && !doctorName.equalsIgnoreCase("") )
					{
						errString = errString.substring(0, errString.indexOf("<description>")+("<description>").length()) +"<![CDATA["+ msgDescr +"]]>"+"" + errString.substring( errString.indexOf("</description>"), errString.length());
					}
				}
			}
	}	
	catch(Exception e)
	{

		System.out.println("Exception ::"+e);
		e.printStackTrace();
		throw new ITMException(e);
	}
	finally
	{
		try
		{
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			if ( isLocalConn && conn != null && ! conn.isClosed())
			{
				conn.close();
				conn = null;
			}
		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}			
	}
	return errString;
}
	
	public String wfValOnDone(String xmlString, String xmlString1,String xmlString2, String objContext, String editFlag, String xtraParams,String formName) throws RemoteException,ITMException
	{

		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = "";

		try
		{
			System.out.println("wfValOnDonexmlString["+xmlString+"]");
			System.out.println("wfValOnDone:xmlString1["+xmlString1+"]");
			System.out.println("wfValData:xmlString2["+xmlString2+"]");
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = parseString(xmlString);
			}
			else
			{
				System.out.println("xmlString is null");
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = parseString(xmlString1);
			}
			else
			{
				System.out.println("xmlString1 null");
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = parseString(xmlString2);
			}
			else
			{
				System.out.println("xmlString2 is null");
			}
			System.out.println("Before call valdata formName:- "+formName);
			errString = wfValOnDone(dom,dom1,dom2,objContext,editFlag,xtraParams,formName);
		}
		catch(Exception e)
		{
			System.out.println("Exception : [SprsCampgnRxWiz][wfValData(String xmlString)] : ==>\n"+e.getMessage());
		}
		return (errString);
	
	}
	public String wfValOnDone(Document dom, Document dom1,Document dom2, String objContext, String editFlag, String xtraParams, String formName) throws RemoteException,ITMException
	{
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

		Connection conn = null;
		String errString = "";
		String sql="";
		boolean isLocalConn= false;
		int count = 0;
		int ctr,currentFormNo=0;
		int childNodeListLength;
		String childNodeName = "";
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String brandCode = "";
		
		int noOfChilds = 0;
		String columnValue="";
		String doctorName="";
		NodeList parentList = null;
		NodeList childList = null;
		if(conn==null)
		{
			conn = getConnection();
			isLocalConn=true;
		}
		if(objContext != null && objContext.trim().length()>0)
		{
			currentFormNo = Integer.parseInt(objContext);
		}
		ITMDBAccessEJB itmDBAccessLocal = null;
		String userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
		
		try
		{
			SimpleDateFormat sdf = new SimpleDateFormat(getApplDateFormat());
			itmDBAccessLocal = new ITMDBAccessEJB();
			
				if("doctor".equalsIgnoreCase(formName))
				{
					int selectedFlagCnt = 0;
					int updateFlagCnt = 0;
					parentList = dom1.getElementsByTagName("Detail"+ currentFormNo);
					int parentNodeListLength = parentList.getLength();
					for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
					{
						String selectedFlag = "";
						String updateFlag = "";

						Node currDetail = parentList.item(prntCtr);
						if(currDetail.getAttributes().getNamedItem("selected") != null)
						{
							selectedFlag = currDetail.getAttributes().getNamedItem("selected").getNodeValue();
						}
						if(selectedFlag != null && "Y".equalsIgnoreCase(selectedFlag))
						{
							selectedFlagCnt++;
						}

						parentNode = parentList.item(prntCtr);
						childList = parentNode.getChildNodes();
						noOfChilds = childList.getLength();
						for (ctr = 0; ctr < noOfChilds; ctr++)
						{
							childNode = childList.item(ctr);
							if( childNode.getNodeType() != Node.ELEMENT_NODE )
							{
								continue;
							}
							childNodeName = childNode.getNodeName();
							if(childNodeName.equalsIgnoreCase("attribute"))
							{
								if(childNode.getAttributes().getNamedItem("updateFlag") != null)
								{
									updateFlag = childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
								}
							}
						}
						if(updateFlag != null && "D".equalsIgnoreCase(updateFlag))
						{
							updateFlagCnt++;
						}
					}
					
					if(selectedFlagCnt > 0)
					{
						for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
						{
							parentNode = parentList.item(prntCtr);
							childList = parentNode.getChildNodes();
							noOfChilds = childList.getLength();
							
							for (ctr = 0; ctr < noOfChilds; ctr++)
							{
								childNode = childList.item(ctr);
								if( childNode.getNodeType() != Node.ELEMENT_NODE )
								{
									continue;
								}

								if ( childNode != null && childNode.getFirstChild() != null )
								{
									columnValue = childNode.getFirstChild().getNodeValue();
								}
								childNodeName = childNode.getNodeName();
								
								if(childNodeName.equalsIgnoreCase("brand_code"))
								{
									brandCode = checkNull(genericUtility.getColumnValue("brand_code", dom2, objContext));
									doctorName = checkNull(genericUtility.getColumnValueFromNode("cust_name", parentNode));
									 
									if(childNode.getFirstChild() == null)				
									{
											errString = itmDBAccessLocal.getErrorString( "brand_code", "CMPBRNDNUL", userId );
											break;
										
									}
								
									else
									{
										if(brandCode != null && brandCode.trim().length() > 0)
										{
											if ( brandCode.indexOf(",")  != -1)
											{
												sql = " SELECT COUNT(*) CNT FROM BRAND WHERE BRAND_CODE in "+ E12GenericUtility.getFormattedProfileId(brandCode)+"";
												pstmt = conn.prepareStatement(sql);
												rs = pstmt.executeQuery();
												while (rs.next())
												{
													count = rs.getInt("CNT");
													System.out.println("BRAND count::["+count+"]");
												}
												if ( rs != null )
												{
													rs.close();
													rs = null;
												}
												if ( pstmt != null )
												{
													pstmt.close();
													pstmt = null;
												}
												if(count == 0)
												{
													errString = itmDBAccessLocal.getErrorString( "brand_code", "INVSTRGBRD", userId );
													break;
												}
											}
											else
											{
												sql = "SELECT COUNT(*) BRAND FROM BRAND WHERE BRAND_CODE = ? ";
												pstmt = conn.prepareStatement(sql);
												pstmt.setString(1, brandCode);
												rs = pstmt.executeQuery();
												if ( rs.next() )
												{
													count = rs.getInt("BRAND");
													System.out.println("BRAND count::["+count+"]");
												}
												if ( rs != null )
												{
													rs.close();
													rs = null;
												}
												if ( pstmt != null )
												{
													pstmt.close();
													pstmt = null;
												}
												if(count == 0)
												{
													errString = itmDBAccessLocal.getErrorString( "brand_code", "INVSTRGBRD", userId );
													break;
												}
											}
											
										}
									}
								}
								else if(childNodeName.equalsIgnoreCase("description"))
								{
									doctorName = checkNull(genericUtility.getColumnValueFromNode("cust_name", parentNode));
									if(childNode.getFirstChild() == null)				
									{
										errString = itmDBAccessLocal.getErrorString( "description", "BRDESCNULL", userId );
										break;
									}
								}
							}
						}
					}
				}
				if("item".equalsIgnoreCase(formName))
				{
					String outcomeNum="";
					String updateFlag = "";
					parentNodeList = dom.getElementsByTagName("Detail"+ currentFormNo);
					int parentNodeListLength = parentNodeList.getLength();
					for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
					{
						parentNode = parentNodeList.item(prntCtr);
						childNodeList = parentNode.getChildNodes();
						noOfChilds = childNodeList.getLength();
						for (int cntr = 0; cntr < noOfChilds; cntr++)
						{
							childNode = childNodeList.item(cntr);
							if( childNode.getNodeType() != Node.ELEMENT_NODE )
							{
								continue;
							}
							if ( childNode != null && childNode.getFirstChild() != null )
							{
								columnValue = childNode.getFirstChild().getNodeValue();
							}
							childNodeName = childNode.getNodeName();
							if(childNodeName.equalsIgnoreCase("attribute"))
							{
								if(childNode.getAttributes().getNamedItem("updateFlag") != null)
								{
									updateFlag = checkNull(childNode.getAttributes().getNamedItem("updateFlag").getNodeValue());
								}
							}
							if(childNodeName.equalsIgnoreCase("outcome_num"))
							{
								if(childNode.getFirstChild() == null)				
								{
									errString = itmDBAccessLocal.getErrorString( "outcome_num", "NULITMQTY", userId );
									break;
								}
								else
								{
									outcomeNum = checkNull(genericUtility.getColumnValue("outcome_num", dom1, objContext));
									System.out.println("outcomeNum:::["+outcomeNum+"]");
									if(outcomeNum!=null && outcomeNum.trim().length() > 0) 
									{
										int qty = Integer.parseInt(outcomeNum);
										if( qty <= 0 )
										{
											errString = itmDBAccessLocal.getErrorString("outcome_num","INVITMQTY",userId);
											break;
										}
									}
									
								}
							}
						}

					}
				}
				
				if(errString.indexOf("<Errors>")!=-1)
				{
					System.out.println("inside the error");
					if( errString.length() > 0 )
					{
						String msgDescr = "";
						msgDescr = errString.substring(errString.indexOf("<description>")+("<description>").length(),errString.indexOf("</description>")) + doctorName ;
						System.out.println("msgDescr the error["+msgDescr+"]cust name["+doctorName+"]");

						if( doctorName.length() != 0 && !doctorName.equalsIgnoreCase("") )
						{
							errString = errString.substring(0, errString.indexOf("<description>")+("<description>").length()) +"<![CDATA["+ msgDescr +"]]>"+"" + errString.substring( errString.indexOf("</description>"), errString.length());
						}
					}
				}
			}
		catch(Exception e)
		{

			System.out.println("Exception ::"+e);
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if ( isLocalConn && conn != null && ! conn.isClosed())
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				throw new ITMException(e);
			}			
		}
		return (errString);
	}
	public String wfValOnFinish(String xmlString, String xmlString1,String xmlString2, String objContext, String editFlag, String xtraParams,String formName) throws RemoteException,ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = "";

		try
		{
			System.out.println("wfValOnFinish:xmlString["+xmlString+"]");
			System.out.println("wfValOnFinish:xmlString1["+xmlString1+"]");
			System.out.println("wfValOnFinish:xmlString2["+xmlString2+"]");
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = parseString(xmlString);
			}
			else
			{
				System.out.println("wfValOnFinish xmlString null");
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = parseString(xmlString1);
			}
			else
			{
				System.out.println("wfValOnFinish xmlString1 null");
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = parseString(xmlString2);
			}
			else
			{
				System.out.println("wfValOnFinish xmlString2 is null");
			}
			errString = wfValOnFinish(dom,dom1,dom2,objContext,editFlag,xtraParams,formName);
		}
		catch(Exception e)
		{
			System.out.println("Exception : [SprsCampgnRxWiz][wfValOnFinish(String xmlString)] : ==>\n"+e.getMessage());
		}
		return (errString);
	
	
	}
	public String wfValOnFinish(Document dom, Document dom1,Document dom2, String objContext, String editFlag, String xtraParams, String formName) throws RemoteException,ITMException
	{
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

		Connection conn = null;
		String errString = "";
		String sql="";
		boolean isLocalConn= false;
		int count = 0;
		int ctr,currentFormNo=0;
		int childNodeListLength;
		String childNodeName = "";
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String brandCode ="" ;
		String campgnId="";
		String columnValue="";
		String doctorName="";
		if(conn==null)
		{
			conn = getConnection();
			isLocalConn=true;
		}
		if(objContext != null && objContext.trim().length()>0)
		{
			currentFormNo = Integer.parseInt(objContext);
		}
		ITMDBAccessEJB itmDBAccessLocal = null;
		String userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
		
		try
		{
			SimpleDateFormat sdf = new SimpleDateFormat(getApplDateFormat());
			DateFormat dtFormat = new SimpleDateFormat(getApplDateFormat());
			java.util.Date date = Calendar.getInstance().getTime();
			String currDate = dtFormat.format( date );
			itmDBAccessLocal = new ITMDBAccessEJB();
			if("header".equalsIgnoreCase(formName) )
			{
				parentNodeList = dom.getElementsByTagName("Detail1");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				for(ctr = 0; ctr < childNodeListLength; ctr++)
				{
					childNode = childNodeList.item(ctr);
					if ( childNode != null && childNode.getFirstChild() != null )
					{
						columnValue = childNode.getFirstChild().getNodeValue();
					}
					childNodeName = childNode.getNodeName();
					if(childNodeName.equalsIgnoreCase("tran_date"))
					{
						if(childNode.getFirstChild() == null)				
						{
							errString = itmDBAccessLocal.getErrorString( "tran_date", "CMPDATENUL", userId );
							break;
						}
					}
					else if(childNodeName.equalsIgnoreCase("campgn_id"))
					{
						if(childNode.getFirstChild() == null)				
						{
							errString = itmDBAccessLocal.getErrorString( "campgn_id", "CMPGNIDNUL", userId );
							break;
						}
					}
					
					else if(childNodeName.equalsIgnoreCase("sales_pers"))
					{
						String salesCode = genericUtility.getColumnValue("sales_pers",dom);
						if(childNode.getFirstChild() == null)				
						{
							errString = itmDBAccessLocal.getErrorString( "sales_pers", "CMPSLPRNUL", userId );
							break;
						}
						else if(salesCode != null && salesCode.trim().length() > 0)
						{
							sql = "SELECT COUNT(*) AS COUNT FROM SALES_PERS WHERE SALES_PERS = ?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, salesCode);
							rs = pstmt.executeQuery();
							if ( rs.next() )
							{
								count = rs.getInt("COUNT");	
							}
							if ( rs != null )
							{
								rs.close();
								rs = null;
							}
							if ( pstmt != null )
							{
								pstmt.close();
								pstmt = null;
							}
							if(count == 0 )
							{
								errString = itmDBAccessLocal.getErrorString( "sales_pers", "INVCMPSLPR", userId );
								break;
							}
						}
					}
					else if(childNodeName.equalsIgnoreCase("eff_from"))
					{
						String effFrom = genericUtility.getColumnValue("eff_from",dom);
						System.out.println("effFrom:::::["+effFrom+"]");
						if((effFrom == null) || effFrom.trim().length() <= 0)			
						{
							errString = itmDBAccessLocal.getErrorString( "eff_from", "CMPEFFNUL", userId );
							break;
						}
						
					}
					else if(childNodeName.equalsIgnoreCase("valid_upto"))
					{
						String validUpto = genericUtility.getColumnValue("valid_upto",dom);
						String effFrom = genericUtility.getColumnValue("eff_from",dom);
						System.out.println("Dates::::["+validUpto+"]["+effFrom+"]");
						
						if(childNode.getFirstChild() == null)				
						{
							errString = itmDBAccessLocal.getErrorString( "valid_upto", "CMVLIDTNUL", userId );
							break;
						}
						else if(validUpto != null && validUpto.trim().length()>0)
						{
							java.util.Date toConValidUpTo = sdf.parse(validUpto);
							java.util.Date toConEffDate = sdf.parse(effFrom);
							
							System.out.println("toConValidUpTo::::"+sdf.format(toConValidUpTo));
							System.out.println("toConEffDate::::"+sdf.format(toConEffDate));
							if(toConValidUpTo.before(toConEffDate))
							{
								errString = itmDBAccessLocal.getErrorString( "valid_upto", "CMPINVUPT", userId );
								break;
							}
							
							if( (validUpto != null && validUpto.trim().length()>0) && (effFrom != null && effFrom.trim().length()>0))
							{
								campgnId = genericUtility.getColumnValue("campgn_id",dom);
								sql = "SELECT GRACE_DAYS FROM STRG_CAMPAIGN  WHERE CAMPGN_ID = ? ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, campgnId);
								rs = pstmt.executeQuery();
								if ( rs.next() )
								{
									count = rs.getInt("GRACE_DAYS");
								}
								if(count>0)
								{
									Calendar cal = Calendar.getInstance();
									java.util.Date tograceValidUpto = sdf.parse(validUpto);
									cal.setTime(tograceValidUpto);
									cal.add(cal.DATE,count);
									java.util.Date sysDateAftergraceDay = cal.getTime();
									System.out.println("value of sysDateAftergraceDay"+sysDateAftergraceDay);
									java.util.Date tocurrDate = sdf.parse(currDate);
									if(sysDateAftergraceDay.compareTo(tocurrDate) < 0)
									{
										errString = itmDBAccessLocal.getErrorString( "valid_upto", "INVCMPVUPD", userId );
									}  
									
								}
							}
						}
					}
					else if(childNodeName.equalsIgnoreCase("remarks"))
					{
						if(columnValue != null && columnValue.length() >60)
						{
							errString = itmDBAccessLocal.getErrorString( "remarks", "INVDCPRMRK", userId );
							break;
						}
					}
					if (errString != null && errString.trim().length()>0)
					{
						break;
					}
				}	
			}
			else if("doctor".equalsIgnoreCase(formName))
			{
				String updateFlag="";
				parentNodeList = dom2.getElementsByTagName("Detail"+ currentFormNo);
				int parentNodeListLength = parentNodeList.getLength();
				//System.out.println("finishvaldata parentNodeListLength:::::::"+parentNodeListLength);
				for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
				{
					parentNode = parentNodeList.item(prntCtr);
					childNodeList = parentNode.getChildNodes();
					childNodeListLength = childNodeList.getLength();
					for ( ctr = 0; ctr < childNodeListLength; ctr++)
					{
						childNode = childNodeList.item(ctr);
						if( childNode.getNodeType() != Node.ELEMENT_NODE )
						{
							continue;
						}
						childNodeName = childNode.getNodeName();
						
						if(childNodeName.equalsIgnoreCase("attribute"))
						{
							if(childNode.getAttributes().getNamedItem("updateFlag") != null)
							{
								updateFlag = childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
							}
						}
					}
					//System.out.println(" finish updateFlag =["+updateFlag+"]");
					if(!"D".equalsIgnoreCase(updateFlag))
					{
						if(childNodeName.equalsIgnoreCase("brand_code"))
						{
							brandCode = checkNull(genericUtility.getColumnValue("brand_code", dom2, objContext));
							doctorName = checkNull(genericUtility.getColumnValueFromNode("cust_name", parentNode));
							if(childNode.getFirstChild() == null)				
							{
								if((childNode.getFirstChild() == null))
								{
									errString = itmDBAccessLocal.getErrorString( "brand_code", "CMPBRNDNUL", userId );
									break;
								}
							}
						
							else
							{
								if(brandCode != null && brandCode.trim().length() > 0)
								{
									if ( brandCode.indexOf(",")  != -1)
									{
										sql = " SELECT COUNT(*) CNT FROM BRAND WHERE BRAND_CODE in "+ E12GenericUtility.getFormattedProfileId(brandCode)+"";
										pstmt = conn.prepareStatement(sql);
										rs = pstmt.executeQuery();
										while (rs.next())
										{
											count = rs.getInt("CNT");
										}
										if ( rs != null )
										{
											rs.close();
											rs = null;
										}
										if ( pstmt != null )
										{
											pstmt.close();
											pstmt = null;
										}
										if(count == 0)
										{
											errString = itmDBAccessLocal.getErrorString( "brand_code", "INVSTRGBRD", userId );
											break;
										}
												
										}
										else
										{
											sql = "SELECT COUNT(*) BRAND FROM BRAND WHERE BRAND_CODE = ? ";
											pstmt = conn.prepareStatement(sql);
											pstmt.setString(1, brandCode);
											rs = pstmt.executeQuery();
											if ( rs.next() )
											{
												count = rs.getInt("BRAND");
											}
											if ( rs != null )
											{
												rs.close();
												rs = null;
											}
											if ( pstmt != null )
											{
												pstmt.close();
												pstmt = null;
											}
											if(count == 0)
											{
												errString = itmDBAccessLocal.getErrorString( "brand_code", "INVSTRGBRD", userId );
												break;
											}
										}
										
									}
								}
							}
							else if(childNodeName.equalsIgnoreCase("description"))
							{
								String description = checkNull(genericUtility.getColumnValueFromNode("description", parentNode));
								doctorName = checkNull(genericUtility.getColumnValueFromNode("cust_name", parentNode));
								if(description==null || description=="")
								{
									errString = itmDBAccessLocal.getErrorString( "description", "BRDESCNULL", userId );
									break;
								}
							}
						}
						if (errString != null && errString.trim().length()>0)
						{
							break;
						}
					}
			}
			else if("item".equalsIgnoreCase(formName))
			{
				String outcomeNum="";
				int noOfChilds=0;
				String updateFlag = "";
				parentNodeList = dom.getElementsByTagName("Detail"+ currentFormNo);
				int parentNodeListLength = parentNodeList.getLength();
				for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
				{
					parentNode = parentNodeList.item(prntCtr);
					childNodeList = parentNode.getChildNodes();
					noOfChilds = childNodeList.getLength();
					for (int cntr = 0; cntr < noOfChilds; cntr++)
					{
						childNode = childNodeList.item(cntr);
						if( childNode.getNodeType() != Node.ELEMENT_NODE )
						{
							continue;
						}
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							columnValue = childNode.getFirstChild().getNodeValue();
						}
						childNodeName = childNode.getNodeName();
						if(childNodeName.equalsIgnoreCase("attribute"))
						{
							if(childNode.getAttributes().getNamedItem("updateFlag") != null)
							{
								updateFlag = checkNull(childNode.getAttributes().getNamedItem("updateFlag").getNodeValue());
							}
						}
						if(childNodeName.equalsIgnoreCase("outcome_num"))
						{
							if(childNode.getFirstChild() == null)				
							{
								errString = itmDBAccessLocal.getErrorString( "outcome_num", "NULITMQTY", userId );
								break;
							}
							else
							{
								outcomeNum = checkNull(genericUtility.getColumnValue("outcome_num", dom1, objContext));
								int qty = Integer.parseInt(outcomeNum);
								if( qty <= 0 )
								{
									errString = itmDBAccessLocal.getErrorString("outcome_num","INVITMQTY",userId);
									break;
								}
							}
						}

					}
				}
			}
				
			if(errString.indexOf("<Errors>")!=-1)
			{
				System.out.println("inside the error");
				if( errString.length() > 0 )
				{
					String msgDescr = "";
					msgDescr = errString.substring(errString.indexOf("<description>")+("<description>").length(),errString.indexOf("</description>")) + doctorName ;
					System.out.println("msgDescr the error["+msgDescr+"]cust name["+doctorName+"]");

					if( doctorName.length() != 0 && !doctorName.equalsIgnoreCase("") )
					{
						errString = errString.substring(0, errString.indexOf("<description>")+("<description>").length()) +"<![CDATA["+ msgDescr +"]]>"+"" + errString.substring( errString.indexOf("</description>"), errString.length());
					}
				}
			}
			
		}
		catch(Exception e)
		{

			System.out.println("Exception ::"+e);
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if ( isLocalConn && conn != null && ! conn.isClosed())
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				throw new ITMException(e);
			}			
		}
		return (errString);
	}
	
	
	private String getDomID(Document dom2,String objContext)
	{
		Node elementName = null;
		NodeList elementList = null;
		String objName = "";
		elementList = dom2.getElementsByTagName("Detail"+objContext);
		elementName = elementList.item(0);
		if (elementName!=null && ("Detail"+objContext).equalsIgnoreCase(elementName.getNodeName()))
		{
			NamedNodeMap etlAttributes = elementName.getAttributes();
			if (etlAttributes!=null)
			{
				if (etlAttributes.getNamedItem("domID")!=null)
				{
					objName = etlAttributes.getNamedItem("domID").getNodeValue();
				}
			}
		}
		return objName;
	}
	public HashMap getSubForms(String formNo, String objName, Connection conn) throws ITMException
	{
		PreparedStatement pStmt = null;
		PreparedStatement pStmtInner = null;
		ResultSet rs = null;
		ResultSet rsInner = null;
		String formType = "";
		HashMap<String, String> SubFormMap = new HashMap<String,String>();
		try
		{
			String winName = "w_"+objName;
			String sql = "SELECT FORM_NO,FORM_TYPE FROM OBJ_FORMS WHERE WIN_NAME = ? AND FORM_NO = ?";
			pStmt = conn.prepareStatement(sql);
			pStmt.setString(1, winName);
			pStmt.setString(2, formNo);
			rs = pStmt.executeQuery();
			if( rs.next() )
			{
				formType = checkNull(rs.getString("FORM_TYPE"));
			}
			if( rs !=null )
			{
				rs.close();
				rs = null;
			}
			if( pStmt !=null )
			{
				pStmt.close();
				pStmt = null;
			}
			if(formType.indexOf(":")>=0)
			{
				String[] nextArr = formType.split(":",3);
				String  nextForm= nextArr[2];

				int nextFormNo = 0;
				int currFormNo = 0;
				if( nextForm != null && nextForm.trim().length() > 0 )
				{
					nextFormNo = Integer.parseInt( nextForm );
				}
				if( formNo != null && formNo.trim().length() > 0 )
				{
					currFormNo = Integer.parseInt( formNo );
				}
				String formNameSql = "SELECT FORM_NO,FORM_NAME FROM OBJ_FORMS WHERE WIN_NAME = ? AND FORM_NO = ? ";
				pStmtInner = conn.prepareStatement(formNameSql);

				for(int i = (currFormNo+1) ; i< nextFormNo; i++)
				{
					pStmtInner.setString(1, winName);
					pStmtInner.setInt(2, i);

					rsInner = pStmtInner.executeQuery();

					if(rsInner.next())
					{
						String _formNo = checkNull(rsInner.getString("FORM_NO"));
						String _formName = checkNull(rsInner.getString("FORM_NAME"));
						SubFormMap.put( _formName,_formNo);
					}
					pStmtInner.clearParameters();
					if( rsInner !=null )
					{
						rsInner.close();
						rsInner = null;
					}
				}
			}

		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);

		}
		finally
		{
			try
			{
				if( rs !=null )
				{
					rs.close();
					rs = null;
				}
				if( pStmt !=null )
				{
					pStmt.close();
					pStmt = null;
				}
				if( pStmtInner !=null )
				{
					pStmtInner.close();
					pStmtInner = null;
				}

			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return SubFormMap;
	}
	
}
