/*
 Request ID :
 Purpose : WsfaDSRMobileSaveVal for implementing logic of validation method.
  		  To Achive the Validation on the Finish button for Mobile.
 Date : 27-AUG-14
 Created By : Gaurav Singh
 */
package ibase.webitm.ejb.wsfa.transactions;

import java.io.*;
import java.rmi.RemoteException;
import java.sql.*;
import java.text.*;
import java.util.*;
import java.util.Date;

import javax.ejb.*;
import javax.naming.InitialContext;
import javax.xml.parsers.*;

import org.apache.commons.io.FileUtils;
import org.w3c.dom.*;

import ibase.ejb.*;
import ibase.system.config.*;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.webitm.ejb.*;
//Commented and Changes Done By Gaurav Singh on 03-Sep-14
//import ibase.webitm.utility.GenericUtility;
import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.ITMException;

import javax.xml.transform.*;
import javax.xml.transform.dom.*;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.stream.StreamSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerConfigurationException;

import org.xml.sax.InputSource;

import java.net.InetAddress;

import org.apache.commons.io.CopyUtils;
import org.apache.commons.io.FileUtils;
import org.jfree.io.FileUtilities;




//@javax.ejb.Stateless			commented by Sagar M [22 Nov 2018].
public class WsfaDSRValidateMobWizEJB extends ValidatorEJB implements WsfaDSRValidateMobWizEJBLocal,WsfaDSRValidateMobWizEJBRemote
{

	private String user_lang ="en";
	//code for Validation
	public String wfValData() throws RemoteException,ITMException
	{
		return "";
	}

	public String wfValData(String xmlString, String xmlString1,String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = "";

		try
		{
			System.out.println("wfValData:xmlStringaaaaaaaa ["+xmlString+"]");
			System.out.println("wfValData:xmlString1bbbbbb["+xmlString1+"]");
			System.out.println("wfValData:xmlString2cccccccc["+xmlString2+"]");
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = parseString(xmlString);
			}
			else
			{
				System.out.println("xmlstring is null");
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = parseString(xmlString1);
			}
			else
			{
				System.out.println("xmlstring1 is null");
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = parseString(xmlString2);
			}
			else
			{
				System.out.println("xmlstring2 is null");
			}
			System.out.println("Before call valdata");
			errString = wfValData(dom,dom1,dom2,objContext,editFlag,xtraParams);
		}
		catch(Exception e)
		{
			System.out.println("Exception : [ExpenseProcessItemChange][wfValData(String xmlString)] : ==>\n"+e.getMessage());
		}
		return (errString);
	}

	public String wfValData(Document dom, Document dom1,Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		//Commented and Changes Done By Gaurav Singh on 03-Sep-14
		//GenericUtility genericUtility = GenericUtility.getInstance();
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

		String userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
		String errString = "";
		int currentFormNo = 0;

		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		String childNodeName = "";
		String columnValue = "";
		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		ResultSet rSet = null ;
		String checkSQL = "";//Gaurav Singh on 10-06-2015

		ITMDBAccessEJB itmDBAccessLocal = null;// modified by kailash.
		int noOfChilds = 0;

		try
		{

			ConnDriver connDriver =new ConnDriver();
			connectionObject = connDriver.getConnectDB("DriverValidator");

			AppConnectParm appConnect = new AppConnectParm();
			Properties p = appConnect.getProperty();
			InitialContext ctx = new InitialContext(p);
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[Start]
			//itmDBAccessLocal = (ITMDBAccessLocal)ctx.lookup("ibase/ITMDBAccessEJB/local");
			itmDBAccessLocal = new ITMDBAccessEJB();
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[End]


			System.out.println("call valdata");
			System.out.println("wfValData objContext   ["+objContext+"]");
			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}

			switch ( currentFormNo )
				{
				case 2:
				{
						parentList = dom.getElementsByTagName("Detail"+ currentFormNo);
						int parentNodeListLength = parentList.getLength();
						System.out.println("parentNodeListLength["+parentNodeListLength+"]");

						for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
						{
							parentNode = parentList.item(prntCtr);
							childList = parentNode.getChildNodes();
							noOfChilds = childList.getLength();
							for (int ctr = 0; ctr < noOfChilds; ctr++)
							{
								childNode = childList.item(ctr);
								if( childNode.getNodeType() != Node.ELEMENT_NODE )
								{
									continue;
								}

								if ( childNode != null && childNode.getFirstChild() != null )
								{
									columnValue = childNode.getFirstChild().getNodeValue();
								}
								childNodeName = childNode.getNodeName();
								if(childNodeName.equalsIgnoreCase("activity_code"))
								{

									String actCode = genericUtility.getColumnValue( "activity_code" , dom );
									String actType ="";
									System.out.println("actCode::"+actCode);

									String actSQL = " SELECT ACTIVITY_TYPE FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ? ";
									pstmt = connectionObject.prepareStatement(actSQL);
									pstmt.setString(1, actCode);
									rSet =pstmt.executeQuery();
									if( rSet.next() )
									{
										actType = rSet.getString("ACTIVITY_TYPE") == null ?"":rSet.getString("ACTIVITY_TYPE");
									}
									if (rSet!= null)
									{
										rSet.close();
										rSet = null;
									}
									if(pstmt!=null)
									{
										pstmt.close();
										pstmt = null;
									}

									if( actType.equalsIgnoreCase("FW") )
									{
										System.out.println("Inside PreNavigateFinish if:::::::::");
										errString = itmDBAccessLocal.getErrorString( "event_type", "INVACTC", userId );
										break;
									}
									//Added by Gaurav Singh on 10-06-2015 [Start]

									if (childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null && !"null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue()))
									{
										if (columnValue.trim().length() > 2)
										{
											errString = itmDBAccessLocal.getErrorString("activity_code","LENGTH",userId);
											break;
										}
										else
										{
											String eventDate = genericUtility.getColumnValue( "event_date" , dom );
											String salesPers = genericUtility.getColumnValue( "sales_pers" , dom );
											String pDate = genericUtility.getValidDateTimeString( eventDate , getApplDateFormat() , getDBDateFormat());

											ArrayList halfDayActList = halfDayActivityList("HALF_DAY_ACTIVITIES",connectionObject);
											int recCount = 0;
											ArrayList activityList = new ArrayList();
											String activitySql = "SELECT ACTIVITY_CODE FROM SPRS_ACT_TRAN WHERE EVENT_DATE = ? AND SALES_PERS=? ";
											PreparedStatement pstmtActivity = connectionObject.prepareStatement(activitySql);
											pstmtActivity.setTimestamp(1, java.sql.Timestamp.valueOf(pDate));
											pstmtActivity.setString(2, salesPers);
											ResultSet rsActivity = pstmtActivity.executeQuery();
											while ( rsActivity.next() )
											{
												activityList.add(rsActivity.getString("ACTIVITY_CODE"));
											}
											rsActivity.close(); rsActivity = null;
											pstmtActivity.close(); pstmtActivity = null;
											recCount = activityList.size();

											checkSQL = "SELECT SPRS_ACT_TRAN.ACTIVITY_CODE,FIELDACTIVITY.ACTIVITY_TYPE FROM SPRS_ACT_TRAN,FIELDACTIVITY WHERE EVENT_DATE=? AND SALES_PERS=?  AND SPRS_ACT_TRAN.ACTIVITY_CODE = FIELDACTIVITY.ACTIVITY_CODE ";
											PreparedStatement pstmtMeetActivity = connectionObject.prepareStatement(checkSQL);
											pstmtMeetActivity.setTimestamp(1, java.sql.Timestamp.valueOf(pDate));//Shahu - 27/10/12
											pstmtMeetActivity.setString(2, salesPers);
											ResultSet rSetMeetActivity = pstmtMeetActivity.executeQuery();
											while ( rSetMeetActivity.next() )
											{
												String selActivityType = "";
												String activityType = rSetMeetActivity.getString(2);
												activityType = checkNull(activityType).trim().toUpperCase();
												String activityCode = checkNull(rSetMeetActivity.getString(1)).toUpperCase();

												if(activityType.indexOf("LEAVE")!=-1)
												{
													checkSQL = " SELECT ACTIVITY_TYPE FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ? ";
													pstmt = connectionObject.prepareStatement(checkSQL);
													pstmt.setString(1, columnValue);
													rSet =pstmt.executeQuery();
													if( rSet.next() )
													{
														if(!activityType.equalsIgnoreCase(rSet.getString(1)))
														{
															errString = itmDBAccessLocal.getErrorString( "event_type", "EPLANLEAVE", userId );
															break;
														}
													}
													if (rSet!= null)
													{
														rSet.close();
														rSet = null;
													}
													if(pstmt!=null)
													{
														pstmt.close();
														pstmt = null;
													}

												}
												else if (activityType.indexOf("NFW")!=-1)
												{
													checkSQL = " SELECT ACTIVITY_TYPE FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ? ";
													pstmt = connectionObject.prepareStatement(checkSQL);
													pstmt.setString(1, columnValue);
													rSet =pstmt.executeQuery();
													if( rSet.next() )
													{
														if(!activityType.equalsIgnoreCase(rSet.getString(1)))
														{
															errString = itmDBAccessLocal.getErrorString( "event_type", "EPLANNFW", userId );
															break;
														}
													}
													if (rSet!= null)
													{
														rSet.close();
														rSet = null;
													}
													if(pstmt!=null)
													{
														pstmt.close();
														pstmt = null;
													}
												}
												else if (activityType.indexOf("FW")!=-1)
												{
													checkSQL = " SELECT ACTIVITY_TYPE FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ? ";
													pstmt = connectionObject.prepareStatement(checkSQL);
													pstmt.setString(1, columnValue);
													rSet =pstmt.executeQuery();
													if( rSet.next() )
													{
														selActivityType = rSet.getString(1);
													}
													if (rSet!= null)
													{
														rSet.close();
														rSet = null;
													}
													if(pstmt!=null)
													{
														pstmt.close();
														pstmt = null;
													}

													//If one record present of Half day activity
													if(recCount == 1 && halfDayActList.contains(activityCode) && !halfDayActList.contains(columnValue) && !activityType.equalsIgnoreCase(selActivityType) )
													{
														errString = itmDBAccessLocal.getErrorString( "event_type", "EPLANFW", userId );
														break;
													}
													//If one record present of Full day activity and trying to select half day activity
													if(recCount == 1 && !halfDayActList.contains(activityCode) && halfDayActList.contains(columnValue) && !activityType.equalsIgnoreCase(selActivityType) )
													{
														errString = itmDBAccessLocal.getErrorString( "event_type", "ACTNCHG1", userId );
														break;
													}
													//If one record present of Full day activity and type is mismatch means other activity is selected like : LEAVE, NFW etc
													if(recCount == 1 && !halfDayActList.contains(activityCode) && !activityType.equalsIgnoreCase(selActivityType) )
													{
														errString = itmDBAccessLocal.getErrorString( "event_type", "ACTNCHG2", userId );
														break;
													}
													//Two records present(one mktev and one FW) and the selected
													if(recCount > 1 && !halfDayActList.contains(columnValue))//OK
													{
														//errString = itmDBAccessLocal.getErrorString( "event_type", "ACTNCHG3", userId );
														break;
													}
												}
												else
												{
													checkSQL = " SELECT ACTIVITY_TYPE FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ? ";
													pstmt = connectionObject.prepareStatement(checkSQL);
													pstmt.setString(1, columnValue);
													rSet =pstmt.executeQuery();
													if( rSet.next() )
													{
														selActivityType = rSet.getString(1);
													}
													if (rSet!= null)
													{
														rSet.close();
														rSet = null;
													}
													if(pstmt!=null)
													{
														pstmt.close();
														pstmt = null;
													}
													//If one record present of Half day MKTEV and Trying to put Full Day activity
													if(recCount == 1 && halfDayActList.contains(activityCode) && !halfDayActList.contains(columnValue) && !activityType.equalsIgnoreCase(selActivityType) )
													{
														errString = itmDBAccessLocal.getErrorString( "event_type", "ACTNCHG4", userId );
														break;
													}
													//If one record present of Full day MKTEV and trying to put half day MKTEV
													if(recCount == 1 && !halfDayActList.contains(activityCode) && halfDayActList.contains(columnValue) && !activityType.equalsIgnoreCase(selActivityType) )
													{
														errString = itmDBAccessLocal.getErrorString( "event_type", "ACTNCHG5", userId );
														break;
													}
													//If one record present of Full day MKTEV activity and type is mismatch means other activity is selected like : LEAVE, NFW etc
													if(recCount == 1 && !halfDayActList.contains(activityCode) && !activityType.equalsIgnoreCase(selActivityType) )
													{
														errString = itmDBAccessLocal.getErrorString( "event_type", "ACTNCHG6", userId );
														break;
													}
													//Two records present(one mktev and one FW) and the selected
													if(recCount > 1 && !halfDayActList.contains(columnValue))//OK
													{
														errString = itmDBAccessLocal.getErrorString( "event_type", "ACTNCHG7", userId );
														break;
													}
												}
											}
											if (rSetMeetActivity!= null)
											{
												rSetMeetActivity.close();
												rSetMeetActivity = null;
											}
											if(pstmtMeetActivity!=null)
											{
												pstmtMeetActivity.close();
												pstmtMeetActivity = null;
											}

										}//else of if (columnValue.trim().length() > 2)
									}
									//Added by Gaurav Singh on 10-06-2015 [End]
								}
								else if(childNodeName.equalsIgnoreCase("remark"))
								{
									System.out.println("Inside remark");
									if(columnValue != null && columnValue.length() >100)
									{
										errString = itmDBAccessLocal.getErrorString( "remark", "INVALREMRK", userId );
										break;
									}
								}
								else if(childNodeName.equalsIgnoreCase("oth_participant"))
								{
									System.out.println("oth_participant remark");
									if(columnValue != null && columnValue.length() >120)
									{
										errString = itmDBAccessLocal.getErrorString( "oth_participant", "INVALOTHER", userId );
										break;
									}
								}
							}//inner for
						}//outer for
				}
				break;


				//Cases Added by poonam for customer validation for mr and manager.:Start
				case 4 :
				{

					System.out.println("Case 4 : validation ::");
					int selectedFlagCnt = 0;
					int updateFlagCnt = 0;


					parentList = dom.getElementsByTagName("Detail"+ currentFormNo);
					int parentNodeListLength = parentList.getLength();
					System.out.println("parentNodeListLength["+parentNodeListLength+"]");

					for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
					{
						String selectedFlag = "";
						String updateFlag = "";

						Node currDetail = parentList.item(prntCtr);
						if(currDetail.getAttributes().getNamedItem("selected") != null)
						{
							selectedFlag = currDetail.getAttributes().getNamedItem("selected").getNodeValue();
						}
						if(selectedFlag != null && "Y".equalsIgnoreCase(selectedFlag))
						{
							selectedFlagCnt++;
						}

						parentNode = parentList.item(prntCtr);
						childList = parentNode.getChildNodes();
						noOfChilds = childList.getLength();
						System.out.println("noOfChilds["+noOfChilds+"]");
						for (int ctr = 0; ctr < noOfChilds; ctr++)
						{
							childNode = childList.item(ctr);
							if( childNode.getNodeType() != Node.ELEMENT_NODE )
							{
								continue;
							}
							childNodeName = childNode.getNodeName();
							System.out.println("childNodeName =["+childNodeName+"]");
							if(childNodeName.equalsIgnoreCase("attribute"))
							{
								if(childNode.getAttributes().getNamedItem("updateFlag") != null)
								{
									updateFlag = childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
								}
							}
						}
						//if(updateFlag != null && "D".equalsIgnoreCase(updateFlag))
						if(updateFlag != null )
						{
							updateFlagCnt++;
						}
					}

					System.out.println("selectedFlagCnt [case 4] =["+selectedFlagCnt+"], updateFlagCnt=["+updateFlagCnt+"]");
					if(selectedFlagCnt == 0 && updateFlagCnt > 0)
					{
						errString = getErrorString("cust_code","CUSTNOTSEL",userId);
						break;
					}

					if(selectedFlagCnt > 0)
					{
						for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
						{

							parentNode = parentList.item(prntCtr);
							childList = parentNode.getChildNodes();
							noOfChilds = childList.getLength();
							System.out.println("noOfChilds["+noOfChilds+"]");
							for (int ctr = 0; ctr < noOfChilds; ctr++)
							{
								childNode = childList.item(ctr);
								if( childNode.getNodeType() != Node.ELEMENT_NODE )
								{
									continue;
								}

								if ( childNode != null && childNode.getFirstChild() != null )
								{
									columnValue = childNode.getFirstChild().getNodeValue();
								}
								childNodeName = childNode.getNodeName();
								//System.out.println("childNodeName :: ["+childNodeName+ "] columnValue :: ["+columnValue+"]");

								if(childNodeName.equalsIgnoreCase("event_type"))
								{
									if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
											( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
									{
										//errString = itmDBAccessLocal.getErrorString("event_type","NULEVTTP",userId);
										//break;
									}
								}
								else if(childNodeName.equalsIgnoreCase("locality_code"))
								{
									if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
											( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
									{
										errString = itmDBAccessLocal.getErrorString("locality_code","NULLOCCD",userId);
										break;
									}
								}
								else if(childNodeName.equalsIgnoreCase("sales_pers"))
								{
									if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
											( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
									{
										errString = itmDBAccessLocal.getErrorString("sales_pers","NULSLSPRS",userId);
										break;
									}
								}
							}

						}
					}
				}
				break;
				case 5 :
				{

					System.out.println("Case 5: validation ::");
					int selectedFlagCnt = 0;
					int updateFlagCnt = 0;
					//String errString = "";
					String errString1 = "";


					boolean isSelected5 = false;
					String CheckUpdateFlag ="";
					ArrayList otherVisitList = new ArrayList();
					isSelected5 = isEmptyDOM(dom2 , "5");
					String objName = checkNull(getObjNameFromDom(dom2, "objName",5));
					System.out.println("isSelected5 status:- "+isSelected5+":Oneject NAme is:- :"+objName);
					if ("wsfa_mgr_dsr_mob_wiz".equalsIgnoreCase(objName))
					{
						if(isSelected5)
						{
							errString = itmDBAccessLocal.getErrorString("strg_code","NOCUSTSETD",userId);
							break;
						}
					}
					parentList = dom2.getElementsByTagName("Detail"+ currentFormNo);
					int parentNodeListLength = parentList.getLength();
					System.out.println("parentNodeListLength["+parentNodeListLength+"]");
					for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
					{
						String selectedFlag = "";
						String updateFlag = "";

						Node currDetail = parentList.item(prntCtr);
						if(currDetail.getAttributes().getNamedItem("selected") != null)
						{
							selectedFlag = currDetail.getAttributes().getNamedItem("selected").getNodeValue();
						}
						if(selectedFlag != null && "Y".equalsIgnoreCase(selectedFlag))
						{
							selectedFlagCnt++;
						}

						parentNode = parentList.item(prntCtr);
						childList = parentNode.getChildNodes();
						noOfChilds = childList.getLength();
						System.out.println("noOfChilds["+noOfChilds+"]");
						for (int ctr = 0; ctr < noOfChilds; ctr++)
						{
							childNode = childList.item(ctr);
							if( childNode.getNodeType() != Node.ELEMENT_NODE )
							{
								continue;
							}
							childNodeName = childNode.getNodeName();
							System.out.println("childNodeName =["+childNodeName+"]");
							if(childNodeName.equalsIgnoreCase("attribute"))
							{
								if(childNode.getAttributes().getNamedItem("updateFlag") != null)
								{
									updateFlag = childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
								}
							}
							if(("D".equalsIgnoreCase(CheckUpdateFlag)))
							{
								errString = itmDBAccessLocal.getErrorString("strg_code","NOTSELCUST",userId);
								break;
							}
						}
						if ("wsfa_mgr_dsr_mob_wiz".equalsIgnoreCase(objName))
						{
							if(updateFlag != null && "D".equalsIgnoreCase(updateFlag))
							{
								updateFlagCnt++;
							}
						}
						else
						{
							if(updateFlag != null )
							{
								updateFlagCnt++;
							}
						}

					}

					System.out.println("selectedFlagCnt [case 5] =["+selectedFlagCnt+"], updateFlagCnt=["+updateFlagCnt+"]");
					if(selectedFlagCnt == 0 && updateFlagCnt > 0)
					{
						errString = getErrorString("cust_code","CUSTNOTSEL",userId);
						break;
					}
					if ("wsfa_mgr_dsr_mob_wiz".equalsIgnoreCase(objName))
					{
						if(selectedFlagCnt == updateFlagCnt)
						{
							errString = getErrorString("cust_code","CUSTNOTSEL",userId);
							break;
						}
						if(selectedFlagCnt == 0 )
						{
							errString = getErrorString("cust_code","CUSTNOTSEL",userId);
							break;
						}
					}
					if(parentNodeListLength == 0 )
					{
						errString = getErrorString("cust_code","CUSTNOTSEL",userId);
						break;
					}
					if(selectedFlagCnt > 0)
					{
						for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
						{
							String custName = getSelectedRowValue(dom2, objContext, "cust_name",prntCtr);
							parentNode = parentList.item(prntCtr);
							childList = parentNode.getChildNodes();
							noOfChilds = childList.getLength();
							System.out.println("noOfChilds["+noOfChilds+"]");
							for (int ctr = 0; ctr < noOfChilds; ctr++)
							{
								childNode = childList.item(ctr);
								if( childNode.getNodeType() != Node.ELEMENT_NODE )
								{
									continue;
								}

								if ( childNode != null && childNode.getFirstChild() != null )
								{
									columnValue = childNode.getFirstChild().getNodeValue();
								}
								//System.out.println("Inside Validation of case 5 : -"+columnValue);
								childNodeName = childNode.getNodeName();
								String meetSummMgr = checkNull(getSelectedRowVal(dom2, "5", "meet_summ_mgr", prntCtr));
								if(meetSummMgr.length() <= 0)
								{
									//System.out.println("Inside Validation of 5645");
									errString1 = itmDBAccessLocal.getErrorString("meet_summ_mgr","NULMGRRMRK",userId);
									break;
								}
								//System.out.println("meetSummMger1213"+meetSummMgr);
								//System.out.println("childNodeName :: ["+childNodeName+ "] columnValue :: ["+columnValue+"]");
								if(childNodeName.equalsIgnoreCase("attribute"))
								{
									//if(childNode.getAttributes().getNamedItem("updateFlag") != null)
									if(childNode.getAttributes().getNamedItem("updateFlag") != null)
									{
										CheckUpdateFlag = checkNull(childNode.getAttributes().getNamedItem("updateFlag").getNodeValue());
									}
								}
								if(childNodeName.equalsIgnoreCase("event_type"))
								{
									if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
											( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
									{
										//errString = itmDBAccessLocal.getErrorString("event_type","NULEVTTP",userId);
										//break;
									}
								}
								else if(childNodeName.equalsIgnoreCase("locality_code"))
								{
									if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
											( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
									{
										errString = itmDBAccessLocal.getErrorString("locality_code","NULLOCCD",userId);
										//break;
									}
								}
								if ("wsfa_mgr_dsr_mob_wiz".equalsIgnoreCase(objName))
								{
									if(("D".equalsIgnoreCase(CheckUpdateFlag)))
									{
										errString = itmDBAccessLocal.getErrorString("strg_cust","DESELCUSTM",userId);
										//break;
									}
								}

								else if(childNodeName.equalsIgnoreCase("sales_pers"))
								{
									if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
											( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
									{
										errString = itmDBAccessLocal.getErrorString("sales_pers","NULSLSPRS",userId);
										//break;
									}
								}
								else if(childNodeName.equalsIgnoreCase("meet_summ_mgr"))
								{
									String meetSummMger2 = getSelectedRowVal(dom2, "5", "meet_summ_mgr", prntCtr);
									System.out.println("meetSummMger"+meetSummMger2);
									System.out.println("Inside flm Remark case"+columnValue);
									if(checkNull(columnValue).length() <= 0)
									{
										errString = itmDBAccessLocal.getErrorString("meet_summ_mgr","NULMGRRMRK",userId);
										break;
									}

								}
								if(errString.indexOf("<Errors>")!=-1 || errString1.indexOf("<Errors>")!=-1)
								{
									if( errString.length() > 0 )
									{
										String msgDescr = "";
										msgDescr = errString.substring(errString.indexOf("<description>")+("<description>").length(),errString.indexOf("</description>")) + " for customer " + custName ;

										if( custName.length() != 0 && !custName.equalsIgnoreCase("") )
										{
											errString = errString.substring(0, errString.indexOf("<description>")+("<description>").length()) + msgDescr + "" + errString.substring( errString.indexOf("</description>"), errString.length());
										}
										break;
									}
									else if( errString1.length() > 0 )
									{
										errString = errString1;
										break;
									}

								}
							}

						}
					}
				}
				break;
				//Added by vianyak on [29/11/2016] [start]
				case 7 :
				{
					boolean isSelected4 = false;
					boolean isSelected7 = false;
					String CheckUpdateFlag ="";
					ArrayList otherVisitList = new ArrayList();
					isSelected4 = isEmptyDOM(dom2 , "4");
					isSelected7 = isEmptyDOM(dom2 , "7");
					String objName = checkNull(getObjNameFromDom(dom2, "objName",7));
					System.out.println("Dom4 status:- "+isSelected4+": Dom7 stautus : "+isSelected7+":Oneject NAme is:- :"+objName);
					if ("wsfa_dsr_mob_wiz".equalsIgnoreCase(objName))
					{
						if(isSelected4  && isSelected7)
						{
							errString = itmDBAccessLocal.getErrorString("strg_code","NOCUSTSETD",userId);
							break;
						}


						//errString = wfValCustomer( dom, "4", userId );

						int selectedFlagCnt = 0;
						int updateFlagCnt = 0;

						System.out.println("Case 7 : validation ::");
						parentList = dom2.getElementsByTagName("Detail"+ currentFormNo);
						int parentNodeListLength = parentList.getLength();
						System.out.println("parentNodeListLength["+parentNodeListLength+"]");

						for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
						{
							String selectedFlag = "";
							String updateFlag = "";

							Node currDetail = parentList.item(prntCtr);
							if(currDetail.getAttributes().getNamedItem("selected") != null)
							{
								selectedFlag = currDetail.getAttributes().getNamedItem("selected").getNodeValue();
							}
							if(selectedFlag != null && "Y".equalsIgnoreCase(selectedFlag))
							{
								selectedFlagCnt++;
							}

							parentNode = parentList.item(prntCtr);
							childList = parentNode.getChildNodes();
							noOfChilds = childList.getLength();
							System.out.println("noOfChilds["+noOfChilds+"]");
							for (int ctr = 0; ctr < noOfChilds; ctr++)
							{
								childNode = childList.item(ctr);
								if( childNode.getNodeType() != Node.ELEMENT_NODE )
								{
									continue;
								}
								childNodeName = childNode.getNodeName();
								System.out.println("childNodeName =["+childNodeName+"]");
								if(childNodeName.equalsIgnoreCase("attribute"))
								{
									if(childNode.getAttributes().getNamedItem("updateFlag") != null)
									{
										updateFlag = childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
									}
								}
							}
							if(updateFlag != null && "D".equalsIgnoreCase(updateFlag))
							{
								updateFlagCnt++;
							}
						}

						System.out.println("selectedFlagCnt [case 7] =["+selectedFlagCnt+"], updateFlagCnt=["+updateFlagCnt+"]");
						if(selectedFlagCnt == 0 && updateFlagCnt > 0)
						{
							errString = getErrorString("cust_code","CUSTNOTSEL",userId);
							break;
						}
						otherVisitList = getSelCustList(dom2, "3", "other_visit");
						if(selectedFlagCnt == 0 )
						{
						//	String dcrId = checkNull(genericUtility.getColumnValue("dcr_id", dom2, "3"));
							//if(dcrId.length() > 0 )
							{
								//String isOtherVisit = checkNull(genericUtility.getColumnValue("other_visit", dom2, "3"));
								String otherVisitval = "Y";
								if(otherVisitList.contains(otherVisitval))
								{
									errString = itmDBAccessLocal.getErrorString( "strg_code", "CUSTNOTSEL", userId );
									break;
								}
							}
						}
						if(selectedFlagCnt > 0)
						{
							for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
							{

								parentNode = parentList.item(prntCtr);
								childList = parentNode.getChildNodes();
								noOfChilds = childList.getLength();
								System.out.println("noOfChilds["+noOfChilds+"]");
								for (int ctr = 0; ctr < noOfChilds; ctr++)
								{
									childNode = childList.item(ctr);
									if( childNode.getNodeType() != Node.ELEMENT_NODE )
									{
										continue;
									}

									if ( childNode != null && childNode.getFirstChild() != null )
									{
										columnValue = childNode.getFirstChild().getNodeValue();
									}
									childNodeName = childNode.getNodeName();
									//System.out.println("childNodeName :: ["+childNodeName+ "] columnValue :: ["+columnValue+"]");
									System.out.println("childNodeName =["+childNodeName+"]");

									if(childNodeName.equalsIgnoreCase("attribute"))
									{
										//if(childNode.getAttributes().getNamedItem("updateFlag") != null)

										if(childNode.getAttributes().getNamedItem("updateFlag") != null)
										{
											System.out.println("Value of updateFlag flag is in case 4:- "+CheckUpdateFlag);
											CheckUpdateFlag = checkNull(childNode.getAttributes().getNamedItem("updateFlag").getNodeValue());
										}
									}
									System.out.println("Value of update flag is in case 4:- "+CheckUpdateFlag);
									if(("D".equalsIgnoreCase(CheckUpdateFlag)))
									{
										errString = itmDBAccessLocal.getErrorString("strg_code","DESELCUSTM",userId);
										break;
									}
									if(childNodeName.equalsIgnoreCase("event_type"))
									{
										if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
												( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
										{
											//errString = itmDBAccessLocal.getErrorString("event_type","NULEVTTP",userId);
											//break;
										}
									}
									else if(childNodeName.equalsIgnoreCase("locality_code"))
									{
										if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
												( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
										{
											errString = itmDBAccessLocal.getErrorString("locality_code","NULLOCCD",userId);
											break;
										}
									}
									else if(childNodeName.equalsIgnoreCase("sales_pers"))
									{
										if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
												( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
										{
											errString = itmDBAccessLocal.getErrorString("sales_pers","NULSLSPRS",userId);
											break;
										}
									}
									else if(childNodeName.equalsIgnoreCase("remarks"))
									{
										if(columnValue != null && columnValue.length() >120)
										{
											errString = itmDBAccessLocal.getErrorString( "remarks", "INVALRMRK", userId );
											break;
										}
									}
									else if(childNodeName.equalsIgnoreCase("oth_participant"))
									{
										if(columnValue != null && columnValue.length() >120)
										{
											errString = itmDBAccessLocal.getErrorString( "oth_participant", "INVALOTHER", userId );
											break;
										}
									}
									else if(childNodeName.equalsIgnoreCase("strg_code"))
									{
										/*String isOtherVisit = checkNull(genericUtility.getColumnValue("other_visit", dom2, "3"));
										if("Y".equalsIgnoreCase(isOtherVisit) && checkNull(columnValue).length() <= 0)
										{
											errString = itmDBAccessLocal.getErrorString( "strg_code", "NONCWVISEL", userId );
											break;
										}*/
										/*else if("N".equalsIgnoreCase(isOtherVisit) && checkNull(columnValue).length() > 0)
										{
											errString = itmDBAccessLocal.getErrorString( "strg_code", "NOTSELNCW", userId );
											break;
										}*/
									}

								}

							}
						}
					}
				}
				break;
			}
			//Added by vianyak on [29/11/2016] [end]
		}
		catch(Exception e)
		{
			e.printStackTrace();
			copyLogFile();

			errString = "";
			errString = genericUtility.createErrorString( e ) ;
			String messageValue="",message = "";

			if( errString.indexOf("<Errors>")!=-1 )
			{
				if( errString.length() > 0 )
				{
					String msgDescr = errString.substring(errString.indexOf("<description>")+("<description>").length(),errString.indexOf("</description>"));
					messageValue = msgDescr.substring(msgDescr.indexOf("<![CDATA[")+("<![CDATA[").length(),msgDescr.indexOf("]"));
					String messageDescr = errString.substring(errString.indexOf("<message>")+("<message>").length(),errString.indexOf("</message>"));
					message = messageDescr.substring(messageDescr.indexOf("<![CDATA[")+("<![CDATA[").length(),messageDescr.indexOf("]"));

					System.out.println("errorMessage==>"+messageValue);
					StringBuffer valueXmlErrorString = new StringBuffer( "<?xmlversion=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<Errors>\r\n" );
					valueXmlErrorString.append("<error id=\"INVDATA\" type=\"E\" column_name=\"\">");
					valueXmlErrorString.append("<message><![CDATA[").append(message).append("]]></message>\r\n");
					valueXmlErrorString.append("<description><![CDATA[").append(messageValue).append("]]></description>\r\n");
					valueXmlErrorString.append("<type>E</type>\r\n");
					valueXmlErrorString.append("<option></option>\r\n");
					valueXmlErrorString.append("<time></time>\r\n");
					valueXmlErrorString.append("<alarm></alarm>\r\n");
					valueXmlErrorString.append("<source></source>\r\n");
					valueXmlErrorString.append("<trace>Error : NO DATA</trace>\r\n");
					valueXmlErrorString.append("<redirect>1</redirect>\r\n");
					valueXmlErrorString.append("</error>\r\n");
					valueXmlErrorString.append("</Errors>\r\n");
					valueXmlErrorString.append("</Header>\r\n");
					valueXmlErrorString.append( "</Root>\r\n" );
					System.out.println( "\n****valueXmlErrorString :" + valueXmlErrorString.toString() + ":********" );
					errString =valueXmlErrorString.toString();
				}
			}
		}
		finally
		{
			try
			{
				if (rSet != null)
				{
					rSet.close();
					rSet = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if( connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :WsfaDSRMobileWizEJB :defaultDataWiz :==>\n"+e.getMessage());
				errString = "";
				errString = genericUtility.createErrorString( e ) ;
				System.out.println( "errString :Dipak:" +errString + ":" );
				String messageValue="",message = "";

				if( errString.indexOf("<Errors>")!=-1 )
				{
					if( errString.length() > 0 )
					{
						String msgDescr = errString.substring(errString.indexOf("<description>")+("<description>").length(),errString.indexOf("</description>"));
						messageValue = msgDescr.substring(msgDescr.indexOf("<![CDATA[")+("<![CDATA[").length(),msgDescr.indexOf("]"));
						String messageDescr = errString.substring(errString.indexOf("<message>")+("<message>").length(),errString.indexOf("</message>"));
						message = messageDescr.substring(messageDescr.indexOf("<![CDATA[")+("<![CDATA[").length(),messageDescr.indexOf("]"));

						System.out.println("errorMessage==>"+messageValue);
						StringBuffer valueXmlErrorString = new StringBuffer( "<?xmlversion=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<Errors>\r\n" );
						valueXmlErrorString.append("<error id=\"INVDATA\" type=\"E\" column_name=\"\">");
						valueXmlErrorString.append("<message><![CDATA[").append(message).append("]]></message>\r\n");
						valueXmlErrorString.append("<description><![CDATA[").append(messageValue).append("]]></description>\r\n");
						valueXmlErrorString.append("<type>E</type>\r\n");
						valueXmlErrorString.append("<option></option>\r\n");
						valueXmlErrorString.append("<time></time>\r\n");
						valueXmlErrorString.append("<alarm></alarm>\r\n");
						valueXmlErrorString.append("<source></source>\r\n");
						valueXmlErrorString.append("<trace>Error : NO DATA</trace>\r\n");
						valueXmlErrorString.append("<redirect>1</redirect>\r\n");
						valueXmlErrorString.append("</error>\r\n");
						valueXmlErrorString.append("</Errors>\r\n");
						valueXmlErrorString.append("</Header>\r\n");
						valueXmlErrorString.append( "</Root>\r\n" );
						System.out.println( "\n****valueXmlErrorString :" + valueXmlErrorString.toString() + ":********" );
						errString =valueXmlErrorString.toString();

					}
				}
			}
		}
		System.out.println("errString ["+errString+"]");
		return errString;
	}
	//Added By Gaurav Singh on 10/06/15 for Request Id [W15BMIT002].Start
	public ArrayList halfDayActivityList( String propName, Connection conn ) throws Exception
	{
		String propVal = "";
		PreparedStatement pstmtProp = null;
		ResultSet rsProp = null;
		boolean isActivityExist=false;
		ArrayList halfDayActList = new ArrayList();
		try
		{
			String propSql = "SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME = ?";
			pstmtProp = conn.prepareStatement(propSql);
			pstmtProp.setString(1,propName);
			rsProp = pstmtProp.executeQuery();
			if(rsProp.next())
			{
				propVal = (rsProp.getString("PROP_VALUE") == null) ?"":rsProp.getString("PROP_VALUE");
			}
			if(propVal.length() > 0)
			{
				halfDayActList = new ArrayList<String>(Arrays.asList(propVal.split(",")));
			}

		}
		catch(Exception e)
		{
			System.out.println("isActivityCodeExist Catch Exception"+e.getMessage());
			throw e;

		}
		finally
		{
			try
			{
				if(rsProp != null)
				{
					rsProp.close(); rsProp = null;
				}
				if(pstmtProp != null)
				{
					pstmtProp.close(); pstmtProp = null;
				}
			}
			catch(Exception e)
			{
				System.out.println("Finaly Catch Exception"+e.getMessage());
			}
		}
		System.out.println("is Activity code exist =["+isActivityExist+"]");

	    return 	 halfDayActList;

	}

	//to check if input is null or "null"
	public String checkNull(String input)
	{
		if (input == null || "null".equalsIgnoreCase(input))
		{
			input = "";
		}
		return input.trim();
	}
	//Added By Gaurav Singh on 10/06/15 for Request Id [W15BMIT002].END

	private void copyLogFile()
	{
		String errDirName = "SLOG" + randomNumberBetween(0, 99999);
		String serverLogPath = CommonConstants.JBOSSHOME + File.separator + "server" +  File.separator + "default" +  File.separator + "log" ;
		File errDir = new File( serverLogPath + File.separator + errDirName );
		if( errDir != null && ! errDir.exists() )
		{
			errDir.mkdir();
		}
		else
		{
			errDirName = "SLOG" + randomNumberBetween(0, 99999);
			errDir = new File( serverLogPath + File.separator + errDirName );
			errDir.mkdir();
		}

		String[] fileList = {"server.log"};
		for(String fileName : fileList)
		{
			try
			{
				File logFile = new File(serverLogPath + File.separator + fileName);
				if( logFile.exists() )
				{
					FileUtils.copyFileToDirectory( logFile ,  new File(serverLogPath + File.separator + errDirName), true);
				}
			}
			catch (IOException e)
			{
				// TODO Auto-generated catch block
				e.printStackTrace();
			}

		}
	}

	private int randomNumberBetween(int start, int end)
	{
		int randomNumber = 0;
		randomNumber = (int) ( ( end - start  + 1 ) * Math.random() + start ) ;
		return randomNumber;
	}
	//Added by vinayak to check  if a dom empty or not [start] [29/11/2016] [start]
    public boolean isEmptyDOM(Document dom,String currentForm)
    {
        System.out.println("isEmptyDOM is called.........");
        NodeList parentList = null;
        NodeList childList = null;
        Node parentNode = null;
        Node childNode = null;
        int ctr = 0;
        int noOfChilds = 0;
        int parentListLength = 0;
        boolean flg = true;
        try
        {
            parentList = dom.getElementsByTagName("Detail" + currentForm);
            parentListLength = parentList.getLength();
            if( parentListLength == 1 )
            {
                for (int prntCtr = 0; prntCtr < parentList.getLength(); prntCtr++ )
                {
                    parentNode = parentList.item(prntCtr);
                    System.out.println("parentList ........."+parentList.getLength());
                    childList = parentNode.getChildNodes();
                    noOfChilds = childList.getLength();
                    System.out.println("noOfChilds ........."+noOfChilds);

                    for(ctr = 0; ctr < noOfChilds; ctr++)
                    {
                        childNode = childList.item(ctr);
                        if(childNode.getFirstChild() != null)
                        {
                            flg=false;
                            break;
                        }
                    }
                    if(!flg)
                    {
                        break;
                    }
                }
            }
            else if( parentListLength > 1 )
            {
                flg=false;
            }
        }
        catch(Exception e)
        {
                System.err.println("Exception :isEmptyDOM :\n"+e.getMessage());
                e.printStackTrace();
        }
        return flg;
    }

    private String getObjNameFromDom( Document dom, String attribute , int currFormNo) throws ITMException
	{
		String objName = "";
		try
		{
			NodeList detailList = null;
			Node currDetail = null,reqDetail = null;
			int	detailListLength = 0;

			detailList = dom.getElementsByTagName("Detail" + currFormNo);
			detailListLength = detailList.getLength();
			for (int ctr = 0;ctr < detailListLength;ctr++)
			{
				currDetail = detailList.item(ctr);
				objName = currDetail.getAttributes().getNamedItem(attribute).getNodeValue();
				break;

			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		return objName;
	}
  //Added by vinayak to check  if a dom empty or not [] [29/11/2016] [end]
    private ArrayList getSelCustList(Document dom2,String currentFormNo, String visitBy)
	{
		String CheckUpdateFlag = "";
		int selectedFlagCnt = 0;
		int updateFlagCnt = 0;
		int noOfChilds = 0;
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		String errString = "";
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		String childNodeName = "";
		String columnValue = "";
		String checkSQL = "";
		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		PreparedStatement actPstmt = null;
		ResultSet actRs = null;
		ResultSet rSet = null;
		parentList = dom2.getElementsByTagName("Detail"+ currentFormNo);
		int parentNodeListLength = parentList.getLength();
		System.out.println("parentNodeListLength["+parentNodeListLength+"]");
		ArrayList drVisitList = new ArrayList();
		try
		{
			for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
			{
				String selectedFlag = "";
				String updateFlag = "";

				Node currDetail = parentList.item(prntCtr);
				if(currDetail.getAttributes().getNamedItem("selected") != null)
				{
					selectedFlag = currDetail.getAttributes().getNamedItem("selected").getNodeValue();
				}
				if(selectedFlag != null && "Y".equalsIgnoreCase(selectedFlag))
				{
					selectedFlagCnt++;
				}

				parentNode = parentList.item(prntCtr);
				childList = parentNode.getChildNodes();
				noOfChilds = childList.getLength();
				System.out.println("noOfChilds["+noOfChilds+"]");
				for (int ctr = 0; ctr < noOfChilds; ctr++)
				{
					childNode = childList.item(ctr);
					if( childNode.getNodeType() != Node.ELEMENT_NODE )
					{
						continue;
					}
					childNodeName = childNode.getNodeName();
					if ( childNode != null && childNode.getFirstChild() != null )
					{
						columnValue = childNode.getFirstChild().getNodeValue();
					}
					System.out.println("childNodeName =["+childNodeName+"]");
					if(childNodeName.equalsIgnoreCase("attribute"))
					{
						if(childNode.getAttributes().getNamedItem("updateFlag") != null)
						{
							updateFlag = childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
						}
					}
					if(childNodeName.equalsIgnoreCase(checkNull(visitBy)))
					{
						if(( childNode.getFirstChild().getNodeValue() != null))
						{
							drVisitList.add(checkNull(columnValue));
						}
					}
				}

			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		System.out.println("drVisitList in method:- "+drVisitList);
		return drVisitList;
	}
    public String getSelectedRowValue(Document dom,String formNo, String colName, int rowNo) throws ITMException
	{
		NodeList detailList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		Element elementAttr = null;
		String childNodeName = "";
		String columnValue = "";
		int	detailListLength = 0;
		int noOfChilds = 0;

		try
		{
			detailList = dom.getElementsByTagName("Detail"+formNo);
			System.out.println("detailList....."+detailList);
			detailListLength = detailList.getLength();
			parentNode = detailList.item(rowNo);
			System.out.println("parentNode....."+parentNode);
			elementAttr = (Element)parentNode;
			childList = parentNode.getChildNodes();
			System.out.println("childList....."+childList);
			noOfChilds = childList.getLength();

			if ( parentNode != null )
			{
				for (int ctr = 0; ctr < noOfChilds; ctr++)
				{
					childNode = childList.item(ctr);
					childNodeName = childNode.getNodeName();
					if(childNodeName.equals(colName) )
					{
						if(childNode.getFirstChild()!=null )
						{
							columnValue = childNode.getFirstChild().getNodeValue();
							break;
						}
					}
				}
			}

			if(columnValue == null)
				columnValue = "";

		}
		catch( Exception exp )
		{
			exp.printStackTrace();
		}

		return columnValue;
	}
    public String getSelectedRowVal(Document dom,String formNo, String colName, int rowNo) throws ITMException
	{
		NodeList detailList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		Element elementAttr = null;
		String childNodeName = "";
		String columnValue = "";
		int	detailListLength = 0;
		int noOfChilds = 0;

		try
		{
			detailList = dom.getElementsByTagName("Detail"+formNo);
			System.out.println("detailList....."+detailList);
			detailListLength = detailList.getLength();
			parentNode = detailList.item(rowNo);
			System.out.println("parentNode....."+parentNode);
			elementAttr = (Element)parentNode;
			childList = parentNode.getChildNodes();
			System.out.println("childList....."+childList);
			noOfChilds = childList.getLength();

			if ( parentNode != null )
			{
				for (int ctr = 0; ctr < noOfChilds; ctr++)
				{
					childNode = childList.item(ctr);
					childNodeName = childNode.getNodeName();
					if(childNodeName.equals(colName) )
					{
						if(childNode.getFirstChild()!=null )
						{
							columnValue = childNode.getFirstChild().getNodeValue();
							break;
						}
					}
				}
			}

			if(columnValue == null)
				columnValue = "";

		}
		catch( Exception exp )
		{
			exp.printStackTrace();
		}

		return columnValue;
	}
}
