/**
 * Date: 02-NOV-2015
 * Created By : Rahul Barve
 */

package ibase.webitm.ejb.wsfa.transactions;

import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TransIDGenerator;
import ibase.webitm.ejb.*;
import ibase.webitm.utility.GenericUtility;
import ibase.ejb.*;
import ibase.system.config.*;
import ibase.utility.*;

import java.util.*;
import java.util.Date;
import java.sql.*;
import java.io.*;
import java.net.InetAddress;
import java.rmi.RemoteException;

import javax.ejb.*;
import javax.naming.InitialContext;

import java.text.*;

import javax.xml.parsers.*;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.w3c.dom.*;


//@Stateless		commented by Sagar M [22 Nov 2018].
public class SalesBudGWTPos extends ValidatorEJB implements  SalesBudGWTPosRemote,SalesBudGWTPosLocal
{
	E12GenericUtility genericUtility = new E12GenericUtility();
	public String postSave()throws RemoteException,ITMException
	{
		return "";
	}

	public String postSave(String tranId,String editFlag, String xtraParams, Connection conn, String domString) throws RemoteException,ITMException
	{
		System.out.println("XML for processing the dom:::"+domString);
		String errString = "";
		//GenericUtility genericUtility = GenericUtility.getInstance();

		Document dom = genericUtility.parseString(domString);

		try
		{
			String windowName = "w_"+getObjName(dom);
			//String empCodeLog = getSelectedColValue(dom, "1", "sprs_code__plan");
			String empCodeLog = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );
			String prdCodeLog = genericUtility.getColumnValue("locality_code",dom);
			String logFileName = empCodeLog.trim() + "_" + prdCodeLog;
			System.out.println("logFileName :::["+logFileName+"]");
			errString = processExpense( dom, dom,windowName,xtraParams,logFileName ,conn);
		}
		catch(Exception e)
		{
			errString = genericUtility.createErrorString(e);
		}
		return errString;
	}



	private String checkNull(String input)
	{
		if (input==null)
		{
			input="";
		}
		return input;
	}

	private String processExpense(Document dom1, Document dom2, String windowName, String xtraParams, String logFileName,Connection conn) throws RemoteException,ITMException
	{
		int ctr;
		String childNodeName = "";
		String selected="";
		String salesPerson="";
		String salesPersMgr = "";
		String targetAmt = "";
		String achAmt = "";
		String lineNo="";
		String tranId="";
		String itemSer="";
		String prdCode="";
		String remarks="";
		boolean localConn = false;
		String columnValue ="";
		String returnString = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null ;
		String currDate = "";
		String chgTerm ="";
		String errString = "";
		/*Connection connect = null;*/
		int count = 1;
		StringBuffer processXmlString=new StringBuffer();

		try
		{

			/*ConnDriver connDriver = new ConnDriver();
			connect = connDriver.getConnectDB("DriverITM");*/

			System.out.println("calling processExpense.........");

			AppConnectParm appConnect = new AppConnectParm();
			Properties p = appConnect.getProperty();
			InitialContext ctx = new InitialContext(p);
			System.out.println("localConn =["+localConn+"]");

			String userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );
			System.out.println(" userId :: [ "+userId+" ]");
			InetAddress ownIP=InetAddress.getLocalHost();
			chgTerm = ownIP.getHostAddress();
			//Add and Commented By Bhushan on 17-02-16:Start [Date format issues ]
			/*DateFormat dtFormat = new SimpleDateFormat(getApplDateFormat());
			java.util.Date date = Calendar.getInstance().getTime();
			currDate = dtFormat.format( date );*/
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			java.util.Date date = Calendar.getInstance().getTime();
			currDate = sdf.format(date);
			currDate = genericUtility.getValidDateTimeString( currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
			System.out.println("currDate:::::["+currDate+"]");
			//Add and Commented By Bhushan on 17-02-16:End
			//Node detailNode = dom2.getElementsByTagName( "Detail1" ).item(0);

			HashMap objDetailMap = null;

			//Commented and modified by kailash on 20-07-18 as per gulzar sir[Start]
			DBAccessEJB dbAccessLocal = null;
			//dbAccessLocal = (DBAccessLocal)ctx.lookup( "ibase/DBAccessEJB/local" );
			new DBAccessEJB();
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[End]

			processXmlString.append("<DocumentRoot><description>Datawindow Root</description><group0>\r\n");
			processXmlString.append("<description>Group0 description</description><Header0><description>Header0 members</description>\r\n");

			String xmlStringAll = getStringFromDocument(dom2);
			System.out.println("xmlStringAll :: ["+xmlStringAll+"]");
			tranId = generateTranID( xmlStringAll, xtraParams, windowName,conn);
			System.out.println("tranId::::::"+ tranId);

			salesPersMgr = genericUtility.getColumnValue("sales_pers__mgr",dom2);
			prdCode 	 = genericUtility.getColumnValue("prd_code",dom2);
			itemSer 	 = genericUtility.getColumnValue("item_ser",dom2);
			remarks 	 = genericUtility.getColumnValue("remarks",dom2);
			System.out.println("salesPersMgr="+salesPersMgr+", prdCode="+prdCode+", itemSer="+itemSer+", remarks="+remarks);
			String empcode=genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");

			NodeList parentNodeList = dom2.getElementsByTagName("Detail2");
			int parentNodeListLength = parentNodeList.getLength();
			System.out.println("parentNodeListLength @@@ ::::::"+ parentNodeListLength);
			System.out.println("insertSalesBud before::insertSalesBud"+conn);
			//insertIntoSalesBudDet( tranId, lineNo, salesPerson,targetAmt, achAmt);
			insertSalesBud(tranId,currDate,empcode,prdCode,itemSer,remarks,conn);
			System.out.println("insertSalesBud after::insertSalesBud"+conn);
			for(int parent = 0; parent < parentNodeListLength; parent++)
			{

				Node parentNode1 = parentNodeList.item(parent);
				NodeList childNodeList = parentNode1.getChildNodes();
				int childNodeListLength = childNodeList.getLength();
				for(ctr = 0; ctr < childNodeListLength; ctr++)
				{
					Node childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					columnValue = "";
					if( childNode.getFirstChild() != null)
					{
						columnValue = childNode.getFirstChild().getNodeValue().trim();
					}
					System.out.println("childNodeName columnValue node name179 ["+childNodeName+"]");
					System.out.println("childNodeName columnValue 180 node value ["+columnValue+"]");
					if( childNodeName.equalsIgnoreCase("selected") || childNodeName.equalsIgnoreCase("selectbox"))
					{
						selected = columnValue;
						System.out.println("selected @@@::::"+selected);
						if (selected != null && "true".equalsIgnoreCase(selected))
						{

						}
					}
					else if(childNodeName == "sales_pers__for")
					{
						salesPerson = columnValue;
						System.out.println("sales_pers__for::::"+salesPerson);
					}
					else if(childNodeName == "target_amt")
					{
						targetAmt = columnValue;
						if(targetAmt == null || targetAmt.equalsIgnoreCase("") )
						{
							targetAmt = "0";
						}
						System.out.println("targetAmt::::"+targetAmt);
					}

					else if(childNodeName == "ach_amt")
					{
						achAmt = columnValue;
						if(achAmt == null || achAmt.equalsIgnoreCase(""))
						{
							achAmt = "0";
						}
						System.out.println("ach_amt::::"+achAmt);
					}

					else if(childNodeName == "line_no")
					{
						lineNo = columnValue;
						System.out.println("line_no::::"+lineNo);
					}

				}

				if ( selected != null && selected.trim().length() >= 0 && "true".equalsIgnoreCase(selected) )
				{
					insertIntoSalesBudDet( tranId, lineNo, salesPerson,targetAmt, achAmt,conn);
					count++;
				}
				else
				{
					System.out.println("Selected field is not found ...... ");
				}
			}
			processXmlString.append("</Header0></group0></DocumentRoot>");
			String xmlString = processXmlString.toString();
			System.out.println("xmlString for process.......:: "+xmlString);
		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}

				/*if ( conn != null )
				{
					conn.close();
					conn = null;
				}*/
			}

			catch(Exception e)
			{
				e.printStackTrace();
				returnString = genericUtility.createErrorString(e);
			}

		}
		return returnString;
	}


	public void insertSalesBud(  String tranId, String currDate, String empcode,String prdCode, String itemSer, String remarks,Connection conn) throws ITMException
	{
		PreparedStatement pstmtInsertSalesBud = null;
		/*Connection connect = null;
		Boolean connectionCheck=false;*/
		System.out.println("insertSalesBud passed::"+conn);
		try
		{
			/*if(connect==null && connectionCheck==false)
			{*/
			/*ConnDriver connDriver = new ConnDriver();
			connect = connDriver.getConnectDB("DriverITM");
			System.out.println("coonect is null::"+connect);*/
			/*connectionCheck=true;
			}*/

			InetAddress ownIP=InetAddress.getLocalHost();
			String chgTerm = ownIP.getHostAddress();

			System.out.println(" INSERT :: TD_SALES_BUD :: tranID =["+tranId+"]");
			System.out.println(" INSERT :: TD_SALES_BUD :: currDate =["+currDate+"]");
			String insertSalesBudSql = "INSERT INTO TD_SALES_BUD (TRAN_ID, TRAN_DATE, SALES_PERS__MGR, PRD_CODE, ITEM_SER, REMARKS, CHG_DATE, CHG_USER, CHG_TERM) VALUES(?,?,?,?,?,?,?,?,?) ";

			pstmtInsertSalesBud = conn.prepareStatement(insertSalesBudSql);
			pstmtInsertSalesBud.setString(1, tranId);
			//Changed and Commented By Bhushan on 17-02-16
			//pstmtInsertSalesBud.setString(2, currDate);
			pstmtInsertSalesBud.setTimestamp(2, java.sql.Timestamp.valueOf(currDate));
			pstmtInsertSalesBud.setString(3, empcode );
			pstmtInsertSalesBud.setString(4, prdCode);
			pstmtInsertSalesBud.setString(5, itemSer);
			pstmtInsertSalesBud.setString(6, remarks);
			//Changed and Commented By Bhushan on 17-02-16
			//pstmtInsertSalesBud.setString(7, currDate);
			pstmtInsertSalesBud.setTimestamp(7, java.sql.Timestamp.valueOf(currDate));
			pstmtInsertSalesBud.setString(8, empcode);
			pstmtInsertSalesBud.setString(9, chgTerm);

			int insertSalesBudCnt = pstmtInsertSalesBud.executeUpdate();
			System.out.println("insertSalesBudCnt =["+insertSalesBudCnt+"]");

			pstmtInsertSalesBud.clearParameters();
			if (insertSalesBudCnt > 0)
			{
				System.out.println("inserted successfully into SalesBud =["+insertSalesBudCnt+"]");
				//connect.commit();
			}

		}
		catch(Exception exp)
		{
			System.out.println("Exception : insertSalesBud ::==>\n");
			throw new ITMException(exp);
		}
		finally
		{
			try
			{
				if(pstmtInsertSalesBud != null)
				{
					pstmtInsertSalesBud.close();
					pstmtInsertSalesBud = null;
				}
				/*if(connect!=null && connectionCheck==true)
				{

					System.out.println("connect.......close1"+connect);
					connect.close();
					connect = null;

			   }	*/
				/*if(connect != null)
				{
					System.out.println("connect.......close5");
					connect.close();
					connect = null;
				}*/
			}
			catch(Exception e1)
			{

			}
		}
	}
	public void insertIntoSalesBudDet(  String tranId, String lineNo, String salesPerson, String targetAmt, String achAmt,Connection conn) throws ITMException
	{
		PreparedStatement pstmtInsertSalesBudDet = null;
		/*Connection connect = null;*/
		int insertSalesBudDetCnt = 0;
		try
		{/*
			ConnDriver connDriver = new ConnDriver();
			connect = connDriver.getConnectDB("DriverITM");*/
			SimpleDateFormat sdfFormat = new SimpleDateFormat(getApplDateFormat());
			java.util.Date date = Calendar.getInstance().getTime();
			String currDate = sdfFormat.format( date );

			InetAddress ownIP=InetAddress.getLocalHost();
			String chgTerm = ownIP.getHostAddress();

			System.out.println(" INSERT :: TD_SALES_BUD_DET :: tranID =["+tranId+"]");

			String insertSalesBudDetSql = " INSERT INTO TD_SALES_BUD_DET (TRAN_ID, LINE_NO, SALES_PERS__FOR, TARGET_AMT, ACH_AMT) VALUES (?,?,?,?,?)";

			pstmtInsertSalesBudDet = conn.prepareStatement(insertSalesBudDetSql);
			pstmtInsertSalesBudDet.setString(1, tranId);
			pstmtInsertSalesBudDet.setString(2, lineNo);
			pstmtInsertSalesBudDet.setString(3, salesPerson);
			pstmtInsertSalesBudDet.setString(4, checkNull(targetAmt));
			pstmtInsertSalesBudDet.setString(5, checkNull(achAmt));

			insertSalesBudDetCnt = pstmtInsertSalesBudDet.executeUpdate();
			System.out.println("insertSalesBudDetCnt =["+insertSalesBudDetCnt+"]");

			pstmtInsertSalesBudDet.clearParameters();
			if (insertSalesBudDetCnt > 0)
			{
				System.out.println("inserted successfully into TD_SALES_BUD_DET =["+insertSalesBudDetCnt+"]");
				//connect.commit();
			}

		}
		catch(Exception exp)
		{
			System.out.println("Exception : pstmtInsertSalesBudDet ::==>\n");
			throw new ITMException(exp);
		}
		finally
		{
			try
			{
				if(pstmtInsertSalesBudDet != null)
				{
					pstmtInsertSalesBudDet.close();
					pstmtInsertSalesBudDet = null;
				}
				/*if(connect != null)
				{
					System.out.println("connect.......close2");
					connect.close();
					connect = null;
				}*/
			}
			catch(Exception e1)
			{

			}
		}
	}

	private String getObjName(Document dom2)
	{
		Node elementName = null, parentNode = null;
		NodeList elementList = null;
		Element elementAttr = null;
		String objName = "";
		elementList = dom2.getElementsByTagName("Detail1");
		elementName = elementList.item(0);
		if (elementName!=null && ("Detail1").equalsIgnoreCase(elementName.getNodeName()))
		{
			NamedNodeMap etlAttributes = elementName.getAttributes();
			if (etlAttributes!=null)
			{
				if (etlAttributes.getNamedItem("objName")!=null)
				{
					objName = etlAttributes.getNamedItem("objName").getNodeValue();
				}
			}
		}
		return objName;
	}

	private String generateTranID(String xmlString, String xtraParams, String winName,Connection conn )
	{
		String salesBudTranID = "";
		PreparedStatement pStmt = null;
		ResultSet rSet = null;
		String refSer="";
		String tranIdCol="";
		String keyString="";
		/*Connection connect = null;*/

		try
		{
			/*ConnDriver connDriver = new ConnDriver();
			connect = connDriver.getConnectDB("DriverITM");*/

			String transSql = "SELECT REF_SER,TRAN_ID_COL,KEY_STRING FROM TRANSETUP WHERE TRAN_WINDOW  = ? ";

			pStmt = conn.prepareStatement(transSql);
			pStmt.setString(1,winName);
			rSet = pStmt.executeQuery();

			if( rSet.next() )
			{
				refSer = (rSet.getString("REF_SER") == null) ?"":rSet.getString("REF_SER").trim();
				tranIdCol = (rSet.getString("TRAN_ID_COL") == null) ?"":rSet.getString("TRAN_ID_COL").trim();
				keyString = (rSet.getString("KEY_STRING") == null) ?"":rSet.getString("KEY_STRING").trim();
			}
			System.out.println("refSer :: [ "+refSer+" ] tranIdCol :: [ "+tranIdCol+" ] keyString :: [ "+keyString+" ]");

			TransIDGenerator tranIDGenerator = new TransIDGenerator(xmlString,getValueFromXTRA_PARAMS(xtraParams, "loginCode"), CommonConstants.DB_NAME);
			salesBudTranID = tranIDGenerator.generateTranSeqID( refSer,tranIdCol,keyString,conn) ;
			System.out.println("sprsSalesBudTranID......."+salesBudTranID);
		}
		catch( Exception exp )
		{
			System.out.println("Exception In generateTranID......");
			exp.printStackTrace();
		}
		finally
		{
			try
			{
				if( rSet != null )
				{
					rSet.close();
					rSet.close();
				}
				if( pStmt != null )
				{
					pStmt.close();
					pStmt.close();
				}
				/*if(connect != null)
				{
					System.out.println("connect.......close3");
					connect.close();
					connect = null;
				}*/
			}
			catch( Exception expRsc )
			{
				expRsc.printStackTrace();
			}
		}
		return salesBudTranID;
	}

	private String getStringFromDocument(Document doc)
    {
        try
        {
           DOMSource domSource = new DOMSource(doc);
           StringWriter writer = new StringWriter();
           StreamResult result = new StreamResult(writer);
           TransformerFactory tf = TransformerFactory.newInstance();
           Transformer transformer = tf.newTransformer();
           transformer.transform(domSource, result);
           return writer.toString();
        }
        catch(TransformerException ex)
        {
           ex.printStackTrace();
           return null;
        }
    }


}