/*
 * Decompiled with CFR 0.152.
 */
package ibase.bi.ejb.session;

import bsh.Interpreter;
import bsh.InterpreterError;
import ibase.bi.ejb.session.Calculation;
import ibase.bi.ejb.session.Column;
import ibase.bi.ejb.session.Total;
import ibase.bi.utility.BIException;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TotalManager
implements Serializable {
    ArrayList totalList = null;
    int noOfTotals = -1;
    int noOfCrossTabTotal = -1;
    boolean isCrossTabTotal = false;
    ArrayList grElementNameList = null;
    ArrayList grElementTypeList = null;
    ArrayList fxElementNameList = null;
    ArrayList fxElementTypeList = null;
    ArrayList ctElementNameList = null;
    ArrayList ctElementTypeList = null;
    ArrayList vlElementNameList = null;
    ArrayList vlElementTypeList = null;
    ArrayList fxElementList = null;
    ArrayList vlElementList = null;
    private ArrayList crossTabMap;
    String crossTabValue = null;
    transient Interpreter interpreter;
    ArrayList calObjList = null;
    ArrayList titleList = null;
    ArrayList titlePos = null;
    String groupOnList = null;
    int prevCounter = 0;
    ArrayList locVarNamesList = null;
    HashMap locVarNameGroupMap = null;
    HashMap locVarMap = null;
    HashMap recordMap = null;
    HashMap CTCountMap = null;

    public void setGrDetails(ArrayList grElementNameList, ArrayList grElementTypeList) throws Exception {
        try {
            this.grElementNameList = grElementNameList;
            this.grElementTypeList = grElementTypeList;
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    public void setFxDetails(ArrayList fxElementNameList, ArrayList fxElementTypeList) throws Exception {
        try {
            this.fxElementNameList = fxElementNameList;
            this.fxElementTypeList = fxElementTypeList;
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    public void setCtDetails(ArrayList ctElementNameList, ArrayList ctElementTypeList) throws Exception {
        try {
            this.ctElementNameList = ctElementNameList;
            this.ctElementTypeList = ctElementTypeList;
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    public void setVlDetails(ArrayList vlElementNameList, ArrayList vlElementTypeList) throws Exception {
        try {
            this.vlElementNameList = vlElementNameList;
            this.vlElementTypeList = vlElementTypeList;
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    public void setCrossTabMap(ArrayList crossTabMap) throws Exception {
        try {
            this.crossTabMap = crossTabMap;
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    public void setCrossTabValue(String crossTabValue) throws Exception {
        try {
            this.crossTabValue = crossTabValue;
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    public void setCalDetails(ArrayList calObjList) throws Exception {
        try {
            this.calObjList = calObjList;
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    public void initializeTotJEP() throws Exception {
        try {
            this.interpreter = new Interpreter();
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    public void cleanUp() throws Exception {
        try {
            this.interpreter = null;
            this.prevCounter = 0;
            int i = 0;
            while (i < this.totalList.size()) {
                Total totObj = (Total)this.totalList.get(i);
                totObj.getResult().clear();
                totObj.resetRecCnt();
                totObj.setLastCounter(0);
                ++i;
            }
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    public ArrayList includeCrossTabTotalHeadings() throws Exception {
        try {
            Total totObj;
            int ctr = 0;
            while (ctr < this.totalList.size()) {
                totObj = (Total)this.totalList.get(ctr);
                ArrayList groupedList = totObj.getGroupedOnList();
                int grpListSize = groupedList.size();
                if (totObj.isValid() && totObj.isVisible()) {
                    int posOfChangedColumn;
                    int i;
                    int posOfChangedColumn2;
                    if (totObj.getTotalType() == 5 && (posOfChangedColumn2 = this.ctElementNameList.indexOf(totObj.getCTColumn())) != -1) {
                        this.updateCrossTabMap((ArrayList)this.crossTabMap.clone(), posOfChangedColumn2, totObj, true);
                    }
                    if (totObj.getPlacement() == 3) {
                        if (!groupedList.get(0).toString().equals("-1")) {
                            i = 0;
                            while (i < grpListSize) {
                                posOfChangedColumn = this.ctElementNameList.indexOf(groupedList.get(i));
                                if (this.ctElementNameList.indexOf(groupedList.get(i).toString()) != -1) {
                                    this.updateCrossTabMap(this.crossTabMap, posOfChangedColumn, totObj, false);
                                }
                                ++i;
                            }
                        } else {
                            this.updateCrossTabMap(this.crossTabMap, -1, totObj, false);
                        }
                    } else if (!groupedList.get(0).toString().equals("-1")) {
                        i = 0;
                        while (i < grpListSize) {
                            posOfChangedColumn = this.ctElementNameList.indexOf(groupedList.get(i));
                            if (this.ctElementNameList.indexOf(groupedList.get(i).toString()) != -1) {
                                this.updateCrossTabMap(this.crossTabMap, posOfChangedColumn, totObj, false);
                            }
                            ++i;
                        }
                    }
                }
                ++ctr;
            }
            ctr = 0;
            while (ctr < this.totalList.size()) {
                totObj = (Total)this.totalList.get(ctr);
                BaseLogger.log("3", null, null, "totOftot:" + this.isTotOfTot(totObj));
                if (this.isTotOfTot(totObj)) {
                    int i = 0;
                    while (i < this.crossTabMap.size()) {
                        String placedOn = this.crossTabMap.get(i).toString();
                        int index = placedOn.indexOf(totObj.getPositionColumn());
                        if (index != -1) {
                            if (this.isTotalValid(placedOn)) {
                                totObj.setPlacement(3);
                                totObj.setValid(true);
                                totObj.setPosition(i);
                                totObj.setVisibility(this.isTotalVisible(totObj.getPositionColumn()));
                            } else {
                                totObj.setValid(false);
                            }
                        }
                        ++i;
                    }
                }
                ++ctr;
            }
            return this.crossTabMap;
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    private void updateCrossTabMap(ArrayList CTMap, int posOfChangedColumn, Total totObj, boolean doCTCount) throws Exception {
        int nextIndex = 0;
        StringTokenizer st = null;
        int CTCount = 0;
        if (posOfChangedColumn != -1) {
            int ctMapSize = CTMap.size();
            int elemAdded = 0;
            int i = 0;
            while (i < CTMap.size()) {
                elemAdded = 0;
                ArrayList<String> curList = new ArrayList<String>();
                ArrayList<String> nextList = new ArrayList<String>();
                st = new StringTokenizer(CTMap.get(i).toString(), "~");
                while (st.hasMoreTokens()) {
                    curList.add(st.nextToken());
                }
                nextIndex = this.searchIndex(CTMap, i, posOfChangedColumn);
                if (nextIndex < CTMap.size()) {
                    st = new StringTokenizer(CTMap.get(nextIndex).toString(), "~");
                    while (st.hasMoreTokens()) {
                        nextList.add(st.nextToken());
                    }
                    if (curList.size() == nextList.size()) {
                        if (!curList.get(posOfChangedColumn).toString().equals(nextList.get(posOfChangedColumn).toString())) {
                            CTMap.add(nextIndex, String.valueOf(this.appendIdentifer(totObj.getTotalId())) + posOfChangedColumn);
                            elemAdded = 1;
                            ++CTCount;
                        }
                    } else {
                        CTMap.add(nextIndex, String.valueOf(this.appendIdentifer(totObj.getTotalId())) + posOfChangedColumn);
                        elemAdded = 1;
                        ++nextIndex;
                        ++CTCount;
                    }
                } else {
                    int prevColPos;
                    int index = CTMap.size();
                    String prevStr = CTMap.get(index - 1).toString();
                    if (prevStr.indexOf(":") != -1 && (prevColPos = Integer.parseInt(prevStr.substring(prevStr.lastIndexOf(":") + 1))) < posOfChangedColumn) {
                        --index;
                    }
                    CTMap.add(index, String.valueOf(this.appendIdentifer(totObj.getTotalId())) + posOfChangedColumn);
                    elemAdded = 1;
                    ++CTCount;
                }
                i = nextIndex + elemAdded;
            }
        } else {
            CTMap.add(String.valueOf(this.appendIdentifer(totObj.getTotalId())) + posOfChangedColumn);
            ++CTCount;
        }
        if (doCTCount) {
            if (this.CTCountMap == null) {
                this.CTCountMap = new HashMap();
            }
            this.CTCountMap.put(totObj.getTotalId(), new Integer(CTCount));
            BaseLogger.log("3", null, null, "Total Id:" + totObj.getTotalId() + ", CTCount:" + CTCount);
        }
    }

    private int searchIndex(ArrayList CTMap, int curIndex, int posOfChangedColumn) throws Exception {
        int nextIndex = curIndex + 1;
        boolean flag = false;
        int i = nextIndex;
        while (i < CTMap.size()) {
            String nextStr = CTMap.get(i).toString();
            if (nextStr.indexOf(":") == -1 && nextStr.indexOf("~") != -1) {
                int index = i - 1;
                String prevStr = CTMap.get(index).toString();
                if (prevStr.indexOf(":") != -1) {
                    while (prevStr.indexOf(":") != -1) {
                        int prevColPos = Integer.parseInt(prevStr.substring(prevStr.lastIndexOf(":") + 1));
                        if (prevColPos >= posOfChangedColumn) {
                            nextIndex = i;
                        }
                        prevStr = CTMap.get(--index).toString();
                    }
                } else {
                    nextIndex = i;
                }
                flag = true;
                break;
            }
            ++i;
        }
        if (!flag) {
            nextIndex = CTMap.size();
        }
        return nextIndex;
    }

    private String appendIdentifer(String title) throws Exception {
        String append = "";
        int i = 0;
        while (i < this.ctElementNameList.size()) {
            append = String.valueOf(append) + ":";
            ++i;
        }
        return String.valueOf(title) + append;
    }

    private boolean isCtTotals(Total totObj) throws Exception {
        boolean isExist = false;
        ArrayList groupedList = totObj.getGroupedOnList();
        int groupListSize = groupedList.size();
        int i = 0;
        while (i < groupListSize) {
            if (this.ctElementNameList.contains(groupedList.get(i).toString()) || totObj.getPlacement() == 3) {
                isExist = true;
                break;
            }
            ++i;
        }
        return isExist;
    }

    public void evaluateNonAggregateTotals(HashMap recordMap) throws Exception {
        try {
            this.recordMap = recordMap;
            int i = 0;
            while (this.locVarNamesList != null && i < this.locVarNamesList.size()) {
                Double value = this.getCurrValueForLocVar(this.locVarNamesList.get(i).toString());
                this.interpreter.set(this.locVarNamesList.get(i).toString(), (Object)value);
                ++i;
            }
            int totIndex = 0;
            while (totIndex < this.totalList.size()) {
                Total totObj = (Total)this.totalList.get(totIndex);
                if (totObj.isValid() && !totObj.isAggregate() && !this.isTotOfTot(totObj)) {
                    totObj.incrementRecCnt();
                    Set colNames = recordMap.keySet();
                    for (String colName : colNames) {
                        this.addVariableToExpressions(colName, recordMap.get(colName).toString());
                    }
                    this.setCurrentValue(totObj);
                    this.calculateTotals(totObj, -1);
                }
                ++totIndex;
            }
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    public void evaluateAggregateTotals(ArrayList fxValNameList, ArrayList grValNameList, Object rowDataArrayCopy, HashMap recordMap) throws Exception {
        try {
            Object[][] rowDataArray = (Object[][])rowDataArrayCopy;
            int ctr = 0;
            while (ctr < this.totalList.size()) {
                Total totObj = (Total)this.totalList.get(ctr);
                if (totObj.isValid() && !this.isTotOfTot(totObj)) {
                    int i = 0;
                    while (this.locVarNamesList != null && i < this.locVarNamesList.size()) {
                        Double value = this.getCurrValueForLocVar(this.locVarNamesList.get(i).toString());
                        this.interpreter.set(this.locVarNamesList.get(i).toString(), (Object)value);
                        ++i;
                    }
                    i = 0;
                    while (i < this.fxElementNameList.size()) {
                        String fxValue = fxValNameList.get(i) == null ? "" : fxValNameList.get(i).toString();
                        this.addVariableToExpressions((String)this.fxElementNameList.get(i), fxValue);
                        ++i;
                    }
                    i = 0;
                    while (i < this.grElementNameList.size()) {
                        this.addVariableToExpressions((String)this.grElementNameList.get(i), grValNameList.get(i).toString());
                        ++i;
                    }
                    double value = 0.0;
                    if (rowDataArray != null) {
                        ArrayList grpdOnList = totObj.getGroupedOnList();
                        boolean isOnChangeCTTotal = false;
                        if (totObj.getPlacement() == 3 && grpdOnList.size() > 0 && !((String)grpdOnList.get(0)).equalsIgnoreCase("-1")) {
                            isOnChangeCTTotal = true;
                        }
                        if (recordMap != null) {
                            if (isOnChangeCTTotal) {
                                totObj.incrementRecCnt();
                                Set colNames = recordMap.keySet();
                                for (String colName : colNames) {
                                    this.addVariableToExpressions(colName, recordMap.get(colName).toString());
                                }
                                this.setCurrentValue(totObj);
                                this.calculateTotals(totObj, -1);
                            }
                        } else if (totObj.getPlacement() == 2 || totObj.getPlacement() == 3) {
                            if (!isOnChangeCTTotal) {
                                totObj.incrementRecCnt();
                                int i2 = 0;
                                while (i2 < rowDataArray.length) {
                                    int j = 0;
                                    while (j < rowDataArray[i2].length) {
                                        if (!(rowDataArray[i2][j] == null || rowDataArray[i2][j].toString().equalsIgnoreCase("Infinity") || rowDataArray[i2][j].toString().equalsIgnoreCase("-Infinity") || rowDataArray[i2][j].toString().equalsIgnoreCase("NaN") || rowDataArray[i2][j].toString().equalsIgnoreCase("-NaN"))) {
                                            value += ((Double)rowDataArray[i2][j]).doubleValue();
                                        }
                                        ++j;
                                    }
                                    String colName = (String)this.vlElementNameList.get(i2);
                                    this.addVariableToExpressions(colName, new Double(value).toString());
                                    value = 0.0;
                                    ++i2;
                                }
                                this.setCurrentValue(totObj);
                                this.calculateTotals(totObj, 0);
                            }
                        } else if (totObj.getPlacement() == 4 && !isOnChangeCTTotal) {
                            totObj.incrementRecCnt();
                            int colCtr = 0;
                            while (colCtr < this.crossTabMap.size()) {
                                if (this.crossTabMap.get(colCtr).toString().indexOf("T$") == -1) {
                                    int rowCtr = 0;
                                    while (rowCtr < this.vlElementNameList.size()) {
                                        if (rowDataArray[rowCtr][colCtr] != null) {
                                            this.addVariableToExpressions((String)this.vlElementNameList.get(rowCtr), rowDataArray[rowCtr][colCtr].toString());
                                        } else {
                                            this.addVariableToExpressions((String)this.vlElementNameList.get(rowCtr), "0.00");
                                        }
                                        ++rowCtr;
                                    }
                                    this.setCurrentValue(totObj);
                                    this.calculateTotals(totObj, colCtr);
                                }
                                ++colCtr;
                            }
                        }
                    } else if (recordMap != null) {
                        totObj.incrementRecCnt();
                        Set colNames = recordMap.keySet();
                        for (String colName : colNames) {
                            this.addVariableToExpressions(colName, recordMap.get(colName).toString());
                        }
                        this.setCurrentValue(totObj);
                        this.calculateTotals(totObj, -1);
                    }
                }
                this.addVariableToExpressions(totObj.getTotalId(), "" + totObj.getCurValue());
                ++ctr;
            }
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    private boolean isTotOfTot(Total totObj) throws Exception {
        boolean isTotOfTot = false;
        if (totObj.getPlacementType() == 'R') {
            String expression = totObj.getExpression();
            int i = 0;
            while (i < this.totalList.size()) {
                String totId = ((Total)this.totalList.get(i)).getTotalId();
                if (this.isTotalInExpression(totId, expression)) {
                    isTotOfTot = true;
                    break;
                }
                ++i;
            }
        }
        return isTotOfTot;
    }

    private void calTotOfTot(Total totObj, int counter) throws Exception {
        int size;
        boolean isExist = false;
        if (this.crossTabMap != null && this.crossTabMap.size() > 0) {
            int i = 0;
            while (i < this.crossTabMap.size()) {
                String str = this.crossTabMap.get(i).toString();
                if (str.indexOf(totObj.getPositionColumn()) != -1) {
                    isExist = true;
                    break;
                }
                ++i;
            }
        }
        if (this.crossTabMap != null && isExist && this.crossTabMap.size() > 0) {
            size = this.crossTabMap.size();
            int lastcount = totObj.getLastCounter();
            boolean isEvaluate = false;
            String expression = totObj.getExpression();
            int finalCounter = lastcount;
            int col = 0;
            while (col < size) {
                int row = lastcount;
                while (row <= counter) {
                    int i = 0;
                    while (i < this.totalList.size()) {
                        Total totalObj = (Total)this.totalList.get(i);
                        if (totObj.getTotalId() != totalObj.getTotalId() && totalObj.isValid() && this.isTotalInExpression(totalObj.getTotalId(), expression)) {
                            if (row > totalObj.getResult().size() - 1 && !this.isCtTotals(totalObj)) break;
                            if (row < totalObj.getResult().size()) {
                                String data = ((ArrayList)totalObj.getResult().get(row)).get(col).toString();
                                if (data.length() > 0) {
                                    this.addVariableToExpressions(totalObj.getTotalId(), data);
                                    isEvaluate = true;
                                } else {
                                    isEvaluate = false;
                                }
                                finalCounter = row;
                            }
                        }
                        ++i;
                    }
                    if (isEvaluate) {
                        this.setCurrentValue(totObj);
                        this.calculateTotals(totObj, col);
                        isEvaluate = false;
                    }
                    ++row;
                }
                ++col;
            }
            totObj.setLastCounter(finalCounter);
        } else if (this.crossTabMap != null && this.crossTabMap.size() > 0) {
            size = this.crossTabMap.size();
            boolean isEvaluate = false;
            boolean checkValid = false;
            String expression = totObj.getExpression();
            int col = 0;
            while (col < size) {
                int i = 0;
                while (i < this.totalList.size()) {
                    Total totalObj = (Total)this.totalList.get(i);
                    if (totObj.getTotalId() != totalObj.getTotalId() && totalObj.isValid()) {
                        if (this.isTotalInExpression(totalObj.getTotalId(), expression)) {
                            String data;
                            checkValid = true;
                            totObj.setValid(true);
                            ArrayList rstList = totalObj.getResult();
                            int rstSize = rstList.size();
                            if (((ArrayList)rstList.get(rstList.size() - 1)).size() > 0) {
                                boolean isData = false;
                                int j = 0;
                                while (j < ((ArrayList)rstList.get(rstList.size() - 1)).size()) {
                                    if (((ArrayList)rstList.get(rstList.size() - 1)).get(j).toString().trim().length() > 0) {
                                        isData = true;
                                        break;
                                    }
                                    ++j;
                                }
                                rstSize = isData ? --rstSize : (rstSize -= 2);
                            }
                            if ((data = ((ArrayList)rstList.get(rstSize)).get(col).toString()).length() > 0) {
                                this.addVariableToExpressions(totalObj.getTotalId(), data);
                                isEvaluate = true;
                            } else {
                                isEvaluate = false;
                            }
                        } else if (!checkValid) {
                            totObj.setValid(false);
                        }
                    }
                    ++i;
                }
                if (isEvaluate && totObj.isValid()) {
                    this.setCurrentValue(totObj);
                    this.calculateTotals(totObj, col);
                    isEvaluate = false;
                }
                ++col;
            }
        } else {
            boolean isEvaluate = false;
            String expression = totObj.getExpression();
            boolean checkValid = false;
            int i = 0;
            while (i < this.totalList.size()) {
                Total totalObj = (Total)this.totalList.get(i);
                if (totObj.getTotalId() != totalObj.getTotalId()) {
                    if (this.isTotalInExpression(totalObj.getTotalId(), expression)) {
                        totObj.setValid(true);
                        checkValid = true;
                        ArrayList resultList = totalObj.getResult();
                        int size2 = resultList.size();
                        if (size2 > 0) {
                            size2 = ((ArrayList)resultList.get(size2 - 1)).size() == 1 & ((ArrayList)resultList.get(size2 - 1)).get(0).toString().length() > 0 ? --size2 : (size2 -= 2);
                            String data = ((ArrayList)resultList.get(size2)).get(0).toString();
                            if (data.length() > 0) {
                                this.addVariableToExpressions(totalObj.getTotalId(), data);
                                isEvaluate = true;
                            } else {
                                isEvaluate = false;
                            }
                        }
                    } else if (!checkValid) {
                        totObj.setValid(false);
                    }
                }
                ++i;
            }
            if (isEvaluate && totObj.isValid()) {
                this.setCurrentValue(totObj);
                this.calculateTotals(totObj, -1);
                isEvaluate = false;
            }
        }
        this.addVariableToExpressions(totObj.getTotalId(), "" + totObj.getCurValue());
    }

    private boolean isTotalInExpression(String operand, String expression) throws Exception {
        boolean isExist = false;
        int c = -1;
        c = expression.indexOf(operand);
        if (c != -1) {
            String tempExpr = expression.substring(c + operand.length());
            isExist = tempExpr.length() > 0 ? !Character.isDigit(tempExpr.charAt(0)) : true;
        }
        return isExist;
    }

    public ArrayList getTotals(String onChangeCol, int counter) throws Exception {
        ArrayList finalTotals = new ArrayList();
        ArrayList existingPosList = new ArrayList();
        ArrayList titleList = new ArrayList();
        ArrayList titlePos = new ArrayList();
        try {
            int i = 0;
            while (i < this.totalList.size()) {
                Total totObj = (Total)this.totalList.get(i);
                if (totObj.isValid() && totObj.isVisible() && !this.isTotOfTot(totObj)) {
                    if (!this.isCtTotals(totObj)) {
                        if (onChangeCol != null) {
                            if (totObj.getGroupedOnList().indexOf(onChangeCol) != -1) {
                                this.collectTotals(totObj, finalTotals, existingPosList, titleList, titlePos);
                            }
                        } else {
                            this.collectTotals(totObj, finalTotals, existingPosList, titleList, titlePos);
                        }
                    }
                } else if (totObj.isValid() && totObj.isVisible() && this.isTotOfTot(totObj)) {
                    if (onChangeCol != null) {
                        if (totObj.getGroupedOnList().indexOf(onChangeCol) != -1) {
                            this.calTotOfTot(totObj, counter);
                            this.collectTotals(totObj, finalTotals, existingPosList, titleList, titlePos);
                        }
                    } else {
                        this.calTotOfTot(totObj, counter);
                        this.collectTotals(totObj, finalTotals, existingPosList, titleList, titlePos);
                    }
                }
                ++i;
            }
            this.titleList = titleList;
            this.titlePos = titlePos;
            return finalTotals;
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    public ArrayList getCtTotals() throws Exception {
        try {
            ArrayList<String> finalTotals = new ArrayList<String>();
            int i = 0;
            while (i < this.crossTabMap.size()) {
                finalTotals.add("");
                ++i;
            }
            i = 0;
            while (i < this.totalList.size()) {
                Total totObj = (Total)this.totalList.get(i);
                if (totObj.isValid() && totObj.isVisible()) {
                    if (this.isCtTotals(totObj) && !this.isTotOfTot(totObj)) {
                        String totId = totObj.getTotalId();
                        ArrayList mainList = totObj.getResult();
                        ArrayList currSubList = (ArrayList)mainList.get(mainList.size() - 1);
                        int crrSubList_size = currSubList.size();
                        double curValue = 0.0;
                        int noOfElements = 0;
                        int j = 0;
                        while (j < crrSubList_size) {
                            if (this.crossTabMap.get(j).toString().indexOf(":") != -1 && this.crossTabMap.get(j).toString().indexOf(totId) != -1) {
                                curValue = totObj.getTotalType() == 1 ? curValue / (double)noOfElements : curValue;
                                ArrayList dataList = new ArrayList();
                                dataList.add(new Double(curValue).toString());
                                dataList = this.applyFormat(dataList, totObj);
                                finalTotals.set(j, (String)dataList.get(0));
                                currSubList.set(j, new Double(curValue).toString());
                                curValue = 0.0;
                                noOfElements = 0;
                            } else if (this.crossTabMap.get(j).toString().indexOf(":") == -1) {
                                String ctValue = currSubList.get(j).toString();
                                if (ctValue.length() == 0 || ctValue.equals("Infinity") || ctValue.equals("-Infinity") || ctValue.equals("NaN") || ctValue.equals("-NaN")) {
                                    ctValue = "0.0d";
                                }
                                if (ctValue.length() > 0) {
                                    curValue += new Double(ctValue).doubleValue();
                                    currSubList.set(j, new String(""));
                                    ++noOfElements;
                                }
                            }
                            ++j;
                        }
                        this.resetResult(totObj);
                    } else if (this.isCtTotals(totObj)) {
                        this.isTotOfTot(totObj);
                    }
                }
                ++i;
            }
            return finalTotals;
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    private void setCurrentValue(Total totObj) throws Exception {
        if (totObj.getTotalType() == 5) {
            totObj.setCurValue(((Integer)this.CTCountMap.get(totObj.getTotalId())).intValue());
            return;
        }
        boolean isEvelSucceeded = false;
        String beanErrorString = null;
        Object resObject = null;
        try {
            resObject = this.interpreter.eval(totObj.getExpression());
            isEvelSucceeded = true;
        }
        catch (InterpreterError inte) {
            BaseLogger.log("0", null, null, " BISaxTrasformer--Interpreter Bean Exception: ==>\n" + (Object)((Object)inte));
            inte.printStackTrace();
            beanErrorString = inte.getMessage();
        }
        if (isEvelSucceeded) {
            if (resObject != null) {
                String resStr = resObject.toString();
                if (resStr.length() > 0) {
                    if (totObj.getTotalType() != 4) {
                        try {
                            totObj.setCurValue((Double)resObject);
                        }
                        catch (Exception e) {
                            totObj.setCurValue(0.0);
                        }
                    } else {
                        totObj.setCurValue(1.0);
                    }
                }
            } else {
                totObj.setCurValue(0.0);
            }
        } else {
            resObject = beanErrorString;
        }
    }

    private void calculateTotals(Total totObj, int position) throws Exception {
        double newValue = totObj.getCurValue();
        double dbValue = 0.0;
        DecimalFormat df = new DecimalFormat();
        if (totObj.isValid()) {
            int posOfValue = -1;
            posOfValue = position == -1 ? (this.crossTabMap != null && this.crossTabMap.size() > 0 ? this.crossTabMap.indexOf(this.crossTabValue) : 0) : position;
            ArrayList mainList = totObj.getResult();
            ArrayList<String> currSubList = null;
            int mainList_size = mainList.size();
            if (mainList_size == 0) {
                if (this.crossTabMap != null && this.crossTabMap.size() > 0) {
                    currSubList = new ArrayList<String>(this.crossTabMap.size());
                    int i = 0;
                    while (i < this.crossTabMap.size()) {
                        currSubList.add(new String(""));
                        ++i;
                    }
                } else {
                    currSubList = new ArrayList<String>();
                    currSubList.add(new String(""));
                }
                mainList.add(currSubList);
            } else {
                currSubList = (ArrayList<String>)mainList.get(mainList.size() - 1);
            }
            if (currSubList.get(posOfValue).toString().length() == 0 || currSubList.get(posOfValue).toString().equals("Infinity") || currSubList.get(posOfValue).toString().equals("-Infinity") || currSubList.get(posOfValue).toString().equals("NaN") || currSubList.get(posOfValue).toString().equals("-NaN")) {
                currSubList.set(posOfValue, new String("0.0d"));
            }
            switch (totObj.getTotalType()) {
                case 0: 
                case 4: {
                    currSubList.set(posOfValue, new Double(df.parse(currSubList.get(posOfValue).toString()).doubleValue() + newValue).toString());
                    break;
                }
                case 1: {
                    currSubList.set(posOfValue, new Double(df.parse(currSubList.get(posOfValue).toString()).doubleValue() + newValue).toString());
                    break;
                }
                case 2: {
                    double tempDBValue;
                    dbValue = mainList_size > 0 ? ((tempDBValue = df.parse(((ArrayList)totObj.getResult().get(0)).get(posOfValue).toString()).doubleValue()) < newValue ? tempDBValue : newValue) : newValue;
                    currSubList.set(posOfValue, new Double(dbValue).toString());
                    break;
                }
                case 3: {
                    double tempDBValue;
                    dbValue = mainList_size > 0 ? ((tempDBValue = df.parse(((ArrayList)totObj.getResult().get(0)).get(posOfValue).toString()).doubleValue()) > newValue ? tempDBValue : newValue) : newValue;
                    currSubList.set(posOfValue, new Double(dbValue).toString());
                    break;
                }
                case 5: {
                    dbValue = newValue;
                    currSubList.set(posOfValue, new Double(dbValue).toString());
                }
                default: {
                    break;
                }
            }
        }
    }

    private void addVariableToExpressions(String tagName, String data) throws Exception {
        boolean isString = false;
        int index = -1;
        if (this.grElementNameList.indexOf(tagName) != -1) {
            index = this.grElementNameList.indexOf(tagName);
            if (((String)this.grElementTypeList.get(index)).indexOf("NUMBER") == -1) {
                isString = true;
            }
        } else if (this.fxElementNameList.indexOf(tagName) != -1) {
            index = this.fxElementNameList.indexOf(tagName);
            if (((String)this.fxElementTypeList.get(index)).indexOf("NUMBER") == -1) {
                isString = true;
            }
        } else if (this.ctElementNameList.indexOf(tagName) != -1) {
            index = this.ctElementNameList.indexOf(tagName);
            if (((String)this.ctElementTypeList.get(index)).indexOf("NUMBER") == -1) {
                isString = true;
            }
        } else if (this.vlElementNameList.indexOf(tagName) != -1) {
            index = this.vlElementNameList.indexOf(tagName);
            if (((String)this.vlElementTypeList.get(index)).indexOf("NUMBER") == -1) {
                isString = true;
            }
        } else {
            isString = false;
        }
        if (isString) {
            data = data.length() <= 0 ? "" : data;
            this.interpreter.set(tagName, (Object)data);
        } else {
            data = data.length() <= 0 || data.equalsIgnoreCase("Infinity") || data.equalsIgnoreCase("-Infinity") || data.equalsIgnoreCase("NaN") ? "0" : data;
            this.interpreter.set(tagName, (Object)Double.valueOf(data));
        }
    }

    public ArrayList getTitleList() throws Exception {
        try {
            return this.titleList;
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    public ArrayList getTitlePos() throws Exception {
        try {
            return this.titlePos;
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    private int findTotalPosition(Total totObj) throws Exception {
        int size = totObj.getGroupedOnList().size();
        this.groupOnList = (String)totObj.getGroupedOnList().get(size - 1);
        int pos = 0;
        if (this.groupOnList != null && !this.groupOnList.equals("-1")) {
            int i = 0;
            while (i < this.fxElementNameList.size()) {
                if (this.groupOnList.equals((String)this.fxElementNameList.get(i))) {
                    pos = i;
                }
                ++i;
            }
        }
        return pos;
    }

    private void collectTotals(Total totObj, ArrayList finalTotals, ArrayList existingPosList, ArrayList titleList, ArrayList titlePos) throws Exception {
        if (totObj.isValid()) {
            boolean isExist = false;
            ArrayList absPosList = this.calAbsPosList(totObj);
            int i = 0;
            while (i < absPosList.size()) {
                if (existingPosList.contains(absPosList.get(i))) {
                    isExist = true;
                    break;
                }
                ++i;
            }
            if (isExist) {
                int index = this.findPos(finalTotals, totObj);
                HashMap tmpMap = null;
                if (index == -1) {
                    tmpMap = new HashMap();
                    if (totObj.getResult().size() > 0) {
                        tmpMap.put(absPosList, new ArrayList(this.applyFormat(this.aggResult(totObj, (ArrayList)totObj.getResult().get(totObj.getResult().size() - 1)), totObj)));
                        finalTotals.add(tmpMap);
                        this.resetResult(totObj);
                    }
                    titleList.add(totObj.getTitle());
                    titlePos.add(Integer.toString(this.findTotalPosition(totObj)));
                } else {
                    tmpMap = (HashMap)finalTotals.get(index);
                    if (totObj.getResult().size() > 0) {
                        tmpMap.put(absPosList, new ArrayList(this.applyFormat(this.aggResult(totObj, (ArrayList)totObj.getResult().get(totObj.getResult().size() - 1)), totObj)));
                    }
                    titleList.set(index, totObj.getTitle());
                    this.resetResult(totObj);
                }
            } else {
                existingPosList.add(new Integer(absPosList.get(0).toString()));
                HashMap tmpMap = null;
                if (finalTotals.size() > 0) {
                    tmpMap = (HashMap)finalTotals.get(0);
                    if (totObj.getResult().size() > 0) {
                        tmpMap.put(absPosList, new ArrayList(this.applyFormat(this.aggResult(totObj, (ArrayList)totObj.getResult().get(totObj.getResult().size() - 1)), totObj)));
                        this.resetResult(totObj);
                    }
                    titleList.set(0, totObj.getTitle());
                    titlePos.set(0, Integer.toString(this.findTotalPosition(totObj)));
                } else {
                    tmpMap = new HashMap();
                    if (totObj.getResult().size() > 0) {
                        tmpMap.put(absPosList, new ArrayList(this.applyFormat(this.aggResult(totObj, (ArrayList)totObj.getResult().get(totObj.getResult().size() - 1)), totObj)));
                        finalTotals.add(tmpMap);
                        this.resetResult(totObj);
                    }
                    titleList.add(totObj.getTitle());
                    titlePos.add(Integer.toString(this.findTotalPosition(totObj)));
                }
            }
        }
    }

    private ArrayList aggResult(Total totObj, ArrayList resultList) throws Exception {
        ArrayList rsLst = new ArrayList();
        double result = 0.0;
        int recordCount = totObj.getRecCnt();
        if (totObj.getPlacement() == 2) {
            int i = 0;
            while (i < resultList.size()) {
                String str = resultList.get(i).toString();
                if (!(str.length() <= 0 || str.equalsIgnoreCase("Infinity") || str.equalsIgnoreCase("-Infinity") || str.equalsIgnoreCase("NaN") || str.equalsIgnoreCase("-NaN"))) {
                    result += new Double(str).doubleValue();
                }
                ++i;
            }
            if (totObj.getTotalType() == 1) {
                result /= (double)recordCount;
            }
            rsLst.add(new Double(result));
            totObj.resetRecCnt();
        } else {
            rsLst = (ArrayList)resultList.clone();
            if (totObj.getTotalType() == 1) {
                int i = 0;
                while (i < rsLst.size()) {
                    Double dres = new Double(Double.parseDouble(rsLst.get(i).toString()) / (double)recordCount);
                    rsLst.set(i, dres);
                    ++i;
                }
            }
            totObj.resetRecCnt();
        }
        return rsLst;
    }

    private ArrayList calAbsPosList(Total totObj) throws Exception {
        String str;
        Calculation calObj;
        Column colObj;
        int absPos = 0;
        int noOfNonVisFxCol_LtRelPos = 0;
        int noOfNonVisFxCol_GtRelPos = 0;
        int noOfNonVisVlCol_LtRelPos = 0;
        int noOfNonVisVlCol_GtRelPos = 0;
        int ctTotCnt = 0;
        int fxElemSize = this.fxElementList.size();
        int vlElemSize = this.vlElementList.size();
        int relPos = totObj.getPosition();
        ArrayList<Integer> absPosList = new ArrayList<Integer>();
        int i = 0;
        while (i < fxElemSize) {
            if (this.fxElementList.get(i).getClass().toString().indexOf("Column") != -1) {
                colObj = (Column)this.fxElementList.get(i);
                if (!colObj.isVisible() && colObj.getPosition() <= relPos) {
                    ++noOfNonVisFxCol_LtRelPos;
                } else if (!colObj.isVisible() && colObj.getPosition() > relPos) {
                    ++noOfNonVisFxCol_GtRelPos;
                }
            } else {
                calObj = (Calculation)this.fxElementList.get(i);
                if (!calObj.isVisible() && calObj.getPosition() <= relPos) {
                    ++noOfNonVisFxCol_LtRelPos;
                } else if (!calObj.isVisible() && calObj.getPosition() > relPos) {
                    ++noOfNonVisFxCol_GtRelPos;
                }
            }
            ++i;
        }
        i = 0;
        while (i < vlElemSize) {
            if (this.vlElementList.get(i).getClass().toString().indexOf("Column") != -1) {
                colObj = (Column)this.vlElementList.get(i);
                if (!colObj.isVisible() && colObj.getPosition() <= relPos) {
                    ++noOfNonVisVlCol_LtRelPos;
                } else if (!colObj.isVisible() && colObj.getPosition() > relPos) {
                    ++noOfNonVisVlCol_GtRelPos;
                }
            } else {
                calObj = (Calculation)this.vlElementList.get(i);
                if (!calObj.isVisible() && calObj.getPosition() <= relPos) {
                    ++noOfNonVisVlCol_LtRelPos;
                } else if (!calObj.isVisible() && calObj.getPosition() > relPos) {
                    ++noOfNonVisVlCol_GtRelPos;
                }
            }
            ++i;
        }
        if (!this.isTotOfTot(totObj)) {
            if (totObj.getPlacement() == 2) {
                absPos = relPos - noOfNonVisFxCol_LtRelPos;
                absPosList.add(new Integer(absPos));
            } else if (totObj.getPlacement() != 3 && totObj.getPlacement() == 4) {
                absPos = fxElemSize + relPos - (noOfNonVisFxCol_LtRelPos + noOfNonVisFxCol_GtRelPos + noOfNonVisVlCol_LtRelPos);
                absPosList.add(new Integer(absPos));
                i = 1;
                while (i < this.crossTabMap.size()) {
                    str = this.crossTabMap.get(i).toString();
                    if (str.indexOf(":") == -1) {
                        absPos = absPos + vlElemSize + ctTotCnt - (noOfNonVisVlCol_LtRelPos + noOfNonVisVlCol_GtRelPos);
                        absPosList.add(new Integer(absPos));
                        ctTotCnt = 0;
                    } else {
                        ++ctTotCnt;
                    }
                    ++i;
                }
            }
        } else if (totObj.getPlacement() == 2) {
            absPos = relPos - noOfNonVisFxCol_LtRelPos;
            absPosList.add(new Integer(absPos));
        } else if (totObj.getPlacement() == 3) {
            i = 1;
            while (i < this.crossTabMap.size()) {
                str = this.crossTabMap.get(i).toString();
                int index = str.indexOf(totObj.getPositionColumn());
                if (index != -1) {
                    relPos = i;
                    absPos = fxElemSize - (noOfNonVisFxCol_LtRelPos + noOfNonVisFxCol_GtRelPos) + (relPos - ctTotCnt) * (vlElemSize - (noOfNonVisVlCol_LtRelPos + noOfNonVisVlCol_GtRelPos)) + ctTotCnt;
                    if (str.indexOf(":") != -1) {
                        ++ctTotCnt;
                    }
                    absPosList.add(new Integer(absPos));
                } else if (str.indexOf(":") != -1) {
                    ++ctTotCnt;
                }
                ++i;
            }
        } else if (totObj.getPlacement() == 4) {
            absPos = fxElemSize + relPos - (noOfNonVisFxCol_LtRelPos + noOfNonVisFxCol_GtRelPos + noOfNonVisVlCol_LtRelPos);
            absPosList.add(new Integer(absPos));
            i = 1;
            while (i < this.crossTabMap.size()) {
                str = this.crossTabMap.get(i).toString();
                if (str.indexOf(":") == -1) {
                    absPos = absPos + vlElemSize + ctTotCnt - (noOfNonVisFxCol_LtRelPos + noOfNonVisFxCol_GtRelPos + noOfNonVisVlCol_LtRelPos) - noOfNonVisVlCol_GtRelPos;
                    absPosList.add(new Integer(absPos));
                    ctTotCnt = 0;
                } else {
                    ++ctTotCnt;
                }
                ++i;
            }
        }
        return absPosList;
    }

    private int findPos(ArrayList finalTotals, Total totObj) throws Exception {
        int index = -1;
        int i = 0;
        while (i < finalTotals.size()) {
            HashMap tmpMap = (HashMap)finalTotals.get(i);
            if (tmpMap.get(this.calAbsPosList(totObj)) == null) {
                index = i;
            }
            ++i;
        }
        return index;
    }

    private void resetResult(Total totObj) throws Exception {
        ArrayList<String> tmpList = new ArrayList<String>();
        if (totObj.getResult().size() > 0) {
            int i = 0;
            while (i < ((ArrayList)totObj.getResult().get(0)).size()) {
                tmpList.add(i, new String(""));
                ++i;
            }
        }
        totObj.setResult(tmpList);
    }

    public void updateTotalProperties(String xmlString, String caller) throws Exception {
        try {
            if (xmlString.length() > 0) {
                DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document doc = parser.parse(new ByteArrayInputStream(xmlString.getBytes(CommonConstants.ENCODING)));
                NodeList xmlTotalList = doc.getElementsByTagName("total");
                NodeList idList = doc.getElementsByTagName("oldId");
                ArrayList oldTots = null;
                int oldTotsSize = 0;
                if (caller.equalsIgnoreCase("OPENBI")) {
                    this.totalList = null;
                }
                if (this.totalList != null) {
                    oldTots = new ArrayList(this.totalList);
                    oldTotsSize = oldTots.size();
                }
                this.totalList = new ArrayList();
                ArrayList<String> existingOldTotsList = new ArrayList<String>();
                ArrayList<String> totExpr = new ArrayList<String>();
                ArrayList<String> totTitle = new ArrayList<String>();
                ArrayList<String> totPattern = new ArrayList<String>();
                ArrayList<Total> newTotsList = new ArrayList<Total>();
                int i = 0;
                while (i < xmlTotalList.getLength()) {
                    Total totObj;
                    String newTotId;
                    if (caller.equalsIgnoreCase("OPENBI")) {
                        newTotId = null;
                        int idCtr = i;
                        if (idList.item(i).getFirstChild() == null) {
                            while (existingOldTotsList.contains("T$" + (newTotId = new Integer(oldTotsSize + idCtr++).toString()))) {
                            }
                            existingOldTotsList.add("T$" + newTotId);
                            totObj = new Total(xmlTotalList.item(i), newTotId);
                            newTotsList.add(totObj);
                        } else {
                            String tempTotId = newTotId = idList.item(i).getFirstChild().getNodeValue();
                            while (existingOldTotsList.contains(tempTotId)) {
                                newTotId = new Integer(oldTotsSize + idCtr++).toString();
                                tempTotId = "T$" + newTotId;
                            }
                            existingOldTotsList.add(tempTotId);
                            Total totObj2 = new Total(xmlTotalList.item(i), newTotId);
                            newTotsList.add(totObj2);
                        }
                    } else if (idList.item(i).getFirstChild() == null) {
                        newTotId = null;
                        int idCtr = i;
                        while (existingOldTotsList.contains("T$" + (newTotId = new Integer(oldTotsSize + idCtr++).toString()))) {
                        }
                        existingOldTotsList.add("T$" + newTotId);
                        totObj = new Total(xmlTotalList.item(i), newTotId);
                        newTotsList.add(totObj);
                    } else {
                        newTotId = idList.item(i).getFirstChild().getNodeValue().trim();
                        if (!existingOldTotsList.contains(newTotId = newTotId.substring(newTotId.indexOf("$") + 1))) {
                            existingOldTotsList.add(newTotId);
                        }
                        Total totObj3 = new Total(xmlTotalList.item(i), newTotId);
                        newTotsList.add(totObj3);
                        totTitle.add(doc.getElementsByTagName("title").item(i).getFirstChild().getNodeValue().trim());
                        Node expressionNode = doc.getElementsByTagName("expression").item(i);
                        if (expressionNode != null && expressionNode.getFirstChild() != null && expressionNode.getFirstChild().getNodeValue() != null) {
                            totExpr.add(expressionNode.getFirstChild().getNodeValue().trim());
                        }
                        totPattern.add(doc.getElementsByTagName("pattern").item(i).getFirstChild().getNodeValue().trim());
                    }
                    ++i;
                }
                if (oldTots != null) {
                    int ctr = 0;
                    while (ctr < oldTots.size()) {
                        if (existingOldTotsList.contains(((Total)oldTots.get(ctr)).getTotalId())) {
                            int index = existingOldTotsList.indexOf(((Total)oldTots.get(ctr)).getTotalId());
                            boolean updated = false;
                            if (index < totExpr.size()) {
                                ((Total)oldTots.get(ctr)).setExpression((String)totExpr.get(index));
                                updated = true;
                            }
                            if (index < totTitle.size()) {
                                ((Total)oldTots.get(ctr)).setTitle((String)totTitle.get(index));
                                updated = true;
                            }
                            if (index < totPattern.size()) {
                                ((Total)oldTots.get(ctr)).setPattern((String)totPattern.get(index));
                                updated = true;
                            }
                            if (updated) {
                                this.totalList.add((Total)oldTots.get(ctr));
                            }
                        }
                        ++ctr;
                    }
                }
                this.totalList.addAll(newTotsList);
                this.noOfTotals = this.totalList.size();
            }
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    public void updateTotalPosition(ArrayList fxElementNameList, ArrayList fxElementList, ArrayList ctElementNameList, ArrayList ctElementList, ArrayList vlElementNameList, ArrayList vlElementList) throws Exception {
        try {
            Total totObj;
            this.fxElementList = fxElementList;
            this.vlElementList = vlElementList;
            int ctr = 0;
            while (ctr < this.noOfTotals) {
                int index;
                totObj = (Total)this.totalList.get(ctr);
                boolean isPositionColumn = false;
                if (fxElementNameList.indexOf(totObj.getPositionColumn()) != -1) {
                    totObj.setValid(true);
                    index = fxElementNameList.indexOf(totObj.getPositionColumn());
                    boolean bl = isPositionColumn = fxElementList.get(index).getClass().toString().indexOf("Column") != -1;
                    if (isPositionColumn) {
                        totObj.setPlacement(2);
                        totObj.setPosition(index);
                        totObj.setVisibility(((Column)fxElementList.get(index)).isVisible());
                    } else if (!isPositionColumn) {
                        totObj.setPlacement(2);
                        totObj.setPosition(index);
                        totObj.setVisibility(((Calculation)fxElementList.get(index)).isVisible());
                    }
                } else if (ctElementNameList.indexOf(totObj.getPositionColumn()) != -1) {
                    totObj.setValid(true);
                    this.isCrossTabTotal = true;
                    index = ctElementNameList.indexOf(totObj.getPositionColumn());
                    boolean bl = isPositionColumn = ctElementList.get(index).getClass().toString().indexOf("Column") != -1;
                    if (isPositionColumn) {
                        totObj.setPlacement(3);
                        totObj.setPlacementType('C');
                        totObj.setPosition(index);
                        totObj.setIsGrouped(false);
                    } else if (!isPositionColumn) {
                        totObj.setPlacement(2);
                        totObj.setPosition(index);
                        totObj.setIsGrouped(false);
                        totObj.setVisibility(((Calculation)ctElementList.get(index)).isVisible());
                    }
                    ++this.noOfCrossTabTotal;
                } else if (vlElementNameList.indexOf(totObj.getPositionColumn()) != -1) {
                    totObj.setValid(true);
                    index = vlElementNameList.indexOf(totObj.getPositionColumn());
                    boolean bl = isPositionColumn = vlElementList.get(index).getClass().toString().indexOf("Column") != -1;
                    if (isPositionColumn) {
                        totObj.setPlacement(4);
                        totObj.setPosition(index);
                        totObj.setVisibility(((Column)vlElementList.get(index)).isVisible());
                    } else if (!isPositionColumn) {
                        totObj.setPlacement(4);
                        totObj.setPosition(index);
                        totObj.setVisibility(((Calculation)vlElementList.get(index)).isVisible());
                    }
                } else if (this.crossTabMap != null) {
                    boolean found = false;
                    int ctTotsCount = 0;
                    int i = 0;
                    while (i < this.crossTabMap.size()) {
                        String elem = this.crossTabMap.get(i).toString();
                        if (elem.indexOf(totObj.getPositionColumn()) != -1) {
                            ctTotsCount = 1;
                            found = true;
                            totObj.setValid(true);
                            totObj.setVisibility(this.isTotalVisible(totObj.getPositionColumn()));
                            totObj.setPlacement(4);
                            totObj.setPosition(i + ctTotsCount);
                            totObj.setVisibility(true);
                            break;
                        }
                        if (elem.indexOf(":") != -1) {
                            ++ctTotsCount;
                        }
                        ++i;
                    }
                    if (!found) {
                        totObj.setValid(false);
                    }
                } else {
                    totObj.setValid(false);
                }
                ++ctr;
            }
            int iCtr = 0;
            while (iCtr < this.noOfTotals) {
                totObj = (Total)this.totalList.get(iCtr);
                BaseLogger.log("3", null, null, "Id :" + totObj.getTotalId() + " Title :" + totObj.getTitle() + " Placement :" + totObj.getPlacement() + " Position :" + totObj.getPosition());
                ++iCtr;
            }
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    public void setlocVarNamesList(ArrayList locVarNamesList) throws Exception {
        try {
            this.locVarNamesList = locVarNamesList;
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    public void setlocVarNameGroupMap(HashMap locVarNameGroupMap) throws Exception {
        try {
            this.locVarNameGroupMap = locVarNameGroupMap;
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    public void setlocVarMap(HashMap locVarMap) throws Exception {
        try {
            this.locVarMap = locVarMap;
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    private Double getCurrValueForLocVar(String locVarName) throws Exception {
        ArrayList groupedOnList = (ArrayList)this.locVarNameGroupMap.get(locVarName);
        StringBuffer keyStrBuff = new StringBuffer();
        Double value = new Double("0.0d");
        int i = 0;
        while (i < groupedOnList.size()) {
            keyStrBuff.append(this.recordMap.get(groupedOnList.get(i).toString()) + "~");
            ++i;
        }
        if (keyStrBuff.length() > 0) {
            keyStrBuff.deleteCharAt(keyStrBuff.length() - 1);
        }
        String keyString = keyStrBuff.toString();
        HashMap tmpMap = (HashMap)this.locVarMap.get(locVarName);
        String str = tmpMap.get(keyString).toString();
        if (!(str.length() <= 0 || str.equalsIgnoreCase("Infinity") || str.equalsIgnoreCase("-Infinity") || str.equalsIgnoreCase("NaN") || str.equalsIgnoreCase("-NaN"))) {
            value = new Double(str);
        }
        return value;
    }

    public String getGroupOnList() throws Exception {
        try {
            return this.groupOnList;
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    public ArrayList getTotalList() throws Exception {
        try {
            return this.totalList;
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    public int getNoOfCrossTabTotal() throws Exception {
        try {
            return this.noOfCrossTabTotal;
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
    }

    public String getTotalString() throws Exception {
        StringBuffer totalStringBuff = null;
        try {
            if (this.totalList != null) {
                totalStringBuff = new StringBuffer();
                int totCount = 0;
                while (totCount < this.totalList.size()) {
                    totalStringBuff.append(this.totalList.get(totCount).toString());
                    ++totCount;
                }
            }
        }
        catch (Exception e) {
            BIException.setErrorCode(0);
            e.printStackTrace();
            throw e;
        }
        return totalStringBuff.toString();
    }

    private boolean isTotalVisible(String positionColumn) throws Exception {
        boolean visibility = false;
        int i = 0;
        while (i < this.noOfTotals) {
            Total totObj = (Total)this.totalList.get(i);
            if (positionColumn.indexOf(totObj.getTotalId()) != -1) {
                visibility = totObj.isVisible();
                break;
            }
            ++i;
        }
        return visibility;
    }

    private boolean isTotalValid(String totalName) throws Exception {
        boolean isValid = false;
        int i = 0;
        while (i < this.noOfTotals) {
            Total totObj = (Total)this.totalList.get(i);
            if (totalName.indexOf(totObj.getTotalId()) != -1) {
                isValid = totObj.isValid();
                break;
            }
            ++i;
        }
        return isValid;
    }

    private ArrayList applyFormat(ArrayList dataList, Total totObj) throws Exception {
        String[] numFormatArr = new String[]{"DEFAULT", "MYH", "MYT", "MYL", "MYM", "MYC", "RTF"};
        String format = null;
        String pattern = null;
        format = totObj.getUnits().toUpperCase();
        pattern = totObj.getPattern();
        int index = -1;
        DecimalFormat df = new DecimalFormat();
        if (pattern == null || pattern.equalsIgnoreCase("null")) {
            pattern = "#,##0.00";
        }
        df.applyPattern(pattern);
        int i = 0;
        while (i < numFormatArr.length) {
            if (numFormatArr[i].equals(format)) {
                index = i;
                break;
            }
            ++i;
        }
        i = 0;
        while (i < dataList.size()) {
            if (dataList.get(i).toString().length() > 0) {
                double resultData = 0.0;
                String str = dataList.get(i).toString();
                if (!(str.length() <= 0 || str.equalsIgnoreCase("Infinity") || str.equalsIgnoreCase("-Infinity") || str.equalsIgnoreCase("NaN") || str.equalsIgnoreCase("-NaN"))) {
                    resultData = Double.parseDouble(str);
                }
                switch (index) {
                    case 0: {
                        resultData /= 1.0;
                        break;
                    }
                    case 1: {
                        resultData /= 100.0;
                        break;
                    }
                    case 2: {
                        resultData /= 1000.0;
                        break;
                    }
                    case 3: {
                        resultData /= 100000.0;
                        break;
                    }
                    case 4: {
                        resultData /= 1000000.0;
                        break;
                    }
                    case 5: {
                        resultData /= 1.0E7;
                        break;
                    }
                }
                dataList.set(i, df.format(resultData));
            }
            ++i;
        }
        return dataList;
    }
}

