/*
 * Decompiled with CFR 0.152.
 */
package ibase.servlet;

import ibase.servlet.AuthenticateServlet;
import ibase.servlet.Messages;
import ibase.utility.BaseException;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.HashMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.w3c.dom.Document;

public class MobileAuthenticateServlet
extends AuthenticateServlet {
    ServletContext servletContext = null;
    ServletConfig servletConfig = null;

    @Override
    public void init(ServletConfig servletConfig) throws ServletException {
        this.servletConfig = servletConfig;
        this.servletContext = servletConfig.getServletContext();
    }

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.doPost(request, response);
    }

    @Override
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        request.setCharacterEncoding(CommonConstants.ENCODING);
        response.setContentType("application/x-www-form-urlencoded; charset=" + CommonConstants.ENCODING);
        try {
            this.authenticate(request, response);
        }
        catch (BaseException itme) {
            try {
                PrintWriter writer = response.getWriter();
                response.setContentType("text/html");
                String errMsg = itme.getMessage();
                response.setContentLength(errMsg.length());
                writer.println(errMsg);
                writer.flush();
                writer.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        catch (Exception e) {
            try {
                PrintWriter writer = response.getWriter();
                response.setContentType("text/html");
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                e.printStackTrace(new PrintStream(baos));
                response.setContentLength(baos.toString().length());
                writer.println(baos.toString());
                writer.flush();
                writer.close();
                baos.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    protected void authenticate(HttpServletRequest request, HttpServletResponse response) throws BaseException {
        BaseLogger.log("2", null, null, "Called MobileAuthenticateServlet authentication.....");
        String responseStr = "false";
        try {
            String authStatusStr = super.authenticate(request);
            if (this.getAuthenticationStatus(authStatusStr)) {
                HashMap<String, String> userInfoMap;
                String userSessId;
                BaseLogger.log("3", null, null, "isValid");
                UserInfoBean userInfo = (UserInfoBean)request.getSession().getAttribute("USER_INFO");
                String SESSION_ID = "INVALIDUSR";
                String user = userInfo.getLoginCode();
                String site = userInfo.getSiteCode();
                String profileID = userInfo.getProfileId();
                CommonConstants.setAPPLICATION_CONTEXT(this.servletContext.getRealPath("/"));
                if (request.getParameter("CLIENT_TYPE") != null && request.getParameter("CLIENT_TYPE").equalsIgnoreCase("MOBILE")) {
                    HashMap<String, HashMap<String, String>> allUserInfoMap;
                    HashMap<String, String> userSessIdMap = this.servletContext.getAttribute("USER_SESSID_MAP") != null ? (HashMap<String, String>)this.servletContext.getAttribute("USER_SESSID_MAP") : null;
                    userSessId = request.getSession().getId();
                    if (userSessIdMap == null) {
                        userSessIdMap = new HashMap<String, String>();
                        userSessIdMap.put(user, userSessId);
                        this.servletContext.setAttribute("USER_SESSID_MAP", userSessIdMap);
                    }
                    if (userSessIdMap.containsKey(user)) {
                        userSessId = (String)userSessIdMap.get(user);
                    } else {
                        userSessIdMap.put(user, userSessId);
                    }
                    HashMap<String, HashMap<String, String>> hashMap = allUserInfoMap = this.servletContext.getAttribute("ALL_USER_INFO_MAP") != null ? (HashMap<String, HashMap<String, String>>)this.servletContext.getAttribute("ALL_USER_INFO_MAP") : null;
                    if (allUserInfoMap == null) {
                        BaseLogger.log("3", null, null, "allUserInfoMap == null");
                        allUserInfoMap = new HashMap<String, HashMap<String, String>>();
                        this.servletContext.setAttribute("ALL_USER_INFO_MAP", allUserInfoMap);
                    }
                    HashMap<String, String> hashMap2 = userInfoMap = allUserInfoMap.get(userSessId) != null ? (HashMap<String, String>)allUserInfoMap.get(userSessId) : null;
                    if (userInfoMap == null) {
                        userInfoMap = new HashMap<String, String>();
                        allUserInfoMap.put(userSessId, userInfoMap);
                    }
                } else {
                    BaseLogger.log("3", null, null, "throwing new Exception( INVALID_REQUEST )");
                    throw new BaseException(new Exception("INVALID_REQUEST"));
                }
                userInfoMap.put("USER", user);
                userInfoMap.put("SITE_CODE", site);
                userInfoMap.put("PROFILE_ID", profileID);
                DataOutputStream dos = new DataOutputStream((OutputStream)response.getOutputStream());
                SESSION_ID = userSessId;
                String positiveResponse = "Y~";
                response.setContentLength(SESSION_ID.length() + positiveResponse.length());
                dos.writeBytes(String.valueOf(positiveResponse) + SESSION_ID);
                dos.flush();
                dos.close();
                return;
            }
            BaseLogger.log("3", null, null, "isNotValid");
            this.generateResponse(request, response, authStatusStr);
        }
        catch (BaseException be) {
            BaseLogger.log("0", null, null, "BaseException :MobileAuthenticateServlet :authenticate() :==>\n" + be.getMessage());
            throw be;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :MobileAuthenticateServlet :authenticate() :==>\n" + e.getMessage());
            throw new BaseException(e);
        }
    }

    private boolean generateResponse(HttpServletRequest request, HttpServletResponse response, String xmlInfo) throws BaseException {
        BaseLogger.log("2", null, null, "Generating Response....");
        boolean isUserAuthentic = false;
        boolean isFirstLogin = false;
        boolean isPwdExpired = false;
        String responseString = "";
        String userCode = null;
        String siteCode = null;
        String passwd = null;
        try {
            userCode = request.getParameter("USER");
            siteCode = request.getParameter("SITE_CODE");
            passwd = request.getParameter("PASSWORD");
            HttpSession session = request.getSession();
            if (xmlInfo != null) {
                Document document = new E12GenericUtility().parseString(xmlInfo);
                if (document.getElementsByTagName("STATUS").item(0) != null) {
                    isUserAuthentic = Boolean.valueOf(document.getElementsByTagName("STATUS").item(0).getFirstChild().getNodeValue());
                }
                if (document.getElementsByTagName("STATUS_CODE").item(0) != null) {
                    String statusCode = document.getElementsByTagName("STATUS_CODE").item(0).getFirstChild().getNodeValue();
                    if (statusCode.equalsIgnoreCase("RESIGNED")) {
                        responseString = "Employee has resigned !";
                    } else if (statusCode.equalsIgnoreCase("LOCKED")) {
                        responseString = "Your account is locked ! Please, contact your administrator for further assistance.";
                    } else if (statusCode.equalsIgnoreCase("ACCOUNT_LOCKED")) {
                        responseString = String.valueOf(Messages.getString("AuthenticateServlet_accountIsLocked", this.getUserLangAndCountry(request.getParameter("USER")))) + " " + CommonConstants.WRONG_LOGIN_COUNT + " times. " + Messages.getString("AuthenticateServlet_newPasswordIsSentToYourEmaiID", this.getUserLangAndCountry(request.getParameter("USER"))) + " " + Messages.getString("AuthenticateServlet_accountUnlocked", this.getUserLangAndCountry(request.getParameter("USER")));
                    } else if (statusCode.equalsIgnoreCase("WRONG_LOGIN_COUNT_EXCEED")) {
                        responseString = String.valueOf(Messages.getString("AuthenticateServlet_passwordBlockedSinceWronglyEntered", this.getUserLangAndCountry(request.getParameter("USER")))) + CommonConstants.WRONG_LOGIN_COUNT + Messages.getString("AuthenticateServlet_newPasswordSentToEmailID", this.getUserLangAndCountry(request.getParameter("USER")));
                    } else if (statusCode.indexOf("INVALID") != -1) {
                        if (statusCode.equalsIgnoreCase("INVALID_USR") || statusCode.equalsIgnoreCase("INVALID_PWD")) {
                            responseString = "Please enter the valid User Name and Password.";
                        }
                        BaseLogger.log("3", null, null, "session.getAttribute( INVALID_COUNT )::" + session.getAttribute("INVALID_COUNT"));
                        if (session.getAttribute("INVALID_COUNT") == null) {
                            BaseLogger.log("3", null, null, "session.setAttribute::");
                            session.setAttribute("INVALID_COUNT", (Object)new Integer(1));
                        } else {
                            int maxCount = 5;
                            int invaildCount = (Integer)session.getAttribute("INVALID_COUNT");
                            BaseLogger.log("3", null, null, "invaildCount::" + invaildCount);
                            BaseLogger.log("3", null, null, "maxCount-1  ::" + (maxCount - 1));
                            if (invaildCount == maxCount - 1) {
                                if (document.getElementsByTagName("RES_TYPE") != null && document.getElementsByTagName("RES_TYPE").item(0) != null) {
                                    String resType = document.getElementsByTagName("RES_TYPE").item(0).getFirstChild().getNodeValue();
                                    String deviceId = request.getParameter("MAC_ADDRESS");
                                    if (deviceId == null || deviceId.trim().length() == 0) {
                                        deviceId = request.getParameter("DEVICEID");
                                    }
                                    this.secureAccount(userCode, resType, request.getRemoteAddr(), deviceId);
                                    if (Integer.parseInt(resType) == 0) {
                                        String emailIdOff = null;
                                        if (document.getElementsByTagName("EMAIL_ID") != null && document.getElementsByTagName("EMAIL_ID").item(0) != null) {
                                            emailIdOff = document.getElementsByTagName("EMAIL_ID").item(0).getFirstChild().getNodeValue();
                                        }
                                        responseString = "Your Password has been blocked since it was wrongly entered" + maxCount + "times new password is sent to your e-mail id" + emailIdOff;
                                    } else if (Integer.parseInt(resType) == 1) {
                                        responseString = "Your account is locked ! Please, contact your administrator for further assistance.";
                                    } else {
                                        BaseLogger.log("3", null, null, "Invaild Response Type(resType) Found :" + resType);
                                    }
                                }
                                session.setAttribute("INVALID_COUNT", (Object)new Integer(0));
                            } else {
                                session.setAttribute("INVALID_COUNT", (Object)new Integer(invaildCount + 1));
                            }
                        }
                    } else if (statusCode.indexOf("PASS_EXP") != -1) {
                        isPwdExpired = true;
                        if (statusCode.equalsIgnoreCase("PASS_EXP_GRACE") || statusCode.equalsIgnoreCase("PASS_EXP_NOGRACE")) {
                            responseString = "Your password is expired !";
                        }
                    } else if (statusCode.equalsIgnoreCase("FIRST_LOGIN")) {
                        isFirstLogin = true;
                        int minPwdLen = -1;
                        if (document.getElementsByTagName("MIN_PWD_LENGTH") != null && document.getElementsByTagName("MIN_PWD_LENGTH").item(0) != null) {
                            minPwdLen = Integer.parseInt(document.getElementsByTagName("MIN_PWD_LENGTH").item(0).getFirstChild().getNodeValue());
                        }
                        responseString = "You have to compulsarily change your password , please do so";
                    }
                }
                response.setBufferSize(responseString.length());
                response.setContentType("text/html");
                ServletOutputStream outputStream = response.getOutputStream();
                outputStream.write(responseString.getBytes());
                outputStream.flush();
                outputStream.close();
            }
        }
        catch (BaseException be) {
            BaseLogger.log("0", null, null, "BaseException: generateResponse:==>\n" + be);
            throw be;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception: generateResponse:==>\n" + e);
            throw new BaseException(e);
        }
        return isUserAuthentic;
    }
}

