/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.servlet;

import ibase.system.config.AppConnectParm;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.MasterStatefulRemote;
import ibase.webitm.servlet.ITMAuthenticateServlet;
import ibase.webitm.servlet.Messages;
import ibase.webitm.utility.ITMException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.naming.InitialContext;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ProcessExtRequestServlet
extends ITMAuthenticateServlet {
    ServletContext servletContext = null;
    ServletConfig servletConfig = null;
    ArrayList objNameList = null;

    @Override
    public void init(ServletConfig servletConfig) throws ServletException {
        this.servletConfig = servletConfig;
        this.servletContext = servletConfig.getServletContext();
        this.objNameList = new ArrayList();
        this.objNameList.add("ser_complaint_fb");
        this.objNameList.add("proj_task_feedback");
        this.objNameList.add("proj_task_res_alloc");
    }

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        this.doPost(request, response);
    }

    @Override
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        PrintWriter writer = null;
        String responseString = "";
        try {
            if (Boolean.valueOf(this.authenticate(request)).booleanValue()) {
                String xmlString = this.buildXMLString(request);
                responseString = this.saveData(xmlString, request);
                String returnStr = "";
                if (responseString.indexOf("<Errors>") != -1) {
                    returnStr = Messages.getString("ProcessExtRequestServlet_error");
                    returnStr = String.valueOf(returnStr) + responseString.substring(responseString.indexOf("<message>") + "<message>".length(), responseString.indexOf("</message>"));
                    returnStr = String.valueOf(returnStr) + responseString.substring(responseString.indexOf("<description>") + "<description>".length(), responseString.indexOf("</description>"));
                } else {
                    returnStr = responseString.substring(responseString.indexOf("<TranID>") + "<TranID>".length(), responseString.indexOf("</TranID>"));
                }
                if (this.objNameList.contains(request.getParameter("OBJ_NAME"))) {
                    request.getSession().setAttribute("MSG", (Object)returnStr);
                    RequestDispatcher reqDis = request.getRequestDispatcher("webitm/jsp/Output.jsp");
                    reqDis.forward((ServletRequest)request, (ServletResponse)response);
                }
            } else {
                responseString = "INVALID ACCESS";
            }
            writer = response.getWriter();
            writer.println(responseString);
            writer.flush();
            writer.close();
        }
        catch (ITMException itme) {
            try {
                if (writer == null) {
                    writer = response.getWriter();
                }
                response.setContentType("text/html; charset=" + CommonConstants.ENCODING);
                String errMsg = itme.getMessage();
                response.setContentLength(errMsg.length());
                writer.println(errMsg);
                writer.flush();
                writer.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        catch (Exception e) {
            try {
                if (writer == null) {
                    writer = response.getWriter();
                }
                response.setContentType("text/html; charset=" + CommonConstants.ENCODING);
                String errMsg = e.getMessage();
                response.setContentLength(errMsg.length());
                writer.println(errMsg);
                writer.flush();
                writer.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private String buildXMLString(HttpServletRequest request) throws ITMException {
        StringBuffer xmlStringBuff = null;
        try {
            E12GenericUtility genericUtility = new E12GenericUtility();
            String objName = request.getParameter("OBJ_NAME");
            String action = request.getParameter("ACTION");
            action = action != null && action.length() > 0 ? action : "SAVE";
            xmlStringBuff = new StringBuffer("<?xml version=\"1.0\"?><Root><header><objName><![CDATA[" + objName + "]]></objName>" + "<pageContext><![CDATA[2]]></pageContext>" + "<objContext><![CDATA[1]]></objContext>" + "<editFlag><![CDATA[A]]></editFlag>" + "<focusedColumn><![CDATA[]]></focusedColumn>" + "<action><![CDATA[" + action + "]]></action>" + "<elementName><![CDATA[]]></elementName>" + "<keyValue><![CDATA[1]]></keyValue>" + "<taxKeyValue><![CDATA[]]></taxKeyValue>" + "<saveLevel><![CDATA[1]]></saveLevel>" + "<forcedSave><![CDATA[true]]></forcedSave>" + "<taxInFocus><![CDATA[false]]></taxInFocus>" + "</header>");
            String xmlData = request.getParameter("XML_DATA");
            if (xmlData != null && !"null".equals(xmlData) && xmlData.length() > 0) {
                Document detailDom = genericUtility.parseString(xmlData);
                NodeList headerNodeList = detailDom.getElementsByTagName("Header0");
                Node headerNode = headerNodeList.item(0);
                if (headerNode != null) {
                    NodeList detailList = headerNode.getChildNodes();
                    int noOfChildren = detailList.getLength();
                    int childCtr = 0;
                    while (childCtr < noOfChildren) {
                        Node childNode = detailList.item(childCtr);
                        String childNodeName = childNode.getNodeName();
                        if (childNodeName.startsWith("Detail")) {
                            xmlStringBuff.append(genericUtility.serializeDom(childNode));
                        }
                        ++childCtr;
                    }
                }
            } else {
                xmlStringBuff.append("<Detail1 dbID='' domID='1' objName='" + objName + "' objContext='1'>");
                xmlStringBuff.append("<attribute pkNames='' status='N' updateFlag='N' selected='N'/>");
                Enumeration enum1 = request.getParameterNames();
                while (enum1.hasMoreElements()) {
                    String param = (String)enum1.nextElement();
                    xmlStringBuff.append("<" + param + "><![CDATA[" + request.getParameter(param) + "]]></" + param + ">");
                }
                xmlStringBuff.append("</Detail1>");
            }
            xmlStringBuff.append("</Root>");
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "[Exception] :[ProcessExtRequestServlet] :[buildXMLString] [" + e + "]");
            throw new ITMException(e);
        }
        return xmlStringBuff.toString();
    }

    private String saveData(String xmlString, HttpServletRequest request) throws ITMException {
        InitialContext ctx = null;
        String retString = null;
        MasterStatefulRemote masterStateful = null;
        try {
            try {
                AppConnectParm appConnect = new AppConnectParm();
                ctx = new InitialContext(appConnect.getProperty());
                masterStateful = (MasterStatefulRemote)ctx.lookup("ibase/MasterStatefulEJB/remote");
                UserInfoBean userInfo = (UserInfoBean)request.getSession().getAttribute("USER_INFO");
                if (userInfo != null) {
                    retString = masterStateful.processRequest(userInfo, xmlString, false, null);
                }
            }
            catch (ITMException itme) {
                BaseLogger.log("0", null, null, "ITMException :ProcessExtRequestServlet :saveData :==>");
                throw itme;
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception :ProcessExtRequestServlet :saveData :==>");
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (masterStateful != null) {
                    masterStateful.remove();
                    masterStateful = null;
                }
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        return retString;
    }
}

