package ibase.webitm.ejb.sys;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;

import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

import ibase.ejb.CommonDBAccessEJB;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseException;
import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.ejb.EventManagerEJB;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.JMSFollowupActions;
import ibase.webitm.utility.JMSLogger;

public class E12APIReInitialize extends ActionHandlerEJB {

	public String reInitialize(String tranID, String xtraParam, String forcedFlag)
			throws ITMException {
		E12GenericUtility genericUtility = new E12GenericUtility();
		ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
		Connection conn = null;

		BaseLogger.log("3", null, null, "Inside E12APIReInitialize =>reInitialize  ...");
		BaseLogger.log("3", null, null, "Inside reInitialize tranId [" + tranID + "]");
		BaseLogger.log("3", null, null, "Inside reInitialize xtraParam [" + xtraParam + "]");
		BaseLogger.log("3", null, null, "Inside reInitialize forcedFlag [" + forcedFlag + "]");

		PreparedStatement pStmt = null;
		ResultSet resultSet = null;
		String objectName = "";
		String refId = "";

		String responseStr = "";
		boolean isEventFound = false;
		StringBuffer xmlString = new StringBuffer();
		StringBuffer responseStrBuff = new StringBuffer("<?xml version=\"1.0\"?><Root>");
		String transDB = "";
		String errorType ="";

		try {
			String userId = genericUtility.getValueFromXTRA_PARAMS(xtraParam, "loginCode");
			JMSFollowupActions jmsFollowupActions = new JMSFollowupActions();

			CommonDBAccessEJB commonDBAccessEJB = new CommonDBAccessEJB();
			UserInfoBean userInfo = commonDBAccessEJB.createUserInfo(userId);
			BaseLogger.log("3", null, null, "userInfo => [" + userInfo + "]");
			transDB = userInfo.getTransDB();
			
			if(transDB == null || transDB.trim().length() == 0)
			{
				throw new ITMException(new Exception("Trans DB is null"));
			}
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB(transDB);
			BaseLogger.log("3", null, null, "conn => [" + conn + "]");

			String query = "SELECT OBJ_NAME,REF_ID FROM FOLLOW_UP_ACTIONS_LOGS WHERE TRAN_ID=?";
			pStmt = conn.prepareStatement(query);
			pStmt.setString(1, tranID);
			resultSet = pStmt.executeQuery();

			if (resultSet.next()) {
				objectName = checkNull(resultSet.getString("OBJ_NAME"));
				refId = checkNull(resultSet.getString("REF_ID"));
			}

			BaseLogger.log("3", null, null, "OBJ NAME [" + objectName + "], refId=["+refId+"]");

			xmlString.append("<DocumentRoot>");
			xmlString.append("<description>Datawindow Root</description>");
			xmlString.append("<group0>");
			xmlString.append("<description>Group0 description</description>");
			xmlString.append("<Header0>");
			xmlString.append("genericUtility<description>Header0 members</description>");
			xmlString.append("<detail1>");
			xmlString.append("<obj_name><![CDATA[").append(objectName).append("]]></obj_name>");
			xmlString.append("<tran_id><![CDATA[").append(tranID).append("]]></tran_id>");
			xmlString.append("<ref_id><![CDATA[").append(refId).append("]]></ref_id>");
			xmlString.append("</detail1>");
			xmlString.append("</Header0>");
			xmlString.append("</group0>");
			xmlString.append("</DocumentRoot>");

			String xmlData = xmlString.toString();
			BaseLogger.log("3", null, null, "xmldata => [" + xmlData + "]");

			EventManagerEJB eventManager = new EventManagerEJB();
			eventManager.setUserInfo(userInfo);

			isEventFound = eventManager.isEventExist(objectName, "reInitialize_api", userInfo);
			BaseLogger.log("3", userInfo, null, "isEventFound[reInitialize_api] =[" + isEventFound + "]");

			if (isEventFound) 
			{
				responseStr = eventManager.executeSystemEvent(objectName, "reInitialize_api", null, xmlData, xmlData,
						xtraParam, null, userInfo);

				BaseLogger.log("3", null, null, " ExecuteSystem response [" + responseStr + "]");
				
				if (responseStr != null && responseStr.length() > 0) 
				{

					if (responseStr.indexOf("<?xml") != -1) {
						responseStrBuff.append(responseStr.substring(responseStr.indexOf("?>") + 2));
					} else {
						responseStrBuff.append(responseStr);
					}
					
					Document doc = genericUtility.getDocument(responseStr);
					NodeList errorList = doc.getElementsByTagName("error");
					int errorListLen = errorList.getLength();
					for (int errorCtr = 0; errorCtr < errorListLen; errorCtr++) 
					{
						errorType ="";					

						errorType = errorList.item(errorCtr).getAttributes().getNamedItem("type").getNodeValue();
						BaseLogger.log("3", null, null, " errorType [" + errorType + "]");
						
						if (errorType != null && "E".equalsIgnoreCase(errorType)) 
						{
							break;
						}
					}
					if (errorType != null && "E".equalsIgnoreCase(errorType)) 
					{
						jmsFollowupActions.updateFollwUpActionData(tranID, transDB, "1", "X", responseStr);
						BaseLogger.log("3", null, null, " error updated in database [" + responseStr + "]");
						//break;
					}
					else 
					{
						jmsFollowupActions.updateFollwUpActionData(tranID, transDB, "1", "S", responseStr);
						BaseLogger.log("3", null, null,"ApiReinitialize sucessfully updated in database[" + tranID + "]");
					}
					
					responseStr = itmDBAccessEJB.getErrorString("", "REINTLZ", userId, "", conn);

					
				}
			} 	
			else
			{
				responseStr = itmDBAccessEJB.getErrorString("", "EVNTNOTFND", userId, "", conn);
			}

		} catch (Exception e) {
			e.printStackTrace();
			throw new ITMException(e);
			
		}

		finally {
			try {
				if (conn != null) {
					if (resultSet != null) {
						resultSet.close();
						resultSet = null;
					}
					if (pStmt != null) {
						pStmt.close();
						pStmt = null;
					}
					conn.close();
					conn = null;
				}

			} catch (SQLException ex) {
				BaseLogger.log("3", null, null, ex.getMessage());
			}
		}
		BaseLogger.log("3", null, null, " responseStr => [" + responseStr + "]");
		return responseStr;

	}
	public String checkNull(String input)
	{
		if (input == null || "null".equalsIgnoreCase(input))
		{
			input= "";
		}
		return input.trim();
	}
}