/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.bean.wiz;

import ibase.system.config.AppConnectParm;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.ITMWizardStatefulRemote;
import ibase.webitm.utility.ITMException;
import java.io.File;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.naming.InitialContext;
import javax.servlet.http.HttpSession;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ITMWizardBean
implements Serializable {
    private UserInfoBean userInfo = null;
    private HttpSession sessionCtx = null;
    ITMWizardStatefulRemote itmWizardRemote = null;
    private String objName = "";
    private String user_lang = "en";
    private String user_country = "US";
    private double classId = 0.0;
    private String hostName = "";
    private String hostIP = "";

    public ITMWizardBean(String objName, HttpSession sessionCtx) throws ITMException {
        try {
            this.objName = objName;
            this.sessionCtx = sessionCtx;
            this.userInfo = (UserInfoBean)this.sessionCtx.getAttribute("USER_INFO");
            this.user_lang = this.userInfo.getUserLanguage();
            this.user_country = this.userInfo.getUserCountry();
            this.hostName = this.userInfo.getHostName();
            this.hostIP = this.userInfo.getHostIP();
            if (this.itmWizardRemote == null) {
                InitialContext ctx = new InitialContext(new AppConnectParm().getProperty());
                this.itmWizardRemote = (ITMWizardStatefulRemote)ctx.lookup("ibase/ITMWizardStatefulEJB/remote");
                this.itmWizardRemote.setUserInfo(this.userInfo);
                this.itmWizardRemote.loadFormsMetaData(this.objName, "1", String.valueOf(this.objName) + "21", this.userInfo.getEmpCode(), this.userInfo.getProfileId());
                this.classId = Math.random();
                new E12GenericUtility().writeFile("ITMWizardComp", " \n ITMWizardBean has been created : UserId [," + this.userInfo.getLoginCode() + ",] objName[," + this.objName + ",] Time [," + new Date() + ",] ClassId [," + this.classId + ",] hostName[," + this.hostName + ",] hostIP[" + this.hostIP + "]");
            }
        }
        catch (ITMException itme) {
            this.itmWizardRemote.remove();
            this.itmWizardRemote = null;
            throw itme;
        }
        catch (Exception e) {
            this.itmWizardRemote.remove();
            this.itmWizardRemote = null;
            throw new ITMException(e);
        }
    }

    public ITMWizardBean() throws ITMException {
    }

    public UserInfoBean getUserInfo() {
        return this.userInfo;
    }

    public void setUserInfo(UserInfoBean userInfo) {
        this.userInfo = userInfo;
    }

    public String callEventManager(String eventCode, String objContext, String domId, ArrayList dataArrayList, String action, String formType, String forceSave, String tranID) throws ITMException {
        return this.callEventManager(eventCode, objContext, domId, dataArrayList, action, formType, forceSave, tranID, "");
    }

    public String callEventManager(String eventCode, String objContext, String domId, ArrayList dataArrayList, String action, String formType, String forceSave, String tranID, String editFlag) throws ITMException {
        String retHTMLStr = "";
        try {
            ArrayList xmlDataList = this.itmWizardRemote.callEventManager(this.userInfo.getLoginCode(), this.objName, eventCode, objContext, domId, dataArrayList, action, formType, forceSave, tranID);
            String xmlData = (String)xmlDataList.get(0);
            xmlData = new E12GenericUtility().setXmlDec(xmlData);
            if (xmlData != null && xmlData.length() > 0) {
                String targetDir = String.valueOf(CommonConstants.APPLICATION_CONTEXT) + File.separator + "temp";
                if (xmlData.indexOf("<error") == -1) {
                    int objCtxInt = Integer.parseInt(objContext);
                    if (eventCode.equals("pre_navigate") && "next".equalsIgnoreCase(action)) {
                        BaseLogger.log("3", this.userInfo, null, " Calling next Click.............");
                        if (formType != null && formType.indexOf("MP:") != -1) {
                            objCtxInt = Integer.parseInt(formType.substring(formType.lastIndexOf(":") + 1));
                            BaseLogger.log("3", this.userInfo, null, " Calling next Click............objCtxInt.[" + objCtxInt + "]");
                        } else {
                            ++objCtxInt;
                        }
                    } else if (eventCode.equals("pre_navigate") && "previous".equalsIgnoreCase(action)) {
                        BaseLogger.log("3", this.userInfo, null, " Calling Previous Click.............");
                        if (formType != null && formType.indexOf(":MP") != -1) {
                            objCtxInt = Integer.parseInt(formType.substring(0, formType.indexOf(":")));
                            BaseLogger.log("3", this.userInfo, null, " Calling Previous Click.............objCtxInt[" + objCtxInt + "]");
                        } else {
                            --objCtxInt;
                        }
                    } else if (xmlData.indexOf("Detail1") != -1) {
                        objCtxInt = 1;
                    }
                    objContext = "" + objCtxInt;
                    BaseLogger.log("3", this.userInfo, null, " this.beanXmlDataMap.put objCtxInt [" + objCtxInt + "]");
                } else {
                    BaseLogger.log("3", this.userInfo, null, "Getting data from  Appending Error Node ");
                    xmlData = this.appendErrorNode((String)dataArrayList.get(0), xmlData);
                }
                if (retHTMLStr.length() == 0) {
                    xmlData = new E12GenericUtility().setXmlDec(xmlData);
                    String xslFileName = "";
                    if (editFlag.equalsIgnoreCase("V")) {
                        xslFileName = this.getXSLFileName(String.valueOf(this.objName) + objContext + "_wiz_" + this.user_lang + "_" + this.user_country + "_" + "V" + ".xsl");
                        BaseLogger.log("3", this.userInfo, null, " 02112022-227 VIEW::::: " + xslFileName);
                    } else {
                        xslFileName = this.getXSLFileName(String.valueOf(this.objName) + objContext + "_wiz_" + this.user_lang + "_" + this.user_country + "_" + "A" + ".xsl");
                        BaseLogger.log("3", this.userInfo, null, " 02112022-233 ELSE::::: " + xslFileName);
                    }
                    retHTMLStr = new E12GenericUtility().transformToString(xslFileName, xmlData, targetDir, "Output", ".html");
                    BaseLogger.log("3", this.userInfo, null, "Getting data from  getXSLFileName [" + xslFileName + "] ");
                    BaseLogger.log("3", this.userInfo, null, "Getting data from  getXSLFileName [" + targetDir + "] ");
                }
            }
        }
        catch (ITMException itme) {
            itme.printStackTrace();
            throw itme;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ITMException(e);
        }
        return retHTMLStr;
    }

    private String getXSLFileName(String xslFileName) throws ITMException {
        String retFileName = null;
        File xslPath = null;
        String userTheme = "";
        String uxInterface = "";
        try {
            String defaultPath = null;
            defaultPath = CommonConstants.APPLICATION_CONTEXT != null ? String.valueOf(CommonConstants.APPLICATION_CONTEXT) + "webitm" + File.separator : ".." + File.separator + "webapps" + File.separator + "ibase" + File.separator + "webitm" + File.separator;
            if (this.userInfo != null) {
                uxInterface = this.userInfo.getUxInterface();
                uxInterface = uxInterface == null ? "" : uxInterface.trim();
                userTheme = this.userInfo.getUserTheme();
                userTheme = userTheme == null ? "" : userTheme.trim();
            }
            BaseLogger.log("3", this.userInfo, null, "uxInterface =[" + uxInterface + "], userTheme =[" + userTheme + "]");
            xslPath = uxInterface != null && "galaxy".equalsIgnoreCase(uxInterface) ? new File(String.valueOf(defaultPath) + File.separator + "xsl" + File.separator + CommonConstants.THEME + File.separator + "WIZARD" + File.separator + uxInterface) : new File(String.valueOf(defaultPath) + File.separator + "xsl" + File.separator + CommonConstants.THEME + File.separator + "WIZARD");
            if (!xslPath.exists()) {
                xslPath.mkdir();
            }
            BaseLogger.log("3", this.userInfo, null, " xslPath [" + xslPath + "] xslFileName [" + xslFileName + "]");
            File xslFile = new File(xslPath, xslFileName);
            if (!xslFile.exists()) {
                throw new ITMException(new Exception(String.valueOf(retFileName) + " Wizard XSL file Not Found"));
            }
            retFileName = xslFile.getAbsolutePath();
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return retFileName;
    }

    public String getSalesPersItemList(String salesPers, String strgCode, String selectedItem) throws ITMException {
        String itemData = "";
        ITMWizardStatefulRemote itmWizardRemoteTemp = null;
        try {
            try {
                InitialContext ctx = new InitialContext(new AppConnectParm().getProperty());
                itmWizardRemoteTemp = (ITMWizardStatefulRemote)ctx.lookup("ibase/ITMWizardStatefulEJB/remote");
                itemData = itmWizardRemoteTemp.getSalesPersItemList(salesPers, strgCode, selectedItem, this.userInfo);
                itmWizardRemoteTemp.remove();
                itmWizardRemoteTemp = null;
                String xslFileName = this.getXSLFileName("strg_meet_item_wiz_" + this.user_lang + "_" + this.user_country + ".xsl");
                itemData = new E12GenericUtility().transformToString(xslFileName, itemData, String.valueOf(CommonConstants.APPLICATION_CONTEXT) + File.separator + "temp", "Output", ".html");
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        finally {
            if (itmWizardRemoteTemp != null) {
                itmWizardRemoteTemp.remove();
                itmWizardRemoteTemp = null;
            }
        }
        return itemData;
    }

    public String getSalesPersTeamList(String salesPers, String strgCode, String selectedTeam) throws ITMException {
        String teamData = "";
        ITMWizardStatefulRemote itmWizardRemoteTemp = null;
        try {
            try {
                InitialContext ctx = new InitialContext(new AppConnectParm().getProperty());
                itmWizardRemoteTemp = (ITMWizardStatefulRemote)ctx.lookup("ibase/ITMWizardStatefulEJB/remote");
                teamData = itmWizardRemoteTemp.getSalesPersTeamList(salesPers, strgCode, selectedTeam, this.userInfo);
                itmWizardRemoteTemp.remove();
                itmWizardRemoteTemp = null;
                String xslFileName = this.getXSLFileName("strg_meet_team_wiz_" + this.user_lang + "_" + this.user_country + ".xsl");
                teamData = new E12GenericUtility().transformToString(xslFileName, teamData, String.valueOf(CommonConstants.APPLICATION_CONTEXT) + File.separator + "temp", "Output", ".html");
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        finally {
            if (itmWizardRemoteTemp != null) {
                itmWizardRemoteTemp.remove();
                itmWizardRemoteTemp = null;
            }
        }
        return teamData;
    }

    private String appendErrorNode(String prevXMLData, String currXmlData) throws ITMException {
        String retUpdXMLData = "";
        try {
            retUpdXMLData = prevXMLData.replace("<Errors></Errors>", currXmlData.substring(currXmlData.indexOf("<Errors>"), currXmlData.lastIndexOf("</Errors>") + 9));
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return retUpdXMLData;
    }

    public String getActivityCodeList(String salesPers, String selectedActCode) {
        String activityCodeData = "";
        ITMWizardStatefulRemote itmWizardRemoteTemp = null;
        try {
            try {
                InitialContext ctx = new InitialContext(new AppConnectParm().getProperty());
                itmWizardRemoteTemp = (ITMWizardStatefulRemote)ctx.lookup("ibase/ITMWizardStatefulEJB/remote");
                activityCodeData = itmWizardRemoteTemp.getActivityCodeList(salesPers, selectedActCode, this.userInfo.getTransDB());
                itmWizardRemoteTemp.remove();
                itmWizardRemoteTemp = null;
                String xslFileName = this.getXSLFileName("strg_meet_act_code_wiz_" + this.user_lang + "_" + this.user_country + ".xsl");
                activityCodeData = new E12GenericUtility().transformToString(xslFileName, activityCodeData, String.valueOf(CommonConstants.APPLICATION_CONTEXT) + File.separator + "temp", "Output", ".html");
            }
            catch (Exception e) {
                e.printStackTrace();
                if (itmWizardRemoteTemp != null) {
                    itmWizardRemoteTemp.remove();
                    itmWizardRemoteTemp = null;
                }
            }
        }
        finally {
            if (itmWizardRemoteTemp != null) {
                itmWizardRemoteTemp.remove();
                itmWizardRemoteTemp = null;
            }
        }
        return activityCodeData;
    }

    public String getFormsHTMLData(String objCtx, String formType, HashMap dataTreeMap) throws ITMException {
        String retHTMLStr = "";
        try {
            String editFlag = (String)dataTreeMap.get("EDIT_FLAG");
            BaseLogger.log("3", this.userInfo, null, " 02112022 EDIT_FLAG::::: " + editFlag);
            String targetDir = String.valueOf(CommonConstants.APPLICATION_CONTEXT) + File.separator + "temp";
            ArrayList currentDomReqArr = this.createCurrentDomReq(dataTreeMap, objCtx, this.objName);
            ArrayList currentDomArray = (ArrayList)currentDomReqArr.get(0);
            ArrayList xmlDataList = this.itmWizardRemote.callEventManager(this.userInfo.getLoginCode(), this.objName, "default_data_wiz", objCtx, "", currentDomArray, "", "", "");
            String xmlData = (String)xmlDataList.get(0);
            String xslFileName = "";
            if (editFlag.equalsIgnoreCase("V")) {
                xslFileName = this.getXSLFileName(String.valueOf(this.objName) + objCtx + "_wiz_" + this.user_lang + "_" + this.user_country + "_" + "V" + ".xsl");
                BaseLogger.log("3", this.userInfo, null, " 02112022 VIEW::::: " + xslFileName);
            } else {
                xslFileName = this.getXSLFileName(String.valueOf(this.objName) + objCtx + "_wiz_" + this.user_lang + "_" + this.user_country + "_" + "A" + ".xsl");
                BaseLogger.log("3", this.userInfo, null, " 02112022 ELSE::::: " + xslFileName);
            }
            retHTMLStr = new E12GenericUtility().transformToString(xslFileName, xmlData, targetDir, "Output", ".html");
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return retHTMLStr;
    }

    public ArrayList createCurrentDomReq(HashMap dataTreeMap, String objContext, String objName) {
        ArrayList currentDomArrayReq = new ArrayList();
        try {
            ArrayList<String> dataArrayList = new ArrayList<String>();
            StringBuffer xmlStringBufHeader = new StringBuffer("<?xml version='1.0' encoding='" + CommonConstants.ENCODING + "'?>");
            xmlStringBufHeader.append("<DocumentRoot><description>Datawindow Root</description><group0><description>Group0 description</description><Header0><description>Header0 members</description>");
            StringBuffer xmlStringBufFooter = new StringBuffer("</Header0>");
            xmlStringBufFooter.append("</group0>").append("</DocumentRoot>");
            if (dataTreeMap != null) {
                Iterator iterator = dataTreeMap.keySet().iterator();
                String prevFormNo = "";
                String prevDomID = "";
                String currDomID = "1";
                StringBuffer xmlStringBuf = new StringBuffer();
                xmlStringBuf.append("<Detail" + objContext + " domID=\"" + currDomID + "\">");
                while (iterator.hasNext()) {
                    String tagName = (String)iterator.next();
                    String tagValue = (String)dataTreeMap.get(tagName);
                    xmlStringBuf.append("<" + tagName + "><![CDATA[" + tagValue + "]]></" + tagName + ">");
                }
                xmlStringBuf.append("</Detail" + objContext + ">");
                String currStr = String.valueOf(xmlStringBufHeader.toString()) + xmlStringBuf.toString() + xmlStringBufFooter.toString();
                dataArrayList.add(currStr);
            }
            currentDomArrayReq.add(dataArrayList);
        }
        catch (Exception e) {
            e.printStackTrace();
            BaseLogger.log("0", this.userInfo, null, "Exception::ITMException-->:" + e.getMessage());
        }
        return currentDomArrayReq;
    }

    public ArrayList getMessageDetailList(String objName) throws ITMException {
        ArrayList<String> msgColdataList = null;
        E12GenericUtility genericUtility = new E12GenericUtility();
        String fieldValue = "";
        String descr = "";
        ITMWizardStatefulRemote itmWizardRemoteTemp = null;
        try {
            try {
                msgColdataList = new ArrayList<String>();
                InitialContext ctx = new InitialContext(new AppConnectParm().getProperty());
                itmWizardRemoteTemp = (ITMWizardStatefulRemote)ctx.lookup("ibase/ITMWizardStatefulEJB/remote");
                String messageArgStr = itmWizardRemoteTemp.getSuccessMsgDetailList(objName, this.userInfo);
                itmWizardRemoteTemp.remove();
                itmWizardRemoteTemp = null;
                if (messageArgStr != null && messageArgStr.length() > 0 && messageArgStr.indexOf("prefix") != -1) {
                    Document dom = genericUtility.parseString(messageArgStr);
                    NodeList prfixNodList = dom.getElementsByTagName("prefix").item(0).getChildNodes();
                    int pFxNodListLen = prfixNodList.getLength();
                    int pCtr = 0;
                    while (pCtr < pFxNodListLen) {
                        Node pfxChildNode = prfixNodList.item(pCtr);
                        if (pfxChildNode != null && pfxChildNode.getNodeType() == 1 && pfxChildNode.getNodeName().equalsIgnoreCase("fld_value")) {
                            if (pfxChildNode.getFirstChild() != null) {
                                fieldValue = String.valueOf(fieldValue) + pfxChildNode.getFirstChild().getNodeValue();
                                BaseLogger.log("3", this.userInfo, null, " getting fieldValue from srv[" + fieldValue + "]");
                            }
                        } else if (pfxChildNode != null && pfxChildNode.getNodeType() == 1 && pfxChildNode.getNodeName().equalsIgnoreCase("descr") && pfxChildNode.getFirstChild() != null) {
                            descr = String.valueOf(descr) + pfxChildNode.getFirstChild().getNodeValue();
                            BaseLogger.log("3", this.userInfo, null, " getting descr from srv[" + descr + "]");
                        }
                        ++pCtr;
                    }
                }
                if (fieldValue != null && fieldValue.length() > 0) {
                    if (fieldValue.indexOf(",") != -1) {
                        StringTokenizer strTokenz = new StringTokenizer(fieldValue, ",");
                        while (strTokenz.hasMoreElements()) {
                            String strToken = strTokenz.nextToken();
                            msgColdataList.add(strToken);
                        }
                    } else {
                        msgColdataList.add(fieldValue);
                    }
                }
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        finally {
            if (itmWizardRemoteTemp != null) {
                itmWizardRemoteTemp.remove();
                itmWizardRemoteTemp = null;
            }
        }
        return msgColdataList;
    }

    public void remove() {
        try {
            if (this.itmWizardRemote != null) {
                new E12GenericUtility().writeFile("ITMWizardComp", " \n ITMWizardBean has been removed : UserId [," + this.userInfo.getLoginCode() + ",] objName[," + this.objName + ",] Time [," + new Date() + ",] ClassId [," + this.classId + ",] hostName[," + this.hostName + ",] hostIP[," + this.hostIP + ",]");
                BaseLogger.log("3", this.userInfo, null, "Remove ITMWizardStatefulEJB");
                this.itmWizardRemote.remove();
                this.itmWizardRemote = null;
            }
        }
        catch (Throwable e) {
            new E12GenericUtility().writeFile("ITMWizardCompException", " \n ITMWizardBean :: Exception has been coming while removing ejb component  :  [" + e.getMessage() + "],  UserId [," + this.userInfo.getLoginCode() + ",] objName[," + this.objName + ",] Time [," + new Date() + ",] ClassId [," + this.classId + ",] hostName[," + this.hostName + ",] hostIP[," + this.hostIP + ",]");
            BaseLogger.log("0", this.userInfo, null, "ITMWizardBean :: Exception has been coming while removing ejb component");
            e.printStackTrace();
        }
    }

    public String getFormData(String formNo) throws ITMException {
        String retHTMLStr = "";
        try {
            String targetDir = String.valueOf(CommonConstants.APPLICATION_CONTEXT) + File.separator + "temp";
            String xmlData = this.itmWizardRemote.getFormData(formNo);
            String xslFileName = this.getXSLFileName(String.valueOf(this.objName) + formNo + "_wiz_" + this.user_lang + "_" + this.user_country + "_" + "A" + ".xsl");
            retHTMLStr = new E12GenericUtility().transformToString(xslFileName, xmlData, targetDir, "Output", ".html");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ITMException(e);
        }
        return retHTMLStr;
    }

    public String getFormXmlData(String formNo) throws ITMException {
        String xmlData = "";
        try {
            String targetDir = String.valueOf(CommonConstants.APPLICATION_CONTEXT) + File.separator + "temp";
            xmlData = this.itmWizardRemote.getFormData(formNo);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ITMException(e);
        }
        return xmlData;
    }

    public ITMWizardBean(String objName, HttpSession sessionCtx, UserInfoBean userInfo) throws ITMException {
        try {
            this.objName = objName;
            this.sessionCtx = sessionCtx;
            this.userInfo = (UserInfoBean)this.sessionCtx.getAttribute("USER_INFO");
            this.user_lang = this.userInfo.getUserLanguage();
            this.user_country = this.userInfo.getUserCountry();
            if (this.itmWizardRemote == null) {
                InitialContext ctx = new InitialContext(new AppConnectParm().getProperty());
                this.itmWizardRemote = (ITMWizardStatefulRemote)ctx.lookup("ibase/ITMWizardStatefulEJB/remote");
                this.itmWizardRemote.setUserInfo(this.userInfo);
                this.itmWizardRemote.loadFormsMetaData(this.objName, "1", String.valueOf(this.objName) + "21", this.userInfo.getEmpCode(), this.userInfo.getProfileId(), userInfo);
            }
        }
        catch (ITMException itme) {
            this.itmWizardRemote.remove();
            this.itmWizardRemote = null;
            throw itme;
        }
        catch (Exception e) {
            this.itmWizardRemote.remove();
            this.itmWizardRemote = null;
            throw new ITMException(e);
        }
    }

    public String getActivityCodeList(String salesPers, String selectedActCode, String transDB) {
        String activityCodeData = "";
        ITMWizardStatefulRemote itmWizardRemoteTemp = null;
        try {
            try {
                BaseLogger.log("3", this.userInfo, null, "ITMWizardBean:getActivityCodeList:transDB=[" + transDB + "]");
                InitialContext ctx = new InitialContext(new AppConnectParm().getProperty());
                itmWizardRemoteTemp = (ITMWizardStatefulRemote)ctx.lookup("ibase/ITMWizardStatefulEJB/remote");
                if (transDB != null && transDB.trim().length() > 0) {
                    activityCodeData = itmWizardRemoteTemp.getActivityCodeList(salesPers, selectedActCode, transDB);
                }
                itmWizardRemoteTemp.remove();
                itmWizardRemoteTemp = null;
                String xslFileName = this.getXSLFileName("strg_meet_act_code_wiz_" + this.user_lang + "_" + this.user_country + ".xsl");
                activityCodeData = new E12GenericUtility().transformToString(xslFileName, activityCodeData, String.valueOf(CommonConstants.APPLICATION_CONTEXT) + File.separator + "temp", "Output", ".html");
            }
            catch (Exception e) {
                e.printStackTrace();
                if (itmWizardRemoteTemp != null) {
                    itmWizardRemoteTemp.remove();
                    itmWizardRemoteTemp = null;
                }
            }
        }
        finally {
            if (itmWizardRemoteTemp != null) {
                itmWizardRemoteTemp.remove();
                itmWizardRemoteTemp = null;
            }
        }
        return activityCodeData;
    }

    public String callEventManager(String eventCode, String objContext, String domId, ArrayList dataArrayList, String action, String formType, String forceSave, String tranID, UserInfoBean userInfo) throws ITMException {
        return this.callEventManager(eventCode, objContext, domId, dataArrayList, action, formType, forceSave, tranID, userInfo, "");
    }

    public String callEventManager(String eventCode, String objContext, String domId, ArrayList dataArrayList, String action, String formType, String forceSave, String tranID, UserInfoBean userInfo, String editFlag) throws ITMException {
        String retHTMLStr = "";
        try {
            ArrayList xmlDataList = this.itmWizardRemote.callEventManager(this.userInfo.getLoginCode(), this.objName, eventCode, objContext, domId, dataArrayList, action, formType, forceSave, tranID, userInfo);
            String xmlData = (String)xmlDataList.get(0);
            xmlData = new E12GenericUtility().setXmlDec(xmlData);
            if (xmlData != null && xmlData.length() > 0) {
                String targetDir = String.valueOf(CommonConstants.APPLICATION_CONTEXT) + File.separator + "temp";
                if (xmlData.indexOf("<error") == -1) {
                    int objCtxInt = Integer.parseInt(objContext);
                    if (eventCode.equals("pre_navigate") && "next".equalsIgnoreCase(action)) {
                        BaseLogger.log("3", userInfo, null, " Calling next Click.............");
                        if (formType != null && formType.indexOf("MP:") != -1) {
                            objCtxInt = Integer.parseInt(formType.substring(formType.lastIndexOf(":") + 1));
                            BaseLogger.log("3", userInfo, null, " Calling next Click............objCtxInt.[" + objCtxInt + "]");
                        } else {
                            ++objCtxInt;
                        }
                    } else if (eventCode.equals("pre_navigate") && "previous".equalsIgnoreCase(action)) {
                        BaseLogger.log("3", userInfo, null, " Calling Previous Click.............");
                        if (formType != null && formType.indexOf(":MP") != -1) {
                            objCtxInt = Integer.parseInt(formType.substring(0, formType.indexOf(":")));
                            BaseLogger.log("3", userInfo, null, " Calling Previous Click.............objCtxInt[" + objCtxInt + "]");
                        } else {
                            --objCtxInt;
                        }
                    } else if (xmlData.indexOf("Detail1") != -1) {
                        objCtxInt = 1;
                    }
                    objContext = "" + objCtxInt;
                    BaseLogger.log("3", userInfo, null, " this.beanXmlDataMap.put objCtxInt [" + objCtxInt + "]");
                } else {
                    BaseLogger.log("3", userInfo, null, "Getting data from  Appending Error Node ");
                    xmlData = this.appendErrorNode((String)dataArrayList.get(0), xmlData);
                }
                if (retHTMLStr.length() == 0) {
                    xmlData = new E12GenericUtility().setXmlDec(xmlData);
                    String xslFileName = "";
                    if (editFlag.equalsIgnoreCase("V")) {
                        xslFileName = this.getXSLFileName(String.valueOf(this.objName) + objContext + "_wiz_" + this.user_lang + "_" + this.user_country + "_" + "V" + ".xsl");
                        BaseLogger.log("3", userInfo, null, " 02112022-975 VIEW::::: " + xslFileName);
                    } else {
                        xslFileName = this.getXSLFileName(String.valueOf(this.objName) + objContext + "_wiz_" + this.user_lang + "_" + this.user_country + "_" + "A" + ".xsl");
                        BaseLogger.log("3", userInfo, null, " 02112022-980 ELSE::::: " + xslFileName);
                    }
                    retHTMLStr = new E12GenericUtility().transformToString(xslFileName, xmlData, targetDir, "Output", ".html");
                    BaseLogger.log("3", userInfo, null, "Getting data from  getXSLFileName [" + xslFileName + "] ");
                    BaseLogger.log("3", userInfo, null, "Getting data from  getXSLFileName [" + targetDir + "] ");
                }
            }
        }
        catch (ITMException itme) {
            itme.printStackTrace();
            throw itme;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ITMException(e);
        }
        return retHTMLStr;
    }

    public double getClassId() {
        return this.classId;
    }

    public void setClassId(double classId) {
        this.classId = classId;
    }

    public String getObjName() {
        return this.objName;
    }

    public void setObjName(String objName) {
        this.objName = objName;
    }

    public void setEditorId(String editorId) throws ITMException, RemoteException {
        try {
            if (this.itmWizardRemote != null) {
                this.itmWizardRemote.setEditorId(editorId);
            }
        }
        catch (RemoteException e) {
            throw new ITMException(e);
        }
        catch (ITMException e) {
            throw new ITMException(e);
        }
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getHostIP() {
        return this.hostIP;
    }
}

