/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.angular;

import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.angular.GenerateComponentLayout;
import ibase.webitm.angular.GenerateHTMLFormLayout;
import ibase.webitm.angular.GenerateModuleLayout;
import ibase.webitm.angular.GenerateServiceLayout;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.utility.ITMException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import javax.naming.InitialContext;

public class BuildAngularLayout {
    static String DEFAULT_PATH = "";

    public void buildANGComponent(String objName, HashMap<String, String> propEditorInfoMap, UserInfoBean userInfo) throws RemoteException, ITMException {
        BaseLogger.log("2", userInfo, null, "BuildAngularLayout: buildANGComponent");
        String pageContext = "2";
        String objContext = "1";
        String sql = "";
        String formNo = "";
        Connection conn = null;
        Statement pstmt = null;
        ResultSet rs = null;
        String winName = "w_" + objName;
        String formTitle = "";
        HashMap<String, Object> paramMap = null;
        StringBuffer HTML = new StringBuffer();
        String firstFormTitle = null;
        try {
            try {
                E12GenericUtility genericUtility = new E12GenericUtility();
                DEFAULT_PATH = genericUtility.getAngCompFilePath(propEditorInfoMap, userInfo.getTransDB(), objName);
                BaseLogger.log("3", userInfo, null, "DEFAULT_PATH filePath->>>> " + DEFAULT_PATH);
                ConnDriver connDriver = new ConnDriver();
                conn = connDriver.getConnectDB(userInfo.getTransDB());
                GenerateHTMLFormLayout formLayout = null;
                sql = "SELECT TITLE,FORM_NO FROM OBJ_FORMS WHERE WIN_NAME = ? order by TO_NUMBER(FORM_NO)";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, winName);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    formNo = rs.getString("FORM_NO");
                    formTitle = rs.getString("TITLE");
                    String tempHTML = "";
                    formLayout = new GenerateHTMLFormLayout(userInfo);
                    if (!formNo.equalsIgnoreCase("1")) {
                        pageContext = "2";
                        objContext = formNo;
                        paramMap = this.getObjParamMap(objName, objContext, userInfo);
                        boolean isTaxApplicable = (Boolean)paramMap.get("IS_TAX_APPL");
                        formLayout.setLocaleLabels(objName, objContext, pageContext, propEditorInfoMap, userInfo);
                        tempHTML = formLayout.getDetailHTML(this.getObjParamMap(objName, objContext, userInfo), userInfo, formTitle);
                    } else {
                        formLayout.setLocaleLabels(objName, objContext, pageContext, propEditorInfoMap, userInfo);
                        tempHTML = formLayout.getHeaderHTML(this.getObjParamMap(objName, objContext, userInfo), userInfo, formTitle);
                        if (firstFormTitle == null) {
                            firstFormTitle = formTitle;
                        }
                    }
                    HTML.append(tempHTML);
                    BaseLogger.log("3", userInfo, null, "buildANGComponent formNo :[" + formNo + "]\n HTML [" + HTML + "]");
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (firstFormTitle != null) {
                    formLayout.buildHTMLandCSSFile(HTML.toString(), firstFormTitle);
                } else {
                    formLayout.buildHTMLandCSSFile(HTML.toString(), formTitle);
                }
                GenerateModuleLayout moduleLayout = new GenerateModuleLayout();
                moduleLayout.buildAngModuleTSFile(objName, userInfo);
                GenerateComponentLayout componentLayout = new GenerateComponentLayout();
                componentLayout.buildAngCompTSFile(objName, userInfo);
                GenerateServiceLayout serviceLayout = new GenerateServiceLayout();
                serviceLayout.buildAngServiceTSFile(objName, userInfo);
                String srcFilepath = "";
                String destinationFileName = "";
                srcFilepath = CommonConstants.APPLICATION_CONTEXT != null ? CommonConstants.APPLICATION_CONTEXT : ".." + File.separator + "webapps" + File.separator + "ibase" + File.separator;
                srcFilepath = String.valueOf(srcFilepath) + File.separator + "angular" + File.separator + "component-templates" + File.separator + "date.adapter.ts";
                this.buildDependencyFiles(srcFilepath, "date.adapter.ts");
            }
            catch (ITMException itme) {
                BaseLogger.log("0", userInfo, null, "ITMException: BuildAngularLayout: buildANGComponent:==>" + itme);
                throw itme;
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception: BuildAngularLayout: buildANGComponent:==>" + e);
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }

    public HashMap<String, Object> getObjParamMap(String objName, String objContext, UserInfoBean userInfo) throws ITMException {
        HashMap<String, Object> paramMap = null;
        try {
            InitialContext initialContext = new InitialContext(new AppConnectParm().getProperty());
            DBAccessEJB dbAccess = new DBAccessEJB();
            HashMap objDetailMap = dbAccess.getObjDetailMap(objName, userInfo);
            paramMap = new HashMap<String, Object>();
            if (objDetailMap != null) {
                paramMap.put("KEY_FLAG", objDetailMap.get("KEY_FLAG") != null ? (String)objDetailMap.get("KEY_FLAG") : "M");
                ArrayList taxList = this.getTokenList((String)objDetailMap.get("TAX_FORMS"), ",");
                Boolean isTaxApplicable = new Boolean(false);
                if (taxList != null && taxList.contains(objContext)) {
                    isTaxApplicable = new Boolean(true);
                }
                paramMap.put("IS_TAX_APPL", isTaxApplicable);
                paramMap.put("EDIT_TMPLT", objDetailMap.get("EDIT_TMPLT") != null ? new Integer((String)objDetailMap.get("EDIT_TMPLT")) : new Integer("0"));
            }
            dbAccess = null;
        }
        catch (Exception e) {
            BaseLogger.log("0", userInfo, null, "Exception :GenerateTranLayout :setObjDetails :==>" + e);
            throw new ITMException(e);
        }
        BaseLogger.log("2", userInfo, null, "[GenerateTranLayout]Obj name and other initializations done !!!!!!!!!!!!!");
        return paramMap;
    }

    private ArrayList getTokenList(String tokenString, String delimiter) throws Exception {
        BaseLogger.log("2", null, null, "[GenerateTranLayout]Getting arraylist from the string :" + tokenString + ": delimiter :" + delimiter + ":");
        ArrayList<String> returnList = null;
        if (tokenString != null && tokenString.length() > 0 && tokenString != "") {
            returnList = new ArrayList<String>();
            if (delimiter.length() == 1) {
                while (tokenString.indexOf(delimiter) != -1) {
                    int endIndex = tokenString.indexOf(delimiter);
                    returnList.add(tokenString.substring(0, endIndex));
                    tokenString = tokenString.substring(endIndex + 1, tokenString.length());
                }
                returnList.add(tokenString.substring(0, tokenString.length()));
            } else if (delimiter.length() == 2 && (delimiter.equals("[]") || delimiter.equals("{}") || delimiter.equals("()"))) {
                while (tokenString.indexOf(delimiter.substring(0, 1)) != -1) {
                    int endIndex = tokenString.indexOf(delimiter.substring(1));
                    returnList.add(tokenString.substring(1, endIndex));
                    tokenString = tokenString.substring(endIndex + 1, tokenString.length());
                }
            }
        }
        return returnList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeFile(String fileName, String fileContent) throws IOException {
        BaseLogger.log("3", null, null, "GenerateAngFileLayout: writeFile filePath :==> [" + DEFAULT_PATH + "] fileCOntent [" + fileContent + "]");
        OutputStream fos = null;
        try {
            try {
                File file = new File(DEFAULT_PATH, fileName);
                byte[] buffer = fileContent.getBytes();
                int bytes = buffer.length;
                fos = new FileOutputStream(file);
                ((FileOutputStream)fos).write(buffer, 0, bytes);
                fos.flush();
                ((FileOutputStream)fos).close();
                fos = null;
                return;
            }
            catch (IOException ie) {
                BaseLogger.log("0", null, null, "IOException :writeFile ::::::::::::==>" + ie);
                if (fos == null) return;
                fos.flush();
                ((FileOutputStream)fos).close();
                fos = null;
                return;
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception :writeFile ::::::::::::==>" + e);
                if (fos == null) return;
                fos.flush();
                ((FileOutputStream)fos).close();
                fos = null;
                return;
            }
        }
        finally {
            if (fos != null) {
                fos.flush();
                ((FileOutputStream)fos).close();
                fos = null;
            }
        }
    }

    public void buildDependencyFiles(String srcFilePath, String destFileName) throws RemoteException, ITMException {
        try {
            String destFilePath = String.valueOf(DEFAULT_PATH) + File.separator + destFileName;
            E12GenericUtility genericutility = new E12GenericUtility();
            File srcFile = new File(srcFilePath);
            File destFile = new File(destFilePath);
            genericutility.copyFile(srcFile, destFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ITMException(e);
        }
    }
}

