

package ibase.webitm.ejb.wsfa.transactions;

import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.ejb.ITMDBAccessEJB;
//import ibase.webitm.utility.GenericUtility;
import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TransIDGenerator;
import ibase.utility.CommonConstants;

import java.rmi.RemoteException;
import java.sql.*;
import java.text.SimpleDateFormat;

import org.w3c.dom.*;

import javax.ejb.Stateless;
import java.util.*;
import java.io.*;

import javax.ejb.EJBException;


//@Stateless		commented by Sagar M [22 Nov 2018].
public class DCRConfirmation extends ValidatorEJB implements DCRConfirmationLocal, DCRConfirmationRemote
{

	public String postSave() throws RemoteException,ITMException
	{
		return "";
	}
	public String postSaveRec() throws RemoteException, ITMException
	{
		return "";
	}
	public String postSaveRec(String xmlString1, String domId, String objContext, String editFlag, String xtraParams, Connection conn) throws RemoteException, ITMException
	{
		return "";
	}

	@Override
	public String postSave(String xmlStringAll, String editFlag, String xtraParams, Connection conn) throws RemoteException,ITMException
	{

		String retString="";

		PreparedStatement pstmtUpdate = null;

		try
		{
			System.out.println("PostSave Action Called:::");
			NodeList hdrDom = null;
			NodeList detail2dom = null;
			Document dom = null;

			//changed by Rahul Barve on 3-sep-2014
			//GenericUtility genericUtility = GenericUtility.getInstance();
			 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();


			System.out.println("xmlStringAll::"+xmlStringAll);

			dom = genericUtility.parseString(xmlStringAll);
			hdrDom = dom.getElementsByTagName("Detail1");

			String eventDate = checkNull(genericUtility.getColumnValue("event_date", dom, "1"));
			String salesPers = checkNull(genericUtility.getColumnValue("sales_pers", dom, "1"));

			java.sql.Timestamp currDate = new Timestamp(System.currentTimeMillis());

			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			java.util.Date newCurrDate = new java.util.Date();

			eventDate = genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );

			String updateSql = "update sprs_act_tran set confirmed ='Y' , conf_date = ? where sales_pers = ? and event_date = ?";
			pstmtUpdate = conn.prepareStatement( updateSql );

			pstmtUpdate.setTimestamp(1, currDate);
			pstmtUpdate.setString(2, salesPers);
			pstmtUpdate.setTimestamp(3, java.sql.Timestamp.valueOf(eventDate));
			int updCnt = pstmtUpdate.executeUpdate();
			if(updCnt > 0 )
			{
				System.out.println("Updated successfully =["+updCnt+"]");
			}

			// Start Block Added By  Shahu Mali 28-11-2012
			String drMainUpdateSql = "update dr_main set confirmation_flag ='Y' , last_update = ? where sales_pers = ? and work_date = ?";
			pstmtUpdate = conn.prepareStatement( drMainUpdateSql );
			pstmtUpdate.setTimestamp(1, currDate);
			pstmtUpdate.setString(2, salesPers);
			pstmtUpdate.setTimestamp(3, java.sql.Timestamp.valueOf(eventDate));
			int updDRMainCnt = pstmtUpdate.executeUpdate();
			if(updDRMainCnt > 0 )
			{
				System.out.println("Updated confirmation flag successfully in dr_main =["+updDRMainCnt+"]");
			}

			pstmtUpdate.close();
			pstmtUpdate = null;
			// END Block Added By  Shahu Mali 28-11-2012

		}
		catch( Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (pstmtUpdate !=null )
				{
					pstmtUpdate.close();
					pstmtUpdate = null;
				}
			}
			catch (Exception e)
			{
			}
		}
		return retString;
	}

	//to check if input is null or "null"
	public String checkNull(String input)
	{
		if (input == null || "null".equalsIgnoreCase(input))
		{
			input= "";
		}
		return input;
	}
	public String checkNullAndTrim(String input)
	{
		if (input == null || "null".equalsIgnoreCase(input))
		{
			input= "";
		}
		return input.trim();
	}
	private String getObjNameFromDom( Document dom, String attribute, String objContext ) throws RemoteException,ITMException
	{
		NodeList detailList = null;
		Node currDetail = null;
		String objName = "";
		int detailListLength = 0;

		try
		{
			detailList = dom.getElementsByTagName("Detail"+objContext);
			detailListLength = detailList.getLength();
			for (int ctr = 0; ctr < detailListLength; ctr++)
			{
				currDetail = detailList.item(ctr);
				objName = currDetail.getAttributes().getNamedItem(attribute).getNodeValue();
			}
		}
		catch ( Exception e )
		{
			throw new ITMException(e);
		}
		System.out.println("objName =["+objName+"]");
		return objName;
	}
}// END OF MAIN CLASS