/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.ejb;

import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.ejb.ITMFilterLocal;
import ibase.webitm.ejb.ITMFilterRemote;
import ibase.webitm.utility.DWFactory;
import ibase.webitm.utility.DWObject;
import ibase.webitm.utility.ITMException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.annotation.Resource;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Stateless
public class ITMFilterEJB
implements ITMFilterRemote,
ITMFilterLocal {
    Locale curLocale;
    transient ResourceBundle resourceLabels;
    String language = new String("en");
    String country = new String("US");
    private ArrayList objFormsDetailList = null;
    private HashMap<String, String> objFormInfoMap = null;
    private String OBJ_INFO_SEPARATOR = ";";
    @Resource
    private SessionContext sessionContext;

    public void ejbCreate() {
    }

    public void ejbRemove() {
    }

    public void ejbActivate() {
    }

    public void ejbPassivate() {
    }

    @Override
    public String getFilterInfoString(String lsObjName, UserInfoBean userInfo) throws RemoteException, ITMException {
        StringBuffer argStrBuff = new StringBuffer();
        this.country = this.country;
        this.language = this.language;
        try {
            String sNames = null;
            StringTokenizer stNames = null;
            HashMap defValMap = this.createDefValueMap(lsObjName, userInfo);
            DWFactory dwFactory = new DWFactory(userInfo);
            BaseLogger.log("3", userInfo, null, " before: FROM getFilterInfoString");
            this.objFormsDetailList = null;
            this.getObjFormDetail(lsObjName, userInfo);
            String formName = this.getFormName("1");
            DWObject dw = dwFactory.getDataWindow(String.valueOf(lsObjName) + "1" + formName);
            BaseLogger.log("3", userInfo, null, " after: FROM getFilterInfoString");
            ArrayList argNamesList = dw.getArgNamesList();
            BaseLogger.log("3", userInfo, null, " after: FROM ArrayList");
            argStrBuff.append("<FORMALARGS>");
            String type = null;
            String dateType = null;
            BaseLogger.log("3", userInfo, null, " 0: outside Loop");
            if (argNamesList.size() > 0) {
                int i = 0;
                while (i < argNamesList.size()) {
                    BaseLogger.log("3", userInfo, null, " 0: Inside Loop");
                    String field_name = null;
                    String name = null;
                    sNames = (String)argNamesList.get(i);
                    BaseLogger.log("3", userInfo, null, " 0: FROM getFilterInfoString");
                    stNames = new StringTokenizer(sNames, "~");
                    while (stNames.hasMoreTokens()) {
                        field_name = stNames.nextToken();
                        name = stNames.nextToken();
                        type = stNames.nextToken();
                    }
                    String lsFormAttr = name;
                    BaseLogger.log("3", userInfo, null, " 0: FROM getFilterInfoString");
                    this.curLocale = new Locale(this.language, this.country);
                    BaseLogger.log("3", userInfo, null, " 1: FROM getFilterInfoString");
                    BaseLogger.log("3", userInfo, null, "[ITMFilterEJB]Creating ResourceBundle for the Resource==>" + lsObjName + "1" + formName + "Arg");
                    try {
                        String propertiesFileURL = String.valueOf(CommonConstants.RESOURCE_PROFILE_PATH) + File.separator + lsObjName + "1" + formName + "Arg" + "_" + this.curLocale.toString() + ".properties";
                        File argPropertiesFile = new File(propertiesFileURL);
                        this.resourceLabels = argPropertiesFile.exists() ? new PropertyResourceBundle(new FileInputStream(argPropertiesFile)) : ResourceBundle.getBundle(String.valueOf(lsObjName) + "1" + formName + "Arg", this.curLocale);
                        lsFormAttr = this.resourceLabels.getString(name) != null ? this.resourceLabels.getString(name) : lsFormAttr;
                    }
                    catch (MissingResourceException mre) {
                        BaseLogger.log("3", userInfo, null, "Exception :ITMFilterEJB :getFilterInfoString =>MissingResourceException :" + mre.getMessage());
                    }
                    argStrBuff.append("<FORMALARG field_name='" + field_name + "' name='" + lsFormAttr + "' javatype='" + type + "'>");
                    if (defValMap != null && defValMap.containsKey(field_name)) {
                        argStrBuff.append("<value>" + defValMap.get(field_name) + "</value>");
                    }
                    argStrBuff.append("</FORMALARG>");
                    if ("datetime".equalsIgnoreCase(type) || "date".equalsIgnoreCase(type)) {
                        dateType = type;
                    }
                    ++i;
                }
                if ("datetime".equalsIgnoreCase(dateType) || "date".equalsIgnoreCase(type)) {
                    argStrBuff.append(this.getPeriodInfo(userInfo));
                }
            }
            dw.remove();
        }
        catch (ITMException itme) {
            BaseLogger.log("0", userInfo, null, "ITMException :ITMFilterEJB :getFilterInfoString :==>");
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", userInfo, null, "Exception :ITMFilterEJB :getFilterInfoString :==>" + e);
            throw new ITMException(e);
        }
        argStrBuff.append("</FORMALARGS>");
        return argStrBuff.toString();
    }

    private String getPeriodInfo(UserInfoBean userInfo) throws RemoteException, ITMException {
        Connection conn = null;
        Statement statement = null;
        StringBuffer periodInfoXMLBuff = null;
        String prdCode = null;
        try {
            try {
                E12GenericUtility genericUtility = new E12GenericUtility();
                periodInfoXMLBuff = new StringBuffer();
                String transDB = userInfo.getTransDB();
                ConnDriver conDriver = new ConnDriver();
                conn = conDriver.getConnectDB(transDB);
                statement = conn.createStatement();
                String sPrdSql = "SELECT PRD_CODE FROM PARAMETER";
                ResultSet rs = statement.executeQuery(sPrdSql);
                if (rs.next()) {
                    prdCode = rs.getString(1);
                }
                rs.close();
                String selQry = "SELECT CODE, FR_DATE, TO_DATE FROM PERIOD ORDER BY FR_DATE";
                BaseLogger.log("3", userInfo, null, "*******************************************Before rs");
                rs = statement.executeQuery(selQry);
                BaseLogger.log("3", userInfo, null, "***********************************************After rs");
                periodInfoXMLBuff.append("<DEFAULT_CODE><![CDATA[" + prdCode + "]]></DEFAULT_CODE>\n");
                while (rs.next()) {
                    periodInfoXMLBuff.append("<PERIOD>\n");
                    periodInfoXMLBuff.append("<CODE><![CDATA[" + rs.getString("CODE") + "]]></CODE>\n");
                    String fromDate = genericUtility.getValidDateString(rs.getDate("FR_DATE").toString(), genericUtility.getDBDateFormat(), genericUtility.getApplDateFormat());
                    periodInfoXMLBuff.append("<FR_DATE><![CDATA[" + fromDate + "]]></FR_DATE>\n");
                    String toDate = genericUtility.getValidDateString(rs.getDate("TO_DATE").toString(), genericUtility.getDBDateFormat(), genericUtility.getApplDateFormat());
                    periodInfoXMLBuff.append("<TO_DATE><![CDATA[" + toDate + "]]></TO_DATE>\n");
                    periodInfoXMLBuff.append("</PERIOD>\n");
                }
                rs.close();
                rs = null;
                statement.close();
                statement = null;
            }
            catch (ITMException itme) {
                BaseLogger.log("0", userInfo, null, "ITMException :ITMFilterEJB :getPeriodInfo :==>");
                throw itme;
            }
            catch (SQLException ie) {
                BaseLogger.log("0", userInfo, null, "Exception :ITMFilterEJB :getPeriodInfo :==>" + ie);
                ie.printStackTrace();
                throw new ITMException(ie);
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception :ITMFilterEJB :getPeriodInfo :==>" + e);
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (conn != null) {
                    if (statement != null) {
                        statement.close();
                        statement = null;
                    }
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        return periodInfoXMLBuff.toString();
    }

    private HashMap createDefValueMap(String lsObjName, UserInfoBean userInfo) throws ITMException {
        HashMap<String, String> defValMap = null;
        Connection conn = null;
        Statement statement = null;
        ResultSet rs = null;
        try {
            try {
                String transDB = userInfo.getTransDB();
                ConnDriver conDriver = new ConnDriver();
                conn = conDriver.getConnectDB(transDB);
                String selQry = "SELECT FORMAL_ARGS FROM TRANSETUP WHERE TRAN_WINDOW = 'w_" + lsObjName + "'";
                statement = conn.createStatement();
                rs = statement.executeQuery(selQry);
                String xmlStr = null;
                if (rs.next()) {
                    xmlStr = rs.getString(1);
                }
                if (xmlStr != null) {
                    defValMap = new HashMap<String, String>();
                    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                    DocumentBuilder db = dbf.newDocumentBuilder();
                    Document doc = db.parse(new ByteArrayInputStream(xmlStr.getBytes()));
                    NodeList nodeList = doc.getElementsByTagName("formal_arg");
                    int noOfFilter = nodeList.getLength();
                    int iCnt = 0;
                    while (iCnt < noOfFilter) {
                        Node nameNode = nodeList.item(iCnt);
                        if (nameNode != null) {
                            NodeList childList = nameNode.getChildNodes();
                            int noOfChild = childList.getLength();
                            String argName = null;
                            String argValue = null;
                            int jCnt = 0;
                            while (jCnt < noOfChild) {
                                Node colNode = childList.item(jCnt);
                                if (colNode != null && colNode.getNodeName().equalsIgnoreCase("name")) {
                                    argName = colNode.getFirstChild().getNodeValue();
                                }
                                if (colNode != null && colNode.getNodeName().equalsIgnoreCase("value")) {
                                    argValue = colNode.getFirstChild().getNodeValue();
                                }
                                ++jCnt;
                            }
                            defValMap.put(argName, argValue);
                        }
                        ++iCnt;
                    }
                }
            }
            catch (ITMException itme) {
                BaseLogger.log("0", userInfo, null, "ITMException :ITMFilterEJB :createDefValueMap :==>");
                throw itme;
            }
            catch (SQLException ie) {
                BaseLogger.log("0", userInfo, null, "SQLException :ITMFilterEJB :createDefValueMap :==>" + ie);
                ie.printStackTrace();
                throw new ITMException(ie);
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception :ITMFilterEJB :createDefValueMap :==>" + e);
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (conn != null) {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (statement != null) {
                        statement.close();
                        statement = null;
                    }
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        return defValMap;
    }

    private void getObjFormDetail(String objName, UserInfoBean userInfo) {
        try {
            if (this.objFormsDetailList == null) {
                DBAccessEJB dbAccess = new DBAccessEJB();
                this.objFormsDetailList = dbAccess.getObjFormsDetailList(objName, userInfo);
                this.setObjFormInfoMap(this.objFormsDetailList);
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (ITMException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setObjFormInfoMap(ArrayList dbValues) {
        try {
            if (this.objFormInfoMap == null) {
                this.objFormInfoMap = new HashMap();
            }
            int i = 0;
            while (i < dbValues.size()) {
                ArrayList currForm = (ArrayList)dbValues.get(i);
                String title = (String)currForm.get(0);
                String objContext = (String)currForm.get(14);
                String scrType = currForm.get(15) == null ? "" : currForm.get(15);
                String dbFormType = currForm.get(16) == null ? "" : currForm.get(16);
                String formName = currForm.get(32) == null ? "" : currForm.get(32);
                String parentKeyCol = currForm.get(18) == null ? "" : currForm.get(18);
                BaseLogger.log("3", null, null, "objContext =[" + objContext + "], formName =[" + formName + "]");
                this.objFormInfoMap.put(objContext, String.valueOf(dbFormType) + this.OBJ_INFO_SEPARATOR + parentKeyCol + this.OBJ_INFO_SEPARATOR + scrType + this.OBJ_INFO_SEPARATOR + formName);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BaseLogger.log("2", null, null, "DB2XMLGenerator >> setObjFormInfoMap >> this.objFromInfoMap ::" + this.objFormInfoMap);
    }

    private String getObjPropValue(String formNo, String objPropName) {
        String value;
        block11: {
            value = "";
            if (this.objFormInfoMap != null) break block11;
            BaseLogger.log("3", null, null, String.valueOf(objPropName) + "= []");
            return "";
        }
        try {
            String objFromInfo = this.objFormInfoMap.get(formNo);
            if (objFromInfo != null) {
                String[] strArr = objFromInfo.split(this.OBJ_INFO_SEPARATOR);
                if ("FORM_TYPE".equalsIgnoreCase(objPropName)) {
                    value = strArr != null && strArr.length > 0 ? strArr[0] : "";
                } else if ("PARENT_KEY_COL".equalsIgnoreCase(objPropName)) {
                    value = strArr != null && strArr.length > 1 ? strArr[1] : "";
                } else if ("SCR_FLAG".equalsIgnoreCase(objPropName)) {
                    value = strArr != null && strArr.length > 2 ? strArr[2] : "";
                } else if ("FORM_NAME".equalsIgnoreCase(objPropName)) {
                    value = strArr != null && strArr.length > 3 ? strArr[3] : "";
                }
            }
            BaseLogger.log("3", null, null, String.valueOf(objPropName) + "= [" + value + "]");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BaseLogger.log("2", null, null, String.valueOf(objPropName) + "= [" + value + "]");
        return value;
    }

    private String getFormName(String formNo) {
        String formName = this.getObjPropValue(formNo, "FORM_NAME");
        if (formName == null || formName.length() == 0) {
            formName = formNo;
        }
        return formName;
    }
}

