/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.ejb;

import ibase.ejb.CommonDBAccessEJB;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.utility.ITMException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.Iterator;
import org.json.JSONObject;

public class ItemAttributesJB {
    public String getAttributes(String refSer, String refId, String itemCode, UserInfoBean userInfo) throws Exception {
        BaseLogger.log("3", userInfo, null, "ItemAttributesJB.getAttributes()");
        String result = "";
        Connection con = null;
        Statement pstmt = null;
        ResultSet resultSet = null;
        try {
            try {
                String itemType = "";
                ConnDriver mConnDriver = new ConnDriver();
                con = mConnDriver.getConnectDB(userInfo.getTransDB());
                String itemSql = "SELECT ITEM_TYPE FROM ITEM WHERE ITEM_CODE = ?";
                pstmt = con.prepareStatement(itemSql);
                pstmt.setString(1, itemCode);
                resultSet = pstmt.executeQuery();
                if (resultSet.next()) {
                    itemType = resultSet.getString("ITEM_TYPE");
                    BaseLogger.log("3", null, null, "ItemAttributesJB.getAttributes() ITEM_TYPE : [" + itemType + "]");
                }
                resultSet.close();
                resultSet = null;
                pstmt.close();
                pstmt = null;
                JSONObject itemAttribObj = new JSONObject();
                if (itemType != null && itemType.length() > 0) {
                    String sql = "SELECT ATTRIB_HEADING, ATTRIB_VALUE, ATTRIB_NO FROM TRANS_ITEM_ATTRIBUTES WHERE REF_SER = ? AND REF_ID = ? AND ITEM_TYPE = ?";
                    pstmt = con.prepareStatement(sql);
                    pstmt.setString(1, refSer);
                    pstmt.setString(2, refId);
                    pstmt.setString(3, itemType);
                    resultSet = pstmt.executeQuery();
                    while (resultSet.next()) {
                        JSONObject itemAttribSubObj = new JSONObject();
                        String attribheading = ItemAttributesJB.checkNull(resultSet.getString("ATTRIB_HEADING"));
                        String attribValue = ItemAttributesJB.checkNull(resultSet.getString("ATTRIB_VALUE"));
                        int attribNo = resultSet.getInt("ATTRIB_NO");
                        if (attribheading == null || "".equals(attribheading)) continue;
                        itemAttribSubObj.put(attribheading, (Object)attribValue);
                        itemAttribObj.put(Integer.toString(attribNo), (Object)itemAttribSubObj);
                    }
                    resultSet.close();
                    resultSet = null;
                    pstmt.close();
                    pstmt = null;
                    if (itemAttribObj.length() == 0) {
                        CommonDBAccessEJB commonDBAccessEJB = new CommonDBAccessEJB();
                        String startDynAttr = E12GenericUtility.checkNull(commonDBAccessEJB.getDBColumnValue("ITEM_TYPE", "START_DYN_ATTR", "WHERE ITEM_TYPE = '" + itemType + "'", userInfo.getTransDB()));
                        BaseLogger.log("3", null, null, "ItemAttributesJB.getAttributes() START_DYN_ATTR index : [" + startDynAttr + "]");
                        int startDynamicIndex = startDynAttr == null || startDynAttr == "" ? 0 : Integer.valueOf(startDynAttr);
                        BaseLogger.log("3", null, null, "ItemAttributesJB.getAttributes() startDynamicIndex : [" + startDynamicIndex + "]");
                        String selectQry = "SELECT ATTRIBUTE.* FROM ITEM_TYPE ATTRIBUTE WHERE ITEM_TYPE = ?";
                        pstmt = con.prepareStatement(selectQry);
                        pstmt.setString(1, itemType);
                        resultSet = pstmt.executeQuery();
                        ResultSetMetaData rsmd = resultSet.getMetaData();
                        int numberOfColumns = rsmd.getColumnCount();
                        if (resultSet.next()) {
                            int count = 1;
                            int colCount = 1;
                            while (colCount <= numberOfColumns) {
                                JSONObject itemAttribSubObj = new JSONObject();
                                String colName = rsmd.getColumnLabel(colCount).toUpperCase();
                                if (colName.startsWith("PHY_ATTRIB_")) {
                                    int lastIndex = colName.lastIndexOf(95);
                                    String lastNumberStr = colName.substring(lastIndex + 1);
                                    int phyAttrbNum = Integer.parseInt(lastNumberStr);
                                    if (resultSet.getString(colName) != null && (startDynamicIndex == 0 || startDynamicIndex <= phyAttrbNum)) {
                                        itemAttribSubObj.put(resultSet.getString(colName), (Object)"");
                                    }
                                }
                                BaseLogger.log("1", userInfo, null, "ItemAttributesJB.getAttributes() itemAttribSubObj :[" + itemAttribSubObj.toString() + "]");
                                if (itemAttribSubObj.length() > 0) {
                                    itemAttribObj.put(Integer.toString(count), (Object)itemAttribSubObj);
                                    ++count;
                                }
                                ++colCount;
                            }
                        }
                    }
                }
                result = itemAttribObj.toString();
                BaseLogger.log("3", null, null, "ItemAttributesJB.getAttributes() itemAttribObj : [" + result + "]");
            }
            catch (Exception e) {
                BaseLogger.log("3", null, null, "ItemAttributesJB.getAttributes() Exception : [" + E12GenericUtility.getStackTrace(e) + "]");
                try {
                    if (con != null) {
                        con.rollback();
                        con.close();
                        con = null;
                    }
                }
                catch (Exception catche) {
                    e.printStackTrace();
                    BaseLogger.log("0", userInfo, null, "Exception inside getAttributes[" + catche.getMessage() + "]");
                }
                throw new ITMException(e);
            }
        }
        finally {
            if (con != null) {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (resultSet != null) {
                    resultSet.close();
                    resultSet = null;
                }
                if (con != null) {
                    con.close();
                    con = null;
                }
            }
        }
        return result;
    }

    public String saveAttributes(String refSer, String refId, String itemCode, String itemAttributeObj, UserInfoBean userInfo) throws Exception {
        BaseLogger.log("3", userInfo, null, "ItemAttributesJB.saveAttributes()");
        String result = "";
        E12GenericUtility e12GenericUtility = new E12GenericUtility();
        Connection con = null;
        ResultSet resultSet = null;
        Statement pstmt = null;
        int attribNo = 0;
        String attribHeading = "";
        String attribValue = "";
        int selectCount = 0;
        try {
            try {
                String itemType = "";
                ConnDriver mConnDriver = new ConnDriver();
                con = mConnDriver.getConnectDB(userInfo.getTransDB());
                String itemSql = "SELECT ITEM_TYPE FROM ITEM WHERE ITEM_CODE = ?";
                pstmt = con.prepareStatement(itemSql);
                pstmt.setString(1, itemCode);
                resultSet = pstmt.executeQuery();
                if (resultSet.next()) {
                    itemType = E12GenericUtility.checkNull(resultSet.getString("ITEM_TYPE"));
                }
                resultSet.close();
                resultSet = null;
                pstmt.close();
                pstmt = null;
                if (itemType != null && itemType.length() > 0) {
                    String sqlcount = "SELECT COUNT(*) FROM TRANS_ITEM_ATTRIBUTES WHERE REF_SER = ? AND REF_ID = ? AND ITEM_TYPE = ?";
                    pstmt = con.prepareStatement(sqlcount);
                    pstmt.setString(1, refSer);
                    pstmt.setString(2, refId);
                    pstmt.setString(3, itemType);
                    resultSet = pstmt.executeQuery();
                    if (resultSet.next()) {
                        selectCount = resultSet.getInt(1);
                    }
                    resultSet.close();
                    resultSet = null;
                    pstmt.close();
                    pstmt = null;
                    JSONObject itemAttribObj = new JSONObject(itemAttributeObj);
                    Iterator keys = itemAttribObj.keys();
                    while (keys.hasNext()) {
                        String itemAttribObjKey = (String)keys.next();
                        attribNo = Integer.parseInt(itemAttribObjKey);
                        JSONObject itemAttribSubObj = itemAttribObj.getJSONObject(itemAttribObjKey);
                        Iterator itemAttribSubObjKeys = itemAttribSubObj.keys();
                        while (itemAttribSubObjKeys.hasNext()) {
                            String objKey = (String)itemAttribSubObjKeys.next();
                            String objValue = itemAttribSubObj.getString(objKey);
                            attribHeading = objKey;
                            attribValue = objValue;
                            if (selectCount == 0) {
                                String insertSql = "Insert into TRANS_ITEM_ATTRIBUTES (REF_SER, REF_ID, ATTRIB_NO, ATTRIB_HEADING, ATTRIB_VALUE, ITEM_TYPE) values (?,?,?,?,?,?)";
                                pstmt = con.prepareStatement(insertSql);
                                pstmt.setString(1, refSer);
                                pstmt.setString(2, refId);
                                pstmt.setInt(3, attribNo);
                                pstmt.setString(4, attribHeading);
                                pstmt.setString(5, attribValue);
                                pstmt.setString(6, itemType);
                                pstmt.executeUpdate();
                                if (pstmt == null) continue;
                                pstmt.close();
                                pstmt = null;
                                continue;
                            }
                            String sqlUpdate = "UPDATE TRANS_ITEM_ATTRIBUTES SET ATTRIB_HEADING=?, ATTRIB_VALUE=? WHERE REF_SER=? AND REF_ID =? And ATTRIB_NO =?";
                            pstmt = con.prepareStatement(sqlUpdate);
                            pstmt.setString(1, attribHeading);
                            pstmt.setString(2, attribValue);
                            pstmt.setString(3, refSer);
                            pstmt.setString(4, refId);
                            pstmt.setInt(5, attribNo);
                            pstmt.executeUpdate();
                            if (pstmt == null) continue;
                            pstmt.close();
                            pstmt = null;
                        }
                    }
                    if (con != null) {
                        con.commit();
                    }
                }
                result = e12GenericUtility.getErrorString("", "VTTRANSUCC", userInfo.getLoginUserId());
            }
            catch (Exception e) {
                try {
                    if (con != null) {
                        con.rollback();
                        con.close();
                        con = null;
                    }
                }
                catch (Exception catche) {
                    e.printStackTrace();
                    BaseLogger.log("0", userInfo, null, "ItemAttributesJB.saveAttributes() Exception :[" + catche.getMessage() + "]");
                }
                throw new ITMException(e);
            }
        }
        finally {
            if (con != null) {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (resultSet != null) {
                    resultSet.close();
                    resultSet = null;
                }
                if (con != null) {
                    con.close();
                    con = null;
                }
            }
        }
        BaseLogger.log("3", userInfo, null, "ItemAttributesJB.saveAttributes() result: [" + result + "]");
        return result;
    }

    public static String checkNull(String input) {
        if (input == null || "null".equalsIgnoreCase(input) || "undefined".equalsIgnoreCase(input)) {
            input = "";
        }
        return input;
    }
}

