/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.utility;

import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.UserInfoBean;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.ServiceArg;
import ibase.webitm.utility.Services;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class Events
implements Serializable {
    String objName;
    String eventCode;
    String eventContext;
    String serviceCodePre;
    String serviceCodePost;
    String serviceCode;
    String methodRule;
    String methodRulePostCode;
    String methodRulePreCode;
    String overwriteCore;
    String resultHandle;
    Services pre;
    Services post;
    String fieldName;
    Hashtable eventServiceTable = new Hashtable();

    public void setPost(Services post) throws ITMException {
        try {
            this.post = post;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
    }

    public Services getPost() throws ITMException {
        try {
            return this.post;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
    }

    public void setPre(Services pre) throws ITMException {
        try {
            this.pre = pre;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
    }

    public Services getPre() throws ITMException {
        try {
            return this.pre;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
    }

    public void setOverwriteCore(String overwriteCore) throws ITMException {
        try {
            this.overwriteCore = overwriteCore;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
    }

    public String getOverwriteCore() throws ITMException {
        try {
            return this.overwriteCore;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
    }

    public void setResultHandle(String resultHandle) throws ITMException {
        try {
            this.resultHandle = resultHandle;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
    }

    public String getResultHandle() throws ITMException {
        try {
            return this.resultHandle;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
    }

    public void setMethodRule(String methodRule) throws ITMException {
        try {
            this.methodRule = methodRule;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
    }

    public String getMethodRule() throws ITMException {
        try {
            return this.methodRule;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
    }

    public void setMethodRulePreCode(String methodRulePre) throws ITMException {
        try {
            this.methodRulePreCode = this.methodRulePreCode;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
    }

    public String getMethodRulePreCode() throws ITMException {
        try {
            return this.methodRulePreCode;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
    }

    public void setMethodRulePostCode(String methodRulePostCode) throws ITMException {
        try {
            this.methodRulePostCode = methodRulePostCode;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
    }

    public String getMethodRulePostCode() throws ITMException {
        try {
            return this.methodRulePostCode;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
    }

    public void setServiceCodePost(String serviceCodePost) throws ITMException {
        try {
            this.serviceCodePost = serviceCodePost;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
    }

    public String getServiceCodePost() throws ITMException {
        try {
            return this.serviceCodePost;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
    }

    public void setServiceCodePre(String serviceCodePre) throws ITMException {
        try {
            this.serviceCodePre = serviceCodePre;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
    }

    public String getServiceCodePre() throws ITMException {
        try {
            return this.serviceCodePre;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
    }

    public void setServiceCode(String serviceCode) throws ITMException {
        try {
            this.serviceCode = serviceCode;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
    }

    public String getServiceCode() throws ITMException {
        try {
            return this.serviceCode;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
    }

    public void setEventContext(String eventContext) throws ITMException {
        try {
            this.eventContext = eventContext;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
    }

    public String getEventContext() throws ITMException {
        try {
            return this.eventContext;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
    }

    public void setEventCode(String eventCode) throws ITMException {
        try {
            this.eventCode = eventCode;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
    }

    public String getEventCode() throws ITMException {
        try {
            return this.eventCode;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
    }

    public void setObjName(String objName) throws ITMException {
        try {
            this.objName = objName;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
    }

    public String getObjName() throws ITMException {
        try {
            return this.objName;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
    }

    public void setFieldName(String fieldName) throws ITMException {
        try {
            this.fieldName = fieldName;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
    }

    public String getFieldName() throws ITMException {
        try {
            return this.fieldName;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        Events clonedEvent = null;
        try {
            clonedEvent = new Events();
            clonedEvent.setObjName(this.getObjName());
            clonedEvent.setEventCode(this.getEventCode());
            clonedEvent.setEventContext(this.getEventContext());
            clonedEvent.setServiceCode(this.getServiceCode());
            clonedEvent.setMethodRule(this.getMethodRule());
            clonedEvent.setOverwriteCore(this.getOverwriteCore());
            clonedEvent.setResultHandle(this.getResultHandle());
            Services clonedServices = new Services();
            clonedServices.setServiceCode(this.pre.getServiceCode());
            clonedServices.setServiceURI(this.pre.getServiceURI());
            clonedServices.setServiceProvider(this.pre.getServiceProvider());
            clonedServices.setMethodName(this.pre.getMethodName());
            clonedServices.setReturnValue(this.pre.getReturnValue());
            clonedServices.setReturnType(this.pre.getReturnType());
            clonedServices.setReturnXFRM(this.pre.getReturnXFRM());
            ArrayList<ServiceArg> clonedServiceArgsList = new ArrayList<ServiceArg>();
            int noOfArgs = this.pre.getServiceArgs().size();
            int argCtr = 0;
            while (argCtr < noOfArgs) {
                ServiceArg clonedServiceArg = new ServiceArg();
                ServiceArg serviceArg = (ServiceArg)this.pre.getServiceArgs().get(argCtr);
                clonedServiceArg.setServiceCode(serviceArg.getServiceCode());
                clonedServiceArg.setLineNo(serviceArg.getLineNo());
                clonedServiceArg.setArgName(serviceArg.getArgName());
                clonedServiceArg.setArgMode(serviceArg.getArgMode());
                clonedServiceArg.setDescr(serviceArg.getDescr());
                clonedServiceArg.setArgType(serviceArg.getArgType());
                clonedServiceArg.setArgDataType(serviceArg.getArgDataType());
                clonedServiceArg.setArgXFRM(serviceArg.getArgXFRM());
                clonedServiceArg.setArgValue(serviceArg.getArgValue());
                clonedServiceArgsList.add(clonedServiceArg);
                clonedServiceArg = null;
                serviceArg = null;
                ++argCtr;
            }
            clonedServices.setServiceArgs(clonedServiceArgsList);
            clonedEvent.setPre(clonedServices);
            Object var2_2 = null;
        }
        catch (ITMException iTMException) {
            // empty catch block
        }
        return clonedEvent;
    }

    public Hashtable execute(String objName, UserInfoBean userInfoBean) throws ITMException, Exception {
        Connection con = null;
        Statement pStmtEventSer = null;
        BaseLogger.log("2", userInfoBean, null, "******* Event Class *******");
        try {
            try {
                String transDB = userInfoBean.getTransDB();
                ConnDriver connDriver = new ConnDriver();
                con = connDriver.getConnectDB(transDB);
                String sqlQuery = "SELECT A.OBJ_NAME, A.EVENT_CODE, A.EVENT_CONTEXT, A.SERVICE_CODE AS SERVICE,  A.METHOD_RULE,A.OVERWRITE_CORE, A.RESULT_HANDLE, A.FIELD_NAME AS FIELD_NAME, B.SERVICE_CODE,  B.SERVICE_DESCR,B.SERVICE_URI,B.SERVICE_PROVIDER,B.METHOD_NAME,B.RETURN_VALUE,  B.RETURN_TYPE,B.RETURN_DESCR,B.RETURN_XFRM FROM  SYSTEM_EVENTS A,SYSTEM_EVENT_SERVICES B  WHERE A.SERVICE_CODE=B.SERVICE_CODE   AND A.OBJ_NAME=?";
                pStmtEventSer = con.prepareStatement(sqlQuery);
                pStmtEventSer.setString(1, objName);
                ResultSet rsEventSer = pStmtEventSer.executeQuery();
                ResultSetMetaData rsmd = rsEventSer.getMetaData();
                while (rsEventSer.next()) {
                    Events eObj = new Events();
                    eObj.setObjName(rsEventSer.getString("OBJ_NAME"));
                    String eventCode = rsEventSer.getString("EVENT_CODE");
                    eObj.setEventCode(eventCode);
                    eObj.setEventContext(rsEventSer.getString("EVENT_CONTEXT"));
                    eObj.setServiceCode(rsEventSer.getString("SERVICE"));
                    eObj.setMethodRule(rsEventSer.getString("METHOD_RULE"));
                    eObj.setOverwriteCore(rsEventSer.getString("OVERWRITE_CORE"));
                    eObj.setResultHandle(rsEventSer.getString("RESULT_HANDLE"));
                    String fieldName = rsEventSer.getString("FIELD_NAME");
                    eObj.setFieldName(fieldName);
                    Services service = new Services();
                    service.setServiceCode(rsEventSer.getString("SERVICE_CODE"));
                    service.setServiceURI(rsEventSer.getString("SERVICE_URI"));
                    service.setServiceProvider(rsEventSer.getString("SERVICE_PROVIDER"));
                    service.setMethodName(rsEventSer.getString("METHOD_NAME"));
                    service.setReturnValue(rsEventSer.getString("RETURN_VALUE"));
                    service.setReturnType(rsEventSer.getString("RETURN_TYPE"));
                    service.setReturnXFRM(rsEventSer.getString("RETURN_XFRM"));
                    eObj.setPre(service);
                    if (fieldName != null) {
                        this.eventServiceTable.put(String.valueOf(eventCode) + "_" + fieldName, eObj);
                    } else {
                        this.eventServiceTable.put(eventCode, eObj);
                    }
                    service = null;
                    eObj = null;
                }
                rsEventSer.close();
                rsEventSer = null;
                pStmtEventSer.close();
                pStmtEventSer = null;
                Enumeration enum1 = this.eventServiceTable.keys();
                while (enum1.hasMoreElements()) {
                    String currentKey = (String)enum1.nextElement();
                    Events currEventObj = (Events)this.eventServiceTable.get(currentKey);
                    String valueToBePassed = currEventObj.getServiceCode();
                    BaseLogger.log("3", userInfoBean, null, "Value to be passed :" + valueToBePassed);
                    String sqlQueryArgs = "SELECT C.SERVICE_CODE,C.LINE_NO,C.ARG_NAME,C.ARG_MODE,C.DESCR,C.ARG_TYPE,C.ARG_XFRM,C.ARG_VALUE FROM SYSTEM_EVENT_SERVICES B,SYSTEM_SERVICE_ARGS C  WHERE B.SERVICE_CODE = C.SERVICE_CODE  AND C.SERVICE_CODE = ? ORDER BY C.LINE_NO";
                    pStmtEventSer = con.prepareStatement(sqlQueryArgs);
                    pStmtEventSer.setString(1, valueToBePassed);
                    rsEventSer = pStmtEventSer.executeQuery();
                    ArrayList<ServiceArg> argList = new ArrayList<ServiceArg>();
                    BaseLogger.log("3", userInfoBean, null, "setting service arguments ................");
                    while (rsEventSer.next()) {
                        ServiceArg serviceArg = new ServiceArg();
                        serviceArg.setServiceCode(rsEventSer.getString("SERVICE_CODE"));
                        serviceArg.setLineNo(rsEventSer.getString("LINE_NO"));
                        serviceArg.setArgName(rsEventSer.getString("ARG_NAME"));
                        serviceArg.setArgMode(rsEventSer.getString("ARG_MODE"));
                        serviceArg.setDescr(rsEventSer.getString("DESCR"));
                        String argTypeID = rsEventSer.getString("ARG_TYPE");
                        String argType = null;
                        String argDataType = null;
                        argTypeID = argTypeID != null ? argTypeID.trim() : "";
                        int indexOfDot = argTypeID.indexOf(".");
                        if (indexOfDot != -1) {
                            argType = argTypeID.substring(0, indexOfDot);
                            argDataType = argTypeID.substring(argTypeID.indexOf(".") + 1);
                        } else {
                            argType = argTypeID.length() > 0 ? argTypeID : "S";
                            argDataType = "String";
                        }
                        serviceArg.setArgType(argType);
                        serviceArg.setArgDataType(argDataType);
                        serviceArg.setArgXFRM(rsEventSer.getString("ARG_XFRM"));
                        serviceArg.setArgValue(rsEventSer.getString("ARG_VALUE"));
                        argList.add(serviceArg);
                        serviceArg = null;
                    }
                    rsEventSer.close();
                    rsEventSer = null;
                    pStmtEventSer.close();
                    pStmtEventSer = null;
                    BaseLogger.log("3", userInfoBean, null, "No. of args for current service code[" + valueToBePassed + "] :[" + argList.size() + "]");
                    currEventObj.getPre().setServiceArgs(argList);
                }
            }
            catch (SQLException sqlE) {
                this.eventServiceTable = null;
                sqlE.printStackTrace();
                throw new ITMException(sqlE);
            }
            catch (Exception e) {
                this.eventServiceTable = null;
                BaseLogger.log("0", userInfoBean, null, "Events:excute:genericBloc" + e);
                throw new ITMException(e);
            }
        }
        finally {
            if (con != null) {
                if (pStmtEventSer != null) {
                    pStmtEventSer.close();
                    pStmtEventSer = null;
                }
                con.close();
                con = null;
            }
        }
        return this.eventServiceTable;
    }

    public Hashtable executeByServiceCode(String objName, String serviceCode, UserInfoBean userInfoBean) throws ITMException, Exception {
        Connection con = null;
        Statement pStmtEventSer = null;
        BaseLogger.log("2", userInfoBean, null, "******* Event Class *******");
        try {
            try {
                ConnDriver connDriver = new ConnDriver();
                String transDB = userInfoBean.getTransDB();
                con = connDriver.getConnectDB(transDB);
                String sqlQuery = "SELECT A.OBJ_NAME, A.EVENT_CODE, A.EVENT_CONTEXT, A.SERVICE_CODE AS SERVICE,  A.METHOD_RULE,A.OVERWRITE_CORE, A.RESULT_HANDLE, B.SERVICE_CODE,  B.SERVICE_DESCR,B.SERVICE_URI,B.SERVICE_PROVIDER,B.METHOD_NAME,B.RETURN_VALUE,  B.RETURN_TYPE,B.RETURN_DESCR,B.RETURN_XFRM FROM  SYSTEM_EVENTS A,SYSTEM_EVENT_SERVICES B  WHERE A.SERVICE_CODE=B.SERVICE_CODE   AND A.OBJ_NAME=? AND A.SERVICE_CODE = ?";
                pStmtEventSer = con.prepareStatement(sqlQuery);
                pStmtEventSer.setString(1, objName);
                pStmtEventSer.setString(2, serviceCode);
                ResultSet rsEventSer = pStmtEventSer.executeQuery();
                while (rsEventSer.next()) {
                    Events eObj = new Events();
                    eObj.setObjName(rsEventSer.getString("OBJ_NAME"));
                    String eventCode = rsEventSer.getString("EVENT_CODE");
                    eObj.setEventCode(eventCode);
                    String eventContext = rsEventSer.getString("EVENT_CONTEXT");
                    eObj.setEventContext(eventContext);
                    eObj.setServiceCode(rsEventSer.getString("SERVICE"));
                    eObj.setMethodRule(rsEventSer.getString("METHOD_RULE"));
                    eObj.setOverwriteCore(rsEventSer.getString("OVERWRITE_CORE"));
                    eObj.setResultHandle(rsEventSer.getString("RESULT_HANDLE"));
                    Services service = new Services();
                    service.setServiceCode(rsEventSer.getString("SERVICE_CODE"));
                    service.setServiceURI(rsEventSer.getString("SERVICE_URI"));
                    service.setServiceProvider(rsEventSer.getString("SERVICE_PROVIDER"));
                    service.setMethodName(rsEventSer.getString("METHOD_NAME"));
                    service.setReturnValue(rsEventSer.getString("RETURN_VALUE"));
                    service.setReturnType(rsEventSer.getString("RETURN_TYPE"));
                    service.setReturnXFRM(rsEventSer.getString("RETURN_XFRM"));
                    eObj.setPre(service);
                    this.eventServiceTable.put(String.valueOf(eventCode) + "~" + eventContext, eObj);
                    service = null;
                    eObj = null;
                }
                rsEventSer.close();
                rsEventSer = null;
                pStmtEventSer.close();
                pStmtEventSer = null;
                Enumeration enum1 = this.eventServiceTable.keys();
                while (enum1.hasMoreElements()) {
                    String currentKey = (String)enum1.nextElement();
                    Events currEventObj = (Events)this.eventServiceTable.get(currentKey);
                    String valueToBePassed = currEventObj.getServiceCode();
                    BaseLogger.log("3", userInfoBean, null, "Value to be passed :" + valueToBePassed);
                    String sqlQueryArgs = "SELECT C.SERVICE_CODE,C.LINE_NO,C.ARG_NAME,C.ARG_MODE,C.DESCR,C.ARG_TYPE,C.ARG_XFRM,C.ARG_VALUE FROM SYSTEM_EVENT_SERVICES B,SYSTEM_SERVICE_ARGS C  WHERE B.SERVICE_CODE = C.SERVICE_CODE  AND C.SERVICE_CODE = ? ORDER BY C.LINE_NO";
                    pStmtEventSer = con.prepareStatement(sqlQueryArgs);
                    pStmtEventSer.setString(1, valueToBePassed);
                    rsEventSer = pStmtEventSer.executeQuery();
                    ArrayList<ServiceArg> argList = new ArrayList<ServiceArg>();
                    BaseLogger.log("3", userInfoBean, null, "setting service arguments ................");
                    while (rsEventSer.next()) {
                        ServiceArg serviceArg = new ServiceArg();
                        serviceArg.setServiceCode(rsEventSer.getString("SERVICE_CODE"));
                        serviceArg.setLineNo(rsEventSer.getString("LINE_NO"));
                        serviceArg.setArgName(rsEventSer.getString("ARG_NAME"));
                        serviceArg.setArgMode(rsEventSer.getString("ARG_MODE"));
                        serviceArg.setDescr(rsEventSer.getString("DESCR"));
                        String argTypeID = rsEventSer.getString("ARG_TYPE");
                        String argType = null;
                        String argDataType = null;
                        argTypeID = argTypeID != null ? argTypeID.trim() : "";
                        int indexOfDot = argTypeID.indexOf(".");
                        if (indexOfDot != -1) {
                            argType = argTypeID.substring(0, indexOfDot);
                            argDataType = argTypeID.substring(argTypeID.indexOf(".") + 1);
                        } else {
                            argType = argTypeID.length() > 0 ? argTypeID : "S";
                            argDataType = "String";
                        }
                        serviceArg.setArgType(argType);
                        serviceArg.setArgDataType(argDataType);
                        serviceArg.setArgXFRM(rsEventSer.getString("ARG_XFRM"));
                        serviceArg.setArgValue(rsEventSer.getString("ARG_VALUE"));
                        argList.add(serviceArg);
                        serviceArg = null;
                    }
                    rsEventSer.close();
                    rsEventSer = null;
                    pStmtEventSer.close();
                    pStmtEventSer = null;
                    BaseLogger.log("3", userInfoBean, null, "No. of args for current service code[" + valueToBePassed + "] :[" + argList.size() + "]");
                    currEventObj.getPre().setServiceArgs(argList);
                }
            }
            catch (SQLException sqlE) {
                this.eventServiceTable = null;
                sqlE.printStackTrace();
                throw new ITMException(sqlE);
            }
            catch (Exception e) {
                this.eventServiceTable = null;
                BaseLogger.log("0", userInfoBean, null, "Events:excute:genericBloc" + e);
                throw new ITMException(e);
            }
        }
        finally {
            if (con != null) {
                if (pStmtEventSer != null) {
                    pStmtEventSer.close();
                    pStmtEventSer = null;
                }
                con.close();
                con = null;
            }
        }
        return this.eventServiceTable;
    }
}

