/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.utility;

import ibase.bean.ExtAuthApplicationBean;
import ibase.ejb.CommonDBAccessEJB;
import ibase.utility.BaseException;
import ibase.utility.BaseLogger;
import ibase.utility.CryptographyUtil;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONException;
import org.json.JSONObject;

public class RestAPIServiceUtility {
    private String transDB = "";
    private CommonDBAccessEJB commonDBAcessEJB = null;

    public String getTransDB() {
        return this.transDB;
    }

    public void setTransDB(String transDB) {
        this.transDB = transDB;
    }

    public CommonDBAccessEJB getCommonDBAcessEJB() throws BaseException {
        return this.getCommonDBAccess();
    }

    public void setCommonDBAcessEJB(CommonDBAccessEJB commonDBAcessEJB) {
        this.commonDBAcessEJB = commonDBAcessEJB;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isWhiteListIP(HttpServletRequest request, String appId) {
        try {
            if (this.commonDBAcessEJB == null) {
                this.commonDBAcessEJB = this.getCommonDBAcessEJB();
            }
            String ipAddressRecvd = this.getRequestedIP(request);
            BaseLogger.log("3", null, null, "isWhiteListIP :: ipAddressRecvd : [" + ipAddressRecvd + "]");
            appId = E12GenericUtility.checkNull(appId);
            BaseLogger.log("3", null, null, "isWhiteListIP :: appId : [" + appId + "]");
            BaseLogger.log("3", null, null, "transDB :: ipAddressRecvd : [" + this.getTransDB() + "]");
            this.commonDBAcessEJB.setTransDB(this.transDB);
            ExtAuthApplicationBean applicationBean = this.commonDBAcessEJB.getExtAuthApplicationInfo(appId);
            if (applicationBean == null) return false;
            String whiteListIP = E12GenericUtility.checkNull(applicationBean.getWhiteListIP());
            if ("NO_IP_CONF_REQUIRED".equalsIgnoreCase(whiteListIP)) {
                BaseLogger.log("3", null, null, "Not validating ip address!");
                return true;
            }
            if (ipAddressRecvd.length() > 0) {
                String[] ipAddressArr = ipAddressRecvd.split(",");
                int outer = 0;
                while (outer < ipAddressArr.length) {
                    String ipAddress = ipAddressArr[outer];
                    BaseLogger.log("3", null, null, "isWhiteListIP :: ipAddress : before : [" + ipAddress + "]");
                    if (ipAddress != null) {
                        ipAddress = ipAddress.trim();
                        BaseLogger.log("3", null, null, "isWhiteListIP :: ipAddress : after trim : [" + ipAddress + "]");
                    }
                    BaseLogger.log("3", null, null, "isWhiteListIP :: ipAddress : [" + ipAddress + "]");
                    if (whiteListIP.length() > 0) {
                        String[] whiteListIPArr = whiteListIP.split(",");
                        int i = 0;
                        while (i < whiteListIPArr.length) {
                            String IP = E12GenericUtility.checkNull(whiteListIPArr[i]);
                            if (!"".equals(IP) && ipAddress.equals(IP)) {
                                return true;
                            }
                            if (!"".equals(IP) && IP.endsWith("*")) {
                                if (ipAddress.startsWith(IP = IP.substring(0, IP.length() - 1))) {
                                    return true;
                                }
                            } else if (!"".equals(IP) && IP.contains("/")) {
                                String ipAddressSubStr = ipAddress.substring(0, ipAddress.lastIndexOf("."));
                                String ipSubStr = IP.substring(0, IP.lastIndexOf("."));
                                BaseLogger.log("3", null, null, "ipAddressSubStr : [" + ipAddressSubStr + "] ipSubStr : [" + ipSubStr + "]");
                                if (ipAddressSubStr.equals(ipSubStr)) {
                                    String ipEnd = IP.substring(IP.lastIndexOf(".") + 1);
                                    String ipAddressEnd = ipAddress.substring(ipAddress.lastIndexOf(".") + 1);
                                    BaseLogger.log("3", null, null, "ipEnd : [" + ipEnd + "], ipAddressEnd : [" + ipAddressEnd + "]");
                                    String[] ipRange = ipEnd.split("/");
                                    int start = Integer.parseInt(ipRange[0]);
                                    int end = Integer.parseInt(ipRange[1]);
                                    int userIP = Integer.parseInt(ipAddressEnd);
                                    BaseLogger.log("3", null, null, "Start : [" + start + "], End : [" + end + "], userIP : [" + userIP + "]");
                                    if (userIP >= start && userIP <= end) {
                                        return true;
                                    }
                                }
                            }
                            ++i;
                        }
                    }
                    ++outer;
                }
            }
            BaseLogger.log("3", null, null, "isWhiteListIP :: whiteListIp : [" + whiteListIP + "]");
            return false;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :: isWhiteListIP : [" + e.getMessage() + "]");
            e.printStackTrace();
            return false;
        }
    }

    public String validateAppId(HttpServletRequest request, String appId, String endpoint) {
        String result = "valid";
        try {
            appId = this.checkNull(appId);
            boolean isWhiteListIP = this.isWhiteListIP(request, appId);
            if (!isWhiteListIP) {
                result = "Requested IP not registered for AppID (" + appId + ")";
            } else {
                boolean isExtAppEndpointAllowed = this.getCommonDBAccess().isExtAppEndpointAllowed(endpoint, appId);
                if (!isExtAppEndpointAllowed) {
                    result = "This service not available for the AppID (" + appId + ")";
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception : validateRequest : " + e.getMessage());
            result = this.getStackTrace(e);
        }
        return result;
    }

    public String validateJWT(String jwt, String appId, String secretKey) {
        String result = "valid";
        try {
            String jwtResult = CryptographyUtil.parseBase64EncodedJWT(jwt, secretKey);
            if ("expired".equalsIgnoreCase(jwtResult)) {
                result = "Token has been expired";
            } else if ("invalid".equalsIgnoreCase(jwtResult)) {
                result = "Invalid Token";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            result = "Invalid Token";
        }
        return result;
    }

    public CommonDBAccessEJB getCommonDBAccess() throws BaseException {
        CommonDBAccessEJB ejbObj = null;
        try {
            ejbObj = new CommonDBAccessEJB();
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :: VisionEDIService : getCommonDBAccess : [" + e.getMessage() + "]");
            throw new BaseException(e);
        }
        return ejbObj;
    }

    public String getStackTrace(Exception e) {
        return new E12GenericUtility().createErrorString(e);
    }

    public String getStackTrace(Exception e, String dataFormat) {
        return new E12GenericUtility().createErrorString(e, dataFormat);
    }

    public String checkNull(String input) {
        return E12GenericUtility.checkNull(input);
    }

    public String getRequestedIP(HttpServletRequest request) {
        String ipAddress = "";
        try {
            if (ipAddress == null || ipAddress.equalsIgnoreCase("") || ipAddress.length() == 0) {
                ipAddress = request.getHeader("X-FORWARDED-FOR");
            }
            if (ipAddress == null || ipAddress.equalsIgnoreCase("") || ipAddress.length() == 0) {
                ipAddress = request.getHeader("HTTP_X_FORWARDED_FOR");
            }
            if (ipAddress == null || ipAddress.equalsIgnoreCase("") || ipAddress.length() == 0) {
                ipAddress = request.getHeader("Remote_Addr");
            }
            if ((ipAddress == null || ipAddress.equalsIgnoreCase("") || ipAddress.length() == 0) && (ipAddress = request.getHeader("X-Forwarded-For")) == null) {
                ipAddress = request.getRemoteAddr();
            }
            ipAddress = E12GenericUtility.checkNull(ipAddress);
            BaseLogger.log("0", null, null, "getRequestedIP :: ipAddress : [" + ipAddress + "]");
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :: getRequestedIP : [" + e.getMessage() + "]");
            e.printStackTrace();
        }
        return ipAddress;
    }

    public UserInfoBean createUserInfo(HashMap<String, String> jwtData) {
        UserInfoBean basicInfo = null;
        if (jwtData != null) {
            basicInfo = new UserInfoBean();
            basicInfo.setLoginCode(this.checkNull(jwtData.get("userId")));
            basicInfo.setLoginUserId(this.checkNull(jwtData.get("userId")));
            basicInfo.setLoginMobileNo(this.checkNull(jwtData.get("loginMobileNo")));
            basicInfo.setLoginEmailId(jwtData.get("email"));
            basicInfo.setProfileId(this.checkNull(jwtData.get("profileId")));
            basicInfo.setSiteCode(this.checkNull(jwtData.get("loginSite")));
            basicInfo.setSiteDescr(this.checkNull(jwtData.get("siteDescr")));
            basicInfo.setEmpCode(this.checkNull(jwtData.get("empCode")));
            basicInfo.setEmpName(this.checkNull(jwtData.get("empName")));
            basicInfo.setEmpFName(this.checkNull(jwtData.get("empFName")));
            basicInfo.setEmpLName(this.checkNull(jwtData.get("empLName")));
            basicInfo.setEmpMName(this.checkNull(jwtData.get("empMName")));
            basicInfo.setReportTo(this.checkNull(jwtData.get("reportTo")));
            basicInfo.setDeptCode(this.checkNull(jwtData.get("deptCode")));
            basicInfo.setDeptCode(this.checkNull(jwtData.get("deptDescr")));
            basicInfo.setEmailIdOff(this.checkNull(jwtData.get("emailIdOff")));
            basicInfo.setEntityCode(this.checkNull(jwtData.get("entityCode")));
            basicInfo.setUserLevel(this.checkNull(jwtData.get("userLevel")));
            basicInfo.setUserType(this.checkNull(jwtData.get("userType")));
            basicInfo.setItemSer(this.checkNull(jwtData.get("itemSer")));
            basicInfo.setDeviceID(this.checkNull(jwtData.get("deviceID")));
            basicInfo.setDeviceType(this.checkNull(jwtData.get("deviceType")));
            basicInfo.setEnterprise(this.checkNull(jwtData.get("enterprise")));
            basicInfo.setSocialOpt(this.checkNull(jwtData.get("socialOpt")));
            basicInfo.setEnterpriseDescr(this.checkNull(jwtData.get("enterpriseDescr")));
            basicInfo.setInMemUserName(this.checkNull(jwtData.get("inMemUserName")));
            basicInfo.setInMemPassword(this.checkNull(jwtData.get("inMemPassword")));
            basicInfo.setInMemUrl(this.checkNull(jwtData.get("inMemUrl")));
            basicInfo.setSessTimeoutInSec(this.checkNull(jwtData.get("sessTimeoutInSecs")));
            basicInfo.setDocServerID(this.checkNull(jwtData.get("docServerID")));
            basicInfo.setSmtpFallback(this.checkNull(jwtData.get("smtpFallback")));
            basicInfo.setCumulativeLoggedInTimeForTheDay(this.checkNull(jwtData.get("cumulativeLoggedInTimeForTheDay")));
            basicInfo.setCity(this.checkNull(jwtData.get("city")));
            basicInfo.setFin_entity(this.checkNull(jwtData.get("fin_entity")));
            basicInfo.setFacility_code(this.checkNull(jwtData.get("facility_code")));
            basicInfo.setEntryType(this.checkNull(jwtData.get("entryType")));
            basicInfo.setEntryId(this.checkNull(jwtData.get("setEntryId")));
            basicInfo.setSmtpHost(this.checkNull(jwtData.get("smtpHost")));
            basicInfo.setSmtpPort(this.checkNull(jwtData.get("smtpPort")));
            basicInfo.setSmtpUser(this.checkNull(jwtData.get("smtpUser")));
            basicInfo.setSmtpPassWD(this.checkNull(jwtData.get("smtpPassWD")));
            basicInfo.setSmtpProtocolType(this.checkNull(jwtData.get("smtpProtocolType")));
            basicInfo.setSmtpMailFrom(this.checkNull(jwtData.get("smtpMailFrom")));
            basicInfo.setAdminEmailId(this.checkNull(jwtData.get("adminEmailId")));
            basicInfo.setUserName(this.checkNull(jwtData.get("userName")));
            basicInfo.setIsPasswordStore(this.checkNull(jwtData.get("isPasswordStore")));
            basicInfo.setDefaultMenu(this.checkNull(jwtData.get("defaultMenu")));
            basicInfo.setFeatures(this.checkNull(jwtData.get("features")));
            basicInfo.setCharEnc(this.checkNull(jwtData.get("charEnc")));
            basicInfo.setRemoteHost(this.checkNull(jwtData.get("remoteHost")));
            basicInfo.setRemoteHostName(this.checkNull(jwtData.get("remoteHostName")));
            basicInfo.setProfileIdRes(this.checkNull(jwtData.get("remoteHostName")));
            basicInfo.setStanCode(this.checkNull(jwtData.get("stanCode")));
            basicInfo.setDesignation(this.checkNull(jwtData.get("designation")));
            basicInfo.setDateJoin(this.checkNull(jwtData.get("dateJoin")));
            basicInfo.setDivision(this.checkNull(jwtData.get("division")));
            basicInfo.setUserLanguage(this.checkNull(jwtData.get("userLanguage")));
            basicInfo.setLoggerType(this.checkNull(jwtData.get("loggerType")));
            basicInfo.setTransDB(this.checkNull(jwtData.get("transDB")));
            basicInfo.setUserTheme(this.checkNull(jwtData.get("userTheme")));
            basicInfo.setUxInterface(this.checkNull(jwtData.get("uxInterface")));
            basicInfo.setTimeZone(this.checkNull(jwtData.get("timeZone")));
            basicInfo.setHostName(this.checkNull(jwtData.get("hostName")));
            basicInfo.setHostIP(this.checkNull(jwtData.get("hostIP")));
            basicInfo.setProfileDescr(this.checkNull(jwtData.get("profileDescr")));
            basicInfo.setUserGeoFence(this.checkNull(jwtData.get("userGeoFence")));
            basicInfo.setDataMode(this.checkNull(jwtData.get("dataMode")));
            basicInfo.setGeoPosOption(this.checkNull(jwtData.get("geoPosOption")));
            basicInfo.setCurrentGeoPOSName(this.checkNull(jwtData.get("geoPosOption")));
            basicInfo.setGeoPosAccuracy(this.checkNull(jwtData.get("geoPosAccuracy")));
            basicInfo.setLogInInterface(this.checkNull(jwtData.get("geoPosAccuracy")));
            basicInfo.setTermId(this.checkNull(jwtData.get("geoPosAccuracy")));
            basicInfo.setMacAddress(this.checkNull(jwtData.get("macAddress")));
            basicInfo.setRemoteAddress(this.checkNull(jwtData.get("remoteAddress")));
            basicInfo.setUserNetworkOption(this.checkNull(jwtData.get("userNetworkOption")));
            basicInfo.setAuthenticatedUsing(this.checkNull(jwtData.get("authenticatedUsing")));
            basicInfo.setSessionId(this.checkNull(jwtData.get("sessionId")));
            basicInfo.setIsAllowOfflineEdit(this.checkNull(jwtData.get("isAllowOfflineEdit")));
            basicInfo.setIsAllowOfflineDelete(this.checkNull(jwtData.get("isAllowOfflineDelete")));
        }
        return basicInfo;
    }

    public String getPayloadRequestData(HttpServletRequest request) throws IOException {
        String bodyData = null;
        StringBuilder stringBuilder = new StringBuilder();
        try (BufferedReader bufferedReader = null;){
            ServletInputStream inputStream = request.getInputStream();
            if (inputStream != null) {
                bufferedReader = new BufferedReader(new InputStreamReader((InputStream)inputStream));
                char[] charBuffer = new char[128];
                int bytesRead = -1;
                while ((bytesRead = bufferedReader.read(charBuffer)) > 0) {
                    stringBuilder.append(charBuffer, 0, bytesRead);
                }
            } else {
                stringBuilder.append("");
            }
        }
        bodyData = stringBuilder.toString();
        return bodyData;
    }

    public String getJsonStringValue(JSONObject inputArgJson, String key) throws JSONException {
        if (inputArgJson != null && inputArgJson.has(key)) {
            return this.checkNull(inputArgJson.getString(key));
        }
        return "";
    }
}

