/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.servlet;

import com.fasterxml.jackson.databind.ObjectMapper;
import ibase.servlet.AuthenticateServlet;
import ibase.utility.BaseException;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.E12CreateBatchLoadEjb;
import ibase.webitm.ejb.MasterApplyEJB;
import ibase.webitm.utility.ITMException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.List;
import javapns.json.JSONException;
import javapns.json.JSONObject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

public class RemoteUploadTemplateServlet
extends AuthenticateServlet {
    private static final long serialVersionUID = 1L;

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.doPost(request, response);
    }

    @Override
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HttpSession sess = null;
        UserInfoBean userInfo = null;
        try {
            if (Boolean.valueOf(this.authenticate(request)).booleanValue()) {
                sess = request.getSession();
                BaseLogger.log("0", null, null, "RemoteUploadTemplateServlet :: [" + sess.getId() + "]");
                userInfo = (UserInfoBean)sess.getAttribute("USER_INFO");
                this.uploadTemplateData(request, response, userInfo);
            } else {
                BaseLogger.log("0", null, null, "Authentication Error Not Login");
            }
        }
        catch (BaseException e) {
            BaseLogger.log("0", null, null, " RemoteUploadTemplateServlet Authentication Exception [" + e.getMessage() + "]");
            e.printStackTrace();
        }
    }

    private void uploadTemplateData(HttpServletRequest request, HttpServletResponse response, UserInfoBean userInfo) throws ITMException {
        block39: {
            String action = request.getParameter("ACTION");
            BaseLogger.log("2", null, null, "action : [" + action + "]");
            if ("REMOTE_UPLOAD".equals(action)) {
                String remoteData = "";
                String detailDataMapJson = "";
                String editOpt = "";
                String batchNo = "";
                String objName = "";
                String uploadFileName = "";
                String xtraParams = "";
                String excelFilePath = "";
                DiskFileItemFactory factory = new DiskFileItemFactory();
                ServletFileUpload uploadFile = new ServletFileUpload((FileItemFactory)factory);
                try {
                    List formItems = uploadFile.parseRequest(request);
                    BaseLogger.log("3", null, null, "formItems : [" + formItems + "]");
                    if (formItems != null) {
                        for (FileItem item : formItems) {
                            String fieldName = item.getFieldName();
                            BaseLogger.log("3", null, null, "fieldName : [" + fieldName + "]");
                            if ("REMOTE_OBJ_DATA".equalsIgnoreCase(fieldName)) {
                                remoteData = item.getString();
                                BaseLogger.log("3", null, null, "remoteData: [" + remoteData + "]");
                            }
                            if ("DETAIL_DATA_JSON".equalsIgnoreCase(fieldName)) {
                                detailDataMapJson = item.getString();
                                BaseLogger.log("3", null, null, " detailDataMapJson: [" + detailDataMapJson + "]");
                            }
                            if ("EDITOPT".equalsIgnoreCase(fieldName)) {
                                editOpt = item.getString();
                                BaseLogger.log("3", null, null, "editOpt: [" + editOpt + "]");
                            }
                            if ("BATCH_NO".equalsIgnoreCase(fieldName)) {
                                batchNo = item.getString();
                                BaseLogger.log("3", null, null, " batchNo: [" + batchNo + "]");
                            }
                            if ("OBJ_NAME".equalsIgnoreCase(fieldName)) {
                                objName = item.getString();
                                BaseLogger.log("3", null, null, "objName: [" + objName + "]");
                            }
                            if ("UPLOAD_FILE_NAME".equalsIgnoreCase(fieldName)) {
                                uploadFileName = item.getString();
                                BaseLogger.log("3", null, null, " uploadFileName: [" + uploadFileName + "]");
                            }
                            if ("XTRA_PARAMS".equalsIgnoreCase(fieldName)) {
                                xtraParams = item.getString();
                                BaseLogger.log("3", null, null, "xtraParams: [" + xtraParams + "]");
                            }
                            if (!"EXCEL_FILE_PATH".equalsIgnoreCase(fieldName)) continue;
                            excelFilePath = item.getString();
                            BaseLogger.log("3", null, null, " excelFilePath: [" + excelFilePath + "]");
                        }
                    }
                }
                catch (FileUploadException e1) {
                    BaseLogger.log("3", null, null, "In the FileUploadException : [" + e1.getMessage() + "]");
                    e1.printStackTrace();
                }
                try {
                    ObjectMapper mapper = new ObjectMapper();
                    LinkedHashMap detailDataMap = (LinkedHashMap)mapper.readValue(detailDataMapJson, LinkedHashMap.class);
                    BaseLogger.log("3", null, null, "detailDataMap: [" + detailDataMap + "]");
                    E12CreateBatchLoadEjb batchLoadEjb = new E12CreateBatchLoadEjb();
                    String batchDataResponse = batchLoadEjb.insertBatchData(detailDataMap, editOpt, batchNo, objName, uploadFileName, xtraParams, userInfo);
                    batchLoadEjb = null;
                    BaseLogger.log("3", userInfo, null, "batchDataResponse : [" + batchDataResponse + "]");
                    if (!"SUCCESS".equalsIgnoreCase(batchDataResponse)) break block39;
                    String tableName = "";
                    String tranIdCol = "";
                    String fileType = "";
                    String templateKey = "";
                    boolean isBatchIdColExist = false;
                    String tempName = "";
                    String loadMode = "";
                    String sessionId = "";
                    boolean isDataUploadAutoConfirm = false;
                    try {
                        JSONObject remoteDataJson = new JSONObject(remoteData);
                        BaseLogger.log("3", null, null, "remoteDataJson :[" + remoteDataJson + "]");
                        if (remoteDataJson.has("TABLE_NAME")) {
                            tableName = remoteDataJson.getString("TABLE_NAME");
                        }
                        if (remoteDataJson.has("TRAN_ID_COL")) {
                            tranIdCol = remoteDataJson.getString("TRAN_ID_COL");
                        }
                        if (remoteDataJson.has("FILE_TYPE")) {
                            fileType = remoteDataJson.getString("FILE_TYPE");
                        }
                        if (remoteDataJson.has("TEMP_KEY")) {
                            templateKey = remoteDataJson.getString("TEMP_KEY");
                        }
                        if (remoteDataJson.has("IS_BATCHID_COL_EXIST")) {
                            isBatchIdColExist = remoteDataJson.getBoolean("IS_BATCHID_COL_EXIST");
                        }
                        if (remoteDataJson.has("TEMP_NAME")) {
                            tempName = remoteDataJson.getString("TEMP_NAME");
                        }
                        if (remoteDataJson.has("LOAD_MODE")) {
                            loadMode = remoteDataJson.getString("LOAD_MODE");
                        }
                        if (remoteDataJson.has("SESSION_ID")) {
                            sessionId = remoteDataJson.getString("SESSION_ID");
                        }
                        if (remoteDataJson.has("AUTO_CONFIRM")) {
                            isDataUploadAutoConfirm = remoteDataJson.getBoolean("AUTO_CONFIRM");
                        }
                    }
                    catch (JSONException e) {
                        BaseLogger.log("0", null, null, "In the JSONException :[" + e.getMessage() + "]");
                        e.printStackTrace();
                    }
                    MasterApplyEJB masterApply = new MasterApplyEJB();
                    BaseLogger.log("3", userInfo, null, "isDataUploadAutoConfirm : [" + isDataUploadAutoConfirm + "]");
                    masterApply.setDataUploadAutoConfirm(isDataUploadAutoConfirm);
                    String retString = masterApply.uploadBatchData(objName, tableName, tranIdCol, excelFilePath, fileType, templateKey, batchNo, isBatchIdColExist, xtraParams, userInfo, tempName, sessionId, loadMode, remoteData.toString());
                    BaseLogger.log("3", userInfo, null, "returnStr : [" + retString + "]");
                    masterApply = null;
                }
                catch (SQLException e) {
                    BaseLogger.log("0", null, null, "In the RemoteUploadTemplateServlet SQLException : [" + e.getMessage() + "]");
                    e.printStackTrace();
                }
                catch (ITMException e) {
                    BaseLogger.log("0", null, null, "In the RemoteUploadTemplateServlet ITMException : [" + e.getMessage() + "]");
                    e.printStackTrace();
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "In the RemoteUploadTemplateServlet Exception : [" + e.getMessage() + "]");
                    e.printStackTrace();
                }
            } else if ("MOVE_UPLOAD_FILE".equals(action)) {
                File errorFilePathDir;
                String newFileName = "";
                byte[] uploadFileData = new byte[1];
                DiskFileItemFactory factory = new DiskFileItemFactory();
                ServletFileUpload uploadFile = new ServletFileUpload((FileItemFactory)factory);
                try {
                    List formItems = uploadFile.parseRequest(request);
                    if (formItems != null) {
                        for (FileItem item : formItems) {
                            String fieldName = item.getFieldName();
                            newFileName = new File(item.getName()).getName();
                            BaseLogger.log("3", null, null, "newFileName :[" + newFileName + "]");
                            if (!"UPLOAD_FILE_DATA".equalsIgnoreCase(fieldName)) continue;
                            uploadFileData = item.get();
                            BaseLogger.log("3", null, null, " bytes: [" + uploadFileData + "]");
                        }
                    }
                }
                catch (FileUploadException e1) {
                    BaseLogger.log("3", null, null, "In the FileUploadException : [" + e1.getMessage() + "]");
                    e1.printStackTrace();
                }
                if (!(errorFilePathDir = new File(CommonConstants.TEMP_FOLDER)).exists()) {
                    errorFilePathDir.mkdirs();
                }
                String errorFilePath = errorFilePathDir + File.separator + newFileName;
                File tempErrorFile = new File(errorFilePath);
                File toUploadDumpDir = new File(String.valueOf(CommonConstants.TEMP_FOLDER) + File.separator + "to_upload");
                if (!toUploadDumpDir.exists()) {
                    toUploadDumpDir.mkdirs();
                }
                String uploadFilepath = toUploadDumpDir + File.separator + newFileName;
                File tempUploadFile = new File(uploadFilepath);
                try {
                    if (!tempErrorFile.exists()) {
                        tempErrorFile.createNewFile();
                    }
                    FileOutputStream tempFileOutputStrem = new FileOutputStream(tempErrorFile);
                    tempFileOutputStrem.write(uploadFileData);
                    tempFileOutputStrem.close();
                    BaseLogger.log("3", null, null, "Successfully byte inserted : tempFile");
                    if (!tempUploadFile.exists()) {
                        tempUploadFile.createNewFile();
                    }
                    FileOutputStream fileOutputStream = new FileOutputStream(tempUploadFile);
                    fileOutputStream.write(uploadFileData);
                    fileOutputStream.close();
                    BaseLogger.log("3", null, null, "Successfully byte inserted : file");
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception: " + e.getMessage());
                    e.printStackTrace();
                }
            }
        }
    }
}

