<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ page import="java.io.*, java.net.*, java.sql.*, javax.naming.Context, javax.naming.InitialContext, javax.sql.DataSource"%>
<%@ page import="ibase.utility.BaseLogger, ibase.utility.UserInfoBean, ibase.webitm.ejb.DBAccessEJB, ibase.system.config.ConnDriver"%>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Customer External Information</title>
   
</head>
<body>
<%
    BaseLogger.log("3", null, null, "Customer Exterranl Info ");

    System.out.println("...@@@@@@@ In CustExtInfo.jsp @@@@@@@@...");

    String custCode = request.getParameter("CUST_CODE");
    BaseLogger.log("3", null, null, "CustCode [" + custCode + "]");

    UserInfoBean userInfo = (UserInfoBean) session.getAttribute("USER_INFO");
    DBAccessEJB dbAccess = new DBAccessEJB();

    String infoResponse = null;
    BaseLogger.log("3", null, null, "infoResponse1 :: "+infoResponse);
    // Check if custCode is present in the database
    String custCODE = dbAccess.getDBColumnValue("CUST_EXT_INFO", "CUST_CODE", "CUST_CODE = '" + custCode + "'", userInfo.getTransDB());
    BaseLogger.log("3", null, null, "CustCode present in CUST_EXT_INFO Table   [" + custCODE + "]");

    if (custCODE != null) {
    	BaseLogger.log("3", null, null, "Inside if block..");
        // If custCode is present, get the INFO_RESPONSE from database
        infoResponse = dbAccess.getDBColumnValue("CUST_EXT_INFO", "INFO_RESPONSE", "CUST_CODE = '" + custCode + "'", userInfo.getTransDB());
        BaseLogger.log("3", null, null, "infoResponse ::===>  [" + infoResponse + "]");
    } else {
    	BaseLogger.log("3", null, null, "Inside else block..");
        // If custCode is not present, call the API and store the response in database
        try {
            String apiUrl = "https://sandboxapi.atlas.vayana.com/AtlasApi/v1.0/aadhaar/udyam/registration/verification";
            URL url = new URL(apiUrl);
            HttpURLConnection conn = (HttpURLConnection) url.openConnection();
            conn.setRequestMethod("GET");

            BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String inputLine;
            StringBuffer apiResponse = new StringBuffer();

            while ((inputLine = in.readLine()) != null) {
                apiResponse.append(inputLine);
            }
            in.close();

            infoResponse = apiResponse.toString();
            BaseLogger.log("3", null, null, "API Response: " + infoResponse);

            // Store the API response in the database
            Connection connection = null;
            PreparedStatement pstmt = null;
            try {
                ConnDriver connDriver = new ConnDriver();
                connection = connDriver.getConnectDB(userInfo.getTransDB());
                String insertQuery = "INSERT INTO CUST_EXT_INFO (CUST_CODE, INFO_RESPONSE) VALUES (?, ?)";
                pstmt = connection.prepareStatement(insertQuery);
                pstmt.setString(1, custCode);
                pstmt.setString(2, infoResponse);
                pstmt.executeUpdate();
            } catch (SQLException e) {
                e.printStackTrace();
            } finally {
                if (pstmt != null) {
                    try {
                        pstmt.close();
                    } catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
                if (connection != null) {
                    try {
                        connection.close();
                    } catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }
        } catch (Exception e) {
            out.println("Error calling API: " + e.getMessage());
        }
    }
%>

<h1>Customer External Information</h1>

<%-- Check if infoResponse is not null and parse JSON --%>
<% 
BaseLogger.log("3", null, null, "infoResponse2 :: "+infoResponse);
if (infoResponse != null || !infoResponse.trim().isEmpty()) { 
    BaseLogger.log("3", null, null, "Inside the If Block :: " + infoResponse);

	%>
    <h2>JSON Data </h2>
    <table id="jsonData">
        <thead>
            <tr>
                <th>Key</th>
                <th>Value</th>
            </tr>
        </thead>
        <tbody>
            <%-- Parse JSON response using JavaScript --%>
            <script>
                var jsonData = <%=infoResponse.replaceAll("\"", "\\\"")%>;

                function createTableFromJson(data, parentElement) {
                    for (var key in data) {
                        if (data.hasOwnProperty(key)) {
                            var value = data[key];
                            var row = parentElement.insertRow();
                            var cell1 = row.insertCell(0);
                            var cell2 = row.insertCell(1);
                            cell1.innerHTML = key;

                            if (typeof value === 'object' && value !== null) {
                                cell2.innerHTML = "";
                                var nestedTable = document.createElement("table");
                                var nestedBody = document.createElement("tbody");
                                nestedTable.appendChild(nestedBody);
                                createTableFromJson(value, nestedBody);
                                cell2.appendChild(nestedTable);
                            } else {
                                cell2.innerHTML = value;
                            }
                        }
                    }
                }

                var tableBody = document.getElementById("jsonData").getElementsByTagName('tbody')[0];
                createTableFromJson(JSON.parse(jsonData), tableBody);
            </script>
        </tbody>
    </table>
<% } else { %>
    <p>No data available.</p>
<% } %>

</body>
</html>
