package ibase.webitm.bean.wsfa;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;

import ibase.system.config.ConnDriver;
import ibase.utility.UserInfoBean;

public class CoachingBean
{
	public HashMap<String, ArrayList<String>> getCoachingValues( String strgCode, String salesPers, UserInfoBean userInfo )
	{
		System.out.println("CoachingBean.getCoachingValues() strgCode = ["+strgCode+"] salesPers = ["+salesPers+"]");
		HashMap<String,ArrayList<String>> coachingHmap = new HashMap<String,ArrayList<String>>();
		Connection connection = null;
		PreparedStatement pstm = null;
		ResultSet rs = null;
		String surveyCode = "", descr = "", correctAns = "", result = "";
		try 
		{
			ConnDriver connDriver = new ConnDriver();
			connection = connDriver.getConnectDB( userInfo.getTransDB() );
			
			String sql = "SELECT SM.SURVEY_CODE, SM.DESCR, SM.CORRECT_ANS, COACHING.RESULT "
					+ "FROM SPRS_COACHING COACHING, SURVEY_MASTER SM "
					+ "WHERE COACHING.SURVEY_CODE = SM.SURVEY_CODE "
					+ "and COACHING.SPRS_CODE__WW = ? "
					+ "and COACHING.STRG_CODE = ? "
					+ "and sm.result_type <> 'A' order by COACHING.RESULT desc";
			
			System.out.println("sql "+sql);
			pstm = connection.prepareStatement(sql);
			pstm.setString( 1, salesPers );
			pstm.setString( 2, strgCode );
			
			rs = pstm.executeQuery();
			while( rs.next() )
			{
				ArrayList<String> coachingList = new ArrayList<String>();
				
				surveyCode = rs.getString("survey_code");
				System.out.println("surveyCode["+surveyCode+"]");
				
				descr = rs.getString("descr");
				System.out.println("descr["+descr+"]");
				
				correctAns = rs.getString("correct_ans");
				System.out.println("correctAns["+correctAns+"]");
				
				result = rs.getString("result");
				System.out.println("result["+result+"]");
				
				coachingList.add( descr );
				coachingList.add( correctAns );
				coachingList.add( result );

				System.out.println("coachingList = "+coachingList);
				coachingHmap.put( surveyCode, coachingList );
			}
			System.out.println("coachingHmap = "+coachingHmap);
			
			if ( pstm != null )
			{
				pstm.close();
				pstm = null;
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
		} 
		catch (Exception e) 
		{
			System.out.println( "Exception : ConnectionBean.getConnection() ["+e.getMessage()+"]" );
		}
		finally
		{
			try 
			{
				if ( pstm != null )
				{
					pstm.close();
					pstm = null;
				}
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( connection != null )
				{
					connection.close();
					connection = null;
				}
			}
			catch (SQLException e) 
			{
				e.printStackTrace();
			}
		}
		return coachingHmap;
	}
}