/*
 * Decompiled with CFR 0.152.
 */
package ibase.system.config;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoCredential;
import com.mongodb.client.ListDatabasesIterable;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import com.mongodb.event.ServerHeartbeatFailedEvent;
import com.mongodb.event.ServerHeartbeatStartedEvent;
import com.mongodb.event.ServerHeartbeatSucceededEvent;
import com.mongodb.event.ServerMonitorListener;
import ibase.utility.BaseLogger;
import java.util.ArrayList;
import java.util.List;
import org.bson.Document;

public class BaseMongoClient {
    private final MongoClient mongoClient;
    private final String databaseName;
    private final String uri;
    private PingStatus pingStatus = PingStatus.INIT;

    BaseMongoClient(String uri, String userName, String password) {
        StringBuilder mongoDbUrl = new StringBuilder();
        mongoDbUrl.append("mongodb://").append(userName).append(":").append(password).append("@").append(uri);
        MongoClientOptions.Builder builder = MongoClientOptions.builder().addServerMonitorListener((ServerMonitorListener)new LocalServerMonitorListener());
        MongoClientURI clientURI = new MongoClientURI(mongoDbUrl.toString(), builder);
        this.databaseName = clientURI.getDatabase();
        this.mongoClient = new MongoClient(clientURI);
        this.uri = uri;
    }

    public PingStatus pingServer() {
        long start = System.currentTimeMillis();
        while (this.pingStatus == PingStatus.INIT) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException ex) {
                BaseLogger.log("0", null, null, "Wait for heartbeat message");
            }
            if (System.currentTimeMillis() - start <= 8000L) continue;
            this.pingStatus = PingStatus.TIMEOUT;
        }
        return this.pingStatus;
    }

    public void close() {
        this.mongoClient.close();
    }

    public MongoClientOptions getMongoClientOptions() {
        return this.mongoClient.getMongoClientOptions();
    }

    public List<MongoCredential> getCredentialsList() {
        return this.mongoClient.getCredentialsList();
    }

    public MongoCredential getCredential() {
        return this.mongoClient.getCredential();
    }

    public MongoIterable<String> listDatabaseNames() {
        return this.mongoClient.listDatabaseNames();
    }

    public ListDatabasesIterable<Document> listDatabases() {
        return this.mongoClient.listDatabases();
    }

    public <T> ListDatabasesIterable<T> listDatabases(Class<T> clazz) {
        return this.mongoClient.listDatabases(clazz);
    }

    public String getCurrentDatabaseName() {
        return this.databaseName;
    }

    public List<String> getDatabaseNames() {
        ArrayList<String> names = new ArrayList<String>();
        try {
            for (String c : this.listDatabaseNames()) {
                names.add(c);
            }
        }
        catch (Throwable ex) {
            names.add(this.getCurrentDatabaseName());
        }
        return names;
    }

    public MongoDatabase getDatabase(String dbName) {
        return this.mongoClient.getDatabase(dbName);
    }

    public MongoDatabase getDatabase() {
        return this.getDatabase(this.getCurrentDatabaseName());
    }

    public List<MongoDatabase> getDatabases() {
        ArrayList<MongoDatabase> list = new ArrayList<MongoDatabase>();
        for (String dbName : this.getDatabaseNames()) {
            list.add(this.getDatabase(dbName));
        }
        return list;
    }

    public List<String> getCollectionNames(String databaseName) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            MongoDatabase db = this.getDatabase(databaseName);
            if (db != null) {
                for (Document doc : db.listCollections()) {
                    if (!doc.containsKey((Object)"type") || !"collection".equals(doc.get((Object)"type"))) continue;
                    list.add(String.valueOf(doc.get((Object)"name")));
                }
            }
            list.remove("system.indexes");
            list.remove("system.users");
            list.remove("system.views");
            list.remove("system.version");
        }
        catch (Throwable ex) {
            BaseLogger.log("0", null, null, "Cannot list collection names for " + databaseName + ". [" + ex + "]");
        }
        return list;
    }

    public List<String> getViewNames(String databaseName) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            MongoDatabase db = this.getDatabase(databaseName);
            if (db != null) {
                for (Document doc : db.listCollections()) {
                    if (!doc.containsKey((Object)"type") || !"view".equals(doc.get((Object)"type"))) continue;
                    list.add(String.valueOf(doc.get((Object)"name")));
                }
            }
        }
        catch (Throwable ex) {
            BaseLogger.log("0", null, null, "Cannot list collection names for [" + databaseName + ". [" + ex + "]");
        }
        return list;
    }

    public String getURI() {
        return this.uri;
    }

    class LocalServerMonitorListener
    implements ServerMonitorListener {
        LocalServerMonitorListener() {
        }

        public void serverHearbeatStarted(ServerHeartbeatStartedEvent serverHeartbeatStartedEvent) {
        }

        public void serverHeartbeatSucceeded(ServerHeartbeatSucceededEvent serverHeartbeatSucceededEvent) {
            BaseMongoClient.this.pingStatus = PingStatus.SUCCEED;
        }

        public void serverHeartbeatFailed(ServerHeartbeatFailedEvent serverHeartbeatFailedEvent) {
            BaseMongoClient.this.pingStatus = PingStatus.FAILED;
        }
    }

    public static enum PingStatus {
        INIT,
        SUCCEED,
        FAILED,
        TIMEOUT;

    }
}

