package test;

import java.io.File;
import java.util.Properties;

import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class ImageEmailSender {	

    public static void sendEmailWithEmbeddedImage(String to, String subject, String body, String imagePath) {
        // Sender's email address and password
        final String username = "gagandeep.bhatia@proteustech.in";
        final String password = "Proteus@7878";

        // SMTP properties
        Properties props = new Properties();
        props.put("mail.smtp.auth", "true");
        props.put("mail.smtp.starttls.enable", "true");
        props.put("mail.smtp.host", "smtp.gmail.com");
        props.put("mail.smtp.port", "587");

        // Create a session with authentication
        Session session = Session.getInstance(props, new Authenticator() {
            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(username, password);
            }
        });

        try {
            // Create a new message
            Message message = new MimeMessage(session);

            // Set From: header field
            message.setFrom(new InternetAddress(username));

            // Set To: header field
            message.setRecipients(Message.RecipientType.TO, InternetAddress.parse(to));

            // Set Subject: header field
            message.setSubject(subject);

            // Create a multipart message
            Multipart multipart = new MimeMultipart("related");

            // First part (the html)
            BodyPart messageBodyPart = new MimeBodyPart();
            String htmlText = "<html><body>" + body + "<br><img src=\"cid:image\"></body></html>";
            messageBodyPart.setContent(htmlText, "text/html");
            multipart.addBodyPart(messageBodyPart);
            
            File imageFile = new File(imagePath);

            // Second part (the image)
            messageBodyPart = new MimeBodyPart();
            DataSource fds = new FileDataSource(imagePath);
            messageBodyPart.setDataHandler(new DataHandler(fds));
            messageBodyPart.setHeader("Content-ID", "<image>");
            messageBodyPart.setDisposition(MimeBodyPart.INLINE);
            messageBodyPart.setFileName(imageFile.getName());
            multipart.addBodyPart(messageBodyPart);

            // Set the content of the message
            message.setContent(multipart);

            // Send the message
            Transport.send(message);

            System.out.println("Email sent successfully");

        } catch (MessagingException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
//        String to = "kandarp.baghar@proteustech.in";
        String to = "kandarp.baghar@proteustech.in";
        String subject = "Test Email with Embedded Image";
        String body = "This is a test email with an embedded image:";
        String imagePath = "/home/gsb/Pictures/vision.png";

        sendEmailWithEmbeddedImage(to, subject, body, imagePath);
    }
}