/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.bean;

import ibase.system.config.AppConnectParm;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.ITMBrowFormEJB;
import ibase.webitm.utility.I18NLabel;
import ibase.webitm.utility.ITMException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import javax.naming.InitialContext;
import org.w3c.dom.Document;

public class ITMBrowFormBean
implements Serializable {
    String objName;
    String pContext = "1";
    String objContext = "1";
    String editFlag = "V";
    String reqParamStr = "";
    String user_lang = "en";
    String user_country = "US";
    UserInfoBean userInfo = null;
    private String editor = "WebEditor";

    public String getEditor() {
        return this.editor;
    }

    public void setEditor(String editor) {
        this.editor = editor;
    }

    public void setObjName(String objName) {
        this.objName = objName;
    }

    public String getObjName() {
        return this.objName;
    }

    public void setPContext(String pContext) {
        if (pContext != null && !"null".equalsIgnoreCase(pContext) && pContext.length() > 0) {
            this.pContext = pContext;
        }
    }

    public String getPContext() {
        return this.pContext;
    }

    public void setObjContext(String objContext) {
        if (objContext != null && !"null".equalsIgnoreCase(objContext) && objContext.length() > 0) {
            this.objContext = objContext;
        }
    }

    public String getObjContext() {
        return this.objContext;
    }

    public void setEditFlag(String editFlag) {
        if (editFlag != null && !"null".equalsIgnoreCase(editFlag) && editFlag.length() > 0) {
            this.editFlag = editFlag;
        }
    }

    public String getEditFlag() {
        return this.editFlag;
    }

    public void setRequestParamStr(String reqParamStr) {
        if (reqParamStr != null && !"null".equalsIgnoreCase(reqParamStr) && reqParamStr.length() > 0) {
            this.reqParamStr = reqParamStr;
        }
    }

    public void setUserInfo(UserInfoBean userInfo) {
        this.userInfo = userInfo;
    }

    private String getDefaultPath() {
        String defaultPath = null;
        defaultPath = CommonConstants.APPLICATION_CONTEXT != null ? String.valueOf(CommonConstants.APPLICATION_CONTEXT) + "webitm" + File.separator : ".." + File.separator + "webapps" + File.separator + "ibase" + File.separator + "webitm" + File.separator;
        return defaultPath;
    }

    public String getXSLFileName(String transDB) throws ITMException {
        String retFileName = null;
        try {
            String defaultPath = "";
            String fileName = String.valueOf(this.objName) + this.pContext + this.objContext + "_" + this.user_lang + "_" + this.user_country + "_" + this.editFlag + ".xsl";
            HashMap<String, String> propEditorInfoMap = new HashMap<String, String>();
            if (this.userInfo != null) {
                propEditorInfoMap.put("PROFILE_ID_RES", this.userInfo.getProfileIdRes());
                propEditorInfoMap.put("ENTERPRISE_ID_RES", this.userInfo.getEnterprise());
                propEditorInfoMap.put("USER_ID", this.userInfo.getLoginCode());
            }
            propEditorInfoMap.put("EDITOR", this.getEditor());
            defaultPath = new E12GenericUtility().getWebEditorXslPath(propEditorInfoMap, transDB);
            File xslFile = new File(defaultPath, fileName);
            if (xslFile.exists()) {
                BaseLogger.log("3", this.userInfo, null, "XSL File Exists........");
                retFileName = xslFile.getName();
            } else {
                BaseLogger.log("3", this.userInfo, null, "XSL File does not exist........");
                String xslString = this.getBrowFormXSLStr(transDB);
                if (!xslString.endsWith(".xsl")) {
                    byte[] buffer = xslString.getBytes();
                    int bytes = buffer.length;
                    FileOutputStream fos = new FileOutputStream(xslFile);
                    fos.write(buffer, 0, bytes);
                    fos.flush();
                    fos.close();
                    fos = null;
                    retFileName = xslFile.getName();
                } else {
                    retFileName = xslString;
                }
            }
        }
        catch (ITMException itme) {
            BaseLogger.log("0", this.userInfo, null, "ITMException: ITMBrowFormBean: getXSLFileName :==>" + itme);
            retFileName = null;
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception: ITMBrowFormBean :getXSLFileName :==>" + e);
            retFileName = null;
            e.printStackTrace();
            throw new ITMException(e);
        }
        BaseLogger.log("2", this.userInfo, null, "Returning XSL File Name :[" + retFileName + "]");
        return retFileName;
    }

    public String getXMLStr() throws ITMException {
        BaseLogger.log("2", this.userInfo, null, "Getting Brow Form XML String....");
        InitialContext ctx = null;
        String xmlString = null;
        try {
            AppConnectParm appConnect = new AppConnectParm();
            ctx = new InitialContext(appConnect.getProperty());
            ITMBrowFormEJB ITMBrowForm = new ITMBrowFormEJB();
            xmlString = ITMBrowForm.getBrowForm(this.objName, this.objContext, String.valueOf(this.objName) + this.pContext + this.objContext, this.reqParamStr, this.userInfo);
            ITMBrowForm = null;
        }
        catch (ITMException itme) {
            BaseLogger.log("0", this.userInfo, null, "ITMException :ITMBrowFormBean :getXmlStr :==>");
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception :ITMBrowFormBean :getXmlStr :==>");
            e.printStackTrace();
            throw new ITMException(e);
        }
        BaseLogger.log("9", this.userInfo, null, "Returning XML String Length :[" + xmlString.length() + "]bytes");
        return xmlString;
    }

    private String getBrowFormXSLStr(String transDB) throws Exception {
        BaseLogger.log("2", this.userInfo, null, "Building XSL Str......");
        String xslString = null;
        try {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("IS_TAX_APPL", new Boolean(false));
            paramMap.put("KEY_FLAG", new String());
            paramMap.put("EDIT_TMPLT", new Integer(1));
            paramMap.put("CONFIRM_COL", "");
            paramMap.put("CONFIRM_VAL", "");
            I18NLabel localizer = new I18NLabel();
            Document metaDataDoc = null;
            HashMap<String, String> propEditorInfoMap = new HashMap<String, String>();
            if (this.userInfo != null) {
                propEditorInfoMap.put("PROFILE_ID_RES", this.userInfo.getProfileIdRes());
                propEditorInfoMap.put("ENTERPRISE_ID_RES", this.userInfo.getEnterprise());
                propEditorInfoMap.put("USER_ID", this.userInfo.getLoginCode().trim());
            }
            propEditorInfoMap.put("EDITOR", this.getEditor());
            metaDataDoc = localizer.setLocaleLabels(this.objName, this.objContext, this.user_lang, this.user_country, this.pContext, this.editFlag, propEditorInfoMap, this.userInfo);
            xslString = localizer.getXSL(this.editFlag, CommonConstants.APPLICATION_CONTEXT, paramMap, this.userInfo);
            StringBuffer xslStrinBuff = new StringBuffer(xslString);
            xslString = xslStrinBuff.toString();
        }
        catch (ITMException itme) {
            BaseLogger.log("0", this.userInfo, null, "ITMException: ITMBrowFormBean :getBrowFormXSLStr:==>" + itme);
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception: ITMBrowFormBean :getBrowFormXSLStr:==>" + e);
            e.printStackTrace();
            throw new ITMException(e);
        }
        BaseLogger.log("2", this.userInfo, null, "Returning XSL String Length :[" + xslString.length() + "]bytes");
        return xslString;
    }

    public String getXSLFileName(UserInfoBean userInfo) throws ITMException {
        String retFileName = null;
        try {
            String defaultPath = "";
            String fileName = String.valueOf(this.objName) + this.pContext + this.objContext + "_" + this.user_lang + "_" + this.user_country + "_" + this.editFlag + ".xsl";
            HashMap<String, String> propEditorInfoMap = new HashMap<String, String>();
            if (userInfo != null) {
                propEditorInfoMap.put("PROFILE_ID_RES", userInfo.getProfileIdRes());
                propEditorInfoMap.put("ENTERPRISE_ID_RES", userInfo.getEnterprise());
                propEditorInfoMap.put("USER_ID", userInfo.getLoginCode());
            }
            propEditorInfoMap.put("EDITOR", this.getEditor());
            defaultPath = new E12GenericUtility().getWebEditorXslPath(propEditorInfoMap, userInfo.getTransDB());
            File xslFile = new File(defaultPath, fileName);
            if (xslFile.exists()) {
                BaseLogger.log("3", userInfo, null, "XSL File Exists........");
                retFileName = xslFile.getName();
            } else {
                BaseLogger.log("3", userInfo, null, "XSL File does not exist........");
                String xslString = this.getBrowFormXSLStr(userInfo);
                if (!xslString.endsWith(".xsl")) {
                    byte[] buffer = xslString.getBytes();
                    int bytes = buffer.length;
                    FileOutputStream fos = new FileOutputStream(xslFile);
                    fos.write(buffer, 0, bytes);
                    fos.flush();
                    fos.close();
                    fos = null;
                    retFileName = xslFile.getName();
                } else {
                    retFileName = xslString;
                }
            }
        }
        catch (ITMException itme) {
            BaseLogger.log("0", userInfo, null, "ITMException: ITMBrowFormBean: getXSLFileName :==>" + itme);
            retFileName = null;
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", userInfo, null, "Exception: ITMBrowFormBean :getXSLFileName :==>" + e);
            retFileName = null;
            e.printStackTrace();
            throw new ITMException(e);
        }
        BaseLogger.log("2", userInfo, null, "Returning XSL File Name :[" + retFileName + "]");
        return retFileName;
    }

    private String getBrowFormXSLStr(UserInfoBean userInfo) throws Exception {
        BaseLogger.log("2", userInfo, null, "Building XSL Str......");
        String xslString = null;
        try {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("IS_TAX_APPL", new Boolean(false));
            paramMap.put("KEY_FLAG", new String());
            paramMap.put("EDIT_TMPLT", new Integer(1));
            paramMap.put("CONFIRM_COL", "");
            paramMap.put("CONFIRM_VAL", "");
            I18NLabel localizer = new I18NLabel();
            Document metaDataDoc = null;
            HashMap<String, String> propEditorInfoMap = new HashMap<String, String>();
            if (this.userInfo != null) {
                propEditorInfoMap.put("PROFILE_ID_RES", this.userInfo.getProfileIdRes());
                propEditorInfoMap.put("ENTERPRISE_ID_RES", this.userInfo.getEnterprise());
                propEditorInfoMap.put("USER_ID", this.userInfo.getLoginCode().trim());
            }
            propEditorInfoMap.put("EDITOR", this.getEditor());
            metaDataDoc = localizer.setLocaleLabels(this.objName, this.objContext, this.user_lang, this.user_country, this.pContext, this.editFlag, propEditorInfoMap, userInfo);
            xslString = localizer.getXSL(this.editFlag, CommonConstants.APPLICATION_CONTEXT, paramMap, userInfo);
            StringBuffer xslStrinBuff = new StringBuffer(xslString);
            xslString = xslStrinBuff.toString();
        }
        catch (ITMException itme) {
            BaseLogger.log("0", userInfo, null, "ITMException: ITMBrowFormBean :getBrowFormXSLStr:==>" + itme);
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", userInfo, null, "Exception: ITMBrowFormBean :getBrowFormXSLStr:==>" + e);
            e.printStackTrace();
            throw new ITMException(e);
        }
        BaseLogger.log("2", userInfo, null, "Returning XSL String Length :[" + xslString.length() + "]bytes");
        return xslString;
    }
}

