/*
 * Decompiled with CFR 0.152.
 */
package ibase.servlet;

import com.fasterxml.jackson.databind.ObjectMapper;
import ibase.entity.Employee;
import ibase.entity.FeedbackCalendar;
import ibase.entity.Holiday;
import ibase.entity.Leave;
import ibase.entity.Plan;
import ibase.entity.PlanSchedule;
import ibase.entity.Report;
import ibase.util.EmployeeDao;
import ibase.utility.BaseLogger;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONArray;
import org.json.JSONObject;

@WebServlet(value={"/emp"})
public class EmployeeServlet
extends HttpServlet {
    EmployeeDao empDao = new EmployeeDao();
    List<String> employeeCodeList = new ArrayList<String>();
    List<Report> employeeReportList = new ArrayList<Report>();
    List<String> selectedEmpCode = new ArrayList<String>();
    List<Employee> empList = new ArrayList<Employee>();
    List<Plan> empPlanList = new ArrayList<Plan>();
    private static final long serialVersionUID = 1L;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        try {
            BaseLogger.log((String)"0", null, null, (Object)"Running emp servlet");
            this.empList = this.empDao.getEmpList();
            request.setAttribute("reportList", this.employeeReportList);
            request.setAttribute("empList", this.empList);
            BaseLogger.log((String)"0", null, null, (Object)("Employee List=" + this.empList));
            JSONArray jsonArray = new JSONArray();
            for (Employee emp : this.empList) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("empcode", (Object)emp.getEmpcode());
                jsonObject.put("name", (Object)emp.getName());
                jsonArray.put((Object)jsonObject);
            }
            String json = jsonArray.toString();
            BaseLogger.log((String)"0", null, null, (Object)("EmpList json from planview sevlet " + json));
            response.setContentType("application/json");
            PrintWriter writer = response.getWriter();
            writer.print(json);
            BaseLogger.log((String)"0", null, null, (Object)"dispatch servlet done");
        }
        catch (Exception e) {
            BaseLogger.log((String)"0", null, null, (Object)("Error in emp servlet " + e.getMessage()));
            e.printStackTrace();
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        SimpleDateFormat formate = new SimpleDateFormat("yyyy/MM/dd");
        response.setContentType("application/json");
        String action = request.getParameter("action");
        if (action.equalsIgnoreCase("holiday")) {
            String startDate = request.getParameter("start");
            String endDate = request.getParameter("end");
            List<Holiday> holidays = this.empDao.getHoliday(startDate, endDate);
            String json = new ObjectMapper().writeValueAsString(holidays);
            response.getWriter().write(json);
            BaseLogger.log((String)"0", null, null, (Object)("Holidays=" + holidays));
            return;
        }
        if (action.equalsIgnoreCase("leave")) {
            String startDate = request.getParameter("start");
            String endDate = request.getParameter("end");
            String empCode = request.getParameter("empcode");
            List<Leave> leaves = this.empDao.getLeave(empCode, startDate, endDate);
            String json = new ObjectMapper().writeValueAsString(leaves);
            response.getWriter().write(json);
            return;
        }
        if (action.equalsIgnoreCase("feedbackcalendar")) {
            try {
                this.selectedEmpCode = Arrays.asList(request.getParameterValues("empcode[]"));
                ArrayList<String> empcode = new ArrayList<String>();
                String date = request.getParameter("date");
                if (this.selectedEmpCode.contains(" All")) {
                    empcode.clear();
                    empcode.addAll(this.empDao.getEmployeeCodes());
                } else {
                    empcode.addAll(this.selectedEmpCode);
                }
                date = formate.format(new SimpleDateFormat("dd-MMM-yyy").parse(date));
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy/MM/dd");
                LocalDate d = LocalDate.parse(date, formatter);
                LocalDate start = d.withDayOfMonth(1);
                LocalDate last = d.withDayOfMonth(d.lengthOfMonth());
                Map<String, List<FeedbackCalendar>> map = new EmployeeDao().getFeedbackCalendar(start, last, empcode);
                BaseLogger.log((String)"0", null, null, (Object)("Feedback calendar map=" + map));
                JSONArray jsonArray = new JSONArray();
                for (Map.Entry<String, List<FeedbackCalendar>> entry : map.entrySet()) {
                    JSONObject jsonObj = new JSONObject();
                    jsonObj.put(entry.getKey(), (Collection)entry.getValue());
                    jsonArray.put((Object)jsonObj);
                }
                String json = new ObjectMapper().writeValueAsString(map);
                BaseLogger.log((String)"0", null, null, (Object)("Feedback calendar json String =" + json));
                response.getWriter().write(json);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return;
        }
        if (action.equalsIgnoreCase("plancalendar")) {
            try {
                this.selectedEmpCode = Arrays.asList(request.getParameterValues("empcode[]"));
                ArrayList<String> empcode = new ArrayList<String>();
                String date = request.getParameter("date");
                if (this.selectedEmpCode.contains(" All")) {
                    empcode.clear();
                    empcode.addAll(this.empDao.getEmployeeCodes());
                } else {
                    empcode.addAll(this.selectedEmpCode);
                }
                date = formate.format(new SimpleDateFormat("dd-MMM-yyy").parse(date));
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy/MM/dd");
                LocalDate d = LocalDate.parse(date, formatter);
                LocalDate start = d.withDayOfMonth(1);
                LocalDate last = d.withDayOfMonth(d.lengthOfMonth());
                Map<String, List<Plan>> map = this.empDao.getPlanCalendar(start, last, empcode);
                String json = new ObjectMapper().writeValueAsString(map);
                response.getWriter().write(json);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return;
        }
        String requestid = request.getParameter("requestid");
        if (action.equalsIgnoreCase("currentStatus")) {
            String empcode = request.getParameter("empcode");
            response.setContentType("text/plain;charset=UTF-8");
            response.getWriter().write(String.valueOf(this.empDao.getEmployeeEmailid(empcode)) + " " + this.empDao.getCurrentStatus(requestid));
            return;
        }
        this.selectedEmpCode = Arrays.asList(request.getParameterValues("empCode[]"));
        String dateFrom = request.getParameter("dateFrom");
        String dateTo = request.getParameter("dateTo");
        try {
            dateFrom = formate.format(new SimpleDateFormat("dd-MMM-yyy").parse(dateFrom));
            dateTo = formate.format(new SimpleDateFormat("dd-MMM-yyy").parse(dateTo));
        }
        catch (ParseException e1) {
            e1.printStackTrace();
        }
        if (Arrays.asList(request.getParameterValues("empCode[]")).contains(" All")) {
            this.selectedEmpCode = new ArrayList<String>();
            this.selectedEmpCode.addAll(this.empDao.getEmployeeCodes());
        }
        if (action.equalsIgnoreCase("feedback")) {
            this.employeeReportList.clear();
            String totalRecord = request.getParameter("totalRecord");
            if (totalRecord.equals("y")) {
                int count = this.empDao.getFeedbackDataCount(this.selectedEmpCode, dateFrom, dateTo, requestid);
                BaseLogger.log((String)"0", null, null, (Object)("Total Record Count=" + count));
                response.getWriter().write(String.valueOf(count));
            } else {
                int offset = Integer.parseInt(request.getParameter("offset"));
                int limit = Integer.parseInt(request.getParameter("limit"));
                BaseLogger.log((String)"0", null, null, (Object)("Offset=" + offset + " limit=" + limit));
                this.employeeReportList = this.empDao.getData(this.selectedEmpCode, dateFrom, dateTo, requestid, offset, limit);
                if (this.employeeReportList.isEmpty()) {
                    response.setContentType("text/plain;charset=UTF-8");
                    response.getWriter().write("No data to show");
                } else {
                    JSONArray jsonArray = this.getReport(this.employeeReportList);
                    response.getWriter().write(jsonArray.toString());
                }
            }
        } else if (action.equalsIgnoreCase("plan")) {
            this.empPlanList.clear();
            String totalRecord = request.getParameter("totalRecord");
            if (totalRecord.equals("y")) {
                int count = this.empDao.getPlanDataCount(this.selectedEmpCode, dateFrom, dateTo, requestid);
                BaseLogger.log((String)"0", null, null, (Object)("Total Record Count for Plan=" + count));
                response.getWriter().write(String.valueOf(count));
            } else {
                int offset = Integer.parseInt(request.getParameter("offset"));
                int limit = Integer.parseInt(request.getParameter("limit"));
                BaseLogger.log((String)"0", null, null, (Object)("get plan report data Offset=" + offset + " limit=" + limit));
                this.empPlanList = this.empDao.getPlanReport(this.selectedEmpCode, dateFrom, dateTo, requestid, offset, limit);
                BaseLogger.log((String)"0", null, null, (Object)("empPlanList size=" + this.empPlanList.size()));
                if (this.empPlanList.isEmpty()) {
                    response.setContentType("text/plain;charset=UTF-8");
                    response.getWriter().write("No data to show");
                } else {
                    JSONArray jsonArray = this.getPlanReport(this.empPlanList);
                    response.getWriter().write(jsonArray.toString());
                }
            }
        } else if (action.equalsIgnoreCase("plangantt")) {
            BaseLogger.log((String)"0", null, null, (Object)"calling plangantt");
            this.empPlanList.clear();
            BaseLogger.log((String)"0", null, null, (Object)("empPlanList after clearing =" + this.empPlanList));
            this.empPlanList = this.empDao.getPlanReport(this.selectedEmpCode, dateFrom, dateTo, requestid, 0, 0);
            if (this.empPlanList.isEmpty()) {
                response.setContentType("text/plain;charset=UTF-8");
                response.getWriter().write("No data to show");
            } else {
                for (Plan plan : this.empPlanList) {
                    PlanSchedule pl = new PlanSchedule();
                    pl.setActiondtl(plan.getActiondtl());
                    pl.setDate(plan.getDate());
                    pl.setDescription(plan.getDescription());
                    pl.setEnddate(plan.getEnddate());
                    pl.setName(plan.getName());
                    pl.setRequestid(plan.getRequestid());
                    pl.setTime(plan.getTime());
                }
                this.empPlanList = this.getEndDate();
                String json = new ObjectMapper().writeValueAsString(this.empPlanList);
                BaseLogger.log((String)"0", null, null, (Object)("empPlanList=" + this.empPlanList));
                response.getWriter().write(json);
            }
        }
    }

    public JSONArray getReport(List<Report> list) {
        JSONArray jsonArray = new JSONArray();
        try {
            for (Report rt : list) {
                JSONObject formDetailsJson = new JSONObject();
                formDetailsJson.put("person", (Object)rt.getPerson());
                formDetailsJson.put("date", (Object)rt.getDate());
                formDetailsJson.put("description", (Object)rt.getDescription());
                formDetailsJson.put("requestid", (Object)rt.getRequestId());
                formDetailsJson.put("status", (Object)rt.getStatus());
                formDetailsJson.put("actiondtl", (Object)rt.getActiondtl());
                formDetailsJson.put("stdtime", rt.getStdtime());
                formDetailsJson.put("startdate", (Object)rt.getStartdate());
                formDetailsJson.put("timespend", rt.getTimespend());
                jsonArray.put((Object)formDetailsJson);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jsonArray;
    }

    public JSONArray getPlanReport(List<Plan> list) {
        JSONArray jsonArray = new JSONArray();
        try {
            for (Plan plan : list) {
                JSONObject formDetailsJson = new JSONObject();
                formDetailsJson.put("person", (Object)plan.getName());
                formDetailsJson.put("date", (Object)plan.getDate());
                formDetailsJson.put("requestid", (Object)plan.getRequestid());
                formDetailsJson.put("description", (Object)plan.getDescription());
                formDetailsJson.put("time", plan.getTime());
                formDetailsJson.put("actiondtl", (Object)plan.getActiondtl());
                jsonArray.put((Object)formDetailsJson);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jsonArray;
    }

    List<String> getList() {
        return this.empDao.getEmployeeCodeName();
    }

    void getAllParameters(HttpServletRequest req) {
        Enumeration parameterNames = req.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String paramName = (String)parameterNames.nextElement();
            String[] paramValues = req.getParameterValues(paramName);
            int i = 0;
            while (i < paramValues.length) {
                String paramValue = paramValues[i];
                BaseLogger.log((String)"0", null, null, (Object)("Parameter =[name=" + paramName + ", value=" + paramValue + "]"));
                ++i;
            }
        }
    }

    public List<Plan> getEndDate() {
        DateTimeFormatter formatterStr = DateTimeFormatter.ofPattern("dd-MMM-YYYY");
        List<Holiday> holidays = this.empDao.getHoliday();
        ArrayList<Plan> newPlanList = new ArrayList<Plan>();
        for (Plan plan : this.empPlanList) {
            String[] name1;
            String[] name2;
            int leave;
            LocalDate planEndDate = this.getActualEndDate(plan.getTime(), plan.getDate());
            LocalDate start = this.getLocalDate(plan.getDate());
            int holiday = this.getHolidatDays(start, planEndDate, holidays);
            if (holiday == (leave = this.getLeave((name2 = (name1 = plan.getName().split("\\("))[1].split("\\)"))[0], start, planEndDate))) {
                plan.setEnddate(formatterStr.format(planEndDate.plusDays(holiday)));
            } else if (holiday > leave) {
                plan.setEnddate(formatterStr.format(planEndDate.plusDays(holiday - leave)));
            } else {
                plan.setEnddate(formatterStr.format(planEndDate.plusDays(leave - holiday)));
            }
            LocalDate planStart = this.getLocalDate(plan.getDate());
            LocalDate planEnd = this.getLocalDate(plan.getEnddate());
            int weekend = 0;
            LocalDate date = planStart;
            while (date.isBefore(planEnd.plusDays(1L))) {
                if (date.getDayOfWeek() == DayOfWeek.SATURDAY) {
                    weekend += 2;
                }
                date = date.plusDays(1L);
            }
            planEnd = planEnd.plusDays(weekend);
            plan.setEnddate(formatterStr.format(planEnd));
            newPlanList.add(plan);
        }
        return newPlanList;
    }

    public int getHolidatDays(LocalDate start, LocalDate end, List<Holiday> holidays) {
        int day = 0;
        for (Holiday h : holidays) {
            if (!h.getStart().isAfter(start) || !h.getStart().isBefore(end.plusDays(1L))) continue;
            day = (int)ChronoUnit.DAYS.between(h.getStart(), h.getEnd().plusDays(1L));
        }
        return day;
    }

    public int getLeave(String empcode, LocalDate start, LocalDate end) {
        List<Leave> list = this.empDao.getLeave(empcode);
        int day = 0;
        for (Leave l : list) {
            if (!l.getStartdate().isAfter(start) || !l.getStartdate().isBefore(end.plusDays(1L))) continue;
            day = (int)ChronoUnit.DAYS.between(l.getStartdate(), l.getEnddate().plusDays(1L));
        }
        return day;
    }

    public LocalDate getLocalDate(String date) {
        SimpleDateFormat formate = new SimpleDateFormat("dd-MMM-yyyy");
        try {
            Date d = formate.parse(date);
            Calendar cal = Calendar.getInstance();
            cal.setTime(d);
            return LocalDateTime.ofInstant(cal.toInstant(), cal.getTimeZone().toZoneId()).toLocalDate();
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    LocalDate getActualEndDate(int stdtime, String startDate) {
        try {
            int time = (int)Math.ceil(stdtime / 9);
            SimpleDateFormat formate = new SimpleDateFormat("dd-MMM-yyyy");
            Date dateStart = formate.parse(startDate);
            Calendar cal = Calendar.getInstance();
            cal.setTime(dateStart);
            LocalDate start = LocalDateTime.ofInstant(cal.toInstant(), cal.getTimeZone().toZoneId()).toLocalDate();
            LocalDate end = start.plusDays(time);
            int i = 0;
            LocalDate date = start;
            while (date.isBefore(end)) {
                DayOfWeek day = date.getDayOfWeek();
                if (day.getValue() == 6 || day.getValue() == 7) {
                    ++i;
                }
                date = date.plusDays(1L);
            }
            LocalDate newEnd = start.plusDays(time += i);
            return newEnd;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

