/*
 * Decompiled with CFR 0.152.
 */
package ibase.scheduler.bean;

import ibase.scheduler.ejb.ScheduleInfoEJB;
import ibase.system.config.AppConnectParm;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SchedulerParamParserBean {
    static String SCHEDULE_FILEPATH = null;
    Document schedulerDom = null;
    Node currSchNode = null;

    public SchedulerParamParserBean() {
        try {
            if (CommonConstants.TOMCAT_HOME == null || CommonConstants.TOMCAT_HOME.trim().length() == 0) {
                CommonConstants.setIBASEHOME();
            }
            SCHEDULE_FILEPATH = String.valueOf(CommonConstants.APPLICATION_CONTEXT) + File.separator + "setting" + File.separator + "ScheduleProperties.xml";
            this.parse();
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :SchedulerParamParserBean :==>\n" + e.getMessage());
        }
    }

    private void parse() throws Exception {
        BaseLogger.log("2", null, null, "Parsing file :\n" + SCHEDULE_FILEPATH);
        try {
            File f = new File(SCHEDULE_FILEPATH);
            BaseLogger.log("3", null, null, f.getPath());
            if (f.exists()) {
                DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                AppConnectParm appConnect = new AppConnectParm();
                Properties p = appConnect.getProperty();
                InitialContext ctx = new InitialContext(p);
                ScheduleInfoEJB sEJB = new ScheduleInfoEJB();
                String schXMLString = sEJB.getAllScheduledFromDB();
                E12GenericUtility genericUtility = new E12GenericUtility();
                this.schedulerDom = genericUtility.parseString(schXMLString);
            } else {
                BaseLogger.log("3", null, null, "ScheduleProperties.xml file doesn't exist");
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :SchedulerParamParserBean :parse :==>\n" + e.getMessage());
            throw e;
        }
    }

    public ArrayList getAllScheduleNameList() throws Exception {
        BaseLogger.log("2", null, null, "[SchedulerParamParserBean]Getting all schedule names list .....");
        ArrayList<String> scheduleNamesList = null;
        try {
            scheduleNamesList = new ArrayList<String>();
            NodeList ndList = this.schedulerDom.getElementsByTagName("SCHEDULE");
            int i = 0;
            while (i < ndList.getLength()) {
                Node scheduleNode = ndList.item(i);
                NodeList childList = scheduleNode.getChildNodes();
                Object scheduleName = null;
                int ctr = 0;
                while (ctr < childList.getLength()) {
                    Node currScheduleNode = childList.item(ctr);
                    if (!currScheduleNode.getNodeName().equalsIgnoreCase("#text") && currScheduleNode.getNodeName().equalsIgnoreCase("NAME")) {
                        scheduleNamesList.add(currScheduleNode.getFirstChild() != null ? currScheduleNode.getFirstChild().getNodeValue() : "");
                    }
                    ++ctr;
                }
                ++i;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :SchedulerParamParserBean :getAllScheduleNameList :==>\n" + e.getMessage());
            throw e;
        }
        BaseLogger.log("2", null, null, "[SchedulerParamParserBean]Returning scheduleNamesList ......");
        return scheduleNamesList;
    }

    public HashMap getDetails(String schedulerName) throws Exception {
        BaseLogger.log("2", null, null, "[SchedulerParamParserBean]Getting details of the scheduler :" + schedulerName + ":");
        HashMap<String, String> scheduleDetailMap = null;
        try {
            scheduleDetailMap = new HashMap<String, String>();
            NodeList ndList = this.schedulerDom.getElementsByTagName("SCHEDULE");
            int i = 0;
            while (i < ndList.getLength()) {
                Node scheduleNode = ndList.item(i);
                String NodeName = scheduleNode.getNodeName();
                if (scheduleNode.getAttributes().getNamedItem("id").getNodeValue().equals(schedulerName)) {
                    this.currSchNode = scheduleNode;
                    NodeList childList = scheduleNode.getChildNodes();
                    int ctr = 0;
                    while (ctr < childList.getLength()) {
                        String nodeValue;
                        String nodeName = childList.item(ctr).getNodeName();
                        String string = nodeValue = childList.item(ctr).getFirstChild() != null ? childList.item(ctr).getFirstChild().getNodeValue() : "";
                        if (!nodeName.equalsIgnoreCase("#text")) {
                            if (nodeName.equalsIgnoreCase("SCHEDULE_OBJ")) {
                                NodeList schObjList = childList.item(ctr).getChildNodes();
                                int sCtr = 0;
                                while (sCtr < schObjList.getLength()) {
                                    if (!schObjList.item(sCtr).getNodeName().equalsIgnoreCase("#text")) {
                                        if (schObjList.item(sCtr).getNodeName().equalsIgnoreCase("PARAMS")) {
                                            StringBuffer paramsBuff = new StringBuffer();
                                            NodeList paramsNodeList = schObjList.item(sCtr).getChildNodes();
                                            int noOfParams = paramsNodeList.getLength();
                                            int paramCtr = 0;
                                            while (paramCtr < noOfParams) {
                                                if (!paramsNodeList.item(paramCtr).getNodeName().equalsIgnoreCase("#text")) {
                                                    paramsBuff.append(paramsNodeList.item(paramCtr).getNodeName()).append("=");
                                                    paramsBuff.append(paramsNodeList.item(paramCtr).getFirstChild() != null ? paramsNodeList.item(paramCtr).getFirstChild().getNodeValue() : "").append("\n");
                                                }
                                                ++paramCtr;
                                            }
                                            scheduleDetailMap.put("PARAMS", paramsBuff.toString());
                                        } else {
                                            scheduleDetailMap.put(schObjList.item(sCtr).getNodeName(), schObjList.item(sCtr).getFirstChild() != null ? schObjList.item(sCtr).getFirstChild().getNodeValue() : "");
                                        }
                                    }
                                    ++sCtr;
                                }
                            } else {
                                scheduleDetailMap.put(nodeName, nodeValue);
                            }
                        }
                        ++ctr;
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :SchedulerParamParserBean :getDetails :==>\n" + e.getMessage());
            throw e;
        }
        BaseLogger.log("2", null, null, "[SchedulerParamParserBean]Returning details ......");
        return scheduleDetailMap;
    }

    public void updateDom(String actionMode, String schedulePropertiesStr) throws Exception {
        BaseLogger.log("2", null, null, "[SchedulerParamParserBean]Update dom for actionMode :" + actionMode + ": schedulePropertiesStr :\n" + schedulePropertiesStr);
        try {
            if (actionMode.equalsIgnoreCase("ADD")) {
                this.addSchedule(schedulePropertiesStr);
            } else if (actionMode.equalsIgnoreCase("EDIT")) {
                this.editSchedule(schedulePropertiesStr);
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :SchedulerParamParserBean :updateDom :==>\n" + e.getMessage());
            throw e;
        }
    }

    private void addSchedule(String schedulePropertiesStr) throws Exception {
        try {
            Document currScheduleDom = this.parseString(schedulePropertiesStr);
            String currScheduleID = currScheduleDom.getElementsByTagName("SCHEDULE").item(0).getAttributes().getNamedItem("id").getNodeValue();
            this.appendToDom(currScheduleDom);
            BaseLogger.log("3", null, null, "Node Added");
            this.currSchNode = this.searchNode(this.schedulerDom, currScheduleID);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :SchedulerParamParserBean :addSchedule :==>\n" + e.getMessage());
            throw e;
        }
        BaseLogger.log("2", null, null, "Updated dom string :\n" + this.serializeDom(this.schedulerDom));
    }

    private void editSchedule(String schedulePropertiesStr) throws Exception {
        try {
            Document currScheduleDom = this.parseString(schedulePropertiesStr);
            String currScheduleID = currScheduleDom.getElementsByTagName("SCHEDULE").item(0).getAttributes().getNamedItem("id").getNodeValue();
            BaseLogger.log("3", null, null, "Edited Schedule id :[" + currScheduleID + "] currSchNode :[" + this.currSchNode + "]");
            Node schNode = this.searchNode(this.schedulerDom, currScheduleID);
            BaseLogger.log("3", null, null, "Removing old Scehdule");
            this.schedulerDom.getElementsByTagName("SCHEDULES").item(0).removeChild(schNode);
            BaseLogger.log("3", null, null, "Adding new Scehdule");
            this.appendToDom(currScheduleDom);
            this.currSchNode = this.searchNode(this.schedulerDom, currScheduleID);
            BaseLogger.log("3", null, null, "Updated dom string :\n" + this.serializeDom(this.schedulerDom));
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :SchedulerParamParserBean :editSchedule :==>\n" + e.getMessage());
            throw e;
        }
    }

    public void deleteSchedule(String scheduleID) throws Exception {
        BaseLogger.log("2", null, null, "Deleting schedule corr to ID :" + scheduleID);
        try {
            Node schNode = this.searchNode(this.schedulerDom, scheduleID);
            this.schedulerDom.getElementsByTagName("SCHEDULES").item(0).removeChild(schNode);
            BaseLogger.log("3", null, null, "Schedule deleted .....");
            this.currSchNode = null;
            BaseLogger.log("3", null, null, "Updated dom string :\n" + this.serializeDom(this.schedulerDom));
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :SchedulerParamParserBean :deleteSchedule :==>\n" + e.getMessage());
            throw e;
        }
    }

    public void saveSchedule() throws Exception {
        try {
            File f1 = new File(SCHEDULE_FILEPATH);
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            DOMSource domSource = new DOMSource(this.schedulerDom);
            StreamResult streamResult = new StreamResult(f1);
            TransformerFactory tfactory = TransformerFactory.newInstance();
            Transformer tr = tfactory.newTransformer();
            tr.transform(domSource, streamResult);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :SchedulerParamParserBean :editSchedule :==>\n" + e.getMessage());
            throw e;
        }
    }

    public void updateSchedulerObjName(String schedulerName, String updatedObjNameStr) throws Exception {
        BaseLogger.log("2", null, null, "[SchedulerParamParserBean]Updating ScheduleProperties.xml file for schedulerName :" + schedulerName + ": with updated objName string :" + updatedObjNameStr + ":");
        try {
            String schedulerPropXMLTemplate = String.valueOf(CommonConstants.APPLICATION_CONTEXT) + File.separator + "setting" + File.separator + "ScheduleProperties.xml";
            File f1 = new File(schedulerPropXMLTemplate);
            BaseLogger.log("3", null, null, "DOM Parsing :" + schedulerPropXMLTemplate);
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            AppConnectParm appConnect = new AppConnectParm();
            Properties p = appConnect.getProperty();
            InitialContext ctx = new InitialContext(p);
            ScheduleInfoEJB sEJB = new ScheduleInfoEJB();
            String schXMLString = sEJB.getAllScheduledFromDB();
            E12GenericUtility genericUtility = new E12GenericUtility();
            Document fileDom = genericUtility.parseString(schXMLString);
            NodeList scheduleNodeList = fileDom.getElementsByTagName("SCHEDULE");
            BaseLogger.log("3", null, null, "scheduleNodeList length :" + scheduleNodeList.getLength());
            int ctr = 0;
            while (ctr < scheduleNodeList.getLength()) {
                Node scheduleNode = scheduleNodeList.item(ctr);
                if (scheduleNode.getAttributes().getNamedItem("id").getNodeValue().equals(schedulerName)) {
                    BaseLogger.log("3", null, null, "EDI scheduler node found");
                    NodeList childList = scheduleNode.getChildNodes();
                    int cCtr = 0;
                    while (cCtr < childList.getLength()) {
                        Node childNode = childList.item(cCtr);
                        if (childNode.getNodeName().equalsIgnoreCase("OBJECT_NAME")) {
                            BaseLogger.log("3", null, null, "Setting OBJECT_NAME node value ...");
                            childNode.getFirstChild().setNodeValue(updatedObjNameStr);
                        }
                        ++cCtr;
                    }
                }
                ++ctr;
            }
            DOMSource domSource = new DOMSource(fileDom);
            StreamResult streamResult = new StreamResult(f1);
            TransformerFactory tfactory = TransformerFactory.newInstance();
            Transformer tr = tfactory.newTransformer();
            tr.transform(domSource, streamResult);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :SchedulerParamParserBean :updateSchedulerObjName :==>\n" + e.getMessage());
            throw e;
        }
    }

    private void appendToDom(Document tempChildDom) throws Exception {
        try {
            BaseLogger.log("3", null, null, "Before SchedulerDom :" + this.serializeDom(this.schedulerDom));
            if (this.schedulerDom != null) {
                NodeList schedulesList = this.schedulerDom.getElementsByTagName("SCHEDULES");
                NodeList newScheduleList = tempChildDom.getElementsByTagName("SCHEDULE");
                int len = newScheduleList.getLength();
                int j = 0;
                while (j < len) {
                    Node nDetail = newScheduleList.item(j);
                    Node importedNode = this.schedulerDom.importNode(nDetail, true);
                    BaseLogger.log("3", null, null, "Appending :" + this.serializeDom(nDetail));
                    schedulesList.item(0).appendChild(importedNode);
                    ++j;
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :SchedulerParamParserBean :appendToDomForedit :\n" + e.getMessage());
            throw e;
        }
        BaseLogger.log("2", null, null, "After SchedulerDom :" + this.serializeDom(this.schedulerDom));
    }

    private Node searchNode(Document dom, String schName) throws Exception {
        Node tabNode = null;
        try {
            NodeList tabNodeList = dom.getElementsByTagName("SCHEDULE");
            int ctr = 0;
            while (ctr < tabNodeList.getLength()) {
                Node currTabNode = tabNodeList.item(ctr);
                if (currTabNode.getAttributes().getNamedItem("id").getNodeValue().equals(schName)) {
                    tabNode = currTabNode;
                    break;
                }
                ++ctr;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :SchedulerParamParserBean :searchNode :==>\n" + e.getMessage());
            throw e;
        }
        return tabNode;
    }

    private Document parseString(String xmlString) throws Exception {
        Document dom = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setIgnoringComments(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            OutputStreamWriter errorWriter = new OutputStreamWriter((OutputStream)System.err, CommonConstants.ENCODING);
            ByteArrayInputStream baos = new ByteArrayInputStream(xmlString.getBytes());
            dom = db.parse(baos);
        }
        catch (Exception e) {
            dom = null;
            BaseLogger.log("0", null, null, "Exception :SchedulerParamParserBean :parseString :==>\n" + e.getMessage());
            throw e;
        }
        return dom;
    }

    private String serializeDom(Node dom) throws Exception {
        String retString = null;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Transformer serializer = TransformerFactory.newInstance().newTransformer();
            serializer.setOutputProperty("omit-xml-declaration", "yes");
            serializer.transform(new DOMSource(dom), new StreamResult(out));
            retString = out.toString();
            out.flush();
            out.close();
            out = null;
        }
        catch (Exception e) {
            retString = null;
            BaseLogger.log("0", null, null, "Exception :SchedulerParamParserBean :serializeDom :==>\n" + e.getMessage());
            throw e;
        }
        return retString;
    }
}

