/*
 * Decompiled with CFR 0.152.
 */
package ibase.system.config;

import com.mongodb.client.MongoDatabase;
import ibase.system.config.BaseMongoClient;
import ibase.system.config.resource.NoSQLConnection;
import java.sql.SQLException;
import java.util.List;

public class BaseMongoConnection
extends NoSQLConnection {
    private final BaseMongoClient client;

    public BaseMongoConnection(String url, String user, String password) throws Exception {
        this.client = new BaseMongoClient(url, user, password);
        this.setCatalog(this.client.getCurrentDatabaseName());
        switch (this.client.pingServer()) {
            case FAILED: {
                throw new SQLException("Connection to server failed.");
            }
            case TIMEOUT: {
                throw new SQLException("Timeout connecting the server.");
            }
        }
    }

    @Override
    public void close() {
        this.client.close();
        super.close();
    }

    public String getUrl() throws SQLException {
        this.checkClosed();
        return this.client.getURI();
    }

    public List<MongoDatabase> getDatabases() throws SQLException {
        this.checkClosed();
        return this.client.getDatabases();
    }

    public List<String> getDatabaseNames() throws SQLException {
        this.checkClosed();
        return this.client.getDatabaseNames();
    }

    public MongoDatabase getDatabase(String name) throws SQLException {
        this.checkClosed();
        return this.client.getDatabase(name);
    }

    public MongoDatabase getDatabase() throws SQLException {
        this.checkClosed();
        return this.client.getDatabase();
    }
}

