/*
 * Decompiled with CFR 0.152.
 */
package ibase.ejb;

import ibase.ejb.E12NotificationLogLocal;
import ibase.ejb.E12NotificationLogRemote;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import javax.ejb.Stateless;

@Stateless
public class E12NotificationLog
extends ValidatorEJB
implements E12NotificationLogLocal,
E12NotificationLogRemote {
    E12GenericUtility genericUtility = new E12GenericUtility();

    @Override
    public String notificationLog(String sendToId, String notificType, String userIdTo, String userIdSend, String msgText, String callerComp, String uuID, long msgId, int status) throws RemoteException, ITMException {
        ConnDriver connDriver = null;
        Connection conn = null;
        Statement pStmt = null;
        String tranID = null;
        String currDate = "";
        try {
            try {
                connDriver = new ConnDriver();
                conn = connDriver.getConnectDB("Driver");
                SimpleDateFormat sdf = new SimpleDateFormat(this.genericUtility.getApplDateFormat());
                currDate = sdf.format(new Date());
                currDate = this.genericUtility.getValidDateTimeString(currDate, this.genericUtility.getApplDateFormat(), this.genericUtility.getDBDateFormat());
                if (uuID == null || uuID.trim().length() == 0) {
                    uuID = UUID.randomUUID().toString().toUpperCase();
                }
                tranID = this.generateTranID(conn);
                BaseLogger.log("3", null, null, "tranID =[" + tranID + "]");
                if (tranID != null && tranID.trim().length() > 0) {
                    String insertSql = "INSERT INTO NOTIFICATION_LOG (TRAN_ID, TRAN_DATE, SEND_TO_ID, UUID, NOTIFIC_TYPE, USER_ID__TO, USER_ID__SEND, MSG_TEXT, CALLER_COMP, MSGID, STATUS, TOCODE ) VALUES(?,?,?,?,?,?,?,?,?,?,?,?)";
                    pStmt = conn.prepareStatement(insertSql);
                    pStmt.setString(1, tranID);
                    pStmt.setTimestamp(2, Timestamp.valueOf(currDate));
                    pStmt.setString(3, sendToId);
                    pStmt.setString(4, uuID);
                    pStmt.setString(5, notificType);
                    pStmt.setString(6, userIdTo);
                    pStmt.setString(7, userIdSend);
                    pStmt.setString(8, msgText);
                    pStmt.setString(9, callerComp);
                    pStmt.setLong(10, msgId);
                    pStmt.setInt(11, status);
                    pStmt.setString(12, userIdTo);
                    int insCnt = pStmt.executeUpdate();
                    if (insCnt > 0) {
                        conn.commit();
                    }
                } else {
                    BaseLogger.log("3", null, null, "Transaction id is null.......");
                }
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
            }
            catch (ITMException itme) {
                System.err.println("ITMException :notificationLog :\n");
                throw itme;
            }
            catch (Exception e) {
                System.err.println("Exception :notificationLog :\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (conn != null) {
                    if (pStmt != null) {
                        pStmt.close();
                        pStmt = null;
                    }
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                System.err.println("Exception :notificationLog :\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        return uuID;
    }

    public String generateTranID(Connection conn) throws RemoteException, ITMException {
        Statement pStmt = null;
        ResultSet rs = null;
        String tranID = null;
        String query = "";
        int newTranIdLen = 0;
        try {
            try {
                String TranIdSeq = "";
                if ("db2".equalsIgnoreCase(CommonConstants.DB_NAME)) {
                    query = "SELECT NEXTVAL FOR NOTIFICATION_LOG_SEQ FROM DUAL";
                } else if ("mysql".equalsIgnoreCase(CommonConstants.DB_NAME)) {
                    String maxValueStr = "";
                    String getMaxValue = "SELECT MAX(MAX_VALUE) FROM SEQUENCES WHERE SEQ_NAME = 'NOTIFICATION_LOG_SEQ' ";
                    PreparedStatement pstmt = conn.prepareStatement(getMaxValue);
                    ResultSet rst = pstmt.executeQuery();
                    PreparedStatement pstm = null;
                    if (rst.next()) {
                        if (rst.getInt(1) != 0) {
                            TranIdSeq = String.valueOf(rst.getInt(1));
                            if (TranIdSeq != null && TranIdSeq.length() > 0) {
                                maxValueStr = "UPDATE SEQUENCES SET MAX_VALUE = ? WHERE SEQ_NAME = 'NOTIFICATION_LOG_SEQ' ";
                                pstm = conn.prepareStatement(maxValueStr);
                                pstm.setLong(1, rst.getInt(1) + 1);
                            }
                        } else {
                            TranIdSeq = String.valueOf(1);
                            maxValueStr = "INSERT INTO SEQUENCES ( MAX_VALUE ,SEQ_NAME) VALUES (?, ?) ";
                            pstm = conn.prepareStatement(maxValueStr);
                            pstm.setInt(1, 1);
                            pstm.setString(2, "NOTIFICATION_LOG_SEQ");
                        }
                    }
                    BaseLogger.log("3", null, null, "mysql :: TranIdSeq =[" + TranIdSeq + "]");
                    pstm.executeUpdate();
                    rst.close();
                    rst = null;
                    pstmt.close();
                    pstmt = null;
                    pstm.close();
                    pstm = null;
                } else {
                    query = "SELECT NOTIFICATION_LOG_SEQ.NEXTVAL FROM DUAL";
                }
                if (!"mysql".equalsIgnoreCase(CommonConstants.DB_NAME)) {
                    pStmt = conn.prepareStatement(query);
                    rs = pStmt.executeQuery();
                    while (rs.next()) {
                        TranIdSeq = rs.getString(1);
                    }
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pStmt != null) {
                        pStmt.close();
                        pStmt = null;
                    }
                }
                if (TranIdSeq != null && TranIdSeq.trim().length() > 0) {
                    tranID = "000000000000" + TranIdSeq;
                    newTranIdLen = tranID.trim().length();
                    tranID = tranID.substring(newTranIdLen - 10, newTranIdLen);
                } else {
                    BaseLogger.log("3", null, null, "Create sequence NOTIFICATION_LOG_SEQ [ Refer office sql ] in case null tran_id issue...");
                }
            }
            catch (Exception e) {
                System.err.println("Exception :generateTranID :\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
            }
            catch (Exception e) {
                System.err.println("Exception :generateTranID :\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        BaseLogger.log("2", null, null, "tranID =[" + tranID + "]");
        return tranID;
    }
}

