/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.bean.sys;

import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.ITMException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ProteusDataSource {
    E12GenericUtility genericUtility = new E12GenericUtility();
    private String dataObjNmae = "";
    private String dataSourceSQL = "";
    private Connection transactionObject = null;
    private int rowCount = 0;
    private int columnCount = 0;
    private HashMap modifiedRowMap = new HashMap();
    private HashMap columnsAttributeMap = new HashMap();
    private Document editDom = null;
    private String objName = "";
    private int formNo = 0;
    private NodeList parentNodeList = null;
    private NodeList childNodeList = null;
    private String formTagName = null;
    private String[] columnList;

    public ProteusDataSource(String objName, String domStr, int formNo) throws ITMException {
        Document localDom = null;
        Object parentNode = null;
        String childNodeName = "";
        try {
            if (domStr.indexOf("<Root>") == -1) {
                domStr = "<Root>\r\n" + domStr + "</Root>";
            }
            localDom = this.genericUtility.parseString(domStr);
            this.initiateProteusDataSource(objName, localDom, formNo);
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
    }

    public ProteusDataSource(String objName, Document argDom, int formNo) throws ITMException {
        try {
            String domStr = this.genericUtility.serializeDom((Node)argDom);
            if (domStr.indexOf("<Root>") == -1) {
                domStr = "<Root>\r\n" + domStr + "</Root>";
            }
            argDom = this.genericUtility.parseString(domStr);
            this.initiateProteusDataSource(objName, argDom, formNo);
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
    }

    private void initiateProteusDataSource(String objName, Document argDom, int formNo) throws ITMException {
        Node parentNode = null;
        String childNodeName = "";
        Node childNode = null;
        try {
            int childNodeListLength;
            this.objName = objName;
            this.editDom = argDom;
            this.formNo = formNo;
            this.parentNodeList = this.editDom.getElementsByTagName("Detail" + formNo);
            this.rowCount = this.parentNodeList.getLength();
            parentNode = this.parentNodeList.item(0);
            this.childNodeList = parentNode.getChildNodes();
            this.columnCount = childNodeListLength = this.childNodeList.getLength();
            this.formTagName = "Detail" + this.formNo;
            System.out.println("serialize editDom ::" + this.genericUtility.serializeDom((Node)this.editDom));
            this.columnList = new String[childNodeListLength];
            int ctr = 0;
            while (ctr < childNodeListLength) {
                childNode = this.childNodeList.item(ctr);
                if (childNode.getNodeType() == 1) {
                    this.columnList[ctr] = this.childNodeList.item(ctr).getNodeName();
                    this.columnsAttributeMap.put(String.valueOf(this.childNodeList.item(ctr).getNodeName().trim()) + "_protect", "X");
                }
                ++ctr;
            }
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
    }

    public int setItem(int rowNum, String columnName, int columnValue) throws ITMException {
        Element element = null;
        Node node = null;
        int returnValue = 0;
        try {
            element = (Element)this.parentNodeList.item(rowNum - 1);
            node = element.getElementsByTagName(columnName).item(0).getFirstChild();
            node.setNodeValue("" + columnValue);
            ArrayList modifiedColNames = new ArrayList();
            if (this.modifiedRowMap.get(rowNum) != null) {
                modifiedColNames = (ArrayList)this.modifiedRowMap.get(rowNum);
            }
            if (!modifiedColNames.contains(columnName)) {
                modifiedColNames.add(columnName);
                this.modifiedRowMap.put(rowNum, modifiedColNames);
            }
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return returnValue;
    }

    public int setItem(int rowNum, String columnName, String columnValue) throws ITMException {
        Element element = null;
        Node node = null;
        int returnValue = 0;
        try {
            element = (Element)this.parentNodeList.item(rowNum - 1);
            node = element.getElementsByTagName(columnName).item(0).getFirstChild();
            node.setNodeValue(columnValue);
            ArrayList modifiedColNames = new ArrayList();
            if (this.modifiedRowMap.get(rowNum) != null) {
                modifiedColNames = (ArrayList)this.modifiedRowMap.get(rowNum);
            }
            if (!modifiedColNames.contains(columnName)) {
                modifiedColNames.add(columnName);
                this.modifiedRowMap.put(rowNum, modifiedColNames);
            }
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return returnValue;
    }

    public int setItem(int rowNum, String columnName, double columnValue) throws ITMException {
        Element element = null;
        Node node = null;
        int returnValue = 0;
        try {
            element = (Element)this.parentNodeList.item(rowNum - 1);
            node = element.getElementsByTagName(columnName).item(0).getFirstChild();
            node.setNodeValue("" + columnValue);
            ArrayList modifiedColNames = new ArrayList();
            if (this.modifiedRowMap.get(rowNum) != null) {
                modifiedColNames = (ArrayList)this.modifiedRowMap.get(rowNum);
            }
            if (!modifiedColNames.contains(columnName)) {
                modifiedColNames.add(columnName);
                this.modifiedRowMap.put(rowNum, modifiedColNames);
            }
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return returnValue;
    }

    public String getItemString(int rowNum, String columnName) throws ITMException {
        Node parentNode = null;
        Node childNode = null;
        NodeList childNodeList = null;
        String columnValue = null;
        String returnValue = null;
        int childNodeListLength = 0;
        try {
            parentNode = this.parentNodeList.item(rowNum - 1);
            childNodeList = parentNode.getChildNodes();
            childNodeListLength = childNodeList.getLength();
            int childRow = 0;
            while (childRow < childNodeListLength) {
                String childNodeName;
                childNode = childNodeList.item(childRow);
                if (childNode.getNodeType() == 1 && (childNodeName = childNode.getNodeName()).equals(columnName)) {
                    if (childNode.getFirstChild() != null) {
                        columnValue = childNode.getFirstChild().getNodeValue();
                    }
                    if (columnValue != null && !columnValue.equalsIgnoreCase("null") && !columnValue.equalsIgnoreCase("<null>") && columnValue.length() > 0) {
                        returnValue = columnValue;
                    }
                }
                ++childRow;
            }
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return returnValue;
    }

    public Integer getItemNumber(int rowNum, String columnName) throws ITMException {
        String columnValue = null;
        Integer returnValue = null;
        try {
            columnValue = this.getItemString(rowNum, columnName);
            if (columnValue != null && !columnValue.equalsIgnoreCase("null") && !columnValue.equalsIgnoreCase("<null>") && columnValue.length() > 0) {
                returnValue = Integer.parseInt(columnValue);
            }
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return returnValue;
    }

    public Integer getItemNumber(int rowNum, String columnName, Integer i) throws ITMException {
        String columnValue = null;
        Integer returnValue = null;
        try {
            columnValue = this.getItemString(rowNum, columnName);
            if (columnValue != null && !columnValue.equalsIgnoreCase("null") && !columnValue.equalsIgnoreCase("<null>") && columnValue.length() > 0) {
                int decPos = columnValue.indexOf(".");
                if (decPos != -1) {
                    columnValue = decPos > 0 ? columnValue.substring(0, decPos) : "0";
                }
                returnValue = Integer.parseInt(columnValue);
            }
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return returnValue;
    }

    public Double getItemNumber(int rowNum, String columnName, Double d) throws ITMException {
        String columnValue = null;
        Double returnValue = null;
        try {
            columnValue = this.getItemString(rowNum, columnName);
            if (columnValue != null && !columnValue.equalsIgnoreCase("null") && !columnValue.equalsIgnoreCase("<null>") && columnValue.length() > 0) {
                returnValue = Double.parseDouble(columnValue);
            }
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return returnValue;
    }

    public Double getItemDecimal(int rowNum, String columnName) throws ITMException {
        String columnValue = null;
        Double returnValue = null;
        try {
            columnValue = this.getItemString(rowNum, columnName);
            if (columnValue != null && !columnValue.equalsIgnoreCase("null") && !columnValue.equalsIgnoreCase("<null>") && columnValue.length() > 0) {
                returnValue = Double.parseDouble(columnValue);
            }
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return returnValue;
    }

    public Timestamp getItemDateTime(int rowNum, String columnName) throws ITMException {
        String columnValue = null;
        Timestamp returnValue = null;
        try {
            columnValue = this.getItemString(rowNum, columnName);
            if (columnValue != null && !columnValue.equalsIgnoreCase("null") && !columnValue.equalsIgnoreCase("<null>") && columnValue.length() > 0) {
                returnValue = Timestamp.valueOf(this.genericUtility.getValidDateTimeString(columnValue, this.genericUtility.getApplDateFormat(), this.genericUtility.getDBDateFormat()));
            }
        }
        catch (Exception e) {
            returnValue = null;
        }
        return returnValue;
    }

    public Date getItemDate(int rowNum, String columnName) throws ITMException {
        String columnValue = null;
        Date returnValue = null;
        try {
            columnValue = this.getItemString(rowNum, columnName);
            if (columnValue != null && !columnValue.equalsIgnoreCase("null") && !columnValue.equalsIgnoreCase("<null>") && columnValue.length() > 0) {
                returnValue = Date.valueOf(this.genericUtility.getValidDateString(columnValue, this.genericUtility.getApplDateFormat(), this.genericUtility.getDBDateFormat()));
            }
        }
        catch (Exception e) {
            returnValue = null;
        }
        return returnValue;
    }

    public String getXmlString() throws ITMException {
        String output = null;
        try {
            output = this.genericUtility.serializeDom((Node)this.editDom);
        }
        catch (Exception e) {
            System.out.println("HHHHH::: " + e);
            e.printStackTrace();
            throw new ITMException(e);
        }
        return output;
    }

    public String getXmlString(String s) throws ITMException {
        String output = null;
        StringBuffer xmlString = new StringBuffer();
        xmlString.append("<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<editFlag>");
        xmlString.append("A").append("</editFlag>\r\n</Header>\r\n");
        try {
            int i = 0;
            while (i < this.rowCount) {
                xmlString.append("<" + this.formTagName + ">\r\n");
                int j = 0;
                while (j < this.columnCount) {
                    String columnValue = this.getItemString(i + 1, this.columnList[j]);
                    String columnProtect = (String)this.columnsAttributeMap.get(String.valueOf(this.columnList[j]) + "_protect");
                    columnProtect = columnProtect != null && columnProtect.length() > 0 && !columnProtect.equalsIgnoreCase("X") ? " protect='" + columnProtect + "'" : "";
                    xmlString.append("<" + this.columnList[j] + columnProtect + ">");
                    if (columnValue != null && !columnValue.equalsIgnoreCase("null") && !columnValue.equalsIgnoreCase("<null>") && columnValue.length() > 0) {
                        xmlString.append("<![CDATA[" + columnValue + "]]>");
                    }
                    xmlString.append("</" + this.columnList[j] + ">\r\n");
                    ++j;
                }
                xmlString.append("</" + this.formTagName + ">\r\n");
                ++i;
            }
            xmlString.append("</Root>");
            output = xmlString.toString();
        }
        catch (Exception e) {
            System.out.println("HHHHH::: " + e);
            e.printStackTrace();
            throw new ITMException(e);
        }
        return output;
    }

    public String getChangedXmlString() throws ITMException {
        String output = null;
        int key = 0;
        Integer ikey = 0;
        int modifiedColumnCounts = 0;
        StringBuffer xmlString = new StringBuffer();
        ArrayList modifiedColumnList = new ArrayList();
        xmlString.append("<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<editFlag>");
        xmlString.append("A").append("</editFlag>\r\n</Header>\r\n");
        try {
            Iterator keySetIterator = this.modifiedRowMap.keySet().iterator();
            while (keySetIterator.hasNext()) {
                key = Integer.parseInt((String)keySetIterator.next());
                modifiedColumnList = (ArrayList)this.modifiedRowMap.get(key);
                modifiedColumnCounts = modifiedColumnList.size();
                if (modifiedColumnCounts > 0) {
                    xmlString.append("<" + this.formTagName + ">\r\n");
                    String[] modifiedColumnNames = new String[modifiedColumnCounts];
                    int i = 0;
                    while (i < modifiedColumnCounts) {
                        modifiedColumnNames[i] = modifiedColumnList.get(i).toString();
                        String columnValue = this.getItemString(key, modifiedColumnNames[i]);
                        String columnProtect = (String)this.columnsAttributeMap.get(String.valueOf(modifiedColumnNames[i]) + "_protect");
                        columnProtect = columnProtect != null && columnProtect.length() > 0 && !columnProtect.equalsIgnoreCase("X") ? " protect='" + columnProtect + "'" : "";
                        xmlString.append("<" + modifiedColumnNames[i] + columnProtect + ">");
                        if (columnValue != null && !columnValue.equalsIgnoreCase("null") && !columnValue.equalsIgnoreCase("<null>") && columnValue.length() > 0) {
                            xmlString.append("<![CDATA[" + columnValue + "]]>");
                        }
                        xmlString.append("</" + modifiedColumnNames[i] + ">\r\n");
                        ++i;
                    }
                }
                modifiedColumnList.clear();
                modifiedColumnCounts = 0;
                xmlString.append("</" + this.formTagName + ">\r\n");
            }
            xmlString.append("</Root>");
            output = xmlString.toString();
        }
        catch (Exception e) {
            System.out.println("HHHHH::: " + e);
            e.printStackTrace();
            throw new ITMException(e);
        }
        return output;
    }

    public int getRowCount() throws ITMException {
        Object output = null;
        try {
            this.parentNodeList = this.editDom.getElementsByTagName(this.formTagName);
            this.rowCount = this.parentNodeList.getLength();
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return this.rowCount;
    }

    public int insertRow(int rowPos) throws ITMException {
        NodeList rootNode = null;
        Element element = null;
        Element newElement = null;
        ArrayList<String> modifiedColNames = new ArrayList<String>();
        try {
            rootNode = this.editDom.getElementsByTagName("Root");
            element = (Element)rootNode.item(0);
            System.out.println("\r\n Inside Insert Row 1");
            newElement = this.editDom.createElement(this.formTagName);
            System.out.println("\r\n Inside Insert Row 2");
            newElement.appendChild(this.editDom.createTextNode(""));
            element.appendChild(newElement);
            System.out.println("\r\n Inside Insert Row 3");
            this.parentNodeList = this.editDom.getElementsByTagName(this.formTagName);
            System.out.println("\r\n Inside Insert Row 4");
            this.rowCount = this.parentNodeList.getLength();
            System.out.println("\r\n Inside Insert Row 5 --- " + this.rowCount);
            element = (Element)this.parentNodeList.item(this.rowCount);
            System.out.println("\r\n Inside Insert Row 6");
            System.out.println("\r\n Inside Insert Row 6 -- " + this.columnCount);
            int ctr = 0;
            while (ctr < this.columnCount) {
                newElement = this.editDom.createElement(this.columnList[ctr]);
                System.out.println("\r\n Inside Insert Row 7");
                newElement.appendChild(this.editDom.createTextNode(""));
                System.out.println("\r\n Inside Insert Row 8");
                element = (Element)this.parentNodeList.item(this.rowCount - 1);
                System.out.println("\r\n Inside Insert Row 9");
                element.appendChild(newElement);
                System.out.println("\r\n Inside Insert Row 10");
                modifiedColNames.add(this.columnList[ctr]);
                ++ctr;
            }
            this.modifiedRowMap.put(this.rowCount, modifiedColNames);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ITMException(e);
        }
        return this.rowCount;
    }

    public void modifyDsAttribute(String columnName, String columnAttributeName, String columnAttributeValue) throws ITMException {
        try {
            String columnAttribute = String.valueOf(columnName.trim()) + "_" + columnAttributeName.trim();
            System.out.println("columnAttribute::: " + columnAttribute);
            this.columnsAttributeMap.put(columnAttribute, columnAttributeValue);
            int i = 1;
            while (i <= this.rowCount) {
                ArrayList modifiedColNames = new ArrayList();
                if (this.modifiedRowMap.get(i) != null) {
                    modifiedColNames = (ArrayList)this.modifiedRowMap.get(i);
                }
                if (!modifiedColNames.contains(columnName)) {
                    modifiedColNames.add(columnName);
                    this.modifiedRowMap.put(i, modifiedColNames);
                }
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println("HHHHH::: " + e);
            e.printStackTrace();
            throw new ITMException(e);
        }
    }
}

