/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.utility;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import ibase.analyticsDataAccess.ReportDataEJB.ReportDataServiceEJB;
import ibase.bean.ExtAuthAppAPIBean;
import ibase.ejb.CommonDBAccessEJB;
import ibase.utility.BaseException;
import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.utility.E12ExtServiceUtility;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONArray;
import org.json.JSONObject;

public class DataServiceUtility
extends E12ExtServiceUtility {
    protected UserInfoBean userInfo = null;

    public String handleRequest(String tokenID, String appID, String componentName, String criteria, HttpServletRequest request) {
        String result = "";
        BaseLogger.log("3", null, null, "tokenID handleRequest: [" + tokenID + "]");
        BaseLogger.log("3", null, null, "appID handleRequest: [" + appID + "]");
        BaseLogger.log("3", null, null, "componentName handleRequest: [" + componentName + "]");
        BaseLogger.log("3", null, null, "criteria handleRequest: [" + criteria + "]");
        String endpoint = "DataService";
        try {
            CommonDBAccessEJB commonDBAcessEJB = this.getCommonDBAcessEJB();
            ExtAuthAppAPIBean authAppAPIBean = commonDBAcessEJB.getAuthAppAPIDetails(endpoint, appID);
            BaseLogger.log("3", null, null, "DataServiceUtility handleRequest: [" + authAppAPIBean + "]");
            if (authAppAPIBean == null) {
                result = "Endpoint Validation Failed";
            } else {
                boolean isWhiteListIP = this.isWhiteListIP(request, appID);
                if (!isWhiteListIP) {
                    result = "Requested IP not registered for AppID (" + appID + ")";
                } else if (this.validateToken(request, tokenID, isWhiteListIP, appID)) {
                    this.userInfo = this.getUserInfo();
                    BaseLogger.log("3", null, null, "userInfo handleRequest: [" + this.userInfo + "]");
                    result = this.getReportData(componentName, criteria, this.userInfo);
                    BaseLogger.log("3", null, null, "result handleRequest: [" + result + "]");
                } else {
                    result = "Token ID validation failed.";
                }
            }
        }
        catch (BaseException e) {
            e.printStackTrace();
        }
        return result;
    }

    public String getReportData(String componentName, String criteria, UserInfoBean userInfo) {
        String result = "";
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode jsonNode = objectMapper.readTree(criteria);
            HashMap<String, String> reportArgMap = new HashMap<String, String>();
            Iterator fieldNames = jsonNode.fieldNames();
            while (fieldNames.hasNext()) {
                String fieldName = (String)fieldNames.next();
                String fieldValue = jsonNode.get(fieldName).asText();
                reportArgMap.put(fieldName, fieldValue);
            }
            reportArgMap.put("TRANS_DB", userInfo.getTransDB());
            BaseLogger.log("3", null, null, "reportArgMap::" + reportArgMap);
            HttpServletRequest request = null;
            result = this.callReportEJB(reportArgMap, componentName, request);
            BaseLogger.log("3", null, null, "result from DataServiceUtility:: [" + result + "]");
        }
        catch (BaseException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public String callReportEJB(HashMap reportArgMap, String componentName, HttpServletRequest request) throws BaseException, Exception {
        String response;
        block23: {
            BaseLogger.log("2", null, null, "FinanceReportDataService.callReportEJB() reportArgMap::[" + reportArgMap + "] componentName::[" + componentName + "]");
            String result = "";
            String status = "error";
            String dataFormat = "JSON";
            response = "";
            Class<?> classObj = null;
            String methodName = "getReportData";
            Class[] paramSpec = new Class[1];
            Object[] params = new Object[1];
            JSONArray jsonArray = null;
            JSONObject responseJson = new JSONObject();
            JSONObject resultJson = new JSONObject();
            try {
                try {
                    BaseLogger.log("3", null, null, "ReportDataServiceEJB.callJB() creating FixedAsset() ");
                    classObj = Class.forName(componentName);
                    paramSpec[0] = Class.forName("java.util.HashMap");
                    params[0] = reportArgMap;
                    ReportDataServiceEJB reportDataService = (ReportDataServiceEJB)classObj.newInstance();
                    BaseLogger.log("3", null, null, "FinanceReportDataService reportDataService object created..." + reportDataService);
                    if (this.userInfo != null) {
                        reportDataService.setUserInfo(this.userInfo);
                    }
                    BaseLogger.log("3", null, null, "methodName [" + methodName + "] compName::[" + componentName + "] comp::[" + reportDataService + "]");
                    Method metObj = classObj.getMethod(methodName, paramSpec);
                    metObj.setAccessible(true);
                    Object retVal = metObj.invoke((Object)reportDataService, params);
                    result = retVal.toString();
                    BaseLogger.log("2", null, null, "FinanceReportDataService callReportEJB result11111::[" + result + "]");
                    reportDataService = null;
                    if (result != null && result.indexOf("<Errors>") != -1 && "JSON".equalsIgnoreCase(dataFormat)) {
                        BaseLogger.log("2", null, null, "before calling::[" + result + "]");
                        E12GenericUtility e12GenericUtility = new E12GenericUtility();
                        result = e12GenericUtility.xmlToJSONString(result);
                        BaseLogger.log("2", null, null, "xmlToJSONString result::[" + result + "]");
                    } else {
                        result = result.replaceAll("\\\\", "");
                        jsonArray = new JSONArray(result);
                        result = "";
                        BaseLogger.log("2", null, null, "inside else....");
                    }
                    status = "success";
                    resultJson.put("results", (Object)jsonArray);
                    BaseLogger.log("2", null, null, "resultJson result::[" + resultJson + "]");
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception in FinanceReportDataService.callReportEJB():[" + E12GenericUtility.getStackTrace(e) + "]");
                    result = this.getStackTrace(e, dataFormat);
                    status = "exception";
                    BaseLogger.log("2", null, null, "FinanceReportDataService.callReportEJB() result::::[" + result + "] jsonArray::::" + jsonArray);
                    if (result.indexOf("Warning") != -1) {
                        status = "warning";
                    } else if (result.indexOf("Errors") != -1) {
                        status = "error";
                    } else if (result.indexOf("Exception") != -1) {
                        status = "exception";
                    }
                    resultJson.put("status", (Object)status);
                    responseJson.put("Response", (Object)resultJson);
                    response = responseJson.toString();
                    break block23;
                }
            }
            catch (Throwable throwable) {
                BaseLogger.log("2", null, null, "FinanceReportDataService.callReportEJB() result::::[" + result + "] jsonArray::::" + jsonArray);
                if (result.indexOf("Warning") != -1) {
                    status = "warning";
                } else if (result.indexOf("Errors") != -1) {
                    status = "error";
                } else if (result.indexOf("Exception") != -1) {
                    status = "exception";
                }
                resultJson.put("status", (Object)status);
                responseJson.put("Response", (Object)resultJson);
                response = responseJson.toString();
                throw throwable;
            }
            BaseLogger.log("2", null, null, "FinanceReportDataService.callReportEJB() result::::[" + result + "] jsonArray::::" + jsonArray);
            if (result.indexOf("Warning") != -1) {
                status = "warning";
            } else if (result.indexOf("Errors") != -1) {
                status = "error";
            } else if (result.indexOf("Exception") != -1) {
                status = "exception";
            }
            resultJson.put("status", (Object)status);
            responseJson.put("Response", (Object)resultJson);
            response = responseJson.toString();
        }
        BaseLogger.log("2", null, null, "responseDataObj result after replace response:::[" + response + "]");
        return response;
    }
}

