package ibase.webService;

import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import ibase.utility.BaseException;
import ibase.utility.BaseLogger;
import ibase.webitm.utility.UserTasksServiceUtility;

@Path("/UserTasksService")

public class UserTasksService extends RestAPIService
{
	@GET
	@Path("/getUserTasks")
	@Produces(MediaType.APPLICATION_JSON)
	public Response getUserTasks( 
			@QueryParam("REF_SER") String refser,
			@QueryParam("REF_ID") String refId,
		    @HeaderParam("TOKEN_ID") String tokenIDfromHeader)  throws BaseException, Exception 
	{
		BaseLogger.log( "3", null, null, "getUserTasks Service Called::");
		  UserTasksServiceUtility userTasksServiceUtility= new UserTasksServiceUtility();
		    
		    String response = userTasksServiceUtility.getUserTasksService( refser, refId,tokenIDfromHeader);
		    BaseLogger.log( "3", null, null, " getUserTasks get response :"+ response );

		return Response.status(200).entity( response ).build();

	}
	
	@POST
	@Path("/getUserTasks")
	@Produces(MediaType.APPLICATION_JSON)
	public Response getUserTasksDetails( 
			@FormParam("REF_SER") String refser,
            @FormParam("REF_ID") String refId,
            @HeaderParam("TOKEN_ID") String tokenIDfromHeader) throws BaseException, Exception 

	{
		BaseLogger.log("3", null, null, "getUserTasksDetails Service Called::");
		UserTasksServiceUtility userTasksServiceUtility = new UserTasksServiceUtility();

		String response = userTasksServiceUtility.getUserTasksService(refser, refId, tokenIDfromHeader);
		BaseLogger.log("3", null, null, " getUserTasks post response  :" + response);

		return Response.status(200).entity( response ).build();

	}
	
	//added by Amol  to insert in usertask
	@GET
	@Path("/addUserTask")
	@Produces(MediaType.APPLICATION_JSON)
	public Response addUserTasks( 
			@QueryParam("REF_ID") String refId,
			@QueryParam("REF_SER") String refser,
			@QueryParam("TASK_DESCR")String taskDescr,
			@QueryParam("USER_ID__ASSIGNED") String userIdAssigned,
		    @HeaderParam("TOKEN_ID") String tokenIDfromHeader)  throws BaseException, Exception 
	{
		BaseLogger.log( "3", null, null, "addUserTask Service Called::");
		  UserTasksServiceUtility userTasksServiceUtility= new UserTasksServiceUtility();
		    
		    String response = userTasksServiceUtility.addUserTask( refId, refser, taskDescr, userIdAssigned, tokenIDfromHeader);
		    BaseLogger.log( "3", null, null, " addUserTasks response :"+ response );

		return Response.status(200).entity( response ).build();

	}

	


}
