// Coding By Vidhya Prabhu on 10-12-09

package ibase.webitm.ejb.wsfa.transactions;

import java.rmi.RemoteException;
import java.util.*;
import java.util.Date;
import java.text.DateFormat;
import java.sql.*;
import javax.ejb.*;
import javax.naming.InitialContext;
import org.w3c.dom.*;
import javax.xml.parsers.*;
import java.text.SimpleDateFormat;
import ibase.webitm.ejb.*;
import ibase.webitm.bean.wsfa.*;
import ibase.webitm.utility.*;
import ibase.system.config.*;
import ibase.webitm.utility.ITMException;
//import ibase.webitm.utility.GenericUtility;
import ibase.utility.E12GenericUtility;
import ibase.utility.CommonConstants;
//@javax.ejb.Stateless		commented by Sagar M [22 Nov 2018].

public class StrgSeriesPreSave extends ValidatorEJB
{

	public String preSave()throws RemoteException,ITMException
	{
		return "";
	}

	public String preSave( String domString, String editFlag, String xtraParams, Connection conn ) throws RemoteException,ITMException
	{
		String retString = "";
		String errCode = "";
		String objName = "";
		//Changed By Avani on 22/02/10 [ WS90NOV012 | to include effective date change in history ]Start
		String currEffDate = "";
		String dbEffDate = "";
		//Changed By Avani on 22/02/10 [ WS90NOV012 | to include effective date change in history ]End
		String dbStatus = "";
		String currStatus = "";
		String salesPers = "";
		String strgCode = "";
		String custType = "";
		String routeId = "";
		String itemSer = "";
		String userId = "";

		PreparedStatement pStmt = null;
		ResultSet rs = null;
		Document dom = null;
		
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null; 	
		String childNodeName = "";
		int parentNodeListLength = 0;
		int childNodeListLength = 0;
		String updateFlag = "";

		try
		{
			//changed by Rahul Barve on 3-sep-2014
			//GenericUtility genericUtility = GenericUtility.getInstance();
			 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

			StrgSerStatusHist updHist = new StrgSerStatusHist();

			userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );

			System.out.println("domString StrgSeriesPreSaveEJB ["+domString+"]");
			dom = genericUtility.parseString(domString);

			salesPers = checkNull(genericUtility.getColumnValue("sales_pers", dom));
			currStatus = checkNull(genericUtility.getColumnValue("status", dom));

			//Changed By Avani on 22/02/10 [ WS90NOV012 | to include effective date change in history ]
			currEffDate = checkNull(genericUtility.getColumnValue("eff_date",  dom));

			strgCode = checkNull(genericUtility.getColumnValue("sc_code", dom));
			custType = checkNull(genericUtility.getColumnValue("cust_type", dom));
			routeId = checkNull(genericUtility.getColumnValue("route_id", dom));
			itemSer = checkNull(genericUtility.getColumnValue("item_ser", dom));
			
			parentNodeList = dom.getElementsByTagName("Detail1");
			parentNodeListLength = parentNodeList.getLength(); 
			for (int selectedRow = 0; selectedRow < parentNodeListLength; selectedRow++)
			{				
				parentNode = parentNodeList.item(selectedRow);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				System.out.println("childNodeListLength::routeApprove: "+ childNodeListLength+"\n");

				for (int childRow = 0; childRow < childNodeListLength; childRow++)
				{
					childNode = childNodeList.item(childRow);
					childNodeName = childNode.getNodeName();	
					if("attribute".equalsIgnoreCase(childNodeName))
					{
						if(childNode.getAttributes().getNamedItem("updateFlag") != null)
						{
							updateFlag = childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
						}
					}

					
				}
			}

			if(updateFlag.equalsIgnoreCase("A") && currStatus.equalsIgnoreCase("N"))
			{
				currStatus = "Y";
			}
			System.out.println("doctor [" + strgCode + "]  Current Status [" + currStatus + "] custType["+custType+"] routeId["+routeId+"] itemSer ["+itemSer+"]");

			//Changed By Avani on 22/02/10 [ WS90NOV012 | to include effective date change in history ]
			//String sql = "SELECT STATUS FROM STRG_SERIES WHERE SC_CODE = ? AND SALES_PERS = ?  AND ITEM_SER = ? AND ROUTE_ID = ? ";
			String sql = "SELECT STATUS, EFF_DATE FROM STRG_SERIES WHERE SC_CODE = ? AND SALES_PERS = ?  AND ITEM_SER = ? AND ROUTE_ID = ? ";

			System.out.println("checking status of doctor ["+strgCode+"]........ CONNECTION IS CLOSE["+conn.isClosed()+"]");
			pStmt = conn.prepareStatement( sql );
			pStmt.setString( 1, strgCode);
			pStmt.setString( 2, salesPers);
			pStmt.setString( 3, itemSer);
			pStmt.setString( 4, routeId);
			rs = pStmt.executeQuery();
			if ( rs.next() )
			{
				dbStatus = rs.getString("STATUS");
				//Changed By Avani on 22/02/10 [ WS90NOV012 | to include effective date change in history ].start
				dbEffDate = rs.getString("EFF_DATE");
				//Changed By Avani on 22/02/10 [ WS90NOV012 | to include effective date change in history ].end
			}
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if (pStmt != null)
			{
				pStmt.close();
				pStmt = null;
			}

			if (dbStatus == null || dbStatus.trim().length() == 0)
			{
				dbStatus = " ";
			}
			//Changed By Avani on 22/02/10 [ WS90NOV012 | to include effective date change in history ].start
			if (dbEffDate == null || dbEffDate.trim().length() == 0)
			{
				dbEffDate = " ";
			}
			else
			{
				dbEffDate =  genericUtility.getValidDateString( dbEffDate, genericUtility.getDBDateTimeFormat(), genericUtility.getApplDateFormat());
			}
			//Changed By Avani on 22/02/10 [ WS90NOV012 | to include effective date change in history ].end
			System.out.println(" Existing status ["+dbStatus+"] Existing Date ["+dbEffDate+"]");

			//Changed By Avani on 22/02/10 [ WS90NOV012 | to include effective date change in history ].start
			/*if ( ! currStatus.equalsIgnoreCase(dbStatus) )
			{
				errCode = updHist.setDrStatusHistory(salesPers, strgCode, "D", routeId, itemSer, currStatus,xtraParams, editFlag, conn);
			}*/
			//if ( ! currStatus.equalsIgnoreCase(dbStatus) ||  ! currEffDate.equalsIgnoreCase(dbEffDate))
			if (!updateFlag.equalsIgnoreCase("A") && (! currStatus.equalsIgnoreCase(dbStatus) ||  ! currEffDate.equalsIgnoreCase(dbEffDate)))
			{
				//errCode = updHist.setDrStatusHistory(salesPers, strgCode, "D", routeId, itemSer, currStatus, currEffDate, dbEffDate, xtraParams, editFlag, conn);
				errCode = updHist.setDrStatusHistory(salesPers, strgCode, custType , routeId, itemSer, currStatus, currEffDate, dbEffDate, xtraParams, editFlag, conn);
			}
			//Changed By Avani on 22/02/10 [ WS90NOV012 | to include effective date change in history ].end

			System.out.println("errCode.trim()["+errCode.trim()+"]");
			if ( errCode.trim() != null &&  errCode.trim().length() != 0)
			{
				retString = getErrorString( "sc_code", errCode.trim(), userId );
				return retString;
			}

		}
		catch(Exception e)
		{
			System.out.println("Exception :StrgSeriesPreSaveEJB : :==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
					if (rs!=null)
					{
						rs.close();
						rs = null;
					}

					if(pStmt != null)
					{
						pStmt.close();
						pStmt = null;
					}


			}
			catch(Exception e)
			{
				System.out.println("Exception :StrgSeriesPreSaveEJB : :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		System.out.println("Return string :["+retString+"]");
		return retString;
	}

	public String checkNull(String input)
	{
		if (input == null || "null".equalsIgnoreCase(input))
		{
			input= "";
		}
		return input.trim();
	}

}