package ibase.webitm.ejb.wsfa.masters;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;

import ibase.system.config.ConnDriver;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;

public class RetailSchemeConfirmation extends ValidatorEJB
{
	private E12GenericUtility genericUtility = new E12GenericUtility();
	
	public String retailSchemeApprove( String xmlData ,String signBy ,String refSer,  String appoverCode ,String userInfoStr, String schemeCode  )throws RemoteException, ITMException
	{
		System.out.println("[retailSchemeApprove] retailSchemeApprove Method called...");
		
		System.out.println("[retailSchemeApprove] xmlData = ["+ xmlData +"]");
		System.out.println("[retailSchemeApprove] signBy = "+signBy);
		System.out.println("[retailSchemeApprove] refSer = "+refSer);
		System.out.println("[retailSchemeApprove] appoverCode = "+appoverCode);
		System.out.println("[retailSchemeApprove] userInfoStr = "+userInfoStr);
		System.out.println("[retailSchemeApprove] schemeCode = "+schemeCode);
		
		String retString = "";
		boolean isError = false;
		PreparedStatement pStmt = null;
		ResultSet rs = null;
		Connection connectionObject = null;
		ConnDriver connDriver = null;
		String transDB = "";
		
		try
		{
			UserInfoBean userInfo = new UserInfoBean(userInfoStr);
			connDriver = new ConnDriver();
			
			if( userInfo != null )
			{
				transDB = userInfo.getTransDB();
			}
			System.out.println("get TransDB connection in retailSchemeApprove : "+transDB);

			if (transDB != null && transDB.trim().length() > 0)
			{
				connectionObject = connDriver.getConnectDB(transDB);
			}

			String userId  = appoverCode.trim();
			DateFormat dtFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
			java.util.Date date = Calendar.getInstance().getTime();
			String currDate = dtFormat.format( date );
			currDate = genericUtility.getValidDateTimeString( currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );

			String updRetSchmSql = "UPDATE RETAIL_SCHEME SET CONFIRMED = 'Y', EMP_CODE__APRV = ?, CONF_DATE = ? WHERE SCHEME_CODE = ?";

			pStmt = connectionObject.prepareStatement( updRetSchmSql );
			pStmt.setString(1, userId );
			pStmt.setTimestamp(2,java.sql.Timestamp.valueOf( currDate ));
			pStmt.setString(3, schemeCode );
			int updCnt = pStmt.executeUpdate();
			if(pStmt != null)
			{
				pStmt.close();
				pStmt = null;
			}
			System.out.println("updCnt[updRetSchmSql] =["+updCnt+"]");
		}
		catch (Exception e)
		{
			isError = true;
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if(pStmt != null )
				{
					pStmt.close();
					pStmt = null;
				}
				if(connectionObject != null )
				{
					if(!isError)
					{
						connectionObject.commit();
					}
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception 1 updRetSchmSql(String) :==>\n"+e.getMessage());
			}
		}
		return retString;
	}
	
	public String retailSchemeRejected( String schemeCode ,String userInfoStr )throws RemoteException, ITMException
	{
		System.out.println("[retailSchemeRejected] retailSchemeRejected Method called...");

		System.out.println("[retailSchemeRejected] schemeCode = "+schemeCode);
		System.out.println("[retailSchemeRejected] userInfoStr = "+userInfoStr);
		//System.out.println("[retailSchemeApprove] approverCode = "+approverCode);

		boolean isError = false;
		PreparedStatement pStmt = null;
		ResultSet rs = null;
		String retString = "";
		Connection connectionObject = null;
		ConnDriver connDriver = null;
		String transDB = "";
		
		try
		{
			UserInfoBean userInfo = new UserInfoBean(userInfoStr);
			connDriver = new ConnDriver();
			
			if( userInfo != null )
			{
				transDB = userInfo.getTransDB();
			}
			System.out.println("get TransDB connection in retailSchemeRejected : "+transDB);

			if (transDB != null && transDB.trim().length() > 0)
			{
				connectionObject = connDriver.getConnectDB(transDB);
			}
			String updRetSchmSql2 = "UPDATE RETAIL_SCHEME SET CONFIRMED = 'N', WF_STATUS = 'D' WHERE SCHEME_CODE = ? ";

			pStmt = connectionObject.prepareStatement(updRetSchmSql2);
			pStmt.setString(1, schemeCode );
			int updCnt = pStmt.executeUpdate();
			if(pStmt != null)
			{
				pStmt.close();
				pStmt = null;
			}
			System.out.println("updCnt>>>["+updCnt+"]");
		}
		catch (Exception e)
		{
			isError = true;
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if(pStmt != null )
				{
					pStmt.close();
					pStmt = null;
				}
				if(connectionObject != null )
				{
					if(!isError)
					{
						connectionObject.commit();
					}
					connectionObject.close();
					connectionObject = null;
				}

			}
			catch(Exception e)
			{
				System.out.println( "Exception 2 updRetSchmSql(String) :==>\n"+e.getMessage());
			}
		}
		return retString;
	}
	
	public String checkNull(String input)
	{
		if (input == null || "null".equalsIgnoreCase(input))
		{
			input= "";
		}
		return input.trim();
	}
}
