/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.utility;

import ibase.ejb.E12SMSComp;
import ibase.system.config.ConnDriver;
import ibase.system.config.nosql.NoSQLConnDriver;
import ibase.system.config.resource.NoSQLConnection;
import ibase.utility.BaseException;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.MongoDBHandler;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.ejb.E12CreateBatchLoadEjb;
import ibase.webitm.ejb.EventManagerEJB;
import ibase.webitm.ejb.TransactionEmailTempltEJB;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.JMSLogger;
import ibase.webitm.utility.JMSWorklFlowInvoker;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.bson.types.ObjectId;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class JMSFollowupActions {
    String batchIDShare = "";

    public String getBatchIDShare() {
        return this.batchIDShare;
    }

    public void executeFollowupactions(String jmsData) throws RemoteException, ITMException {
        block47: {
            E12GenericUtility e12GenericUtility = new E12GenericUtility();
            Connection conn = null;
            Document detailDom = null;
            Statement pstmt = null;
            ResultSet resultSet = null;
            Object newConn = null;
            String userTransDB = "";
            String follwUpActioTranId = "";
            boolean isValid = false;
            HashMap<String, String> xtraparamsValMap = new HashMap<String, String>();
            String XTRA_PARAMS_SEPARATOR = "~~";
            String user_lang = "en";
            String user_country = "US";
            try {
                try {
                    String userId;
                    String transDB;
                    if (jmsData == null) break block47;
                    String[] inputArr = jmsData.split("!~~!");
                    JMSLogger.log("1", null, null, "JMSFollowupActions.executeFollowupactions() inputArr size:[" + inputArr.length + "]");
                    String xmlString = inputArr[0];
                    String objName = inputArr[1];
                    String objContext = inputArr[2];
                    String pkNames = inputArr[3];
                    String tranId = inputArr[4];
                    String action = inputArr[5];
                    String xtraParams = inputArr[6];
                    UserInfoBean userInfo = new UserInfoBean(inputArr[7]);
                    String coreModelId = "";
                    if (inputArr.length > 8) {
                        coreModelId = inputArr[8];
                    }
                    userTransDB = transDB = userInfo.getTransDB();
                    JMSLogger.log("3", userInfo, null, "JMSFollowupActions.executeFollowupactions() transDB :[" + transDB + "]");
                    JMSLogger.log("3", userInfo, null, "JMSFollowupActions.executeFollowupactions() objName :[" + objName + "]");
                    JMSLogger.log("3", userInfo, null, "JMSFollowupActions.executeFollowupactions() objContext :[" + objContext + "]");
                    JMSLogger.log("3", userInfo, null, "JMSFollowupActions.executeFollowupactions() pkNames :[" + pkNames + "]");
                    JMSLogger.log("3", userInfo, null, "JMSFollowupActions.executeFollowupactions() tranId :[" + tranId + "]");
                    JMSLogger.log("3", userInfo, null, "JMSFollowupActions.executeFollowupactions() action :[" + action + "]");
                    JMSLogger.log("3", userInfo, null, "JMSFollowupActions.executeFollowupactions() xtraParams :[" + xtraParams + "]");
                    JMSLogger.log("3", userInfo, null, "JMSFollowupActions.executeFollowupactions() coreModelId :[" + coreModelId + "]");
                    try {
                        if (xmlString != null) {
                            xmlString = e12GenericUtility.updateXMLString(pkNames, tranId, xmlString, userInfo);
                        }
                    }
                    catch (Exception e) {
                        JMSLogger.log("3", userInfo, null, "JMSFollowupActions.executeFollowupactions xmlString Exception p :[" + e + "]");
                    }
                    JMSLogger.log("3", userInfo, null, "JMSFollowupActions.executeFollowupactions() xmlString :[" + xmlString + "]");
                    detailDom = e12GenericUtility.parseString(xmlString);
                    if ("user_device".equalsIgnoreCase(objName) && "".equals(E12GenericUtility.checkNull(tranId))) {
                        userId = e12GenericUtility.getColumnValue("user_id", detailDom, "1");
                        String deviceIdPush = e12GenericUtility.getColumnValue("device_id__push", detailDom, "1");
                        StringBuilder whereCondtion = new StringBuilder();
                        whereCondtion.append(" WHERE USER_ID ='").append(userId).append("' ");
                        whereCondtion.append(" AND DEVICE_ID__PUSH ='").append(deviceIdPush).append("' ");
                        tranId = E12GenericUtility.checkNull(this.getDBColumnValue("USER_DEVICE", "TRAN_ID", whereCondtion.toString(), null));
                        JMSLogger.log("3", userInfo, null, "JMSFollowupActions.executeFollowupactions() tranId in if :[" + tranId + "]");
                    }
                    userId = this.getValueFromXTRA_PARAMS(xtraParams, "loginCode", userInfo);
                    String loginEmpCode = this.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode", userInfo);
                    String loginSiteCode = this.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode", userInfo);
                    String profileId = this.getValueFromXTRA_PARAMS(xtraParams, "profileId", userInfo);
                    xtraparamsValMap.put("loginCode", userId);
                    xtraparamsValMap.put("loginEmpCode", loginEmpCode);
                    xtraparamsValMap.put("loginSiteCode", loginSiteCode);
                    xtraparamsValMap.put("profileId", profileId);
                    JMSLogger.log("2", userInfo, "", "xtraparamsValMap : [" + xtraparamsValMap + "]");
                    String title = this.getDBColumnValue("ITM2MENU", "DESCR", "WHERE WIN_NAME = 'w_" + objName + "'", userInfo.getTransDB());
                    JMSLogger.log("3", userInfo, null, "JMSFollowupActions.executeFollowupactions() tite :[" + title + "]");
                    ConnDriver connDriver = new ConnDriver();
                    conn = connDriver.getConnectDB(transDB);
                    String ref_ser = this.getDBColumnValue("TRANSETUP", "REF_SER", "WHERE TRAN_WINDOW = 'w_" + objName + "'", userInfo.getTransDB());
                    String sql = "SELECT ACTION_TYPE, ACTION_INFO, CONDITIONAL_EXPRESSION, CONDITIONAL_INPUT FROM OBJ_FOLLOWUP_ACT WHERE OBJ_NAME = ? AND ACTION_ID = ?";
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setString(1, objName);
                    pstmt.setString(2, action);
                    resultSet = pstmt.executeQuery();
                    JMSLogger.log("3", userInfo, null, "JMSFollowupActions.executeFollowupactions() sql executed");
                    while (resultSet.next()) {
                        follwUpActioTranId = this.getFollwUpActionsNextSeqId(conn);
                        this.insertFollwUpActionData(transDB, follwUpActioTranId, userId, objName, ref_ser, tranId, action);
                        JMSLogger.log("3", userInfo, null, "JMSFollowupActions.executeFollowupactions() in while");
                        String actionType = E12GenericUtility.checkNull(resultSet.getString("ACTION_TYPE"));
                        String actionInfo = E12GenericUtility.checkNull(resultSet.getString("ACTION_INFO"));
                        String condnalInput = E12GenericUtility.checkNull(resultSet.getString("CONDITIONAL_INPUT"));
                        String condnalExprn = E12GenericUtility.checkNull(resultSet.getString("CONDITIONAL_EXPRESSION"));
                        JMSLogger.log("2", userInfo, "", "In FollowupActions actionType:[" + actionType + "]");
                        JMSLogger.log("2", userInfo, "", "In FollowupActions actionInfo:[" + actionInfo + "]");
                        JMSLogger.log("2", userInfo, "", "In FollowupActions condnalInput:[" + condnalInput + "]");
                        JMSLogger.log("2", userInfo, "", "In FollowupActions condnalExprn:[" + condnalExprn + "]");
                        if (!"".equals(condnalExprn) && !"".equals(condnalInput)) {
                            isValid = this.evaluateExpression(detailDom, objContext, condnalExprn, condnalInput, userInfo);
                        } else if (!"".equals(condnalExprn) && condnalExprn.equalsIgnoreCase("GenValidate")) {
                            JMSLogger.log("2", userInfo, "", "In JMSFollowupAction else if line no 158:");
                            isValid = this.callGenvalidate(objName, objContext, xmlString, xtraParams, userInfo, follwUpActioTranId);
                        } else {
                            isValid = true;
                        }
                        JMSLogger.log("3", userInfo, null, "JMSFollowupActions.executeFollowupactions() expression result :[" + isValid + "]");
                        if (isValid) {
                            boolean isErrorNodeFound;
                            String result = "";
                            String responseStr = "";
                            if ("E".equals(actionType)) {
                                responseStr = this.sendEmail(detailDom, actionInfo, action.toUpperCase(), objName, tranId, title, userInfo, pkNames, "Email");
                                result = "Email~~";
                            } else if ("S".equals(actionType)) {
                                responseStr = this.sendSMS(detailDom, actionInfo, action.toUpperCase(), objName, tranId, title, userInfo);
                                result = "SMS~~";
                            } else if ("C".equals(actionType)) {
                                responseStr = this.sendTelegram(detailDom, actionInfo, action.toUpperCase(), objName, tranId, title, userInfo, pkNames);
                                result = "Telegram~~";
                            } else if ("R".equals(actionType)) {
                                result = "WebService~~";
                            } else if ("U".equals(actionType)) {
                                result = "URL~~";
                            } else if ("T".equals(actionType)) {
                                JMSLogger.log("0", userInfo, "", "Inside actionType T");
                                EventManagerEJB eventManager = new EventManagerEJB();
                                eventManager.setUserInfo(userInfo);
                                if (transDB != null && !"null".equalsIgnoreCase(transDB.trim()) && transDB.trim().length() > 0) {
                                    String XTRA_PARAMS = "loginCode=" + userInfo.getLoginCode() + "~~" + "loginEmpCode=" + userInfo.getEmpCode() + "~~" + "loginSiteCode=" + userInfo.getSiteCode() + "~~" + "entityCode=" + userInfo.getEntityCode() + "~~" + "profileId=" + userInfo.getProfileId() + "~~" + "userType=" + userInfo.getUserType() + "~~" + "runMode=I" + "~~" + "user_lang=" + user_lang + "~~" + "user_country=" + user_country + "~~" + "site_code=" + userInfo.getSiteCode() + "~~" + "termId=" + userInfo.getRemoteHost() + "~~" + "chgTerm=" + userInfo.getRemoteHost() + "~~" + "objName=" + objName;
                                    responseStr = eventManager.executeSystemEvent(objName, actionInfo, null, xmlString, xmlString, XTRA_PARAMS, null, userInfo);
                                }
                                result = "SystemEvent~~";
                            } else if ("W".equals(actionType)) {
                                responseStr = this.triggerWorkflow(userId, coreModelId, tranId, objName, userInfo);
                            }
                            responseStr = result.concat(responseStr);
                            if (!"".equals(responseStr) && responseStr.length() > 500) {
                                responseStr = responseStr.substring(0, 500);
                            }
                            String status = "S";
                            if (responseStr != null && responseStr.indexOf("<Errors>") != -1 && (isErrorNodeFound = new E12GenericUtility().isErrorNodeFound(responseStr))) {
                                status = "E";
                            }
                            this.updateFollwUpActionData(follwUpActioTranId, transDB, "1", status, responseStr);
                            continue;
                        }
                        String responseStr = "Condition not matched.";
                        this.updateFollwUpActionData(follwUpActioTranId, transDB, "0", "S", responseStr);
                    }
                    if (resultSet != null) {
                        resultSet.close();
                        resultSet = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                }
                catch (Exception e) {
                    ITMException ie = new ITMException(e);
                    String exception = ie.getMessage();
                    if (!"".equals(exception) && exception.length() > 500) {
                        exception = exception.substring(0, 500);
                    }
                    try {
                        if (!"".equalsIgnoreCase(follwUpActioTranId) && !"".equalsIgnoreCase(userTransDB)) {
                            if (isValid) {
                                this.updateFollwUpActionData(follwUpActioTranId, userTransDB, "1", "X", exception);
                            } else {
                                this.updateFollwUpActionData(follwUpActioTranId, userTransDB, "0", "X", exception);
                            }
                        }
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                    throw new ITMException(e);
                }
            }
            finally {
                try {
                    if (resultSet != null) {
                        resultSet.close();
                        resultSet = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (SQLException e) {
                    throw new ITMException(e);
                }
            }
        }
    }

    private String getValueFromXTRA_PARAMS(String xtraParams, String searchParam, UserInfoBean userInfo) throws RemoteException, ITMException {
        String argument = "-1";
        try {
            int searchParamPos = xtraParams.indexOf(searchParam);
            if (searchParamPos != -1) {
                int equalsPos = xtraParams.indexOf("=", searchParamPos);
                int endPos = xtraParams.indexOf("~", equalsPos);
                if (endPos < 0) {
                    endPos = xtraParams.length();
                }
                if ((argument = xtraParams.substring(equalsPos + 1, endPos)) != null && ("null".equalsIgnoreCase(argument) || "undefined".equalsIgnoreCase(argument))) {
                    argument = "";
                }
            }
            JMSLogger.log("3", userInfo, null, "Value of " + searchParam + " : " + argument);
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return argument;
    }

    private String getDBColumnValue(String tableName, String columnName, String condition, String transDB) throws ITMException {
        String sql = "";
        String returnValue = null;
        Statement pstmt = null;
        ResultSet rs = null;
        Connection conn = null;
        try {
            try {
                ConnDriver connDriver = new ConnDriver();
                conn = transDB != null && !"null".equalsIgnoreCase(transDB.trim()) && transDB.trim().length() > 0 ? connDriver.getConnectDB(transDB) : connDriver.getConnectDB("Driver");
                sql = " SELECT " + columnName + " FROM " + tableName + " " + condition;
                pstmt = conn.prepareStatement(sql);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    returnValue = rs.getString(1);
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (Exception exp) {
                throw new ITMException(exp);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (SQLException se) {
                throw new ITMException(se);
            }
        }
        return returnValue;
    }

    private boolean evaluateExpression(Document detailDom, String objContext, String condnalExprn, String condnalInput, UserInfoBean userInfo) throws ITMException {
        boolean result = false;
        E12GenericUtility e12GenericUtility = new E12GenericUtility();
        try {
            JMSLogger.log("2", userInfo, null, "In evaluateExpression Conditional Expression : [" + condnalExprn + "]");
            if (condnalExprn != null && condnalExprn.length() > 0) {
                ScriptEngineManager manager = new ScriptEngineManager();
                ScriptEngine scriptEngine = manager.getEngineByName("js");
                if (condnalInput != null && condnalInput.length() > 0) {
                    JMSLogger.log("2", userInfo, null, "In evaluateExpression Conditional Input : [" + condnalInput + "]");
                    String[] condnalInputArr = condnalInput.split(",");
                    int i = 0;
                    while (i < condnalInputArr.length) {
                        String formNo = "";
                        String fieldName = "";
                        String inputStr = E12GenericUtility.checkNull(condnalInputArr[i]);
                        if (inputStr.indexOf(":") != -1) {
                            formNo = inputStr.substring(0, inputStr.indexOf(":"));
                            fieldName = inputStr.substring(inputStr.indexOf(":"));
                        } else {
                            formNo = "1";
                            fieldName = inputStr;
                        }
                        String fieldValue = "";
                        fieldValue = formNo.equals(objContext) ? e12GenericUtility.getColumnValue(fieldName, detailDom, formNo) : e12GenericUtility.getColumnValue(fieldName, detailDom, formNo);
                        scriptEngine.put(fieldName, fieldValue);
                        ++i;
                    }
                    result = (Boolean)scriptEngine.eval(condnalExprn);
                }
            }
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        JMSLogger.log("2", userInfo, null, "In evaluateExpression Conditional Expression result : [" + result + "]");
        return result;
    }

    private String sendEmail(Document detailDom, String formatCode, String action, String objName, String tranId, String title, UserInfoBean userInfo, String pkNmaes, String calledFrom) throws ITMException {
        BaseLogger.log("3", null, null, "Called from sendEmail:::" + calledFrom);
        Statement pstmt = null;
        ResultSet resultSet = null;
        Connection connection = null;
        try {
            String transDB = userInfo.getTransDB();
            String toAddr = "";
            String ccAddr = "";
            String bccAddr = "";
            String subject = "";
            String body = "";
            String templateCode = "";
            String templateName = "";
            String attachmentText = "";
            String attachmentType = "";
            String attachmentObject = "";
            String editFlag = "E";
            String saveFlag = "false";
            String tranDataStr = new E12GenericUtility().serializeDom(detailDom);
            String tranPKNames = pkNmaes;
            String tranPKValues = tranId;
            String sql = "SELECT SEND_TO, COPY_TO, BLIND_COPY, SUBJECT, BODY_TEXT, FORMAT_CODE, MAIL_DESCR, ATTACH_OBJECT, ATTACH_TEXT, ATTACH_TYPE FROM MAIL_FORMAT WHERE FORMAT_CODE='" + formatCode + "'";
            ConnDriver connDriver = new ConnDriver();
            connection = connDriver.getConnectDB(transDB);
            pstmt = connection.prepareStatement(sql);
            resultSet = pstmt.executeQuery();
            while (resultSet.next()) {
                toAddr = E12GenericUtility.checkNull(resultSet.getString("SEND_TO"));
                ccAddr = E12GenericUtility.checkNull(resultSet.getString("COPY_TO"));
                bccAddr = E12GenericUtility.checkNull(resultSet.getString("BLIND_COPY"));
                subject = E12GenericUtility.checkNull(resultSet.getString("SUBJECT"));
                body = E12GenericUtility.checkNull(resultSet.getString("BODY_TEXT"));
                templateCode = E12GenericUtility.checkNull(resultSet.getString("FORMAT_CODE"));
                templateName = E12GenericUtility.checkNull(resultSet.getString("MAIL_DESCR"));
                attachmentText = E12GenericUtility.checkNull(resultSet.getString("ATTACH_TEXT"));
                attachmentType = E12GenericUtility.checkNull(resultSet.getString("ATTACH_TYPE"));
                attachmentObject = E12GenericUtility.checkNull(resultSet.getString("ATTACH_OBJECT"));
                JMSLogger.log("3", userInfo, null, "FollowupActions sendEmail toAddr:[" + toAddr + "]");
                JMSLogger.log("3", userInfo, null, "FollowupActions sendEmail ccAddr:[" + ccAddr + "]");
                JMSLogger.log("3", userInfo, null, "FollowupActions sendEmail bccAddr:[" + bccAddr + "]");
                JMSLogger.log("3", userInfo, null, "FollowupActions sendEmail subject:[" + subject + "]");
                JMSLogger.log("3", userInfo, null, "FollowupActions sendEmail body:[" + body + "]");
                JMSLogger.log("3", userInfo, null, "FollowupActions sendEmail templateCode:[" + templateCode + "]");
                JMSLogger.log("3", userInfo, null, "FollowupActions sendEmail templateName:[" + templateName + "]");
                JMSLogger.log("3", userInfo, null, "FollowupActions sendEmail attachmentText:[" + attachmentText + "]");
                JMSLogger.log("3", userInfo, null, "FollowupActions sendEmail attachmentType:[" + attachmentType + "]");
                JMSLogger.log("3", userInfo, null, "FollowupActions sendEmail attachmentObject:[" + attachmentObject + "]");
            }
            if (resultSet != null) {
                resultSet.close();
                resultSet = null;
            }
            if (pstmt != null) {
                pstmt.close();
                pstmt = null;
            }
            if (connection != null) {
                connection.close();
                connection = null;
            }
            TransactionEmailTempltEJB emailTemplate = new TransactionEmailTempltEJB();
            String responseStr = emailTemplate.sendMail(objName, userInfo, toAddr, ccAddr, bccAddr, subject, body, tranDataStr, tranPKNames, tranPKValues, attachmentText, saveFlag, templateName, templateCode, editFlag);
            JMSLogger.log("3", userInfo, null, "FollowupActions sendEmail response:[" + responseStr + "]");
            JMSLogger.log("3", userInfo, null, "FollowupActions sendMail Successfully.");
            String string = responseStr;
            return string;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                    resultSet = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (connection != null) {
                    connection.close();
                    connection = null;
                }
            }
            catch (Exception e2) {
                throw new ITMException(e2);
            }
        }
    }

    private String sendTelegram(Document detailDom, String formatCode, String action, String objName, String tranId, String title, UserInfoBean userInfo, String pkNmaes) throws ITMException {
        String result = this.sendEmail(detailDom, formatCode, action, objName, tranId, title, userInfo, pkNmaes, "Email");
        BaseLogger.log("3", userInfo, null, "result gsb =[" + result + "]");
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getEmailId(String userType, String userID, String transDB) throws RemoteException, BaseException {
        JMSLogger.log("9", null, null, "Getting User Type for userType :" + userType + ": userID :-[" + userID + "]");
        String emailId = "";
        String tableName = "";
        String selectColName = "";
        String whereColName = "";
        ConnDriver connDriver = null;
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        String query = null;
        try {
            try {
                String entityCode;
                block47: {
                    if (userType.equalsIgnoreCase("P")) {
                        tableName = "sales_pers";
                        selectColName = "email_addr";
                        whereColName = "sales_pers";
                    } else if (userType.equalsIgnoreCase("E")) {
                        tableName = "employee";
                        selectColName = "email_id_off";
                        whereColName = "emp_code";
                    } else if (userType.equalsIgnoreCase("S")) {
                        tableName = "supplier";
                        selectColName = "email_addr";
                        whereColName = "supp_code";
                    } else if (userType.equalsIgnoreCase("C")) {
                        tableName = "customer";
                        selectColName = "email_addr";
                        whereColName = "cust_code";
                    } else {
                        tableName = "";
                        selectColName = "";
                        whereColName = "";
                    }
                    connDriver = new ConnDriver();
                    entityCode = "";
                    try {
                        Throwable throwable = null;
                        Object var15_20 = null;
                        try (Connection usersConn = connDriver.getConnectDB("Driver");){
                            String qry = "SELECT  ENTITY_CODE  FROM USERS WHERE CODE='" + userID + "'";
                            Throwable throwable2 = null;
                            Object var19_26 = null;
                            try {
                                PreparedStatement pstmt = usersConn.prepareStatement(qry);
                                try {
                                    try (ResultSet resultSet = pstmt.executeQuery();){
                                        if (resultSet.next()) {
                                            entityCode = resultSet.getString("ENTITY_CODE");
                                        }
                                    }
                                    if (pstmt == null) break block47;
                                }
                                catch (Throwable throwable3) {
                                    if (throwable2 == null) {
                                        throwable2 = throwable3;
                                    } else if (throwable2 != throwable3) {
                                        throwable2.addSuppressed(throwable3);
                                    }
                                    if (pstmt == null) throw throwable2;
                                    pstmt.close();
                                    throw throwable2;
                                }
                                pstmt.close();
                            }
                            catch (Throwable throwable4) {
                                if (throwable2 == null) {
                                    throwable2 = throwable4;
                                    throw throwable2;
                                }
                                if (throwable2 == throwable4) throw throwable2;
                                throwable2.addSuppressed(throwable4);
                                throw throwable2;
                            }
                        }
                        catch (Throwable throwable5) {
                            if (throwable == null) {
                                throwable = throwable5;
                                throw throwable;
                            }
                            if (throwable == throwable5) throw throwable;
                            throwable.addSuppressed(throwable5);
                            throw throwable;
                        }
                    }
                    catch (Exception e) {
                        throw new ITMException(e);
                    }
                }
                conn = connDriver.getConnectDB(transDB);
                query = "SELECT " + selectColName + " FROM " + tableName + " WHERE " + whereColName + " = '" + entityCode + "'";
                stmt = conn.createStatement();
                rs = stmt.executeQuery(query);
                while (true) {
                    if (!rs.next()) {
                        rs.close();
                        rs = null;
                        stmt.close();
                        stmt = null;
                        break;
                    }
                    emailId = rs.getString(1);
                }
            }
            catch (SQLException sqle) {
                throw new ITMException(sqle);
            }
            catch (BaseException basee) {
                throw new ITMException(basee);
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (conn != null) {
                    if (stmt != null) {
                        stmt.close();
                    }
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        JMSLogger.log("2", null, null, "[FollowupActions]EmailID :" + emailId);
        return emailId;
    }

    private String sendSMS(Document detailDom, String formatCode, String action, String objName, String tranId, String title, UserInfoBean userInfo) throws ITMException {
        try {
            String userId = userInfo.getLoginCode();
            String userName = E12GenericUtility.checkNull(userInfo.getUserName());
            String transDB = userInfo.getTransDB();
            String entityCode = this.getDBColumnValue("USERS", "ENTITY_CODE", "WHERE CODE = '" + userId + "'", transDB);
            JMSLogger.log("3", null, null, "EntityCode:[" + entityCode + "]");
            E12SMSComp smsComp = new E12SMSComp();
            String xtraParams = "loginCode=" + userId + "~~loginEmpCode" + userId;
            StringBuffer valueXmlString = new StringBuffer("<?xml version=\"1.0\" ?><Root><Header></Header><Errors></Errors>");
            valueXmlString.append("<Detail1 objName = ''>");
            valueXmlString.append("<code><![CDATA[").append(entityCode).append("]]></code>");
            valueXmlString.append("<name><![CDATA[").append(userName).append("]]></name>");
            valueXmlString.append("<action><![CDATA[").append(action).append("]]></action>");
            valueXmlString.append("<object><![CDATA[").append(title).append("]]></object>");
            valueXmlString.append("<tran_id><![CDATA[").append(tranId).append("]]></tran_id>");
            valueXmlString.append("</Detail1>");
            valueXmlString.append("</Root>");
            JMSLogger.log("3", userInfo, null, "FollowupActions sending SMS..........");
            String result = smsComp.sendSMS(valueXmlString.toString(), formatCode, xtraParams, userInfo);
            smsComp = null;
            JMSLogger.log("3", null, null, "Result of sendSMS:[" + result + "]");
            if ("SEND_SUCCESS".equals(result)) {
                JMSLogger.log("3", userInfo, null, "FollowupActions send SMS successfully..........");
            } else {
                JMSLogger.log("3", userInfo, null, "FollowupActions send SMS failed..........");
            }
            return result;
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
    }

    private String getFollwUpActionsNextSeqId(Connection con) throws RemoteException, ITMException {
        ResultSet rs = null;
        String tranId = "";
        try {
            String query = "";
            if ("db2".equalsIgnoreCase(CommonConstants.DB_NAME)) {
                query = "SELECT NEXTVAL FOR FOLLOWUP_ACTIONS_SEQ FROM DUAL";
            } else if ("mysql".equalsIgnoreCase(CommonConstants.DB_NAME) || "MSSQL".equalsIgnoreCase(CommonConstants.DB_NAME)) {
                String maxValueStr = "";
                String getMaxValue = "SELECT MAX(MAX_VALUE) FROM SEQUENCES WHERE SEQ_NAME = 'FOLLOWUP_ACTIONS_SEQ' ";
                PreparedStatement pstmt = con.prepareStatement(getMaxValue);
                ResultSet rst = pstmt.executeQuery();
                PreparedStatement pstm = null;
                if (rst.next()) {
                    if (rst.getInt(1) != 0) {
                        tranId = String.valueOf(rst.getInt(1));
                        if (tranId != null && tranId.length() > 0) {
                            maxValueStr = "UPDATE SEQUENCES SET MAX_VALUE = ? WHERE SEQ_NAME = 'FOLLOWUP_ACTIONS_SEQ' ";
                            pstm = con.prepareStatement(maxValueStr);
                            pstm.setLong(1, rst.getInt(1) + 1);
                            tranId = Integer.toString(Integer.parseInt(tranId) + 1);
                        }
                    } else {
                        tranId = String.valueOf(1);
                        maxValueStr = "INSERT INTO SEQUENCES ( MAX_VALUE ,SEQ_NAME) VALUES (?, ?) ";
                        pstm = con.prepareStatement(maxValueStr);
                        pstm.setInt(1, 1);
                        pstm.setString(2, "FOLLOWUP_ACTIONS_SEQ");
                    }
                }
                pstm.executeUpdate();
                rst.close();
                rst = null;
                pstmt.close();
                pstmt = null;
                pstm.close();
                pstm = null;
            } else {
                query = "SELECT FOLLOWUP_ACTIONS_SEQ.NEXTVAL FROM DUAL";
            }
            Statement stmt = con.createStatement();
            if (!"mysql".equalsIgnoreCase(CommonConstants.DB_NAME) && !"MSSQL".equalsIgnoreCase(CommonConstants.DB_NAME)) {
                rs = stmt.executeQuery(query);
                while (rs.next()) {
                    tranId = rs.getString(1);
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
            String tmp1 = "000000000000000000000000" + tranId;
            int tm_len = tmp1.length() - 20;
            tranId = tmp1.substring(tm_len);
            if (stmt != null) {
                stmt.close();
                stmt = null;
            }
            if (con != null) {
                con.commit();
            }
        }
        catch (Exception e) {
            JMSLogger.log("0", null, null, "Exception :getFollwUpActionsNextSeqId :==>\n" + e);
            throw new ITMException(e);
        }
        return tranId;
    }

    private void insertFollwUpActionData(String transDB, String tranId, String userId, String objName, String refSer, String refId, String actionName) throws Exception {
        Statement pStmt = null;
        Connection con = null;
        try {
            try {
                ConnDriver connDriver = new ConnDriver();
                con = connDriver.getConnectDB(transDB);
                String insertQuery = "INSERT INTO FOLLOW_UP_ACTIONS_LOGS  (TRAN_ID, USER_ID, OBJ_NAME, REF_SER, REF_ID, ACTION_NAME, COND_MATCHED, TIME_START, TIME_END, RESULT_TYPE, RESULT_DETAILS )VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? )";
                pStmt = con.prepareStatement(insertQuery);
                pStmt.setString(1, tranId);
                pStmt.setString(2, userId);
                pStmt.setString(3, objName);
                pStmt.setString(4, refSer);
                pStmt.setString(5, refId);
                pStmt.setString(6, actionName);
                pStmt.setString(7, "0");
                pStmt.setTimestamp(8, new Timestamp(System.currentTimeMillis()));
                pStmt.setTimestamp(9, null);
                pStmt.setString(10, "I");
                pStmt.setString(11, "");
                pStmt.executeUpdate();
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
                if (con != null) {
                    con.commit();
                }
            }
            catch (Exception e) {
                JMSLogger.log("0", null, null, "Exception :insertFollwUpActionData :==>\n" + e);
                if (con != null) {
                    con.rollback();
                }
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
                if (con != null) {
                    con.close();
                    con = null;
                }
            }
            catch (Exception e) {
                JMSLogger.log("0", null, null, "Exception :insertFollwUpActionData==>");
                throw new ITMException(e);
            }
        }
    }

    private void updateFollwUpActionData(String tranId, String transDB, String cond_match, String result_type, String result_detail) throws Exception {
        Connection con = null;
        E12GenericUtility genericUtility = new E12GenericUtility();
        Statement pStmt = null;
        try {
            try {
                ConnDriver connDriver = new ConnDriver();
                con = connDriver.getConnectDB(transDB);
                String updateQuery = "";
                String currentDateTime = "";
                SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateTimeFormat());
                Date currentDate = new Date();
                currentDateTime = sdf.format(currentDate);
                currentDateTime = genericUtility.getValidDateTimeString(currentDateTime.toString(), genericUtility.getApplDateTimeFormat(), genericUtility.getDBDateFormat());
                updateQuery = "UPDATE FOLLOW_UP_ACTIONS_LOGS SET COND_MATCHED = ?, TIME_END = ?, RESULT_TYPE = ? , RESULT_DETAILS = ? WHERE TRAN_ID = ?";
                pStmt = con.prepareStatement(updateQuery);
                pStmt.setString(1, cond_match);
                pStmt.setTimestamp(2, Timestamp.valueOf(currentDateTime));
                pStmt.setString(3, result_type);
                pStmt.setString(4, result_detail);
                pStmt.setString(5, tranId);
                pStmt.executeUpdate();
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
                if (con != null) {
                    con.commit();
                }
            }
            catch (Exception e) {
                JMSLogger.log("0", null, null, "Exception :updateFollwUpActionData :==>\n" + e);
                if (con != null) {
                    con.rollback();
                }
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
                if (con != null) {
                    con.close();
                    con = null;
                }
            }
            catch (Exception e) {
                JMSLogger.log("0", null, null, "Exception :updateFollwUpActionData==>");
                throw new ITMException(e);
            }
        }
    }

    public void executeFollowUpEDIService(String jmsData) throws ITMException, Exception {
        block20: {
            BaseLogger.log("2", null, null, "jmsData : [" + jmsData + "]");
            NoSQLConnection connection = null;
            String result = "";
            String status = "";
            E12GenericUtility genericUtility = new E12GenericUtility();
            SimpleDateFormat formatter = new SimpleDateFormat(genericUtility.getApplDateTimeFormat());
            StringBuffer preProcessDataLogBuff = new StringBuffer();
            try {
                try {
                    JSONObject dataJson = new JSONObject(jmsData);
                    String endpoint = E12GenericUtility.getJSONValue(dataJson, "ENDPOINT");
                    String enterprise = E12GenericUtility.getJSONValue(dataJson, "ENTERPRISE");
                    String userId = E12GenericUtility.getJSONValue(dataJson, "USER_ID");
                    String inputData = E12GenericUtility.getJSONValue(dataJson, "INPUT_DATA");
                    String receiveDate = E12GenericUtility.getJSONValue(dataJson, "RECEIVE_DATE");
                    String collection = E12GenericUtility.getJSONValue(dataJson, "COLLECTION");
                    String ediDataFile = E12GenericUtility.getJSONValue(dataJson, "EDI_FILE_NAME");
                    String requestIP = E12GenericUtility.getJSONValue(dataJson, "REQUEST_IP");
                    String userInfoStr = E12GenericUtility.getJSONValue(dataJson, "USER_INFO");
                    preProcessDataLogBuff.append("(").append(endpoint).append(")").append(" ").append(requestIP).append(" ").append(formatter.format(new Date())).append(" ");
                    UserInfoBean userInfo = new UserInfoBean(userInfoStr);
                    BaseLogger.log("3", userInfo, null, "userInfo : [" + userInfo + "]");
                    BaseLogger.log("3", userInfo, null, "API_FILE_DESTINATION : [" + CommonConstants.API_FILE_DESTINATION + "]");
                    if (CommonConstants.API_FILE_DESTINATION != null && CommonConstants.API_FILE_DESTINATION.length() > 0) {
                        NoSQLConnDriver connDriver = new NoSQLConnDriver();
                        connection = connDriver.getConnectNoSQLDB(String.valueOf(userInfo.getEnterprise()) + "_NOSQL", CommonConstants.API_FILE_DESTINATION);
                        connDriver = null;
                        HashMap<String, String> dataMap = new HashMap<String, String>();
                        dataMap.put("ENDPOINT", endpoint);
                        dataMap.put("ENTERPRISE", enterprise);
                        dataMap.put("USER_ID", userId);
                        dataMap.put("INPUT_DATA", inputData);
                        dataMap.put("RECEIVE_DATE", receiveDate);
                        dataMap.put("RECEIVE_STATUS", "N");
                        dataMap.put("EDI_FILE_NAME", ediDataFile);
                        dataMap.put("REQUEST_IP", requestIP);
                        MongoDBHandler dbHandler = new MongoDBHandler(connection, collection);
                        ObjectId mongoDBRefId = dbHandler.insert(dataMap);
                        BaseLogger.log("3", userInfo, null, "mongoDBRefId : [" + mongoDBRefId + "]");
                        JSONObject mongoDBDataJson = dbHandler.retrieve(mongoDBRefId);
                        BaseLogger.log("3", userInfo, null, "mongoDBDataJson : [" + mongoDBDataJson + "]");
                        if (mongoDBDataJson != null) {
                            String fileType = ediDataFile.substring(ediDataFile.lastIndexOf(".") + 1);
                            BaseLogger.log("3", userInfo, null, "fileType : [" + fileType + "]");
                            inputData = E12GenericUtility.getJSONValue(mongoDBDataJson, "INPUT_DATA");
                            BaseLogger.log("3", userInfo, null, "inputData : [" + inputData + "]");
                            if (inputData != null && inputData.length() > 0) {
                                result = mongoDBRefId.toString();
                                dbHandler.update("_id", result, "RECEIVE_STATUS", "Y");
                                dataJson.put("REF_ID", (Object)result);
                                status = "success";
                                preProcessDataLogBuff.append(CommonConstants.API_FILE_DESTINATION).append(" Ref_Id : (").append(result).append(") ");
                            } else {
                                status = "error";
                                result = "Invalid input data";
                            }
                        } else {
                            status = "error";
                            result = "Something went wrong. Data not stored in " + CommonConstants.API_FILE_DESTINATION;
                        }
                        if (connection != null) {
                            connection.close();
                            connection = null;
                        }
                    }
                    BaseLogger.log("3", userInfo, null, "status : [" + status + "], result : [" + result + "]");
                    if ("error".equalsIgnoreCase(status)) break block20;
                    String batchId = new E12CreateBatchLoadEjb().processFileData(dataJson, userInfo);
                    batchId = E12GenericUtility.checkNull(batchId);
                    BaseLogger.log("3", userInfo, null, "batchId : [" + batchId + "]");
                    this.batchIDShare = batchId;
                    BaseLogger.log("3", userInfo, null, "batchIDShare : [" + this.batchIDShare + "]");
                    if (batchId.length() > 0) {
                        status = "success";
                        result = "Data inserted into Batchload with (" + batchId + ") batch id.";
                        break block20;
                    }
                    status = "error";
                    result = "Something went wrong. Not inserted in Batchload";
                }
                catch (Exception e) {
                    e.printStackTrace();
                    BaseLogger.log("0", null, null, "Exception in executeFollowUpEDIService :: preProcessData : [" + e.getMessage() + "]");
                    status = "exception";
                    result = "Getting exception (" + e.getMessage() + ") while inserting into Batchload.";
                    preProcessDataLogBuff.append(formatter.format(new Date())).append(" ").append(status).append(" ").append(result);
                    BaseLogger.log("3", null, null, "preProcessDataLogBuff : [" + preProcessDataLogBuff.toString() + "]");
                    String fileName = "edi_preProcessData_log_" + new SimpleDateFormat("yyyyMMdd").format(new Date()) + ".txt";
                    try {
                        genericUtility.writeFile(CommonConstants.EDI_LOG, fileName, preProcessDataLogBuff.toString(), true);
                        if (connection != null) {
                            connection.close();
                            connection = null;
                        }
                    }
                    catch (ITMException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                preProcessDataLogBuff.append(formatter.format(new Date())).append(" ").append(status).append(" ").append(result);
                BaseLogger.log("3", null, null, "preProcessDataLogBuff : [" + preProcessDataLogBuff.toString() + "]");
                String fileName = "edi_preProcessData_log_" + new SimpleDateFormat("yyyyMMdd").format(new Date()) + ".txt";
                try {
                    genericUtility.writeFile(CommonConstants.EDI_LOG, fileName, preProcessDataLogBuff.toString(), true);
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                }
                catch (ITMException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private boolean callGenvalidate(String objName, String objContext, String xmlString, String xtraParams, UserInfoBean userInfo, String follwUpActioTranId) throws ITMException {
        JMSLogger.log("2", userInfo, "", "In JMSFollowupAction callGenvalidate");
        boolean isValid = false;
        String retString = "";
        String errorId = "";
        Connection connection = null;
        Statement pstmt = null;
        try {
            try {
                Class[] paramSpec = new Class[7];
                Object[] params = new Object[7];
                paramSpec[0] = Class.forName("java.lang.String");
                paramSpec[1] = Class.forName("java.lang.String");
                paramSpec[2] = Class.forName("java.lang.String");
                paramSpec[3] = Class.forName("java.lang.String");
                paramSpec[4] = Class.forName("java.lang.String");
                paramSpec[5] = Class.forName("java.lang.String");
                paramSpec[6] = Class.forName("java.lang.String");
                params[0] = xmlString;
                params[1] = xmlString;
                params[2] = xmlString;
                params[3] = "1";
                params[4] = "w_" + objName;
                params[5] = xtraParams;
                params[6] = "followup";
                Class<?> classObj = null;
                classObj = Class.forName("ibase.webitm.ejb.sys.GenValidate");
                ValidatorEJB valEJB = (ValidatorEJB)classObj.newInstance();
                valEJB.setUserInfo(userInfo);
                Method metObj = classObj.getMethod("wfValData", paramSpec);
                metObj.setAccessible(true);
                Object retVal = metObj.invoke((Object)valEJB, params);
                retString = retVal.toString();
                valEJB = null;
                JMSLogger.log("2", userInfo, "", "In JMSFollowupAction callGenvalidate retString :[" + retString + "]");
                if (retString != null && retString.indexOf("error") != -1) {
                    Node errorNode;
                    isValid = true;
                    String updateQuery = "";
                    Document currentDetailNode = new E12GenericUtility().parseString(retString);
                    if (currentDetailNode.getElementsByTagName("error").item(0) != null && (errorNode = currentDetailNode.getElementsByTagName("error").item(0)).hasAttributes() && errorNode.getAttributes().getNamedItem("id") != null) {
                        errorId = errorNode.getAttributes().getNamedItem("id").getNodeValue();
                    }
                    String transDB = userInfo.getTransDB();
                    ConnDriver connDriver = new ConnDriver();
                    connection = connDriver.getConnectDB(transDB);
                    updateQuery = "UPDATE FOLLOW_UP_ACTIONS_LOGS SET ERROR_CD = '" + errorId + "'  WHERE TRAN_ID = '" + follwUpActioTranId + "'";
                    pstmt = connection.prepareStatement(updateQuery);
                    int updateCount = pstmt.executeUpdate();
                    JMSLogger.log("2", userInfo, "", "In JMSFollowupAction callGenvalidate FOLLOW_UP_ACTIONS_LOGS updateCount :[" + updateCount + "]");
                    connection.commit();
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                }
            }
            catch (Exception e) {
                JMSLogger.log("0", userInfo, "", "Exception:[" + E12GenericUtility.getStackTrace(e) + "]");
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (connection != null) {
                    connection.close();
                    connection = null;
                }
            }
            catch (Exception e) {
                JMSLogger.log("0", userInfo, "", "Exception:[" + E12GenericUtility.getStackTrace(e) + "]");
                throw new ITMException(e);
            }
        }
        return isValid;
    }

    private String triggerWorkflow(String userId, String editorId, String refID, String objName, UserInfoBean userInfo) throws ITMException {
        String responseStr = "In Triggered workflow";
        BaseLogger.log("2", userInfo, null, "JMSFollowupActions.triggerWorkflow()");
        try {
            String transDB = userInfo.getTransDB();
            BaseLogger.log("2", userInfo, null, "JMSFollowupActions.triggerWorkflow() userInfo  : [" + userInfo + "]");
            BaseLogger.log("2", userInfo, null, "JMSFollowupActions.triggerWorkflow() transDB  : [" + transDB + "]");
            BaseLogger.log("2", userInfo, null, "JMSFollowupActions.triggerWorkflow() userId   : [" + userId + "]");
            BaseLogger.log("2", userInfo, null, "JMSFollowupActions.triggerWorkflow() editorId : [" + editorId + "]");
            BaseLogger.log("2", userInfo, null, "JMSFollowupActions.triggerWorkflow() refID    : [" + refID + "]");
            BaseLogger.log("2", userInfo, null, "JMSFollowupActions.triggerWorkflow() objName  : [" + objName + "]");
            if (objName.length() > 0 && refID.length() > 0) {
                DBAccessEJB dbAccessEJB = new DBAccessEJB();
                String refSer = dbAccessEJB.getDBColumnValue("TRANSETUP", "REF_SER", " TRAN_WINDOW = 'w_" + objName + "' ", transDB);
                BaseLogger.log("2", userInfo, null, "JMSFollowupActions.triggerWorkflow() refSer   : [" + refSer + "]");
                String wrkflwOpt = dbAccessEJB.getDBColumnValue("TRANSETUP", "WORKFLOW_OPT", " TRAN_WINDOW = 'w_" + objName + "' ", transDB);
                BaseLogger.log("2", userInfo, null, "JMSFollowupActions.triggerWorkflow() wrkflwOpt : [" + wrkflwOpt + "]");
                dbAccessEJB = null;
                if (this.checkNull(wrkflwOpt).length() > 0) {
                    String wfObjName = objName;
                    String wfRefSer = refSer;
                    String wfRefID = refID;
                    String jmsData = String.valueOf(wfObjName) + "!~~!" + wfRefSer + "!~~!" + wfRefID + "!~~!" + userInfo.toString();
                    JMSWorklFlowInvoker jmsWorklFlowInvoker = new JMSWorklFlowInvoker();
                    jmsWorklFlowInvoker.invokeWorkFlow(jmsData);
                    responseStr = "Workflow Triggered Successfully";
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", userInfo, null, "JMSFollowupActions.triggerWorkflow() Exception : [" + E12GenericUtility.getStackTrace(e) + "]");
            e.printStackTrace();
        }
        BaseLogger.log("2", userInfo, null, "JMSFollowupActions.triggerWorkflow() responseStr : [" + responseStr + "]");
        return responseStr;
    }

    private String checkNull(String input) {
        if (input == null || "null".equalsIgnoreCase(input)) {
            input = "";
        }
        return input.trim();
    }
}

