/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.servlet;

import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.HTMLTaggingStorageEJB;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONObject;

public class HTMLTaggingStorageServlet
extends HttpServlet {
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HTMLTaggingStorageEJB storageLocal = null;
        String responseString = "{}";
        ServletOutputStream ostream = response.getOutputStream();
        try {
            response.setContentType("application/json");
            String tagData = E12GenericUtility.readStreamAsString((InputStream)request.getInputStream());
            storageLocal = this.getHTMLTaggingStorageInstance();
            UserInfoBean userInfoBean = (UserInfoBean)request.getSession().getAttribute("USER_INFO");
            String userId = null;
            String tranDB = null;
            if (userInfoBean != null) {
                userId = userInfoBean.getEmpCode();
                tranDB = userInfoBean.getTransDB();
                responseString = storageLocal.insertTag(tagData, userId, tranDB);
            } else {
                responseString = "{'ex':'User info is null !'}";
            }
        }
        catch (Exception ex) {
            this.printException(ex, "While inserting tag data");
            String st = this.getStackTrace(ex);
            responseString = "{'ex':'" + st + "'}";
        }
        ostream.write(responseString.getBytes());
        ostream.flush();
        ostream.close();
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HTMLTaggingStorageEJB storageRemote = null;
        String responseStr = "{}";
        ServletOutputStream os = response.getOutputStream();
        try {
            response.setContentType("application/json");
            String tagData = E12GenericUtility.readStreamAsString((InputStream)request.getInputStream());
            JSONObject parsedTagData = new JSONObject(tagData);
            String refSer = (String)parsedTagData.remove("REF_SER");
            String refId = (String)parsedTagData.remove("REF_ID");
            String elementId = (String)parsedTagData.remove("ELEMENT_ID");
            storageRemote = this.getHTMLTaggingStorageInstance();
            UserInfoBean userInfoBean = (UserInfoBean)request.getSession().getAttribute("USER_INFO");
            String userId = null;
            String tranDB = null;
            if (userInfoBean != null) {
                userId = userInfoBean.getEmpCode();
                tranDB = userInfoBean.getTransDB();
                int affectedRows = storageRemote.updateTag(refSer, refId, elementId, parsedTagData.toString(), userId, tranDB);
                if (affectedRows > 0) {
                    responseStr = parsedTagData.toString();
                }
            } else {
                responseStr = "{'ex':'User info is null !'}";
            }
        }
        catch (Exception ex) {
            this.printException(ex, "While updating tag data");
            responseStr = "{'ex':'" + this.getStackTrace(ex) + "'}";
        }
        os.write(responseStr.getBytes());
        os.flush();
        os.close();
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HTMLTaggingStorageEJB storageRemote = null;
        String responseStr = "{}";
        ServletOutputStream os = response.getOutputStream();
        try {
            response.setContentType("application/json");
            String tagData = E12GenericUtility.readStreamAsString((InputStream)request.getInputStream());
            JSONObject tagObj = new JSONObject(tagData);
            String refSer = request.getParameter("rs");
            String refId = request.getParameter("ri");
            String elementId = request.getParameter("ei");
            String tagId = tagObj.getString("id");
            storageRemote = this.getHTMLTaggingStorageInstance();
            UserInfoBean userInfoBean = (UserInfoBean)request.getSession().getAttribute("USER_INFO");
            String userId = null;
            String tranDB = null;
            if (userInfoBean != null) {
                userId = userInfoBean.getEmpCode();
                int affectedRows = storageRemote.deleteTag(refSer, refId, elementId, tagId, userId, tranDB = userInfoBean.getTransDB());
                if (affectedRows == 0) {
                    responseStr = "{'ex': 'Tag data not deleted !'}";
                }
            } else {
                responseStr = "{'ex':'User info is null !'}";
            }
        }
        catch (Exception ex) {
            this.printException(ex, "While deleting tag data");
            responseStr = "{'ex':'" + this.getStackTrace(ex) + "'}";
        }
        os.write(responseStr.getBytes());
        os.flush();
        os.close();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HTMLTaggingStorageEJB storageRemote = null;
        String responseStr = "{}";
        ServletOutputStream os = response.getOutputStream();
        try {
            response.setContentType("application/json");
            String refSer = request.getParameter("rs");
            String refId = request.getParameter("ri");
            String elementId = request.getParameter("ei");
            UserInfoBean userInfoBean = (UserInfoBean)request.getSession().getAttribute("USER_INFO");
            storageRemote = this.getHTMLTaggingStorageInstance();
            String userId = null;
            String tranDB = null;
            if (userInfoBean != null) {
                userId = userInfoBean.getEmpCode();
                tranDB = userInfoBean.getTransDB();
                responseStr = storageRemote.searchTags(refSer, refId, elementId, userId, tranDB);
            } else {
                responseStr = "{'ex':'User info is null !'}";
            }
        }
        catch (Exception ex) {
            this.printException(ex, "While searching tag data");
            String st = this.getStackTrace(ex);
            responseStr = "{'ex':'" + st + "'}";
        }
        os.write(responseStr.getBytes());
        os.flush();
        os.close();
    }

    private HTMLTaggingStorageEJB getHTMLTaggingStorageInstance() {
        return new HTMLTaggingStorageEJB();
    }

    private void printException(Exception ex, String desc) {
        BaseLogger.log("2", null, null, "Exception " + desc + " : " + ex.getClass().getSimpleName());
        ex.printStackTrace();
    }

    private String getStackTrace(Exception ex) {
        StringBuilder sb = new StringBuilder();
        StackTraceElement[] elements = ex.getStackTrace();
        sb.append(String.valueOf(ex.getClass().getSimpleName()) + " : " + ex.getMessage() + "\n");
        StackTraceElement[] stackTraceElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement element = stackTraceElementArray[n2];
            sb.append("\tat " + element.toString());
            ++n2;
        }
        return sb.toString();
    }
}

