/*
 * Decompiled with CFR 0.152.
 */
package ibase.bankIntegration.unsHsbc;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import ibase.bankIntegration.CommonMethods;
import ibase.utility.BaseLogger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import javax.json.JsonObject;

public class SFTPFileDownloader {
    static String SFTP_HOST = "";
    static int SFTP_PORT = 0;
    static String SFTP_USERNAME = "";
    static String PRIVATE_KEY_PATH = "";

    public SFTPFileDownloader(JsonObject payIntRArgsJSONObj) {
        SFTP_HOST = CommonMethods.getValueFromJson(payIntRArgsJSONObj, "host_name");
        SFTP_PORT = Integer.parseInt(CommonMethods.getValueFromJson(payIntRArgsJSONObj, "port"));
        SFTP_USERNAME = CommonMethods.getValueFromJson(payIntRArgsJSONObj, "username");
        String privateKeyFileName = CommonMethods.getValueFromJson(payIntRArgsJSONObj, "private_key_file_name");
        PRIVATE_KEY_PATH = String.valueOf(CommonMethods.getValueFromJson(payIntRArgsJSONObj, "private_key_file_path")) + File.separator + privateKeyFileName;
        System.out.println("SFTP_HOST....::[" + SFTP_HOST + "]");
        System.out.println("SFTP_PORT....::[" + SFTP_PORT + "]");
        System.out.println("SFTP_USERNAME....::[" + SFTP_USERNAME + "]");
        System.out.println("PRIVATE_KEY_PATH....::[" + PRIVATE_KEY_PATH + "]");
    }

    public void downloadFolder(String remoteFolderPath, String localFolderPath) throws Exception {
        System.out.println("Inside downloadFolder SFTP_HOST ....::[" + SFTP_HOST + "]");
        System.out.println("Inside downloadFolder SFTP_PORT....::[" + SFTP_PORT + "]");
        System.out.println("Inside downloadFolder SFTP_USERNAME....::[" + SFTP_USERNAME + "]");
        System.out.println("Inside downloadFolder PRIVATE_KEY_PATH....::[" + PRIVATE_KEY_PATH + "]");
        JSch jsch = new JSch();
        Session session = null;
        ChannelSftp channelSftp = null;
        OutputStream outputStream = null;
        try {
            try {
                jsch.addIdentity(PRIVATE_KEY_PATH);
                session = jsch.getSession(SFTP_USERNAME, SFTP_HOST, SFTP_PORT);
                session.setConfig("StrictHostKeyChecking", "no");
                session.connect();
                channelSftp = (ChannelSftp)session.openChannel("sftp");
                channelSftp.connect();
                File localFolder = new File(localFolderPath);
                if (!localFolder.exists()) {
                    localFolder.mkdirs();
                }
                channelSftp.cd(remoteFolderPath);
                Vector fileList = channelSftp.ls(".");
                for (ChannelSftp.LsEntry entry : fileList) {
                    if (entry.getAttrs().isDir()) continue;
                    String remoteFilePath = String.valueOf(remoteFolderPath) + "/" + entry.getFilename();
                    String localFilePath = String.valueOf(localFolderPath) + "/" + entry.getFilename();
                    outputStream = new FileOutputStream(localFilePath);
                    channelSftp.get(remoteFilePath, outputStream);
                    outputStream.close();
                    System.out.println("File downloaded successfully: " + entry.getFilename());
                }
            }
            catch (JSchException | SftpException | IOException e) {
                e.printStackTrace();
                throw e;
            }
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (channelSftp != null && channelSftp.isConnected()) {
                channelSftp.disconnect();
            }
            if (session != null && session.isConnected()) {
                session.disconnect();
            }
        }
    }

    public void downloadFile(String remoteFilePath, String localFilePath) {
        BaseLogger.log((String)"3", null, null, (Object)("Inside actionHandler SFTP_HOST.. payIntArgs[ " + SFTP_HOST + "]"));
        JSch jsch = new JSch();
        Session session = null;
        ChannelSftp channelSftp = null;
        OutputStream outputStream = null;
        try {
            try {
                jsch.addIdentity(PRIVATE_KEY_PATH);
                session = jsch.getSession(SFTP_USERNAME, SFTP_HOST, SFTP_PORT);
                session.setConfig("StrictHostKeyChecking", "no");
                session.connect();
                channelSftp = (ChannelSftp)session.openChannel("sftp");
                channelSftp.connect();
                outputStream = new FileOutputStream(localFilePath);
                channelSftp.get(remoteFilePath, outputStream);
                System.out.println("File downloaded successfully.");
            }
            catch (JSchException | SftpException | IOException e) {
                e.printStackTrace();
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
                if (channelSftp != null && channelSftp.isConnected()) {
                    channelSftp.disconnect();
                }
                if (session != null && session.isConnected()) {
                    session.disconnect();
                }
            }
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (channelSftp != null && channelSftp.isConnected()) {
                channelSftp.disconnect();
            }
            if (session != null && session.isConnected()) {
                session.disconnect();
            }
        }
    }

    public void readAndPrintFileContent(String remoteFilePath) {
        JSch jsch = new JSch();
        Session session = null;
        ChannelSftp channelSftp = null;
        InputStream inputStream = null;
        try {
            try {
                int bytesRead;
                jsch.addIdentity(PRIVATE_KEY_PATH);
                session = jsch.getSession(SFTP_USERNAME, SFTP_HOST, SFTP_PORT);
                session.setConfig("StrictHostKeyChecking", "no");
                session.connect();
                channelSftp = (ChannelSftp)session.openChannel("sftp");
                channelSftp.connect();
                inputStream = channelSftp.get(remoteFilePath);
                byte[] buffer = new byte[1024];
                while ((bytesRead = inputStream.read(buffer)) > 0) {
                    System.out.write(buffer, 0, bytesRead);
                }
                System.out.println("\nFile content read and printed successfully.");
            }
            catch (JSchException | SftpException | IOException e) {
                e.printStackTrace();
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
                if (channelSftp != null && channelSftp.isConnected()) {
                    channelSftp.disconnect();
                }
                if (session != null && session.isConnected()) {
                    session.disconnect();
                }
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (channelSftp != null && channelSftp.isConnected()) {
                channelSftp.disconnect();
            }
            if (session != null && session.isConnected()) {
                session.disconnect();
            }
        }
    }
}

