package ibase.webitm.ejb.wsfa.transactions;

import java.io.*;
import java.rmi.RemoteException;
import java.sql.*;
import java.util.*;
import javax.ejb.*;
import javax.naming.InitialContext;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import ibase.ejb.*;
import ibase.system.config.*;
import ibase.webitm.ejb.*;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
//import oracle.jdbc.driver.OraclePreparedStatement; 
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;

@Stateless
public class SprsStockistStatusChg extends ValidatorEJB implements SprsStockistStatusChgLocal,SprsStockistStatusChgRemote
{
	E12GenericUtility genericUtility = new E12GenericUtility();
	protected static String database = CommonConstants.DB_NAME;

	public String wfValData() throws RemoteException, ITMException
	{
		return "";
	}

	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;
		//E12GenericUtility genericUtility = new E12GenericUtility(); //Commented by vinayak on [29/04/2016] as object has been declared on class level
		try
		{
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString); 
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1); 
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2); 
			}
			errString = wfValData(dom, dom1, dom2, objContext, editFlag, xtraParams);
			System.out.println("ErrString: " + errString);
		}
		catch(Exception e)
		{
			System.out.println("Exception: SprsStockistStatusChg: wfValData(String xmlString): " + e.getMessage() + ":");
			errString = genericUtility.createErrorString(e);
			e.printStackTrace();
		}
		System.out.println("Returning from SprsStockistStatusChg wfValData");
		return (errString); 
	}
	
	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		System.out.println(" Sprs Item in function wfValData(dom,dom1,dom2)");
		String columnName = "";
		String columnValue = "";
		String userId = "";
		String errString = "";
		String sql = "";
		Connection connectionObject = null;		
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		String childNodeName = null;

		int intDtRet = 0;
		int ctr = 0;
		int noOfChilds = 0;
		int currentFormNo = 0;

		//E12GenericUtility genericUtility = new E12GenericUtility(); //Commented by vinayak on [29/04/2016] as object has been declared on class level

		try
		{
			//commented by saiprasad G.
			/*InitialContext ctx = getInitialContext();
			ITMDBAccessLocal itmDBAccessLocal = (ITMDBAccessLocal)ctx.lookup( "ibase/ITMDBAccessEJB/local" );*/
			ITMDBAccessEJB itmDBAccessLocal = new ITMDBAccessEJB();
			//Commented by vinayak on [11/07/2016][start]
			/*ConnDriver connDriver = null;
			connDriver = new ConnDriver();
			connectionObject = connDriver.getConnectDB("DriverValidator");*/
			//Commented by vinayak on [11/07/2016] [end]
			connectionObject = getConnection();//Added by vinayak on [11/07/2016] to get connection.
			
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			parentList = dom2.getElementsByTagName("Detail" + currentFormNo);
			parentNode = parentList.item(0);
			childList = parentNode.getChildNodes();
			noOfChilds = childList.getLength();
			for(ctr = 0; ctr < noOfChilds; ctr++)
			{
				childNode = childList.item(ctr);
				childNodeName = childNode.getNodeName();
				switch(currentFormNo)
				{
					case 1:
						if(childNodeName.equalsIgnoreCase("sprs_code"))
						{
							if(childNode.getFirstChild() == null)				
							{
								errString = itmDBAccessLocal.getErrorString("sprs_code","NULSPRCODE",userId,errString,connectionObject);								
							}
							else
							{
								columnValue = childNode.getFirstChild().getNodeValue().trim();
								if(columnValue != null)
								{	
									sql = "SELECT * FROM SPRS_STOCKIST WHERE SPRS_CODE =?";
									pstmt = connectionObject.prepareStatement(sql);
									/*--Commented and Changes below - Gulzar - 04/09/08 Req ID :SY89SUN019
									if ( this.database.toUpperCase().startsWith("ORACLE") ) 
									{
										((OraclePreparedStatement)pstmt).setFixedCHAR(1,columnValue);
									}
									else
									{
										pstmt.setString(1, columnValue);
									}*/
									pstmt.setString(1, columnValue);
									//End Changes - Gulzar - 04/09/08 Req ID :SY89SUN019
									rs = pstmt.executeQuery();
									if(!rs.next())
									{
										errString = itmDBAccessLocal.getErrorString("sprs_code","VSPRSCODE",userId,errString,connectionObject);
									}
									rs.close();//Gulzar - 04/09/08 Req ID :SY89SUN019
									pstmt.close();//Gulzar - 04/09/08 Req ID :SY89SUN019
								}								
							}							
						}
				}
				if (errString != null && errString.trim().length()>0)
				{
					break;
				}
			}
		}
		catch(SQLException se)//Gulzar - 04/09/08 Req ID :SY89SUN019
		{
			System.out.println("Exception: SprsStockistStatusChg: wfValData(Document dom): " + se.getMessage() + ":");
			errString = genericUtility.createErrorString(se);
		}
		catch(Exception e)
		{
			System.out.println("Exception: SprsStockistStatusChg: wfValData(Document dom): " + e.getMessage() + ":");
			errString = genericUtility.createErrorString(e);
		}
		finally //Gulzar - 04/09/08 Req ID :SY89SUN019
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if ( connectionObject != null )
				{
					connectionObject.close();
				}
			}
			catch(Exception e){}
		}
		return (errString);
	}
	
	public String itemChanged() throws RemoteException, ITMException
	{
		return "";
	}

	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{

		
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;
		//E12GenericUtility genericUtility = new E12GenericUtility(); //Commented by vinayak on [29/04/2016] as object has been declared on class level
		try
		{
			if (xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString); 
			}
			if (xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1); 
			}
			if (xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2); 
			}
			System.out.println("xmlstring:"+xmlString);
			System.out.println("xmlstring1:"+xmlString1);
			System.out.println("xmlstring2:"+xmlString2);
			errString = itemChanged(dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams);
			System.out.println ("ErrString :" + errString);
		}
		catch (Exception e)
		{
			System.out.println ("Exception :SprsStockistStatusChg :itemChanged(String,String):" + e.getMessage() + ":");
			errString = genericUtility.createErrorString(e);
		}
		System.out.println ("returning from SprsStockistStatusChg itemChanged");
		return errString;
	}

	public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		System.out.println("ITEMCHANGE is called...............................");
		String columnValue = "";
		String returnString = "";					
		Connection connectionObject = null;		
		Statement stmt = null; 
		ResultSet rs = null;		
		StringBuffer valueXmlString = new StringBuffer();

		String salesPers = "";
		String salesPersName = "";
		String selectSql = "";

		int currentFormNo = 0;
		//E12GenericUtility genericUtility = new E12GenericUtility(); //Commented by vinayak on [29/04/2016] as object has been declared on class level
		try
		{
			//Commented by vinayak on [11/07/2016] [start]
			/*ConnDriver connDriver = null;
			connDriver = new ConnDriver();
			connectionObject = connDriver.getConnectDB("DriverValidator");*/
			//Commented by vinayak on [11/07/2016] [end]
			connectionObject = getConnection();//Added by vinayak on [11/07/2016] to get connection.
			
			columnValue = genericUtility.getColumnValue(currentColumn,dom2);
			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			//Modified by Ganesh [16/05/2013][To add utf-8 in xml format][Start]
            //valueXmlString = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<editFlag>");
			valueXmlString = new StringBuffer("<?xml version=\"1.0\" encoding='UTF-8'?>\r\n<Root>\r\n<Header>\r\n<editFlag>");
          //Modified by Ganesh [16/05/2013][To add utf-8 in xml format][End]
			valueXmlString.append(editFlag).append("</editFlag>\r\n</Header>\r\n");
			System.out.println("currentFormNo ["+currentFormNo+"] currentColumn ["+currentColumn+"]");
			switch (currentFormNo)
			{
				case 1:
					valueXmlString.append("<Detail>\r\n");
					if (currentColumn.trim().equalsIgnoreCase("itm_default")) 
					{
						salesPers = genericUtility.getColumnValue("sprs_code",dom2);	
						selectSql = "SELECT SP_NAME FROM SALES_PERS WHERE SALES_PERS = '"+salesPers+"'";
						System.out.println("selectSql:: "+selectSql);
						stmt = connectionObject.createStatement();
						rs = stmt.executeQuery(selectSql);
						if ( rs.next() )
						{
							salesPersName = rs.getString("SP_NAME");
							valueXmlString.append("<sp_name>").append("<![CDATA["+salesPersName+"]]>").append("</sp_name>\r\n");
						}
						else
						{
							//Modified By Ganesh [15/05/2013][To set the value in cdata of xml][Start]
							//valueXmlString.append("<sp_name>").append("").append("</sp_name>\r\n");
							valueXmlString.append("<sp_name><![CDATA[").append("").append("]]></sp_name>\r\n");
							//Modified By Ganesh [15/05/2013][To set the value in cdata of xml][End]
							
						}
						rs.close();
					}
					else if (currentColumn.trim().equalsIgnoreCase("sprs_code")) 
					{
						columnValue = genericUtility.getColumnValue(currentColumn,dom2);	
						selectSql = "SELECT SP_NAME FROM SALES_PERS WHERE SALES_PERS = '"+columnValue+"'";
						System.out.println("selectSql:: "+selectSql);
						stmt = connectionObject.createStatement();
						rs = stmt.executeQuery(selectSql);
						if ( rs.next() )
						{
							salesPersName = rs.getString("SP_NAME");
							valueXmlString.append("<sp_name>").append("<![CDATA["+salesPersName+"]]>").append("</sp_name>\r\n");
						}
						else
						{
							//Modified By Ganesh [15/05/2013][To set the value in cdata of xml][Start]
							//valueXmlString.append("<sp_name>").append("").append("</sp_name>\r\n");
							valueXmlString.append("<sp_name><![CDATA[").append("").append("]]></sp_name>\r\n");
							//Modified By Ganesh [15/05/2013][To set the value in cdata of xml][End]
							
						}
						rs.close();
					}
					valueXmlString.append("</Detail>\r\n");
			}
		}
		catch(SQLException se)//Gulzar - 04/09/08 Req ID :SY89SUN019
		{
			System.out.println("Exception: SprsStockistStatusChg: itemChanged(Document,String): " + se.getMessage() + ":");
			valueXmlString = valueXmlString.append(genericUtility.createErrorString(se));
		}
		catch(Exception e)
		{
			System.out.println("Exception :SprsStockistStatusChg :itemChanged(Document,String):" + e.getMessage() + ":");
			valueXmlString = valueXmlString.append(genericUtility.createErrorString(e));
		}
		finally //Gulzar - 04/09/08 Req ID :SY89SUN019
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( stmt != null )
				{
					stmt.close();
					stmt = null;
				}
				if ( connectionObject != null )
				{
					connectionObject.close();
				}
			}
			catch(Exception e){}
		}
		valueXmlString.append("</Root>\r\n");	
		System.out.println("\n****ValueXmlString :" + valueXmlString + ":********");
		return valueXmlString.toString();
	}
	protected InitialContext getInitialContext()throws ITMException
	{
		InitialContext ctx = null;
		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			ctx = new InitialContext(appConnect.getProperty());
		}
		catch(ITMException itme)
		{
			System.out.println("ITMException :[EmpITDeclNewServlet] :getInitialContext :==>");
			throw itme;
		}
		catch(Exception e)
		{
			System.out.println("Exception :[EmpITDeclNewServlet] :getInitialContext :==>");
			throw new ITMException(e);
		}
		return ctx;
	}
}