package ibase.webitm.ejb.wsfa.masters;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;

public class RetailSchemePreSignSave extends ValidatorEJB
{
	private E12GenericUtility genericUtility = new E12GenericUtility();

	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		String errString = "";
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		try
		{
			BaseLogger.log("3",null,null,"RetailSchemePreSignSave Val xmlString :: " + xmlString );
			BaseLogger.log("3",null,null,"RetailSchemePreSignSave Val xmlString1 :: " + xmlString1 );
			BaseLogger.log("3",null,null,"RetailSchemePreSignSave Val xmlString2 :: " + xmlString2 );
			dom = parseString(xmlString);
			dom1 = parseString(xmlString1);
			if (xmlString2.trim().length() > 0 )
			{
				dom2 = parseString("<Root>" + xmlString2+ "</Root>");
			}
			errString = wfValData(dom, dom1, dom2, objContext, editFlag, xtraParams);
		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		return(errString);
	}

	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		NodeList parentNodeList = null;
		NodeList childNodeList = null;	
		Node parentNode = null;
		Node childNode = null;
		int currentFormNo = 0;
		String userId = "";
		String childNodeName = null;
		String errString = "";
		int ctr=0;
		int childNodeListLength;
		Connection conn = null;
		PreparedStatement pstmt = null ;
		ResultSet rs = null;
		StringBuffer valueXmlString = new StringBuffer(); 

		try
		{
			conn = getConnection();
			userId = getValueFromXTRA_PARAMS(xtraParams, "loginCode");

			if ((objContext != null) && (objContext.trim().length() > 0)) 
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			switch (currentFormNo) 
			{
			case 1:

				parentNodeList = dom.getElementsByTagName("Detail1");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				valueXmlString.append("<Detail1>");

				for( ctr = 0; ctr < childNodeListLength; ctr ++ )
				{
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					BaseLogger.log("3",null,null,"RetailSchemePreSignSave childNodeName 1st= "+childNodeName);

					if( childNodeName.equalsIgnoreCase("payout_date") )
					{   
						String payoutDate = checkNull(genericUtility.getColumnValue("payout_date", dom)).trim();
						BaseLogger.log("3",null,null,"RetailSchemePreSignSave payoutDate  = "+payoutDate );

						String wfStatus = checkNull(genericUtility.getColumnValue("wf_status", dom)).trim();
						BaseLogger.log("3",null,null,"RetailSchemePreSignSave wfStatus = "+wfStatus);

						if( payoutDate == null || payoutDate.length() <= 0 ) 
						{
							errString = getErrorString("payout_date", "RETSCHPAYD", userId);
							break;
						}
						else
						{
							BaseLogger.log("3",null,null,"RetailSchemePreSignSave IN ELSE [payout_date] payoutDate  = "+payoutDate );

							SimpleDateFormat sdf=new SimpleDateFormat(genericUtility.getApplDateFormat());
							SimpleDateFormat sdf1=new SimpleDateFormat(genericUtility.getDBDateFormat());

							Date dateTo = sdf.parse( payoutDate );
							BaseLogger.log("3",null,null,"RetailSchemePreSignSave else dateTo = "+dateTo);

							//Timestamp s1 = Timestamp.valueOf(sdf1.format(dateTo)+" 00:00:00.0");
							//Timestamp s2 = new Timestamp(System.currentTimeMillis());
							BaseLogger.log("3",null,null,"RetailSchemePreSignSave else payout_date dateTo= "+dateTo);

							//if( s2.after(s1) ) 
							if ( ( dateTo.compareTo( getDateObject( sdf.format( new Date() ) ) ) ) < 0 )
							{
								if( wfStatus.equalsIgnoreCase("S") )
								{
									BaseLogger.log("3",null,null,"RetailSchemePreSignSave IN IF ...end");
									errString = getErrorString("payout_date", "RETSCHPAYO", userId);
									break;
								}
							}
							else
							{
								BaseLogger.log("3",null,null,"RetailSchemePreSignSave payout_date wfStatus s2.after(s1) ELSE");
							}
						}
					}
					else if( childNodeName.equalsIgnoreCase("last_claim_date") )
					{   
						String lastClaimDate = checkNull(genericUtility.getColumnValue("last_claim_date", dom)).trim();
						BaseLogger.log("3",null,null,"RetailSchemePreSignSave lastClaimDate  = "+lastClaimDate );

						String wfStatus = checkNull(genericUtility.getColumnValue("wf_status", dom)).trim();
						BaseLogger.log("3",null,null,"RetailSchemePreSignSave wfStatus = "+wfStatus);

						if( lastClaimDate == null || lastClaimDate.length() <= 0 ) 
						{
							errString = getErrorString("last_claim_date", "RETSCHLCLM", userId);
							break;
						}
						else
						{
							BaseLogger.log("3",null,null,"RetailSchemePreSignSave IN ELSE [last_claim_date] lastClaimDate  = "+lastClaimDate );

							SimpleDateFormat sdf=new SimpleDateFormat(genericUtility.getApplDateFormat());
							//SimpleDateFormat sdf1=new SimpleDateFormat(genericUtility.getDBDateFormat());

							Date dateTo = sdf.parse( lastClaimDate );
							BaseLogger.log("3",null,null,"RetailSchemePreSignSave else dateTo = "+dateTo);

							//Timestamp s1 = Timestamp.valueOf(sdf1.format(dateTo)+" 00:00:00.0");
							//Timestamp s2 = new Timestamp(System.currentTimeMillis());
							BaseLogger.log("3",null,null,"RetailSchemePreSignSave else last_claim_date dateTo= "+dateTo);

							//if( s2.after(s1) ) 
							if ( ( dateTo.compareTo( getDateObject( sdf.format( new Date() ) ) ) ) < 0 )
							{
								if( wfStatus.equalsIgnoreCase("S") )
								{
									BaseLogger.log("3",null,null,"RetailSchemePreSignSave IN IF ...end");
									errString = getErrorString("last_claim_date", "RETSCHLCLP", userId);
									break;
								}
							}
							else
							{
								BaseLogger.log("3",null,null,"RetailSchemePreSignSave last_claim_date wfStatus s2.after(s1) ELSE");
							}
						}
					}
				}
				valueXmlString.append("</Detail1>");	
				break;	
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			errString = e.getMessage();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(rs != null) 
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null) 
				{
					pstmt.close();
					pstmt = null;
				}
				if(conn != null)
				{
					conn.close();
					conn = null;
				}
			} 
			catch(Exception d)
			{
				d.printStackTrace();
				throw new ITMException(d);
			}
		}
		return errString;
	}

	private String checkNull(String input) 
	{
		return input == null ? "" : input.trim();
	}
}