package ibase.webService;

import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import org.json.JSONException;

import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.wsfa.masters.SellsStock;
import ibase.webitm.utility.wsfa.ExceptionUtility;

@Path("/SellStockService")
public class SellAndStockService
{
	//private UserInfoBean  userInfo = null;
	@GET
	@Path("/itemChange/{columnName}/{columnValue}/{paramValue}")
	@Produces(MediaType.APPLICATION_JSON)
	public Response itemChange( @PathParam("columnName") String columnName, @PathParam("columnValue") String columnValue, @PathParam("paramValue") String paramValue, @Context HttpServletRequest request )
	{
		BaseLogger.log( "2", null, null, "In itemChanged :: columName ["+ columnName +"] columnValue ["+ columnValue +"] paramValue ["+ paramValue +"]" );
		String resultStr = "";
		try
		{
			UserInfoBean userInfo = getUserInfo( request );
			if( userInfo != null )
			{
				SellsStock sellStk = new SellsStock();
				resultStr = sellStk.getFirstFormItemChange(columnName, columnValue,paramValue, userInfo);
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
			resultStr = new ExceptionUtility().handleException( e ).toString();
		}
		return Response.status(200).entity( resultStr ).build();
	}
	
	@POST
	@Path("/itemChange")
	@Produces(MediaType.APPLICATION_JSON)
	public Response itemChangeClient( String data, @Context HttpServletRequest request )
	{
		BaseLogger.log( "2", null, null, "In itemChangeClient :: data ["+ data +"]" );
		String resultStr = "";
		try
		{
			UserInfoBean userInfo = getUserInfo( request );
			if( userInfo != null )
			{
				data = E12GenericUtility.checkNull( data );
				if ( data.length() > 0 )
				{
					org.json.JSONObject jsonData = new org.json.JSONObject(data);
					System.out.println( "itemChangeClient :: jsonData ["+ jsonData.toString() +"]" );
					String columnName = "", columnValue = "", paramValue = "";
					columnName = jsonData.getString("columnName");
					columnValue = jsonData.getString("columnValue");
					paramValue = jsonData.getString("paramValue");

					SellsStock sellStk = new SellsStock();
					resultStr = sellStk.getFirstFormItemChange(columnName, columnValue,paramValue, userInfo);
				}
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
			resultStr = new ExceptionUtility().handleException( e ).toString();
		}
		return Response.status(200).entity( resultStr ).build();
	}

	@GET
	@Path("/itemChange/{columnName}/{columnValue}")
	@Produces(MediaType.APPLICATION_JSON)
	public Response itemChange( @PathParam("columnName") String columnName, @PathParam("columnValue") String columnValue, @Context HttpServletRequest request )
	{
		BaseLogger.log( "2", null, null, "In itemChange :: columName ["+ columnName +"] columnValue ["+ columnValue +"]" );
		String resultStr = "";
		try
		{
			UserInfoBean userInfo = getUserInfo( request );
			if( userInfo != null )
			{
				SellsStock sellStk = new SellsStock();
				resultStr = sellStk.getFirstFormItemChange( columnName, columnValue, "", userInfo );
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
			resultStr = new ExceptionUtility().handleException( e ).toString();
		}
		return Response.status(200).entity( resultStr ).build();
	}

	@POST
	@Path("/getSellsStockData")
	@Produces({ "application/json" })
	@Consumes({ "application/json" })
	public Response getSellsStockData( String data, @Context HttpServletRequest request )
	{
		BaseLogger.log( "2", null, null, "Inside getSellsStockData :: data : ["+ data +"]" );
		String resultStr = "";
		try
		{
			UserInfoBean userInfo = getUserInfo( request );
			if( userInfo != null )
			{
				SellsStock sellStk = new SellsStock();
				//resultStr = sellStk.getSellsStockData(stanCodeHq,scCode,prdCode,fromDate,toDate,forceSave,userInfo);
				resultStr = sellStk.getSellsStockData(data,userInfo);
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
			resultStr = new ExceptionUtility().handleException( e ).toString();
		}
		return Response.status(200).entity( resultStr ).build();
	}

	@POST
	@Path("/sellDone")
	@Produces({ "application/json" })
	@Consumes({ "application/json" })
	public Response sellDone( String data, @Context HttpServletRequest request ) throws JSONException
	{
		BaseLogger.log( "2", null, null, "In sellDone :: data ["+ data +"]" );
		String resultStr = "";
		
		try
		{
			UserInfoBean userInfo = getUserInfo( request );
			if ( userInfo != null )
			{
				SellsStock sell = new SellsStock();
				resultStr = sell.insertStkInOutData(data, userInfo);
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
			resultStr = new ExceptionUtility().handleException( e ).toString();
		}

		return Response.status(200).entity( resultStr ).build();
	}

	@GET
	@Path("/getSellStockValidate/{columnName}/{columnValue}")
	@Produces(MediaType.APPLICATION_JSON)
	public Response getSellStockValidate( @PathParam("columnName") String columnName, @PathParam("columnValue") String columnValue, @Context HttpServletRequest request )
	{
		BaseLogger.log( "2", null, null, "In getSellStockValidate :: columName ["+ columnName +"] columnValue ["+ columnValue +"]" );
		String resultStr = "";
		try
		{
			UserInfoBean userInfo = getUserInfo( request );
			if( userInfo != null )
			{
				SellsStock sellStk = new SellsStock();
				resultStr = sellStk.getFirstFormValidation( columnName, columnValue, userInfo );
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
			resultStr = new ExceptionUtility().handleException( e ).toString();
		}

		return Response.status(200).entity( resultStr ).build();
	}
	
	@POST
	@Path("/getSellStockValidate")
	@Produces(MediaType.APPLICATION_JSON)
	public Response getSellStockValidateClient( String data, @Context HttpServletRequest request )
	{
		BaseLogger.log( "2", null, null, "In getSellStockValidateClient :: data ["+ data +"]" );
		String resultStr = "";
		try
		{
			UserInfoBean userInfo = getUserInfo( request );
			if( userInfo != null )
			{
				data = E12GenericUtility.checkNull( data );
				if ( data.length() > 0 )
				{
					org.json.JSONObject jsonData = new org.json.JSONObject(data);
					System.out.println( "itemChangeClient :: jsonData ["+ jsonData.toString() +"]" );
					String columnName = "", columnValue = "";
					columnName = jsonData.getString("columnName");
					columnValue = jsonData.getString("columnValue");
					
					SellsStock sellStk = new SellsStock();
					resultStr = sellStk.getFirstFormValidation( columnName, columnValue, userInfo );
				}
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
			resultStr = new ExceptionUtility().handleException( e ).toString();
		}

		return Response.status(200).entity( resultStr ).build();
	}

	@GET
	@Path("/itmDefault")
	@Produces(MediaType.APPLICATION_JSON)
	public Response itmDefault( @Context HttpServletRequest request )
	{
		BaseLogger.log( "2", null, null, "In itmDefault" );
		String resultStr = "";
		try
		{
			UserInfoBean userInfo = getUserInfo( request );
			if( userInfo != null )
			{
				SellsStock stock = new SellsStock();
				resultStr = stock.itmDefault(userInfo);
			}
			BaseLogger.log( "3", null, null, "resultStr...................["+ resultStr +"]" );
		}
		catch (Exception e)
		{
			e.printStackTrace();
			resultStr = new ExceptionUtility().handleException( e ).toString();
		}
		return Response.status(200).entity( resultStr ).build();
	}

	/*@GET
	@Path("/getSellsPlanData/{scCode}/{prdCode}/{checkData}")
	@Produces(MediaType.APPLICATION_JSON)*/

	@POST
	@Path("/getSellsPlanData")
	@Produces({ "application/json" })
	@Consumes({ "application/json" })
	public Response getSellsPlanData( String data, @Context HttpServletRequest request )
	{
		BaseLogger.log( "2", null, null, "In getSellsPlanData :: data ["+ data +"]" );
		String resultStr = "";
		try
		{
			UserInfoBean userInfo = getUserInfo( request );
			if( userInfo != null )
			{
				SellsStock stock = new SellsStock();
				resultStr = stock.getSellsPlanData(data, userInfo);
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
			resultStr = new ExceptionUtility().handleException( e ).toString();
		}
		return Response.status(200).entity( resultStr ).build();
	}

	@GET
	@Path("/sellPlanningDefault")
	@Produces(MediaType.APPLICATION_JSON)
	public Response sellPlanningDefault( @Context HttpServletRequest request )
	{
		BaseLogger.log( "2", null, null, "Inside sellPlanningDefault" );
		String resultStr = "";
		try
		{
			UserInfoBean userInfo = getUserInfo( request );
			if( userInfo != null )
			{
				SellsStock stock = new SellsStock();
				resultStr = stock.itmDefaultSellsPlanning(userInfo);
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
			resultStr = new ExceptionUtility().handleException( e ).toString();
		}
		return Response.status(200).entity( resultStr ).build();
	}


	@POST
	@Path("/planningDone")
	@Produces({ "application/json" })
	@Consumes({ "application/json" })
	public Response planningDone( String data, @Context HttpServletRequest request ) throws Exception{

		BaseLogger.log( "2", null, null, "In planningDone :: data ["+ data +"]" );
		String resultStr = "";
		try
		{
			UserInfoBean userInfo = getUserInfo( request );
			if( userInfo != null )
			{
				SellsStock sellsStock = new SellsStock();
				resultStr = sellsStock.insertPlanningData(data, userInfo);
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
			resultStr = new ExceptionUtility().handleException( e ).toString();
		}
		return Response.status(200).entity( resultStr ).build();
	}

	//Added by Prasad on 26/01/2020 [to get sell performance related data] START

	@POST
	@Path("/getSellPerformance")
	@Produces({ "application/json" })
	@Consumes({ "application/json" })
	public Response getSellPerformance( String data, @Context HttpServletRequest request )
	{
		BaseLogger.log( "2", null, null, "In getSellPerformance :: data ["+ data +"]" );
		String resultStr = "";
		try
		{
			UserInfoBean userInfo = getUserInfo( request );
			if( userInfo != null )
			{
				SellsStock stock = new SellsStock();
				resultStr = stock.getSellPerformance( data, userInfo );
			}
			BaseLogger.log( "3", null, null, "resultStr...................["+ resultStr +"]" );
		}
		catch (Exception e)
		{
			e.printStackTrace();
			resultStr = new ExceptionUtility().handleException( e ).toString();
		}
		return Response.status(200).entity( resultStr ).build();
	}
	//Added by Prasad on 26/01/2020 [to get sell performance related data] END


	@POST
	@Path("/sentBackPlan")
	@Produces({ "application/json" })
	@Consumes({ "application/json" })
	public Response sentBackPlan( String data, @Context HttpServletRequest request ) throws JSONException
	{
		BaseLogger.log( "2", null, null, "In sentBackPlan :: data ["+ data +"]" );
		String resultStr = "";
		try
		{
			UserInfoBean userInfo = getUserInfo( request );
			if( userInfo != null )
			{
				SellsStock sellsStock = new SellsStock();
				resultStr = sellsStock.updatePlanningData( data, userInfo );
			}
			BaseLogger.log( "3", null, null, "resultStr...................["+ resultStr +"]" );
		}
		catch (Exception e)
		{
			e.printStackTrace();
			resultStr = new ExceptionUtility().handleException( e ).toString();
		}
		return Response.status(200).entity( resultStr ).build();
	}
	
	private UserInfoBean getUserInfo( HttpServletRequest request ) throws Exception
	{
		UserInfoBean userInfo = ( UserInfoBean ) request.getSession().getAttribute( "USER_INFO" );
		BaseLogger.log( "3", userInfo, null, "USER_INFO : [" + userInfo + "]" );
		if ( userInfo == null )
		{
			throw new Exception("SESSION_EXPIRED");
		}
		return userInfo;
	}
}
