/*
 * Decompiled with CFR 0.152.
 */
package ibase.bankIntegration.unsHsbc;

import ibase.bankIntegration.CommonMethods;
import ibase.ejb.CommonDBAccessEJB;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.utility.ITMException;
import java.io.File;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import javax.json.JsonObject;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class UNSHSBC
extends ActionHandlerEJB {
    UserInfoBean userInfoGlobal = new UserInfoBean();
    CommonDBAccessEJB commonDBAccessEJB = new CommonDBAccessEJB();
    ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
    E12GenericUtility e12GenericUtility = new E12GenericUtility();
    DBAccessEJB dbAccessEJB = new DBAccessEJB();
    DBAccessEJB dbAccess = new DBAccessEJB();

    public String actionHandler(String tranID, String xtraParam, Connection conn) throws RemoteException, ITMException {
        String result = "";
        BaseLogger.log((String)"3", null, null, (Object)("Inside UNSHSBC actionHandler tranID::27-May[" + tranID + "] xtraParam [" + xtraParam + "]"));
        String userCode = this.e12GenericUtility.getValueFromXTRA_PARAMS(xtraParam, "loginCode");
        BaseLogger.log((String)"3", null, null, (Object)("Inside UNSHSBCXML actionHandler userCode [" + userCode + "]"));
        Statement statement = null;
        ResultSet resultSet = null;
        String bankTransferID = "";
        String tranType = "";
        try {
            UserInfoBean userInfo = this.commonDBAccessEJB.createUserInfo(userCode);
            String netAmt = "";
            netAmt = this.dbAccessEJB.getDBColumnValue("MISC_PAYMENT", "NET_AMT", "TRAN_ID  = '" + tranID + "'", userInfo.getTransDB());
            BaseLogger.log((String)"3", null, null, (Object)("Value of netAmt ... [" + netAmt + "]"));
            bankTransferID = this.dbAccessEJB.getDBColumnValue("MISC_PAYMENT", "BANK_TRANSFER_ID", "TRAN_ID  = '" + tranID + "'", userInfo.getTransDB());
            BaseLogger.log((String)"3", null, null, (Object)("Value of BANK_TRANSFER_ID ... [" + bankTransferID + "]"));
            if (netAmt.equalsIgnoreCase("0")) {
                String string = result = "<ROOT><STATUS><![CDATA[1]]></STATUS><RESULT><![CDATA[Net Amount is 0.]]></RESULT></ROOT>";
                return string;
            }
            String generateBankSpecificXMLResult = "";
            if (bankTransferID != null && !E12GenericUtility.checkNull((String)bankTransferID).equals("")) {
                BaseLogger.log((String)"3", null, null, (Object)"UNSHSBC.actionHandler Payment already processed");
                String string = result = "<ROOT><STATUS><![CDATA[1]]></STATUS><RESULT><![CDATA[Payment already has been processed.]]></RESULT></ROOT>";
                return string;
            }
            generateBankSpecificXMLResult = this.generateBankSpecificXML(userInfo, E12GenericUtility.checkNull((String)tranID.trim()));
            BaseLogger.log((String)"3", null, null, (Object)("UNSHSBC.actionHandler Result [" + generateBankSpecificXMLResult + "]"));
            try {
                result = generateBankSpecificXMLResult.equals("XML modified successfully!") ? "<ROOT><STATUS><![CDATA[1]]></STATUS><RESULT><![CDATA[Transaction specific XML generated.]]></RESULT></ROOT>" : "<ROOT><STATUS><![CDATA[1]]></STATUS><RESULT><![CDATA[Error in generating transaction specific XML.]]></RESULT></ROOT>";
            }
            catch (Exception e) {
                BaseLogger.log((String)"3", null, null, (Object)("Exception. [" + E12GenericUtility.getStackTrace((Exception)e) + "]"));
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }

    public String generateBankSpecificXML(UserInfoBean userInfo, String tranID) throws ITMException {
        String supplierAddress;
        String formattedDate;
        String sundryType;
        String result;
        block11: {
            block10: {
                result = "";
                String tranType = "";
                try {
                    System.out.println("Inside gsb generateXMl() 27-May-25 Tuesday:::: [ " + tranID + "]");
                    sundryType = this.dbAccessEJB.getDBColumnValue("MISC_PAYMENT", "SUNDRY_TYPE", "TRAN_ID  = '" + tranID + "'", userInfo.getTransDB());
                    BaseLogger.log((String)"3", null, null, (Object)("Inside actionHandler generateXML.. sundryType[ " + sundryType + "]"));
                    tranType = this.dbAccessEJB.getDBColumnValue("MISC_PAYMENT", "TRAN_TYPE", "TRAN_ID  = '" + tranID + "'", userInfo.getTransDB());
                    BaseLogger.log((String)"3", null, null, (Object)("Value of tranType[ " + tranType + "]"));
                    if (!"C".equals(tranType.trim())) break block10;
                    BaseLogger.log((String)"3", null, null, (Object)"Inside the block Test");
                    return "Payment Type is Cash. XML will not be generated";
                }
                catch (Exception e) {
                    BaseLogger.log((String)"3", null, null, (Object)("Exception. [" + E12GenericUtility.getStackTrace((Exception)e) + "]"));
                    throw new ITMException(e);
                }
            }
            if (sundryType != null && !sundryType.trim().isEmpty()) break block11;
            return "Sundry Type is invalid";
        }
        sundryType = sundryType.trim();
        HashMap<Object, Object> unsHsbcValuesMap = new HashMap();
        if (!sundryType.equalsIgnoreCase("E") && !sundryType.equalsIgnoreCase("S")) {
            result = "Sundry Type is other than Employee or Supplier";
            System.out.println(String.valueOf(result) + ",..." + sundryType);
            return result;
        }
        unsHsbcValuesMap = this.getUnsHsbcDetails(tranID, sundryType, userInfo);
        System.out.println("unsHsbcValuesMap:::" + unsHsbcValuesMap);
        String netAmt = "";
        netAmt = this.dbAccessEJB.getDBColumnValue("MISC_PAYMENT", "NET_AMT", "TRAN_ID  = '" + tranID + "'", userInfo.getTransDB());
        BaseLogger.log((String)"3", null, null, (Object)("Value of netAmt ... [" + netAmt + "]"));
        if (netAmt.equalsIgnoreCase("0")) {
            result = "<ROOT><STATUS><![CDATA[1]]></STATUS><RESULT><![CDATA[Net Amount is 0.]]></RESULT></ROOT>";
            return result;
        }
        String bankCode = E12GenericUtility.checkNull((String)E12GenericUtility.checkNull((String)unsHsbcValuesMap.get("BANK_CODE").toString()));
        BaseLogger.log((String)"3", null, null, (Object)("Inside UNSHSBCXML generateXML bankCode [" + bankCode + "]"));
        String payIntArgs = this.dbAccessEJB.getDBColumnValue("BANK", "PAY_INT_ARGS", "BANK_CODE  = '" + bankCode + "'", userInfo.getTransDB());
        BaseLogger.log((String)"3", null, null, (Object)("Inside actionHandler generateXML.. payIntArgs[ " + payIntArgs + "]"));
        JsonObject payIntArgsJSON = CommonMethods.parseJsonString(payIntArgs);
        String bankIntegrationFolder = CommonMethods.getValueFromJson(payIntArgsJSON, "bank_specific_folder");
        BaseLogger.log((String)"3", null, null, (Object)("Inside actionHandler generateXML.. bankIntegrationXMLFolder[" + bankIntegrationFolder + "]"));
        bankIntegrationFolder = String.valueOf(bankIntegrationFolder) + File.separator + "XML_files";
        String bankIntegrationXMLTemplateFileName = CommonMethods.getValueFromJson(payIntArgsJSON, "bank_specific_xml_template_file_name");
        BaseLogger.log((String)"3", null, null, (Object)("Inside actionHandler generateXML.. bankIntegrationXMLTemplateFileName[" + bankIntegrationXMLTemplateFileName + "]"));
        String sourceFilePath = String.valueOf(bankIntegrationFolder) + File.separator + bankIntegrationXMLTemplateFileName;
        BaseLogger.log((String)"3", null, null, (Object)("Inside actionHandler generateXML.. sourceFilePath[" + sourceFilePath + "]"));
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(sourceFilePath);
        String modifiedFileName = CommonMethods.generateBankXMLName(tranID);
        String destinationFilePath = String.valueOf(bankIntegrationFolder) + File.separator + modifiedFileName + ".xml";
        System.out.println("destinationFilePath [" + destinationFilePath + "]");
        LocalDate currentDate = LocalDate.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String refDate = formattedDate = currentDate.format(formatter);
        System.out.println("refDate [" + refDate + "]");
        String emailAddr = unsHsbcValuesMap.get("EMAIL_ADDR").toString();
        if (E12GenericUtility.checkNull((String)emailAddr).equalsIgnoreCase("")) {
            emailAddr = "test@gmail.com";
        }
        if ((supplierAddress = unsHsbcValuesMap.get("SUPPLIER_ADDRESS").toString()).length() > 16) {
            supplierAddress = supplierAddress.substring(0, 16);
        }
        if (doc != null) {
            Element root = doc.getDocumentElement();
            CommonMethods.modifyElementValue(root, "GrpHdr", "MsgId", unsHsbcValuesMap.get("TRAN_ID").toString());
            CommonMethods.modifyElementValue(root, "GrpHdr", "CreDtTm", UNSHSBC.getCurrentTimeStamp());
            CommonMethods.modifyElementValue(root, "Authstn", "Cd", "ILEV");
            CommonMethods.modifyElementValue(root, "GrpHdr", "NbOfTxs", "1");
            CommonMethods.modifyElementValue(root, "GrpHdr", "CtrlSum", unsHsbcValuesMap.get("NET_AMT").toString());
            CommonMethods.modifyElementValue(root, "InitgPty", "Nm", "UNIVERSAL NUTRISCIENCE PVT. LTD");
            CommonMethods.modifyElementValue(root, "PmtInf", "PmtInfId", unsHsbcValuesMap.get("TRAN_ID").toString());
            CommonMethods.modifyElementValue(root, "PmtInf", "PmtMtd", "TRF");
            CommonMethods.modifyElementValue(root, "PmtInf", "NbOfTxs", "1");
            CommonMethods.modifyElementValue(root, "PmtInf", "CtrlSum", unsHsbcValuesMap.get("NET_AMT").toString());
            CommonMethods.modifyElementValue(root, "PmtInf", "ReqdExctnDt", refDate);
            CommonMethods.modifyElementValue(root, "Dbtr", "Nm", "UNIVERSAL NUTRISCIENCE PVT. LTD");
            CommonMethods.modifyElementValue(root, "PstlAdr", "StrtNm", "2nd Floor,Fleet House, Andheri - Kurla Rd, Gamdevi, Marol, Naka", 0);
            CommonMethods.modifyElementValue(root, "PstlAdr", "PstCd", "400059", 0);
            CommonMethods.modifyElementValue(root, "PstlAdr", "TwnNm", "Mumbai", 0);
            CommonMethods.modifyElementValue(root, "PstlAdr", "CtrySubDvsn", "Maharashtra", 0);
            CommonMethods.modifyElementValue(root, "PstlAdr", "Ctry", "IN", 0);
            CommonMethods.modifyElementValue(root, "DbtrAcct", "Ccy", "INR");
            CommonMethods.modifyElementValue(root, "PstlAdr", "Ctry", "IN");
            CommonMethods.modifyElementValue(root, "PmtId", "InstrId", unsHsbcValuesMap.get("TRAN_ID").toString());
            CommonMethods.modifyElementValue(root, "PmtId", "EndToEndId", unsHsbcValuesMap.get("TRAN_ID").toString());
            CommonMethods.modifyElementValue(root, "SvcLvl", "Cd", "URNS");
            CommonMethods.modifyElementValue(root, "CtgyPurp", "Cd", "SUPP");
            CommonMethods.modifyElementValue(root, "Amt", "InstdAmt", unsHsbcValuesMap.get("NET_AMT").toString());
            CommonMethods.modifyElementValue(root, "FinInstnId", "Nm", unsHsbcValuesMap.get("BANK_CODE__BEN").toString());
            CommonMethods.modifyElementValue(root, "PstlAdr", "Ctry", "IN", 1);
            CommonMethods.modifyElementValue(root, "Cdtr", "Nm", unsHsbcValuesMap.get("CHQ_NAME").toString());
            CommonMethods.modifyElementValue(root, "Cdtr", "StrtNm", supplierAddress, 0);
            CommonMethods.modifyElementValue(root, "PstlAdr", "Ctry", "IN", 1);
            CommonMethods.modifyElementValue(root, "CdtrAcct", "Nm", unsHsbcValuesMap.get("CHQ_NAME").toString());
            CommonMethods.modifyIdValue(root, unsHsbcValuesMap.get("BANK_ACCT_NO__BEN").toString(), 0);
            CommonMethods.modifyCdtrAgtValues(root, unsHsbcValuesMap.get("IFSC").toString(), unsHsbcValuesMap.get("BANK_NAME").toString());
            CommonMethods.modifyElementValue(root, "RltdRmtInf", "RmtLctnMtd", "EMAL");
            CommonMethods.modifyElementValue(root, "RltdRmtInf", "RmtLctnElctrncAdr", emailAddr);
            HashMap<String, String> billNoAndBillDateRes = CommonMethods.getBillNoAndBillDate(tranID, userInfo);
            String billNo = billNoAndBillDateRes.get("BILL_NO");
            String billlDate = billNoAndBillDateRes.get("BILL_DATE");
            CommonMethods.modifyElementValue(root, "RfrdDocInf", "Nb", billNo);
            CommonMethods.modifyElementValue(root, "RfrdDocInf", "RltdDt", billlDate);
            CommonMethods.modifyElementValue(root, "CdOrPrtry", "Prtry", "/AMNT/" + unsHsbcValuesMap.get("NET_AMT").toString());
            CommonMethods.modifyElementValue(root, "CdtrRefInf", "Ref", "/TDSA/" + unsHsbcValuesMap.get("NET_AMT").toString());
            CommonMethods.modifyElementValue(root, "Strd", "AddtlRmtInf", "/NAMT/" + unsHsbcValuesMap.get("NET_AMT").toString());
            CommonMethods.saveChanges(doc, destinationFilePath);
            result = "XML modified successfully!";
            System.out.println(result);
        } else {
            result = "Failed to read XML file.";
            System.out.println(result);
        }
        return result;
    }

    private HashMap<String, Object> getUnsHsbcDetails(String tranID, String sundryType, UserInfoBean userInfo) throws SQLException {
        HashMap<String, Object> unshsbcDetails = new HashMap<String, Object>();
        System.out.println("Inside getUnsHsbcDetails tranID: [" + tranID + "]");
        System.out.println("Inside getUnsHsbcDetails : [" + userInfo + "]");
        Connection connection = null;
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                ConnDriver connDriver = new ConnDriver();
                connection = connDriver.getConnectDB(userInfo.getTransDB());
                String unsHsbcSQL = "SELECT\n    PAY.TRAN_ID,\n    PAY.REF_DATE,\n    PAY.NET_AMT,\n    PAY.SUNDRY_CODE,\n    PAY.SUNDRY_TYPE,\n    PAY.BANK_CODE,\n    PAYBANK.AC_NO,    \n    SUPPBANK.BANK_NAME,\n    S.ADDR1\n    || ' '\n    || S.ADDR2\n    || ' '\n    || S.ADDR3\n    || ' '\n    || S.CITY\n    || ' '\n    || S.STATE_CODE AS SUPPLIER_ADDRESS,\n    S.CHQ_NAME,\n    S.EMAIL_ADDR,\n    SB.BANK_ACCT_NO__BEN,\n    SB.BANK_CODE__BEN,    \n    SB.IFSC\nFROM\n    MISC_PAYMENT  PAY,\n    MISC_PAYDET   PAYDET,\n    BANK          PAYBANK,\n    SUPPLIER      S,\n    SUPPLIER_BANK SB,\n    BANK SUPPBANK\nWHERE\n        PAY.TRAN_ID = ?\n    AND SB.ACTIVE_YN = 'Y'\n    AND SB.CONFIRMED = 'Y'\n    AND PAY.TRAN_ID = PAYDET.TRAN_ID\n    AND PAY.BANK_CODE = PAYBANK.BANK_CODE\n    AND PAY.SUNDRY_CODE = S.SUPP_CODE\n    AND S.SUPP_CODE = SB.SUPP_CODE\n    AND SB.BANK_CODE__BEN = SUPPBANK.BANK_CODE\nORDER BY\n    SB.VALID_UPTO DESC";
                if (sundryType.equalsIgnoreCase("E")) {
                    unsHsbcSQL = "SELECT DISTINCT\n    PAY.TRAN_ID,\n    PAY.REF_DATE,\n    PAY.NET_AMT,\n    PAY.SUNDRY_CODE,\n    PAY.SUNDRY_TYPE,\n    PAY.BANK_CODE,\n    PAYBANK.AC_NO,\n    EMPBANK.BANK_NAME,\n    EMP.CUR_ADD1\n    || ' '\n    || EMP.CUR_ADD2\n    || ' '\n    || EMP.CUR_ADD3\n    || ' '\n    || EMP.CUR_STATE AS SUPPLIER_ADDRESS,\n    EMP.EMP_FNAME\n    || ' '\n    || EMP.EMP_MNAME\n    || ' '\n    || EMP.EMP_LNAME AS CHQ_NAME,\n    EMP.EMAIL_ID_OFF as EMAIL_ADDR,\n    EMP.BANK_ACCT AS BANK_ACCT_NO__BEN,\n    EMP.BANK_CODE AS BANK_CODE__BEN,\n    EMP.IFSC\nFROM\n    MISC_PAYMENT PAY,\n    MISC_PAYDET  PAYDET,\n    BANK         PAYBANK,\n    EMPLOYEE     EMP,\n    BANK         EMPBANK\n    \nWHERE\n        PAY.TRAN_ID = ?\n    AND PAY.TRAN_ID = PAYDET.TRAN_ID\n    AND PAY.BANK_CODE = PAYBANK.BANK_CODE\n    AND PAY.SUNDRY_CODE = EMP.EMP_CODE\n    AND EMPBANK.BANK_CODE = EMP.BANK_CODE";
                }
                pstmt = connection.prepareStatement(unsHsbcSQL);
                pstmt.setString(1, tranID);
                rs = pstmt.executeQuery();
                ResultSetMetaData metaData = rs.getMetaData();
                int columnCount = metaData.getColumnCount();
                while (rs.next()) {
                    int i = 1;
                    while (i <= columnCount) {
                        String columnName = metaData.getColumnName(i);
                        String columnValue = rs.getString(i);
                        columnValue = columnValue != null ? columnValue.trim() : " ";
                        unshsbcDetails.put(columnName, columnValue);
                        ++i;
                    }
                    System.out.println("Row Data unshsbcDetails Hashmap: " + unshsbcDetails);
                }
            }
            catch (Exception exp) {
                exp.printStackTrace();
                if (connection != null) {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                }
            }
        }
        finally {
            if (connection != null) {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (connection != null) {
                    connection.close();
                    connection = null;
                }
            }
        }
        return unshsbcDetails;
    }

    public static String getCurrentTimeStamp() {
        LocalDateTime currentDateTime = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss");
        String formattedDateTime = currentDateTime.format(formatter);
        return formattedDateTime;
    }
}

