/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.utility;

import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.JMSFollowupActions;
import ibase.webitm.utility.JMSLogger;
import ibase.webitm.utility.JMSUpdateDirtyDataModels;
import ibase.webitm.utility.JMSWorklFlowInvoker;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class JMSReceiver
implements MessageListener {
    public static final String JMS_USERNAME = CommonConstants.JMS_USERNAME;
    public static final String JMS_PASSWORD = CommonConstants.JMS_PASSWORD;
    public static final String JMS_CONNECTION_FACTORY = CommonConstants.JMS_CONNECTION_FACTORY;
    public static final String JMS_QUEUE = CommonConstants.JMS_QUEUE;
    private QueueConnectionFactory qconFactory;
    private QueueConnection qcon;
    private QueueSession qsession;
    private QueueReceiver qReceiver;
    private Queue queue;
    private boolean quit = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JMSReceiver() throws Exception {
        JMSLogger.log("3", null, null, "JMS Ready To Receive Messages");
        this.init();
        JMSReceiver jMSReceiver = this;
        synchronized (jMSReceiver) {
            while (!this.quit) {
                try {
                    this.wait();
                }
                catch (InterruptedException ie) {
                    JMSLogger.log("3", null, null, "JMSReceiver.JMSReceiver() InterruptedException:[ " + ie + "]");
                    ie.printStackTrace();
                }
            }
        }
        this.close();
    }

    public void init() throws NamingException, JMSException {
        try {
            JMSLogger.log("3", null, null, "JMSReceiver.init()");
            InitialContext ctx = new InitialContext();
            this.qconFactory = (QueueConnectionFactory)ctx.lookup(JMS_CONNECTION_FACTORY);
            this.qcon = this.qconFactory.createQueueConnection(JMS_USERNAME, JMS_PASSWORD);
            this.qsession = this.qcon.createQueueSession(false, 101);
            this.queue = (Queue)ctx.lookup(JMS_QUEUE);
            this.qReceiver = this.qsession.createReceiver(this.queue);
            this.qReceiver.setMessageListener((MessageListener)this);
            this.qcon.start();
        }
        catch (Exception e) {
            JMSLogger.log("3", null, null, "JMSReceiver.init() Exception:[" + E12GenericUtility.getStackTrace(e) + "]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void onMessage(Message message) {
        block38: {
            String recvdStatus = "S";
            E12GenericUtility genericUtility = new E12GenericUtility();
            String msgText = "";
            try {
                try {
                    JMSLogger.log("3", null, null, "JMSReceiver.onMessage() Message Type :[" + ((TextMessage)message).getJMSType() + "]");
                    if (message instanceof TextMessage) {
                        JMSLogger.log("3", null, null, "JMSReceiver.onMessage() TextMessage");
                        msgText = ((TextMessage)message).getText();
                    } else {
                        JMSLogger.log("3", null, null, "JMSReceiver.onMessage() Message");
                        msgText = message.toString();
                    }
                    if (msgText.equalsIgnoreCase("quit")) {
                        JMSLogger.log("3", null, null, "JMSReceiver.onMessage() quit receiver");
                        JMSReceiver jMSReceiver = this;
                        synchronized (jMSReceiver) {
                            this.quit = true;
                            this.notifyAll();
                            break block38;
                        }
                    }
                    if ("WORKFLOW".equals(((TextMessage)message).getJMSType())) {
                        JMSLogger.log("3", null, null, "JMSReceiver.onMessage() WORKFLOW start");
                        JMSWorklFlowInvoker jmsWorklFlowInvoker = new JMSWorklFlowInvoker();
                        jmsWorklFlowInvoker.invokeWorkFlow(msgText);
                        jmsWorklFlowInvoker = null;
                        message.acknowledge();
                        JMSLogger.log("3", null, null, "JMSReceiver.onMessage() WORKFLOW completed");
                    } else if ("UPDATE_DIRTY_DATAMODEL".equals(((TextMessage)message).getJMSType())) {
                        JMSLogger.log("3", null, null, "JMSReceiver.onMessage() UPDATE_DIRTY_DATAMODEL start");
                        JMSUpdateDirtyDataModels jmsUpdateDirtyDataModels = new JMSUpdateDirtyDataModels();
                        jmsUpdateDirtyDataModels.updateDirtyDataModels(msgText);
                        jmsUpdateDirtyDataModels = null;
                        message.acknowledge();
                        JMSLogger.log("3", null, null, "JMSReceiver.onMessage() UPDATE_DIRTY_DATAMODEL completed");
                    } else if ("FOLLOWUP_ACTIONS".equals(((TextMessage)message).getJMSType())) {
                        JMSLogger.log("3", null, null, "JMSReceiver.onMessage() FOLLOWUP_ACTIONS start111");
                        JMSFollowupActions jmsFollowupActions = new JMSFollowupActions();
                        jmsFollowupActions.executeFollowupactions(msgText);
                        jmsFollowupActions = null;
                        message.acknowledge();
                        JMSLogger.log("3", null, null, "JMSReceiver.onMessage() FOLLOWUP_ACTIONS completed111");
                    } else if ("FOLLOWUP_EDI_SERVICE".equals(((TextMessage)message).getJMSType())) {
                        JMSLogger.log("3", null, null, "JMSReceiver.onMessage() FOLLOWUP_EDI_SERVICE start");
                        JMSFollowupActions jmsFollowUpEDIService = new JMSFollowupActions();
                        jmsFollowUpEDIService.executeFollowUpEDIService(msgText);
                        jmsFollowUpEDIService = null;
                        message.acknowledge();
                        JMSLogger.log("3", null, null, "JMSReceiver.onMessage() FOLLOWUP_EDI_SERVICE completed");
                    }
                }
                catch (ITMException itmException) {
                    recvdStatus = "E";
                    JMSLogger.log("3", null, null, "JMSReceiver.onMessage() ITMException:[ " + itmException.getMessage() + "]");
                    try {
                        message.acknowledge();
                    }
                    catch (JMSException e) {
                        e.printStackTrace();
                    }
                    try {
                        JMSLogger.log("3", null, null, "JMSReceiver.onMessage() => inside finally block");
                        genericUtility.jmsLog(msgText, "", recvdStatus);
                    }
                    catch (Exception e) {
                        JMSLogger.log("3", null, null, "In JMSReceiver.onMessage() => Exception in finally block :[ " + E12GenericUtility.getStackTrace(e) + "]");
                    }
                }
                catch (JMSException jmse) {
                    recvdStatus = "E";
                    JMSLogger.log("3", null, null, "JMSReceiver.onMessage() JMSException:[ " + E12GenericUtility.getStackTrace((Exception)((Object)jmse)) + "]");
                    try {
                        message.acknowledge();
                    }
                    catch (JMSException e) {
                        e.printStackTrace();
                    }
                    try {
                        JMSLogger.log("3", null, null, "JMSReceiver.onMessage() => inside finally block");
                        genericUtility.jmsLog(msgText, "", recvdStatus);
                    }
                    catch (Exception e) {
                        JMSLogger.log("3", null, null, "In JMSReceiver.onMessage() => Exception in finally block :[ " + E12GenericUtility.getStackTrace(e) + "]");
                    }
                }
                catch (Exception e) {
                    recvdStatus = "E";
                    JMSLogger.log("3", null, null, "JMSReceiver.onMessage() Exception:[ " + E12GenericUtility.getStackTrace(e) + "]");
                    try {
                        message.acknowledge();
                    }
                    catch (JMSException e1) {
                        e1.printStackTrace();
                    }
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    try {
                        JMSLogger.log("3", null, null, "JMSReceiver.onMessage() => inside finally block");
                        genericUtility.jmsLog(msgText, "", recvdStatus);
                    }
                    catch (Exception e2) {
                        JMSLogger.log("3", null, null, "In JMSReceiver.onMessage() => Exception in finally block :[ " + E12GenericUtility.getStackTrace(e2) + "]");
                    }
                }
            }
            finally {
                try {
                    JMSLogger.log("3", null, null, "JMSReceiver.onMessage() => inside finally block");
                    genericUtility.jmsLog(msgText, "", recvdStatus);
                }
                catch (Exception e) {
                    JMSLogger.log("3", null, null, "In JMSReceiver.onMessage() => Exception in finally block :[ " + E12GenericUtility.getStackTrace(e) + "]");
                }
            }
        }
    }

    public void close() throws JMSException {
        JMSLogger.log("3", null, null, "JMSReceiver.close()");
        this.qReceiver.close();
        this.qsession.close();
        this.qcon.close();
    }
}

