/*
 * Decompiled with CFR 0.152.
 */
package ibase.webService;

import ibase.bean.ExtAuthAppAPIBean;
import ibase.utility.BaseLogger;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.E12DataModelComponent;
import ibase.webitm.utility.APIUtility;
import ibase.webitm.utility.E12ExtServiceUtility;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.RestAPIServiceUtility;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;

@Path(value="/data_model")
public class DataModelService {
    private UserInfoBean userInfo = null;

    public UserInfoBean getUserInfo() {
        return this.userInfo;
    }

    public void setUserInfo(UserInfoBean userInfo) {
        this.userInfo = userInfo;
    }

    @GET
    @Path(value="/{dataModelName}")
    @Produces(value={"application/json"})
    public Response getData(@Context HttpServletRequest request, @PathParam(value="dataModelName") String dataModelName) throws Exception {
        BaseLogger.log((String)"2", null, null, (Object)("dataModel: [" + dataModelName + "]"));
        UserInfoBean userInfo = (UserInfoBean)request.getSession().getAttribute("USER_INFO");
        String jsonString = "";
        if (userInfo != null) {
            jsonString = this.callDMDataJson(dataModelName, null, userInfo.toString());
        }
        return Response.status((int)200).entity((Object)jsonString).build();
    }

    @GET
    @Path(value="/{dataModelName}/{fieldValue}")
    @Produces(value={"application/json"})
    public Response getDataByParam(@Context HttpServletRequest request, @PathParam(value="dataModelName") String dataModelName, @PathParam(value="fieldValue") String fieldValue) throws Exception {
        BaseLogger.log((String)"2", null, null, (Object)("dataModelName: [" + dataModelName + "] fieldValue[" + fieldValue + "]"));
        String jsonString = "";
        UserInfoBean userInfo = (UserInfoBean)request.getSession().getAttribute("USER_INFO");
        if (userInfo != null) {
            jsonString = this.callDMDataJson(dataModelName, fieldValue, userInfo.toString());
        }
        return Response.status((int)200).entity((Object)jsonString).build();
    }

    public String callDMDataJson(String dataModelName, String fieldValue, String userInfo) throws Exception {
        BaseLogger.log((String)"2", null, null, (Object)"proteus-> getDMDataJson 2835");
        Class<?> classObj = null;
        String returnValue = null;
        Class[] paramSpec = new Class[]{Class.forName("java.lang.String"), Class.forName("java.lang.String"), Class.forName("java.lang.String")};
        Object[] params = new Object[]{dataModelName, fieldValue, userInfo};
        if (userInfo != null) {
            try {
                classObj = Class.forName("ibase.webitm.ejb.dis.DataModelComponent");
                E12DataModelComponent e12DmCom = (E12DataModelComponent)classObj.newInstance();
                Method metObj = classObj.getMethod("getDMDataJson", paramSpec);
                metObj.setAccessible(true);
                Object retVal = metObj.invoke((Object)e12DmCom, params);
                returnValue = retVal.toString();
                BaseLogger.log((String)"2", null, null, (Object)("returnValue [" + returnValue + "]"));
                e12DmCom = null;
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println("Exception :EventManagerEJB :callJB :\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        return returnValue;
    }

    @GET
    @Path(value="/datamodellist")
    @Produces(value={"application/json"})
    public Response getDataModelsList(@Context HttpServletRequest request) {
        BaseLogger.log((String)"3", null, null, (Object)"calling API for getting data models");
        UserInfoBean userInfo = (UserInfoBean)request.getSession().getAttribute("USER_INFO");
        if (userInfo != null) {
            E12DataModelComponent e12DataModelComp = new E12DataModelComponent();
            try {
                String jsonString = e12DataModelComp.prepareDataModeldetail(userInfo.getLoginCode(), userInfo.getProfileId(), "SFA", true, userInfo, "", "", "", "");
                return Response.status((int)200).entity((Object)jsonString).build();
            }
            catch (ITMException e) {
                e.printStackTrace();
                return Response.status((int)500).entity((Object)("Error: " + e.getMessage())).build();
            }
        }
        return Response.status((int)200).entity((Object)"Error: Unauthorized Access").build();
    }

    @GET
    @Path(value="/getJSON/{modelName}")
    @Produces(value={"application/json"})
    public Response getDataModels(@PathParam(value="modelName") String modelName, @Context HttpServletRequest request) {
        BaseLogger.log((String)"3", null, null, (Object)("calling API for getting data models==>" + modelName));
        return Response.status((int)200).entity((Object)this.getDataModels(request, modelName, null)).build();
    }

    @GET
    @Path(value="/getJSONData")
    @Produces(value={"application/json"})
    public Response getDataModels(@QueryParam(value="MODEL_NAME") String modelName, @Context HttpHeaders header, @Context HttpServletRequest request) {
        BaseLogger.log((String)"3", null, null, (Object)("calling API for getting data models==>" + modelName));
        E12ExtServiceUtility e12ExtServiceUtil = new E12ExtServiceUtility();
        RestAPIServiceUtility restapiserviceutility = new RestAPIServiceUtility();
        APIUtility apiUtility = new APIUtility();
        String result = "";
        String status = "error";
        UserInfoBean userInfo = null;
        try {
            String tokenId = e12ExtServiceUtil.getTokenFromHeaders(header);
            if (tokenId == null || tokenId.length() <= 0) {
                status = "Reject";
                result = "Unauthorised Access.";
                return Response.status((int)401).entity((Object)result).build();
            }
            String appId = apiUtility.getAppIdFromJWTToken(tokenId);
            BaseLogger.log((String)"3", null, null, (Object)("getDataModels() got App_id==>" + appId));
            if (appId == null || appId.length() <= 0) {
                status = "Reject";
                result = "Unauthorised Access.";
                return Response.status((int)401).entity((Object)result).build();
            }
            if (!appId.equals("FLUTTERAPP")) {
                BaseLogger.log((String)"3", null, null, (Object)"getDataModels() validating APPID ExtAuthAppAPIBean==>");
                ExtAuthAppAPIBean authAppAPIBean = restapiserviceutility.getCommonDBAccess().getAuthAppAPIDetails("getJSONData", appId);
                if (authAppAPIBean == null) {
                    status = "Reject";
                    result = "This service not available for this APPID";
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)result).build();
                }
                result = e12ExtServiceUtil.validateRequest(request, "JSON", tokenId, true, appId, "getJSONData");
                BaseLogger.log((String)"3", null, null, (Object)("getDataModels() Validate request result==>" + result));
                if (!"valid".equalsIgnoreCase(result)) {
                    return Response.status((int)401).entity((Object)result).build();
                }
            }
            if ((userInfo = apiUtility.createUserInfoFromJWTToken(tokenId)) == null) {
                status = "Reject";
                result = "User Not Allowed";
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)result).build();
            }
            if (apiUtility.checkDailyAPILimit(userInfo)) {
                status = "Reject";
                result = "Daily API call limit exceeded";
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)result).build();
            }
            e12ExtServiceUtil.writeAPICallLog("getReport ( VisionOBJService/getReport )", status, result, appId, request, userInfo);
            return Response.status((int)200).entity((Object)this.getDataModels(request, modelName, userInfo)).build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
    }

    public String getDataModels(HttpServletRequest request, String dataModel, UserInfoBean userInfo) {
        try {
            String scopeParameters = "";
            if (userInfo == null) {
                userInfo = (UserInfoBean)request.getSession().getAttribute("USER_INFO");
            }
            if (userInfo != null) {
                String format;
                Map<String, String> queryParams = this.getQueryParams(request);
                for (Map.Entry<String, String> entry : queryParams.entrySet()) {
                    String key = entry.getKey();
                    String value = entry.getValue();
                    scopeParameters = "&" + entry.getKey() + "=" + entry.getValue();
                    BaseLogger.log((String)"3", null, null, (Object)("Query parameter: " + key + " = " + value));
                }
                E12DataModelComponent e12DataModelComponent = new E12DataModelComponent();
                String applName = null;
                BaseLogger.log((String)"3", null, null, (Object)("calling API for getting applName==>" + (applName == null)));
                BaseLogger.log((String)"3", null, null, (Object)("calling API for getting applName scopeParameters==>" + scopeParameters));
                boolean isMobile = false;
                String dataModelName = dataModel;
                String responseFormat = format = "JSON";
                String dataModelToDownload = "";
                BaseLogger.log((String)"3", null, null, (Object)"calling prepareDataModelDetailsJSON for getting data models==>");
                String dataModelValue = e12DataModelComponent.prepareDataModelDetailsJSON(userInfo.getLoginCode(), userInfo.getProfileId(), applName, isMobile, userInfo, dataModelName, scopeParameters, responseFormat, dataModelToDownload);
                return dataModelValue;
            }
            return "Error:Unauthorized Access";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "Error:" + e.getMessage();
        }
    }

    private Map<String, String> getQueryParams(HttpServletRequest request) {
        Map parameterMap = request.getParameterMap();
        return parameterMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((String[])entry.getValue())[0]));
    }
}

