package ibase.webService;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import ibase.utility.BaseException;
import ibase.utility.BaseLogger;

@Path("/VisionOBJService")
public class VisionOBJService extends RestAPIService {

	
	@GET
	@Path("/getPageDetails")
	@Produces(MediaType.APPLICATION_JSON)
	public Response getExtServiceData(
		@QueryParam("APP_ID") String appId,
	    @QueryParam("OBJ_NAME") String objName,
	 //   @QueryParam("PAGE_NO") String pageNo,
	    @Context HttpServletRequest request,
	    @Context HttpHeaders header) throws BaseException, Exception {
	    
	    try {
	        VisionOBJServiceUtility visonOBJServiceUtility = new VisionOBJServiceUtility();
	        
	       //return Response.ok(visonOBJServiceUtility.getPageDetails(request,header,appId,objName,pageNo)).build();
	       return Response.ok(visonOBJServiceUtility.getPageDetails(request,header,appId,objName)).build();
	        //return visonOBJServiceUtility.getPageDetails(request,header,appId,objName,pageNo);
	    } catch (Exception e) {	       
	        e.printStackTrace();
	        return Response.serverError().build();
	    }
	}
	@GET
	@Path("/getListPageData")
	@Produces(MediaType.APPLICATION_JSON)
	public Response getListPageData(@QueryParam("APP_ID") String appId, @QueryParam("OBJ_NAME") String objName,
			@QueryParam("ADV_QRY") String advQuery, @QueryParam("ARG_NAMES") String argFieldNames,
			@QueryParam("ARG_TYPES") String argFieldTypes, @QueryParam("ARG_VALUES") String argFieldValues,
			@QueryParam("SEARCH_PARAM") String searchParam,

			@QueryParam("OBJ_CONTEXT") String objContext, @QueryParam("PAGE_CONTEXT") String pageContext,
			@QueryParam("CURR_ROW_NUM") String currentRowNo, @QueryParam("UPTO_ROW_NUM") String upToRowNo,
			@QueryParam("DATA_FORMAT") String dataFormat, @Context HttpServletRequest request,
			@Context HttpHeaders header) throws BaseException, Exception {

		try {
			VisionOBJServiceUtility visonOBJServiceUtility = new VisionOBJServiceUtility();

			return Response.ok(visonOBJServiceUtility.getListPageData(appId, objName, advQuery, argFieldNames,
					argFieldTypes, argFieldValues, searchParam, objContext, pageContext, currentRowNo, upToRowNo,
					dataFormat, request, header)).build();
		} catch (Exception e) {
			e.printStackTrace();
			return Response.serverError().build();
		}
	}
	@GET
	@Path("/getPageMetadata")
	@Produces(MediaType.APPLICATION_JSON)
	public Response getPageMetadata(
		@QueryParam("APP_ID") String appId,
		@QueryParam("OBJ_NAME") String objName,
		@QueryParam("FORM_NAME") String formName,	
		@QueryParam("OBJ_CONTEXT") String objContext,
		@QueryParam("PAGE_CONTEXT") String pageContext,	   
	    @Context HttpServletRequest request,
	    @Context HttpHeaders header) throws BaseException, Exception {
	    
	    try {
	        VisionOBJServiceUtility visonOBJServiceUtility = new VisionOBJServiceUtility();
	        
	        return Response.ok(visonOBJServiceUtility.getPageMetadata(request,header,appId,objName,formName,objContext,pageContext)).build();
	    } catch (Exception e) {	       
	        e.printStackTrace();
	        return Response.serverError().build();
	    }
	}	
	@GET
	@Path("/getFormalArgs")
	@Produces(MediaType.APPLICATION_JSON)
	public Response getPageFormalArgs(
		@QueryParam("APP_ID") String appId,
	    @QueryParam("OBJ_NAME") String objName,
	    @QueryParam("PAGE_NO") String pageNo,
	    @QueryParam("FORM_NAME") String formName,
	    @Context HttpServletRequest request,
	    @Context HttpHeaders header) throws BaseException, Exception {
	    
	    try {
	        VisionOBJServiceUtility visonOBJServiceUtility = new VisionOBJServiceUtility();
	        
	        return Response.ok(visonOBJServiceUtility.getFormalArgs(request,header,appId,objName,pageNo,formName)).build();
	    } catch (Exception e) {	       
	        e.printStackTrace();
	        return Response.serverError().build();
	    }
	}
	
	@POST
	@Path("/getData")
	@Produces(MediaType.APPLICATION_JSON)
	public Response getData( @FormParam("OBJ_NAME") String objName, @FormParam("REF_ID") String refId,
			@FormParam("TOKEN_ID") String tokenId, @FormParam("DATA_FORMAT") String dataFormat,
		 	@FormParam("APP_ID") String appId, @Context HttpServletRequest request,@Context HttpHeaders header) throws BaseException, Exception
	{
		BaseLogger.log("3", null, null, "Inside getData : VisonObjServiceUtility ");
		VisionOBJServiceUtility visonOBJServiceUtility = new VisionOBJServiceUtility();
		
		//String result = E12ExtServiceUtility.getDataClient(objName, refId, tokenId, dataFormat, appId, request);
		 
		 
		String result = visonOBJServiceUtility.getData(request,header,objName, refId,  dataFormat, appId);
		return Response.status(200).entity( result ).build();
	}

	@POST
	@Path("/getReportArgs")
	@Produces(MediaType.APPLICATION_JSON)
	public Response getReportArgs(
			@FormParam("OBJ_NAME") String objName,
			@FormParam("DATA_FORMAT") String dataFormat,
			@FormParam("APP_ID") String appId,
			@FormParam("FORM_NAME") String formName,
			@Context HttpServletRequest request,
			@Context HttpHeaders header) throws BaseException, Exception 
	{
		
		VisionOBJServiceUtility visonOBJServiceUtility = new VisionOBJServiceUtility();
		String result = visonOBJServiceUtility.getReportArgs(objName,dataFormat,appId,formName,request,header);
		
		return Response.status(200).entity(result).build();
	}
	
	@POST
	@Path("/getReport")
	public Response getReport(
			@FormParam("APP_ID") String appId,
			@FormParam("OBJ_NAME") String objName,
			@FormParam("REPORT_SAVE_TYPE") String docType,
			@FormParam("DATA_FORMAT") String dataFormat,
			@FormParam("ARGUMENT") String reportArgument,
			@Context HttpServletRequest request,
			@Context HttpServletResponse response,
			@Context HttpHeaders header) throws BaseException, Exception 
	{
		
		VisionOBJServiceUtility visonOBJServiceUtility = new VisionOBJServiceUtility();
		String result = visonOBJServiceUtility.getReport(objName, appId,dataFormat,docType,reportArgument, request, header,response);
		return Response.status(200).entity(result).build();
	}
	
	//Creat
	
	@POST
	@Path("/getObjPopHelpInfoAll")
	public Response getObjPopHelpInfoAll(@FormParam("OBJ_NAME") String objName, @Context HttpServletRequest request,
			@Context HttpServletResponse response, @HeaderParam("TOKEN_ID") String tokenIDfromHeader)
			throws BaseException, Exception {

		VisionOBJServiceUtility visonOBJServiceUtility = new VisionOBJServiceUtility();
		String result = visonOBJServiceUtility.getObjPopHelpInfoAll(objName, tokenIDfromHeader);
		return Response.status(200).entity(result).build();
	}
	
	
}
