/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.bean;

public class GeolocationBean {
    public int getClosest(double clientLongitude, double clientLattitude, TwoDCoordinates[] coordinateArray) {
        if (coordinateArray == null || coordinateArray != null && coordinateArray.length == 0) {
            return -1;
        }
        double min = -1.0;
        int index = -1;
        int i = 0;
        while (i < coordinateArray.length) {
            TwoDCoordinates coordinates = coordinateArray[i];
            if (coordinates != null) {
                double dist = TwoDCoordinates.getDistance(clientLongitude, clientLattitude, coordinates);
                if (min < 0.0) {
                    min = dist;
                    index = i;
                } else if (dist < min) {
                    min = dist;
                    index = i;
                }
            }
            ++i;
        }
        return index;
    }

    public static class TwoDCoordinates {
        protected double latitude;
        protected double longitude;
        protected String localityCode;
        protected String localityDescr;

        public TwoDCoordinates(double latitude, double longitude, String localityCode, String localityDescr) {
            this.latitude = latitude;
            this.longitude = longitude;
            this.localityCode = localityCode;
            this.localityDescr = localityDescr;
        }

        public static double getDistance(double clientLongitude, double clientLattitude, TwoDCoordinates arg2) {
            double latitude1 = clientLattitude;
            double latitude2 = arg2.getLatitude();
            double longitude1 = clientLongitude;
            double longitude2 = arg2.getLongitude();
            double x = latitude1 - latitude2;
            double y = longitude1 - longitude2;
            double dist = Math.sqrt(x * x + y * y);
            return dist;
        }

        public double getLatitude() {
            return this.latitude;
        }

        public double getLongitude() {
            return this.longitude;
        }

        public String getLocalityCode() {
            return this.localityCode;
        }

        public String getLocalityDescr() {
            return this.localityDescr;
        }
    }
}

