/*
 * Decompiled with CFR 0.152.
 */
package ibase.bean;

import ibase.ejb.UserEventLogEJB;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserActivityLogger;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.utility.ITMException;
import java.io.File;
import java.io.FileWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpSession;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EventLogInfoBean {
    public UserEventLogEJB userEventEJB;
    private String userCode = null;
    private ArrayList<String> editorIDAndActionList = null;
    private String objName = "";
    private String activityDescr = "";
    final String SEPARATOR = "~SEP~";
    private HashMap<String, String> objDetailMap = new HashMap();
    private HashMap<String, String> userNameMap = new HashMap();
    private HashMap<String, String> userSiteMap = new HashMap();
    private HashMap<String, String> userTransDBMap = new HashMap();

    public EventLogInfoBean() {
        try {
            if (this.userEventEJB == null) {
                this.userEventEJB = new UserEventLogEJB();
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Excepton 2: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public EventLogInfoBean(String userCode) {
        this();
        this.userCode = userCode;
    }

    public String getUserActivityLog() throws ITMException {
        StringBuffer retStringBuff = new StringBuffer("<ACTIVITIES>");
        if (this.userCode != null) {
            retStringBuff.append(this.getUserActivityLog(this.userCode));
        }
        retStringBuff.append("</ACTIVITIES>");
        return retStringBuff.toString();
    }

    private String getUserActivityLog(String userCode) throws ITMException {
        StringBuffer retStringBuff = new StringBuffer();
        LinkedHashMap userEventLogMap = null;
        if (UserEventLogEJB.eventActivityMap != null && (userEventLogMap = (LinkedHashMap)UserEventLogEJB.eventActivityMap.get(userCode)) != null) {
            retStringBuff.append("<ACTIVITY USER_CODE='" + userCode + "'>");
            Iterator itr = userEventLogMap.keySet().iterator();
            while (itr.hasNext()) {
                retStringBuff.append(this.getObjectActivityLog(userEventLogMap, (String)itr.next()));
            }
            retStringBuff.append("</ACTIVITY>");
        }
        return retStringBuff.toString();
    }

    public String getUserActivityLog(String objName, String sessionId) throws ITMException {
        StringBuffer retStringBuff = new StringBuffer("<ACTIVITIES>");
        LinkedHashMap userEventLogMap = null;
        if (UserEventLogEJB.eventActivityMap != null && (userEventLogMap = (LinkedHashMap)UserEventLogEJB.eventActivityMap.get(this.userCode)) != null) {
            retStringBuff.append("<ACTIVITY USER_CODE='" + this.userCode + "'>");
            retStringBuff.append(this.getObjectActivityLog(userEventLogMap, String.valueOf(sessionId) + "~SEP~" + objName));
            retStringBuff.append("</ACTIVITY>");
        }
        retStringBuff.append("</ACTIVITIES>");
        return retStringBuff.toString();
    }

    public String getUserActivityLog(String objName, String sessionId, String editorIdAndAction, String transDB) throws ITMException {
        StringBuffer retStringBuff = new StringBuffer("<ACTIVITIES>");
        LinkedHashMap userEventLogMap = null;
        if (UserEventLogEJB.eventActivityMap != null && (userEventLogMap = (LinkedHashMap)UserEventLogEJB.eventActivityMap.get(this.userCode)) != null) {
            retStringBuff.append("<ACTIVITY USER_CODE='" + this.userCode + "'>");
            retStringBuff.append(this.getObjectActivityLog(userEventLogMap, String.valueOf(sessionId) + "~SEP~" + objName, editorIdAndAction, transDB));
            retStringBuff.append("</ACTIVITY>");
        }
        retStringBuff.append("</ACTIVITIES>");
        return retStringBuff.toString();
    }

    public String getUserActivityLog(String param, boolean isObjectSelected) throws ITMException {
        StringBuffer retStringBuff = new StringBuffer("<ACTIVITIES>");
        LinkedHashMap userEventLogMap = null;
        if (UserEventLogEJB.eventActivityMap != null && (userEventLogMap = (LinkedHashMap)UserEventLogEJB.eventActivityMap.get(this.userCode)) != null) {
            retStringBuff.append("<ACTIVITY USER_CODE='" + this.userCode + "'>");
            Iterator itr = userEventLogMap.keySet().iterator();
            while (itr.hasNext()) {
                String keyValue;
                String tempKeyValue = keyValue = (String)itr.next();
                String objName = keyValue.substring(keyValue.indexOf("~SEP~") + 5, keyValue.length());
                String sessionId = keyValue.substring(0, keyValue.indexOf("~SEP~"));
                boolean isExist = false;
                tempKeyValue = isObjectSelected ? tempKeyValue.substring(tempKeyValue.indexOf("~SEP~") + 5, tempKeyValue.length()) : tempKeyValue.substring(0, tempKeyValue.indexOf("~SEP~"));
                isExist = tempKeyValue.equalsIgnoreCase(param);
                if (!isExist) continue;
                retStringBuff.append(this.getObjectActivityLog(userEventLogMap, String.valueOf(sessionId) + "~SEP~" + objName));
            }
            retStringBuff.append("</ACTIVITY>");
        }
        retStringBuff.append("</ACTIVITIES>");
        return retStringBuff.toString();
    }

    private String getObjectActivityLog(LinkedHashMap userEventLogMap, String paramValue, String editorIdAndAction, String transDB) throws ITMException {
        LinkedHashMap objectActivityMap = (LinkedHashMap)userEventLogMap.get(paramValue);
        String descrResult = "";
        String iconPath = "";
        String objName = paramValue.substring(paramValue.indexOf("~SEP~") + 5);
        String sessionId = paramValue.substring(0, paramValue.indexOf("~SEP~"));
        try {
            descrResult = this.userEventEJB.getObjNameDescr(objName, transDB, null);
            iconPath = this.userEventEJB.getobjIconPath(objName, transDB, null);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "EventLogInfoBean.getUserActivityLog() :: " + e);
        }
        StringBuffer retStringBuff = new StringBuffer("<OBJECT_ACTIVITY OBJ_NAME='" + objName + "' SESSION_ID='" + sessionId + "' TITLE='" + descrResult + "' ICON_PATH='" + iconPath + "'>");
        Iterator itr = objectActivityMap.keySet().iterator();
        while (itr.hasNext()) {
            String keyValue = E12GenericUtility.checkNull((String)itr.next());
            String action = "";
            String editorId = keyValue;
            if (!keyValue.equals(editorIdAndAction)) continue;
            if (this.editorIDAndActionList != null) {
                this.editorIDAndActionList.add(keyValue);
            }
            retStringBuff.append(this.getEditorActivity(objectActivityMap, editorId, action, transDB));
        }
        retStringBuff.append("</OBJECT_ACTIVITY>");
        return retStringBuff.toString();
    }

    private String getObjectActivityLog(LinkedHashMap userEventLogMap, String paramValue) throws ITMException {
        LinkedHashMap objectActivityMap = (LinkedHashMap)userEventLogMap.get(paramValue);
        String descrResult = "";
        String iconPath = "";
        String objName = paramValue.substring(paramValue.indexOf("~SEP~") + 5);
        String sessionId = paramValue.substring(0, paramValue.indexOf("~SEP~"));
        try {
            descrResult = this.userEventEJB.getObjNameDescr(objName, null, this.userCode);
            iconPath = this.userEventEJB.getobjIconPath(objName, null, this.userCode);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "EventLogInfoBean.getUserActivityLog() :: " + e);
        }
        StringBuffer retStringBuff = new StringBuffer("<OBJECT_ACTIVITY OBJ_NAME='" + objName + "' SESSION_ID='" + sessionId + "' TITLE='" + descrResult + "' ICON_PATH='" + iconPath + "'>");
        for (String keyValue : objectActivityMap.keySet()) {
            String action = "";
            String editorId = keyValue;
            if (this.editorIDAndActionList != null) {
                this.editorIDAndActionList.add(keyValue);
            }
            retStringBuff.append(this.getEditorActivity(objectActivityMap, editorId, action, null));
        }
        retStringBuff.append("</OBJECT_ACTIVITY>");
        return retStringBuff.toString();
    }

    public String getEventActivityLog(String objName, String sessionId, String editorId, String action, String transDB) throws ITMException {
        LinkedHashMap objectMap;
        StringBuffer retStringBuffer = new StringBuffer("<ROOT>");
        LinkedHashMap userEventLogMap = null;
        if (UserEventLogEJB.eventActivityMap != null && (userEventLogMap = (LinkedHashMap)UserEventLogEJB.eventActivityMap.get(this.userCode)) != null && (objectMap = (LinkedHashMap)userEventLogMap.get(String.valueOf(sessionId) + "~SEP~" + objName)) != null) {
            retStringBuffer.append(this.getEditorActivity(objectMap, editorId, action, transDB));
        }
        retStringBuffer.append("</ROOT>");
        BaseLogger.log("2", null, null, "return string ....[" + retStringBuffer.toString() + "]");
        return retStringBuffer.toString();
    }

    private String getEditorActivity(LinkedHashMap objectActivityMap, String editorId, String action, String transDB) throws ITMException {
        StringBuffer eventDetails = new StringBuffer();
        LinkedList editorActivityList = (LinkedList)objectActivityMap.get(editorId);
        try {
            if (transDB == null || transDB.trim().length() == 0) {
                DBAccessEJB dbAccessEjb = new DBAccessEJB();
                transDB = dbAccessEjb.getDBColumnValue("USERS", "TRANS_DB", "CODE = '" + this.userCode + "'");
                dbAccessEjb = null;
            }
        }
        catch (Exception e) {
            e.getStackTrace();
            throw new ITMException(e);
        }
        String actionType = null;
        if (editorActivityList != null) {
            int listSize = editorActivityList.size();
            int cnt = 0;
            while (cnt < listSize) {
                LinkedHashMap detailMap = (LinkedHashMap)editorActivityList.get(cnt);
                if (detailMap != null && detailMap.size() > 0 && !detailMap.containsKey("IS_WRITETOFILE")) {
                    eventDetails.append("<EVENT_ACTIVITY id='" + (cnt + 1) + "'>");
                    eventDetails.append("<EVENT><![CDATA[").append(this.userEventEJB.getEventDescr((String)detailMap.get("EVENT"), transDB)).append("]]></EVENT>");
                    eventDetails.append("<DB_NAME><![CDATA[").append(transDB).append("]]></DB_NAME>");
                    eventDetails.append("<ARG_PARAM><![CDATA[").append((String)detailMap.get("ARG_PARAM")).append("]]></ARG_PARAM>");
                    eventDetails.append("<ACCESS_TIME><![CDATA[").append((String)detailMap.get("ACCESS_TIME")).append("]]></ACCESS_TIME>");
                    eventDetails.append("<COMPL_TIME><![CDATA[").append((String)detailMap.get("COMPL_TIME")).append("]]></COMPL_TIME>");
                    eventDetails.append("<TRAN_ID><![CDATA[").append((String)detailMap.get("TRAN_ID")).append("]]></TRAN_ID>");
                    String exceptionStr = (String)detailMap.get("EXCEPTION_MSG");
                    BaseLogger.log("2", null, null, "inside getUserActivityLog.....exceptionStr[[" + exceptionStr + "]]]]");
                    if (exceptionStr.startsWith("<![CDATA[")) {
                        eventDetails.append("<EXCEPTION_MSG>").append(exceptionStr).append("</EXCEPTION_MSG>");
                    } else {
                        eventDetails.append("<EXCEPTION_MSG><![CDATA[").append((String)detailMap.get("EXCEPTION_MSG")).append("]]></EXCEPTION_MSG>");
                    }
                    eventDetails.append("<EVENT_RESULT><![CDATA[").append((String)detailMap.get("EVENT_RESULT")).append("]]></EVENT_RESULT>");
                    eventDetails.append("</EVENT_ACTIVITY>");
                    if (actionType == null || "null".equalsIgnoreCase(actionType)) {
                        actionType = (String)detailMap.get("ACTION_TYPE");
                    }
                }
                ++cnt;
            }
        }
        if (actionType != null) {
            StringBuffer retStringBuff = new StringBuffer("<EDITOR_ACTIVITY ACTION='" + action + "' EDITOR_ID='" + editorId + "' ACTION_TYPE='" + actionType + "' >");
            retStringBuff.append(eventDetails.toString());
            retStringBuff.append("</EDITOR_ACTIVITY>");
            return retStringBuff.toString();
        }
        return "";
    }

    public int getUserActiveObjectCount(String sessionId) {
        int size = 0;
        LinkedHashMap userEventLogMap = null;
        if (UserEventLogEJB.eventActivityMap != null && (userEventLogMap = (LinkedHashMap)UserEventLogEJB.eventActivityMap.get(this.userCode)) != null) {
            Iterator itr = userEventLogMap.keySet().iterator();
            while (itr.hasNext()) {
                String keyValue;
                String tempKeyValue = keyValue = (String)itr.next();
                if (!(tempKeyValue = tempKeyValue.substring(0, tempKeyValue.indexOf("~SEP~"))).equalsIgnoreCase(sessionId)) continue;
                ++size;
            }
        }
        BaseLogger.log("2", null, null, "getuserObjectLogCounter return value[" + size + "]");
        return size;
    }

    public void removeEditorActivity(String objName, String sessionId, String coreModelID, String transDB) {
        try {
            BaseLogger.log("3", null, null, "removeEditorActivity ");
            LinkedHashMap userEventLogMap = null;
            if (UserEventLogEJB.eventActivityMap != null && (userEventLogMap = (LinkedHashMap)UserEventLogEJB.eventActivityMap.get(this.userCode)) != null) {
                LinkedHashMap objectActivityMap = (LinkedHashMap)userEventLogMap.get(String.valueOf(sessionId) + "~SEP~" + objName);
                this.editorIDAndActionList = new ArrayList();
                if (objectActivityMap != null) {
                    HashSet<String> wroteFileCoreModelID = new HashSet<String>();
                    for (String keyValue : objectActivityMap.keySet()) {
                        String tempKeyValue = keyValue;
                        if (tempKeyValue.indexOf("_") != -1) {
                            tempKeyValue = tempKeyValue.substring(0, tempKeyValue.indexOf("_"));
                        }
                        BaseLogger.log("3", null, null, "removeEditorActivity : keyValue [" + keyValue + "] coreModelID[" + coreModelID + "]");
                        if (!tempKeyValue.equalsIgnoreCase(coreModelID)) continue;
                        if ("2".equals(CommonConstants.USER_LOG) && !wroteFileCoreModelID.contains(tempKeyValue)) {
                            this.writeLogToFile(objName, sessionId, (LinkedHashMap)userEventLogMap.get(keyValue), keyValue, transDB);
                            wroteFileCoreModelID.add(tempKeyValue);
                        }
                        this.editorIDAndActionList.add(keyValue);
                    }
                    boolean cnt = false;
                    Set actionkeys = objectActivityMap.keySet();
                    ArrayList<String> keyToRemove = new ArrayList<String>();
                    for (String editorIdkey : actionkeys) {
                        if (!this.editorIDAndActionList.contains(editorIdkey)) continue;
                        ArrayList<Integer> removeIndexFromList = new ArrayList<Integer>();
                        LinkedList editorActivityList = (LinkedList)objectActivityMap.get(editorIdkey);
                        LinkedHashMap eventDetailMap = new LinkedHashMap();
                        int i = 0;
                        while (i < editorActivityList.size()) {
                            eventDetailMap = (LinkedHashMap)editorActivityList.get(i);
                            if (eventDetailMap.size() > 0) {
                                if (eventDetailMap.containsValue("Success")) {
                                    removeIndexFromList.add(i);
                                } else {
                                    eventDetailMap.put("IS_WRITETOFILE", "false");
                                }
                            }
                            ++i;
                        }
                        i = removeIndexFromList.size();
                        while (i > 0) {
                            int k = (Integer)removeIndexFromList.get(i - 1);
                            editorActivityList.remove(k);
                            --i;
                        }
                        if (editorActivityList.size() != 0) continue;
                        keyToRemove.add(editorIdkey);
                    }
                    int i = 0;
                    while (i < keyToRemove.size()) {
                        String key = (String)keyToRemove.get(i);
                        if (objectActivityMap.containsKey(key)) {
                            objectActivityMap.remove(key);
                        }
                        ++i;
                    }
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :" + e.getMessage());
            e.printStackTrace();
        }
    }

    public void removeSessionActivity(String sessionId) {
        try {
            LinkedHashMap userEventLogMap = null;
            if (UserEventLogEJB.eventActivityMap != null && (userEventLogMap = (LinkedHashMap)UserEventLogEJB.eventActivityMap.get(this.userCode)) != null) {
                ArrayList<String> keyValues = new ArrayList<String>();
                Iterator itr = userEventLogMap.keySet().iterator();
                while (itr.hasNext()) {
                    String keyValue;
                    String tempKeyValue = keyValue = (String)itr.next();
                    if (!(tempKeyValue = tempKeyValue.substring(0, tempKeyValue.indexOf("~SEP~"))).equalsIgnoreCase(sessionId)) continue;
                    if ("2".equals(CommonConstants.USER_LOG)) {
                        String objName = keyValue.substring(keyValue.indexOf("~SEP~") + 5);
                        this.writeLogToFile(objName, sessionId, (LinkedHashMap)userEventLogMap.get(keyValue));
                    }
                    keyValues.add(keyValue);
                }
                int cnt = 0;
                cnt = 0;
                while (cnt < keyValues.size()) {
                    userEventLogMap.remove(keyValues.get(cnt));
                    ++cnt;
                }
                if (userEventLogMap.size() == 0) {
                    UserEventLogEJB.eventActivityMap.remove(this.userCode);
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :" + e.getMessage());
            e.printStackTrace();
        }
    }

    private void writeLogToFile(String objName, String sessionId, LinkedHashMap userEventLogMap) throws Exception {
        String transDB = this.getTransDB(this.userCode);
        this.writeLogToFile(objName, sessionId, userEventLogMap, null, transDB);
    }

    private void writeLogToFile(String objName, String sessionId, LinkedHashMap userEventLogMap, String editorIdAndAction, String transDB) throws Exception {
        StringBuffer contents = new StringBuffer();
        if (editorIdAndAction == null) {
            contents.append(String.valueOf(this.getUserActivityLog(objName, sessionId)) + "\n\n");
        } else {
            contents.append(String.valueOf(this.getUserActivityLog(objName, sessionId, editorIdAndAction, transDB)) + "\n\n");
        }
        this.write(contents.toString());
    }

    private void writeLogToFile(String objName, String sessionId, String coreModelID, String action, LinkedHashMap objectActivityMap) throws Exception {
        StringBuffer contents = new StringBuffer();
        contents.append("<ACTIVITIES><ACTIVITY USER_CODE='" + this.userCode + "'><OBJECT_ACTIVITY OBJ_NAME='" + objName + "' SESSION_ID='" + sessionId + "'>");
        contents.append(this.getEditorActivity(objectActivityMap, coreModelID, action, null));
        contents.append("</OBJECT_ACTIVITY></ACTIVITY></ACTIVITIES>\n\n");
        this.write(contents.toString());
    }

    private void write(String contents) {
        try {
            int eventIndxVal = 0;
            E12GenericUtility genericUtility = new E12GenericUtility();
            Document dom = genericUtility.parseString(contents);
            StringBuffer xmlContent = new StringBuffer();
            StringBuffer eventSaveAbort = new StringBuffer();
            NodeList activitesNodeLst = dom.getElementsByTagName("ACTIVITY");
            if (activitesNodeLst.getLength() > 0) {
                int activityIndex = 0;
                while (activityIndex < activitesNodeLst.getLength()) {
                    Node activities = activitesNodeLst.item(activityIndex);
                    if (activities != null && activities.hasAttributes()) {
                        String value = this.listAllAttributes(activities).toString();
                        xmlContent.append(value);
                    }
                    NodeList activitiesList = activities.getChildNodes();
                    int objIndex = 0;
                    while (objIndex < activitiesList.getLength()) {
                        Node objActNode = activitiesList.item(objIndex);
                        if (objActNode.getNodeName().equals("OBJECT_ACTIVITY")) {
                            if (objActNode.hasAttributes()) {
                                String value = this.listAllAttributes(objActNode).toString();
                                xmlContent.append(value);
                            }
                            NodeList objectList = objActNode.getChildNodes();
                            int editorIndex = 0;
                            while (editorIndex < objectList.getLength()) {
                                Node objNames = objectList.item(editorIndex);
                                if (objNames.getNodeName().equals("EDITOR_ACTIVITY")) {
                                    String complActionVal;
                                    if (objNames.hasAttributes()) {
                                        String value = this.listAllAttributes(objNames).toString();
                                        xmlContent.append(value);
                                    }
                                    NodeList eventList = objNames.getChildNodes();
                                    String eventAction = "";
                                    String lastEventResult = "";
                                    int eventIndex = 0;
                                    while (eventIndex < eventList.getLength()) {
                                        Node eventNames = eventList.item(eventIndex);
                                        if (eventNames.getNodeName().equals("EVENT_ACTIVITY")) {
                                            if (eventNames.hasAttributes()) {
                                                String value = this.listAllAttributes(eventNames).toString();
                                                if (value.contains("<EVENT_ID id=")) {
                                                    int beginIndex = value.indexOf("'");
                                                    int endIndex = value.lastIndexOf("'");
                                                    eventIndxVal = Integer.parseInt(value.substring(beginIndex + 1, endIndex));
                                                } else {
                                                    xmlContent.append(value);
                                                }
                                            }
                                            NodeList eventChildList = eventNames.getChildNodes();
                                            int evtIndex = 0;
                                            while (evtIndex < eventChildList.getLength()) {
                                                Node eventChildNames = eventChildList.item(evtIndex);
                                                if (eventChildNames.getNodeName().equals("EVENT")) {
                                                    eventAction = eventChildNames.getFirstChild().getNodeValue();
                                                    if ("SAVE".equalsIgnoreCase(eventAction) || "ABORT".equalsIgnoreCase(eventAction)) {
                                                        eventSaveAbort.append("<EVENT_ID id='").append(eventIndxVal).append("'>\n");
                                                        eventSaveAbort.append("<EVENT_DESCRP><![CDATA[").append(eventAction).append("]]></EVENT_DESCRP>\n");
                                                    } else {
                                                        xmlContent.append("<EVENT_ID id='").append(eventIndxVal).append("'> \n");
                                                        xmlContent.append("<EVENT_DESCRP><![CDATA[").append(eventAction).append("]]></EVENT_DESCRP>\n");
                                                    }
                                                } else if (eventChildNames.getNodeName().equals("ARG_PARAM")) {
                                                    String formNo;
                                                    String argName = "";
                                                    if (eventChildNames.hasChildNodes()) {
                                                        String string = argName = eventChildNames.getFirstChild().getNodeValue() == null ? "" : eventChildNames.getFirstChild().getNodeValue();
                                                    }
                                                    if ((formNo = this.getFormNum(argName)) != null) {
                                                        xmlContent.append("<FORM_NO><![CDATA[").append(formNo).append("]]></FORM_NO>\n");
                                                    }
                                                    if ("SAVE".equalsIgnoreCase(eventAction) || "ABORT".equalsIgnoreCase(eventAction)) {
                                                        eventSaveAbort.append("<ARG_PARAM><![CDATA[").append("").append("]]></ARG_PARAM>\n");
                                                    } else {
                                                        xmlContent.append("<ARG_PARAM><![CDATA[").append(argName).append("]]></ARG_PARAM>\n");
                                                    }
                                                } else if (eventChildNames.getNodeName().equals("ACCESS_TIME")) {
                                                    String startTime;
                                                    String string = startTime = eventChildNames.getFirstChild().getNodeValue() == null ? "" : eventChildNames.getFirstChild().getNodeValue();
                                                    if ("SAVE".equalsIgnoreCase(eventAction) || "ABORT".equalsIgnoreCase(eventAction)) {
                                                        eventSaveAbort.append("<ACCESS_START_TIME><![CDATA[").append(startTime).append("]]></ACCESS_START_TIME>\n");
                                                    } else {
                                                        xmlContent.append("<ACCESS_START_TIME><![CDATA[").append(startTime).append("]]></ACCESS_START_TIME>\n");
                                                    }
                                                } else if (eventChildNames.getNodeName().equals("COMPL_TIME")) {
                                                    String complTime = "";
                                                    complTime = eventChildNames.hasChildNodes() && eventChildNames.getFirstChild() != null ? (eventChildNames.getFirstChild().getNodeValue() == null ? "" : eventChildNames.getFirstChild().getNodeValue()) : eventChildNames.getNodeValue();
                                                    if ("SAVE".equalsIgnoreCase(eventAction) || "ABORT".equalsIgnoreCase(eventAction)) {
                                                        eventSaveAbort.append("<ACCESS_END_TIME><![CDATA[").append(complTime).append("]]></ACCESS_END_TIME>\n");
                                                    } else {
                                                        xmlContent.append("<ACCESS_END_TIME><![CDATA[").append(complTime).append("]]></ACCESS_END_TIME>\n");
                                                    }
                                                } else if (eventChildNames.getNodeName().equals("TRAN_ID")) {
                                                    String tranId = "";
                                                    tranId = eventChildNames.hasChildNodes() && eventChildNames.getFirstChild() != null ? (eventChildNames.getFirstChild().getNodeValue() == null || "null".equalsIgnoreCase(eventChildNames.getFirstChild().getNodeValue()) ? "NA" : eventChildNames.getFirstChild().getNodeValue()) : eventChildNames.getNodeValue();
                                                    if ("Save".equalsIgnoreCase(eventAction) || "Abort".equalsIgnoreCase(eventAction)) {
                                                        eventSaveAbort.append("<PRIMARY_KEY><![CDATA[").append(tranId).append("]]></PRIMARY_KEY>\n");
                                                        BaseLogger.log("3", null, null, "eventAction in transaction page[" + eventAction + "]");
                                                    } else {
                                                        xmlContent.append("<PRIMARY_KEY><![CDATA[").append(tranId).append("]]></PRIMARY_KEY>\n");
                                                    }
                                                } else if (eventChildNames.getNodeName().equals("EXCEPTION_MSG")) {
                                                    String exception_msg = "";
                                                    exception_msg = eventChildNames.hasChildNodes() && eventChildNames.getFirstChild() != null ? (eventChildNames.getFirstChild().getNodeValue() == null || "null".equalsIgnoreCase(eventChildNames.getFirstChild().getNodeValue()) ? "" : eventChildNames.getFirstChild().getNodeValue()) : eventChildNames.getNodeValue();
                                                    if (("Save".equalsIgnoreCase(eventAction) || "Abort".equalsIgnoreCase(eventAction)) && !"".equals(exception_msg) && exception_msg != null) {
                                                        eventSaveAbort.append("<EXCEPTION_MSG><![CDATA[").append(exception_msg).append("]]></EXCEPTION_MSG>\n");
                                                    } else if (!"".equals(exception_msg) && exception_msg != null) {
                                                        xmlContent.append("<EXCEPTION_MSG><![CDATA[").append(exception_msg).append("]]></EXCEPTION_MSG>\n");
                                                    }
                                                } else if (eventChildNames.getNodeName().equals("EVENT_RESULT")) {
                                                    String eventResult = "";
                                                    eventResult = eventChildNames.hasChildNodes() && eventChildNames.getFirstChild() != null ? (eventChildNames.getFirstChild().getNodeValue() == null || "null".equalsIgnoreCase(eventChildNames.getFirstChild().getNodeValue()) ? "NA" : eventChildNames.getFirstChild().getNodeValue()) : eventChildNames.getNodeValue();
                                                    lastEventResult = eventResult;
                                                    if ("Save".equalsIgnoreCase(eventAction) || "Abort".equalsIgnoreCase(eventAction)) {
                                                        eventSaveAbort.append("<EVENT_RESULT><![CDATA[").append(eventResult).append("]]></EVENT_RESULT>\n").append("</EVENT_ID>\n");
                                                        BaseLogger.log("3", null, null, "eventAction in transaction page[" + eventAction + "]");
                                                    } else {
                                                        xmlContent.append("<EVENT_RESULT><![CDATA[").append(eventResult).append("]]></EVENT_RESULT>\n").append("</EVENT_ID>\n");
                                                    }
                                                } else if (eventChildNames.getNodeName().equals("DB_NAME")) {
                                                    String dbName = "";
                                                    dbName = eventChildNames.hasChildNodes() && eventChildNames.getFirstChild() != null ? (eventChildNames.getFirstChild().getNodeValue() == null || "null".equalsIgnoreCase(eventChildNames.getFirstChild().getNodeValue()) ? "" : eventChildNames.getFirstChild().getNodeValue()) : eventChildNames.getNodeValue();
                                                    xmlContent.append("<DB_NAME><![CDATA[").append(dbName).append("]]></DB_NAME>\n");
                                                }
                                                ++evtIndex;
                                            }
                                        }
                                        ++eventIndex;
                                    }
                                    String complActionResult = this.getObjDetails(this.objName, "COMPL_ACTION", null, this.userCode, null);
                                    if (complActionResult == null) {
                                        DBAccessEJB dbAccessEjb = new DBAccessEJB();
                                        String transDB = dbAccessEjb.getDBColumnValue("USERS", "TRANS_DB", "CODE = '" + this.userCode + "'");
                                        String condition = " TRAN_WINDOW = 'w_" + this.objName + "' ";
                                        complActionResult = dbAccessEjb.getDBColumnValue("TRANSETUP", "COMPL_ACTION", condition, transDB);
                                    }
                                    complActionResult = this.checkNull(complActionResult);
                                    boolean isExistComplAction = false;
                                    String[] complActionResultSplitArry = complActionResult.split(",");
                                    int i = 0;
                                    while (i < complActionResultSplitArry.length) {
                                        String complAction = complActionResultSplitArry[i].trim();
                                        if (complAction.equalsIgnoreCase(this.activityDescr)) {
                                            isExistComplAction = true;
                                            break;
                                        }
                                        ++i;
                                    }
                                    String string = complActionVal = "Success".equalsIgnoreCase(lastEventResult) ? "1" : "0";
                                    if ("Save".equalsIgnoreCase(eventAction) || "Abort".equalsIgnoreCase(eventAction)) {
                                        if (!"VIEW".equalsIgnoreCase(this.activityDescr) && isExistComplAction) {
                                            eventSaveAbort.append("<COMPL_ACTION><![CDATA[").append(complActionVal).append("]]></COMPL_ACTION>\n");
                                        }
                                        eventSaveAbort.append("</ACTIVITY_ACTION>\n");
                                    } else {
                                        if (!"VIEW".equalsIgnoreCase(this.activityDescr) && isExistComplAction) {
                                            xmlContent.append("<COMPL_ACTION><![CDATA[").append(complActionVal).append("]]></COMPL_ACTION>\n");
                                        }
                                        xmlContent.append("</ACTIVITY_ACTION>\n");
                                    }
                                }
                                ++editorIndex;
                            }
                        }
                        ++objIndex;
                    }
                    ++activityIndex;
                }
                if (eventSaveAbort.toString() != null && eventSaveAbort.toString() != "") {
                    xmlContent.append(eventSaveAbort.toString());
                }
                xmlContent.append("</ACTIVITY>\n\n");
            }
            String tranformDomToStringVal = null;
            Document dom1 = genericUtility.parseString(xmlContent.toString());
            if (dom1 != null) {
                NodeList activityNL = dom1.getElementsByTagName("ACTIVITY");
                int activityLen = activityNL.getLength();
                int i = 0;
                while (i < activityLen) {
                    Node node = activityNL.item(i);
                    BaseLogger.log("3", null, null, " node [" + node + "]");
                    if (node != null) {
                        NodeList childNL = node.getChildNodes();
                        int childLen = childNL.getLength();
                        int childIndex = 0;
                        while (childIndex < childLen) {
                            String nodeName;
                            Node childNode = childNL.item(childIndex);
                            if (childNode != null && "ACTIVITY_ACTION".equals(nodeName = childNode.getNodeName())) {
                                String primeryKeyVal = this.getPrimaryKeyValue(childNode);
                                this.replacePrimaryKeyVal(primeryKeyVal, childNode);
                            }
                            ++childIndex;
                        }
                    }
                    ++i;
                }
                tranformDomToStringVal = genericUtility.serializeDom(dom1);
            }
            contents = tranformDomToStringVal != null ? tranformDomToStringVal : xmlContent.toString();
            BaseLogger.log("3", null, null, "Content to write[" + contents + "]");
            this.writeUserActivityUsingLogger(contents);
            String logPath = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "server" + File.separator + "default" + File.separator + "UserActivity";
            this.userCode = this.userCode.trim();
            File file = new File(String.valueOf(logPath) + File.separator + this.userCode + "_" + new SimpleDateFormat("yyyyMMdd").format(new Date()) + ".txt");
            File userFolder = new File(logPath);
            boolean isDirExist = false;
            isDirExist = !userFolder.exists() ? userFolder.mkdir() : true;
            if (isDirExist) {
                if (!file.exists()) {
                    BaseLogger.log("3", null, null, "New File created.....");
                    file.createNewFile();
                }
                FileWriter fos = new FileWriter(file, true);
                fos.write(contents);
                fos.flush();
                fos.close();
                BaseLogger.log("3", null, null, "Activity Log Saved######### :" + file);
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception in Activity log write. :[" + E12GenericUtility.getStackTrace(e) + "]");
            e.printStackTrace();
        }
    }

    public void setLog(String objName, String sessionId, String editorId, String action, String event, Date startTime, Date endTime, String paramString, String tranId) {
        if (this.userEventEJB != null) {
            this.userEventEJB.setEventLog(this.userCode, objName, sessionId, editorId, action, event, startTime, endTime, paramString, tranId, "Pending", "SA", "");
        }
    }

    public void updateLog(String objName, String sessionId, String editorId, String action, String event, Date startTime, Date endTime, String paramString, String tranId) {
        if (this.userEventEJB != null) {
            this.userEventEJB.updateEventLog(this.userCode, objName, sessionId, editorId, action, event, startTime, endTime, paramString, tranId, "Success", "SA", "");
        }
    }

    public String getActiveUsers(HttpSession session) {
        String retString = "";
        TreeSet<String> userSet = new TreeSet<String>();
        try {
            HashMap applLevUserInfo;
            if (session != null && (applLevUserInfo = (HashMap)session.getServletContext().getAttribute("applLevUserInfo")) != null) {
                for (String key : applLevUserInfo.keySet()) {
                    userSet.add(key.split(":")[0]);
                }
            }
            Iterator itr = userSet.iterator();
            while (itr.hasNext()) {
                retString = String.valueOf(retString) + (String)itr.next() + ":";
            }
            if (retString.length() > 0 && retString.lastIndexOf(":") == retString.length() - 1) {
                retString = retString.substring(0, retString.lastIndexOf(":"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BaseLogger.log("2", null, null, "UserList[" + retString + "]");
        return retString;
    }

    public String getTargetFieldValue(String user, String objName, String sessionId, String editorId, String action, String field) {
        String retString = "";
        BaseLogger.log("2", null, null, "user[" + user + "] objName[" + objName + "] sesssionId[" + sessionId + "] editorId[" + editorId + "] action[" + action + "] field[" + field + "]");
        LinkedHashMap userMap = (LinkedHashMap)UserEventLogEJB.eventActivityMap.get(user);
        if (userMap == null || userMap.size() == 0 || field == null || field.length() == 0) {
            return retString;
        }
        if ("EDITOR_ID".equalsIgnoreCase(field) || "ACTION".equalsIgnoreCase(field)) {
            if (objName != null && objName.length() > 0 && sessionId != null && sessionId.length() > 0) {
                userMap = (LinkedHashMap)userMap.get(String.valueOf(sessionId) + "_" + objName);
            } else {
                return retString;
            }
        }
        TreeSet<String> userSet = new TreeSet<String>();
        for (String keyValue : userMap.keySet()) {
            String value = "";
            boolean flag = false;
            if ("OBJ_NAME".equalsIgnoreCase(field)) {
                value = keyValue.substring(keyValue.indexOf("_") + 1, keyValue.length());
                if (sessionId == null || sessionId.trim().length() == 0) {
                    flag = true;
                } else if (keyValue.equalsIgnoreCase(String.valueOf(sessionId) + "_" + value)) {
                    flag = true;
                }
            } else if ("SESSION_ID".equalsIgnoreCase(field)) {
                value = keyValue.substring(0, keyValue.indexOf("_"));
                if (objName == null || objName.trim().length() == 0) {
                    flag = true;
                } else if (keyValue.equalsIgnoreCase(String.valueOf(value) + "_" + objName)) {
                    flag = true;
                }
            } else if ("EDITOR_ID".equalsIgnoreCase(field)) {
                value = keyValue.substring(0, keyValue.indexOf("_"));
                if (value != null && value.trim().length() == 0) {
                    value = "ID-" + objName;
                }
                flag = true;
            } else if ("ACTION".equalsIgnoreCase(field)) {
                value = keyValue.substring(keyValue.indexOf("_") + 1, keyValue.length());
                if (("ID-" + objName).equalsIgnoreCase(editorId)) {
                    editorId = "";
                }
                if (keyValue.equalsIgnoreCase(String.valueOf(editorId) + "_" + value)) {
                    flag = true;
                }
            }
            if (!flag || value == null || value.length() <= 0) continue;
            userSet.add(value);
        }
        Iterator itr1 = userSet.iterator();
        while (itr1.hasNext()) {
            retString = String.valueOf(retString) + (String)itr1.next() + ":";
        }
        if (retString.length() > 0 && retString.lastIndexOf(":") == retString.length() - 1) {
            retString = retString.substring(0, retString.lastIndexOf(":"));
        }
        BaseLogger.log("2", null, null, "UserList[" + retString + "]");
        return retString;
    }

    public StringBuffer listAllAttributes(Node element) {
        NamedNodeMap attributes = element.getAttributes();
        StringBuffer attrValue = new StringBuffer();
        int numAttrs = attributes.getLength();
        String editorId = "";
        if (attributes.getNamedItem("EDITOR_ID") != null) {
            editorId = attributes.getNamedItem("EDITOR_ID").getNodeValue();
        }
        int index = 0;
        while (index < numAttrs) {
            Attr attr = (Attr)attributes.item(index);
            String attrName = attr.getNodeName();
            if (attrName.equalsIgnoreCase("USER_CODE")) {
                attrValue.append("<ACTIVITY USER_ID='").append(attr.getNodeValue()).append("'>\n");
            } else if (attrName.equalsIgnoreCase("OBJ_NAME")) {
                this.objName = attr.getNodeValue();
                attrValue.append("<ACTIVITY_OBJECT><![CDATA[").append(attr.getNodeValue()).append("]]></ACTIVITY_OBJECT>\n");
            } else if (attrName.equalsIgnoreCase("SESSION_ID")) {
                attrValue.append("<ACTIVITY_SESSION_ID><![CDATA[").append(attr.getNodeValue()).append("]]></ACTIVITY_SESSION_ID>\n");
            } else if (attrName.equalsIgnoreCase("TITLE")) {
                attrValue.append("<ACTIVITY_TITLE><![CDATA[").append(attr.getNodeValue()).append("]]></ACTIVITY_TITLE>\n");
            } else if (attrName.equalsIgnoreCase("ICON_PATH")) {
                attrValue.append("<ACTIVITY_ICON><![CDATA[").append(attr.getNodeValue()).append("]]></ACTIVITY_ICON>\n");
            } else if (attrName.equalsIgnoreCase("ACTION")) {
                attrValue.append("<ACTIVITY_ACTION>\n");
                this.activityDescr = this.checkNull(UserEventLogEJB.eventActionMap.get(editorId));
                if (this.activityDescr.length() <= 0) {
                    this.activityDescr = "VIEW";
                    attrValue.append("<ACTIVITY_DESCRP><![CDATA[").append(this.activityDescr).append("]]></ACTIVITY_DESCRP>\n");
                    attrValue.append("<EVENT_INFO><![CDATA[").append(UserEventLogEJB.eventActionMap.get(String.valueOf(editorId) + "_callerName")).append("]]></EVENT_INFO>\n");
                } else {
                    attrValue.append("<ACTIVITY_DESCRP><![CDATA[").append(this.activityDescr).append("]]></ACTIVITY_DESCRP>\n");
                }
                UserEventLogEJB.eventActionMap.remove(String.valueOf(editorId) + "_callerName");
                UserEventLogEJB.eventActionMap.remove(editorId);
            } else if (attrName.equalsIgnoreCase("EDITOR_ID")) {
                String editorIDLocal = attr.getNodeValue();
                if (editorIDLocal != null && editorIDLocal.indexOf("_") != -1) {
                    editorIDLocal = editorIDLocal.substring(0, editorIDLocal.indexOf("_"));
                }
                attrValue.append("<ACTIVITY_EDITOR><![CDATA[").append(editorIDLocal).append("]]></ACTIVITY_EDITOR>\n");
            } else if (attrName.equalsIgnoreCase("id")) {
                attrValue.append("<EVENT_ID id='").append(attr.getNodeValue()).append("'>");
            } else if ("ACTION_TYPE".equalsIgnoreCase(attrName)) {
                attrValue.append("<ACTION_TYPE><![CDATA[").append(attr.getNodeValue()).append("]]></ACTION_TYPE>\n");
            }
            ++index;
        }
        return attrValue;
    }

    public LinkedHashMap<String, String> isTranIdAvailable(String objName, String tranID, String execType, UserInfoBean infoBean) {
        LinkedHashMap<String, String> transLockDataMap = new LinkedHashMap<String, String>();
        Set userKeySet = null;
        LinkedHashMap sessionInfoMap = null;
        LinkedHashMap editorInfoMap = null;
        LinkedList tranDataList = null;
        String flag = "false";
        transLockDataMap.put("IS_TRAN_LOCK", flag);
        transLockDataMap.put("TRAN_LOCK_TYPE", this.checkNull(this.getLockType(execType)));
        BaseLogger.log("2", infoBean, null, "EventLogInfoBean.java : isTranIdAvailable : EVENT ACTIVITY MAP [" + UserEventLogEJB.eventActivityMap + "]");
        if (UserEventLogEJB.eventActivityMap != null) {
            try {
                BaseLogger.log("3", infoBean, null, "eventActionMap [" + UserEventLogEJB.eventActionMap + "]");
                userKeySet = UserEventLogEJB.eventActivityMap.keySet();
                if (userKeySet != null) {
                    for (String userKey : userKeySet) {
                        BaseLogger.log("3", infoBean, null, "userKey [" + userKey + "]");
                        if (UserEventLogEJB.eventActivityMap.get(userKey) == null || (sessionInfoMap = (LinkedHashMap)UserEventLogEJB.eventActivityMap.get(userKey)) == null) continue;
                        BaseLogger.log("3", infoBean, null, "1");
                        Set sessionKeySet = sessionInfoMap.keySet();
                        if (sessionKeySet == null) continue;
                        for (String sessionKey : sessionKeySet) {
                            if (!sessionKey.contains("_" + objName)) continue;
                            BaseLogger.log("3", infoBean, null, "2");
                            editorInfoMap = (LinkedHashMap)sessionInfoMap.get(sessionKey);
                            Set editorKeySet = editorInfoMap.keySet();
                            if (editorKeySet == null) continue;
                            for (String editorKey : editorKeySet) {
                                BaseLogger.log("3", infoBean, null, "3 editorKey [" + editorKey + "]");
                                if (!editorKey.contains("_EDIT")) continue;
                                tranDataList = (LinkedList)editorInfoMap.get(editorKey);
                                String siteCode = this.checkNull(this.getSiteCode(userKey));
                                if (tranDataList == null) continue;
                                BaseLogger.log("3", infoBean, null, "4 execType [" + execType + "]");
                                if ("E".equalsIgnoreCase(execType)) {
                                    flag = "true";
                                } else if ("S".equalsIgnoreCase(execType)) {
                                    if (siteCode.equalsIgnoreCase(infoBean.getSiteCode())) {
                                        flag = "true";
                                    }
                                } else if ("T".equalsIgnoreCase(execType)) {
                                    for (LinkedHashMap tranData : tranDataList) {
                                        if (tranData.get("TRAN_ID") == null || tranID == null) continue;
                                        BaseLogger.log("3", infoBean, null, "4 tranData.get(\"TRAN_ID\")  [" + tranData.get("TRAN_ID") + "] tranID [" + tranID + "]");
                                        if (!((String)tranData.get("TRAN_ID")).trim().equalsIgnoreCase(tranID.trim())) continue;
                                        flag = "true";
                                    }
                                }
                                if (!flag.equals("true")) continue;
                                transLockDataMap.clear();
                                transLockDataMap.put("IS_TRAN_LOCK", flag);
                                transLockDataMap.put("TRAN_LOCK_TYPE", this.checkNull(this.getLockType(execType)));
                                transLockDataMap.put("EMP_NAME", String.valueOf(this.getUserName(userKey, infoBean.getTransDB())) + " (" + userKey + ") ");
                                transLockDataMap.put("SITE_CODE", this.getSiteCode(userKey));
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            userKeySet = null;
            sessionInfoMap = null;
            editorInfoMap = null;
            tranDataList = null;
        }
        return transLockDataMap;
    }

    public String getObjDetails(String objName, String fieldName, UserInfoBean userInfo, String userCode, String transDB) {
        String execType = "";
        try {
            BaseLogger.log("3", userInfo, null, "objName  [" + objName + "]");
            if (this.objDetailMap == null || this.objDetailMap.size() == 0) {
                DBAccessEJB dbAccessEjb = new DBAccessEJB();
                if (userInfo != null) {
                    this.objDetailMap = dbAccessEjb.getObjDetailMap(objName, userInfo);
                } else {
                    if (transDB == null || transDB.trim().length() == 0) {
                        transDB = dbAccessEjb.getDBColumnValue("USERS", "TRANS_DB", "CODE = '" + userCode + "'");
                    }
                    this.objDetailMap = dbAccessEjb.getObjDetailMap(objName, transDB);
                }
                dbAccessEjb = null;
            }
            if (this.objDetailMap != null) {
                execType = this.objDetailMap.get(fieldName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return execType;
    }

    private String getUserName(String empCode, String transDB) {
        String empName;
        block17: {
            empName = new String("");
            Connection mConnection = null;
            Statement mStmt = null;
            ResultSet rs = null;
            try {
                try {
                    if (this.userNameMap != null && this.userNameMap.containsKey(empCode)) {
                        empName = this.userNameMap.get(empCode);
                        break block17;
                    }
                    ConnDriver mConnDriver = new ConnDriver();
                    mConnection = mConnDriver.getConnectDB(transDB);
                    mConnDriver = null;
                    String empQuery = "SELECT NAME FROM USERS  WHERE CODE = ? ";
                    BaseLogger.log("3", null, null, "Emp Query [" + empQuery + "]");
                    mStmt = mConnection.prepareStatement(empQuery);
                    mStmt.setString(1, empCode);
                    rs = mStmt.executeQuery();
                    if (rs.next()) {
                        empName = this.checkNull(rs.getString("NAME"));
                    }
                    this.userNameMap.put(empCode, empName);
                    rs.close();
                    rs = null;
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception :EventLogInfoBean :getEmpName() :==>\n" + e.getMessage());
                    try {
                        if (mConnection != null) {
                            if (mStmt != null) {
                                mStmt.close();
                                mStmt = null;
                            }
                            mConnection.close();
                            mConnection = null;
                        }
                    }
                    catch (Exception e2) {
                        BaseLogger.log("0", null, null, "Exception :EventLogInfoBean :getEmpName() :==>finally" + e2.getMessage());
                    }
                }
            }
            finally {
                try {
                    if (mConnection != null) {
                        if (mStmt != null) {
                            mStmt.close();
                            mStmt = null;
                        }
                        mConnection.close();
                        mConnection = null;
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception :EventLogInfoBean :getEmpName() :==>finally" + e.getMessage());
                }
            }
        }
        return empName;
    }

    private String getLockType(String execType) {
        String lockType = "";
        if ("E".equalsIgnoreCase(execType)) {
            lockType = "ENTERPRISE";
        } else if ("S".equalsIgnoreCase(execType)) {
            lockType = "SITE";
        } else if ("T".equalsIgnoreCase(execType)) {
            lockType = "TRANSACTION";
        }
        return lockType;
    }

    private String getSiteCode(String userKey) {
        String loginSite = "";
        try {
            if (this.userSiteMap != null && this.userSiteMap.containsKey(userKey)) {
                loginSite = this.userSiteMap.get(userKey);
            } else {
                DBAccessEJB dbAccessEjb = new DBAccessEJB();
                String condition = " CODE = '" + userKey + "' ";
                loginSite = dbAccessEjb.getDBColumnValue("USERS", "SITE_CODE__DEF", condition);
                dbAccessEjb = null;
                this.userSiteMap.put(userKey, loginSite);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return loginSite;
    }

    private String getTransDB(String userCode) {
        String loginSite = "";
        try {
            if (this.userTransDBMap != null && this.userTransDBMap.containsKey(userCode)) {
                loginSite = this.userTransDBMap.get(userCode);
            } else {
                DBAccessEJB dbAccessEjb = new DBAccessEJB();
                String condition = " CODE = '" + userCode + "' ";
                loginSite = dbAccessEjb.getDBColumnValue("USERS", "TRANS_DB", condition);
                dbAccessEjb = null;
                this.userTransDBMap.put(userCode, loginSite);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return loginSite;
    }

    private String checkNull(String input) {
        if (input == null || "null".equalsIgnoreCase(input)) {
            input = "";
        }
        return input.trim();
    }

    private String getFormNum(String formNo) {
        String formNum = null;
        String[] eventForm = null;
        if (formNo.contains("EventContext:")) {
            eventForm = formNo.split("EventContext:");
            if (!eventForm[1].substring(1, 2).equalsIgnoreCase("n")) {
                formNum = eventForm[1].substring(1, 2);
            }
        } else if (formNo.contains("objContext:")) {
            eventForm = formNo.split("objContext:");
            if (!eventForm[1].substring(1, 2).equalsIgnoreCase("n")) {
                formNum = eventForm[1].substring(1, 2);
            }
        } else if (formNo.contains("pageContext:")) {
            eventForm = formNo.split("pageContext:");
            if (!eventForm[1].substring(1, 2).equalsIgnoreCase("n")) {
                formNum = eventForm[1].substring(1, 2);
            }
        } else if (formNo.contains("domId:") && !(eventForm = formNo.split("domId:"))[1].substring(1, 2).equalsIgnoreCase("n")) {
            formNum = eventForm[1].substring(1, 2);
        }
        return formNum;
    }

    public String getPrimaryKeyValue(Node activityAction) {
        String returnPrimaryKeyVal = "NA";
        NodeList childNL = activityAction.getChildNodes();
        int childLen = childNL.getLength();
        int index = 0;
        while (index < childLen) {
            Node node = childNL.item(index);
            String nodeName = node.getNodeName();
            if ("EVENT_ID".equals(nodeName)) {
                NodeList eventNL = node.getChildNodes();
                int eventLen = eventNL.getLength();
                int eventNLIndex = 0;
                while (eventNLIndex < eventLen) {
                    Node eventChildNode = eventNL.item(eventNLIndex);
                    if ("PRIMARY_KEY".equals(eventChildNode.getNodeName())) {
                        String primaryKeyVal = "NA";
                        primaryKeyVal = eventChildNode.getFirstChild() != null ? eventChildNode.getFirstChild().getNodeValue() : eventChildNode.getNodeValue();
                        if (!(primaryKeyVal == null || "Not Applicable".equalsIgnoreCase(primaryKeyVal) || "null".equalsIgnoreCase(primaryKeyVal) || "NA".equalsIgnoreCase(primaryKeyVal))) {
                            returnPrimaryKeyVal = primaryKeyVal;
                        }
                    }
                    ++eventNLIndex;
                }
            }
            ++index;
        }
        return returnPrimaryKeyVal;
    }

    public void replacePrimaryKeyVal(String primaryKeyVal, Node activityAction) {
        NodeList childNL = activityAction.getChildNodes();
        int childLen = childNL.getLength();
        int index = 0;
        while (index < childLen) {
            Node node = childNL.item(index);
            String nodeName = node.getNodeName();
            if ("EVENT_ID".equals(nodeName)) {
                NodeList eventNL = node.getChildNodes();
                int eventLen = eventNL.getLength();
                int eventNLIndex = 0;
                while (eventNLIndex < eventLen) {
                    Node eventChildNode = eventNL.item(eventNLIndex);
                    if ("PRIMARY_KEY".equals(eventChildNode.getNodeName())) {
                        if (eventChildNode.getFirstChild() != null) {
                            eventChildNode.getFirstChild().setNodeValue(primaryKeyVal);
                        } else {
                            eventChildNode.setNodeValue(primaryKeyVal);
                        }
                    }
                    ++eventNLIndex;
                }
            }
            ++index;
        }
    }

    public void writeCompleteActivityLog(String userCode, String objName, String sessionId, String editorId, String action, String event, Date startTime, Date endTime, String argsParam, String tranId, String eventResult, String actionType, Connection conn) {
        try {
            E12GenericUtility genericUtility = new E12GenericUtility();
            editorId = "" + new Date().getTime();
            BaseLogger.log("3", null, null, "==================writeCompleteActivityLog====================editorId[" + editorId + "]");
            String complActionResult = this.getObjDetails(objName, "COMPL_ACTION", null, userCode, null);
            boolean isExistComplAction = false;
            String[] complActionResultSplitArry = complActionResult.split(",");
            int i = 0;
            while (i < complActionResultSplitArry.length) {
                String complAction = complActionResultSplitArry[i].trim();
                if (complAction.equalsIgnoreCase(this.activityDescr)) {
                    isExistComplAction = true;
                    break;
                }
                ++i;
            }
            StringBuffer sb = new StringBuffer();
            sb.append("<ACTIVITY USER_ID='").append(userCode).append("'>\n");
            sb.append("<ACTIVITY_OBJECT> <![CDATA[").append(objName).append("]]></ACTIVITY_OBJECT>\n");
            sb.append("<ACTIVITY_SESSION_ID> <![CDATA[").append(sessionId).append("]]></ACTIVITY_SESSION_ID>\n");
            sb.append("<ACTIVITY_ACTION>\n");
            sb.append("<ACTIVITY_DESCRP> <![CDATA[").append(action).append("]]></ACTIVITY_DESCRP>\n");
            sb.append("<ACTION_TYPE> <![CDATA[").append(actionType).append("]]></ACTION_TYPE>\n");
            sb.append("<ACTIVITY_EDITOR> <![CDATA[").append(editorId).append("]]></ACTIVITY_EDITOR>\n");
            sb.append("<EVENT_ID id='1'>\n");
            sb.append("<EVENT_DESCRP><![CDATA[").append(event).append("]]></EVENT_DESCRP>\n");
            sb.append("<ARG_PARAM><![CDATA[").append("NA").append("]]></ARG_PARAM>\n");
            sb.append("<ACCESS_START_TIME><![CDATA[").append(this.getValidDateTimeString(startTime, genericUtility.getApplDateTimeFormat())).append("]]></ACCESS_START_TIME>\n");
            sb.append("<ACCESS_END_TIME><![CDATA[").append(this.getValidDateTimeString(endTime, genericUtility.getApplDateTimeFormat())).append("]]></ACCESS_END_TIME>\n");
            sb.append("<PRIMARY_KEY><![CDATA[").append(tranId).append("]]></PRIMARY_KEY>\n");
            sb.append("<EVENT_RESULT><![CDATA[").append(eventResult).append("]]></EVENT_RESULT>\n");
            sb.append("</EVENT_ID>\n");
            if (isExistComplAction) {
                sb.append("<COMPL_ACTION><![CDATA[").append("1").append("]]></COMPL_ACTION>\n");
            }
            sb.append("</ACTIVITY_ACTION>\n");
            sb.append("</ACTIVITY>\n\n");
            this.writeUserActivityUsingLogger(sb.toString());
            String logPath = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "server" + File.separator + "default" + File.separator + "UserActivity";
            File file = new File(String.valueOf(logPath) + File.separator + userCode + "_" + new SimpleDateFormat("yyyyMMdd").format(new Date()) + ".txt");
            File userFolder = new File(logPath);
            boolean isDirExist = false;
            isDirExist = !userFolder.exists() ? userFolder.mkdir() : true;
            if (isDirExist) {
                if (!file.exists()) {
                    BaseLogger.log("3", null, null, "New File created.....");
                    file.createNewFile();
                }
                FileWriter fos = new FileWriter(file, true);
                fos.write(sb.toString());
                fos.flush();
                fos.close();
                BaseLogger.log("3", null, null, "Activity Log Saved######### :" + file);
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "==========EventLogInfoBean.java : writeCompleteActivityLog================");
            e.printStackTrace();
        }
    }

    private String getValidDateTimeString(Date dateTime, String targetDateTimeFormat) throws ITMException {
        String retDateStr = "";
        SimpleDateFormat formatter = null;
        try {
            try {
                formatter = new SimpleDateFormat(targetDateTimeFormat);
                String strDate = formatter.format(dateTime);
                String nanoSecs = "" + dateTime.getTime();
                nanoSecs = nanoSecs.substring(nanoSecs.length() - 3, nanoSecs.length());
                retDateStr = String.valueOf(strDate) + "." + nanoSecs;
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception :UserEventLogEJB :getValidDateTimeString :==>" + e.getMessage());
                throw new ITMException(e);
            }
        }
        finally {
            formatter = null;
        }
        BaseLogger.log("2", null, null, "retDateStr :" + retDateStr);
        return retDateStr;
    }

    public void removeObjectActivity(String objName, String sessionId) {
        try {
            LinkedHashMap objectActivityMap;
            LinkedHashMap userEventLogMap = null;
            ArrayList keyValues = new ArrayList();
            if (UserEventLogEJB.eventActivityMap != null && (userEventLogMap = (LinkedHashMap)UserEventLogEJB.eventActivityMap.get(this.userCode)) != null && (objectActivityMap = (LinkedHashMap)userEventLogMap.get(String.valueOf(sessionId) + "~SEP~" + objName)) != null) {
                if ("2".equals(CommonConstants.USER_LOG)) {
                    this.writeLogToFile(objName, sessionId, (LinkedHashMap)userEventLogMap.get(String.valueOf(sessionId) + "~SEP~" + objName));
                }
                Iterator itr = objectActivityMap.keySet().iterator();
                Set actionkeys = objectActivityMap.keySet();
                ArrayList<String> keyToRemove = new ArrayList<String>();
                for (String editorIdkey : actionkeys) {
                    ArrayList<Integer> removeIndexFromList = new ArrayList<Integer>();
                    LinkedList editorActivityList = (LinkedList)objectActivityMap.get(editorIdkey);
                    LinkedHashMap eventDetailMap = new LinkedHashMap();
                    int i = 0;
                    while (i < editorActivityList.size()) {
                        eventDetailMap = (LinkedHashMap)editorActivityList.get(i);
                        if (eventDetailMap.size() > 0) {
                            if (eventDetailMap.containsValue("Success")) {
                                removeIndexFromList.add(i);
                            } else {
                                eventDetailMap.put("IS_WRITETOFILE", "false");
                            }
                        }
                        ++i;
                    }
                    i = removeIndexFromList.size();
                    while (i > 0) {
                        int k = (Integer)removeIndexFromList.get(i - 1);
                        editorActivityList.remove(k);
                        --i;
                    }
                    if (editorActivityList.size() != 0) continue;
                    keyToRemove.add(editorIdkey);
                }
                int i = 0;
                while (i < keyToRemove.size()) {
                    String key = (String)keyToRemove.get(i);
                    if (objectActivityMap.containsKey(key)) {
                        objectActivityMap.remove(key);
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            E12GenericUtility gn = new E12GenericUtility();
            BaseLogger.log("0", null, null, "Exception in removeObjectActivity....2027[" + gn.writePrintStacktrace(e) + "]");
            e.printStackTrace();
        }
    }

    private void writeUserActivity(String objName, String sessionId, String transDB) {
        ArrayList<String> userActivityList = new ArrayList<String>();
        try {
            userActivityList.add(this.userCode);
            userActivityList.add(this.userEventEJB.getObjNameDescr(objName, transDB, null));
            userActivityList.add(objName);
            LinkedHashMap userEventLogMap = null;
            if (UserEventLogEJB.eventActivityMap != null) {
                userEventLogMap = (LinkedHashMap)UserEventLogEJB.eventActivityMap.get(this.userCode);
            }
            LinkedHashMap objectActivityMap = (LinkedHashMap)userEventLogMap.get(String.valueOf(sessionId) + "~SEP~" + objName);
            ArrayList<String> activityList = null;
            String[] activityEditor = null;
            HashMap<Integer, ArrayList<String>> activityListMap = new HashMap<Integer, ArrayList<String>>();
            Iterator itr = objectActivityMap.keySet().iterator();
            while (itr.hasNext()) {
                String objectActivitykey = this.checkNull((String)itr.next());
                LinkedList editorActivityList = (LinkedList)objectActivityMap.get(objectActivitykey);
                if (editorActivityList == null) continue;
                int listSize = editorActivityList.size();
                BaseLogger.log("3", null, null, "listSize : [" + listSize + "]");
                int cnt = 0;
                while (cnt < listSize) {
                    LinkedHashMap detailMap = (LinkedHashMap)editorActivityList.get(cnt);
                    if (detailMap != null && detailMap.size() > 0 && !detailMap.containsKey("IS_WRITETOFILE")) {
                        activityList = new ArrayList<String>();
                        activityEditor = objectActivitykey.split("_");
                        activityList.add(activityEditor[0]);
                        activityList.add(activityEditor[1]);
                        activityList.add("" + (cnt + 1));
                        activityList.add(this.userEventEJB.getEventDescr((String)detailMap.get("EVENT"), transDB));
                        activityList.add((String)detailMap.get("ACCESS_TIME"));
                        activityList.add((String)detailMap.get("COMPL_TIME"));
                        activityList.add((String)detailMap.get("TRAN_ID"));
                        activityList.add((String)detailMap.get("EVENT_RESULT"));
                        activityList.add(transDB);
                        activityList.add((String)detailMap.get("ARG_PARAM"));
                        activityList.add((String)detailMap.get("ACTION_TYPE"));
                        activityList.add((String)detailMap.get("EXCEPTION_MSG"));
                        activityListMap.put(cnt + 1, activityList);
                    }
                    ++cnt;
                }
            }
            this.writeAllUserActivityData(userActivityList, activityListMap, sessionId);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "In the WriteUserActivity ITMException : [" + e.getMessage() + "]");
            e.printStackTrace();
        }
    }

    private void writeAllUserActivityData(ArrayList<String> userActivityList, HashMap<Integer, ArrayList<String>> rows, String sessionId) {
        HashMap<Integer, ArrayList<String>> completeData = new HashMap<Integer, ArrayList<String>>();
        ArrayList<String> completeList = null;
        for (Map.Entry<Integer, ArrayList<String>> entry : rows.entrySet()) {
            int editorkey = entry.getKey();
            ArrayList<String> editorIDList = entry.getValue();
            completeList = new ArrayList<String>();
            completeList.addAll(userActivityList);
            completeList.addAll(editorIDList);
            completeList.add(sessionId);
            completeData.put(editorkey, completeList);
        }
        UserActivityLogger.log(completeData, this.userCode);
    }

    private void writeUserActivityUsingLogger(String xmlContent) {
        E12GenericUtility genericUtility = new E12GenericUtility();
        try {
            Document dom1 = genericUtility.parseString(xmlContent);
            NodeList activityNL = dom1.getElementsByTagName("ACTIVITY");
            int activityLen = activityNL.getLength();
            int activityCtr = 0;
            while (activityCtr < activityLen) {
                Node node = activityNL.item(activityCtr);
                if (node != null) {
                    String nodeName;
                    HashMap<String, String> activityDetails = new HashMap<String, String>();
                    String userId = node.getAttributes().getNamedItem("USER_ID").getNodeValue();
                    activityDetails.put("USER_ID", userId);
                    NodeList childNL = node.getChildNodes();
                    int childLen = childNL.getLength();
                    int childIndex = 0;
                    while (childIndex < childLen) {
                        Node childNode = childNL.item(childIndex);
                        if (childNode != null && childNode.getNodeType() == 1) {
                            nodeName = childNode.getNodeName();
                            String nodeValue = "";
                            if (!"ACTIVITY_ACTION".equals(nodeName) && childNode.getFirstChild() != null) {
                                nodeValue = this.checkNull(childNode.getFirstChild().getNodeValue());
                            }
                            activityDetails.put(nodeName, nodeValue);
                        }
                        ++childIndex;
                    }
                    childNL = node.getChildNodes();
                    childLen = childNL.getLength();
                    childIndex = 0;
                    while (childIndex < childLen) {
                        Node activityActionNode = childNL.item(childIndex);
                        if (activityActionNode != null && activityActionNode.getNodeType() == 1 && "ACTIVITY_ACTION".equals(nodeName = activityActionNode.getNodeName())) {
                            HashMap<String, HashMap<String, String>> activityActionEventsDetails = this.getActivityActionDetails(activityActionNode, activityDetails);
                            UserActivityLogger.log(userId, activityActionEventsDetails);
                            break;
                        }
                        ++childIndex;
                    }
                }
                ++activityCtr;
            }
        }
        catch (ITMException e) {
            BaseLogger.log("0", null, null, "ITMException :: writeUserActivityUsingLogger : [" + e.getMessage() + "]");
            e.printStackTrace();
        }
        catch (DOMException e) {
            BaseLogger.log("0", null, null, "DOMException :: writeUserActivityUsingLogger : [" + e.getMessage() + "]");
            e.printStackTrace();
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :: writeUserActivityUsingLogger : [" + e.getMessage() + "]");
            e.printStackTrace();
        }
    }

    private HashMap<String, HashMap<String, String>> getActivityActionDetails(Node activityActionNode, HashMap<String, String> activityActionDetails) {
        String nodeName;
        HashMap<String, HashMap<String, String>> activityActionEventsDetails = new HashMap<String, HashMap<String, String>>();
        NodeList activityNL = activityActionNode.getChildNodes();
        int activityActionNodeLen = activityNL.getLength();
        int activityActCtr = 0;
        while (activityActCtr < activityActionNodeLen) {
            Node childNode = activityNL.item(activityActCtr);
            if (childNode != null && childNode.getNodeType() == 1) {
                nodeName = childNode.getNodeName();
                String nodeValue = "";
                if (!"EVENT_ID".equals(nodeName) && childNode.getFirstChild() != null) {
                    nodeValue = this.checkNull(childNode.getFirstChild().getNodeValue());
                }
                activityActionDetails.put(nodeName, nodeValue);
            }
            ++activityActCtr;
        }
        activityActCtr = 0;
        while (activityActCtr < activityActionNodeLen) {
            Node activityActionEventNode = activityNL.item(activityActCtr);
            if (activityActionEventNode != null && activityActionEventNode.getNodeType() == 1 && "EVENT_ID".equals(nodeName = activityActionEventNode.getNodeName())) {
                String eventId = activityActionEventNode.getAttributes().getNamedItem("id").getNodeValue();
                activityActionDetails.put("EVENT_ID", eventId);
                HashMap<String, String> activityActionEventDetails = new HashMap<String, String>();
                activityActionEventDetails.putAll(activityActionDetails);
                this.getActivityActionEventDetails(activityActionEventNode, activityActionEventDetails);
                activityActionEventsDetails.put(eventId, activityActionEventDetails);
            }
            ++activityActCtr;
        }
        return activityActionEventsDetails;
    }

    private void getActivityActionEventDetails(Node activityActionEventNode, HashMap<String, String> activityActionEventDetails) {
        NodeList activityNL = activityActionEventNode.getChildNodes();
        int activityActionEventNodeLen = activityNL.getLength();
        int activityActEvtCtr = 0;
        while (activityActEvtCtr < activityActionEventNodeLen) {
            Node childNode = activityNL.item(activityActEvtCtr);
            if (childNode != null && childNode.getNodeType() == 1) {
                String nodeName = childNode.getNodeName();
                String nodeValue = "";
                if (childNode.getFirstChild() != null) {
                    nodeValue = this.checkNull(childNode.getFirstChild().getNodeValue());
                }
                activityActionEventDetails.put(nodeName, nodeValue);
            }
            ++activityActEvtCtr;
        }
    }
}

