//Coding by Vidhya Prabhu on 24/06/09
package ibase.webitm.ejb.wsfa.transactions;

import ibase.ejb.CommonDBAccessEJB;
import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.webitm.bean.wsfa.StrgMeetWizardBean;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ITMDBAccessLocal;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.ejb.dis.DistCommon;
//import ibase.webitm.utility.GenericUtility;//changed by rahul 10-apr-2015
import ibase.utility.E12GenericUtility; //changed by rahul on 10-apr-2015
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;

import java.net.InetAddress;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;

import javax.naming.InitialContext;

import org.jboss.ejb3.remoting.IsLocalInterceptor;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

//@javax.ejb.Stateless      commented by Sagar M [22 Nov 2018].
public class StrgMeetPRWizard extends ValidatorEJB implements StrgMeetDCRWizardLocal, StrgMeetDCRWizardRemote
{
	static int domID = 1;

	//Validation Start*********
	//Changed By Vidhya on 25/11/09[WS89NOV655 | separate method for validation in 'RIA'] Start
	public String wfValSalesPersActRIA(Document dom, Document dom2, String currentFormNo, String userId) throws ITMException
	{
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;

		//changed by Rahul Barve on 10-Apr-2015
		//GenericUtility genericUtility = GenericUtility.getInstance();
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

		String errString = "";
		String checkSQL = "";
		String childNodeName = "";
		String columnValue = "";

		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		ResultSet rSet = null ;

		ITMDBAccessEJB itmDBAccessLocal = null;// modified by kailash.

		int noOfChilds = 0;
		try
		{
			/*ConnDriver connDriver =new ConnDriver();
			connectionObject = connDriver.getConnectDB("DriverValidator");*/
			connectionObject = getConnection();//chnged by sachin satre on [11-nov-16] to get connection

			AppConnectParm appConnect = new AppConnectParm();
			Properties p = appConnect.getProperty();
			InitialContext ctx = new InitialContext(p);
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[Start]
			//itmDBAccessLocal = (ITMDBAccessLocal)ctx.lookup("ibase/ITMDBAccessEJB/local");
			itmDBAccessLocal = new ITMDBAccessEJB();
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[End]

			parentList = dom.getElementsByTagName("Detail"+ currentFormNo);
			int parentNodeListLength = parentList.getLength();
			System.out.println("parentNodeListLength["+parentNodeListLength+"]");

			for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
			{
				parentNode = parentList.item(prntCtr);
				childList = parentNode.getChildNodes();
				noOfChilds = childList.getLength();
				for (int ctr = 0; ctr < noOfChilds; ctr++)
				{
					childNode = childList.item(ctr);
					if( childNode.getNodeType() != Node.ELEMENT_NODE )
					{
						continue;
					}

					if ( childNode != null && childNode.getFirstChild() != null )
					{
						columnValue = childNode.getFirstChild().getNodeValue();
					}
					childNodeName = childNode.getNodeName();

					if(childNodeName.equalsIgnoreCase("event_date"))
					{
						if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
								( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
						{
							errString = itmDBAccessLocal.getErrorString("event_date","NULLEVTCOD",userId);
							break;
						}
						else //to validate future date and holidays
						{
							//SimpleDateFormat sdfFormat = new SimpleDateFormat("dd/MM/yyyy");//commented by vinayak
							SimpleDateFormat sdfFormat = new SimpleDateFormat(getApplDateFormat());//Added by vinayak to set Date Format on [03/10/2016]

							String evtdat= childNode.getFirstChild().getNodeValue();
							java.util.Date eventDate = sdfFormat.parse( evtdat);
							//Changed By Vidhya on 09/12/09[WS89NOV647 | date validation for 00/00/00] Start
							if (!sdfFormat.format(eventDate).equals(evtdat))
							{
								errString = itmDBAccessLocal.getErrorString( "event_date", "INVDTFRMT", userId );
								break;
							}
							//Changed By Vidhya on 09/12/09[WS89NOV647 | date validation for 00/00/00] End

							if ( ( eventDate.compareTo( getDateObject( sdfFormat.format( new Date() ) ) ) ) > 0 )
							{
								errString = itmDBAccessLocal.getErrorString( "event_date", "FUTUREVENT", userId );
								break;
							}

							int allowDays = 0;
							checkSQL = "SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME ='MAX_ALLOW_PRD_MEET'";
							pstmt = connectionObject.prepareStatement(checkSQL);
							rSet = pstmt.executeQuery( checkSQL );
							if( rSet.next() )
							{
								allowDays = rSet.getInt("PROP_VALUE");
								System.out.println("allowDays Exist In Properties are ["+allowDays+"]");
								java.util.Calendar cal = java.util.Calendar.getInstance();
								cal.setTime( getDateObject( sdfFormat.format( new Date() ) ) );
								cal.add( cal.DATE, -allowDays );
								if( eventDate.before( cal.getTime() ) )
								{
									errString = itmDBAccessLocal.getErrorString( "event_date" , "XCIDMITLMT" , userId );
									break;
								}
							}
							if (rSet!= null)
							{
								rSet.close();
								rSet = null;
							}
							if(pstmt!=null)
							{
								pstmt.close();
								pstmt = null;
							}

							//for checking Holiday
							String salesPers = genericUtility.getColumnValue( "sales_pers" , dom );
							if( salesPers != null && evtdat != null )
							{
								errString = valHoliday( evtdat, salesPers, userId, itmDBAccessLocal, connectionObject);
								if(errString != null && errString.length()>0 && errString.indexOf("ERRORS")!=-1)
								{
									errString = itmDBAccessLocal.getErrorString("event_date","HOLIDAY",userId);
									System.out.println("Holiday!");
									break;

								}
							}

						}

					}
					else if(childNodeName.equalsIgnoreCase("activity_code"))
					{
						if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
						{

							errString = itmDBAccessLocal.getErrorString("activity_code", "NULLACTCOD",userId);
							break;
						}
						else
						{
							if (columnValue.trim().length() > 2)
							{
								errString = itmDBAccessLocal.getErrorString("activity_code","LENGTH",userId);
								break;
							}
							else
							{
								checkSQL = "SELECT COUNT(1) COUNT FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ?";
								pstmt = connectionObject.prepareStatement(checkSQL);
								pstmt.setString(1,checkNull(columnValue));
								rSet = pstmt.executeQuery();
								if(rSet.next() && rSet.getInt("COUNT") < 1 )
								{
									errString = itmDBAccessLocal.getErrorString("activity_code","INVEVET",userId);
									break;
								}

								if (rSet!= null)
								{
									rSet.close();
									rSet = null;
								}
								if(pstmt!=null)
								{
									pstmt.close();
									pstmt = null;
								}
								String eventDate = genericUtility.getColumnValue( "event_date" , dom );

								if(eventDate == null || eventDate.trim().length() == 0 || "null".equalsIgnoreCase(eventDate))
								{
									errString = itmDBAccessLocal.getErrorString("event_date","NULLEVTCOD",userId);
									break;
								}

								String salesPers = genericUtility.getColumnValue( "sales_pers" , dom );
								String pDate = "";
								try
								{
									//pDate = genericUtility.getValidDateString( eventDate , getApplDateFormat() , "dd-MMM-yyyy");//Shahu - 27/10/12
									pDate = genericUtility.getValidDateTimeString( eventDate , getApplDateFormat() , getDBDateFormat());//Shahu - 27/10/12
								}
								catch ( Exception e )
								{
									System.out.println("------------- INVALIDFRMT ---------------");
									errString = itmDBAccessLocal.getErrorString( "event_date", "INVDTFRMT", userId );
									break;
								}
								checkSQL = "SELECT ACTIVITY_TYPE FROM STRG_MEET,FIELDACTIVITY WHERE EVENT_DATE=? AND SALES_PERS=?  AND FIELDACTIVITY.ACTIVITY_CODE = STRG_MEET.EVENT_TYPE";
								pstmt = connectionObject.prepareStatement(checkSQL);
								//pstmt.setString(1, pDate);//Shahu - 27/10/12
								pstmt.setTimestamp(1, java.sql.Timestamp.valueOf(pDate));//Shahu - 27/10/12
								pstmt.setString(2, salesPers);
								rSet = pstmt.executeQuery();
								if( rSet.next() )
								{
									String activityType = rSet.getString(1);
									activityType = checkNull(activityType).toUpperCase();
									System.out.println("activityType######["+activityType+"]");
									if(activityType.indexOf("LEAVE")!=-1 )
									{
										checkSQL = " SELECT ACTIVITY_TYPE FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ? ";
										pstmt = connectionObject.prepareStatement(checkSQL);
										pstmt.setString(1, columnValue);
										rSet = pstmt.executeQuery();
										if( rSet.next() )
										{
											if(!activityType.equalsIgnoreCase(rSet.getString(1)))
											{
												errString = itmDBAccessLocal.getErrorString( "event_type", "EPLANLEAVE", userId );
												break;
											}
										}
										if (rSet!= null)
										{
											rSet.close();
											rSet = null;
										}
										if(pstmt!=null)
										{
											pstmt.close();
											pstmt = null;
										}
									}
									//else if (!(activtyType.equalsIgnoreCase("FW") && activityType.equalsIgnoreCase("LEAVE")))
									else if (activityType.indexOf("NFW")!=-1)
									{
										checkSQL = " SELECT ACTIVITY_TYPE FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ? ";
										pstmt = connectionObject.prepareStatement(checkSQL);
										pstmt.setString(1, columnValue);
										rSet =pstmt.executeQuery();
										if( rSet.next() )
										{
											if(!activityType.equalsIgnoreCase(rSet.getString(1)))
											{
												errString = itmDBAccessLocal.getErrorString( "event_type", "EPLANNFW", userId );
												break;
											}
										}
										if (rSet!= null)
										{
											rSet.close();
											rSet = null;
										}
										if(pstmt!=null)
										{
											pstmt.close();
											pstmt = null;
										}
									}
									else if (activityType.indexOf("FW")!=-1)
									{
										checkSQL = " SELECT ACTIVITY_TYPE FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ? ";
										pstmt = connectionObject.prepareStatement(checkSQL);
										pstmt.setString(1, columnValue);
										rSet =pstmt.executeQuery();
										if( rSet.next() )
										{
											if(!activityType.equalsIgnoreCase(rSet.getString(1)))
											{
												errString = itmDBAccessLocal.getErrorString( "event_type", "EPLANFW", userId );
												break;
											}
										}
										if (rSet!= null)
										{
											rSet.close();
											rSet = null;
										}
										if(pstmt!=null)
										{
											pstmt.close();
											pstmt = null;
										}
									}

								}
								if (rSet!= null)
								{
									rSet.close();
									rSet = null;
								}
								if(pstmt!=null)
								{
									pstmt.close();
									pstmt = null;
								}
							}
						}

					}
					else if(childNodeName.equalsIgnoreCase("sales_pers"))
					{
						if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
								( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
						{
							errString = itmDBAccessLocal.getErrorString("sales_pers","NULLSPRSCD",userId);
							break;
						}
						else
						{
							if( parentNodeListLength > 1 )
							{
								errString = itmDBAccessLocal.getErrorString("sales_pers","SPRSONCE",userId);
								break;
							}

							String eventDate = genericUtility.getColumnValue( "event_date" , dom );
							String sprs = childNode.getFirstChild().getNodeValue();
							String dcrID = genericUtility.getColumnValue( "dcr_id" , dom );
							if( dcrID == null || "null".equalsIgnoreCase(dcrID) )
							{
								dcrID = "x";
							}
							checkSQL = "SELECT * FROM SALES_PERS WHERE SALES_PERS = ?";
							pstmt = connectionObject.prepareStatement(checkSQL);
							pstmt.setString(1,checkNull(sprs));
							rSet = pstmt.executeQuery();
							if(!rSet.next())
							{
								errString = itmDBAccessLocal.getErrorString("sales_pers","WRGSPRSCD",userId);
								break;
							}

							/* Changed by Danish on 10/1/2009 [ Not to validate anymore as to get data for edit ] Uncommented for the moment
							checkSQL = "SELECT COUNT(1) COUNT FROM SPRS_ACT_TRAN WHERE SALES_PERS = ? AND EVENT_DATE = ? AND DCR_ID <> ?";
							pstmt = connectionObject.prepareStatement(checkSQL);
							pstmt.setString(1,checkNull(sprs));
							pstmt.setTimestamp( 2,java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString(checkNull(eventDate),genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat())));
							pstmt.setString(3,dcrID);
							rSet = pstmt.executeQuery();
							if(rSet.next() && rSet.getInt("COUNT")>0)
							{
								errString = itmDBAccessLocal.getErrorString("sales_pers","SPRSEXIST",userId);
								break;
							}*/


							if (rSet!= null)
							{
								rSet.close();
								rSet = null;
							}
							if(pstmt!=null)
							{
								pstmt.close();
								pstmt = null;
							}
						}
					}
					else if(childNodeName.equalsIgnoreCase("sprs_route_stan_code"))
					{
						if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
								( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
						{
							errString = itmDBAccessLocal.getErrorString("sprs_route_stan_code","NULLSTANCD",userId);
							break;
						}
					}
				}
				if(errString.indexOf("<Errors>")!=-1)
				{
					break;
				}
			}
		}
		catch(Exception e)
		{

			System.out.println ( "Exception :WsfaZuviusDsrMobileWizardEJB :wfValData():" + e.getMessage() + ":" );

			//errString = generateErrorString(genericUtility.createErrorString(e));//Commented By Dipak
			throw new ITMException(e);//Commented By Dipak

		}
		finally
		{
			try
			{
				if (rSet !=null )
				{
					rSet.close();
				}
				if(pstmt != null)
				{
					pstmt.close();
				}


				if (connectionObject != null)
				{
					connectionObject.close();
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}

		return errString;
	}
	//Changed By Vidhya on 25/11/09[ WS89NOV655 | separate method for validation in 'RIA'] END
	public String wfValLocality(Document dom, String currentFormNo, String userId) throws ITMException
	{
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;

		//changed by Rahul Barve on 10-Apr-2015
		//GenericUtility genericUtility = GenericUtility.getInstance();
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

		String errString = "";
		String columnValue = "";
		String checkSQL = "";
		String childNodeName = "";
		String errString1 = "";
		String actType = "";

		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		ResultSet rSet = null ;

		ITMDBAccessEJB itmDBAccessLocal = null;// modified by kailash.

		int ctr = 0;
		int noOfChilds = 0;

		boolean isAnyCustomerSel = false;
		boolean isDoctorSelected = false;
		boolean isChemistSelected = false;
		boolean isStockistSelected = false;
		boolean toValidateDoctor = true;
		boolean toValidateChemist = true;
		boolean toValidateStockist = true;

		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			Properties p = appConnect.getProperty();
			InitialContext ctx = new InitialContext(p);
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[Start]
			//itmDBAccessLocal = (ITMDBAccessLocal)ctx.lookup("ibase/ITMDBAccessEJB/local");
			itmDBAccessLocal = new ITMDBAccessEJB();
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[End]


			/*ConnDriver connDriver = connDriver = new ConnDriver();;
			connectionObject = connDriver.getConnectDB("DriverValidator");*/
			connectionObject = getConnection();//chnged by sachin satre on [11-nov-16] to get connection

			parentList = dom.getElementsByTagName("Detail" + currentFormNo);
			int parentNodeListLength = parentList.getLength();
			System.out.println("parentNodeListLength(wfValLocality)["+parentNodeListLength+"]");
			for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
			{
				String locDescr = getSelectedRowValue(dom, currentFormNo, "sprs_route_descr",prntCtr);
				String actCode = genericUtility.getColumnValue("activity_code", dom);
				actType = getActivityType(actCode, connectionObject);
				parentNode = parentList.item(prntCtr);
				childList = parentNode.getChildNodes();
				noOfChilds = childList.getLength();
				for (ctr = 0; ctr < noOfChilds; ctr++)
				{
					childNode = childList.item(ctr);
					if( childNode.getNodeType() != Node.ELEMENT_NODE )
					{
						continue;
					}

					if ( childNode != null && childNode.getFirstChild() != null )
					{
						columnValue = childNode.getFirstChild().getNodeValue().trim();
					}
					childNodeName = childNode.getNodeName();

					System.out.println("childNodeName ["+childNodeName+"] actType ["+actType+"]");

					if(childNodeName.equalsIgnoreCase("locality_code"))
					{
						if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) || ( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue()))||childNode.getFirstChild() == null)
						{
							errString = itmDBAccessLocal.getErrorString("locality_code","NULLLOCTCD",userId);
							break;
						}
						else
						{

							if( actType.indexOf("LEAVE")!= -1 )
							{
								if( parentNodeListLength > 1 )
								{
									errString1 = itmDBAccessLocal.getErrorString("locality_code","LOCALONCE",userId);
									break;
								}
							}
						}


					}
					else if( childNodeName.equalsIgnoreCase("travel_mode") )
					{
						if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) || ( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue()))||childNode.getFirstChild() == null)
						{
							errString = itmDBAccessLocal.getErrorString("travel_mode","NULLTRVLM",userId);
							break;
						}
						else
						{
							if(actType.indexOf("LEAVE")!=-1 )
							{
								if( !columnValue.equalsIgnoreCase("ROAD"))
								{
									errString = itmDBAccessLocal.getErrorString("travel_mode","TRMODENFW",userId);
									break;
								}
							}
						}

					}
					else if(childNodeName.equalsIgnoreCase("over_night"))
					{
						if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) || ( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue()))||childNode.getFirstChild() == null)
						{
							errString = itmDBAccessLocal.getErrorString("over_night","NULLOVRNIT",userId);
							break;
						}
						else
						{
							//if(!"FW".equalsIgnoreCase(actType))
							if( actType.indexOf("NFW")!=-1 || actType.indexOf("LEAVE")!=-1 )
							{
								if( !columnValue.equalsIgnoreCase("N"))
								{
									errString = itmDBAccessLocal.getErrorString("over_night","OVRNITENFW",userId);
									break;
								}
							}

						}

					}
					else if(childNodeName.equalsIgnoreCase("order_of_visit"))
					{
						if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) || ( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue()))||childNode.getFirstChild() == null)
						{
							errString = itmDBAccessLocal.getErrorString("order_of_visit","NULLORDVST",userId);
							break;
						}

					}
					else if ( actType.equalsIgnoreCase("FW") &&  ( "dr_visit".equalsIgnoreCase( childNodeName )  || "chem_visit".equalsIgnoreCase( childNodeName ) || "stockist_visit".equalsIgnoreCase( childNodeName ) ) )
					{
						/*
						if ( columnValue != null && "Y".equalsIgnoreCase(columnValue))
						{

							isAnyCustomerSel = true;
							String selectSql = "";
							int count = 0;

							String localityCode = getSelectedRowValue(dom, currentFormNo, "locality_code",prntCtr);
							String salesPers = getSelectedRowValue(dom, currentFormNo, "sales_pers",prntCtr);

							System.out.println("Validating for "+childNodeName+" LocalityCode ["+localityCode+"] salesPers ["+salesPers+"]");

							if( "dr_visit".equalsIgnoreCase( childNodeName ) )
							{
								selectSql = "select count(1) as count from strg_series ss,strg_customer sc where sc.locality_Code = ? and ss.sales_pers= ? and ss.sc_code = sc.sc_code and sc.cust_type = 'D' and ss.status = 'Y'";

								System.out.println("selectSql ["+selectSql+"]");

								pstmt = connectionObject.prepareStatement(selectSql);
								pstmt.setString(1,localityCode);
								pstmt.setString(2,salesPers);
								rSet = pstmt.executeQuery();
								if(rSet.next())
								{
									count = rSet.getInt("count");
								}

								System.out.println("count ["+count+"]");

								if( count == 0 )
								{
									errString = itmDBAccessLocal.getErrorString( "","NODREXIST",userId );
									break;
								}
								isDoctorSelected = true;
							}
							else if( "chem_visit".equalsIgnoreCase( childNodeName ) )
							{
								selectSql = "select count(1) as count from strg_series ss,strg_customer sc where sc.locality_Code = ? and ss.sales_pers = ? and ss.sc_code = sc.sc_code and sc.cust_type = 'C' and ss.status = 'Y'";
								System.out.println("selectSql ["+selectSql+"]");

								pstmt = connectionObject.prepareStatement(selectSql);
								pstmt.setString(1,localityCode);
								pstmt.setString(2,salesPers);

								rSet = pstmt.executeQuery();
								if(rSet.next())
								{
									count = rSet.getInt("count");
								}

								System.out.println("count ["+count+"]");

								if( count == 0 )
								{
									errString = itmDBAccessLocal.getErrorString( "","NOCHMEXIST",userId );
									break;
								}
								isChemistSelected = true;
							}

						}//if ( columnValue != null && "Y".equalsIgnoreCase(columnValue))
						 */
						{

							String selectSql = "";
							int count = 0;

							String localityCode = getSelectedRowValue(dom, currentFormNo, "locality_code",prntCtr);
							String salesPers = getSelectedRowValue(dom, currentFormNo, "sales_pers",prntCtr);

							System.out.println("Validating for "+childNodeName+" LocalityCode ["+localityCode+"] salesPers ["+salesPers+"]");

							if( "dr_visit".equalsIgnoreCase( childNodeName ) )
							{
								//isDoctorSelected = true;
								selectSql = "select count(1) as count from strg_series ss,strg_customer sc where sc.locality_Code = ? and ss.sales_pers= ? and ss.sc_code = sc.sc_code and sc.cust_type = 'D' and ss.status = 'Y'";

								System.out.println("selectSql ["+selectSql+"]");

								pstmt = connectionObject.prepareStatement(selectSql);
								pstmt.setString(1,localityCode);
								pstmt.setString(2,salesPers);
								rSet = pstmt.executeQuery();
								if(rSet.next())
								{
									count = rSet.getInt("count");
								}
								//added by rakesh kumar 13/12/12
								if (rSet!= null)
								{
									rSet.close();
									rSet = null;
								}
								if(pstmt!=null)
								{
									pstmt.close();
									pstmt = null;
								}
								//ended by rakesh kumar 13/12/12

								System.out.println("count ["+count+"]");

								if (columnValue != null && "Y".equalsIgnoreCase(columnValue))
								{
									isAnyCustomerSel = true;
									isDoctorSelected = true;

									if ( count == 0 )
									{
										errString = itmDBAccessLocal.getErrorString( "","NODREXIST",userId );
										break;
									}
								}
								else if (columnValue != null && "N".equalsIgnoreCase(columnValue))
								{
									if ( count > 0 )
									{
										isDoctorSelected = false;
									}
									else
									{
										toValidateDoctor = false;
									}
								}

							}
							else if( "chem_visit".equalsIgnoreCase( childNodeName ) )
							{
								//isChemistSelected = true;
								selectSql = "select count(1) as count from strg_series ss,strg_customer sc where sc.locality_Code = ? and ss.sales_pers = ? and ss.sc_code = sc.sc_code and sc.cust_type = 'C' and ss.status = 'Y'";
								System.out.println("selectSql ["+selectSql+"]");

								pstmt = connectionObject.prepareStatement(selectSql);
								pstmt.setString(1,localityCode);
								pstmt.setString(2,salesPers);

								rSet = pstmt.executeQuery();
								if(rSet.next())
								{
									count = rSet.getInt("count");
								}
								//added by rakesh kumar 13/12/12
								if (rSet!= null)
								{
									rSet.close();
									rSet = null;
								}
								if(pstmt!=null)
								{
									pstmt.close();
									pstmt = null;
								}
								//ended by rakesh kumar 13/12/12

								System.out.println("count ["+count+"]");

								if (columnValue != null && "Y".equalsIgnoreCase(columnValue))
								{
									isAnyCustomerSel = true;
									isChemistSelected = true;

									if ( count == 0 )
									{
										errString = itmDBAccessLocal.getErrorString( "","NOCHMEXIST",userId );
										break;
									}
								}
								else if (columnValue != null && "N".equalsIgnoreCase(columnValue))
								{
									if ( count > 0 )
									{
										isChemistSelected = false;
									}
									else
									{
										toValidateChemist = false;
									}
								}
							}
							//Added by Gaurav Singh on 23-APR-2015 for validating Stockist [Start]
							else if( "stockist_visit".equalsIgnoreCase( childNodeName ) )
							{
								System.out.println("Inside stockist_visit validation");
								//isDoctorSelected = true;
								selectSql = "select count(1) as count from strg_series ss,strg_customer sc where sc.locality_Code = ? and ss.sales_pers= ? and ss.sc_code = sc.sc_code and sc.cust_type = 'S' and ss.status = 'Y'";

								System.out.println("selectSql ["+selectSql+"]");

								pstmt = connectionObject.prepareStatement(selectSql);
								pstmt.setString(1,localityCode);
								pstmt.setString(2,salesPers);
								rSet = pstmt.executeQuery();
								if(rSet.next())
								{
									count = rSet.getInt("count");
								}
								//added by rakesh kumar 13/12/12
								if (rSet!= null)
								{
									rSet.close();
									rSet = null;
								}
								if(pstmt!=null)
								{
									pstmt.close();
									pstmt = null;
								}
								//ended by rakesh kumar 13/12/12

								System.out.println("count ["+count+"]");

								if (columnValue != null && "Y".equalsIgnoreCase(columnValue))
								{
									isAnyCustomerSel = true;
									isStockistSelected = true;

									if ( count == 0 )
									{
										errString = itmDBAccessLocal.getErrorString( "","NOSTKEXIST",userId );
										break;
									}
								}
								else if (columnValue != null && "N".equalsIgnoreCase(columnValue))
								{
									if ( count > 0 )
									{
										isStockistSelected = false;
									}
									else
									{
										toValidateStockist = false;
									}
								}
								System.out.println("isAnyCustomerSel::["+isAnyCustomerSel+"] isStockistSelected :: ["+isStockistSelected+"] toValidateStockist :: ["+toValidateStockist+"]");
							}
							//Added by Gaurav Singh on 23-APR-2015 for validating Stockist [End]
						}//

					}
				}
				if( errString.indexOf("<Errors>")!=-1 || errString1.indexOf("<Errors>")!=-1 )
				{
					if( errString.length() > 0 )
					{
						String msgDescr = errString.substring(errString.indexOf("<description>")+("<description>").length(),errString.indexOf("</description>")) + " for locality " + locDescr ;

						errString = errString.substring(0, errString.indexOf("<description>")+("<description>").length()) + msgDescr + "" + errString.substring( errString.indexOf("</description>"), errString.length());
						break;
					}
					else if( errString1.length() > 0 )
					{
						errString = errString1;
						break;
					}

				}
			}

			if( errString == null || errString.trim().length() == 0 )
			{
				System.out.println("isAnyCustomerSel ["+isAnyCustomerSel+"], actType=["+actType+"], isDoctorSelected =["+isDoctorSelected+"]");
				if( ! isAnyCustomerSel && ( actType.equalsIgnoreCase("FW") ) )
				{
					errString = itmDBAccessLocal.getErrorString( "","NOCUSTSELD",userId );
				}
				else
				{
					if( ! isDoctorSelected && toValidateDoctor && ( actType.equalsIgnoreCase("FW") ) )
					{
						errString = itmDBAccessLocal.getErrorString( "","NODOCTSELD",userId );
					}

					if( ! isChemistSelected && toValidateChemist && ( actType.equalsIgnoreCase("FW") ) )
					{
						errString = itmDBAccessLocal.getErrorString( "","NOCHEMSELD",userId );
					}
					//Added by Gaurav Singh on 23-APR-2015 for validating stockist [Start]
					if( ! isStockistSelected && toValidateStockist && ( actType.equalsIgnoreCase("FW") ) )
					{
						errString = itmDBAccessLocal.getErrorString( "","NOSTKSELD",userId );
					}
					//Added by Gaurav Singh on 23-APR-2015 for validating stockist [End]
				}
			}

		}
		catch(Exception e)
		{
			System.out.println ( "Exception :WsfaZuviusDsrMobileWizardEJB :wfValData():" + e.getMessage() + ":" );
			//errString = generateErrorString(genericUtility.createErrorString(e));//Commented By Dipak
			throw new ITMException(e);//Commented By Dipak
		}
		finally
		{
			try
			{
				if (rSet!= null)
				{
					rSet.close();
					rSet = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}

				if (connectionObject != null)
				{
					connectionObject.close();
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}

		return errString;

	}

	public String wfValCustomer(Document dom, String currentFormNo, String userId) throws ITMException
	{
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;

		//changed by Rahul Barve on 10-Apr-2015
		//GenericUtility genericUtility = GenericUtility.getInstance();
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

		String errString = "";
		String errString1 = "";
		String columnValue = "";
		String checkSQL = "";
		String childNodeName = "";

		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		ResultSet rSet = null ;

		ITMDBAccessEJB itmDBAccessLocal = null;// modified by kailash.

		int ctr = 0;
		int noOfChilds = 0;



		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			Properties p = appConnect.getProperty();
			InitialContext ctx = new InitialContext(p);
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[Start]
			//itmDBAccessLocal = (ITMDBAccessLocal)ctx.lookup("ibase/ITMDBAccessEJB/local");
			itmDBAccessLocal = new ITMDBAccessEJB();
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[End]

			/*ConnDriver connDriver = connDriver = new ConnDriver();;
			connectionObject = connDriver.getConnectDB("DriverValidator");*/
			connectionObject = getConnection();//chnged by sachin satre on [11-nov-16] to get connection

			parentList = dom.getElementsByTagName("Detail" + currentFormNo);
			int parentNodeListLength = parentList.getLength();
			System.out.println("dddddd : parentNodeListLength(wfValCustomer)["+parentNodeListLength+"]");
			for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
			{
				String custName = getSelectedRowValue(dom, currentFormNo, "cust_name",prntCtr);
				parentNode = parentList.item(prntCtr);
				childList = parentNode.getChildNodes();
				noOfChilds = childList.getLength();
				for (ctr = 0; ctr < noOfChilds; ctr++)
				{
					childNode = childList.item(ctr);
					if( childNode.getNodeType() != Node.ELEMENT_NODE )
					{
						continue;
					}
					if ( childNode != null && childNode.getFirstChild() != null )
					{
						columnValue = childNode.getFirstChild().getNodeValue().trim();
					}
					childNodeName = childNode.getNodeName();
					if(childNodeName.equalsIgnoreCase("short_id"))
					{
						if((childNode.getFirstChild() == null) || (childNode.getFirstChild().getNodeValue() == null) ||
								( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
						{
							errString = itmDBAccessLocal.getErrorString("short_id","NULLMPLNID",userId);
							break;
						}

					}
					else if(childNodeName.equalsIgnoreCase("event_time_start"))
					{
						if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
								( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
						{
							errString = itmDBAccessLocal.getErrorString("event_time_start","NULEVENTTS",userId);
							break;
						}
						else
						{
							String startTime = childNode.getFirstChild().getNodeValue().trim();
							int position = startTime.indexOf(':');

							if ( position < 0 )
							{
								errString = itmDBAccessLocal.getErrorString ("event_time_start", "STIMENV", userId );
								break;
							}
							else
							{
								String hour = startTime.substring( 0, position );
								String minute = startTime.substring( position + 1, startTime.length() ).trim();
								if ( hour.length() == 2 )
								{
									if(!checkIfNumber(hour))
									{
										System.out.println("HOUR IS NOT A NUMBER!!!!");
										errString = itmDBAccessLocal.getErrorString ("event_time_start", "STINVTIME", userId);
										break;
									}
									else if ( Integer.parseInt( hour.trim() ) > 23 )
									{
										errString = itmDBAccessLocal.getErrorString ("event_time_start", "SHOURENV", userId);
										break;
									}

								}
								else
								{
									errString = itmDBAccessLocal.getErrorString ("event_time_start", "SHTIMENV", userId);
									break;
								}
								if ( minute.length() == 2 )
								{
									if(!checkIfNumber(minute))
									{
										System.out.println("MINUTE IS NOT A NUMBER!!!!");
										errString = itmDBAccessLocal.getErrorString ("event_time_start", "STINVTIME", userId);
										break;
									}
									else if ( Integer.parseInt(minute.trim()) >59 )
									{
										errString = itmDBAccessLocal.getErrorString ( "event_time_start", "SMINUTE", userId);
										break;
									}

								}
								else
								{
									errString = itmDBAccessLocal.getErrorString ("event_time_start", "SMTIMENV", userId);
									break;
								}
							}
						}

					}
					else if(childNodeName.equalsIgnoreCase("event_time_end"))
					{
						if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
								( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
						{
							errString = itmDBAccessLocal.getErrorString("event_time_end","NULEVENTTE",userId);
							break;
						}
						else
						{
							String endTime = childNode.getFirstChild().getNodeValue().trim();

							int position = endTime.indexOf(':');
							if ( position < 0 )
							{
								errString = itmDBAccessLocal.getErrorString( "event_time_end", "ETIMENV", userId);
								break;
							}
							else
							{
								String hour = endTime.substring( 0, position);
								String minute = endTime.substring( position + 1, endTime.length() ).trim();

								if (hour.length() == 2 )
								{
									if(!checkIfNumber(hour))
									{
										System.out.println("HOUR IS NOT A NUMBER!!!!");
										errString = itmDBAccessLocal.getErrorString ("event_time_end", "STINVTIME", userId);
										break;
									}
									else if ( Integer.parseInt(hour.trim()) > 23 )
									{
										errString = itmDBAccessLocal.getErrorString ("event_time_end","EHOURE",userId );
										break;
									}
								}
								else
								{
									errString = itmDBAccessLocal.getErrorString ("event_time_end","EHTIMENV",userId);
									break;
								}
								if ( minute.length() == 2 )
								{
									if(!checkIfNumber(minute))
									{
										System.out.println("MINUTE IS NOT A NUMBER!!!!");
										errString = itmDBAccessLocal.getErrorString ("event_time_end", "STINVTIME", userId);
										break;
									}
									else if ( Integer.parseInt(minute.trim()) > 59 )
									{
										errString = itmDBAccessLocal.getErrorString ("event_time_end","EMINUTE",userId);
										break;
									}
								}
								else
								{
									errString = itmDBAccessLocal.getErrorString ("event_time_end","EMTIMENV",userId);
									break;
								}
								String eventTimeStart = getSelectedRowValue(dom, currentFormNo, "event_time_start",prntCtr);

								int stPosition = eventTimeStart.indexOf(':');
								if ( stPosition < 0 )
								{
									errString = itmDBAccessLocal.getErrorString ("event_time_start","STIMENV",userId);
									break;
								}
								else
								{
									String stHoure = eventTimeStart.substring( 0, stPosition ).trim();
									String stMinute = eventTimeStart.substring( stPosition + 1, eventTimeStart.length() ).trim();

									position = endTime.indexOf(':');
									if ( position < 0 || stHoure.length() == 0 || stMinute.length() == 0 )
									{
										errString = itmDBAccessLocal.getErrorString ("event_time_end","ETIMENV",userId);
										break;
									}
									else
									{

										if ( stHoure.length() > 0 && hour.length() > 0 )
										{
											if ( Integer.parseInt(hour) < Integer.parseInt(stHoure) )
											{
												errString = itmDBAccessLocal.getErrorString ("event_time_end","ETHLSTH",userId);
												break;
											}

											if ( stHoure.equalsIgnoreCase( hour ) )
											{
												if ( stMinute.length() > 0 && minute.length() > 0 )
												{
													if ( Integer.parseInt( minute ) < Integer.parseInt( stMinute ) )
													{
														errString = itmDBAccessLocal.getErrorString ("event_time_end","ETMLSTM",userId);
														break;
													}
												}
											}
											if ( Integer.parseInt( stHoure ) == Integer.parseInt( hour ) && Integer.parseInt( stMinute ) == Integer.parseInt( minute ) )
											{
												errString = itmDBAccessLocal.getErrorString ("event_time_end","EQUAL",userId);
												break;
											}
										}
									}//End else(position)
								}//End else
							}//End else
						}
					}
					else if(childNodeName.equalsIgnoreCase("strg_code"))
					{
						String actCode = genericUtility.getColumnValue("event_type",dom);
						if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
								( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
						{
							if( actCode.equalsIgnoreCase("FW") || actCode.indexOf("FW")!= -1 )
							{
								errString1 = itmDBAccessLocal.getErrorString("strg_code","CUSTREQD",userId);
								break;

							}
							else
							{
								errString1 = itmDBAccessLocal.getErrorString("strg_code","NULSTRGCD",userId);
								break;
							}

						}
						else
						{
							String actType = getActivityType(actCode, connectionObject);
							if(actType.indexOf("LEAVE")!=-1)
							{
								if( parentNodeListLength > 1 )
								{
									errString1 = itmDBAccessLocal.getErrorString("strg_code","CUSTONCE",userId);
								}
							}

						}
					}
					else if ( "strg_type".equalsIgnoreCase( childNodeName ) )
					{
						String strgCode = genericUtility.getColumnValue( "strg_code", dom );
						//Verifying only in case "Doctor is selected"
						if(  strgCode != null &&  strgCode.length() > 0 && (   ( ! "null".equalsIgnoreCase(strgCode) ) || ( ! "-NA-".equalsIgnoreCase(strgCode) ) ) )
						{
							if ( childNode.getFirstChild() == null )
							{
								errString = itmDBAccessLocal.getErrorString("strg_type","NULSTRGT",userId);
								break;
							}

						}
					}
					else if ( "strg_class_code".equalsIgnoreCase( childNodeName ) )
					{
						String strgCode = genericUtility.getColumnValue("strg_code",dom);
						//Verifying only in case "Doctor is selected"
						if(  strgCode != null &&  strgCode.length() > 0 && (   ( ! "null".equalsIgnoreCase(strgCode) ) || ( ! "-NA-".equalsIgnoreCase(strgCode) ) ) )
						{
							if ( childNode.getFirstChild() == null )
							{
								errString = itmDBAccessLocal.getErrorString("strg_class_code","NULSTRCC",userId);
								break;
							}
						}
					}
					else if ( "strg_no_visit".equalsIgnoreCase( childNodeName ) )
					{
						String strgCode = genericUtility.getColumnValue( "strg_code", dom );
						//Verifying only in case "Doctor is selected"
						if(  strgCode != null &&  strgCode.length() > 0 && (   ( ! "null".equalsIgnoreCase(strgCode) ) || ( ! "-NA-".equalsIgnoreCase(strgCode) ) ) )
						{
							if ( childNode.getFirstChild() == null )
							{
								errString = itmDBAccessLocal.getErrorString("strg_no_visit","NULSTRGV",userId);
								break;
							}
						}
					}
					else if ( "strg_name".equalsIgnoreCase( childNodeName ) )
					{
						String strgCode = genericUtility.getColumnValue( "strg_code", dom );
						String strgType = genericUtility.getColumnValue( "strg_type", dom );
						if( strgCode == null  && strgType != null )
						{
							if ( childNode.getFirstChild() == null  )
							{
								errString = itmDBAccessLocal.getErrorString("strg_name","NULSTRGN",userId);
								break;
							}
						}
						else
						{
							if (strgCode != null && childNode.getFirstChild() != null)
							{
								errString = itmDBAccessLocal.getErrorString("strg_name","INSERTVALD",userId);
							}
						}
					}
					else if ( "order_booked".equalsIgnoreCase( childNodeName ) )
					{
						if ( childNode.getFirstChild() == null )
						{
							errString = itmDBAccessLocal.getErrorString("order_booked","ORBONONUL",userId );
							break;
						}
						else
						{
							//Changed By Vidhya on 19/11/09[WS89NOV613 | ORDER BOOKED LENGTH TO BE 6-DIGITS]
							//if( columnValue.length() > 2 )
							if( columnValue.length() > 6 )
							{
								String orderBooked =  "";
								String ordBookDec = "";
								if(columnValue.indexOf(".") != -1)
								{
									System.out.println("entered a decimal!!!!!");
									orderBooked =  columnValue.substring(0, columnValue.indexOf("."));
									ordBookDec =  columnValue.substring(columnValue.indexOf(".")+1,columnValue.length());
									if(!checkIfNumber(orderBooked) || !checkIfNumber(ordBookDec))
									{
										System.out.println("Not a number!!!!!");
										errString = itmDBAccessLocal.getErrorString( "order_booked","INVORDERBK",userId );
										break;

									}
									//Changed By Vidhya on 19/11/09[WS89NOV613 | ORDER BOOKED LENGTH TO BE 6-DIGITS]
									//else if(orderBooked.length() > 2)
									else if(orderBooked.length() > 6)
									{
										errString = itmDBAccessLocal.getErrorString( "order_booked","ORDERBKDGT",userId );
										break;
									}

								}
								else
								{
									System.out.println("Not a two-digit number!!!");
									errString = itmDBAccessLocal.getErrorString("order_booked","ORDERBKDGT",userId );
									break;

								}

							}
							else
							{
								if(!checkIfNumber(columnValue))
								{
									System.out.println("(2-dig)Not a number!!!!!");
									errString = itmDBAccessLocal.getErrorString( "order_booked","INVORDERBK",userId );
									break;

								}

							}

						}
					}

				}
				if(errString.indexOf("<Errors>")!=-1 || errString1.indexOf("<Errors>")!=-1)
				{
					if( errString.length() > 0 )
					{
						String msgDescr = "";
						msgDescr = errString.substring(errString.indexOf("<description>")+("<description>").length(),errString.indexOf("</description>")) + " for customer " + custName ;

						if( custName.length() != 0 && !custName.equalsIgnoreCase("") )
						{
							errString = errString.substring(0, errString.indexOf("<description>")+("<description>").length()) + msgDescr + "" + errString.substring( errString.indexOf("</description>"), errString.length());
						}
						break;
					}
					else if( errString1.length() > 0 )
					{
						errString = errString1;
						break;
					}

				}
			}


		}
		catch(Exception e)
		{
			System.out.println ( "Exception :WsfaZuviusDsrMobileWizardEJB :wfValData():" + e.getMessage() + ":" );

			//errString = generateErrorString(genericUtility.createErrorString(e));//Commented By Dipak
			throw new ITMException(e);//Commented By Dipak

		}
		finally
		{
			try
			{
				if (rSet!= null)
				{
					rSet.close();
					rSet = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}

				if (connectionObject != null)
				{
					connectionObject.close();
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return errString;

	}

	public String wfValItem(Document dom, Document dom2, String currentFormNo, String userId) throws ITMException
	{
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;

		//changed by Rahul Barve on 10-Apr-2015
		//GenericUtility genericUtility = GenericUtility.getInstance();
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

		String errString = "";
		String errString1 = "";
		String checkSQL = "";
		String childNodeName = "";
		String columnValue = "";

		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		ResultSet rSet = null ;

		ArrayList itemPitchList = new ArrayList();

		ITMDBAccessEJB itmDBAccessLocal = null;// modified by kailash.

		int ctr = 0;
		int noOfChilds = 0;

		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			Properties p = appConnect.getProperty();
			InitialContext ctx = new InitialContext(p);
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[Start]
			//itmDBAccessLocal = (ITMDBAccessLocal)ctx.lookup("ibase/ITMDBAccessEJB/local");
			itmDBAccessLocal = new ITMDBAccessEJB();
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[End]

			/*ConnDriver connDriver = connDriver = new ConnDriver();
			connectionObject = connDriver.getConnectDB("DriverValidator");*/
			connectionObject = getConnection();//chnged by sachin satre on [11-nov-16] to get connection

			parentList = dom.getElementsByTagName("Detail" + currentFormNo);
			int parentNodeListLength = parentList.getLength();
			System.out.println("parentNodeListLength(wfValItem)["+parentNodeListLength+"]");
			for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
			{
				String custCode = getSelectedRowValue(dom, currentFormNo, "strg_code",prntCtr);
				String sprsProdGrp = getSelectedRowValue(dom, currentFormNo, "sales_prod_grp", prntCtr);
				String itemCode = getSelectedRowValue(dom, currentFormNo, "item_code",prntCtr);
				String itemDescr = getSelectedRowValue(dom, currentFormNo, "item_descr",prntCtr);
				parentNode = parentList.item(prntCtr);
				childList = parentNode.getChildNodes();
				noOfChilds = childList.getLength();
				for (ctr = 0; ctr < noOfChilds; ctr++)
				{
					childNode = childList.item(ctr);
					if( childNode.getNodeType() != Node.ELEMENT_NODE )
					{
						continue;
					}
					if ( childNode != null && childNode.getFirstChild() != null )
					{
						columnValue = childNode.getFirstChild().getNodeValue().trim();
					}
					childNodeName = childNode.getNodeName();
					if(childNodeName.equalsIgnoreCase("item_code"))
					{
						if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) || ( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
						{
							if(sprsProdGrp == null || "null".equalsIgnoreCase(sprsProdGrp))
							{
								errString = itmDBAccessLocal.getErrorString("item_code","NULLITEMCD",userId);
								break;
							}
						}
					}

					else if ( "quantity".equalsIgnoreCase( childNodeName ) )
					{
						System.out.println("quantity(wfValItem)::::::");

						if ( (childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) || ( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())) )
						{
							errString = itmDBAccessLocal.getErrorString("quantity","NULQUACD",userId);
							break;
						}
						else
						{

							if( Integer.parseInt( columnValue ) > 0 )
							{
								if( sprsProdGrp.length() != 0 && !"null".equalsIgnoreCase(sprsProdGrp) )
								{
									errString = itmDBAccessLocal.getErrorString("quantity","INVLQUANT",userId);
									break;
								}

							}
							else if(!( Integer.parseInt( columnValue ) > 0 ))
							{
								if( itemCode.length() != 0 && !"null".equalsIgnoreCase(itemCode) )
								{
									errString = itmDBAccessLocal.getErrorString("quantity","QUANTREQD",userId);
									break;
								}

							}
						}

					}

				}
				if( errString.indexOf("<Errors>")!=-1 || errString1.indexOf("<Errors>")!=-1)
				{
					if( errString.length() > 0 )
					{
						errString = getItemErrorString( errString,  custCode, itemDescr, itemCode, sprsProdGrp,connectionObject); //Chnaged by sachin satre on 09-nov-16
						break;
					}
					else if( errString1.length() > 0 )
					{
						errString = errString1;
						break;
					}
				}
			}
			itemPitchList.clear();

		}
		catch(Exception e)
		{
			System.out.println ( "Exception :wfValItem :wfValData():" + e.getMessage() + ":" );
			//errString = generateErrorString(genericUtility.createErrorString(e));//Commented By Dipak
			throw new ITMException(e);//Commented By Dipak

		}
		finally
		{
			try
			{
				if (rSet!= null)
				{
					rSet.close();
					rSet = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}


				if (connectionObject != null)
				{
					connectionObject.close();
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return errString;

	}
	//Validation End*********

	//Getting Default Values for forms Start*********
	//Changed By Vidhya on 15/10/09[WI89BAS033 | changing signature ]
	//public String getSalesPers(Document dom, String currentForm, String userId, String salesPers, String actCode, String trvDate) throws ITMException
	public String getSalesPers(Document dom, Document dom2, String currentForm, String userId, String salesPers, String actCode, String trvDate) throws ITMException
	{
		ResultSet rs = null;
		Connection connectionObject = null;
		Statement stmt = null;

		String sql = "";
		String currDate = "";
		String chgTerm ="";
		String preFormDet ="";
		String actDescr = "";
		StringBuffer valueXmlString = new StringBuffer();
		boolean flag = false;
		//Changed By Vidhya on 15/10/09[WI89BAS033 | Changing signature]
		ArrayList temp = new ArrayList();

		//changed by Rahul Barve on 10-Apr-2015
		//GenericUtility genericUtility = GenericUtility.getInstance();
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		try
		{
			InetAddress ownIP=InetAddress.getLocalHost();
			chgTerm = ownIP.getHostAddress();

			DateFormat dtFormat = new SimpleDateFormat(getApplDateFormat());
			java.util.Date date = Calendar.getInstance().getTime();
			currDate = dtFormat.format( date );
			System.out.println("SalesPerson  (getSalesPers)> "+salesPers);
			if( salesPers != null && salesPers.trim().length() > 0 && !salesPers.equalsIgnoreCase("") )
			{
				salesPers = salesPers.trim().toUpperCase();
			}
			/*ConnDriver connDriver = new ConnDriver();
			connectionObject = connDriver.getConnectDB( "DriverValidator" );*/
			connectionObject = getConnection();//chnged by sachin satre on [11-nov-16] to get connection

			//to append previous values of current form from current dom on previous action
			flag = preDomExists( dom, currentForm );
			System.out.println( "history detail exists["+ flag +"]" );
			if( flag )
			{
				//Changed By Vidhya on 15/10/09[WI89BAS033 | Changing signature]Start
				//preFormDet = getPrevFormValues( dom, currentForm, domID );
				preFormDet = getPrevFormValues( dom, currentForm, temp , "sales_pers");
				Document preFormDom =  genericUtility.parseString("<Root>"+preFormDet+"</Root>");
				String actCodePreDom = genericUtility.getColumnValue( "activity_code",preFormDom );
				java.util.Date eventDte = genericUtility.getDateObject(genericUtility.getColumnValue( "event_date", preFormDom ));

				//for creating act_desr node
				sql = "SELECT DESCR FROM FIELDACTIVITY WHERE ACTIVITY_CODE = '"+actCodePreDom+"'";
				stmt = connectionObject.createStatement();
				rs = stmt.executeQuery(sql);
				if(rs.next())
				{
					actDescr = rs.getString("DESCR");

				}
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(stmt!=null)
				{
					stmt.close();
					stmt = null;
				}
				Element element = (Element) preFormDom.getElementsByTagName("Detail"+currentForm).item(0);
				element.appendChild(preFormDom.createElement("activity_descr"));
				preFormDom.getElementsByTagName("activity_descr").item(0).appendChild(preFormDom.createCDATASection(actDescr));

				//for eventdate as long
				Node node = preFormDom.getElementsByTagName("Detail" + currentForm).item(0);
				NodeList nodeList = node.getChildNodes();
				for (int i = 0; i < nodeList.getLength(); i++ )
				{
					Node elementNode = nodeList.item(i);
					if ( elementNode.getNodeName().equals("event_date") )
					{
						if ( elementNode.getFirstChild() == null)
						{
							Element sourceElement = preFormDom.createElement( "event_date" );
							Text sourceText = preFormDom.createTextNode( Long.toString(eventDte.getTime()) );
							sourceElement.appendChild( sourceText );
							Node updatedNode = preFormDom.importNode( ( Node ) sourceElement,true );
							node.replaceChild( updatedNode, elementNode );
						}
						else
						{
							elementNode.getFirstChild().setNodeValue( Long.toString(eventDte.getTime()) );
						}
					}
				}
				//Changed By Vidhya on 15/10/09[WI89BAS033 | Changing signature] End
				preFormDet = genericUtility.serializeDom(preFormDom);
				if( preFormDet != null || !"null".equalsIgnoreCase( preFormDet ))
				{
					valueXmlString.append( preFormDet );
					domID = domID + 1;
				}

			}

			//for sales person
			sql = "SELECT DISTINCT SR.SPRS_CODE SALES_PERS, UPPER(SP.SP_NAME) SP_NAME FROM SPRS_ROUTE SR, SALES_PERS SP WHERE SR.SPRS_CODE = SP.SALES_PERS AND SP.SP_NAME LIKE '%"+checkNull(salesPers)+"%' ORDER BY SPRS_CODE ";
			stmt = connectionObject.createStatement();
			rs = stmt.executeQuery(sql);
			while(rs.next())
			{
				valueXmlString.append( "<Detail"+currentForm+" domID='" + domID + "' selected ='N'>\r\n" );
				valueXmlString.append( "<sales_pers><![CDATA[" ).append(checkNull(rs.getString("SALES_PERS"))).append( "]]></sales_pers>\r\n" );
				valueXmlString.append( "<sales_pers_sp_name><![CDATA[" ).append(checkNull(rs.getString("SP_NAME"))).append( "]]></sales_pers_sp_name>\r\n" );
				valueXmlString.append( "<event_date><![CDATA[" ).append( checkNull( trvDate ) ).append( "]]></event_date>\r\n" );
				valueXmlString.append( "<activity_code><![CDATA[" ).append( checkNull( actCode )).append( "]]></activity_code>\r\n" );
				valueXmlString.append( "<chg_date><![CDATA[" ).append(currDate).append( "]]></chg_date>\r\n" );
				valueXmlString.append( "<chg_user><![CDATA[" ).append(userId).append( "]]></chg_user>\r\n" );
				valueXmlString.append( "<chg_term><![CDATA[" ).append(chgTerm).append( "]]></chg_term>\r\n" );
				valueXmlString.append( "<dcr_id><![CDATA[]]></dcr_id>\r\n" );
				valueXmlString.append( "</Detail"+currentForm+">\r\n" );
				domID++;

			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(stmt!=null)
			{
				stmt.close();
				stmt = null;
			}

			domID = 1;

		}
		catch(Exception e)
		{
			System.out.println( "Exception :WsfaZuviusDsrMobileWizardEJB :getPlaceOfWork():" + e.getMessage() + ":" );
			//valueXmlString = valueXmlString.append( generateErrorString( genericUtility.createErrorString( e ) ) );
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(stmt!=null)
				{
					stmt.close();
					stmt = null;
				}
				if( connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :WsfaZuviusDsrMobileWizardEJB :getPlaceOfWork :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		return valueXmlString.toString();
	}
	//to get place of work
	public String getPlaceOfWork( Document dom, Document dom2, String currentForm, String formName,String userId, String sprsCode, String actCode, String trvDate, String loginMode,Connection connectionObject) throws ITMException //chnged by sachin satre on [9-nov-16] to get connection
	{
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		String custType = null;
		String sql = "";
		String sqlEdit = "";
		String currDate = "";
		String chgTerm ="";
		String preFormDet ="";
		String locality ="";
		String planDataString="";
		String placeOfReturnStr="";
		String placeOfReturnDescr="";
		StringBuffer valueXmlString = new StringBuffer();
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		boolean flag = false;
		int rowsRS = 0;
		int count=0;
		ArrayList temp = new ArrayList();
		int currForm = 0;
		String modeReport = "A";

		String dcrID = "";
		boolean isLocalConn=false;
		if(currentForm != null && currentForm.trim().length() > 0)
			currForm  = Integer.parseInt(currentForm);

		String objName = checkNull(getObjNameFromDom(dom2, "objName",currForm));
		String locFormNo = checkNull(getFormNo(objName, "place", connectionObject));
		String mainFormNo = checkNull(getFormNo(objName, "mainform", connectionObject));
		String retailFormNo = checkNull(getFormNo(objName, "retailer", connectionObject));
		String docFormNo = checkNull(getFormNo(objName, "doctor", connectionObject));
		try
		{
			temp.add("'"+sprsCode.trim()+"'");

			InetAddress ownIP=InetAddress.getLocalHost();
			chgTerm = ownIP.getHostAddress();

			DateFormat dtFormat = new SimpleDateFormat(getApplDateFormat());
			java.util.Date date = Calendar.getInstance().getTime();
			currDate = dtFormat.format( date );
			System.out.println("SalesPerson > " + sprsCode);
			if(connectionObject == null)
			{
				connectionObject = getConnection();
				isLocalConn=true;
			}
			placeOfReturnStr = genericUtility.getColumnValue("last_place_of_return", dom2, mainFormNo);
			placeOfReturnDescr = genericUtility.getColumnValue("last_place_of_descr_return", dom2, mainFormNo);
			String copyPlan = checkNull(getSelectedRowValue(dom2, mainFormNo, "copy_plan", 0));
			dcrID = getDCRId(connectionObject,sprsCode, trvDate);
			System.out.println("dcrID =["+dcrID+"], custType =["+custType+"] copyPlan=["+copyPlan+"]");
			sql = "SELECT COUNT(*) FROM SPRS_TRAVEL WHERE SALES_PERS = ? AND TRAVEL_DATE = ?";
			PreparedStatement pstmtSprsTravel =  connectionObject.prepareStatement( sql );
			pstmtSprsTravel.setString(1, sprsCode);
			pstmtSprsTravel.setTimestamp( 2, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( trvDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
			ResultSet rsTravel = pstmtSprsTravel.executeQuery();
			if(rsTravel.next())
			{
				rowsRS = rsTravel.getInt(1);
			}
			if (rsTravel != null)
			{
				rsTravel.close();
				rsTravel = null;
			}
			if(pstmtSprsTravel!=null)
			{
				pstmtSprsTravel.close();
				pstmtSprsTravel = null;
			}
			System.out.println("rowsRS:::::[ "+rowsRS+" ]");
			if(rowsRS > 0)
			{
				modeReport = "E";
			}
			flag = preDomExists( dom2, currentForm );
			System.out.println( "history detail exists["+ flag +"]" );
			String lineCount = "";
			String sfaParmData  = getSfaParmValue(userId,connectionObject); //Chnaged by sachin satre on 11-nov-16
			HashMap<String,String> planmap = new HashMap<String,String>();
			HashMap<String, ArrayList<String>> custTypeMap = new HashMap<String, ArrayList<String>>();
			if(sfaParmData.equalsIgnoreCase("Y") && !"E".equalsIgnoreCase(modeReport))
			{
				String workDate = checkNull(getSelectedRowValue(dom2, "1", "event_date", 0));
				String planSql = " SELECT PLACE.LOCALITY_CODE AS LOCALITY_CODE,LOC.DESCR AS DESCR," +
						" LOC.LOCALITY_TYPE AS LOCALITY_TYPE, HDR.SPRS_CODE__PLAN AS  SPRS_CODE,PLACE.ORDER_OF_VISIT AS ORDER_OF_VISIT" +
						" FROM SPRS_PLAN_HDR HDR,SPRS_PLAN_PLACE PLACE,locality loc "+
						" WHERE HDR.PLAN_DATE= ? AND HDR.SPRS_CODE__PLAN= ? AND HDR.PLAN_ID = PLACE.PLAN_ID AND  PLACE.LOCALITY_CODE = LOC.LOCALITY_CODE";
				pstmt = connectionObject.prepareStatement(planSql);
				pstmt.setTimestamp( 1, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( workDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
				pstmt.setString(2,userId);
				rs = pstmt.executeQuery();
				while(rs.next())
				{
					planmap.put(rs.getString("LOCALITY_CODE").trim(), rs.getString("ORDER_OF_VISIT").trim());
				}
				System.out.println("planmap : "+planmap.toString());
			}
			if( flag )
			{
				preFormDet = getPrevFormLocValues( dom, currentForm, temp , "sales_pers", modeReport,connectionObject );
				if( preFormDet != null || !"null".equalsIgnoreCase( preFormDet ))
				{
					locality = getLocFromDom( genericUtility.parseString("<Root>"+preFormDet+"</Root>"), currentForm, sprsCode,connectionObject ); //Chnaged by sachin satre on 11-nov-16
					System.out.println("locality:::::::["+locality+"]");
					System.out.println("preFormDet:::::::["+preFormDet+"]");
					valueXmlString.append( preFormDet );
				}
			}
			else
			{
				sqlEdit = "SELECT ST.*, SR.DESCR DESCR FROM SPRS_TRAVEL ST, SPRS_ROUTE SR  WHERE ST.SALES_PERS = SR.SPRS_CODE AND ST.LOCALITY_CODE = SR.LOCALITY_CODE AND ST.SALES_PERS = ? AND ST.TRAVEL_DATE = ? ORDER BY ORDER_OF_VISIT, DESCR";
				if( rowsRS > 0 )
				{
					modeReport = "E";
					pstmt =  connectionObject.prepareStatement( sqlEdit );
					pstmt.setString(1, sprsCode);
					pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( trvDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );

					rs = pstmt.executeQuery();

					while(rs.next())
					{
						count++;
						lineCount = planmap.get(rs.getString("LOCALITY_CODE").trim());
						valueXmlString.append( "<Detail"+currentForm+" domID='"+ domID +"' selected = 'Y' formName='"+formName+"'>\r\n" );
						valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");
						valueXmlString.append( "<order_of_visit><![CDATA[" ).append(checkNull(rs.getString("ORDER_OF_VISIT"))).append( "]]></order_of_visit>\r\n" );
						valueXmlString.append( "<locality_code><![CDATA[" ).append(checkNull(rs.getString("LOCALITY_CODE"))).append( "]]></locality_code>\r\n" );
						valueXmlString.append( "<sprs_route_descr><![CDATA[" ).append(checkNull(rs.getString("DESCR"))).append( "]]></sprs_route_descr>\r\n" );
						valueXmlString.append( "<stan_code><![CDATA[" ).append(checkNull(rs.getString("STAN_CODE"))).append( "]]></stan_code>\r\n" );
						valueXmlString.append( "<travel_mode><![CDATA[" ).append(checkNull(rs.getString("TRAVEL_MODE"))).append( "]]></travel_mode>\r\n" );
						valueXmlString.append( "<over_night><![CDATA[" ).append(checkNull(rs.getString("OVER_NIGHT"))).append( "]]></over_night>\r\n" );
						valueXmlString.append( "<sales_pers><![CDATA[" ).append(checkNull(sprsCode)).append( "]]></sales_pers>\r\n" );
						valueXmlString.append( "<travel_date><![CDATA[" ).append(trvDate).append( "]]></travel_date>\r\n" );
						valueXmlString.append( "<activity_code><![CDATA[" ).append(checkNull(actCode)).append( "]]></activity_code>\r\n" );
						valueXmlString.append( "<chg_date><![CDATA[" ).append(currDate).append( "]]></chg_date>\r\n" );
						valueXmlString.append( "<chg_user><![CDATA[" ).append(userId).append( "]]></chg_user>\r\n" );
						valueXmlString.append( "<chg_term><![CDATA[" ).append(chgTerm).append( "]]></chg_term>\r\n" );
						valueXmlString.append( "<oth_participant><![CDATA[" ).append("").append( "]]></oth_participant>\r\n" );
						valueXmlString.append( "<plan_id><![CDATA[" ).append("").append( "]]></plan_id>\r\n" );
						valueXmlString.append( "<stan_code__from><![CDATA[" ).append("").append( "]]></stan_code__from>\r\n" );
						valueXmlString.append( "<sprs_code__ww><![CDATA[" ).append("").append( "]]></sprs_code__ww>\r\n" );
						valueXmlString.append( "<sales_team><![CDATA[" ).append("").append( "]]></sales_team>\r\n" );
						valueXmlString.append( "<template_file><![CDATA[" ).append("").append( "]]></template_file>\r\n" );
						valueXmlString.append( "<locality_code_from><![CDATA[" ).append("").append( "]]></locality_code_from>\r\n" );
						valueXmlString.append( "<dcr_id><![CDATA[" ).append(checkNull(rs.getString("DCR_ID"))).append( "]]></dcr_id>\r\n" );
						valueXmlString.append( "<tran_id><![CDATA[" ).append(checkNull(rs.getString("TRAN_ID"))).append( "]]></tran_id>\r\n" );
						valueXmlString.append( "<line_no><![CDATA[]]></line_no>\r\n" );
						valueXmlString.append( "<to_disable><![CDATA[" ).append("Y").append( "]]></to_disable>\r\n" );
						valueXmlString.append( "<dr_visit protect='1'><![CDATA[" ).append(checkNull(rs.getString("dr_visit"))).append( "]]></dr_visit>\r\n" );
						valueXmlString.append( "<chem_visit protect='1'><![CDATA[" ).append(checkNull(rs.getString("chem_visit"))).append( "]]></chem_visit>\r\n" );
						valueXmlString.append( "<stockist_visit protect='1'><![CDATA[" ).append(checkNull(rs.getString("stockist_visit"))).append( "]]></stockist_visit>\r\n" );
						valueXmlString.append( "<other_visit protect='1'><![CDATA[" ).append(checkNull(rs.getString("other_visit"))).append( "]]></other_visit>\r\n" );
						valueXmlString.append( "<last_place_of_return><![CDATA[" ).append( placeOfReturnStr ).append( "]]></last_place_of_return>\r\n" );
						valueXmlString.append( "<last_place_of_descr_return><![CDATA[" ).append(placeOfReturnDescr).append( "]]></last_place_of_descr_return>\r\n" );
						valueXmlString.append( "<stan_code__fr><![CDATA[" ).append("").append( "]]></stan_code__fr>\r\n" );
						valueXmlString.append( "<stan_code__to><![CDATA[" ).append("").append( "]]></stan_code__to>\r\n" );
						valueXmlString.append( "<add_geopos><![CDATA[" ).append(checkNull(rs.getString("ADD_GEOPOS"))).append( "]]></add_geopos>\r\n" );
						valueXmlString.append( "<chg_geopos><![CDATA[" ).append(checkNull(rs.getString("CHG_GEOPOS"))).append( "]]></chg_geopos>\r\n" );
						valueXmlString.append( "</Detail"+currentForm+">\r\n" );
						domID ++;
					}
					if (rs!= null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt!=null)
					{
						pstmt.close();
						pstmt = null;
					}
					locality = getLocFromDom(genericUtility.parseString("<Root>"+valueXmlString.toString()+"</Root>"), currentForm, sprsCode,connectionObject); //Chnaged by sachin satre on 11-nov-16
				}
			}

			if( locality != null && locality.length() == 0 )
			{
				locality = "'x'";
			}
			if ( loginMode.equalsIgnoreCase("RIA") )
			{

				sql = "SELECT LOCALITY_CODE, DESCR, STAN_CODE FROM SPRS_ROUTE WHERE SPRS_CODE = ? AND STATUS='Y'";
			}
			else if ( loginMode.equalsIgnoreCase("HTML") )
			{
				sql = "SELECT LOCALITY_CODE, DESCR, STAN_CODE FROM SPRS_ROUTE WHERE SPRS_CODE = ? AND STATUS='Y' AND LOCALITY_CODE NOT IN ("+locality+") ";
			}
			pstmt =  connectionObject.prepareStatement( sql );
			pstmt.setString(1, sprsCode);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				count++;
				lineCount = planmap.get(rs.getString("LOCALITY_CODE").trim());
				if(planmap.containsKey(rs.getString("LOCALITY_CODE").trim()) && "Y".equalsIgnoreCase(copyPlan))
				{
					valueXmlString.append( "<Detail"+currentForm+" domID='"+ domID +"' selected = 'Y' formName='"+formName+"'>\r\n" );
					valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");//Gaurav
					valueXmlString.append( "<order_of_visit><![CDATA[" ).append(lineCount).append( "]]></order_of_visit>\r\n" );
				}
				else
				{
					valueXmlString.append( "<Detail"+currentForm+" domID='"+ domID +"' selected = 'N' formName='"+formName+"'>\r\n" );
					valueXmlString.append( "<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");//Gaurav Singh on 03/06/15
					valueXmlString.append( "<order_of_visit><![CDATA[" ).append("").append( "]]></order_of_visit>\r\n" );
				}
				valueXmlString.append( "<locality_code><![CDATA[" ).append(checkNull(rs.getString("LOCALITY_CODE"))).append( "]]></locality_code>\r\n" );
				valueXmlString.append( "<sprs_route_descr><![CDATA[" ).append(checkNull(rs.getString("DESCR"))).append( "]]></sprs_route_descr>\r\n" );
				valueXmlString.append( "<stan_code><![CDATA[" ).append(checkNull(rs.getString("STAN_CODE"))).append( "]]></stan_code>\r\n" );
				valueXmlString.append( "<sales_pers><![CDATA[" ).append(checkNull(sprsCode)).append( "]]></sales_pers>\r\n" );
				valueXmlString.append( "<travel_date><![CDATA[" ).append(trvDate).append( "]]></travel_date>\r\n" );
				valueXmlString.append( "<activity_code><![CDATA[" ).append(checkNull(actCode)).append( "]]></activity_code>\r\n" );
				valueXmlString.append( "<chg_date><![CDATA[" ).append(currDate).append( "]]></chg_date>\r\n" );
				valueXmlString.append( "<chg_user><![CDATA[" ).append(userId).append( "]]></chg_user>\r\n" );
				valueXmlString.append( "<chg_term><![CDATA[" ).append(chgTerm).append( "]]></chg_term>\r\n" );
				valueXmlString.append( "<oth_participant><![CDATA[" ).append("").append( "]]></oth_participant>\r\n" );
				valueXmlString.append( "<plan_id><![CDATA[" ).append("").append( "]]></plan_id>\r\n" );
				valueXmlString.append( "<stan_code__from><![CDATA[" ).append("").append( "]]></stan_code__from>\r\n" );
				valueXmlString.append( "<sprs_code__ww><![CDATA[" ).append("").append( "]]></sprs_code__ww>\r\n" );
				valueXmlString.append( "<sales_team><![CDATA[" ).append("").append( "]]></sales_team>\r\n" );
				valueXmlString.append( "<template_file><![CDATA[" ).append("").append( "]]></template_file>\r\n" );
				valueXmlString.append( "<locality_code_from><![CDATA[" ).append("").append( "]]></locality_code_from>\r\n" );
				valueXmlString.append( "<dcr_id><![CDATA["+dcrID+"]]></dcr_id>\r\n" );
				valueXmlString.append( "<line_no><![CDATA[]]></line_no>\r\n" );
				valueXmlString.append( "<travel_mode><![CDATA[" ).append("ROAD").append( "]]></travel_mode>\r\n" );
				valueXmlString.append( "<over_night><![CDATA[" ).append("N").append( "]]></over_night>\r\n" );
				valueXmlString.append( "<to_disable><![CDATA[" ).append("N").append( "]]></to_disable>\r\n" );

				String isDrExist = "Y";
				String isChemExist = "Y";
				String isStockExist = "Y";
				String isNCWExist = "Y";
				String locCode = checkNull(rs.getString("LOCALITY_CODE"));
				isDrExist = checkCustExist(sprsCode, locCode, "D", connectionObject);
				isChemExist = checkCustExist(sprsCode, locCode, "C", connectionObject);
				isStockExist = checkCustExist(sprsCode, locCode, "S", connectionObject);
				isNCWExist = checkCustExist(sprsCode, locCode, "O", connectionObject);
				System.out.println("isDrExist ["+isDrExist+"]isNCWExist["+isNCWExist);
				if(isDrExist.equalsIgnoreCase("N"))
				{
					valueXmlString.append( "<dr_visit protect='1'><![CDATA[" ).append("N").append( "]]></dr_visit>\r\n" );
				}
				else
				{
					valueXmlString.append( "<dr_visit><![CDATA[" ).append("N").append( "]]></dr_visit>\r\n" );
				}
				if(isChemExist.equalsIgnoreCase("N"))
				{
					valueXmlString.append( "<chem_visit protect='1'><![CDATA[" ).append("N").append( "]]></chem_visit>\r\n" );
				}
				else
				{
					valueXmlString.append( "<chem_visit><![CDATA[" ).append("N").append( "]]></chem_visit>\r\n" );
				}
				if(isStockExist.equalsIgnoreCase("N"))
				{
					valueXmlString.append( "<stockist_visit protect='1'><![CDATA[" ).append("N").append( "]]></stockist_visit>\r\n" );
				}
				else
				{
					valueXmlString.append( "<stockist_visit><![CDATA[" ).append("N").append( "]]></stockist_visit>\r\n" );
				}
				if(isNCWExist.equalsIgnoreCase("N"))
				{
					valueXmlString.append( "<other_visit protect='1'><![CDATA[" ).append("N").append( "]]></other_visit>\r\n" );
				}
				else
				{
					valueXmlString.append( "<other_visit><![CDATA[" ).append("N").append( "]]></other_visit>\r\n" );
				}
				valueXmlString.append( "<last_place_of_return><![CDATA[" ).append( placeOfReturnStr ).append( "]]></last_place_of_return>\r\n" );
				valueXmlString.append( "<last_place_of_descr_return><![CDATA[" ).append(placeOfReturnDescr).append( "]]></last_place_of_descr_return>\r\n" );
				valueXmlString.append( "<stan_code__fr><![CDATA[" ).append("").append( "]]></stan_code__fr>\r\n" );
				valueXmlString.append( "<stan_code__to><![CDATA[" ).append("").append( "]]></stan_code__to>\r\n" );
				valueXmlString.append( "<add_geopos><![CDATA[" ).append("").append( "]]></add_geopos>\r\n" );
				valueXmlString.append( "<chg_geopos><![CDATA[" ).append("").append( "]]></chg_geopos>\r\n" );
				valueXmlString.append( "</Detail"+currentForm+">\r\n" );
				domID ++;

			}
			domID = 1;
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			System.out.println( "Exception :WsfaDSRMobileWizardEJB :getPlaceOfWork():" + e.getMessage() + ":" );
			//valueXmlString = valueXmlString.append( generateErrorString( genericUtility.createErrorString( e ) ) );
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(isLocalConn &&  connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :WsfaDSRMobileWizardEJB :getPlaceOfWork :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		System.out.println("placeof work detail:::"+valueXmlString.toString());
		return valueXmlString.toString();
	}

	public String getCustomerDetail(Document dom, Document dom2, String currentForm, String formName,String userId, String sprsCode, String actCode, String trvDate, String custType,Connection connectionObject) throws ITMException //Chnaged by sachin satre on 11-nov-16
	{
		System.out.println("PR:Inside getCustomerDetail............>>>>>>>> ");
		ResultSet rs = null;
		Statement stmt = null;
		PreparedStatement pstmt = null;
		PreparedStatement strgVisitPstmt = null;
		ResultSet strgVisitRs = null;

		PreparedStatement pstmtPlan = null;
		ResultSet rsPlan = null;
		String sql = "";
		String currDate = "";
		String chgTerm ="";
		String locality = "";
		String hours="";
		String startTime="";
		String hour = "";
		String minute = "";
		String interval ="";
		String preFormDet ="";
		String sqlEdit = "";
		String customers ="";
		String [] temp;
		String strgCode = "";
		String visitDatesInMonth = "";

		StringBuffer valueXmlString = new StringBuffer();
		List<String> list = null;
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		boolean flag = false;
		int locForm = 0;
		int rowsRS = 0;
		NodeList parentList = null;
		Node parentNode = null;
		String chemistVisit ="" ;
		String stockistVisit ="" ;
		boolean chemistExistFlag;
		boolean stockistExistFlag;
		boolean IsLocalConn = false;
		String modeReport = "A";
		int currentFormNumber = 0;
		String eventTime = geteventTime();
		if( currentForm != null && currentForm.trim().length() > 0 )
		{
			currentFormNumber = Integer.parseInt( currentForm );
		}


		//String objName = checkNull(getObjNameFromDom(dom2, "objName",currentFormNumber));
		//String locFormNo = checkNull(getFormNo(objName, "place", connectionObject));
		//String mainFormNo = checkNull(getFormNo(objName, "mainform", connectionObject));
		//String retailFormNo = checkNull(getFormNo(objName, "retailer", connectionObject));
		//String docFormNo = checkNull(getFormNo(objName, "doctor", connectionObject));
		try
		{
			InetAddress ownIP=InetAddress.getLocalHost();
			chgTerm = ownIP.getHostAddress();
			if(connectionObject ==null)
			{
				connectionObject = getConnection();
				IsLocalConn = true;
			}
			DateFormat dtFormat = new SimpleDateFormat(getApplDateFormat());
			java.util.Date date = Calendar.getInstance().getTime();
			currDate = dtFormat.format( date );
			String currDate1 =  genericUtility.getValidDateTimeString( currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
			System.out.println("Salesperson >"+sprsCode);
			chemistExistFlag=false;
			stockistExistFlag=false;
			int detail3ListLen = 0;

			String trvDBDate =  genericUtility.getValidDateTimeString( trvDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
			String eventDate =  genericUtility.getValidDateString( trvDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );

			locForm = Integer.parseInt(currentForm) - 1;
			locality = getLocFromDom(dom2, ""+2, sprsCode, custType,connectionObject );//Chnaged by sachin satre on 11-nov-16
			System.out.println("locality------"+locality);
			String otherParticipant = checkNull(genericUtility.getColumnValue("oth_participant", dom2, "1"));//Gaurav Singh on 05-06-15
			String workWithOther = checkNull(genericUtility.getColumnValue("work_with_other", dom2, "1"));//Gaurav Singh on 05-06-15
			String workWith = checkNull(genericUtility.getColumnValue("visited_with_display", dom2, "1"));//Gaurav Singh on 05-06-15
			String copyPlan = checkNull(getSelectedRowValue(dom2, "1", "copy_plan", 0));
			String activityCodeDom = checkNull(genericUtility.getColumnValue("activity_code", dom2, "1"));//Gaurav Singh on 05-06-15

			System.out.println("otherParticipant=["+otherParticipant+"]");
			System.out.println("workWith=["+workWith+"] copyPlan=["+copyPlan+"]");
			String otherParticipantDb = "";
			temp = locality.split(",");
			String actType = getActivityType( actCode, connectionObject );
			System.out.println("actType......= "+actType);
			int strgMeetCount = 0;
			String checkStrgMeetSql = "SELECT COUNT(1) AS COUNT FROM STRG_MEET WHERE EVENT_DATE  = ? AND SALES_PERS = ? AND STRG_CODE = ?";
			PreparedStatement pstmtCheckStrgMeet = connectionObject.prepareStatement(checkStrgMeetSql);
			sql = "SELECT COUNT(*) FROM STRG_MEET WHERE SALES_PERS = ? AND EVENT_DATE = ?";
			pstmt =  connectionObject.prepareStatement( sql );
			pstmt.setString(1, sprsCode);
			pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( trvDBDate ) );
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				rowsRS = rs.getInt(1);
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rowsRS > 0)
			{
				modeReport = "E";
			}

			String parmValue = "N";
			String sqlVisit = "SELECT PARM_VALUE FROM SFAPARM WHERE PARM_NAME='VALIDATE_NO_VISIT' AND ? BETWEEN EFF_FROM AND VALID_UPTO AND ACTIVE='Y' ";
			pstmt = connectionObject.prepareStatement(sqlVisit);
			pstmt.setTimestamp(1, java.sql.Timestamp.valueOf(currDate1));
			rs = pstmt.executeQuery();

			if (rs.next())
			{
				parmValue = checkNull(rs.getString("PARM_VALUE"));
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			String dcrID = getDCRId(connectionObject,userId, trvDate);
			int srNo=0;
			//to append previous values of current form from current dom on previous action
			flag = preDomExists( dom, currentForm );
			System.out.println( "history detail exists["+ flag +"]" );
			if(flag)
			{
				/*preFormDet = getPrevFormCustValues( dom2, currentForm, new ArrayList<String>(Arrays.asList(temp)), "locality_code" );
				//TODO
				System.out.println( "preFormDet::::::::::::::"+preFormDet);

				if(preFormDet != null && preFormDet.trim().length() > 0)
				{


					String actCodePreDom = getSelectedRowValue(  genericUtility.parseString("<Root>"+preFormDet+"</Root>"), currentForm, "event_type", 0);
					String actTypePreDom = getActivityType( actCodePreDom, connectionObject );

					Document preFormDom =  genericUtility.parseString("<Root>"+preFormDet+"</Root>");
					NodeList preDomList = preFormDom.getElementsByTagName("Detail" + currentForm);
					for (int prntCtr = 0; prntCtr < preDomList.getLength(); prntCtr++ )
					{
						srNo++;
						String locDescr ="";
						String localityCode = getSelectedRowValue( preFormDom, currentForm,  "locality_code", prntCtr );
						sql = "SELECT DESCR FROM LOCALITY WHERE LOCALITY_CODE = ?";
						pstmt =  connectionObject.prepareStatement(sql);
						pstmt.setString(1, localityCode);
						rs = pstmt.executeQuery();
						if( rs.next())
						{
							locDescr = rs.getString("DESCR");

						}
						if (rs!= null)
						{
							rs.close();
							rs = null;
						}
						if(pstmt!=null)
						{
							pstmt.close();
							pstmt = null;
						}
						System.out.println(" locality descr ["+locDescr+"]");
						Element element = (Element) preFormDom.getElementsByTagName("Detail"+currentForm).item(prntCtr);
						element.appendChild(preFormDom.createElement("activity_type"));
						preFormDom.getElementsByTagName("activity_type").item(prntCtr).appendChild( preFormDom.createCDATASection( actTypePreDom ) );
						String custCode = getSelectedRowValue( preFormDom, currentForm,  "strg_code", prntCtr );
						pstmtCheckStrgMeet.setTimestamp(1, java.sql.Timestamp.valueOf(trvDBDate));
						pstmtCheckStrgMeet.setString(2, userId);
						pstmtCheckStrgMeet.setString(3, custCode);
						ResultSet rsCheckStrgMeet = pstmtCheckStrgMeet.executeQuery();
						if(rsCheckStrgMeet.next())
						{
							strgMeetCount = rsCheckStrgMeet.getInt("COUNT");
						}
						pstmtCheckStrgMeet.clearParameters();
						rsCheckStrgMeet.close(); rsCheckStrgMeet = null;
						if(strgMeetCount > 0 )
						{
							element.appendChild(preFormDom.createElement("to_disable"));
							preFormDom.getElementsByTagName("to_disable").item(prntCtr).appendChild( preFormDom.createCDATASection( "Y" ) );
						}
						else
						{
							element.appendChild(preFormDom.createElement("to_disable"));
							preFormDom.getElementsByTagName("to_disable").item(prntCtr).appendChild( preFormDom.createCDATASection( "N" ) );
						}
						element.appendChild(preFormDom.createElement("sr_no"));
						preFormDom.getElementsByTagName("sr_no").item(prntCtr).appendChild( preFormDom.createCDATASection( ""+srNo ) );
					}
					if( pstmtCheckStrgMeet != null )
					{
						pstmtCheckStrgMeet.close(); pstmtCheckStrgMeet = null;
					}
					preFormDet = genericUtility.serializeDom( preFormDom );
					if( preFormDet != null || !"null".equalsIgnoreCase(preFormDet))
					{
						if ( actType.equalsIgnoreCase( actTypePreDom ) )
						{
							String preDomLocality = getLocFromDom( genericUtility.parseString("<Root>" + preFormDet + "</Root>"), currentForm, sprsCode,connectionObject ); //Chnaged by sachin satre on 11-nov-16
							list = new ArrayList<String>( Arrays.asList( temp ) );
							list.removeAll( Arrays.asList( preDomLocality.split(",") ) );
							temp = list.toArray(new String[0]);
							customers = getCustFromDom( genericUtility.parseString("<Root>" + preFormDet + "</Root>"), currentForm, sprsCode , "Y",connectionObject); //Chnaged by sachin satre on 11-nov-16
							valueXmlString.append( preFormDet );
						}
					}
				}*/

			}
			else
			{
				sql = "SELECT COUNT(*) FROM STRG_MEET WHERE SALES_PERS = ? AND EVENT_DATE = ? AND EVENT_TYPE = 'PR'";
				pstmt =  connectionObject.prepareStatement( sql );
				pstmt.setString(1, sprsCode);
				pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( trvDBDate ) );
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					rowsRS = rs.getInt(1);
				}
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if ( locality == null || locality.trim().length() == 0 )
				{
					locality = "''";
				}
				/*Added By Shahu for DB2 Start*/

				sqlEdit="SELECT STRG_MEET.*,LOCALITY.DESCR LOC_DESCR,FIELDACTIVITY.ACTIVITY_TYPE ACT_TYPE,"+
						"   UPPER(STRG_CUSTOMER.FIRST_NAME)||' '||UPPER(STRG_CUSTOMER.LAST_NAME) AS SC_NAME,"+
						"STRG_CUSTOMER.ADDR1,STRG_CUSTOMER.ADDR2,STRG_CUSTOMER.ADDR3  "+
						" FROM LOCALITY , FIELDACTIVITY,STRG_MEET LEFT OUTER JOIN STRG_CUSTOMER ON STRG_MEET.STRG_CODE = STRG_CUSTOMER.SC_CODE "+
						"  WHERE STRG_MEET.EVENT_TYPE =FIELDACTIVITY.ACTIVITY_CODE"+
						" AND STRG_MEET.LOCALITY_CODE = LOCALITY.LOCALITY_CODE "+
						" AND STRG_MEET.SALES_PERS = ? "+
						" AND STRG_MEET.EVENT_DATE = ? "+
						" AND STRG_MEET.STRG_CODE IN "+
						" ( SELECT SC_CODE  FROM STRG_STATUS_HIST "+
						"    WHERE STRG_STATUS_HIST .EFF_FROM<= ?  "+
						"    AND STRG_STATUS_HIST .VALID_UPTO >= ?"+
						"    AND STRG_CUSTOMER.CUST_TYPE = ? " +
						"    AND STRG_STATUS_HIST.SALES_PERS = STRG_MEET.SALES_PERS  ) AND STRG_MEET.EVENT_TYPE = 'PR' " +
						" ORDER BY STRG_MEET.SHORT_ID ";

				System.out.println("Rows ["+rowsRS+"]");

				if( rowsRS > 0 )
				{
					modeReport = "E";
					pstmt =  connectionObject.prepareStatement( sqlEdit );
					pstmt.setString(1, sprsCode);
					pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( trvDBDate ) );
					pstmt.setTimestamp( 3, java.sql.Timestamp.valueOf( trvDBDate ) );
					pstmt.setTimestamp( 4, java.sql.Timestamp.valueOf( trvDBDate ) );
					if(!custType.equalsIgnoreCase("O"))
					{
						pstmt.setString(5, custType);//Gulzar on 17/06/12
					}
					rs = pstmt.executeQuery();

					while(rs.next())
					{
						srNo++;
						String actypeDB = checkNull(rs.getString("ACT_TYPE"));
						strgCode = checkNull(rs.getString("STRG_CODE"));//Gulzar on 17/06/12

						//if (otherParticipant == null || otherParticipant.trim().length() == 0)
						{
							otherParticipantDb = checkNull(rs.getString("OTH_PARTICIPANT"));
						}
						if (otherParticipantDb == null || otherParticipantDb.trim().length() == 0)
						{
							otherParticipantDb = otherParticipant;
						}

						String specialityDescr = checkNull(getSplDescr(strgCode, sprsCode, connectionObject));
						System.out.println("specialityDescr:-- "+specialityDescr+"--- strgCode--- "+strgCode+"-- sprsCode-- ");

						if(parmValue.equalsIgnoreCase("Y"))
						{
							visitDatesInMonth = getDocVistDatesInMonth(strgCode,sprsCode,trvDate,connectionObject);
						}
						int strgPriorVisitNo = 0;
						if(visitDatesInMonth != null && visitDatesInMonth.trim().length() > 0)
						{
							String strgPriorVisit [] = visitDatesInMonth.split(",");
							strgPriorVisitNo = strgPriorVisit.length;
						}
						System.out.println("Edit strgPriorVisitNo :::=["+strgPriorVisitNo+"]");
						if ( actType.equalsIgnoreCase(actypeDB) )
						{
							String places = checkNull(rs.getString("LOCALITY_CODE"));
							list = new ArrayList<String>( Arrays.asList( temp ) );
							list.removeAll( Arrays.asList("'"+places+"'" ) );
							temp = list.toArray(new String[0]);

							valueXmlString.append( "<Detail"+currentForm+" domID='"+domID+"' selected = 'Y' formName='"+formName+"'>\r\n" );
							valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");//Gaurav Singh on 03/06/15
							valueXmlString.append("<sr_no><![CDATA[" ).append(srNo).append( "]]></sr_no>\r\n"); // Added By Shahu Mali on  28/12/12
							valueXmlString.append("<to_disable><![CDATA[Y]]></to_disable>\r\n"); //rakesh kumar on 16/11/12 to disable the checkbox
							valueXmlString.append("<short_id><![CDATA[" ).append( checkNull(rs.getString("SHORT_ID")).trim()).append( "]]></short_id>\r\n");
							valueXmlString.append("<strg_code><![CDATA[" ).append( checkNull(rs.getString("STRG_CODE")).trim()).append( "]]></strg_code>\r\n");
							/*if("FW".equalsIgnoreCase(actType))
							{
								valueXmlString.append("<cust_name><![CDATA[" ).append( checkNull(rs.getString("SC_NAME")).trim()).append( "]]></cust_name>\r\n");
								
							}
							else
							{
								valueXmlString.append("<cust_name><![CDATA[-NA-]]></cust_name>\r\n");
							}*/
							if(actType.indexOf("NFW")!=-1 || actType.indexOf("LEAVE")!=-1)
							{
								valueXmlString.append("<cust_name><![CDATA[-NA-]]></cust_name>\r\n");
							}
							else
							{
								valueXmlString.append("<cust_name><![CDATA[" ).append( checkNull(rs.getString("SC_NAME")).trim()).append( "]]></cust_name>\r\n");
							}
							valueXmlString.append( "<locality_descr><![CDATA[" ).append( checkNull(rs.getString("LOC_DESCR"))).append( "]]></locality_descr>\r\n" );
							valueXmlString.append( "<order_booked><![CDATA[" ).append( checkNull(rs.getString("ORDER_BOOKED"))).append( "]]></order_booked>\r\n" );
							valueXmlString.append( "<event_time_start><![CDATA[" ).append( checkNull(rs.getString("EVENT_TIME_START"))).append( "]]></event_time_start>\r\n" );
							valueXmlString.append( "<event_time_end><![CDATA[" ).append( checkNull(rs.getString("EVENT_TIME_END"))).append( "]]></event_time_end>\r\n" );
							valueXmlString.append( "<meet_summ><![CDATA[" ).append( checkNull(rs.getString("MEET_SUMM"))).append( "]]></meet_summ>\r\n" );
							valueXmlString.append( "<remarks><![CDATA[" ).append(checkNull(rs.getString("REMARKS"))).append( "]]></remarks>\r\n" );
							//valueXmlString.append( "<call_outcome><![CDATA[" ).append(checkNull(rs.getString("CALL_OUTCOME"))).append( "]]></call_outcome>\r\n" );


							String callOutCome = checkNull(rs.getString("CALL_OUTCOME"));
							valueXmlString.append( "<call_outcome><![CDATA[" ).append(checkNull(callOutCome)).append( "]]></call_outcome>\r\n" );
							if(callOutCome.equalsIgnoreCase("4"))
							{
								valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Very Positive").append( "]]></calloutcome_descr>\r\n" );
							}
							else if(callOutCome.equalsIgnoreCase("3"))
							{
								valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Average").append( "]]></calloutcome_descr>\r\n" );
							}
							else if(callOutCome.equalsIgnoreCase("2"))
							{
								valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Below Average").append( "]]></calloutcome_descr>\r\n" );
							}
							else if(callOutCome.equalsIgnoreCase("1"))
							{
								valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Negative").append( "]]></calloutcome_descr>\r\n" );
							}
							else if(callOutCome.equalsIgnoreCase("0"))
							{
								valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Refused").append( "]]></calloutcome_descr>\r\n" );
							}


							valueXmlString.append( "<oth_participant><![CDATA[" ).append(otherParticipantDb).append( "]]></oth_participant>\r\n" );
							valueXmlString.append( "<visited_with_display><![CDATA[" ).append(workWith).append( "]]></visited_with_display>\r\n" );
							if("JW".equalsIgnoreCase(actCode) && "FW".equalsIgnoreCase(actType))//Gulzar on 17/06/12
							{
								valueXmlString.append( "<work_with_other><![CDATA[" ).append(workWithOther).append( "]]></work_with_other>\r\n" );
							}
							else
							{
								valueXmlString.append( "<work_with_other><![CDATA[" ).append("").append( "]]></work_with_other>\r\n" );
							}
							valueXmlString.append( "<work_team><![CDATA[" ).append(checkNull(rs.getString("WORK_TEAM"))).append( "]]></work_team>\r\n" );
							valueXmlString.append( "<sales_pers><![CDATA[" ).append(checkNull(sprsCode)).append( "]]></sales_pers>\r\n" );
							valueXmlString.append( "<chg_date><![CDATA[" ).append(currDate).append( "]]></chg_date>\r\n" );
							valueXmlString.append( "<chg_user><![CDATA[" ).append(userId).append( "]]></chg_user>\r\n" );
							valueXmlString.append( "<chg_term><![CDATA[" ).append(chgTerm).append( "]]></chg_term>\r\n" );
							valueXmlString.append( "<locality_code visible='1' protect='0'><![CDATA[" ).append(places).append( "]]></locality_code>\r\n" );
							valueXmlString.append( "<sales_pers_sp_name><![CDATA[" ).append("").append( "]]></sales_pers_sp_name>\r\n" );
							valueXmlString.append( "<sprs_code__ww><![CDATA[" ).append("").append( "]]></sprs_code__ww>\r\n" );
							valueXmlString.append( "<event_date><![CDATA[" ).append(trvDate).append( "]]></event_date>\r\n" );
							valueXmlString.append( "<event_type><![CDATA[" ).append(checkNull(actCode)).append( "]]></event_type>\r\n" );
							valueXmlString.append( "<activity_type><![CDATA[" ).append(actypeDB).append( "]]></activity_type>\r\n" );
							valueXmlString.append( "<strg_name><![CDATA[]]></strg_name>\r\n" );
							valueXmlString.append( "<strg_type><![CDATA[" ).append(checkNull(rs.getString("STRG_TYPE"))).append( "]]></strg_type>\r\n" );
							valueXmlString.append( "<strg_no_visit><![CDATA[" ).append(checkNull(rs.getString("STRG_NO_VISIT"))).append("]]></strg_no_visit>\r\n" );
							/*if("FW".equalsIgnoreCase(actType))
							{
								valueXmlString.append( "<strg_class_code><![CDATA[" ).append(checkNull(rs.getString("STRG_CLASS_CODE"))).append( "]]></strg_class_code>\r\n" );
								
							}
							else
							{
								valueXmlString.append( "<strg_class_code><![CDATA[ ]]></strg_class_code>\r\n" );
							}*/
							if(actType.indexOf("NFW")!=-1 || actType.indexOf("LEAVE")!=-1)
							{
								valueXmlString.append( "<strg_class_code><![CDATA[ ]]></strg_class_code>\r\n" );
							}
							else
							{
								valueXmlString.append( "<strg_class_code><![CDATA[" ).append(checkNull(rs.getString("STRG_CLASS_CODE"))).append( "]]></strg_class_code>\r\n" );
							}
							valueXmlString.append( "<sales_team><![CDATA[" ).append("").append( "]]></sales_team>\r\n" );
							valueXmlString.append( "<template_file><![CDATA[" ).append("").append( "]]></template_file>\r\n" );
							valueXmlString.append( "<last_meet_summ><![CDATA[" ).append("").append( "]]></last_meet_summ>\r\n" );
							valueXmlString.append( "<last_meet_date><![CDATA[" ).append("").append( "]]></last_meet_date>\r\n" );
							valueXmlString.append( "<last_prod_brf><![CDATA[" ).append("").append( "]]></last_prod_brf>\r\n" );
							valueXmlString.append( "<ref_tran_id><![CDATA[" ).append("").append( "]]></ref_tran_id>\r\n" );
							valueXmlString.append( "<conf_date><![CDATA[" ).append("").append( "]]></conf_date>\r\n" );
							valueXmlString.append( "<confirmed><![CDATA[" ).append("").append( "]]></confirmed>\r\n" );
							valueXmlString.append( "<emp_code__aprv><![CDATA[" ).append("").append( "]]></emp_code__aprv>\r\n" );
							valueXmlString.append( "<sc_code__ref><![CDATA[" ).append("").append( "]]></sc_code__ref>\r\n" );
							valueXmlString.append( "<meet_summ_mgr><![CDATA[" ).append("").append( "]]></meet_summ_mgr>\r\n" );
							valueXmlString.append( "<dcr_id><![CDATA[" ).append(checkNull(rs.getString("DCR_ID"))).append( "]]></dcr_id>\r\n" );//Gaurav Singh on 10-06-2015
							valueXmlString.append( "<doc_visit_dates><![CDATA[" ).append(strgPriorVisitNo).append( "]]></doc_visit_dates>\r\n" );
							valueXmlString.append( "<addr1><![CDATA[" ).append(checkNull(rs.getString("ADDR1"))).append( "]]></addr1>\r\n" );//Gulzar on 17/06/12
							valueXmlString.append( "<addr2><![CDATA[" ).append(checkNull(rs.getString("ADDR2"))).append( "]]></addr2>\r\n" );//Gulzar on 17/06/12
							valueXmlString.append( "<addr3><![CDATA[" ).append(checkNull(rs.getString("ADDR3"))).append( "]]></addr3>\r\n" );//Gulzar on 17/06/12
							valueXmlString.append( "<add_geopos><![CDATA[" ).append(checkNull(rs.getString("ADD_GEOPOS"))).append( "]]></add_geopos>\r\n" );
							valueXmlString.append( "<chg_geopos><![CDATA[" ).append(checkNull(rs.getString("CHG_GEOPOS"))).append( "]]></chg_geopos>\r\n" );
							String visitedWith = checkNull(genericUtility.getColumnValue("visited_with", dom2, "1"));
							valueXmlString.append( "<select_team><![CDATA[" ).append(visitedWith).append( "]]></select_team>\r\n" );
							valueXmlString.append( "<speciality_descr><![CDATA[" ).append(specialityDescr).append( "]]></speciality_descr>\r\n" );
							valueXmlString.append( "<sku_value><![CDATA[" ).append(checkNull(rs.getString("SKU_VALUE"))).append( "]]></sku_value>\r\n" );
							valueXmlString.append( "<validate_no_visit><![CDATA[" ).append( checkNull(parmValue) ).append( "]]></validate_no_visit>\r\n" );
							valueXmlString.append( "</Detail"+currentForm+">\r\n" );
							domID++;
						}
						customers = getCustFromDom(genericUtility.parseString("<Root>"+valueXmlString.toString()+"</Root>"),currentForm ,sprsCode , "Y",connectionObject); //Chnaged by sachin satre on 11-nov-16

					}
					if (rs!= null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt!=null)
					{
						pstmt.close();
						pstmt = null;
					}
				}
			}
			if(pstmtCheckStrgMeet!=null)
			{
				pstmtCheckStrgMeet.close();
				pstmtCheckStrgMeet = null;
			}
			if( customers != null && customers.length() == 0 )
			{
				customers = "'x'";
			}
			sql = "SELECT TRIM(PROP_VALUE) AS MEET_START_TIME FROM PROPERTIES WHERE PROP_NAME ='MEET_START_TIME'";
			System.out.println( " [StrgMeetWizEJB]sql [" + sql + "]" );
			stmt = connectionObject.createStatement();
			rs = stmt.executeQuery( sql );
			if( rs.next() )
			{
				startTime = checkNull(rs.getString( "MEET_START_TIME" ));
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			sql = "SELECT TRIM(PROP_VALUE) AS MEET_INTERVAL FROM PROPERTIES WHERE PROP_NAME ='MEET_INTERVAL'";
			System.out.println( " [StrgMeetWizEJB]sql [" + sql + "]" );
			stmt = connectionObject.createStatement();
			rs = stmt.executeQuery( sql );
			if( rs.next() )
			{
				interval = checkNull(rs.getString( "MEET_INTERVAL" ));
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(stmt!=null)
			{
				stmt.close();
				stmt = null;
			}
			//Cfor duplicate doctor entry.start

			System.out.println("locality=["+locality+"]");

			if ( locality == null || locality.trim().length() == 0 )
			{
				locality = "''";
			}
			String sfaParmData  = getSfaParmValue(userId,connectionObject); //Chnaged by sachin satre on 11-nov-16
			ArrayList<String> custList = new ArrayList<String>();
			//Added vinayak to not check plan on previous click and to show data as per selection [start]
			if(sfaParmData.equalsIgnoreCase("Y") && !"E".equalsIgnoreCase(modeReport))
			{
				String workDate = checkNull(getSelectedRowValue(dom2, "1", "event_date", 0));
				String planSql = "SELECT SC_CODE  FROM SPRS_PLAN_CUST CUST,SPRS_PLAN_HDR HDR WHERE " +
						"HDR.PLAN_DATE= ? AND HDR.SPRS_CODE__PLAN= ?  " +
						"AND HDR.PLAN_ID = CUST.PLAN_ID";
				pstmtPlan = connectionObject.prepareStatement(planSql);
				pstmtPlan.setTimestamp( 1, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( workDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
				pstmtPlan.setString(2,userId);
				rsPlan = pstmtPlan.executeQuery();
				while(rsPlan.next())
				{
					custList.add(rsPlan.getString("SC_CODE").trim());
				}
				//added Bu Nilesh Start::02-06-2017
				if (rsPlan!= null)
				{
					rsPlan.close();
					rsPlan = null;
				}
				if(pstmtPlan!=null)
				{
					pstmtPlan.close();
					pstmtPlan = null;
				}
				//added By Nilesh End::02-06-2017
				System.out.println("custList :::: "+custList.toString());
			}
			//Added vinayak to not check plan on previous click and to show data as per selection [end]

			sql = "SELECT SS.SHORT_ID MPLNO, SS.SPL_CODE, SP.DESCR SPL_DECR, "+
					" SC.SC_CODE CODE, UPPER(SC.FIRST_NAME)||' '||UPPER(SC.LAST_NAME) AS SC_NAME,   "+
					" L.DESCR LOC_DESCR, SS.CLASS_CODE CLASS_CODE,  "+
					" SS.NO_VISIT NO_VISIT, SC.CUST_TYPE CUST_TYPE, SC.LOCALITY_CODE LOCALITY_CODE,  "+
					" SC.ADDR1 AS ADDR1, SC.ADDR2 AS ADDR2, SC.ADDR3  AS ADDR3 " +
					" FROM STRG_CUSTOMER SC,  LOCALITY L, STRG_SERIES SS LEFT OUTER JOIN SPECIALITY SP ON SP.SPL_CODE = SS.SPL_CODE  "+
					" WHERE SS.SC_CODE = SC.SC_CODE  "+
					" AND SC.LOCALITY_CODE = L.LOCALITY_CODE  "+
					" AND SS.SALES_PERS = ? "+
					" AND SS.SC_CODE IN "+
					" (SELECT SC_CODE FROM STRG_STATUS_HIST WHERE STATUS = 'Y' "+
					" AND EFF_FROM <= ? AND VALID_UPTO >= ? "+
					" AND SALES_PERS = SS.SALES_PERS  "+
					" AND SC_CODE = SC.SC_CODE ) "+
					" AND SC.CUST_TYPE =? " +//Gulzar on 6/10/2012
					" AND SS.SC_CODE NOT IN ( "+customers+" ) "+
					" ORDER BY SHORT_ID ";

			pstmt =  connectionObject.prepareStatement( sql );
			pstmt.setString(1, checkNull(sprsCode));
			pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( trvDBDate ) );
			pstmt.setTimestamp(3, java.sql.Timestamp.valueOf( trvDBDate ) );
			if(!custType.equalsIgnoreCase("O"))
			{
				pstmt.setString(4, custType);//Gulzar on 17/06/12
			}
			System.out.println("actType:::::::= "+actType);
			//if( !"FW".equalsIgnoreCase(actType))
			if( actType.indexOf("NFW")!=-1 || actType.indexOf("LEAVE")!=-1)
			{
				String sqlLoc = "SELECT DESCR FROM LOCALITY WHERE LOCALITY_CODE = ?";
				pstmt =  connectionObject.prepareStatement( sqlLoc );
				if ( temp.length > 0 )
				{
					for(int i = 0; i < temp.length; i++)
					{
						srNo++;
						String place = temp[i];
						System.out.println("place =["+place+"]");
						if (place != null && place.trim().length() > 0 )
						{
							place = place.substring(1, place.length()-1);
						}
						System.out.println("Before Activity Type");
						//if( !"FW".equalsIgnoreCase(actType) &&  !"LEAVE".equalsIgnoreCase(actType) && actType.trim().length() > 0)
						if("NFW".equalsIgnoreCase(actType) && actType.trim().length() > 0)
						{
							System.out.println("Inside Activity Type");
							valueXmlString.append( "<Detail"+currentForm+" domID='"+domID+"' selected = 'Y' formName='"+formName+"'>\r\n" );
							valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");//Gaurav Singh on 03/06/15
						}
						else
						{
							System.out.println("Inside Activity Type3");
							valueXmlString.append( "<Detail"+currentForm+" domID='"+domID+"' selected = 'N'>\r\n" );
							valueXmlString.append( "<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");//Gaurav Singh on 03/06/15
						}
						valueXmlString.append("<sr_no><![CDATA[" ).append(srNo).append( "]]></sr_no>\r\n"); // Added By Shahu Mali on  28/12/12
						valueXmlString.append("<short_id><![CDATA[NA]]></short_id>\r\n");
						valueXmlString.append("<strg_code><![CDATA[-NA-]]></strg_code>\r\n");
						valueXmlString.append("<cust_name><![CDATA[-NA-]]></cust_name>\r\n");
						pstmt.setString(1, checkNull(place));
						rs = pstmt.executeQuery();
						if ( rs.next())
						{
							valueXmlString.append( "<locality_descr><![CDATA[" ).append( checkNull(rs.getString("DESCR"))).append( "]]></locality_descr>\r\n" );
						}
						valueXmlString.append( "<order_booked><![CDATA[" ).append("0").append( "]]></order_booked>\r\n" );
						valueXmlString.append( "<event_time_start><![CDATA[" ).append(eventTime).append( "]]></event_time_start>\r\n" );//VINAYAKK
						int position=startTime.indexOf(':');
						hour = startTime.substring(0,position).trim();
						minute = startTime.substring( position+1 , startTime.length() ).trim();
						int hr=Integer.parseInt(hour);
						int min=Integer.parseInt(minute);

						int intr =0;
						if( interval.length()>0 )
						{
							intr = Integer.parseInt( interval );
							min = min+intr;
							if( min>59 )
							{

								while( min > 59 )
								{
									hr=hr+1;
									min=min-60;
								}
								if( min==0 )
								{
									if( hr < 10 )
									{
										hours = "0"+hr;
									}
									else
									{
										hours = String.valueOf( hr );
									}
									//valueXmlString.append( "<event_time_end><![CDATA[" ).append( checkNull(hours+":00")).append( "]]></event_time_end>\r\n" );
								}
								else
								{
									if( hr < 10 )
									{
										hours="0"+hr;
									}
									else
									{
										hours=String.valueOf( hr );
									}
									if(min<10)
									{
										//valueXmlString.append( "<event_time_end><![CDATA[" ).append( checkNull(hours+":0"+min)).append( "]]></event_time_end>\r\n" );
									}
									else
									{
										//valueXmlString.append( "<event_time_end><![CDATA[" ).append( checkNull(hours+":"+min)).append( "]]></event_time_end>\r\n" );
									}
								}
							}
							else
							{

								if( hr < 10 )
								{
									hours="0"+hr;
								}
								else
								{
									hours=String.valueOf( hr );
								}
								//valueXmlString.append( "<event_time_end><![CDATA[" ).append( checkNull(hours+":"+min)).append( "]]></event_time_end>\r\n" );
							}
						}
						//valueXmlString.append( "<oth_participant><![CDATA[" ).append("").append( "]]></oth_participant>\r\n" );//Gulzar on 17/06/12
						valueXmlString.append( "<event_time_end><![CDATA[" ).append(eventTime).append( "]]></event_time_end>\r\n" );//VINAYAKK

						valueXmlString.append( "<oth_participant><![CDATA[" ).append("").append( "]]></oth_participant>\r\n" );
						valueXmlString.append( "<visited_with_display><![CDATA[" ).append(workWith).append( "]]></visited_with_display>\r\n" );
						if("JW".equalsIgnoreCase(actCode) && "FW".equalsIgnoreCase(actType))//Gulzar on 17/06/12
						{
							valueXmlString.append( "<work_with_other><![CDATA[" ).append(workWithOther).append( "]]></work_with_other>\r\n" );
						}
						else
						{
							valueXmlString.append( "<work_with_other><![CDATA[" ).append("").append( "]]></work_with_other>\r\n" );
						}
						valueXmlString.append( "<work_team><![CDATA[" ).append("Alone").append( "]]></work_team>\r\n" );
						valueXmlString.append( "<sales_pers><![CDATA[" ).append(checkNull(sprsCode)).append( "]]></sales_pers>\r\n" );
						valueXmlString.append( "<chg_date><![CDATA[" ).append(currDate).append( "]]></chg_date>\r\n" );
						valueXmlString.append( "<chg_user><![CDATA[" ).append(userId).append( "]]></chg_user>\r\n" );
						valueXmlString.append( "<chg_term><![CDATA[" ).append(chgTerm).append( "]]></chg_term>\r\n" );
						valueXmlString.append( "<locality_code><![CDATA[" ).append(place).append( "]]></locality_code>\r\n" );
						valueXmlString.append( "<meet_summ><![CDATA[" ).append("").append( "]]></meet_summ>\r\n" );
						valueXmlString.append( "<remarks><![CDATA[" ).append("").append( "]]></remarks>\r\n" );
						valueXmlString.append( "<call_outcome><![CDATA[" ).append("").append( "]]></call_outcome>\r\n" );
						valueXmlString.append( "<sales_pers_sp_name><![CDATA[" ).append("").append( "]]></sales_pers_sp_name>\r\n" );
						valueXmlString.append( "<sprs_code__ww><![CDATA[" ).append("").append( "]]></sprs_code__ww>\r\n" );
						valueXmlString.append( "<event_date><![CDATA[" ).append(trvDate).append( "]]></event_date>\r\n" );
						valueXmlString.append( "<event_type><![CDATA[" ).append(actCode).append( "]]></event_type>\r\n" );
						valueXmlString.append( "<activity_type><![CDATA[" ).append(actType).append( "]]></activity_type>\r\n" );
						valueXmlString.append( "<strg_name><![CDATA[]]></strg_name>\r\n" );
						valueXmlString.append( "<strg_type><![CDATA[ ]]></strg_type>\r\n" );
						valueXmlString.append( "<strg_no_visit><![CDATA[0.0]]></strg_no_visit>\r\n" );
						valueXmlString.append( "<strg_class_code><![CDATA[ ]]></strg_class_code>\r\n" );
						valueXmlString.append( "<sales_team><![CDATA[" ).append("").append( "]]></sales_team>\r\n" );
						valueXmlString.append( "<template_file><![CDATA[" ).append("").append( "]]></template_file>\r\n" );
						valueXmlString.append( "<last_meet_summ><![CDATA[" ).append("").append( "]]></last_meet_summ>\r\n" );
						valueXmlString.append( "<last_meet_date><![CDATA[" ).append("").append( "]]></last_meet_date>\r\n" );
						valueXmlString.append( "<last_prod_brf><![CDATA[" ).append("").append( "]]></last_prod_brf>\r\n" );
						valueXmlString.append( "<ref_tran_id><![CDATA[" ).append("").append( "]]></ref_tran_id>\r\n" );
						valueXmlString.append( "<conf_date><![CDATA[" ).append("").append( "]]></conf_date>\r\n" );
						valueXmlString.append( "<confirmed><![CDATA[" ).append("").append( "]]></confirmed>\r\n" );
						valueXmlString.append( "<emp_code__aprv><![CDATA[" ).append("").append( "]]></emp_code__aprv>\r\n" );
						valueXmlString.append( "<sc_code__ref><![CDATA[" ).append("").append( "]]></sc_code__ref>\r\n" );
						valueXmlString.append( "<meet_summ_mgr><![CDATA[" ).append("").append( "]]></meet_summ_mgr>\r\n" );
						//valueXmlString.append( "<dcr_id><![CDATA[]]></dcr_id>\r\n" );
						valueXmlString.append( "<dcr_id><![CDATA[" ).append(dcrID).append( "]]></dcr_id>\r\n" );
						valueXmlString.append( "<doc_visit_dates><![CDATA[" ).append("").append( "]]></doc_visit_dates>\r\n" );//Gulzar on 17/06/12
						valueXmlString.append( "<addr1><![CDATA[]]></addr1>\r\n" );//Gulzar on 17/06/12
						valueXmlString.append( "<addr2><![CDATA[]]></addr2>\r\n" );//Gulzar on 17/06/12
						valueXmlString.append( "<addr3><![CDATA[]]></addr3>\r\n" );//Gulzar on 17/06/12
						valueXmlString.append( "<order_of_visit><![CDATA[" ).append("").append( "]]></order_of_visit>\r\n" );
						valueXmlString.append( "<add_geopos><![CDATA[" ).append("").append( "]]></add_geopos>\r\n" );
						valueXmlString.append( "<chg_geopos><![CDATA[" ).append("").append( "]]></chg_geopos>\r\n" );
						String visitedWith = checkNull(genericUtility.getColumnValue("visited_with", dom2, "1"));
						valueXmlString.append( "<select_team><![CDATA[" ).append(visitedWith).append( "]]></select_team>\r\n" );
						valueXmlString.append( "<validate_no_visit><![CDATA[" ).append( checkNull(parmValue) ).append( "]]></validate_no_visit>\r\n" );
						valueXmlString.append( "</Detail"+currentForm+">\r\n" );
						domID++;
					}
					if (rs!= null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt!=null)
					{
						pstmt.close();
						pstmt = null;
					}
				}


			}
			else
			{
				rs = pstmt.executeQuery();
				System.out.println("Inside Add... else loop");
				while(rs.next())
				{
					srNo++;
					strgCode = rs.getString("CODE");
					//added by mrunalini sinkar on 20-may-2017 to protect subform when number of visit are excced(start)
					int visit=0;
					//added by mrunalini sinkar to provide multiple locality selection on 17-nov-2018(start)
					String strgVisitHrsLoc = getLocalityVisitHours(strgCode,sprsCode,connectionObject);
					//added by mrunalini sinkar to provide multiple locality selection on 17-nov-2018(end)

					String noOfVisit = rs.getString("NO_VISIT") ;
					if(noOfVisit!=null)
					{
						visit=Integer.parseInt(noOfVisit);
					}
					//added by mrunalini sinkar on 20-may-2017 to protect subform when number of visit are excced(end)
					if(parmValue.equalsIgnoreCase("Y"))
					{
						visitDatesInMonth = getDocVistDatesInMonth(strgCode,sprsCode,trvDate,connectionObject);
					}
					int strgPriorVisitNo = 0;
					if(visitDatesInMonth != null && visitDatesInMonth.trim().length() > 0)
					{
						String strgPriorVisit [] = visitDatesInMonth.split(",");
						strgPriorVisitNo = strgPriorVisit.length;
					}

					String isOtherVisit = checkNull(genericUtility.getColumnValue("other_visit", dom2, "2"));
					String isDrVisit = checkNull(genericUtility.getColumnValue("dr_visit", dom2, "2"));
					String isChemVisit = checkNull(genericUtility.getColumnValue("chem_visit", dom2, "2"));
					String isStockVisit = checkNull(genericUtility.getColumnValue("stockist_visit", dom2, "2"));
					if("2".equalsIgnoreCase(currentForm.trim()))
					{
						if(custList != null && custList.size() > 0 && custList.contains(rs.getString("CODE").trim()) && "Y".equalsIgnoreCase(copyPlan) && "Y".equalsIgnoreCase(isDrVisit))
						{
							//commented by mrunalini sinkar for remove the no of visit code changes on 23-April-2018(start)
							/*if(strgPriorVisitNo > visit && noOfVisit!= null)  // added by mrunalini sinkar
							{
								valueXmlString.append( "<Detail"+currentForm+" domID='"+domID+"' selected = 'Y' formName='"+formName+"'  protectSubform=\"3,4\"><protect_subform><![CDATA[4,5,6,7]]></protect_subform>\r\n" );
								valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"A\" status=\"N\" pkNames=\"\" protectSubform=\"3,4\"/>\r\n");
								valueXmlString.append( "<meet_summ protect='1'><![CDATA[" ).append("").append( "]]></meet_summ>\r\n" );
								valueXmlString.append( "<call_outcome protect='1'><![CDATA[" ).append("5").append( "]]></call_outcome>\r\n" );
							}
							else
							{*/
							//commented by mrunalini sinkar for remove the no of visit code changes on 23-April-2018(end)
								valueXmlString.append( "<Detail"+currentForm+" domID='"+domID+"' selected = 'Y' formName='"+formName+"' >\r\n" );
								valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");//Gaurav Singh on 03/06/15
								System.out.println("Value in IF 2 form:-- ");
							//}
						}
						else
						{
							//commented by mrunalini sinkar for remove the no of visit code changes on 23-April-2018(start)
							/*if(strgPriorVisitNo > visit && noOfVisit!= null) // added by mrunalini sinkar
							{
								valueXmlString.append( "<Detail"+currentForm+" domID='"+domID+"' selected = 'N' formName='"+formName+"'  protectSubform=\"3,4\"><protect_subform><![CDATA[4,5,6,7]]></protect_subform>\r\n" );
								valueXmlString.append( "<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\" protectSubform=\"3,4\"/>\r\n");
								valueXmlString.append( "<meet_summ protect='1'><![CDATA[" ).append("").append( "]]></meet_summ>\r\n" );
								valueXmlString.append( "<call_outcome protect='1'><![CDATA[" ).append("5").append( "]]></call_outcome>\r\n" );
							}
							else
							{*/
							//commented by mrunalini sinkar for remove the no of visit code changes on 23-April-2018(end)
								valueXmlString.append( "<Detail"+currentForm+" domID='"+domID+"' selected = 'N' formName='"+formName+"' >\r\n" );
								valueXmlString.append( "<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");
								System.out.println("Value in ELSE 2 form:-- ");
							//}

						}
					}

					valueXmlString.append( "<speciality_descr><![CDATA[" ).append(checkNull(rs.getString("SPL_DECR"))).append( "]]></speciality_descr>\r\n" );

					valueXmlString.append("<sr_no><![CDATA[").append(srNo).append("]]></sr_no>\r\n");
					valueXmlString.append("<short_id><![CDATA[").append(checkNull(rs.getString("MPLNO"))).append("]]></short_id>\r\n");
					valueXmlString.append("<strg_code><![CDATA[").append(checkNull(rs.getString("CODE"))).append("]]></strg_code>\r\n");
					valueXmlString.append("<cust_name><![CDATA[").append(checkNull(rs.getString("SC_NAME"))).append("]]></cust_name>\r\n");
					valueXmlString.append( "<order_booked><![CDATA[" ).append("0").append( "]]></order_booked>\r\n" );
					valueXmlString.append( "<event_time_start><![CDATA[" ).append(eventTime).append( "]]></event_time_start>\r\n" );
					String visitedWith = checkNull(genericUtility.getColumnValue("visited_with", dom2, "1"));
					valueXmlString.append( "<select_team><![CDATA[" ).append(visitedWith).append( "]]></select_team>\r\n" );
					int position=startTime.indexOf(':');
					hour = startTime.substring(0,position).trim();
					minute = startTime.substring( position+1 , startTime.length() ).trim();
					int hr=Integer.parseInt(hour);
					int min=Integer.parseInt(minute);

					int intr =0;
					if( interval.length()>0 )
					{
						intr = Integer.parseInt( interval );
						min = min+intr;
						if( min>59 )
						{

							while( min > 59 )
							{
								hr=hr+1;
								min=min-60;
							}
							if( min==0 )
							{
								if( hr < 10 )
								{
									hours = "0"+hr;
								}
								else
								{
									hours = String.valueOf( hr );
								}
								//valueXmlString.append( "<event_time_end><![CDATA[" ).append( checkNull(hours+":00")).append( "]]></event_time_end>\r\n" );//vinayakk
							}
							else
							{
								if( hr < 10 )
								{
									hours="0"+hr;
								}
								else
								{
									hours=String.valueOf( hr );
								}
								if(min<10)
								{
									//valueXmlString.append( "<event_time_end><![CDATA[" ).append( checkNull(hours+":0"+min)).append( "]]></event_time_end>\r\n" );//vinayakk
								}
								else
								{
									//valueXmlString.append( "<event_time_end><![CDATA[" ).append( checkNull(hours+":"+min)).append( "]]></event_time_end>\r\n" );//vinayakk
								}
							}
						}
						else
						{

							if( hr < 10 )
							{
								hours="0"+hr;
							}
							else
							{
								hours=String.valueOf( hr );
							}
							//valueXmlString.append( "<event_time_end><![CDATA[" ).append( checkNull(hours+":"+min)).append( "]]></event_time_end>\r\n" );//vinayakk
						}
						valueXmlString.append( "<event_time_end><![CDATA[" ).append(eventTime).append( "]]></event_time_end>\r\n" );
						valueXmlString.append( "<oth_participant><![CDATA[" ).append(otherParticipant).append( "]]></oth_participant>\r\n" );
						valueXmlString.append( "<visited_with_display><![CDATA[" ).append(workWith).append( "]]></visited_with_display>\r\n" );
						if("JW".equalsIgnoreCase(actCode) && "FW".equalsIgnoreCase(actType))//Gulzar on 17/06/12
						{
							valueXmlString.append( "<work_with_other><![CDATA[" ).append(workWithOther).append( "]]></work_with_other>\r\n" );
						}
						else
						{
							valueXmlString.append( "<work_with_other><![CDATA[" ).append("").append( "]]></work_with_other>\r\n" );
						}
						valueXmlString.append( "<work_team><![CDATA[" ).append("Alone").append( "]]></work_team>\r\n" );
						//Changed By Vidhya on 08/12/09[WS89NOV642 |Commenting work team display]
						//valueXmlString.append( "<work_team_disp><![CDATA[Alone]]></work_team_disp>\r\n" );
						valueXmlString.append( "<sales_pers><![CDATA[" ).append(checkNull(sprsCode)).append( "]]></sales_pers>\r\n" );
						valueXmlString.append( "<chg_date><![CDATA[" ).append(currDate).append( "]]></chg_date>\r\n" );
						valueXmlString.append( "<chg_user><![CDATA[" ).append(userId).append( "]]></chg_user>\r\n" );
						valueXmlString.append( "<chg_term><![CDATA[" ).append(chgTerm).append( "]]></chg_term>\r\n" );
						//added by mrunalini sinkar to provide multiple locality selection on 17-nov-2018(start)
						if(strgVisitHrsLoc.trim().length() > 0)
						{
							String locDescr="";
							String strgVisitHrssql="SELECT DESCR FROM LOCALITY WHERE LOCALITY_CODE = ?";
							strgVisitPstmt =connectionObject.prepareStatement(strgVisitHrssql);
							strgVisitPstmt.setString(1, strgVisitHrsLoc);
							strgVisitRs=strgVisitPstmt.executeQuery();
							if(strgVisitRs.next())
							{
								locDescr = checkNull(strgVisitRs.getString("DESCR"));
							}
							if (strgVisitRs!= null)
							{
								strgVisitRs.close();
								strgVisitRs = null;
							}
							if(strgVisitPstmt!=null)
							{
								strgVisitPstmt.close();
								strgVisitPstmt = null;
							}
							valueXmlString.append( "<locality_code visible='1' protect='0' ><![CDATA[" ).append(strgVisitHrsLoc).append( "]]></locality_code>\r\n" );
							valueXmlString.append( "<locality_descr visible='1' protect='1'><![CDATA[" ).append(locDescr).append( "]]></locality_descr>\r\n" );
						}
						else
						{
							valueXmlString.append( "<locality_code visible='1' protect='0'><![CDATA[" ).append(checkNull(rs.getString("LOCALITY_CODE"))).append( "]]></locality_code>\r\n" );
							valueXmlString.append( "<locality_descr visible='1' protect='1'><![CDATA[" ).append( checkNull(rs.getString("LOC_DESCR"))).append( "]]></locality_descr>\r\n" );


						}
						//added by mrunalini sinkar to provide multiple locality selection on 17-nov-2018(end)

						valueXmlString.append( "<meet_summ><![CDATA[" ).append("").append( "]]></meet_summ>\r\n" );
						valueXmlString.append( "<remarks><![CDATA[" ).append("").append( "]]></remarks>\r\n" );
						//valueXmlString.append( "<call_outcome><![CDATA[" ).append(checkNull("")).append( "]]></call_outcome>\r\n" );

						valueXmlString.append( "<call_outcome><![CDATA[" ).append(checkNull("4")).append( "]]></call_outcome>\r\n" );
						valueXmlString.append( "<calloutcome_descr><![CDATA[" ).append("Very Positive").append( "]]></calloutcome_descr>\r\n" );

						valueXmlString.append( "<sales_pers_sp_name><![CDATA[" ).append("").append( "]]></sales_pers_sp_name>\r\n" );
						valueXmlString.append( "<sprs_code__ww><![CDATA[" ).append("").append( "]]></sprs_code__ww>\r\n" );
						valueXmlString.append( "<event_date><![CDATA[" ).append(trvDate).append( "]]></event_date>\r\n" );
						valueXmlString.append( "<event_type><![CDATA[" ).append(actCode).append( "]]></event_type>\r\n" );
						valueXmlString.append( "<activity_type><![CDATA[" ).append(actType).append( "]]></activity_type>\r\n" );
						valueXmlString.append( "<strg_name><![CDATA[]]></strg_name>\r\n" );
						valueXmlString.append( "<strg_type><![CDATA[" ).append(checkNull(rs.getString("CUST_TYPE"))).append( "]]></strg_type>\r\n" );
						valueXmlString.append( "<strg_no_visit><![CDATA[" ).append(checkNull(rs.getString("NO_VISIT"))).append( "]]></strg_no_visit>\r\n" );
						valueXmlString.append( "<strg_class_code><![CDATA[" ).append(checkNull(rs.getString("CLASS_CODE"))).append( "]]></strg_class_code>\r\n" );
						valueXmlString.append( "<sales_team><![CDATA[" ).append("").append( "]]></sales_team>\r\n" );
						valueXmlString.append( "<template_file><![CDATA[" ).append("").append( "]]></template_file>\r\n" );
						valueXmlString.append( "<last_meet_summ><![CDATA[" ).append("").append( "]]></last_meet_summ>\r\n" );
						valueXmlString.append( "<last_meet_date><![CDATA[" ).append("").append( "]]></last_meet_date>\r\n" );
						valueXmlString.append( "<last_prod_brf><![CDATA[" ).append("").append( "]]></last_prod_brf>\r\n" );
						valueXmlString.append( "<ref_tran_id><![CDATA[" ).append("").append( "]]></ref_tran_id>\r\n" );
						valueXmlString.append( "<conf_date><![CDATA[" ).append("").append( "]]></conf_date>\r\n" );
						valueXmlString.append( "<confirmed><![CDATA[" ).append("").append( "]]></confirmed>\r\n" );
						valueXmlString.append( "<emp_code__aprv><![CDATA[" ).append("").append( "]]></emp_code__aprv>\r\n" );
						valueXmlString.append( "<sc_code__ref><![CDATA[" ).append("").append( "]]></sc_code__ref>\r\n" );
						valueXmlString.append( "<meet_summ_mgr><![CDATA[" ).append("").append( "]]></meet_summ_mgr>\r\n" );
						valueXmlString.append( "<doc_visit_dates><![CDATA[" ).append(strgPriorVisitNo).append( "]]></doc_visit_dates>\r\n" );
						valueXmlString.append( "<addr1><![CDATA[" ).append(checkNull(rs.getString("ADDR1"))).append( "]]></addr1>\r\n" );//Gulzar on 17/06/12
						valueXmlString.append( "<addr2><![CDATA[" ).append(checkNull(rs.getString("ADDR2"))).append( "]]></addr2>\r\n" );//Gulzar on 17/06/12
						valueXmlString.append( "<addr3><![CDATA[" ).append(checkNull(rs.getString("ADDR3"))).append( "]]></addr3>\r\n" );//Gulzar on 17/06/12
						valueXmlString.append( "<order_of_visit><![CDATA[" ).append("").append( "]]></order_of_visit>\r\n" );
						if(chemistExistFlag)
						{
							valueXmlString.append( "<chemist_exist><![CDATA[" ).append("Y").append( "]]></chemist_exist>\r\n" );
						}
						else
						{
							valueXmlString.append( "<chemist_exist><![CDATA[" ).append("N").append( "]]></chemist_exist>\r\n" );
						}
						//valueXmlString.append( "<dcr_id><![CDATA[]]></dcr_id>\r\n" );
						valueXmlString.append( "<dcr_id><![CDATA[" ).append(dcrID).append( "]]></dcr_id>\r\n" );
						valueXmlString.append( "<add_geopos><![CDATA[" ).append("").append( "]]></add_geopos>\r\n" );
						valueXmlString.append( "<chg_geopos><![CDATA[" ).append("").append( "]]></chg_geopos>\r\n" );
						valueXmlString.append( "<sku_value><![CDATA[" ).append("0").append( "]]></sku_value>\r\n" );
					}
					valueXmlString.append( "<validate_no_visit><![CDATA[" ).append( checkNull(parmValue) ).append( "]]></validate_no_visit>\r\n" );
					valueXmlString.append( "</Detail"+currentForm+">\r\n" );
					domID++;
				}//end of while
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			domID = 1;

		}
		catch(Exception e)
		{
			System.out.println( "Exception :WsfaZuviusDsrMobileWizardEJB :getCustomerDetail():" + e.getMessage() + ":" );
			e.printStackTrace();
			//valueXmlString = valueXmlString.append( generateErrorString( genericUtility.createErrorString( e ) ) );
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if( IsLocalConn && connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :WsfaZuviusDsrMobileWizardEJB :getCustomerDetail :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		return valueXmlString.toString();

	}
	//Changed By Vidhya on 15/10/09[WI89BAS033 | changing signature]
	//public String getItemDetail( Document dom, String currentForm, String userId, String sprsCode, String custCode, String actCode) throws ITMException
	public String getItemDetail( Document dom, Document dom2, String currentForm, String userId, String sprsCode, String custCode, String actCode) throws ITMException
	{
		ResultSet rs = null;
		Connection connectionObject = null;
		PreparedStatement pstmt = null;

		String sql = "";
		String sql1 = "";
		String currDate = "";
		String chgTerm ="";
		String preFormDet ="";
		String trvDate = "";
		String preFormItems ="";
		String salesProdItems ="";
		String items ="";
		boolean flag = false;
		StringBuffer valueXmlString = new StringBuffer();
		String [] temp;

		//changed by Rahul Barve on 10-Apr-2015
		//GenericUtility genericUtility = GenericUtility.getInstance();
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		try
		{
			/*ConnDriver connDriver = new ConnDriver();
			connectionObject = connDriver.getConnectDB( "DriverValidator" );*/
			connectionObject = getConnection();//chnged by sachin satre on [11-nov-16] to get connection
			int custForm = Integer.parseInt(currentForm) - 1;
			//to append previous values of current form from current dom on previous action START
			flag = preDomExists( dom, currentForm );
			System.out.println( "history detail exists["+ flag +"]" );
			//COMMENTED BY PRATHAMESH JANGAM FOR JOINS IN DB2
			//sql = "SELECT DISTINCT SPG.SALES_PROD_GRP CODE, SPG.DESCR DESCRIPTION FROM SALES_PROD_GRP SPG, ITEM M  WHERE M.ITEM_CODE IN ( SELECT ITEM_CODE FROM SPRS_ITEM WHERE SALES_PERS = ? ) AND M.SALES_PROD_GRP = SPG.SALES_PROD_GRP( + )";
			sql = "SELECT DISTINCT SPG.SALES_PROD_GRP CODE, SPG.DESCR DESCRIPTION FROM SALES_PROD_GRP SPG left outer join  ITEM M on M.SALES_PROD_GRP = SPG.SALES_PROD_GRP WHERE M.ITEM_CODE IN ( SELECT ITEM_CODE FROM SPRS_ITEM WHERE SALES_PERS = ?) ";

			//sql1 = "SELECT M.ITEM_CODE CODE, M.DESCR DESCRIPTION FROM ITEM M, SALES_PROD_GRP SPG WHERE M.ITEM_CODE IN ( SELECT ITEM_CODE FROM SPRS_ITEM WHERE SALES_PERS = ? ) AND M.SALES_PROD_GRP = SPG.SALES_PROD_GRP( + )";
			sql1 = "SELECT M.ITEM_CODE CODE, M.DESCR DESCRIPTION FROM ITEM M left outer join SALES_PROD_GRP SPG on  M.SALES_PROD_GRP = SPG.SALES_PROD_GRP WHERE M.ITEM_CODE IN ( SELECT ITEM_CODE FROM SPRS_ITEM WHERE SALES_PERS = ?)";
			String actType = getActivityType( actCode, connectionObject );
			//if( "FW".equalsIgnoreCase(actType))
			if( actType.indexOf("NFW") == -1 && actType.indexOf("LEAVE") == -1 )
			{
				pstmt =  connectionObject.prepareStatement( sql );
				pstmt.setString(1, checkNull(sprsCode));
				rs = pstmt.executeQuery();
				while(rs.next())
				{

					valueXmlString.append( "<Detail"+currentForm+" domID='" + domID + "' selected = 'N'>\r\n" );
					valueXmlString.append( "<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");//Gaurav Singh on 03/06/15
					valueXmlString.append("<item_descr><![CDATA[").append(checkNull(rs.getString("DESCRIPTION"))).append("]]></item_descr>\r\n");
					valueXmlString.append( "<quantity><![CDATA[" ).append( "0" ).append( "]]></quantity>\r\n" );					valueXmlString.append("<item_code><![CDATA[").append("").append("]]></item_code>\r\n");
					valueXmlString.append( "<sales_prod_grp><![CDATA[" ).append(checkNull(rs.getString("CODE"))).append( "]]></sales_prod_grp>\r\n" );
					valueXmlString.append("<strg_code><![CDATA[").append(checkNull(custCode)).append("]]></strg_code>\r\n");
					valueXmlString.append("<line_no><![CDATA[]]></line_no>\r\n");
					valueXmlString.append( "<item_type><![CDATA[" ).append("").append( "]]></item_type>\r\n" );
					valueXmlString.append( "<briefed><![CDATA[" ).append("").append( "]]></briefed>\r\n" );
					valueXmlString.append( "<item_pob><![CDATA[" ).append("").append( "]]></item_pob>\r\n" );
					valueXmlString.append( "<dcr_id><![CDATA[]]></dcr_id>\r\n" );
					valueXmlString.append( "<briefed_descr><![CDATA[" ).append("P1").append( "]]></briefed_descr>\r\n" );
					valueXmlString.append( "</Detail"+currentForm+">\r\n" );
					domID++;

				}
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}

				pstmt =  connectionObject.prepareStatement( sql1 );
				pstmt.setString(1, checkNull(sprsCode));
				rs = pstmt.executeQuery();
				while(rs.next())
				{
					valueXmlString.append( "<Detail"+currentForm+" domID='" + domID + "' selected = 'N'>\r\n" );
					valueXmlString.append( "<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");//Gaurav Singh on 03/06/15
					valueXmlString.append("<item_descr><![CDATA[").append(checkNull(rs.getString("DESCRIPTION"))).append("]]></item_descr>\r\n");
					valueXmlString.append( "<quantity><![CDATA[" ).append( "0" ).append( "]]></quantity>\r\n" );					valueXmlString.append("<item_code><![CDATA[").append(checkNull(rs.getString("CODE"))).append("]]></item_code>\r\n");
					valueXmlString.append( "<sales_prod_grp><![CDATA[" ).append("").append( "]]></sales_prod_grp>\r\n" );
					valueXmlString.append("<strg_code><![CDATA[").append(checkNull(custCode)).append("]]></strg_code>\r\n");
					valueXmlString.append("<line_no><![CDATA[]]></line_no>\r\n");
					valueXmlString.append( "<item_type><![CDATA[" ).append("").append( "]]></item_type>\r\n" );
					valueXmlString.append( "<briefed><![CDATA[" ).append("").append( "]]></briefed>\r\n" );
					valueXmlString.append( "<item_pob><![CDATA[" ).append("").append( "]]></item_pob>\r\n" );
					valueXmlString.append( "<dcr_id><![CDATA[]]></dcr_id>\r\n" );
					valueXmlString.append( "<briefed_descr><![CDATA[" ).append("Promo Material").append( "]]></briefed_descr>\r\n" );
					valueXmlString.append( "</Detail"+currentForm+">\r\n" );
					domID++;
				}
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				domID = 1;
			}
			if(flag)
			{
				//Changed By Vidhya on 15/10/09[WI89BAS033 | changing signature]
				//preFormDet = getPrevFormValues( dom, currentForm, domID );
				String customers = getCustFromDom( dom2, Integer.toString( custForm ), sprsCode,connectionObject ); //Chnaged by sachin satre on 11-nov-16
				temp = customers.split(",");
				preFormDet = getPrevFormValues( dom, currentForm, new ArrayList<String>( Arrays.asList( temp ) ), "strg_code" );
				if( preFormDet != null || !"null".equalsIgnoreCase(preFormDet))
				{
					valueXmlString.append( preFormDet );
					domID = domID + 1;
				}

			}
			else
			{
				trvDate =  getSelectedRowValue( dom2, "1", "event_date", 0);
				if ( trvDate != null )
				{
					trvDate = genericUtility.getValidDateString( trvDate , getApplDateFormat() , "dd-MMM-yyyy");
				}

				String dcrID = "";
				String smiQuery = "SELECT DCR_ID FROM SPRS_ACT_TRAN WHERE EVENT_DATE =? AND SALES_PERS = ?";
				pstmt = connectionObject.prepareStatement( smiQuery );
				//pstmt.setString(1, trvDate);//Shahu - 27/10/12
				pstmt.setTimestamp(1, java.sql.Timestamp.valueOf(trvDate));//Shahu - 27/10/12
				pstmt.setString(2, sprsCode);
				rs = pstmt.executeQuery();
				while( rs.next() )
				{
					dcrID = checkNull(rs.getString("DCR_ID"));
				}
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}


				//smiQuery = "SELECT ITEM.DESCR DESCR, LINE_NO, ITEM_POB, STRG_MEET_ITEMS.ITEM_CODE, STRG_MEET_ITEMS.SALES_PROD_GRP, STRG_CODE, ITEM.ITEM_TYPE, ITEM.ITEM_USAGE, STRG_MEET_ITEMS.BRIEFED, STRG_MEET_ITEMS.QUANTITY, STRG_MEET_ITEMS.BRIEFED_DESCR, SALES_PROD_GRP.DESCR AS SPG_DESCR FROM STRG_MEET_ITEMS, ITEM ITEM ,SALES_PROD_GRP SALES_PROD_GRP  WHERE (STRG_MEET_ITEMS.ITEM_CODE = ITEM.ITEM_CODE (+)) AND (STRG_MEET_ITEMS.SALES_PROD_GRP = SALES_PROD_GRP.SALES_PROD_GRP (+)) AND STRG_MEET_ITEMS.DCR_ID= '"+dcrID+"' ";
				smiQuery = "SELECT ITEM.DESCR DESCR, LINE_NO, ITEM_POB, STRG_MEET_ITEMS.ITEM_CODE, STRG_MEET_ITEMS.SALES_PROD_GRP, STRG_CODE, ITEM.ITEM_TYPE, ITEM.ITEM_USAGE, STRG_MEET_ITEMS.BRIEFED, STRG_MEET_ITEMS.QUANTITY, STRG_MEET_ITEMS.BRIEFED_DESCR, SALES_PROD_GRP.DESCR AS SPG_DESCR " +
						"   FROM STRG_MEET_ITEMS LEFT OUTER JOIN ITEM ITEM ON (STRG_MEET_ITEMS.ITEM_CODE = ITEM.ITEM_CODE ) LEFT OUTER JOIN SALES_PROD_GRP SALES_PROD_GRP ON (STRG_MEET_ITEMS.SALES_PROD_GRP = SALES_PROD_GRP.SALES_PROD_GRP ) " +
						"   WHERE STRG_MEET_ITEMS.DCR_ID= '"+dcrID+"' ";

				pstmt = connectionObject.prepareStatement(smiQuery);
				rs = pstmt.executeQuery();
				while(rs.next())
				{
					String item = checkNull(rs.getString("DESCR"));
					String sprogrp = checkNull(rs.getString("SPG_DESCR"));


					valueXmlString.append( "<Detail5 domID='" + domID + "' selected = 'Y'>\r\n" );
					valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");//Gaurav Singh on 03/06/15
					if( !item.equals("") )
					{
						valueXmlString.append("<item_descr>").append( item ).append("</item_descr>\n");

					}
					else if ( ! sprogrp.equals("") )
					{
						valueXmlString.append("<item_descr>").append(sprogrp).append("</item_descr>\n");
					}

					//valueXmlString.append("<quantity>").append(checkNull(rs.getString("QUANTITY"))).append("</quantity>\n");//Gulzar
					valueXmlString.append("<quantity>").append(rs.getInt("QUANTITY")).append("</quantity>\n");//Gulzar
					valueXmlString.append("<item_code><![CDATA[").append(checkNull(rs.getString("ITEM_CODE"))).append("]]></item_code>\n");
					valueXmlString.append("<sales_prod_grp><![CDATA[").append(checkNull(rs.getString("SALES_PROD_GRP"))).append("]]></sales_prod_grp>\n");
					valueXmlString.append("<strg_code><![CDATA[").append( checkNull(rs.getString("STRG_CODE")) ).append("]]></strg_code>\r\n");
					valueXmlString.append("<line_no><![CDATA[").append( checkNull(rs.getString("LINE_NO")) ).append("]]></line_no>\r\n");

					valueXmlString.append( "<item_type><![CDATA[" ).append( checkNull(rs.getString("ITEM_TYPE")) ).append( "]]></item_type>\r\n" );
					valueXmlString.append( "<briefed><![CDATA[" ).append( checkNull(rs.getString("BRIEFED"))).append( "]]></briefed>\r\n" );
					valueXmlString.append( "<item_pob><![CDATA[" ).append( checkNull(rs.getString("ITEM_POB")) ).append( "]]></item_pob>\r\n" );
					valueXmlString.append( "<briefed_descr><![CDATA[" ).append( checkNull(rs.getString("BRIEFED_DESCR")) ).append( "]]></briefed_descr>\r\n" );

					valueXmlString.append( "</Detail5>\r\n" );
					domID++;

				}
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
			}


		}
		catch(Exception e)
		{
			System.out.println( "Exception :WsfaZuviusDsrMobileWizardEJB :defaultDataWiz(Document,String):" + e.getMessage() + ":" );
			//valueXmlString = valueXmlString.append( generateErrorString( genericUtility.createErrorString( e ) ) );
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}

				if( connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :WsfaZuviusDsrMobileWizardEJB :defaultDataWiz :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		return valueXmlString.toString();

	}

	//New overloaded method is added to select the pitch detail - Gulzar on 18/06/12

	//Getting Default Values for forms End*********

	//Utility Functions Start****************
	//*****Public Methods ***** Start
	//to get StanCodeFrom of the salesPerson's last visited place from DB
	//Commented by Gaurav Singh on 02-Jun-2015 for Request Id [W15BMIT002].Start
	/*
	public String getStanCodeFrom( Connection con, String userId, String currDate ) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String localityCodeFrom = "";
		//changed by Rahul Barve on 10-Apr-2015
		//GenericUtility genericUtility = GenericUtility.getInstance();
		 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		try
		{
			//Commented and changes by gulzar to get the last sation based on their max ordr of visit
			String stanCodeSql = "SELECT ST.LOCALITY_CODE FROM  SPRS_TRAVEL ST, LOCALITY LOC "+
								" WHERE ORDER_OF_VISIT = ( SELECT MAX( ORDER_OF_VISIT) "+
								" FROM SPRS_TRAVEL WHERE SALES_PERS= ? AND TRAVEL_DATE =(SELECT MAX(TRAVEL_DATE) FROM SPRS_TRAVEL WHERE SALES_PERS=?) ) "+
								" AND LOC.LOCALITY_CODE = ST.LOCALITY_CODE "+
								" AND ST.SALES_PERS= ? AND ST.TRAVEL_DATE  =(SELECT MAX(TRAVEL_DATE) FROM SPRS_TRAVEL WHERE SALES_PERS=?) ";
			//pstmt =  con.prepareStatement( "SELECT ST.LOCALITY_CODE FROM  SPRS_TRAVEL ST, LOCALITY LOC WHERE TRAN_ID = ( SELECT MAX( TRAN_ID ) FROM SPRS_TRAVEL WHERE SALES_PERS= ? AND TRAVEL_DATE <= ? ) AND LOC.LOCALITY_CODE = ST.LOCALITY_CODE" );
			pstmt =  con.prepareStatement(stanCodeSql);
			pstmt.setString(1, userId );
			//pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
			pstmt.setString(2, userId );
			pstmt.setString(3, userId );
			pstmt.setString(4, userId );
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				localityCodeFrom = rs.getString(1);
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}

		}
		catch ( Exception e )
		{
			System.out.println( "Exception :WsfaZuviusDsrMobileWizardEJB :defaultDataWiz :==>\n"+e.getMessage());
			throw new ITMException(e);
		}

		return localityCodeFrom;
	}
	 */
	//Commented by Gaurav Singh on 02-Jun-2015 for Request Id [W15BMIT002].End
	//to check if input is null or "null"
	public String checkNull(String input)
	{
		if (input == null || "null".equalsIgnoreCase(input))
		{
			input= "";
		}
		return input.trim();
	}
	//to check if current dom contains values (for previous action)
	public boolean preDomExists(Document dom, String currentFormNo) throws ITMException
	{
		NodeList parentList = null;
		NodeList childList = null;
		Node childNode = null;
		boolean selected = false;

		try
		{
			parentList = dom.getElementsByTagName("Detail" + currentFormNo);
			if ( parentList.item(0) != null )
			{
				childList = parentList.item(0).getChildNodes();
				for (int ctr = 0; ctr < childList.getLength(); ctr++)
				{
					childNode = childList.item(ctr);
					if((childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null))
					{
						System.out.println("Column found!!!" + childNode.getNodeName());
						selected = true;
						break;
					}
				}
			}


		}
		catch ( Exception e )
		{
			System.out.println( "Exception :WsfaZuviusDsrMobileWizardEJB :preDomExists :==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		System.out.println("preDomExists =["+selected+"] and currentFormNo =["+currentFormNo+"]");

		return selected;
	}

	//to get previous dom values and set selected attribute to 'y' (for previous action)
	public String getPrevFormValues( Document dom, String currentFormNo, ArrayList temp, String colName) throws ITMException
	{
		//changed by Rahul Barve on 10-Apr-2015
		//GenericUtility genericUtility = GenericUtility.getInstance();
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		Element elementAttr = null;
		String childNodeName = "";
		String columnValue = "";
		String returnPrevStr = "";
		Document chgPreDom = null;
		try
		{
			chgPreDom = genericUtility.parseString("<Root/>");
			System.out.println("currentFormNo ["+currentFormNo+"]");
			parentList = dom.getElementsByTagName("Detail" + currentFormNo);
			int parentNodeListLength = parentList.getLength();
			for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
			{
				parentNode = parentList.item(prntCtr);
				childList = parentNode.getChildNodes();
				for (int ctr = 0; ctr < childList.getLength(); ctr++)
				{
					childNode = childList.item(ctr);

					if((childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null))
					{
						columnValue = childNode.getFirstChild().getNodeValue().trim();
						if ( childNode.getNodeName().equalsIgnoreCase(colName) && temp.contains("'"+columnValue+"'"))
						{
							elementAttr = (Element)parentNode;
							if ( parentNode.getAttributes().getNamedItem( "domID" ) != null )
							{
								//elementAttr.setAttribute( "domID" , Integer.toString(domID) );
								elementAttr.setAttribute( "selected" , "Y" );
								domID++;
							}
							Node importedNode = chgPreDom.importNode( parentNode, true );
							chgPreDom.getDocumentElement().appendChild( importedNode );
							break;
						}

					}
				}

			}
			if(currentFormNo.equals("1"))
			{
				domID = 1;
			}
			returnPrevStr = genericUtility.serializeDom(chgPreDom);
			if(returnPrevStr.indexOf("Detail"+currentFormNo) != -1)
			{
				returnPrevStr = returnPrevStr.substring(returnPrevStr.indexOf(">") + 1, returnPrevStr.lastIndexOf("</"));
			}
			returnPrevStr = returnPrevStr.indexOf("Detail"+currentFormNo) != -1 ? returnPrevStr : "";
		}
		catch ( Exception e )
		{
			System.out.println( "Exception :WsfaZuviusDsrMobileWizardEJB :getPrevFormValues :==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		return returnPrevStr;

	}
	public String getLocFromDom(Document dom, String currentForm, String sprsCode,Connection connectionObject) throws ITMException //Chnaged by sachin satre on 11-nov-16
	{
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;

		//Connection connectionObject = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null ;
		StringBuffer localityBuff = new StringBuffer();
		ArrayList temp = new ArrayList(100);
		String sql = "";
		String columnValue = "";
		boolean isLocalConn =false;
		try
		{
			if(connectionObject == null)
			{
				/*ConnDriver connDriver = new ConnDriver();
				connectionObject = connDriver.getConnectDB("Driver");*/
				connectionObject = getConnection();//chnged by sachin satre on [11-nov-16] to get connection
				isLocalConn =true;
			}
			sql = "SELECT * FROM SPRS_ROUTE WHERE SPRS_CODE = ? AND LOCALITY_CODE = ?";
			//Changed By Vidhya on 16/12/09[WS89NOV642 | to make connection before any loop]
			pstmt = connectionObject.prepareStatement(sql);

			parentList = dom.getElementsByTagName("Detail" + currentForm);
			int parentNodeListLength = parentList.getLength();
			for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
			{
				parentNode = parentList.item(prntCtr);
				childList = parentNode.getChildNodes();

				for (int ctr = 0; ctr < childList.getLength(); ctr++)
				{
					childNode = childList.item(ctr);
					if ( childNode != null && childNode.getFirstChild() != null )
					{
						columnValue = childNode.getFirstChild().getNodeValue().trim();
					}
					if( childNode.getNodeName().equalsIgnoreCase("locality_code"))
					{

						if ( temp.contains(columnValue))
						{
							continue;
						}

						pstmt.setString(1, sprsCode);
						pstmt.setString(2, columnValue);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							if(localityBuff.length() == 0)
							{
								localityBuff.append("'").append(columnValue.toUpperCase()).append("'");
							}
							else
							{
								localityBuff.append(",'").append(columnValue.toUpperCase()).append("'");
							}
						}
						temp.add(columnValue);
					}
				}
			}

			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			temp.clear();

		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if (isLocalConn && connectionObject != null )
				{
					connectionObject.close();
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}

		return localityBuff.toString();

	}

	//get location selected from given dom in a String Buffer
	public String getLocFromDom(Document dom, String currentForm, String sprsCode, String custType,Connection connectionObject) throws ITMException //Chnaged by sachin satre on 11-nov-16
	{
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;

		//Connection connectionObject = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null ;
		StringBuffer localityBuff = new StringBuffer();
		ArrayList temp = new ArrayList(100);
		String sql = "";
		String columnValue = "";
		String drVisit = "";//Gulzar  on 6/10/2012
		String chemVisit = "";//Gulzar on 17/06/12
		String stockVisit = "";//Gulzar on 17/06/12
		String othVisit = "";//Gulzar on 17/06/12
		String localityCode = "";//Gulzar  on 6/10/2012
		boolean isLocalConn =false;
		try
		{
			if(connectionObject == null )
			{
				/*ConnDriver connDriver = new ConnDriver();
				connectionObject = connDriver.getConnectDB("Driver");*/
				connectionObject = getConnection();//chnged by sachin satre on [11-nov-16] to get connection
				isLocalConn =true;
			}
			//changed by Rahul Barve on 10-Apr-2015
			//GenericUtility genericUtility = GenericUtility.getInstance();
			E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

			System.out.println("dom2:::"+genericUtility.serializeDom(dom));

			String activityCode = genericUtility.getColumnValue("activity_code", dom, "1");
			String activityType = checkNull(getActivityType(activityCode, connectionObject));
			if (!"FW".equalsIgnoreCase(activityType))
			{
				String localityDetail = getLocFromDom(dom, currentForm, sprsCode,connectionObject); //Chnaged by sachin satre on 11-nov-16
				System.out.println("localityDetail :::"+localityDetail);
				return localityDetail;
			}

			sql = "SELECT * FROM SPRS_ROUTE WHERE SPRS_CODE = ? AND LOCALITY_CODE = ?";
			//Changed By Vidhya on 16/12/09[WS89NOV642 | to make connection before any loop]
			pstmt = connectionObject.prepareStatement(sql);

			parentList = dom.getElementsByTagName("Detail" + currentForm);
			int parentNodeListLength = parentList.getLength();
			for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
			{
				parentNode = parentList.item(prntCtr);
				childList = parentNode.getChildNodes();

				drVisit = "";
				localityCode = "";
				String updateFlag = "";
				for (int ctr = 0; ctr < childList.getLength(); ctr++)
				{
					childNode = childList.item(ctr);
					if ( childNode != null && childNode.getFirstChild() != null )
					{
						columnValue = childNode.getFirstChild().getNodeValue().trim();
					}
					//Added by vinayak
					System.out.println("Outside if flag:-");
					if(childNode.getNodeName().equalsIgnoreCase("attribute"))
					{
						//if(childNode.getAttributes().getNamedItem("updateFlag") != null)
						if(childNode.getAttributes().getNamedItem("updateFlag") != null)
						{
							System.out.println("Outside if flag232:-");
							updateFlag = childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
						}
					}
					//Added by vinayak
					System.out.println("Value of update flag:-  "+updateFlag);
					if(!updateFlag.trim().equalsIgnoreCase("D"))
					{
						//System.out.println("Value of update flag:-  "+updateFlag);
						if( childNode.getNodeName().equalsIgnoreCase("locality_code"))
						{
							if ( temp.contains(columnValue))
							{
								continue;
							}
							localityCode = columnValue;

							/*--Gulzar on 6/11/2012
							pstmt.setString(1, sprsCode);
							pstmt.setString(2, columnValue);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								if(localityBuff.length() == 0)
								{
									localityBuff.append("'").append(columnValue.toUpperCase()).append("'");
								}
								else
								{
									localityBuff.append(",'").append(columnValue.toUpperCase()).append("'");
								}
							}
							temp.add(columnValue);
							 */
						}
						else if( childNode.getNodeName().equalsIgnoreCase("dr_visit"))
						{
							drVisit = columnValue;
						}
						else if( childNode.getNodeName().equalsIgnoreCase("chem_visit"))
						{
							chemVisit = columnValue;
						}
						//changed by rahul barve on 6-apr-2015 [Start] to display stockist details.
						else if( childNode.getNodeName().equalsIgnoreCase("stockist_visit"))
						{
							stockVisit = columnValue;
						}
						else if( childNode.getNodeName().equalsIgnoreCase("other_visit"))
						{
							othVisit = columnValue;
						}
					}
					//changed by rahul barve on 6-apr-2015 [End] to display stockist details.
				}
				System.out.println("drVisit=["+drVisit+"]");
				System.out.println("localityCode=["+localityCode+"]");
				int countLoc = 0;
				if(!updateFlag.trim().equalsIgnoreCase("D"))
				{
					if ( "D".equalsIgnoreCase(custType) && drVisit != null && drVisit.trim().length() > 0 && "Y".equalsIgnoreCase(drVisit.trim()) && localityCode != null && localityCode.trim().length() > 0 )
					{
						pstmt.setString(1, sprsCode);
						pstmt.setString(2, localityCode);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							if(localityBuff.length() == 0)
							{
								localityBuff.append("'").append(localityCode.toUpperCase()).append("'");
							}
							else
							{
								localityBuff.append(",'").append(localityCode.toUpperCase()).append("'");
							}
						}
						pstmt.clearParameters();
						temp.add(localityCode);
						countLoc++;
					}
					else if ( "C".equalsIgnoreCase(custType) && chemVisit != null && chemVisit.trim().length() > 0 && "Y".equalsIgnoreCase(chemVisit.trim()) && localityCode != null && localityCode.trim().length() > 0 )
					{
						pstmt.setString(1, sprsCode);
						pstmt.setString(2, localityCode);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							if(localityBuff.length() == 0)
							{
								localityBuff.append("'").append(localityCode.toUpperCase()).append("'");
							}
							else
							{
								localityBuff.append(",'").append(localityCode.toUpperCase()).append("'");
							}
						}
						pstmt.clearParameters();
						temp.add(localityCode);
						countLoc++;
					}
					//changed by rahul barve on 6-apr-2015 [Start] to display stockist details.
					else if ( "S".equalsIgnoreCase(custType) && stockVisit != null && stockVisit.trim().length() > 0 && "Y".equalsIgnoreCase(stockVisit.trim()) && localityCode != null && localityCode.trim().length() > 0 )
					{
						pstmt.setString(1, sprsCode);
						pstmt.setString(2, localityCode);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							if(localityBuff.length() == 0)
							{
								localityBuff.append("'").append(localityCode.toUpperCase()).append("'");
							}
							else
							{
								localityBuff.append(",'").append(localityCode.toUpperCase()).append("'");
							}
						}
						pstmt.clearParameters();
						temp.add(localityCode);
						countLoc++;
					}
					else if ( "O".equalsIgnoreCase(custType) && othVisit != null && othVisit.trim().length() > 0 && "Y".equalsIgnoreCase(othVisit.trim()) && localityCode != null && localityCode.trim().length() > 0 )
					{
						pstmt.setString(1, sprsCode);
						pstmt.setString(2, localityCode);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							if(localityBuff.length() == 0)
							{
								localityBuff.append("'").append(localityCode.toUpperCase()).append("'");
							}
							else
							{
								localityBuff.append(",'").append(localityCode.toUpperCase()).append("'");
							}
						}
						pstmt.clearParameters();
						temp.add(localityCode);
						countLoc++;
					}
					/*
						else if(countLoc == 0)
						{
							pstmt.setString(1, sprsCode);
							pstmt.setString(2, localityCode);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								if(localityBuff.length() == 0)
								{
									localityBuff.append("'").append(localityCode.toUpperCase()).append("'");
								}
								else
								{
									localityBuff.append(",'").append(localityCode.toUpperCase()).append("'");
								}
							}
							pstmt.clearParameters();
							temp.add(localityCode);
						}
					 */

				}
				//changed by rahul barve on 6-apr-2015 [End] to display stockist details.
			}

			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			temp.clear();

		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if (isLocalConn && connectionObject != null)
				{
					connectionObject.close();
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		System.out.println("localityBuff =["+localityBuff.toString()+"]");

		return localityBuff.toString();

	}
	//get customers selected from given dom in a String Buffer
	public String getCustFromDom( Document dom, String currentForm, String sprsCode ,Connection connectionObject) throws ITMException //Chnaged by sachin satre on 11-nov-16
	{
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;

		//Connection connectionObject = null;
		//Changed By Vidhya on 16/12/09[WS89NOV642 | to make connection before any loop]
		//Statement stmt = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null ;
		StringBuffer custBuff = new StringBuffer();
		ArrayList temp = new ArrayList(100);
		String sql = "";
		String columnValue = "";
		boolean isLocalConn=false;
		try
		{
			if(connectionObject == null)
			{
				/*ConnDriver connDriver = new ConnDriver();
				connectionObject = connDriver.getConnectDB("Driver");*/
				connectionObject = getConnection();//chnged by sachin satre on [11-nov-16] to get connection
				isLocalConn =true;
			}
			parentList = dom.getElementsByTagName("Detail" + currentForm);
			int parentNodeListLength = parentList.getLength();
			//Changed By Vidhya on 16/12/09[WS89NOV642 | to make connection before any loop] Start
			sql = "SELECT * FROM STRG_SERIES SS, STRG_CUSTOMER SC WHERE SS.SC_CODE = SC.SC_CODE AND SS.SALES_PERS = ? AND LOCALITY_CODE = ? AND SS.SC_CODE = ?";
			pstmt = connectionObject.prepareStatement(sql);
			//Changed By Vidhya on 16/12/09[WS89NOV642 | to make connection before any loop] end
			for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
			{
				String locality = getSelectedRowValue( dom, currentForm, "locality_code", prntCtr);

				parentNode = parentList.item(prntCtr);
				childList = parentNode.getChildNodes();

				for (int ctr = 0; ctr < childList.getLength(); ctr++)
				{
					childNode = childList.item(ctr);
					if ( childNode != null && childNode.getFirstChild() != null &&  childNode.getNodeName().equalsIgnoreCase("strg_code") )
					{
						columnValue = childNode.getFirstChild().getNodeValue();

						if( temp.contains(columnValue) )
						{
							continue;
						}
						//Changed By Vidhya on 16/12/09[WS89NOV642 | to make connection before any loop]Start
						pstmt.setString(1, sprsCode);
						pstmt.setString(2, locality);
						pstmt.setString(3, columnValue);
						rs = pstmt.executeQuery();
						//Changed By Vidhya on 16/12/09[WS89NOV642 | to make connection before any loop] End
						if( rs.next() )
						{
							if( custBuff.length() == 0)
							{
								custBuff.append("'").append( columnValue ).append("'");
							}
							else
							{
								custBuff.append(",'").append( columnValue ).append("'");
							}
						}
						//added by rakesh kumar 14/12/12.
						if (rs!= null)
						{
							rs.close();
							rs = null;
						}
						temp.add( columnValue );

					}
				}
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			temp.clear();

		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				//Changed By Vidhya on 16/12/09[WS89NOV642 | to make connection before any loop] End

				if (isLocalConn && connectionObject != null)
				{
					connectionObject.close();
					connectionObject=null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return custBuff.toString();
	}

	//Vidhya on 23/10/09 overloaded method to get previoulsy customers selected from given dom in a String Buffer
	public String getCustFromDom( Document dom, String currentForm, String sprsCode, String attrValue ,Connection connectionObject) throws ITMException //Chnaged by sachin satre on 11-nov-16
	{
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;

		//Connection connectionObject = null;
		//Changed By Vidhya on 16/12/09[WS89NOV642 | to make connection before any loop]
		//Statement stmt = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null ;
		StringBuffer custBuff = new StringBuffer();
		ArrayList temp = new ArrayList(100);
		String sql = "";
		String columnValue = "";
		boolean isLocalConn =false;
		try
		{
			if( connectionObject == null)
			{
				/*ConnDriver connDriver = new ConnDriver();
				connectionObject = connDriver.getConnectDB("Driver");*/
				connectionObject = getConnection();//chnged by sachin satre on [11-nov-16] to get connection
				isLocalConn =true;
			}
			parentList = dom.getElementsByTagName("Detail" + currentForm);
			int parentNodeListLength = parentList.getLength();
			//Changed By Pragyan 2/9/2011 to Solve the bug
			//Changed By Vidhya on 16/12/09[WS89NOV642 | to make connection before any loop] Start
			//sql = "SELECT * FROM STRG_SERIES SS, STRG_CUSTOMER SC WHERE SS.SC_CODE = SC.SC_CODE AND SS.SALES_PERS = ? AND LOCALITY_CODE = ? AND SS.SC_CODE = ?";
			sql = "SELECT * FROM STRG_SERIES SS, STRG_CUSTOMER SC WHERE SS.SC_CODE = SC.SC_CODE AND SS.SALES_PERS = ? AND SC.LOCALITY_CODE = ? AND SS.SC_CODE = ?";
			pstmt = connectionObject.prepareStatement(sql);
			//Changed By Vidhya on 16/12/09[WS89NOV642 | to make connection before any loop] End
			for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
			{
				String locality = getSelectedRowValue( dom, currentForm, "locality_code", prntCtr);

				parentNode = parentList.item(prntCtr);
				childList = parentNode.getChildNodes();

				for (int ctr = 0; ctr < childList.getLength(); ctr++)
				{
					childNode = childList.item(ctr);
					if ( childNode != null && childNode.getFirstChild() != null &&  childNode.getNodeName().equalsIgnoreCase("strg_code") )
					{
						columnValue = childNode.getFirstChild().getNodeValue();
						if( parentNode.getAttributes().getNamedItem("selected").getNodeValue().equalsIgnoreCase(attrValue))
						{
							if( temp.contains(columnValue) )
							{

								continue;
							}
							//Changed By Vidhya on 16/12/09[WS89NOV642 | to make connection before any loop] Start
							//pstmt.setString(1, sprsCode);
							//pstmt.setString(2, locality);
							//pstmt.setString(3, columnValue);
							//rs = pstmt.executeQuery();
							//Changed By Vidhya on 16/12/09[WS89NOV642 | to make connection before any loop] End
							//if( rs.next() )
							//{
								if( custBuff.length() == 0)
								{
									custBuff.append("'").append( columnValue ).append("'");
								}
								else
								{
									custBuff.append(",'").append( columnValue ).append("'");
								}
							//}
							//added by rakesh kumar 14/12/12.
							/*if (rs != null)
							{
								rs.close();
								rs = null;
							}*/
							temp.add( columnValue );
						}
					}
				}
			}

			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			temp.clear();

		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				//Changed By Vidhya on 16/12/09[WS89NOV642 | to make connection before any loop] End
				if (isLocalConn && connectionObject != null)
				{
					connectionObject.close();
					connectionObject=null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return custBuff.toString();
	}


	public String getItemsFromDom( Document dom, String currentForm, String sprsCode, String attrValue ) throws ITMException
	{
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;

		Connection connectionObject = null;
		Statement stmt = null;
		ResultSet rs = null ;
		StringBuffer itemBuff = new StringBuffer();
		ArrayList temp = new ArrayList(100);
		String sql = "";
		String columnValue = "";
		try
		{
			/*ConnDriver connDriver = new ConnDriver();
			connectionObject = connDriver.getConnectDB("Driver");*/
			connectionObject = getConnection();//chnged by sachin satre on [11-nov-16] to get connection
			parentList = dom.getElementsByTagName("Detail" + currentForm);
			int parentNodeListLength = parentList.getLength();
			for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
			{

				parentNode = parentList.item(prntCtr);
				childList = parentNode.getChildNodes();

				for (int ctr = 0; ctr < childList.getLength(); ctr++)
				{
					childNode = childList.item(ctr);
					if ( childNode != null && childNode.getFirstChild() != null &&  childNode.getNodeName().equalsIgnoreCase("sales_prod_grp") )
					{
						columnValue = childNode.getFirstChild().getNodeValue().trim();
						if( parentNode.getAttributes().getNamedItem("selected").getNodeValue().equalsIgnoreCase(attrValue))
						{
							if( temp.contains(columnValue.trim()+"-SPG") )
							{
								continue;
							}
							//commented by Prathamesh Jangam in db for joins
							//sql = "SELECT DISTINCT SPG.SALES_PROD_GRP CODE FROM SALES_PROD_GRP SPG, ITEM M  WHERE M.ITEM_CODE IN ( SELECT ITEM_CODE FROM SPRS_ITEM WHERE SALES_PERS = '"+sprsCode+"' ) AND M.SALES_PROD_GRP = SPG.SALES_PROD_GRP( + ) AND SPG.SALES_PROD_GRP='"+columnValue+"'";

							sql = "SELECT DISTINCT SPG.SALES_PROD_GRP CODE FROM SALES_PROD_GRP SPG left outer join ITEM M on M.SALES_PROD_GRP = SPG.SALES_PROD_GRP WHERE M.ITEM_CODE IN ( SELECT ITEM_CODE FROM SPRS_ITEM  WHERE SALES_PERS = '"+sprsCode+"' ) AND SPG.SALES_PROD_GRP= '"+columnValue+"'";

							stmt = connectionObject.createStatement();
							rs = stmt.executeQuery(sql);
							if( rs.next() )
							{
								if( itemBuff.length() == 0)
								{
									itemBuff.append("'").append( columnValue ).append("'");
								}
								else
								{
									itemBuff.append(",'").append( columnValue ).append("'");
								}
							}
							//added by rakesh kumar 13/12/12
							if (rs!= null)
							{
								rs.close();
								rs = null;
							}
							if(stmt!=null)
							{
								stmt.close();
								stmt = null;
							}
							//ended by rakesh kumar 13/12/12
							temp.add( columnValue+"-SPG");
						}
					}
					else if ( childNode != null && childNode.getFirstChild() != null &&  childNode.getNodeName().equalsIgnoreCase("item_code"))
					{
						columnValue = childNode.getFirstChild().getNodeValue().trim();
						if( parentNode.getAttributes().getNamedItem("selected").getNodeValue().equalsIgnoreCase(attrValue))
						{
							if( temp.contains(columnValue) )
							{

								continue;
							}
							//COMMENTED BY PRATHAMESH JANGAM ON 07/07/17 FOR JOINS IN DB2
							//sql = "SELECT M.ITEM_CODE CODE FROM ITEM M, SALES_PROD_GRP SPG WHERE M.ITEM_CODE IN ( SELECT ITEM_CODE FROM SPRS_ITEM WHERE SALES_PERS =  '"+sprsCode+"' ) AND M.SALES_PROD_GRP = SPG.SALES_PROD_GRP( + ) AND M.ITEM_CODE= '"+columnValue+"'";

							sql ="SELECT M.ITEM_CODE CODE FROM ITEM M left outer join SALES_PROD_GRP SPG on M.SALES_PROD_GRP = SPG.SALES_PROD_GRP WHERE M.ITEM_CODE IN ( SELECT ITEM_CODE FROM SPRS_ITEM  WHERE SALES_PERS =  '"+sprsCode+"' )  AND M.ITEM_CODE='"+columnValue+"'";

							stmt = connectionObject.createStatement();
							rs = stmt.executeQuery(sql);
							if( rs.next() )
							{
								if( itemBuff.length() == 0)
								{
									itemBuff.append("'").append( columnValue ).append("'");
								}
								else
								{
									itemBuff.append(",'").append( columnValue ).append("'");
								}
							}
							//added by rakesh kumar 13/12/12
							if (rs!= null)
							{
								rs.close();
								rs = null;
							}
							if(stmt!=null)
							{
								stmt.close();
								stmt = null;
							}
							//ended by rakesh kumar 13/12/12
							temp.add( columnValue );
						}

					}

				}
			}
			temp.clear();

		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}

				if(stmt != null)
				{
					stmt.close();
					stmt = null;
				}
				if (connectionObject != null)
				{
					connectionObject.close();
					connectionObject=null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return itemBuff.toString();
	}

	//to get current dom
	public String getCurrentDom(String objContext, Document dom)
	{
		String returnStr = "";
		Document returnDom = null;
		//changed by Rahul Barve on 10-Apr-2015
		//GenericUtility genericUtility = GenericUtility.getInstance();
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		try
		{
			returnDom = genericUtility.parseString("<Root/>");
			NodeList nodeList =  dom.getElementsByTagName("Detail" + objContext);
			for(int i=0; i< nodeList.getLength(); i++)
			{
				Node currentDom = nodeList.item(i);
				if(currentDom != null)
				{
					Node importedNode = returnDom.importNode( currentDom, true);
					returnDom.getDocumentElement().appendChild(importedNode);
				}
			}

			returnStr = genericUtility.serializeDom(returnDom);
			if(returnStr.indexOf("Detail") != -1)
			{
				returnStr = returnStr.substring(returnStr.indexOf(">") + 1, returnStr.lastIndexOf("</"));
			}
			returnStr = returnStr.indexOf("Detail") != -1 ? returnStr : "";

		}
		catch (Exception e){
			e.printStackTrace();
		}
		return returnStr;
	}

	//Changed By Vidhya on  24/10/09[new method to generate errorString]
	public String generateErrorString(String errorString)
	{
		//Changed By Sumit Sarkar on 12/11/11 [SY1GNOV001] update return xml <Errors> in place of <Error>
		//return ("<Error><error id = \"xxxx\" type=\"X\">" + errorString.substring(errorString.indexOf("<message>") , errorString.indexOf("</description>") + "</description>".length()) + "<redirect>1</redirect></error></Errors>");
		return ("<Errors><error id = \"xxxx\" type=\"X\">" + errorString.substring(errorString.indexOf("<message>") , errorString.indexOf("</description>") + "</description>".length()) + "<redirect>1</redirect></error></Errors>");

	}
	//*****Public Methods ***** End

	//****Private Methods ***** Start
	//to validate holiday for saleperson
	/*private String valHoliday(String eventdate, String sprs, String userId, ITMDBAccessLocal itmDBAccessLocal, Connection connectionObject) throws Exception
	{
		//changed by Rahul Barve on 10-Apr-2015
		//GenericUtility genericUtility = GenericUtility.getInstance();
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

		String errString = "";
		String columnValue = "";
		String checkSQL = "";
		String childNodeName = "";

		//Connection connectionObject = null;
		PreparedStatement pstmtPeriod = null;
		ResultSet rsPeriod = null ;

		try
		{
			//ConnDriver connDriver = new ConnDriver();
			//connectionObject = connDriver.getConnectDB( "DriverValidator" );
			//Checking Hodiday
			//eventdate = genericUtility.getValidDateString( eventdate , getApplDateFormat() , "dd-MMM-yyyy");//Shahu - 27/10/12
			eventdate = genericUtility.getValidDateTimeString( eventdate , getApplDateFormat() , getDBDateFormat());//Shahu - 27/10/12
			checkSQL = "SELECT CODE FROM PERIOD WHERE ? BETWEEN FR_DATE AND TO_DATE";
			System.out.println(" sql [" + checkSQL + "]" );
			pstmtPeriod = connectionObject.prepareStatement(checkSQL);
			//pstmt.setString(1,checkNull(eventdate));//Shahu - 27/10/12
			pstmtPeriod.setTimestamp(1, java.sql.Timestamp.valueOf(eventdate));//Shahu - 27/10/12
			rsPeriod = pstmtPeriod.executeQuery();

			if(rsPeriod.next())
			{
				String code = rsPeriod.getString( "CODE" );

				checkSQL = "SELECT DDF_GET_EMP_HOLIDAY(?,?,?,?) HOLDATE FROM DUAL ";
				System.out.println("sql [" + checkSQL + "] ");

				PreparedStatement pstmt = connectionObject.prepareStatement(checkSQL);
				pstmt.setString(1,checkNull(sprs));
				pstmt.setString(2,checkNull(code));
				pstmt.setString(3,checkNull(code));
				//pstmt.setString(4,checkNull(eventdate));//Shahu - 27/10/12
				pstmt.setTimestamp(4, java.sql.Timestamp.valueOf(eventdate));//Shahu - 27/10/12
				ResultSet rs = pstmt.executeQuery();
				if(rs.next())
				{
					String holDate = rs.getString( 1 );
					System.out.println(" holDate [" + holDate + "] ");
					if ( holDate != null )
					{
						errString = itmDBAccessLocal.getErrorString("event_date","HOLIDAY",userId);
					}
				}
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}

			}
			if (rsPeriod != null)
			{
				rsPeriod.close();
				rsPeriod = null;
			}
			if(pstmtPeriod !=null)
			{
				pstmtPeriod.close();
				pstmtPeriod = null;
			}

		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw e;
		}
		finally
		{
			try
			{
				if (rsPeriod != null)
				{
					rsPeriod.close();
					rsPeriod = null;
				}
				if(pstmtPeriod !=null)
				{
					pstmtPeriod.close();
					pstmtPeriod = null;
				}
				
				if (connectionObject != null)
				{
					connectionObject.close();
					connectionObject=null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return errString;
	}*/

	//to get value of selected attribute
	private String getDomAttrVal( Document dom,String objContext, int rowNo, String attribute )
	{
		Node elementName = null, parentNode = null;
		NodeList elementList = null;
		Element elementAttr = null;
		String attrVal = "";
		elementList = dom.getElementsByTagName("Detail"+objContext);
		elementName = elementList.item(0);
		if ( elementName!=null && ("Detail"+objContext).equalsIgnoreCase( elementName.getNodeName()) )
		{
			NamedNodeMap etlAttributes = elementName.getAttributes();
			if (etlAttributes!=null)
			{
				if (etlAttributes.getNamedItem("domID")!=null && etlAttributes.getNamedItem("domID").getNodeValue().equalsIgnoreCase(Integer.toString(rowNo)))
				{
					attrVal = etlAttributes.getNamedItem( attribute ).getNodeValue();
				}
			}
		}
		return attrVal;
	}

	//Changed By Vidhya on 08/12/09 [WS89NOV642 | made public for work team issue] Start
	//private String getSelectedRowValue(Document dom,String formNo, String colName, int rowNo) throws ITMException
	public String getSelectedRowValue(Document dom,String formNo, String colName, int rowNo) throws ITMException
	{
		NodeList detailList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		Element elementAttr = null;
		String childNodeName = "";
		String columnValue = "";
		int	detailListLength = 0;
		int noOfChilds = 0;

		try
		{
			detailList = dom.getElementsByTagName("Detail"+formNo);
			System.out.println("detailList....."+detailList);
			detailListLength = detailList.getLength();
			parentNode = detailList.item(rowNo);
			System.out.println("parentNode....."+parentNode);
			elementAttr = (Element)parentNode;
			childList = parentNode.getChildNodes();
			System.out.println("childList....."+childList);
			noOfChilds = childList.getLength();

			if ( parentNode != null )
			{
				for (int ctr = 0; ctr < noOfChilds; ctr++)
				{
					childNode = childList.item(ctr);
					childNodeName = childNode.getNodeName();
					if(childNodeName.equals(colName) )
					{
						if(childNode.getFirstChild()!=null )
						{
							columnValue = childNode.getFirstChild().getNodeValue();
							break;
						}
					}
				}
			}

			if(columnValue == null)
				columnValue = "";

		}
		catch( Exception exp )
		{
			exp.printStackTrace();
		}

		return columnValue;
	}

	//to get Activity type
	private String getActivityType( String actCode, Connection connectionObject )throws ITMException
	{
		String sql = "";
		String actType = "";
		//Connection connectionObject = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null ;

		//changed by Rahul Barve on 10-Apr-2015
		//GenericUtility genericUtility = GenericUtility.getInstance();
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

		try
		{
			//ConnDriver connDriver = new ConnDriver();
			//connectionObject = connDriver.getConnectDB( "DriverValidator" );

			sql = "SELECT ACTIVITY_TYPE FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ?";
			pstmt = connectionObject.prepareStatement(sql);
			pstmt.setString(1, actCode);
			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				actType = rs.getString("ACTIVITY_TYPE");
				actType = checkNull(actType).toUpperCase();
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				/*
				if (connectionObject != null)
				{
					connectionObject.close();
					connectionObject=null;
				}*/
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}

		return actType;
	}

	//formatted errorstring for Item Detail
	private String getItemErrorString( String errString, String custCode ,String itemDescr, String itemCode, String sprsProdGrp,Connection connectionObject) throws ITMException//Chnaged by sachin satre on 11-nov-16
	{
		String sql = "";
		String custName = "";
		String msgDescr = "";
		//Connection connectionObject = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null ;
		boolean isLocalConn =false;
		try
		{
			if(connectionObject == null )
			{
				/*ConnDriver connDriver = new ConnDriver();
				connectionObject = connDriver.getConnectDB( "DriverValidator" );*/
				connectionObject = getConnection();//chnged by sachin satre on [11-nov-16] to get connection
				isLocalConn =true;
			}
			sql = "SELECT UPPER(FIRST_NAME)||\' \'||UPPER(LAST_NAME) AS SC_NAME FROM STRG_CUSTOMER WHERE SC_CODE = ?";
			pstmt =  connectionObject.prepareStatement( sql );
			pstmt.setString(1, checkNull(custCode));
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				custName = rs.getString("SC_NAME");
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(itemCode.length() != 0 && !itemCode.equalsIgnoreCase(""))
			{
				itemDescr = "Promo Material for "+ itemDescr;
			}
			else if( sprsProdGrp.length() != 0 && !sprsProdGrp.equalsIgnoreCase(""))
			{
				itemDescr = "Pitch value for " + itemDescr;
			}

			msgDescr = errString.substring(errString.indexOf("<description>")+("<description>").length(),errString.indexOf("</description>"))+
					"" +itemDescr+ " selected for " + custName;

			errString = errString.substring(0, errString.indexOf("<description>")+("<description>").length()) + msgDescr + "" + errString.substring( errString.indexOf("</description>"), errString.length());
		}

		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if (isLocalConn && connectionObject != null)
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}

		return errString;

	}

	//to check if input is a number
	private boolean checkIfNumber(String in)
	{
		try
		{
			System.out.println("=====>IN VALUE"+in);
			//Integer.parseInt(in);//Commented By Dipak
			Double.parseDouble(in);//Added By Dipak

		} catch (NumberFormatException ex)
		{
			return false;
		}
		return true;
	}
	//****Private Methods ***** End
	//Utility Functions End****************
	public String getSelectedCustomerDetail( Document dom, String reqFormNo,String repformNo, ArrayList temp, String colName) throws ITMException
	{
		//changed by Rahul Barve on 10-Apr-2015
		//GenericUtility genericUtility = GenericUtility.getInstance();
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		Element elementAttr = null;
		String childNodeName = "";
		String columnValue = "";
		String returnPrevStr = "";
		Document chgPreDom = null;
		try
		{
			chgPreDom = genericUtility.parseString("<Root/>");
			System.out.println("currentFormNo ["+reqFormNo+"]");
			parentList = dom.getElementsByTagName("Detail" + reqFormNo);
			int parentNodeListLength = parentList.getLength();
			System.out.println("parentlistlength["+parentNodeListLength+"]");
			for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
			{
				parentNode = parentList.item(prntCtr);
				childList = parentNode.getChildNodes();
				for (int ctr = 0; ctr < childList.getLength(); ctr++)
				{
					childNode = childList.item(ctr);
					if((childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null))
					{
						columnValue = childNode.getFirstChild().getNodeValue().trim();
						System.out.println("columnValue["+columnValue+"]");
						System.out.println("TEMP ARRAY ["+temp.toString()+"]");
						//System.out.println("TEMP ARRAY ["+temp[]+"]");

						if ( childNode.getNodeName().equalsIgnoreCase(colName) && temp.contains("'"+columnValue+"'"))
						{
							System.out.println("Inside temp Contains Column value["+columnValue+"]");
							elementAttr = (Element)parentNode;
							if ( parentNode.getAttributes().getNamedItem( "domID" ) != null )
							{
								elementAttr.setAttribute( "domID" , Integer.toString(domID) );
								elementAttr.setAttribute( "selected" , "Y" );
								elementAttr.setAttribute( "objContext" , repformNo );
								domID++;
							}
							Node importedNode = chgPreDom.importNode( parentNode, true );
							chgPreDom.getDocumentElement().appendChild( importedNode );
							break;
						}
					}
				}

			}

			returnPrevStr = genericUtility.serializeDom(chgPreDom);
			if(returnPrevStr.indexOf("Detail"+reqFormNo) != -1)
			{
				returnPrevStr = returnPrevStr.substring(returnPrevStr.indexOf(">") + 1, returnPrevStr.lastIndexOf("</"));
			}
			returnPrevStr = returnPrevStr.indexOf("Detail"+reqFormNo) != -1 ? returnPrevStr : "";

			returnPrevStr = returnPrevStr.replace("Detail"+reqFormNo,"Detail"+repformNo);
		}
		catch ( Exception e )
		{
			System.out.println( "Exception :StrgMeetOtcWizardEJB :getSelectedCustomerDetail :==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		return returnPrevStr;

	}
	private String getDocVistDatesInMonth(String strgCode,String sprsCode, String eventDate, Connection conn) throws ITMException
	{
		String visitDates = "";
		String sql="";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		//changed by Rahul Barve on 10-Apr-2015
		//GenericUtility genericUtility = GenericUtility.getInstance();
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		int maxDate = 0;
		StringBuffer sb = new StringBuffer();
		try
		{
			//commented by mrunalini sinkar on 14-july-17 for number of visit changes (start)

			/*
			String dbDateFormat = genericUtility.getDBDateFormat();

			Calendar cal  = Calendar.getInstance();
			cal.setTime( new Date( java.sql.Timestamp.valueOf( eventDate+" 00:00:00" ).getTime() ) );
			maxDate =	cal.getActualMaximum(Calendar.DAY_OF_MONTH);
			int monInt =	cal.get( Calendar.MONTH );
			int yearInt =	cal.get( Calendar.YEAR );

			String dbName =CommonConstants .DB_NAME;

			System.out.println("maxDate ["+maxDate+"] monInt ["+monInt+"] yearInt ["+yearInt+"]");
			System.out.println("DATABASE NAME===>"+dbName);
			System.out.println("Commented code for visted dates===>");

			if(dbName.equalsIgnoreCase("ORACLE"))
			{

				Commented By Shahu Mali on 29-12-12
			 * sql = "select  to_char(event_date,'dd') as VisitDates from strg_meet "+
				"where strg_code = ? "+
				"and sales_pers = ? "+
				"and event_date >=  '01' || '-' || to_char(to_date(?,?),'MON') || to_char(to_date(?,?),'yy') "+
				"and event_date <  ?";


				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,strgCode);
				pstmt.setString(2,sprsCode);
				pstmt.setString(3,eventDate);
				pstmt.setString(4,dbDateFormat);
				pstmt.setString(5,eventDate);
				pstmt.setString(6,dbDateFormat);
				pstmt.setTimestamp(7,java.sql.Timestamp.valueOf(eventDate +" 00:00:00"));



				//Added By Shahu Mali on 29-12-12
				sql = "select  to_char(event_date,'dd/MON') as VisitDates from strg_meet "+
				"where strg_code = ? "+
				"and sales_pers = ? "+
				"and event_date <  ? order by event_date desc ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,strgCode);
				pstmt.setString(2,sprsCode);
				pstmt.setTimestamp(3,java.sql.Timestamp.valueOf(eventDate +" 00:00:00"));
				//Ended  By Shahu Mali on 29-12-12


			}
			else if(dbName.equalsIgnoreCase("DB2"))
			{


				Added For DB2 BY DIPAK
				sql = "select VARCHAR_FORMAT(event_date,'DD') as VisitDates from strg_meet "+
						"where strg_code = ? "+
						"and sales_pers = ? "+
						"and event_date >=  VARCHAR_FORMAT(?,'YYYY')|| '-' ||VARCHAR_FORMAT(?,'MM')  || '-' ||'01' "+
						"and event_date <  ?";

				Ended For DB2 BY DIPAK

				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,strgCode);
				pstmt.setString(2,sprsCode);
				pstmt.setTimestamp(3,java.sql.Timestamp.valueOf(eventDate +" 00:00:00"));
				pstmt.setTimestamp(4,java.sql.Timestamp.valueOf(eventDate +" 00:00:00"));
				pstmt.setTimestamp(5,java.sql.Timestamp.valueOf(eventDate +" 00:00:00"));

			}
			rs = pstmt.executeQuery();
			int visitDtCnt = 0;
			while (rs.next())
			{
				visitDtCnt++;
				String dates = rs.getString("VisitDates");
				sb.append(dates).append(",");
				if(visitDtCnt == 3)
				{
					break;
				}
			}
			visitDates = sb.toString();
			if(visitDates.length() > 0 && visitDates.lastIndexOf(",") > 0  )
			{
				visitDates = visitDates.substring(0,visitDates.length() - 1);
			}
			System.out.println("visitDates =["+visitDates+"]");

			 */
			//commented by mrunalini sinkar on 14-july-17 for number of visit changes (start)
			//added by mrunalini sinkar for number of visit changes on 14-july-17(start)
			String startDate = eventDate;
			//commented by mrunalini sinkar to remove the hardcode date format changes  on 23-April-2018
			//String sdate = startDate.substring(0,startDate.indexOf("/"));
			//added by mrunalini sinkar for remove the hardcode date format changes  on 23-April-2018 (START)
			String sdate="";
			String applFormat = getApplDateFormat();
			if(applFormat.contains("/"))
			{
				sdate = startDate.substring(0,startDate.indexOf("/"));
			}
			else if(applFormat.contains("-"))
			{
				sdate = startDate.substring(0,startDate.indexOf("-"));
			}
			//added by mrunalini sinkar for remove the hardcode date format changes  on 23-April-2018 (end)
			startDate = startDate.replaceFirst(sdate,"01");
			if(startDate != null  && !"".equals(startDate))
			{
				startDate = genericUtility.getValidDateTimeString( startDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ;
			}
			//added by mrunalini sinkar to remove the hardcode date format changes  on 23-April-2018(start)
			//SimpleDateFormat dateFormat = new SimpleDateFormat("dd/mm/yy");
			SimpleDateFormat dateFormat = new SimpleDateFormat(applFormat);
			//added by mrunalini sinkar to remove the hardcode date format changes  on 23-April-2018(end)
			Date prvDate = dateFormat.parse(eventDate);
			Calendar calendar = Calendar.getInstance();
			calendar.setTime(prvDate);
			calendar.add(Calendar.DAY_OF_YEAR, -1);
			Date previousDate = calendar.getTime();
			String prevDate = dateFormat.format(previousDate);
			if(prevDate != null  && !"".equals(prevDate))
			{
				prevDate = genericUtility.getValidDateTimeString( prevDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ;
			}
			sql = "SELECT  STRG_CODE, EVENT_DATE AS VISITDATES  FROM STRG_MEET WHERE SALES_PERS = ? " +
					"  AND STRG_CODE = ? AND EVENT_DATE BETWEEN ? AND ?";

			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,sprsCode);
			pstmt.setString(2,strgCode);
			pstmt.setTimestamp(3,java.sql.Timestamp.valueOf(startDate) );
			pstmt.setTimestamp(4,java.sql.Timestamp.valueOf(prevDate) );

			rs = pstmt.executeQuery();

			while (rs.next())
			{
				String dates = rs.getString("VISITDATES");
				System.out.println("Dates::::"+dates);
				dates =  genericUtility.getValidDateString( dates, genericUtility.getDBDateFormat(), genericUtility.getApplDateFormat() );
				System.out.println("Dates::::"+dates);
				sb.append(dates).append(",");
			}
			visitDates = sb.toString();
			System.out.println("visitDates is ::::::=["+visitDates+"]");
			if(visitDates.length() > 0 && visitDates.lastIndexOf(",") > 0  )
			{
				visitDates = visitDates.substring(0,visitDates.length() - 1);
			}
			System.out.println("visitDates ::::::=["+visitDates+"]");
			//added by mrunalini sinkar for number of visit changes on 14-july-17(end)



		}

		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{

			}
		}
		return visitDates;
	}
	//Overloaded method is added by Gulzar [eventDate] on 18/06/12
	//Added By Gaurav Singh on 02-JUN-2015 [ Start ]

	public String getSalesPersItemList( String sprsCode, String strgCode, String selectedItem, String eventDate ) throws ITMException
	{
		//Form 4 defaultData()
		String sql = "";
		String sql1 = "";
		StringBuffer valueXmlString = new StringBuffer();
		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		boolean isMasterPitchFound = false;
		try
		{
			valueXmlString.append( "<Root>\r\n" );
			/*ConnDriver connDriver = new ConnDriver();
			connectionObject = connDriver.getConnectDB( "DriverValidator" );*/
			connectionObject = getConnection();//chnged by sachin satre on [11-nov-16] to get connection

			/*sql1 = "SELECT M.ITEM_CODE ITEM, M.DESCR DESCR "+
					"FROM ITEM M LEFT OUTER JOIN SALES_PROD_GRP SPG ON M.SALES_PROD_GRP = SPG.SALES_PROD_GRP "+
					"WHERE M.ITEM_CODE IN ( SELECT ITEM_CODE FROM SPRS_ITEM WHERE SALES_PERS = ? AND STATUS='Y' ) ";*/



			sql1 =" SELECT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR FROM  ITEM ITEM, STRG_CUSTOMER SC ," +
					"PRICELIST  PM "+
					"WHERE ITEM.ITEM_CODE = PM.ITEM_CODE AND SC.STATE_CODE = PM.PRICE_LIST "+
					"AND SC.SC_CODE= ? "+
					"ORDER BY ITEM.SH_DESCR ";


			System.out.println(" selectedItem string vala parameter["+selectedItem+"]");
			HashMap itemMap = new HashMap();

			String dcrID = getDCRId(connectionObject,sprsCode, eventDate);

			if ( selectedItem != null && selectedItem.trim().length() > 0 )
			{
				NodeList itemNodeList = ( genericUtility.parseString( selectedItem ) ).getElementsByTagName("Detail5");
				int nodeListLen = itemNodeList.getLength();
				for ( int i=0; i < nodeListLen ; i++ )
				{
					NodeList innerNodeList = itemNodeList.item( i ).getChildNodes();
					int innerNodeListLen = innerNodeList.getLength();
					String itemCode = "";
					String pitch = "";
					String qty = "";
					String columnValue = "";
					String itemDescr = "";
					for ( int j = 0; j < innerNodeListLen; j++ )
					{
						Node currNode = innerNodeList.item( j );
						System.out.println("COLUMNAME ["+ currNode.getNodeName()+"] COLUMKN VALUE["+currNode.getFirstChild()+"] ");
						if ( "item_code".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild() != null)
							{
								itemCode = currNode.getFirstChild().getNodeValue().trim() ;
							}
						}
						else if ( "quantity".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild().getNodeValue() != null )
							{
								qty = currNode.getFirstChild().getNodeValue().trim();
							}
						}
						else if("scheme_code".equals( currNode.getNodeName() ))
						{
							if(currNode.getFirstChild() != null)
							{
								itemCode = checkNull(currNode.getFirstChild().getNodeValue());
								itemCode = itemCode.trim();
							}
						}
						else if ( "item_descr".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild() != null)
							{
								itemDescr = checkNull(currNode.getFirstChild().getNodeValue());
							}
						}
					}
					System.out.println("itemCode["+itemCode+"] pitch["+pitch+"] qty["+qty+"]" );
					itemMap.put( itemCode, pitch+"~"+qty);

					System.out.println(" itemMap ["+itemMap+"]");
				}
			}

			String qty = "";
			String pitch = "";
			int num = 1;
			int lineNo=1;

			double value = 0d;
			double rate = 0d;


			pstmt =  connectionObject.prepareStatement( sql1 );
			pstmt.setString(1, strgCode);//changed by poonam
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				String itemCode = rs.getString("ITEM_CODE");
				System.out.println("itemCode["+itemCode+"]");
				String itemDescr = checkNull(rs.getString("DESCR"));
				String itemShDescr = checkNull(rs.getString("SH_DESCR"));
				//	String domQty = getSelectedRowValue(dom, 5, colName, rowNo)
				rate = getLandingRate( strgCode, itemCode, eventDate, sprsCode, connectionObject);

				System.out.println("RATE:::==["+rate+"]");
				if ( itemMap.get( itemCode.trim() ) != null )
				{
					String data = ( String ) itemMap.get( itemCode.trim() );
					qty = data.substring( data.indexOf("~") + 1 );
					System.out.println("itemCode inside if["+itemCode+"]");
					valueXmlString.append("<Detail5 domID='"+num+"' selected = 'Y'>\r\n" );
					valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");//Gaurav Singh on 03-06-15
					valueXmlString.append("<selectbox><![CDATA[").append( "true" ).append("]]></selectbox>\n");
				}
				else
				{
					valueXmlString.append("<Detail5 domID='"+num+"' selected = 'N'>\r\n" );
					valueXmlString.append( "<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");//Gaurav Singh on 03-06-15
				}

				valueXmlString.append("<strg_code><![CDATA[").append( strgCode ).append("]]></strg_code>\r\n");
				valueXmlString.append("<item_descr><![CDATA[").append(rs.getString("DESCR")).append("]]></item_descr>\r\n");
				valueXmlString.append( "<quantity><![CDATA[" ).append( qty ).append( "]]></quantity>\r\n" );
				valueXmlString.append("<landing_rate><![CDATA[" ).append( rate ).append( "]]></landing_rate>\r\n" );
				System.out.println("qty::::==["+qty+"]");
				System.out.println("value::::==["+value+"]");
				valueXmlString.append("<value><![CDATA[" ).append(value).append( "]]></value>\r\n" );
				valueXmlString.append("<item_code><![CDATA[").append( rs.getString("ITEM_CODE") ).append("]]></item_code>\r\n");
				valueXmlString.append("<tooltip_descr><![CDATA[").append(itemDescr).append("]]></tooltip_descr>\r\n");
				valueXmlString.append("<line_no><![CDATA["+lineNo+"]]></line_no>\r\n");
				valueXmlString.append( "<dcr_id><![CDATA["+dcrID+"]]></dcr_id>\r\n" );
				valueXmlString.append("<sales_pers><![CDATA[").append(sprsCode).append("]]></sales_pers>\r\n");
				valueXmlString.append( "</Detail5>\r\n" );

				qty = "";
				num++;
				lineNo++;
			}//end of while
			if(rs != null)
			{
				rs.close(); rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close(); pstmt = null;
			}
			num = 1;
		}
		catch (Exception e)
		{
			e.printStackTrace();
			System.out.println( "Exception :ITMWizardStatefulEJB :getSalesPersItemList(String):" + e.getMessage() + ":" );
			//valueXmlString = valueXmlString.append( genericUtility.createErrorString( e ) );
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if( connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :ITMWizardStatefulEJB :getSalesPersItemList(String) :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		valueXmlString.append( "</Root>\r\n" );
		System.out.println( "\n****ValueXmlString :" + valueXmlString.toString() + ":********" );
		return valueXmlString.toString();
	}
	//Method to get order Item details
	public String getSalesPersItemList(Document dom, String sprsCode, String strgCode, String selectedItem, String eventDate,String formNo ,String formName) throws ITMException
	{
		String sql = "";
		String sql1 = "";
		StringBuffer valueXmlString = new StringBuffer();
		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		boolean isMasterPitchFound = false;
		try
		{
			valueXmlString.append( "<Root>\r\n" );
			connectionObject = getConnection();
			// commented and added by rupali on 08/03/18 for getting price_list of that state_code [start]
			/*sql1 =" SELECT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR FROM  ITEM ITEM, STRG_CUSTOMER SC ," +
					"PRICELIST  PM "+
					"WHERE ITEM.ITEM_CODE = PM.ITEM_CODE AND SC.STATE_CODE = PM.PRICE_LIST "+
					"AND SC.SC_CODE= ? "+
					"ORDER BY ITEM.SH_DESCR ";*/

			sql1 =" SELECT DISTINCT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR, S.PRICE_LIST AS PRICE_LIST " +
					"FROM  ITEM ITEM, STRG_CUSTOMER SC ,PRICELIST  PM, STATE S "+
					"WHERE ITEM.ITEM_CODE = PM.ITEM_CODE AND SC.STATE_CODE = S.STATE_CODE AND S.PRICE_LIST = PM.PRICE_LIST "+
					"AND RTRIM((CASE WHEN ITEM.ITEM_USAGE IS NULL THEN 'O' ELSE ITEM.ITEM_USAGE END )) NOT IN('S','G') AND SC.SC_CODE= ? "+
					"ORDER BY ITEM.SH_DESCR ";
			// commented and added by rupali on 08/03/18 for getting price_list of that state_code [start]
			System.out.println(" selectedItem in dom vala parametr["+selectedItem+"]");
			HashMap itemMap = new HashMap();
			String dcrID = getDCRId(connectionObject,sprsCode, eventDate);
			System.out.println("Value of dcr id is123:- -"+dcrID);
			if ( selectedItem != null && selectedItem.trim().length() > 0 )
			{
				NodeList itemNodeList = ( genericUtility.parseString( selectedItem ) ).getElementsByTagName("Detail"+formNo+"");
				int nodeListLen = itemNodeList.getLength();
				for ( int i=0; i < nodeListLen ; i++ )
				{
					NodeList innerNodeList = itemNodeList.item( i ).getChildNodes();
					int innerNodeListLen = innerNodeList.getLength();
					String itemCode = "";
					String pitch = "";
					String qty = "";
					String val = "";
					String columnValue = "";
					String itemDescr = "";
					for ( int j = 0; j < innerNodeListLen; j++ )
					{
						Node currNode = innerNodeList.item( j );
						System.out.println("COLUMNAME ["+ currNode.getNodeName()+"] COLUMKN VALUE["+currNode.getFirstChild()+"] ");
						if ( "item_code".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild() != null)
							{
								itemCode = currNode.getFirstChild().getNodeValue().trim() ;
							}
						}
						else if ( "quantity".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild().getNodeValue() != null )
							{
								qty = currNode.getFirstChild().getNodeValue().trim();
							}
						}
						else if("scheme_code".equals( currNode.getNodeName() ))
						{
							if(currNode.getFirstChild() != null)
							{
								itemCode = checkNull(currNode.getFirstChild().getNodeValue());
								itemCode = itemCode.trim();
							}
						}
						else if ( "item_descr".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild() != null)
							{
								itemDescr = checkNull(currNode.getFirstChild().getNodeValue());
							}
						}
						else if ( "value".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild() != null)
							{
								val = checkNull(currNode.getFirstChild().getNodeValue());
							}
						}
					}
					System.out.println("itemCode["+itemCode+"] pitch["+pitch+"] qty["+qty+"]" );
					itemMap.put( itemCode, pitch+"~"+qty);

					System.out.println(" itemMap ["+itemMap+"]");
				}
			}

			String qty = "";
			String pitch = "";
			int num = 1;
			int lineNo=1;

			double value = 0d;
			double rate = 0d;


			pstmt =  connectionObject.prepareStatement( sql1 );
			pstmt.setString(1, strgCode);//changed by poonam
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				String itemCode = rs.getString("ITEM_CODE");
				System.out.println("itemCode["+itemCode+"]");
				String itemDescr = checkNull(rs.getString("DESCR"));
				String itemShDescr = checkNull(rs.getString("SH_DESCR"));
				//String domQty = getSelectedRowValue(dom, "5", "quantity", 0);
				String priceList = checkNull(rs.getString("PRICE_LIST")); //added by rupali on 08/03/18 for getting price_list

				String domQty1 = genericUtility.getColumnValue("quantity", dom, formNo);
				rate = getLandingRate( strgCode, itemCode, eventDate, sprsCode, priceList, connectionObject);//added by rupali on 08/03/18 for passing price_list

				//string aaa= dom.toString();
				System.out.println("dom:::==["+dom +"]"+ "domQty1"+domQty1);
				System.out.println("RATE:::==["+rate+"]");
				System.out.println("itemMap.get( itemCode.trim()"+itemMap.get( itemCode.trim()));
				if ( itemMap.get( itemCode.trim() ) != null )
				{
					String data = ( String ) itemMap.get( itemCode.trim() );
					qty = data.substring( data.indexOf("~") + 1 );
					System.out.println("itemCode inside if["+itemCode+"]");
					valueXmlString.append("<Detail"+formNo+" domID='"+num+"' selected = 'Y' formName='"+formName+"'>\r\n" );
					valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");//Gaurav Singh on 03-06-15
					valueXmlString.append("<selectbox><![CDATA[").append( "true" ).append("]]></selectbox>\n");
					valueXmlString.append("<strg_code><![CDATA[").append( strgCode ).append("]]></strg_code>\r\n");
				}
				else
				{
					valueXmlString.append("<Detail"+formNo+" domID='"+num+"' selected = 'N' formName='"+formName+"'>\r\n" );
					valueXmlString.append( "<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");//Gaurav Singh on 03-06-15
					valueXmlString.append("<strg_code><![CDATA[").append( "" ).append("]]></strg_code>\r\n");
				}
				valueXmlString.append("<strg_code_dummy><![CDATA[").append( strgCode ).append("]]></strg_code_dummy>\r\n");
				valueXmlString.append("<item_descr><![CDATA[").append(rs.getString("DESCR")).append("]]></item_descr>\r\n");
				valueXmlString.append( "<quantity><![CDATA[" ).append( qty ).append( "]]></quantity>\r\n" );
				valueXmlString.append("<landing_rate><![CDATA[" ).append( rate ).append( "]]></landing_rate>\r\n" );
				System.out.println("qty::::==["+qty+"]");
				System.out.println("value::::==["+value+"]");
				DecimalFormat df = new DecimalFormat("###.##");
				System.out.println(" Before if >::::==["+ qty+"]");
				if(qty != null && qty.trim().length()!= 0)
				{
					double value1= 0d;
					System.out.println(" rate>::::==["+ rate+"]");
					double qty1 = 0d;
					qty1= Double.parseDouble(qty);
					value1 = qty1 * rate;
					//value1 = Integer.parseInt(qty) * rate;
					System.out.println("value::::==["+value1+"]");
					valueXmlString.append("<value><![CDATA[" ).append(df.format(value1)).append( "]]></value>\r\n" );
				}
				else
				{
					System.out.println(" Else if>::::==["+ value+"]");
					valueXmlString.append("<value><![CDATA[" ).append(value).append( "]]></value>\r\n" );
				}
				//valueXmlString.append("<value><![CDATA[" ).append(value).append( "]]></value>\r\n" );
				valueXmlString.append("<item_code><![CDATA[").append( rs.getString("ITEM_CODE") ).append("]]></item_code>\r\n");
				valueXmlString.append("<tooltip_descr><![CDATA[").append(itemDescr).append("]]></tooltip_descr>\r\n");
				valueXmlString.append("<line_no><![CDATA["+lineNo+"]]></line_no>\r\n");
				valueXmlString.append( "<dcr_id><![CDATA["+dcrID+"]]></dcr_id>\r\n" );
				valueXmlString.append("<sales_pers><![CDATA[").append(sprsCode).append("]]></sales_pers>\r\n");
				valueXmlString.append( "</Detail"+formNo+">\r\n" );

				qty = "";
				num++;
				lineNo++;
			}//end of while
			if(rs != null)
			{
				rs.close(); rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close(); pstmt = null;
			}
			num = 1;
		}
		catch (Exception e)
		{
			e.printStackTrace();
			System.out.println( "Exception :ITMWizardStatefulEJB :getSalesPersItemList(String):" + e.getMessage() + ":" );
			//valueXmlString = valueXmlString.append( genericUtility.createErrorString( e ) );
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if( connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :ITMWizardStatefulEJB :getSalesPersItemList(String) :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		valueXmlString.append( "</Root>\r\n" );
		System.out.println( "\n****ValueXmlString :" + valueXmlString.toString() + ":********" );
		return valueXmlString.toString();
	}

	private double getLandingRate(String strgCode, String itemCode, String workDate, String sprsCode, Connection connectionObject) throws Exception
	{
		System.out.println("Inside getLandingRate()::::::" );
		double rate = 0d;
		String sql = "";
		String stateCode = "";
		PreparedStatement pStmt = null;
		ResultSet rs = null;

		try
		{
			System.out.println("strgCode:::>>>>[" + strgCode +"]" );
			sql = "SELECT STATE_CODE FROM STRG_CUSTOMER WHERE SC_CODE= ? ";

			pStmt = connectionObject.prepareStatement(sql);
			pStmt.setString(1, strgCode);
			rs = pStmt.executeQuery();

			if(rs.next())
			{
				stateCode= (checkNull(rs.getString("STATE_CODE"))).trim();
			}

			System.out.println("stateCode:::>>>>[" + stateCode +"]");
			DistCommon distComn = new DistCommon();
			rate = distComn.pickRate(stateCode, workDate, itemCode, connectionObject);

			System.out.println("getLandingRate_RATE::>>>>["+itemCode+"] [" + rate +"]");


		}
		catch (Exception e)
		{
			e.printStackTrace();
			System.out.println( "Exception :getLandingRate(String):" + e.getMessage() + ":" );
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if( rs != null )
				{
					rs.close();
					rs = null;
				}

				if(pStmt != null )
				{
					pStmt.close();
					pStmt = null;
				}

			}
			catch(Exception e)
			{
				System.out.println( "Exception getLandingRate(String) :==>\n"+e.getMessage());
			}
		}

		return rate;
	}
	//Added by Poonam Gole on 26-10-2015 [ End ]
	//Added method by Gulzar on 18/06/12

	private String findValue(Connection conn, String columnName ,String tableName, String columnName2, String value) throws  ITMException
	{
		PreparedStatement pstmt = null ;
		ResultSet rs = null ;
		String sql = "";
		String findValue = "";
		try
		{
			sql = "SELECT " + columnName + " from " + tableName + " where " + columnName2 +"= ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,value);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				findValue = rs.getString(1);
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
		}
		catch(Exception e)
		{
			System.out.println("Exception in findValue ");
			e.printStackTrace();
			throw new ITMException(e);
		}
		System.out.println("returning String from findValue " + findValue);
		return findValue;
	}

	private ArrayList getTeamList(String workWith) throws  ITMException
	{
		ArrayList teamList = new ArrayList();
		try
		{
			if ( workWith != null && workWith.trim().length() > 0 )
			{
				String searchIndex = "";
				if ( workWith.indexOf("<BR/>") > 0 )
				{
					searchIndex = "<BR/>";
				}
				else if ( workWith.indexOf(",") > 0 )
				{
					searchIndex = ",";
				}
				System.out.println("searchIndex =["+searchIndex+"]");
				if ( workWith.indexOf(searchIndex) > 0 )
				{
					String workWitthTeam [] = workWith.split(searchIndex);
					if ( workWitthTeam != null && workWitthTeam.length > 0 )
					{
						String teamMember = "";

						for ( int i=0; i<workWitthTeam.length; i++)
						{
							teamMember = workWitthTeam[i];
							System.out.println("teamMember =["+teamMember+"]");
							int leftIndex = teamMember.indexOf("(");
							int rightIndex = teamMember.indexOf(")");
							String newStr = "";
							if (leftIndex >= 0 && rightIndex >= 0 )
							{
								newStr = teamMember.substring(leftIndex+1,teamMember.lastIndexOf(")"));
								System.out.println("leftIndex_rightIndex =["+newStr+"]");
							}
							else if (leftIndex >= 0 )
							{
								newStr = teamMember.substring(leftIndex+1);
								System.out.println("newStr_leftIndex =["+newStr+"]");
							}
							else if (rightIndex >= 0 )
							{
								newStr = teamMember.substring(0,rightIndex);
								System.out.println("newStr_rightIndex =["+newStr+"]");
							}
							teamList.add(newStr.trim());
						}

					}
				}
				else
				{
					teamList.add(workWith);
				}
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		System.out.println("Team List ::"+teamList);
		return teamList;
	}

	public String getSalesPersTeamList( String salesPers, String strgCode, String selectedTeam, String workWith ) throws ITMException
	{
		System.out.println("<===::: getSalesPersTeamList is called :::===>");
		String sql = "";
		String [] team = new String [25];
		StringBuffer valueXmlString = new StringBuffer("<Root>\r\n");
		Connection connectionObject = null;
		PreparedStatement pstmtPophelp = null;
		ResultSet rsPophelp = null;
		//changed by Rahul Barve on 10-Apr-2015
		//GenericUtility genericUtility = GenericUtility.getInstance();
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

		try
		{
			ArrayList teamList = getTeamList(workWith);//Gulzar on 23/06/12

			/*ConnDriver connDriver = new ConnDriver();
			connectionObject = connDriver.getConnectDB( "DriverValidator" );*/
			connectionObject = getConnection();//chnged by sachin satre on [11-nov-16] to get connection

			selectedTeam = ( selectedTeam != null ) ? selectedTeam.trim() : selectedTeam;
			team = selectedTeam.split(",");
			System.out.println("Team selected ["+Arrays.asList(team)+"] strgCode["+strgCode+"]");
			sql = "SELECT SQL_STR FROM POPHELP WHERE FIELD_NAME='SALES_PERS' AND MOD_NAME='W_WSFA_DSR_MOB_WIZ'";
			pstmtPophelp =  connectionObject.prepareStatement( sql );
			rsPophelp = pstmtPophelp.executeQuery();
			int num = 1;
			if (rsPophelp.next())
			{
				sql = rsPophelp.getString("SQL_STR").trim().replace("'?'", "?");
				PreparedStatement pstmt =  connectionObject.prepareStatement( sql );
				pstmt.setString(1, salesPers);
				ResultSet rs = pstmt.executeQuery();
				while(rs.next())
				{
					String reportTo = rs.getString("REPORT_TO");
					String desgn= rs.getString("DESIGNATION");
					System.out.println("reportTo["+reportTo+"] desgn ["+desgn+"]");
					reportTo = ( reportTo != null ) ? reportTo.trim() : reportTo;
					if ( new ArrayList<String>(Arrays.asList(team)).contains( reportTo ) || (teamList != null && teamList.contains(reportTo)) )
					{

						valueXmlString.append( "<Detail10 domID='" + num + "' selected = 'Y'>\r\n" );
						valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");//Gaurav Singh on 03/06/15
					}
					else
					{
						valueXmlString.append( "<Detail10 domID='" + num + "' selected = 'N'>\r\n" );
						valueXmlString.append( "<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");//Gaurav Singh on 03/06/15
					}

					valueXmlString.append("<sales_pers><![CDATA[").append( reportTo ).append("]]></sales_pers>\r\n");
					valueXmlString.append("<name><![CDATA[").append( rs.getString("NAME") ).append("]]></name>\r\n");
					valueXmlString.append("<designation><![CDATA[").append( rs.getString("DESIGNATION")).append("]]></designation>\r\n");
					valueXmlString.append("<strg_code><![CDATA[").append( strgCode ).append("]]></strg_code>\r\n");
					valueXmlString.append("<role_code><![CDATA[]]></role_code>\r\n");

					sql = "SELECT DESIGN_CODE FROM EMPLOYEE WHERE EMP_CODE = ?";
					PreparedStatement pstmtEmp =  connectionObject.prepareStatement( sql );
					pstmtEmp.setString(1, reportTo);
					ResultSet rset = pstmtEmp.executeQuery();
					if ( rset.next())
					{
						String desgnCode = rset.getString("DESIGN_CODE") != null ?rset.getString("DESIGN_CODE").trim() :"";
						valueXmlString.append("<design_code><![CDATA[").append( desgnCode ).append("]]></design_code>\r\n");
					}
					rset.close(); rset = null;
					pstmtEmp.close(); pstmtEmp = null;

					valueXmlString.append("<line_no><![CDATA[]]></line_no>\r\n");
					valueXmlString.append( "<deselect_strg_code><![CDATA[" ).append("N").append( "]]></deselect_strg_code>\r\n" );//Gulzar on 02/08/12
					valueXmlString.append( "</Detail10>\r\n" );
					num++;
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;

				}
			}
			if(rsPophelp != null)
			{
				rsPophelp.close();
				rsPophelp = null;
			}
			if(pstmtPophelp != null)
			{
				pstmtPophelp.close();
				pstmtPophelp = null;

			}

		}
		catch (Exception e)
		{
			e.printStackTrace();
			System.out.println( "Exception :ITMWizardStatefulEJB :getSalesPersTeamList(String):" + e.getMessage() + ":" );
			valueXmlString = valueXmlString.append( genericUtility.createErrorString( e ) );
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if ( rsPophelp != null )
				{
					rsPophelp.close();
					rsPophelp = null;
				}

				if ( pstmtPophelp != null )
				{
					pstmtPophelp.close();
					pstmtPophelp = null;
				}
				if( connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :ITMWizardStatefulEJB :getSalesPersTeamList(String) :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		valueXmlString.append( "</Root>\r\n" );
		System.out.println( "\n****ValueXmlString :" + valueXmlString.toString() + ":********" );
		return valueXmlString.toString();

	}

	//End Added by Gulzar on 18/06/12
	//Added By Gulzar on 16-APR-13.START
	private String getDCRId(Connection conn, String salesPers, String dcrDate, String selActCode) throws Exception
	{
		String dcrID = "";
		PreparedStatement pstmtDCRID = null;
		ResultSet rsDCRID = null;
		try
		{
			String activityCode = "";
			//changed by Rahul Barve on 10-Apr-2015
			//GenericUtility genericUtility = GenericUtility.getInstance();
			E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
			dcrDate = genericUtility.getValidDateTimeString( dcrDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );

			//Select the activity type of selected activity code
			String selActType = "";
			String actTypeSql = "SELECT ACTIVITY_TYPE FROM FIELDACTIVITY WHERE ACTIVITY_CODE = ? ";

			PreparedStatement pstmtActType = conn.prepareStatement( actTypeSql );
			pstmtActType.setString(1, selActCode);
			ResultSet rsActType = pstmtActType.executeQuery();
			if( rsActType.next() )
			{
				selActType = checkNull(rsActType.getString("ACTIVITY_TYPE"));
			}
			rsActType.close();rsActType = null;
			pstmtActType.close();pstmtActType = null;

			//Select the activity code from sprs_act_tran of selected activity type
			String actCodeDb = "";
			String actCodeSql = "SELECT A.ACTIVITY_CODE FROM SPRS_ACT_TRAN A, FIELDACTIVITY B WHERE A.ACTIVITY_CODE = B.ACTIVITY_CODE AND A.EVENT_DATE = ? AND A.SALES_PERS = ? AND B.ACTIVITY_TYPE = ? ";

			PreparedStatement pstmtActCode = conn.prepareStatement( actCodeSql );
			pstmtActCode.setTimestamp(1, java.sql.Timestamp.valueOf(dcrDate));
			pstmtActCode.setString(2, salesPers);
			pstmtActCode.setString(3, selActType);
			ResultSet rsActCode = pstmtActCode.executeQuery();
			if( rsActCode.next() )
			{
				actCodeDb = checkNull(rsActCode.getString("ACTIVITY_CODE"));
			}
			rsActCode.close();rsActCode = null;
			pstmtActCode.close();pstmtActCode = null;

			if(actCodeDb.trim().length() > 0)
			{
				activityCode = actCodeDb;
			}
			else
			{
				activityCode = selActCode;
			}

			String dcrSql = "SELECT DCR_ID FROM SPRS_ACT_TRAN WHERE EVENT_DATE =? AND SALES_PERS = ? AND ACTIVITY_CODE = ? ";

			pstmtDCRID = conn.prepareStatement( dcrSql );
			pstmtDCRID.setTimestamp(1, java.sql.Timestamp.valueOf(dcrDate));
			pstmtDCRID.setString(2, salesPers);
			pstmtDCRID.setString(3, activityCode);
			rsDCRID = pstmtDCRID.executeQuery();
			if( rsDCRID.next() )
			{
				dcrID = checkNull(rsDCRID.getString("DCR_ID"));
			}
			//added By Nilesh Start::02-06-2017
			if (rsDCRID!= null)
			{
				rsDCRID.close();
				rsDCRID = null;
			}
			if(pstmtDCRID!=null)
			{
				pstmtDCRID.close();
				pstmtDCRID = null;
			}
			//added By Nilesh End::02-06-2017
		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rsDCRID != null)
				{
					rsDCRID.close();
					rsDCRID = null;
				}
				if(pstmtDCRID !=null)
				{
					pstmtDCRID.close();
					pstmtDCRID = null;
				}
			}
			catch(Exception e1){}
		}
		return dcrID;
	}
	//Added by Gulzar on 16-APR-13.END
	//Added By Shahu Mali on 11/04/13 for Request Id [WS3ANOV003].START
	public ArrayList halfDayActivityList( String propName, Connection conn ) throws Exception
	{
		String propVal = "";
		PreparedStatement pstmtProp = null;
		ResultSet rsProp = null;
		boolean isActivityExist=false;
		ArrayList halfDayActList = new ArrayList();
		try
		{
			String propSql = "SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME = ?";
			pstmtProp = conn.prepareStatement(propSql);
			pstmtProp.setString(1,propName);
			rsProp = pstmtProp.executeQuery();
			if(rsProp.next())
			{
				propVal = (rsProp.getString("PROP_VALUE") == null) ?"":rsProp.getString("PROP_VALUE");
			}
			if(propVal.length() > 0)
			{
				halfDayActList = new ArrayList<String>(Arrays.asList(propVal.split(",")));
			}

		}
		catch(Exception e)
		{
			System.out.println("isActivityCodeExist Catch Exception"+e.getMessage());
			throw e;

		}
		finally
		{
			try
			{
				if(rsProp != null)
				{
					rsProp.close(); rsProp = null;
				}
				if(pstmtProp != null)
				{
					pstmtProp.close(); pstmtProp = null;
				}
			}
			catch(Exception e)
			{
				System.out.println("Finaly Catch Exception"+e.getMessage());
			}
		}
		System.out.println("is Activity code exist =["+isActivityExist+"]");

		return 	 halfDayActList;

	}
	//Added By Shahu Mali on 11/04/13 for Request Id [WS3ANOV003].END

	////////////////////////////////////////////////////////////////////

	//Addded by Gaurav Singh on 02-Jun-2015 for Request Id [W15BMIT002].Start
	public String[] getStanCodeFrom( Connection con, String userId, String currDate ) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String localityCodeFrom = "";
		String overNight = "N";
		java.sql.Timestamp travelDate = null;

		String stanCodeFrom[] = new String[2];
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		boolean isLocalConn = false;

		try
		{
			if(con == null)
			{
				/*ConnDriver connDriver = new ConnDriver();
					con = connDriver.getConnectDB( "DriverITM" );*/
				con = getConnection();//chnged by sachin satre on [11-nov-16] to get connection
				isLocalConn = true;
			}
			String activityType = "";
			String sprsTrvSql = "SELECT A.LOCALITY_CODE, A.ACTIVITY_CODE, A.OVER_NIGHT, B.ACTIVITY_TYPE, C.DESCR FROM SPRS_TRAVEL A, FIELDACTIVITY B, LOCALITY C " +
					" WHERE A.ACTIVITY_CODE = B.ACTIVITY_CODE AND A.LOCALITY_CODE = C.LOCALITY_CODE AND A.SALES_PERS = ?  " +
					" AND A.TRAVEL_DATE = (SELECT MAX(TRAVEL_DATE) FROM SPRS_TRAVEL WHERE SALES_PERS = ? AND TRAVEL_DATE < ?) ";

			PreparedStatement pstmtTrv = con.prepareStatement(sprsTrvSql);
			pstmtTrv.setString(1, userId );
			pstmtTrv.setString(2, userId );
			pstmtTrv.setTimestamp( 3, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );

			ResultSet rsTrv = pstmtTrv.executeQuery();
			if(rsTrv.next())
			{
				localityCodeFrom = (rsTrv.getString("LOCALITY_CODE") == null) ?"":rsTrv.getString("LOCALITY_CODE").trim();
				activityType = (rsTrv.getString("ACTIVITY_TYPE") == null) ?"":rsTrv.getString("ACTIVITY_TYPE").trim();
				//overNight = (rsTrv.getString("OVER_NIGHT") == null) ?"":rsTrv.getString("OVER_NIGHT").trim();
			}
			rsTrv.close(); rsTrv = null;
			pstmtTrv.close(); pstmtTrv = null;

			//if("FW".equalsIgnoreCase(activityType))
			if(!("LEAVE".equalsIgnoreCase(activityType) || "NFW".equalsIgnoreCase(activityType)))
			{
				String stanCodeSql = "SELECT ST.LOCALITY_CODE, ST.TRAVEL_DATE FROM  SPRS_TRAVEL ST, LOCALITY LOC "+
						" WHERE ORDER_OF_VISIT = ( SELECT MAX( ORDER_OF_VISIT) "+
						" FROM SPRS_TRAVEL WHERE SALES_PERS= ? AND TRAVEL_DATE =(SELECT MAX(TRAVEL_DATE) FROM SPRS_TRAVEL WHERE SALES_PERS=?  and TRAVEL_DATE < ?) " +
						" AND (DR_VISIT ='Y' OR RETAILER_VISIT ='Y' OR MERCH_VISIT='Y') "+
						") "+
						" AND LOC.LOCALITY_CODE = ST.LOCALITY_CODE "+
						" AND ST.SALES_PERS= ? AND ST.TRAVEL_DATE  =(SELECT MAX(TRAVEL_DATE) FROM SPRS_TRAVEL WHERE SALES_PERS=?  and TRAVEL_DATE < ? )";
				pstmt =  con.prepareStatement(stanCodeSql);
				pstmt.setString(1, userId );
				pstmt.setString(2, userId );
				pstmt.setTimestamp( 3, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
				pstmt.setString(4, userId );
				pstmt.setString(5, userId );
				pstmt.setTimestamp( 6, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );

				rs = pstmt.executeQuery();

				if(rs.next())
				{
					localityCodeFrom = (rs.getString(1) == null)?"":rs.getString(1).trim();
					travelDate = rs.getTimestamp("TRAVEL_DATE");
				}
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}

			}
			stanCodeFrom[0] = localityCodeFrom;
			stanCodeFrom[1] = overNight;

		}
		catch ( Exception e )
		{
			System.out.println( "Exception :WsfaZuviusDsrMobileWizardEJB :defaultDataWiz :==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(con != null && isLocalConn)
				{
					con.close();
					con = null;
				}
			}
			catch(Exception e1){}
		}
		System.out.println("localityCodeFrom =["+localityCodeFrom+"], overNight =["+overNight+"]");
		//return localityCodeFrom;
		return stanCodeFrom;
	}

	public String[] getPlaceOfReturnFrom( Connection con, String userId, String eventDate ) throws ITMException
	{
		System.out.println("getPlaceOfReturnFrom......Called event_date=["+eventDate+"]");
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String  []localityCodeFrom = new String[2];
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		try
		{
			String activityType = "";
			String sprsTrvSql = "SELECT A.LOCALITY_CODE, A.ACTIVITY_CODE, B.ACTIVITY_TYPE, C.DESCR LOC_DESCR FROM SPRS_TRAVEL A, FIELDACTIVITY B, LOCALITY C " +
					" WHERE A.ACTIVITY_CODE = B.ACTIVITY_CODE AND A.LOCALITY_CODE = C.LOCALITY_CODE AND A.SALES_PERS = ?  " +
					" AND A.TRAVEL_DATE = (SELECT MAX(TRAVEL_DATE) FROM SPRS_TRAVEL WHERE SALES_PERS = ? AND TRAVEL_DATE < ? )";

			PreparedStatement pstmtTrv = con.prepareStatement(sprsTrvSql);
			pstmtTrv.setString(1, userId );
			pstmtTrv.setString(2, userId );
			pstmtTrv.setTimestamp( 3, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );

			ResultSet rsTrv = pstmtTrv.executeQuery();
			if(rsTrv.next())
			{
				localityCodeFrom[0] = (rsTrv.getString("LOCALITY_CODE") == null) ?"":rsTrv.getString("LOCALITY_CODE").trim();
				localityCodeFrom[1] = (rsTrv.getString("LOC_DESCR") == null) ?"":rsTrv.getString("LOC_DESCR").trim();
				activityType = (rsTrv.getString("ACTIVITY_TYPE") == null) ?"":rsTrv.getString("ACTIVITY_TYPE").trim();
			}
			rsTrv.close(); rsTrv = null;
			pstmtTrv.close(); pstmtTrv = null;

			//if("FW".equalsIgnoreCase(activityType))
			if(!("LEAVE".equalsIgnoreCase(activityType) || "NFW".equalsIgnoreCase(activityType)))
			{
				String stanCodeSql = " SELECT ST.LOCALITY_CODE , LOC.descr FROM  SPRS_TRAVEL ST, LOCALITY LOC "+
						" WHERE LOC.LOCALITY_CODE = ST.LOCALITY_CODE  "+
						" AND  SALES_PERS= ? AND TRAVEL_DATE =(SELECT MAX(TRAVEL_DATE) FROM SPRS_TRAVEL WHERE SALES_PERS=? and TRAVEL_DATE < ? )  "+
						" AND ST.OVER_NIGHT='Y'";
				pstmt =  con.prepareStatement(stanCodeSql);
				pstmt.setString(1, userId );
				pstmt.setString(2, userId );
				pstmt.setTimestamp(3,java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat())));
				rs = pstmt.executeQuery();

				if(rs.next())
				{
					localityCodeFrom[0] = rs.getString(1);
					localityCodeFrom[1] = rs.getString(2);

				}

				System.out.println("getPlaceOfReturnFrom......CalledlocalityCodeFrom[0].."+localityCodeFrom[0]+"localityCodeFrom[1].."+localityCodeFrom[1]);

				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
			}

		}
		catch ( Exception e )
		{
			System.out.println( "Exception :WsfaZuviusDsrMobileWizardEJB :defaultDataWiz :==>\n"+e.getMessage());
			throw new ITMException(e);
		}

		return localityCodeFrom ;
	}

	public String getLastStanCode( String salesPers, String eventDate ) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String localityCodeFrom = "";
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		Connection conn = null;
		String localityDescr = "";
		String planDataStr="";
		StringBuffer valueXmlString = new StringBuffer();
		java.sql.Timestamp travelDate = null;
		try
		{
			/*ConnDriver connDriver = new ConnDriver();
				conn = connDriver.getConnectDB( "DriverITM" );*/
			conn = getConnection();//chnged by sachin satre on [11-nov-16] to get connection

			valueXmlString = new StringBuffer( "<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<editFlag>" );
			valueXmlString.append( "" ).append( "</editFlag>\r\n</Header>\r\n<Errors>\r\n</Errors>\r\n" );
			valueXmlString.append( "<Detail1 domID='1'>\r\n" );

			String activityType = "";
			String overNight = "";

			String remarkStr="";
			String sprsRemark  = "SELECT SP.REMARK AS REMARK"
					+" FROM SPRS_ACT_TRAN SP,FIELDACTIVITY FD WHERE EVENT_DATE=? "
					+" AND SALES_PERS=? AND FD.ACTIVITY_CODE = SP.ACTIVITY_CODE AND FD.ACTIVITY_TYPE <> 'MKTEV'";
			PreparedStatement pstmtRemark = conn.prepareStatement(sprsRemark);

			pstmtRemark.setTimestamp( 1, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
			pstmtRemark.setString(2, checkNull(salesPers));

			ResultSet rsRemark = pstmtRemark.executeQuery();
			if(rsRemark.next())
			{
				remarkStr = (rsRemark.getString("REMARK") == null) ?"":rsRemark.getString("REMARK").trim();

			}
			rsRemark.close(); rsRemark = null;
			pstmtRemark.close(); pstmtRemark = null;

			String sprsTrvSql = "SELECT A.LOCALITY_CODE, A.OVER_NIGHT, B.ACTIVITY_TYPE, C.DESCR LOC_DESCR FROM SPRS_TRAVEL A, FIELDACTIVITY B, LOCALITY C " +
					" WHERE A.ACTIVITY_CODE = B.ACTIVITY_CODE AND A.LOCALITY_CODE = C.LOCALITY_CODE AND A.SALES_PERS = ?  " +
					" AND A.TRAVEL_DATE = (SELECT MAX(TRAVEL_DATE) FROM SPRS_TRAVEL WHERE SALES_PERS = ? AND TRAVEL_DATE < ? )";


			PreparedStatement pstmtTrv = conn.prepareStatement(sprsTrvSql);
			pstmtTrv.setString(1, salesPers );
			pstmtTrv.setString(2, salesPers );
			pstmtTrv.setTimestamp( 3, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );

			ResultSet rsTrv = pstmtTrv.executeQuery();
			if(rsTrv.next())
			{
				localityCodeFrom = (rsTrv.getString("LOCALITY_CODE") == null) ?"":rsTrv.getString("LOCALITY_CODE").trim();
				localityDescr = (rsTrv.getString("LOC_DESCR") == null) ?"":rsTrv.getString("LOC_DESCR").trim();
				activityType = (rsTrv.getString("ACTIVITY_TYPE") == null) ?"":rsTrv.getString("ACTIVITY_TYPE").trim();
				//overNight = (rsTrv.getString("OVER_NIGHT") == null) ?"":rsTrv.getString("OVER_NIGHT").trim();
			}
			rsTrv.close(); rsTrv = null;
			pstmtTrv.close(); pstmtTrv = null;

			System.out.println("localityCodeFrom=["+localityCodeFrom+"]");
			//if("FW".equalsIgnoreCase(activityType))
			if(!("LEAVE".equalsIgnoreCase(activityType) || "NFW".equalsIgnoreCase(activityType)))
			{

				String stanCodeSql = "SELECT ST.LOCALITY_CODE AS LOC_CODE, ST.TRAVEL_DATE AS TRAVEL_DATE, LOC.DESCR AS LOC_DESCR FROM  SPRS_TRAVEL ST, LOCALITY LOC "+
						" WHERE ORDER_OF_VISIT = ( SELECT MAX( ORDER_OF_VISIT) "+
						" FROM SPRS_TRAVEL WHERE SALES_PERS= ? AND TRAVEL_DATE =(SELECT MAX(TRAVEL_DATE) FROM SPRS_TRAVEL WHERE SALES_PERS=?  and TRAVEL_DATE < ?) " +
						" AND (DR_VISIT ='Y' OR RETAILER_VISIT ='Y' OR MERCH_VISIT='Y')) "+
						" AND LOC.LOCALITY_CODE = ST.LOCALITY_CODE "+
						" AND ST.SALES_PERS= ? AND ST.TRAVEL_DATE  =(SELECT MAX(TRAVEL_DATE) FROM SPRS_TRAVEL WHERE SALES_PERS=?  and TRAVEL_DATE < ?) ";
				pstmt =  conn.prepareStatement(stanCodeSql);
				pstmt.setString(1, salesPers );
				pstmt.setString(2, salesPers );
				pstmt.setTimestamp( 3, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
				pstmt.setString(4, salesPers );
				pstmt.setString(5, salesPers );
				pstmt.setTimestamp( 6, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );

				rs = pstmt.executeQuery();

				System.out.println("Inside method getStanCodeFrom eventDate"+eventDate);
				if(rs.next())
				{
					localityCodeFrom = (rs.getString("LOC_CODE") == null)?"":rs.getString("LOC_CODE").trim();
					localityDescr = (rs.getString("LOC_DESCR") == null)?"":rs.getString("LOC_DESCR").trim();
					travelDate = rs.getTimestamp("TRAVEL_DATE");
				}
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				valueXmlString.append( "<last_place_of_return><![CDATA[" ).append( localityCodeFrom ).append( "]]></last_place_of_return>\r\n" );
				valueXmlString.append( "<last_place_of_descr_return><![CDATA[" ).append(localityDescr).append( "]]></last_place_of_descr_return>\r\n" );

			}
			else
			{
				valueXmlString.append( "<last_place_of_return><![CDATA[" ).append( localityCodeFrom ).append( "]]></last_place_of_return>\r\n" );
				valueXmlString.append( "<last_place_of_descr_return><![CDATA[" ).append(localityDescr).append( "]]></last_place_of_descr_return>\r\n" );
			}
			valueXmlString.append( "<sprs_route_locality_code><![CDATA[" ).append( localityCodeFrom ).append( "]]></sprs_route_locality_code>\r\n" );
			valueXmlString.append( "<sprs_route_descr><![CDATA[" ).append( localityDescr ).append( "]]></sprs_route_descr>\r\n" );
			valueXmlString.append( "<remark><![CDATA[" ).append( remarkStr ).append( "]]></remark>\r\n" );

			valueXmlString.append("</Detail1>\r\n");
			valueXmlString.append("</Root>\r\n");

		}
		catch ( Exception e )
		{
			System.out.println( "Exception :WsfaZuviusDsrMobileWizardEJB :defaultDataWiz :==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(conn != null )
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e1){}
		}

		return valueXmlString.toString();
	}
	//public String getExistingTeamDetail( String salePersCode, String eventDate, String custType, Connection conn ) throws ITMException
	public String getExistingTeamDetail( String salePersCode, String eventDate, Connection conn ) throws ITMException
	{
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		int domID= 1;

		String teamData = "";
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		try
		{

			String dcrID = getDCRId(conn,salePersCode, eventDate);

			if(dcrID != null && dcrID.trim().length() > 0)
			{

				String strgCode = "";
				StringBuffer strgCodeBuff = new StringBuffer();
				//String meetSql = "SELECT STRG_CODE FROM STRG_MEET WHERE DCR_ID = ? AND STRG_TYPE = ?";
				String meetSql = "SELECT DISTINCT(STRG_CODE) FROM STRG_MEET WHERE DCR_ID = ? ";
				PreparedStatement pstmtMeet = conn.prepareStatement(meetSql);
				pstmtMeet.setString(1, dcrID);
				//pstmtMeet.setString(2, custType);

				ResultSet rsMeet = pstmtMeet.executeQuery();
				while(rsMeet.next())
				{
					strgCode = rsMeet.getString("STRG_CODE");

					if(strgCodeBuff.length() == 0)
					{
						strgCodeBuff.append("'").append(strgCode.toUpperCase()).append("'");
					}
					else
					{
						strgCodeBuff.append(",'").append(strgCode.toUpperCase()).append("'");
					}
				}
				rsMeet.close(); rsMeet = null;
				pstmtMeet.close(); pstmtMeet = null;

				String strgCodeList = strgCodeBuff.toString();

				if(strgCodeList == null || strgCodeList.trim().length() == 0)
				{
					strgCodeList = "''";
				}

				String smtQuery = "SELECT DISTINCT ST.SALES_PERS,UPPER(EMP.EMP_FNAME) ||' ' ||UPPER(EMP.EMP_MNAME) ||' '|| UPPER(EMP.EMP_LNAME) AS EMP_NAME, EMP.DESIGNATION DESIGNATION FROM STRG_MEET_TEAM ST LEFT OUTER JOIN EMPLOYEE EMP ON ST.SALES_PERS = EMP.EMP_CODE WHERE ST.DCR_ID = ? AND STRG_CODE IN("+strgCodeList+")";

				pstmt = conn.prepareStatement(smtQuery);
				pstmt.setString(1, dcrID);

				rs = pstmt.executeQuery();
				while(rs.next())
				{
					teamData = teamData + checkNull(rs.getString("EMP_NAME")) +" ("+checkNull(rs.getString("SALES_PERS"))+")," ;
				}
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}

				if(teamData.lastIndexOf(",")!= -1)
				{
					teamData = teamData.substring(0, teamData.length()-1);
				}
			}
		}
		catch(Exception e)
		{
			System.out.println( "Exception :WsfaDSRMobileWizardEJB :getExistingTeamDetail:" + e.getMessage() + ":" );
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :WsfaDSRMobileWizardEJB :getExistingTeamDetail :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		System.out.println("teamData ::"+teamData);
		return teamData;

	}
	public String getDCRId(Connection conn, String salesPers, String dcrDate) throws Exception
	{
		String dcrID = "";
		PreparedStatement pstmtDCRID = null;
		ResultSet rsDCRID = null;
		try
		{
			String activityCode = "";
			E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
			dcrDate = genericUtility.getValidDateTimeString( dcrDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );

			String dcrSql = "SELECT DCR_ID FROM SPRS_ACT_TRAN A, FIELDACTIVITY B WHERE A.ACTIVITY_CODE = B.ACTIVITY_CODE AND A.EVENT_DATE = ? AND A.SALES_PERS = ? AND B.ACTIVITY_TYPE = 'PR'" ;

			pstmtDCRID = conn.prepareStatement( dcrSql );
			pstmtDCRID.setTimestamp(1, java.sql.Timestamp.valueOf(dcrDate));
			pstmtDCRID.setString(2, salesPers);
			rsDCRID = pstmtDCRID.executeQuery();
			if( rsDCRID.next() )
			{
				dcrID = (rsDCRID.getString("DCR_ID") == null )?"":rsDCRID.getString("DCR_ID");
			}

		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rsDCRID != null)
				{
					rsDCRID.close();
					rsDCRID = null;
				}
				if(pstmtDCRID !=null)
				{
					pstmtDCRID.close();
					pstmtDCRID = null;
				}
			}
			catch(Exception e1){}
		}
		System.out.println("dcrID =["+dcrID+"]");
		return dcrID;
	}

	public String getDSRPlanData(String salesPers,String eventDate,Connection conn) throws ITMException //Chnaged by sachin satre on 11-nov-16
	{
		String returnXmlString="";
		String sprsPlanSql="";
		String planActivity="";
		String planLocality="";
		PreparedStatement sprsPstmt=null;
		ResultSet sprsResultSet= null;
		//Connection conn = null;
		//Commented and Changes Done By Gaurav Singh on 03-Sep-14
		//GenericUtility genericUtility = GenericUtility.getInstance();
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		StringBuffer valueXmlString = new StringBuffer();
		StringBuffer sprsPlanDetail = new StringBuffer();
		int count=0;
		boolean isLocalConn =false;
		try
		{
			if(conn == null)
			{
				/*ConnDriver connDriver = new ConnDriver();
					conn = connDriver.getConnectDB( "DriverITM" );*/
				conn = getConnection();//chnged by sachin satre on [11-nov-16] to get connection
				isLocalConn =true;
			}
			sprsPlanSql=" SELECT A.LOCALITY_CODE, B.ACTIVITY_TYPE  ACTIVITY_TYPE, C.DESCR LOC_DESCR FROM SPRS_PLAN A, FIELDACTIVITY B, LOCALITY C " +
					" WHERE A.PLAN_ACTIVITY = B.ACTIVITY_CODE AND A.LOCALITY_CODE = C.LOCALITY_CODE AND A.SPRS_CODE__PLAN = ? " +
					" AND A.PLAN_DATE = ? ";
			//valueXmlString.append("<table>\r\n");
			sprsPstmt = conn.prepareStatement(sprsPlanSql);
			sprsPstmt.setString(1, salesPers );
			//sprsPstmt.setString(2, salesPers );
			sprsPstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
			sprsResultSet = sprsPstmt.executeQuery();
			while(sprsResultSet.next())
			{
				count++;
				planActivity=sprsResultSet.getString("ACTIVITY_TYPE");
				planLocality=sprsResultSet.getString("LOC_DESCR");
				System.out.println("planActivity=["+planActivity+"],planLocality=["+planLocality+"]");
				valueXmlString.append("<tr>");
				System.out.println("\n Count =["+count+"]");
				if(count==1)
				{
					valueXmlString.append("<td class=\"td_leftAlign\"><plan_activity>").append(planActivity).append("</plan_activity></td>");
				}
				else
				{
					valueXmlString.append("<td class=\"td_leftAlign\"><plan_activity>").append("").append("</plan_activity></td>");
				}
				valueXmlString.append("<td class=\"td_leftAlign\"><plan_locality>").append(planLocality).append("</plan_locality></td>");
				valueXmlString.append("</tr>");
			}
			//sprsPlanDetail.append("<dsr_plan_data>").append(valueXmlString).append("</dsr_plan_data>\r\n");
			sprsPlanDetail.append("<dsr_plan_data>").append("<![CDATA["+valueXmlString+"]]>").append("</dsr_plan_data>\r\n");
			//valueXmlString.append("</table>\r\n");
			sprsResultSet.close();sprsResultSet=null;
			sprsPstmt.close();sprsPstmt=null;
		}
		catch (Exception e)
		{
			System.out.println("Exception :WsfaDSRMobileWizardEJB:getDSRPlanData()\n"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if(sprsResultSet!=null)
				{
					sprsResultSet.close();
					sprsResultSet=null;
				}
				if(sprsPstmt!=null)
				{
					sprsPstmt.close();
					sprsPstmt=null;
				}
				if(isLocalConn && conn!=null)
				{
					conn.close();
					conn=null;
				}

			}
			catch(Exception fe)
			{
				System.out.println("Exception :WsfaDSRMobileWizardEJB:getDSRPlanData(): finaly block \n"+fe.getMessage());
				fe.printStackTrace();
			}
		}
		returnXmlString=sprsPlanDetail.toString();
		//System.out.println("returnXmlString=["+returnXmlString+"]");

		return returnXmlString;
	}
	public String valHoliday(String eventdate, String empCode, String userId, ITMDBAccessLocal itmDBAccessLocal, Connection connectionObject) throws Exception
	{
		E12GenericUtility genericUtility = new E12GenericUtility();
		String errString = "";
		StrgMeetWizardBean strgMeetWizardBean = new StrgMeetWizardBean();
		eventdate = genericUtility.getValidDateTimeString( eventdate , getApplDateFormat() , getDBDateFormat());
		boolean isHoliday = strgMeetWizardBean.isEmpHoliday(empCode, eventdate, connectionObject);
		if(isHoliday)
		{
			errString = itmDBAccessLocal.getErrorString("event_date","HOLIDAY",userId);
		}
		return errString;
	}
	/*public String valHoliday(String eventdate, String sprs, String userId, ITMDBAccessLocal itmDBAccessLocal) throws ITMException
	{
		GenericUtility genericUtility = GenericUtility.getInstance();

		String errString = "";
		String columnValue = "";
		String checkSQL = "";
		String childNodeName = "";

		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null ;

		try
		{
			ConnDriver connDriver = new ConnDriver();
				connectionObject = connDriver.getConnectDB( "DriverValidator" );
			connectionObject = getConnection();//chnged by sachin satre on [11-nov-16] to get connection
			//Checking Hodiday
			eventdate = genericUtility.getValidDateString( eventdate , getApplDateFormat() , "dd-MMM-yyyy");
			checkSQL = "SELECT CODE FROM PERIOD WHERE ? BETWEEN FR_DATE AND TO_DATE";
			System.out.println(" sql [" + checkSQL + "]" );
			pstmt = connectionObject.prepareStatement(checkSQL);
			pstmt.setString(1,checkNull(eventdate));
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				String code = rs.getString( "CODE" );

				checkSQL = "SELECT DDF_GET_EMP_HOLIDAY(?,?,?,?) HOLDATE FROM DUAL ";
				System.out.println("sql [" + checkSQL + "] ");

				pstmt = connectionObject.prepareStatement(checkSQL);
				pstmt.setString(1,checkNull(sprs));
				pstmt.setString(2,checkNull(code));
				pstmt.setString(3,checkNull(code));
				pstmt.setString(4,checkNull(eventdate));
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					String holDate = rs.getString( 1 );
					System.out.println(" holDate [" + holDate + "] ");
					if ( holDate != null )
					{
						errString = itmDBAccessLocal.getErrorString("event_date","HOLIDAY",userId);
					}
				}
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}

				if (connectionObject != null)
				{
					connectionObject.close();
					connectionObject=null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return errString;
	}*/
	public String checkSequentialReporting(Connection connectionObject, String salesPers, String dcrDate)throws  ITMException
	{
		boolean isError = false;
		PreparedStatement pstmt = null ;
		ResultSet rs = null ;
		String sql = "";
		String errString = "";
		try
		{
			SimpleDateFormat sdfFormat = new SimpleDateFormat(getApplDateFormat());
			StrgMeetWizardBean strgMeetWizardBean=new StrgMeetWizardBean();
			GenericUtility genericUtility = GenericUtility.getInstance();
			String dcrDateString = dcrDate;
			dcrDate = genericUtility.getValidDateTimeString( dcrDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );

			System.out.println("::::salesPers" + salesPers + "::::dcrDate" + dcrDate);
			DateFormat dtFormat = new SimpleDateFormat(getApplDateFormat());
			String dateOfJoin = "";
			java.util.Date date = null;
			Object dateObj = null;

			String lastDCRDate = "";
			String sqlLastDcr = "";
			PreparedStatement pstmtLastDcr = null;
			ResultSet rsLastDcr = null;
			sqlLastDcr = "SELECT MAX(EVENT_DATE) LAST_DCR_DATE FROM SPRS_ACT_TRAN WHERE SALES_PERS = ?  AND  EVENT_DATE <= ? ";
			pstmtLastDcr =  connectionObject.prepareStatement(sqlLastDcr);
			pstmtLastDcr.setString(1, salesPers);
			pstmtLastDcr.setTimestamp(2, java.sql.Timestamp.valueOf(dcrDate));
			rsLastDcr = pstmtLastDcr.executeQuery();

			if(rsLastDcr.next())
			{
				dateObj =  ((rsLastDcr.getDate("LAST_DCR_DATE") == null) ?"":rsLastDcr.getDate("LAST_DCR_DATE"));
				if(dateObj.toString() != null && dateObj.toString().trim().length() > 0)
				{
					date = (Date) dateObj;
					lastDCRDate = dtFormat.format( date );
				}
				System.out.println("lastDCRDate =["+lastDCRDate+"]");

				if(lastDCRDate == null || lastDCRDate.trim().length()==0 || lastDCRDate == "")
				{
					String sqlDateJoin = "";
					sqlDateJoin = "SELECT DATE_JOIN  FROM EMPLOYEE WHERE EMP_CODE = ? ";
					PreparedStatement pstmtDateJoin = null;
					ResultSet rsDateJoin = null;
					pstmtDateJoin =  connectionObject.prepareStatement(sqlDateJoin);
					pstmtDateJoin.setString(1, salesPers);
					rsDateJoin = pstmtDateJoin.executeQuery();

					java.util.Date dateJoin = null;

					if(rsDateJoin.next())
					{
						dateObj =  ((rsDateJoin.getDate("DATE_JOIN") == null) ?"":rsDateJoin.getDate("DATE_JOIN"));
						if(dateObj.toString()!=null && dateObj.toString().trim().length() > 0)
						{
							date = (Date)dateObj;
							dateJoin = date;
							dateOfJoin = dtFormat.format( date );
						}
						System.out.println("dateOfJoin =["+dateOfJoin+"]");
					}
					if (rsDateJoin!= null)
					{
						rsDateJoin.close();
						rsDateJoin = null;
					}
					if(pstmtDateJoin!=null)
					{
						pstmtDateJoin.close();
						pstmtDateJoin = null;
					}

					//Changed by Gulzar on 31/08/13 : START
					String applStartDCRDateProp = "";
					java.util.Date applStartDCRDate = null;
					//String propSql = "SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME='APPL_START_DCR'";
					String propSql = "SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME='APPL_START_DAR'";
					PreparedStatement pstmtProp = connectionObject.prepareStatement(propSql);

					ResultSet rsProp = pstmtProp.executeQuery();

					if(rsProp.next())
					{
						applStartDCRDateProp = rsProp.getString("PROP_VALUE");
					}
					java.util.Date searchDateFrom = dateJoin;

					if(applStartDCRDateProp != null && applStartDCRDateProp.trim().length() > 0)
					{
						try
						{
							applStartDCRDate = sdfFormat.parse(applStartDCRDateProp);

							if(applStartDCRDate.after(dateJoin))
							{
								searchDateFrom = applStartDCRDate;
							}
						}
						catch(Exception ex)
						{
							errString = getErrorString("event_date","INVDATEFMT","");
							return errString;
						}
					}

					SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getDBDateFormat());

					java.util.Calendar cal = java.util.Calendar.getInstance();

					ArrayList<String> dateArr1 = new ArrayList<String>();

					Date eventDate1 = sdfFormat.parse(dcrDateString);
					cal.setTime( getDateObject( sdfFormat.format( eventDate1 ) ) );
					cal.add( cal.DATE, -1 );
					//sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());//Gulzar on 31/08/13
					String dcrDateString1 = sdfFormat.format(cal.getTime());
					Date eventDate2 = sdfFormat.parse(dcrDateString1);

					if(searchDateFrom.before(eventDate2))
					{
						int diffInDays = (int) Math.round((eventDate2.getTime()-searchDateFrom.getTime()) / (1000 * 60 * 60 * 24) );
						System.out.println("::::diffInDays" + diffInDays + "::::eventDate1" + eventDate1 +"::::searchDateFrom" + searchDateFrom);
						cal.setTime( getDateObject( sdfFormat.format( searchDateFrom ) ) );

						for(int i=0;i< diffInDays;i++)
						{
							boolean flag1 = false;

							cal.add( cal.DATE, 1 );
							sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
							String newDcrDate = sdf.format(cal.getTime());
							String newDcrDateString = genericUtility.getValidDateTimeString( newDcrDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
							//flag1 = validateHoliday( newDcrDateString ,salesPers, salesPers, connectionObject);
							flag1 = strgMeetWizardBean.isEmpHoliday(salesPers, newDcrDateString, connectionObject);
							if(flag1 == false)
							{
								dateArr1.add(newDcrDate);
							}
						}

						if(dateArr1 != null && dateArr1.size() > 0)
						{
							StringBuffer errStringXml = new StringBuffer("<?xml version = \"1.0\"?> \r\n <Root> <Errors>");
							errString = getErrorString("event_date", "PENDDCR", salesPers);
							String bifurErrString = errString.substring(errString.indexOf("<Errors>") + 8, errString.indexOf("<trace>"));
							bifurErrString = bifurErrString + errString.substring(errString.indexOf("</trace>") + 8, errString.indexOf("</Errors>"));
							errStringXml.append(bifurErrString);
							errStringXml.append("</Errors> </Root> \r\n");

							errString =errStringXml.toString();

							String msgDescr = errString.substring(errString.indexOf("<description>")+("<description>").length(),errString.indexOf("</description>"));
							String messageValue = msgDescr.substring(msgDescr.indexOf("<![CDATA[")+("<![CDATA[").length(),msgDescr.indexOf("]")) + dateArr1.toString();  ;
							String messageDescr = errString.substring(errString.indexOf("<message>")+("<message>").length(),errString.indexOf("</message>"));
							String message = messageDescr.substring(messageDescr.indexOf("<![CDATA[")+("<![CDATA[").length(),messageDescr.indexOf("]"));

							errString = "";
							StringBuffer valueXmlErrorString = new StringBuffer( "<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<Errors>\r\n" );
							valueXmlErrorString.append("<error id=\"PENDDCR\" type=\"E\" column_name=\"event_date\">");
							valueXmlErrorString.append("<message><![CDATA[").append(message).append("]]></message>\r\n");
							valueXmlErrorString.append("<description><![CDATA[").append(messageValue).append("]]></description>\r\n");
							valueXmlErrorString.append("<type>E</type>\r\n");
							valueXmlErrorString.append("<option></option>\r\n");
							valueXmlErrorString.append("<time></time>\r\n");
							valueXmlErrorString.append("<alarm></alarm>\r\n");
							valueXmlErrorString.append("<source></source>\r\n");
							valueXmlErrorString.append("<trace>Error : NO DATA</trace>\r\n");
							valueXmlErrorString.append("<redirect>1</redirect>\r\n");
							valueXmlErrorString.append("</error>\r\n");
							valueXmlErrorString.append("</Errors>\r\n");
							valueXmlErrorString.append("</Header>\r\n");
							valueXmlErrorString.append( "</Root>\r\n" );
							System.out.println( "\n****valueXmlErrorString :" + valueXmlErrorString.toString() + ":********" );
							errString =valueXmlErrorString.toString();
							return errString;
						}
					}
					//vishal
					if(rsProp != null)
					{
						rsProp.close(); rsProp = null;
					}
					if(pstmtProp != null)
					{
						pstmtProp.close(); pstmtProp = null;
					}
				}
				else
				{
					SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getDBDateFormat());
					java.util.Calendar cal = java.util.Calendar.getInstance();

					ArrayList<String> dateArr = new ArrayList<String>();
					Date lastDCRDate1 = sdfFormat.parse(lastDCRDate);

					Date eventDate1 = sdfFormat.parse(dcrDateString);
					cal.setTime( getDateObject( sdfFormat.format( eventDate1 ) ) );
					cal.add( cal.DATE, -1 );
					sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
					String dcrDateString1 = sdf.format(cal.getTime());
					Date eventDate2 = sdfFormat.parse(dcrDateString1);

					if(lastDCRDate1.before(eventDate2))
					{
						int diffInDays = (int) Math.round((eventDate2.getTime()-lastDCRDate1.getTime()) / (1000 * 60 * 60 * 24) );
						System.out.println("::::diffInDays" + diffInDays + "::::eventDate1" + eventDate1 +"::::lastDCRDate1" + lastDCRDate1);
						cal.setTime( getDateObject( sdfFormat.format( lastDCRDate1 ) ) );

						for(int i=0;i< diffInDays;i++)
						{
							boolean flagDCR1 = false;
							cal.add( cal.DATE, 1 );
							sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
							String newDcrDate = sdf.format(cal.getTime());
							String newDcrDateString = genericUtility.getValidDateTimeString( newDcrDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
							//flagDCR1 = validateHoliday( newDcrDateString ,salesPers, salesPers, connectionObject);
							flagDCR1 = strgMeetWizardBean.isEmpHoliday(salesPers, newDcrDateString, connectionObject);
							if(flagDCR1 == false)
							{
								dateArr.add(newDcrDate);
							}
						}

						if(dateArr != null && dateArr.size() > 0)
						{
							StringBuffer errStringXml = new StringBuffer("<?xml version = \"1.0\"?> \r\n <Root> <Errors>");
							errString = getErrorString("event_date", "PENDDCR", salesPers);
							String bifurErrString = errString.substring(errString.indexOf("<Errors>") + 8, errString.indexOf("<trace>"));
							bifurErrString = bifurErrString + errString.substring(errString.indexOf("</trace>") + 8, errString.indexOf("</Errors>"));
							errStringXml.append(bifurErrString);
							errStringXml.append("</Errors> </Root> \r\n");

							errString =errStringXml.toString();

							String msgDescr = errString.substring(errString.indexOf("<description>")+("<description>").length(),errString.indexOf("</description>"));
							String messageValue = msgDescr.substring(msgDescr.indexOf("<![CDATA[")+("<![CDATA[").length(),msgDescr.indexOf("]")) + dateArr.toString();  ;
							String messageDescr = errString.substring(errString.indexOf("<message>")+("<message>").length(),errString.indexOf("</message>"));
							String message = messageDescr.substring(messageDescr.indexOf("<![CDATA[")+("<![CDATA[").length(),messageDescr.indexOf("]"));

							errString = "";
							StringBuffer valueXmlErrorString = new StringBuffer( "<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<Errors>\r\n" );
							valueXmlErrorString.append("<error id=\"PENDDCR\" type=\"E\" column_name=\"event_date\">");
							valueXmlErrorString.append("<message><![CDATA[").append(message).append("]]></message>\r\n");
							valueXmlErrorString.append("<description><![CDATA[").append(messageValue).append("]]></description>\r\n");
							valueXmlErrorString.append("<type>E</type>\r\n");
							valueXmlErrorString.append("<option></option>\r\n");
							valueXmlErrorString.append("<time></time>\r\n");
							valueXmlErrorString.append("<alarm></alarm>\r\n");
							valueXmlErrorString.append("<source></source>\r\n");
							valueXmlErrorString.append("<trace>Error : NO DATA</trace>\r\n");
							valueXmlErrorString.append("<redirect>1</redirect>\r\n");
							valueXmlErrorString.append("</error>\r\n");
							valueXmlErrorString.append("</Errors>\r\n");
							valueXmlErrorString.append("</Header>\r\n");
							valueXmlErrorString.append( "</Root>\r\n" );
							System.out.println( "\n****valueXmlErrorString :" + valueXmlErrorString.toString() + ":********" );
							errString =valueXmlErrorString.toString();
							return errString;
						}
					}
				}
			}
			if (rsLastDcr!= null)
			{
				rsLastDcr.close();
				rsLastDcr = null;
			}
			if(pstmtLastDcr!=null)
			{
				pstmtLastDcr.close();
				pstmtLastDcr = null;
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception in findValue ");
			e.printStackTrace();
			throw new ITMException(e);
		}
		System.out.println("checkSequentialReporting >> errString =[" + errString +"]");
		return errString;
	}
	/*private boolean validateHoliday(String eventdate, String sprs, String userId, Connection connectionObject) throws Exception
	{
		System.out.println("@@@@@@@@@@@@@@@@@@@valHoliday@@@@@@@@@@@@");
		GenericUtility genericUtility = GenericUtility.getInstance();

		String errString = "";
		String columnValue = "";
		String checkSQL = "";
		String childNodeName = "";

		PreparedStatement pstmtPeriod = null;
		ResultSet rsPeriod = null ;

		boolean isHoliday = false;

		try
		{

			checkSQL = "SELECT CODE FROM PERIOD WHERE ? BETWEEN FR_DATE AND TO_DATE";
			System.out.println(" sql [" + checkSQL + "]" );
			pstmtPeriod = connectionObject.prepareStatement(checkSQL);
			pstmtPeriod.setTimestamp(1, java.sql.Timestamp.valueOf(eventdate));
			rsPeriod = pstmtPeriod.executeQuery();

			if(rsPeriod.next())
			{
				String code = rsPeriod.getString( "CODE" );
				String holDate = getEmpHoliday (sprs ,code ,code ,eventdate, connectionObject);
				if ( holDate != null )
				{
					isHoliday = true;
				}
				else
				{
					isHoliday =  false;
				}
			}
			else
			{
				isHoliday =  false;
			}

			if (rsPeriod != null)
			{
				rsPeriod.close();
				rsPeriod = null;
			}
			if(pstmtPeriod !=null)
			{
				pstmtPeriod.close();
				pstmtPeriod = null;
			}

		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw e;
		}
		finally
		{
			try
			{
				if (rsPeriod != null)
				{
					rsPeriod.close();
					rsPeriod = null;
				}
				if(pstmtPeriod !=null)
				{
					pstmtPeriod.close();
					pstmtPeriod = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return isHoliday;
	}

	private String getEmpHoliday (String empCode , String prdCodeFr , String prdCodeTo , String date, Connection conn) throws Exception
	{
		String holDate = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try
		{
			String holtblno = getHoltblno(empCode,date, conn);

			String Sql = " SELECT HOL_DATE AS A_HOL_DATE FROM HOLIDAY WHERE HOL_TBLNO = ? AND HOL_DATE = ? ";
			pstmt = conn.prepareStatement(Sql);
			pstmt.setString(1, holtblno);
			pstmt.setTimestamp(2, java.sql.Timestamp.valueOf(date));
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				holDate = rs.getString("A_HOL_DATE");
			}
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt !=null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		System.out.println("holDate =["+holDate+"]");
		return holDate;
	}*/

	private String getHoltblno (String emplCode, String eventDate, Connection conn ) throws Exception
	{
		int count = 0;
		int cnt = 0;
		String sql = null;
		String sqlCnt = null;
		String holTblNo = null;
		String sqlTbl = null;
		String sqlTblNo = null;
		PreparedStatement pstmtCount = null;
		ResultSet rsCount = null;
		PreparedStatement pstmtCnt = null;
		ResultSet rsCnt = null;
		PreparedStatement pstmtSet = null;
		ResultSet rsSet = null;
		PreparedStatement pstmtTbl = null;
		ResultSet rsTbl = null;
		PreparedStatement pstmtTblno = null;
		ResultSet rsTblno = null;

		try
		{
			sql = " SELECT COUNT(*) AS COUNT FROM EMP_EMPLOY_EVENTS WHERE EMP_CODE = ? AND CONFIRMED = 'Y'";
			pstmtCount = conn.prepareStatement(sql);
			pstmtCount.setString(1, emplCode);
			rsCount = pstmtCount.executeQuery();

			if(rsCount.next())
			{
				count = rsCount.getInt("COUNT");
			}
			System.out.println("EMP_EMPLOY_EVENTS count =["+count+"]");
			if(count > 0 )
			{
				String sql1 = " SELECT COUNT(*) AS COUNT FROM EMP_EMPLOY_EVENTS WHERE EMP_CODE = ? AND EFF_DATE = (SELECT MAX(EFF_DATE) FROM EMP_EMPLOY_EVENTS WHERE EMP_CODE = ? AND CONFIRMED =  'Y'AND EFF_DATE <= ?) AND CONFIRMED = 'Y'";
				pstmtCnt = conn.prepareStatement(sql1);
				pstmtCnt.setString(1, emplCode);
				pstmtCnt.setString(2, emplCode);
				pstmtCnt.setTimestamp(3, java.sql.Timestamp.valueOf(eventDate));
				rsCnt = pstmtCnt.executeQuery();

				if(rsCnt.next())
				{
					cnt = rsCnt.getInt("COUNT");
				}
				System.out.println("EMP_EMPLOY_EVENTS cnt =["+cnt+"]");
				if(cnt > 0 )
				{
					sqlCnt = " SELECT AA.HOL_TBLNO__TO AS HOL_TBLNO FROM EMP_EMPLOY_EVENTS AA WHERE AA.EMP_CODE = ? AND AA.CONFIRMED = 'Y' AND AA.TRAN_ID = ( SELECT MAX(BB.TRAN_ID) FROM EMP_EMPLOY_EVENTS BB WHERE BB.EMP_CODE = AA.EMP_CODE AND BB.EFF_DATE = ( SELECT MAX(CC.EFF_DATE) FROM EMP_EMPLOY_EVENTS CC WHERE CC.EMP_CODE = AA.EMP_CODE AND CC.EFF_DATE <= ? AND CC.CONFIRMED = 'Y' ) AND BB.CONFIRMED = 'Y')";
				}
				else
				{
					sqlCnt = " SELECT AA.HOL_TBLNO__FR AS HOL_TBLNO FROM EMP_EMPLOY_EVENTS AA WHERE AA.EMP_CODE = ? AND AA.CONFIRMED = 'Y' AND AA.TRAN_ID = ( SELECT MIN(BB.TRAN_ID) FROM EMP_EMPLOY_EVENTS BB WHERE BB.EMP_CODE = AA.EMP_CODE AND BB.EFF_DATE = ( SELECT MIN(CC.EFF_DATE) FROM EMP_EMPLOY_EVENTS CC WHERE CC.EMP_CODE = AA.EMP_CODE AND CC.EFF_DATE > ? AND CC.CONFIRMED = 'Y' ) AND BB.CONFIRMED = 'Y')";
				}
				pstmtSet = conn.prepareStatement(sqlCnt);
				pstmtSet.setString(1, emplCode);
				pstmtSet.setTimestamp(2, java.sql.Timestamp.valueOf(eventDate));
				rsSet = pstmtSet.executeQuery();
				if(rsSet.next())
				{
					holTblNo = rsSet.getString("HOL_TBLNO");
				}
			}

			if(holTblNo == null || (holTblNo).trim().length() == 0  )
			{
				String workSite = "";
				sqlTbl = "SELECT HOL_TBLNO, WORK_SITE FROM EMPLOYEE WHERE EMP_CODE = ? ";
				pstmtTbl = conn.prepareStatement(sqlTbl);
				pstmtTbl.setString(1, emplCode);
				rsTbl = pstmtTbl.executeQuery();
				if(rsTbl.next())
				{
					holTblNo = rsTbl.getString("HOL_TBLNO");
					workSite = rsTbl.getString("WORK_SITE");
				}

				if(holTblNo == null || (holTblNo).trim().length() == 0  )
				{
					sqlTblNo = "SELECT HOL_TBLNO FROM SITE WHERE SITE_CODE = ? ";
					pstmtTblno = conn.prepareStatement(sqlTblNo);
					pstmtTblno.setString(1, workSite);
					rsTblno = pstmtTblno.executeQuery();

					if(rsTblno.next())
					{
						holTblNo = rsTblno.getString("HOL_TBLNO");
					}
				}
			}
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rsCount != null)
				{
					rsCount.close();
					rsCount = null;
				}
				if(pstmtCount !=null)
				{
					pstmtCount.close();
					pstmtCount = null;
				}
				if (rsCnt != null)
				{
					rsCnt.close();
					rsCnt = null;
				}
				if(pstmtCnt !=null)
				{
					pstmtCnt.close();
					pstmtCnt = null;
				}
				if (rsSet != null)
				{
					rsSet.close();
					rsSet = null;
				}
				if(pstmtSet !=null)
				{
					pstmtSet.close();
					pstmtSet = null;
				}
				if (rsTbl != null)
				{
					rsTbl.close();
					rsTbl = null;
				}
				if(pstmtTbl !=null)
				{
					pstmtTbl.close();
					pstmtTbl = null;
				}
				if (rsTblno != null)
				{
					rsTblno.close();
					rsTblno = null;
				}
				if(pstmtTblno !=null)
				{
					pstmtTblno.close();
					pstmtTblno = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		System.out.println("holTblNo =["+holTblNo+"]");
		return holTblNo;
	}
	//Addded by Gaurav Singh on 02-Jun-2015 for Request Id [W15BMIT002].End

	// Changed by Rahul on 19-May-2016 [START] to check value of IS_PLAN_COMPULSARY from SFAPARM table
	public String getSfaParmValue(String userId,Connection connectionObject) //Chnaged by sachin satre on 11-nov-16
	{
		//Connection connectionObject = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String empSite="";
		String itemSer="";
		String isPlan="N";
		boolean isLocalConn =false;
		try
		{
			//chnged by sachin satre on [11-nov-16] to get connectioni
			if(connectionObject == null)
			{
				/*ConnDriver connDriver = new ConnDriver();
					connectionObject = connDriver.getConnectDB( "DriverValidator" );*/
				connectionObject = getConnection();//chnged by sachin satre on [11-nov-16] to get connectioni
				isLocalConn =true;
			}
			//chnged by sachin satre on [11-nov-16] to get connection
			String sql = "SELECT SITE_CODE__DEF FROM USERS WHERE CODE = ? ";
			pstmt = connectionObject.prepareStatement(sql);
			pstmt.setString(1, userId);

			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				empSite  = checkNull(rs.getString("SITE_CODE__DEF"));
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}

			System.out.println("value of empSite is::........."+empSite);
			//COMMENTED BY PRATHAMESH JANGAM ON 06/07/17 FOR DB2
			/*String getSalesPerData = " SELECT SALES_PERS.ITEM_SER,ITEMSER.DESCR FROM ITEMSER,SALES_PERS "+
										 " WHERE ( ITEMSER.ITEM_SER = SALES_PERS.ITEM_SER(+) ) AND  SALES_PERS.SALES_PERS = ? ";*/

			String getSalesPerData = "SELECT SALES_PERS.ITEM_SER,ITEMSER.DESCR FROM ITEMSER left outer join SALES_PERS on  ITEMSER.ITEM_SER = SALES_PERS.ITEM_SER WHERE  SALES_PERS.SALES_PERS = ?";

			pstmt = connectionObject.prepareStatement(getSalesPerData);
			pstmt.setString(1, userId);

			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				itemSer  = checkNull(rs.getString("ITEM_SER"));
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}

			sql=" SELECT PARM_VALUE  "+
					" FROM SFAPARM  "+
					" WHERE ORG_UNIT =?  "+
					" AND ACTIVE='Y'  "+
					" AND PARM_NAME='IS_PLAN_COMPULSORY' ";

			pstmt = connectionObject.prepareStatement(sql);
			pstmt.setString(1, empSite+"_"+itemSer);
			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				isPlan  = checkNull(rs.getString(1));
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}

			System.out.println("value of isPlan is::........."+isPlan);
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				//chnged by sachin satre on [11-nov-16] to get connectioni
				if( isLocalConn && connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
				//chnged by sachin satre on [11-nov-16] to get connectioni
			}
			catch (SQLException e) {
				e.printStackTrace();
			}
		}
		return isPlan;
	}
	// Changed by Rahul on 19-May-2016 [END] to check value of IS_PLAN_COMPULSARY from SFAPARM table
	//Added by Gulzar on 07-Oct-2016 for getting call note types [START]
	/*public String getCallNoteTypes( String xmlString, String xtraParams) throws Exception
		{
			System.out.println("in getCallNoteTypes");
			String listType = "";
			PreparedStatement pstmtNoteType = null;
			ResultSet rsNoteType = null;
			Connection conn = null;

			String noteType = "";
			String descr = "";
			String shDescr = "";
			String colorCode = "";
			JSONObject jsonObj = new JSONObject();
			String jSonKey="";

			try
			{
				JSONObject jsonNoteTypeObj = new JSONObject();
				E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
				Document dom=genericUtility.parseString(xmlString);
				System.out.println("Dom >>>:: "+dom);
				System.out.println("xmlString>>>::"+xmlString);
				jSonKey=genericUtility.getColumnValue("scope_object",dom);
				System.out.println("jSonKey>>>::"+jSonKey);
				if(jSonKey==null && jSonKey.trim().length()==0)
				{
					jSonKey="JSON";
				}

				ConnDriver connDriver = new ConnDriver();
				conn = connDriver.getConnectDB( "DriverITM" );
				conn = getConnection();//chnged by sachin satre on [11-nov-16] to get connection
				String noteTypeSql = "SELECT NOTE_TYPE, DESCR, SH_DESCR, REQ_FOLL_UP, TASK_TYPE, COLOR_CODE FROM CALL_NOTE_TYPE ";
				pstmtNoteType = conn.prepareStatement(noteTypeSql);
				rsNoteType = pstmtNoteType.executeQuery();
				while(rsNoteType.next())
				{
					noteType = checkNull(rsNoteType.getString("NOTE_TYPE"));
					descr = checkNull(rsNoteType.getString("DESCR"));
					shDescr = checkNull(rsNoteType.getString("SH_DESCR"));
					colorCode = checkNull(rsNoteType.getString("COLOR_CODE"));

					jsonNoteTypeObj.put(noteType, shDescr+","+colorCode);

				}
				System.out.println("jSonKey>>>::"+jSonKey);
				jsonObj.put(jSonKey, jsonNoteTypeObj);

				System.out.println("jsonConvertedData ::"+jsonObj.toString());
			}
			catch(Exception e)
			{
				System.out.println("Exception in getcallnotetype ::"+e.getMessage());
				throw e;
			}
			finally
			{
				try
				{
					if(rsNoteType != null)
					{
						rsNoteType.close();
						rsNoteType = null;
					}
					if(pstmtNoteType != null)
					{
						pstmtNoteType.close();
						pstmtNoteType = null;
					}
					if(conn != null)
					{
						conn.close();
						conn = null;
					}
				}
				catch(Exception e)
				{

				}
			}
			return jsonObj.toString();
		}*/
	//Added by Gulzar on 07-Oct-2016 for getting call note types [END]

	public String getPrevFormVal( Document dom, String currentFormNo, ArrayList temp, String colName ) throws ITMException
	{
		GenericUtility genericUtility = GenericUtility.getInstance();
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		Element elementAttr = null;
		String childNodeName = "";
		String columnValue = "";
		String returnPrevStr = "";
		Document chgPreDom = null;
		try
		{
			chgPreDom = genericUtility.parseString("<Root/>");
			//System.out.println("currentFormNo ["+currentFormNo+"] \n dom["+genericUtility.serializeDom(dom)+"]");
			parentList = dom.getElementsByTagName("Detail" + currentFormNo);
			int parentNodeListLength = parentList.getLength();
			System.out.println("parentlistlength["+parentNodeListLength+"]");
			for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
			{
				parentNode = parentList.item(prntCtr);
				childList = parentNode.getChildNodes();
				for (int ctr = 0; ctr < childList.getLength(); ctr++)
				{
					childNode = childList.item(ctr);
					if((childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null))
					{
						columnValue = childNode.getFirstChild().getNodeValue().trim();
						//	System.out.println("childNode.getNodeName()["+childNode.getNodeName()+"]columnValue["+columnValue+"]temp["+temp+"] ");
						if ( childNode.getNodeName().equalsIgnoreCase(colName) && temp.contains(columnValue))
						{
							elementAttr = (Element)parentNode;
							if ( parentNode.getAttributes().getNamedItem( "domID" ) != null )
							{
								//Changes By Prajyot On 22-11-2011
								//[ For Items Details to maintain the default domID it is necessary to discard the new domID generation ]
								//elementAttr.setAttribute( "domID" , Integer.toString(domID) );
								elementAttr.setAttribute( "selected" , "Y" );
								domID++;
							}
							Node importedNode = chgPreDom.importNode( parentNode, true );
							chgPreDom.getDocumentElement().appendChild( importedNode );
							break;
						}

					}
				}

			}
			if(currentFormNo.equals("1"))
			{
				domID = 1;
			}
			returnPrevStr = genericUtility.serializeDom(chgPreDom);
			if(returnPrevStr.indexOf("Detail"+currentFormNo) != -1)
			{
				returnPrevStr = returnPrevStr.substring(returnPrevStr.indexOf(">") + 1, returnPrevStr.lastIndexOf("</"));
			}
			returnPrevStr = returnPrevStr.indexOf("Detail"+currentFormNo) != -1 ? returnPrevStr : "";
		}
		catch ( Exception e )
		{
			System.out.println( "Exception :SavexWizardEJB :getPrevFormValues :==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		return returnPrevStr;

	}
	public String getCallNoteTypes( String xmlString, String xtraParams) throws Exception
	{
		System.out.println("in getCallNoteTypes");
		String listType = "";
		PreparedStatement pstmtNoteType = null;
		ResultSet rsNoteType = null;
		Connection conn = null;
		String noteType = "";
		String descr = "";
		String shDescr = "";
		String colorCode = "";
		JSONObject jsonObj = new JSONObject();
		String jSonKey="";
		try
		{
			JSONObject jsonNoteTypeObj = new JSONObject();
			E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
			Document dom=genericUtility.parseString(xmlString);
			System.out.println("Dom >>>:: "+dom);
			System.out.println("xmlString>>>::"+xmlString);
			jSonKey=genericUtility.getColumnValue("scope_object",dom);
			System.out.println("jSonKey>>>::"+jSonKey);
			if(jSonKey==null && jSonKey.trim().length()==0)
			{
				jSonKey="JSON";
			}
			/*ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB( "DriverITM" );*/
			conn = getConnection();//chnged by sachin satre on [11-nov-16] to get connection
			String noteTypeSql = "SELECT NOTE_TYPE, DESCR, SH_DESCR, REQ_FOLL_UP, TASK_TYPE, COLOR_CODE FROM CALL_NOTE_TYPE ";
			pstmtNoteType = conn.prepareStatement(noteTypeSql);
			rsNoteType = pstmtNoteType.executeQuery();
			while(rsNoteType.next())
			{
				noteType = checkNull(rsNoteType.getString("NOTE_TYPE"));
				descr = checkNull(rsNoteType.getString("DESCR"));
				shDescr = checkNull(rsNoteType.getString("SH_DESCR"));
				colorCode = checkNull(rsNoteType.getString("COLOR_CODE"));
				jsonNoteTypeObj.put(noteType, shDescr+","+colorCode);
			}
			System.out.println("jSonKey>>>::"+jSonKey);
			if(rsNoteType != null)
			{
				rsNoteType.close();
				rsNoteType = null;
			}
			if(pstmtNoteType != null)
			{
				pstmtNoteType.close();
				pstmtNoteType = null;
			}
			jsonObj.put(jSonKey, jsonNoteTypeObj);
			System.out.println("jsonConvertedData ::"+jsonObj.toString());
		}
		catch(Exception e)
		{
			System.out.println("Exception in getcallnotetype ::"+e.getMessage());
			throw e;
		}
		finally
		{
			try
			{
				if(rsNoteType != null)
				{
					rsNoteType.close();
					rsNoteType = null;
				}
				if(pstmtNoteType != null)
				{
					pstmtNoteType.close();
					pstmtNoteType = null;
				}
				if(conn != null)
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return jsonObj.toString();
	}
	public String getPrevFormLocValues( Document dom, String currentFormNo, ArrayList temp, String colName, String modeReport, Connection conn) throws ITMException
	{
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		Element elementAttr = null;
		String childNodeName = "";
		String columnValue = "";
		String returnPrevStr = "";
		Document chgPreDom = null;

		try
		{

			chgPreDom = genericUtility.parseString("<Root/>");
			System.out.println("currentFormNo ["+currentFormNo+"]");
			parentList = dom.getElementsByTagName("Detail" + currentFormNo);
			int parentNodeListLength = parentList.getLength();
			for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
			{
				boolean isFound = false;
				parentNode = parentList.item(prntCtr);
				childList = parentNode.getChildNodes();
				for (int ctr = 0; ctr < childList.getLength(); ctr++)
				{
					childNode = childList.item(ctr);
					String chileNodeName =  childNode.getNodeName();

					if((childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null))
					{
						columnValue = childNode.getFirstChild().getNodeValue().trim();
						if ( childNode.getNodeName().equalsIgnoreCase(colName) && temp.contains("'"+columnValue+"'"))
						{
							elementAttr = (Element)parentNode;
							if ( parentNode.getAttributes().getNamedItem( "domID" ) != null )
							{
								isFound = true;
								elementAttr.setAttribute( "selected", "Y" );
								domID++;
							}
							/*Node importedNode = chgPreDom.importNode(parentNode  , true );
							chgPreDom.getDocumentElement().appendChild( importedNode );*/
							break;
						}
					}
				}

				System.out.println( "parentNode - ["+ genericUtility.serializeDom( parentNode ) +"]" );

				if( isFound && "E".equalsIgnoreCase(modeReport) )
				{
					String cchgDomStr = genericUtility.serializeDom(parentNode);
					if(cchgDomStr.indexOf("<dr_visit>") != -1)
					{
						cchgDomStr = cchgDomStr.replaceAll("<dr_visit>", "<dr_visit protect='1'>");
					}
					if(cchgDomStr.indexOf("<chem_visit>") != -1)
					{
						cchgDomStr = cchgDomStr.replaceAll("<chem_visit>", "<chem_visit protect='1'>");
					}
					if(cchgDomStr.indexOf("<stockist_visit>") != -1)
					{
						cchgDomStr = cchgDomStr.replaceAll("<stockist_visit>", "<stockist_visit protect='1'>");
					}
					if(cchgDomStr.indexOf("<other_visit>") != -1)
					{
						cchgDomStr = cchgDomStr.replaceAll("<other_visit>", "<other_visit protect='1'>");
					}

					Document chgParentDom = genericUtility.parseString(cchgDomStr);
					Node selNode = chgParentDom.getElementsByTagName("Detail"+currentFormNo).item(0);
					Node importedNode = chgPreDom.importNode( selNode, true );
					chgPreDom.getDocumentElement().appendChild( importedNode );
				}
				else if( isFound && !"E".equalsIgnoreCase(modeReport) )
				{
					String locCode = getSelectedRowValue(dom ,""+2 ,"locality_code",prntCtr);
					String sprsCode = getSelectedRowValue(dom ,""+2 ,"sales_pers",prntCtr);
					String isDrExist = "";
					String isNCWExist = "";
					String isChemExist = "";
					String isStockExist = "";
					if(locCode != null && locCode.trim().length()>0)
					{
						isDrExist = checkCustExist(sprsCode, locCode, "D", conn);
						isChemExist = checkCustExist(sprsCode, locCode, "C", conn);
						isStockExist = checkCustExist(sprsCode, locCode, "S", conn);
						isNCWExist = checkCustExist(sprsCode, locCode, "O", conn);
					}
					System.out.println("isDrExist 123["+isDrExist+"]isNCWExist123["+isNCWExist);
					System.out.println("locality["+locCode+"]isNCWAva");
					System.out.println("Inside drotherif");
					String cchgDomStr = genericUtility.serializeDom(parentNode);
					if(cchgDomStr.indexOf("<dr_visit>") != -1 && isDrExist.equalsIgnoreCase("N"))
					{
						System.out.println("Inside drvisit");
						cchgDomStr = cchgDomStr.replace("<dr_visit>", "<dr_visit protect='1'>");
					}
					if(cchgDomStr.indexOf("<chem_visit>") != -1 && isChemExist.equalsIgnoreCase("N"))
					{
						System.out.println("Inside chem_visit");
						cchgDomStr = cchgDomStr.replace("<chem_visit>", "<chem_visit protect='1'>");
					}
					if(cchgDomStr.indexOf("<stockist_visit>") != -1 && isStockExist.equalsIgnoreCase("N"))
					{
						System.out.println("Inside stockist_visit");
						cchgDomStr = cchgDomStr.replace("<stockist_visit>", "<stockist_visit protect='1'>");
					}
					if(cchgDomStr.indexOf("<other_visit>") != -1 && isNCWExist.equalsIgnoreCase("N"))
					{
						System.out.println("Inside other_visit");
						cchgDomStr = cchgDomStr.replace("<other_visit>", "<other_visit protect='1'>");
					}
					Document chgParentDom = genericUtility.parseString(cchgDomStr);
					Node selNode = chgParentDom.getElementsByTagName("Detail"+currentFormNo).item(0);
					System.out.println("Chgpredom value:- "+genericUtility.serializeDom( chgPreDom )+"Node value is:---"+genericUtility.serializeDom( chgParentDom ));
					Node importedNode = chgPreDom.importNode( selNode, true );
					chgPreDom.getDocumentElement().appendChild( importedNode );
				}
			}
			if(currentFormNo.equals("1"))
			{
				domID = 1;
			}
			returnPrevStr = genericUtility.serializeDom(chgPreDom);
			if(returnPrevStr.indexOf("Detail"+currentFormNo) != -1)
			{
				returnPrevStr = returnPrevStr.substring(returnPrevStr.indexOf(">") + 1, returnPrevStr.lastIndexOf("</"));
			}
			returnPrevStr = returnPrevStr.indexOf("Detail"+currentFormNo) != -1 ? returnPrevStr : "";
		}
		catch ( Exception e )
		{
			System.out.println( "Exception :WsfaZuviusDsrMobileWizardEJB :getPrevFormValues :==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		return returnPrevStr;

	}
	public String getPrevFormCustValues( Document dom, String currentFormNo, ArrayList temp, String colName) throws ITMException
	{
		//changed by Rahul Barve on 10-Apr-2015
		//GenericUtility genericUtility = GenericUtility.getInstance();
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		Element elementAttr = null;
		String childNodeName = "";
		String columnValue = "";
		String returnPrevStr = "";
		Document chgPreDom = null;

		HashMap locVisitMap = new HashMap();

		try
		{
			//String drVisit = checkNull(genericUtility.getColumnValue("dr_visit", dom, "3"));
			//String othVisit = checkNull(genericUtility.getColumnValue("other_visit", dom, "3"));

			///////////////////
			parentList = dom.getElementsByTagName("Detail2");
			int parentNodeListLength1 = parentList.getLength();
			for (int prntCtr = 0; prntCtr < parentNodeListLength1; prntCtr++ )
			{
				ArrayList custVisitList = new ArrayList();
				String localityCode = "";
				String drVisit = "";
				String ncwVisit = "";
				String chemVisit = "";
				String stockVisit = "";
				String chileNodeName = "";
				parentNode = parentList.item(prntCtr);
				childList = parentNode.getChildNodes();
				for (int ctr = 0; ctr < childList.getLength(); ctr++)
				{
					childNode = childList.item(ctr);

					chileNodeName = childNode.getNodeName();

					if ( "locality_code".equalsIgnoreCase(chileNodeName))
					{
						if((childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null))
						{
							localityCode = childNode.getFirstChild().getNodeValue().trim();
						}

					}
					else if ( "dr_visit".equalsIgnoreCase(chileNodeName))
					{
						if((childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null))
						{
							drVisit = childNode.getFirstChild().getNodeValue().trim();
						}

					}
					else if ( "chem_visit".equalsIgnoreCase(chileNodeName))
					{
						if((childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null))
						{
							chemVisit = childNode.getFirstChild().getNodeValue().trim();
						}

					}
					else if ( "stockist_visit".equalsIgnoreCase(chileNodeName))
					{
						if((childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null))
						{
							stockVisit = childNode.getFirstChild().getNodeValue().trim();
						}

					}
					else if ( "other_visit".equalsIgnoreCase(chileNodeName))
					{
						if((childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null))
						{
							ncwVisit = childNode.getFirstChild().getNodeValue().trim();
						}

					}

				}
				custVisitList.add(0, drVisit);
				custVisitList.add(1, ncwVisit);
				custVisitList.add(2, chemVisit);
				custVisitList.add(3, stockVisit);
				locVisitMap.put(localityCode, custVisitList);


			}
			////////////////

			System.out.println("locVisitMap ::"+locVisitMap);

			chgPreDom = genericUtility.parseString("<Root/>");
			System.out.println("currentFormNo ["+currentFormNo+"]");
			parentList = dom.getElementsByTagName("Detail" + currentFormNo);
			int parentNodeListLength = parentList.getLength();
			for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
			{
				parentNode = parentList.item(prntCtr);
				childList = parentNode.getChildNodes();
				for (int ctr = 0; ctr < childList.getLength(); ctr++)
				{
					childNode = childList.item(ctr);

					if((childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null))
					{
						columnValue = childNode.getFirstChild().getNodeValue().trim();
						if ( childNode.getNodeName().equalsIgnoreCase(colName) && temp.contains("'"+columnValue+"'"))
						{
							ArrayList visitList = (ArrayList)locVisitMap.get(columnValue);
							System.out.println("visitList ::"+visitList);
							if(visitList != null && ("Y".equalsIgnoreCase((String)visitList.get(0)) && "3".equalsIgnoreCase(currentFormNo)) || ("Y".equalsIgnoreCase((String)visitList.get(1)) && "9".equalsIgnoreCase(currentFormNo) ) || ("Y".equalsIgnoreCase((String)visitList.get(2)) && "9".equalsIgnoreCase(currentFormNo) ) || ("Y".equalsIgnoreCase((String)visitList.get(3)) && "8".equalsIgnoreCase(currentFormNo) ) )
							{
								elementAttr = (Element)parentNode;
								if ( parentNode.getAttributes().getNamedItem( "domID" ) != null )
								{
									//elementAttr.setAttribute( "domID" , Integer.toString(domID) );
									elementAttr.setAttribute( "selected" , "Y" );
									domID++;
								}
								Node importedNode = chgPreDom.importNode( parentNode, true );
								chgPreDom.getDocumentElement().appendChild( importedNode );
								break;
							}
						}

					}
				}

			}
			if(currentFormNo.equals("1"))
			{
				domID = 1;
			}
			returnPrevStr = genericUtility.serializeDom(chgPreDom);
			if(returnPrevStr.indexOf("Detail"+currentFormNo) != -1)
			{
				returnPrevStr = returnPrevStr.substring(returnPrevStr.indexOf(">") + 1, returnPrevStr.lastIndexOf("</"));
			}
			returnPrevStr = returnPrevStr.indexOf("Detail"+currentFormNo) != -1 ? returnPrevStr : "";
		}
		catch ( Exception e )
		{
			System.out.println( "Exception :WsfaZuviusDsrMobileWizardEJB :getPrevFormValues :==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		return returnPrevStr;

	}
	private String checkCustExist(String sprsCode, String locCode, String scType,Connection connectionObject) throws ITMException
	{
		String custPresent = "Y";
		try
		{
			String selectSql = "";
			int count = 0;
			PreparedStatement pstmt = null;
			ResultSet rSet = null;
			if(!scType.equalsIgnoreCase("O"))
			{
				selectSql = "select count(1) as count from strg_series ss,strg_customer sc where sc.locality_Code = ? and ss.sales_pers= ? and ss.sc_code = sc.sc_code and sc.cust_type = ? and ss.status = 'Y'";
			}
			else if(scType.equalsIgnoreCase("O"))
			{
				selectSql = "select count(1) as count from strg_series ss,strg_customer sc where sc.locality_Code = ? and ss.sales_pers= ? and ss.sc_code = sc.sc_code and sc.cust_type not in ('D','S','C') and ss.status = 'Y'";
			}
			System.out.println("selectSql ["+selectSql+"]");

			pstmt = connectionObject.prepareStatement(selectSql);
			pstmt.setString(1,locCode);
			pstmt.setString(2,sprsCode);
			if(!scType.trim().equalsIgnoreCase("O"))
			{
				pstmt.setString(3,scType);
			}
			rSet = pstmt.executeQuery();
			if(rSet.next())
			{
				count = rSet.getInt("count");
			}
			if (rSet!= null)
			{
				rSet.close();
				rSet = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			System.out.println("count ["+count+"]");

			if (count <= 0)
			{
				custPresent = "N";
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		return custPresent;
	}

	public String wfValSalesPersAct(Document dom, Document dom2, String currentFormNo, String userId,Connection connectionObject) throws ITMException //chnged by sachin satre on [9-nov-16] to get connection
	{
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;

		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

		String errString = "";
		String errStringNew = "";
		String checkSQL = "";
		String childNodeName = "";
		String columnValue = "";

		PreparedStatement pstmt = null;
		ResultSet rSet = null ;

		ITMDBAccessEJB itmDBAccessLocal = null;// modified by kailash.
		boolean isLocalConn=false;
		int noOfChilds = 0;
		try
		{

			if(connectionObject == null)
			{
				connectionObject = getConnection();//chnged by sachin satre on [9-nov-16] to get connection
				isLocalConn=true;
			}

			AppConnectParm appConnect = new AppConnectParm();
			Properties p = appConnect.getProperty();
			InitialContext ctx = new InitialContext(p);
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[Start]
			//itmDBAccessLocal = (ITMDBAccessLocal)ctx.lookup("ibase/ITMDBAccessEJB/local");
			itmDBAccessLocal = new ITMDBAccessEJB();
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[End]

			parentList = dom.getElementsByTagName("Detail"+ currentFormNo);
			int parentNodeListLength = parentList.getLength();
			System.out.println("parentNodeListLength["+parentNodeListLength+"]");

			for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
			{
				parentNode = parentList.item(prntCtr);
				childList = parentNode.getChildNodes();
				noOfChilds = childList.getLength();
				for (int ctr = 0; ctr < noOfChilds; ctr++)
				{
					childNode = childList.item(ctr);
					if( childNode.getNodeType() != Node.ELEMENT_NODE )
					{
						continue;
					}

					if ( childNode != null && childNode.getFirstChild() != null )
					{
						columnValue = childNode.getFirstChild().getNodeValue();
					}
					childNodeName = childNode.getNodeName();
					System.out.println("childNodeName =["+childNodeName+"]");

					if(childNodeName.equalsIgnoreCase("event_date"))
					{
						if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
								( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
						{
							errString = itmDBAccessLocal.getErrorString("event_date","NULLEVTCOD",userId);
							break;
						}
						else //to validate future date and holidays
						{
							SimpleDateFormat sdfFormat = new SimpleDateFormat(getApplDateFormat());
							java.util.Date eventDate = sdfFormat.parse( childNode.getFirstChild().getNodeValue());
							String evtdat=childNode.getFirstChild().getNodeValue();
							//Changed By Vidhya on 09/12/09[WS89NOV647 | date validation for 00/00/00] Start
							if (!sdfFormat.format(eventDate).equals(evtdat))
							{
								errString = itmDBAccessLocal.getErrorString( "event_date", "INVDTFRMT", userId );
								break;
							}
							//Changed By Vidhya on 09/12/09[WS89NOV647 | date validation for 00/00/00] End

							if ( ( eventDate.compareTo( getDateObject( sdfFormat.format( new Date() ) ) ) ) > 0 )
							{
								errString = itmDBAccessLocal.getErrorString( "event_date", "FUTUREVENT", userId );
								break;
							}


							String salesPers = genericUtility.getColumnValue( "sales_pers" , dom );

							//changed for not allow to edit the DCR once confirmed - Gulzar
							String dcrDate = genericUtility.getColumnValue( "event_date" , dom );

							String confirmed = "";
							dcrDate = genericUtility.getValidDateTimeString( dcrDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
							String selectSql = "SELECT CONFIRMED FROM SPRS_ACT_TRAN WHERE SALES_PERS = ? AND EVENT_DATE = ? "+
									"AND ACTIVITY_CODE IN (SELECT ACTIVITY_CODE FROM FIELDACTIVITY WHERE ACTIVITY_TYPE = 'PR')"; // added by condition rupali on 14/03/17 for separate pr menu
							PreparedStatement pstmtSel = connectionObject.prepareStatement(selectSql);
							pstmtSel.setString(1, salesPers);
							pstmtSel.setTimestamp(2, java.sql.Timestamp.valueOf(dcrDate));
							ResultSet rsSelect = pstmtSel.executeQuery();
							if(rsSelect.next())
							{
								confirmed = (rsSelect.getString("CONFIRMED") == null) ?"":rsSelect.getString("CONFIRMED").trim();
							}
							rsSelect.close(); rsSelect = null;
							pstmtSel.close(); pstmtSel = null;
							if("Y".equalsIgnoreCase(confirmed))
							{
								errString = itmDBAccessLocal.getErrorString( "event_date" , "PRCONFD" , userId ); // changed error code by rupali on 14/03/17 for separate pr menu
								break;
							}


							int allowDays = 0;
							String propName = "MAX_ALLOW_PRD_MEET";//ADDED BY DIPAK FOR DB2
							//checkSQL = "SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME ='MAX_ALLOW_PRD_MEET'";//Commented By Dipak FOR DB2
							checkSQL = "SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME = ? ";//ADDED By Dipak FOR DB2
							pstmt = connectionObject.prepareStatement(checkSQL);
							pstmt.setString(1, propName);//ADDED By Dipak FOR DB2
							rSet = pstmt.executeQuery();//ADDED By Dipak FOR DB2
							if( rSet.next() )
							{
								allowDays = rSet.getInt("PROP_VALUE");
								System.out.println("allowDays Exist In Properties are ["+allowDays+"]");
								java.util.Calendar cal = java.util.Calendar.getInstance();
								java.util.Date currDate = new java.util.Date();
								cal.setTime( currDate );
								cal.add( cal.DATE, -allowDays );
								if( eventDate.before( cal.getTime() ) )
								{
									errString = itmDBAccessLocal.getErrorString( "event_date" , "XCIDMITLMT" , userId );
									break;
								}
							}
							if (rSet!= null)
							{
								rSet.close();
								rSet = null;
							}
							if(pstmt!=null)
							{
								pstmt.close();
								pstmt = null;
							}

							//for checking Holiday
							String eventdate = childNode.getFirstChild().getNodeValue();


							if( salesPers != null && eventdate != null )
							{
								// Changed by Rahul on 26-june-2015 [Start] for Sequential Reporting message on Holiday.
								errStringNew = checkSequentialReporting(connectionObject, salesPers, evtdat);
								if(errStringNew != null && errStringNew.indexOf("<Errors>") != -1)
								{
									System.out.println("Sequential.......:");
									break;
								}
								// Changed by Rahul on 26-june-2015 [End] for Sequential Reporting message on Holiday.
								errString = valHoliday( eventdate, salesPers, userId, itmDBAccessLocal, connectionObject );
								if(errString != null && errString.length()>0 && errString.indexOf("Errors")!=-1)
								{
									System.out.println("Holiday.......:");
									break;

								}

							}
							//Changed By Vidhya on 09/12/09[WS89NOV647 | validation order change] end

						}

					}
				}
				if(errString.indexOf("<Errors>")!=-1)
				{
					break;
				}
			}
		}
		catch(Exception e)
		{
			System.out.println ( "Exception :WsfaZuviusDsrWizardEJB :wfValData():" + e.getMessage() + ":" );
			//Commented and added by Dipak 05/11/12
			//errString = generateErrorString(genericUtility.createErrorString(e));
			throw new ITMException(e);
			//End changes by Dipak 05/11/12
		}
		finally
		{
			try
			{
				if (rSet!= null)
				{
					rSet.close();
					rSet = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}

				//chnged by sachin satre on 9-nov-16 [] to get connection from parameter [start]
				if( isLocalConn && connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
				//chnged by sachin satre on 9-nov-16 [] to get connection from parameter [start]
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}

		return errString;
	}

	public String getExistingPitchForDoctor( String salePersCode, String wrkDate, String scCode, String objNameDefault, String callOutcome, String currentFormNo, String formName,Connection connectionObject ) throws ITMException
	{
		System.out.println("In side getExistingPitchForDoctor.......");
		ResultSet rs = null;
		//Connection connectionObject = null;
		PreparedStatement pstmt = null;
		int domID = 1;
		StringBuffer valueXmlString = new StringBuffer();
		String wrkDateInDbFmt = "", sdQuery = "", pitchDetData ="";

		GenericUtility genericUtility = GenericUtility.getInstance();
		try
		{
			//ConnDriver connDriver = new ConnDriver();
			//connectionObject = connDriver.getConnectDB( "DriverValidator" );
			DateFormat dtFormat = new SimpleDateFormat(getApplDateFormat());
			java.util.Date date = Calendar.getInstance().getTime();
			String currDate = dtFormat.format( date );

			System.out.println("getExistingPitchForDoctor callOutcome ::["+callOutcome+"]");
			HashMap callOutMap = new HashMap();
			if(callOutcome.contains(",") && callOutcome != null )
			{
				///callOutMap = getExistingCallOutcome( salePersCode,  wrkDate,  scCode, currentFormNo , connectionObject);
				System.out.println("callOutMap ::==="+callOutMap);
			}
			else
			{
				System.out.println("callOutcome ::===["+callOutcome+"]");
			}

			////pitchDetData = getCallOutcomePitch(callOutcome, connectionObject);
			System.out.println("pitchDetData ::["+pitchDetData+"]");

			if ( wrkDate != null )
			{
				wrkDateInDbFmt = genericUtility.getValidDateString( wrkDate , getApplDateFormat() , "dd-MMM-yyyy");
			}
			System.out.println(" PITCH :: scCode = ["+scCode+"]");
			if(scCode.contains(","))
			{
				//					sdQuery = " SELECT SB.*, ITEM.DESCR FROM STRG_BRAND_PITCH SB, ITEM ITEM WHERE SB.ITEM_CODE = ITEM.ITEM_CODE " +
				//							  " AND SALES_PERS = '"+salePersCode+"' AND WORK_DATE = '"+wrkDateInDbFmt+"' AND SC_CODE IN ("+getFormattedStringBuff(scCode)+") ";

				sdQuery = " SELECT SB.* FROM STRG_BRAND_PITCH SB WHERE SB.SALES_PERS = '"+salePersCode+"' AND SB.WORK_DATE = '"+wrkDateInDbFmt+"' AND SB.SC_CODE IN ("+scCode+") ";
			}
			else
			{
				//					sdQuery = " SELECT SB.*, ITEM.DESCR FROM STRG_BRAND_PITCH SB, ITEM ITEM WHERE SB.ITEM_CODE = ITEM.ITEM_CODE AND SALES_PERS = '"+salePersCode+"' AND WORK_DATE = '"+wrkDateInDbFmt+"' AND SC_CODE='"+scCode+"' ";

				sdQuery = " SELECT SB.* FROM STRG_BRAND_PITCH SB WHERE SB.SALES_PERS = '"+salePersCode+"' AND SB.WORK_DATE = '"+wrkDateInDbFmt+"' AND SB.SC_CODE= "+scCode+"";
			}
			System.out.println(" PITCH :: SavexWizardSQL[ ---- >] "+sdQuery);
			pstmt = connectionObject.prepareStatement(sdQuery);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				//String item = checkNull(rs.getString("DESCR"));
				String brand = checkNull(rs.getString("BRAND_DESCR"));
				String brandCode = checkNull(rs.getString("BRAND_CODE"));
				String pitchDet = checkNull(rs.getString("PITCH_DETAIL"));
				String custCode = checkNull( rs.getString("SC_CODE") );
				System.out.println("custCode::::::["+custCode);
				String pitchDetDescr ="";
				String callOutExt  = "";
				if( callOutMap.get( custCode.trim() ) != null )
				{
					callOutExt = ( String ) callOutMap.get( custCode.trim() );
					System.out.println("callOutExt ::::["+callOutExt+"]");
					///pitchDetDescr = getPitchDescr(callOutExt, pitchDet);
					System.out.println(" pitchDetDescr ::::["+pitchDetDescr+"]");
				}

				//String pitchDetDescr = getPitchDescr(callOutcome, pitchDet);
				//System.out.println("item["+item+"]");
				valueXmlString.append( "<Detail"+currentFormNo+" dbID='' domID='"+ domID +"' objContext='"+currentFormNo+"' objName='"+objNameDefault+"' selected='Y' formName='"+formName+"'>\r\n" );
				//Changed By Bhushan on 06-10-16
				valueXmlString.append("<attribute pkNames='' status='O' updateFlag='E' selected='Y' />\r\n");
				//valueXmlString.append("<attribute pkNames='' status='N' updateFlag='A' selected='Y' />\r\n");

				valueXmlString.append( "<work_date><![CDATA[" ).append(wrkDate).append( "]]></work_date>\r\n" );
				valueXmlString.append( "<sales_pers><![CDATA[").append(checkNull(salePersCode)).append("]]></sales_pers>\n");
				//valueXmlString.append( "<sc_code><![CDATA[").append( checkNull( scCode ) ).append("]]></sc_code>\r\n");
				valueXmlString.append( "<sc_code><![CDATA[").append( checkNull( rs.getString("SC_CODE") ) ).append("]]></sc_code>\r\n");
				valueXmlString.append( "<strg_code><![CDATA[").append( checkNull( rs.getString("SC_CODE") ) ).append("]]></strg_code>\r\n");

				valueXmlString.append( "<brand_code><![CDATA[").append(checkNull(rs.getString("BRAND_CODE"))).append("]]></brand_code>\n");
				valueXmlString.append( "<pitch_detail><![CDATA[").append(checkNull(rs.getString("PITCH_DETAIL"))).append("]]></pitch_detail>\r\n" );
				valueXmlString.append( "<pitch_feedback><![CDATA[]]></pitch_feedback>\r\n" );
				valueXmlString.append( "<pres_pattern><![CDATA[]]></pres_pattern>\r\n" );
				valueXmlString.append( "<remarks><![CDATA[]]></remarks>\r\n" );
				valueXmlString.append( "<line_no><![CDATA["+domID+"]]></line_no>\r\n" );

				valueXmlString.append( "<pitch_sequence><![CDATA[").append(checkNull(rs.getString("PITCH_SEQUENCE"))).append("]]></pitch_sequence>\n");

				valueXmlString.append( "<item_code><![CDATA[").append(checkNull(rs.getString("ITEM_CODE"))).append("]]></item_code>\n");
				//valueXmlString.append( "<item_descr protect =\"1\"><![CDATA[").append(item).append("]]></item_descr>\n");
				valueXmlString.append( "<item_descr protect =\"1\"><![CDATA[").append("").append("]]></item_descr>\n");
				valueXmlString.append( "<brand_descr protect =\"1\"><![CDATA[").append(brand).append("]]></brand_descr>\n");
				valueXmlString.append( "<brand_type><![CDATA[]]></brand_type>\r\n" );
				valueXmlString.append( "<cur_val><![CDATA[]]></cur_val>\r\n" );
				valueXmlString.append( "<cur_nos><![CDATA[]]></cur_nos>\r\n" );
				valueXmlString.append( "<source><![CDATA[]]></source>\r\n" );
				valueXmlString.append( "<pitch_detail_data><![CDATA[" ).append( pitchDetData ).append( "]]></pitch_detail_data>\r\n" );
				//Added By Bhushan on 17-11-16
				valueXmlString.append( "<tran_id><![CDATA[" ).append( checkNull(rs.getString("TRAN_ID")) ).append( "]]></tran_id>\r\n" );
				valueXmlString.append( "<dcr_id><![CDATA[" ).append( checkNull(rs.getString("DCR_ID")) ).append( "]]></dcr_id>\r\n" );
				valueXmlString.append( "<call_outcome_data><![CDATA[" ).append(callOutcome).append( "]]></call_outcome_data>\r\n" );
				valueXmlString.append( "<call_outcome><![CDATA[" ).append(callOutExt).append( "]]></call_outcome>\r\n" );
				valueXmlString.append( "<pitch_detail_descr><![CDATA[" ).append( pitchDetDescr ).append( "]]></pitch_detail_descr>\r\n" );
				valueXmlString.append( "<sc_code_pitch><![CDATA[" ).append( checkNull( rs.getString("SC_CODE") ) ).append( "]]></sc_code_pitch>\r\n" );
				valueXmlString.append( "</Detail"+currentFormNo+">\r\n" );
				domID++;
			}
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch(Exception e)
		{
			System.out.println( "Exception :SavexWizardEJB :getExistingPitchForDoctor :" + e.getMessage() + ":" );
			//valueXmlString = valueXmlString.append( genericUtility.createErrorString( e ) );
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if (rs !=null )
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}

			}
			catch(Exception e)
			{
				System.out.println( "Exception :SavexWizardEJB :getExistingPitchForDoctor :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		return valueXmlString.toString();

	}
	public String getPitchDetails( String salePersCode, String wrkDate , String scCode, String xtraParams,String objNameDefault, String callOutcome, String currentFormNo, String formName,Connection connectionObject ) throws ITMException
	{
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		int domID = 1;
		StringBuffer valueXmlString = new StringBuffer();
		String wrkDateInDbFmt = "", pitchDetData ="", brandSql = "";
		GenericUtility genericUtility = GenericUtility.getInstance();

		try
		{

			DateFormat dtFormat = new SimpleDateFormat(getApplDateFormat());
			java.util.Date date = Calendar.getInstance().getTime();
			String currDate = dtFormat.format( date );

			if( "".equalsIgnoreCase( checkNull( salePersCode ) ) )
			{
				salePersCode = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginEmpCode" );
			}
			System.out.println("In getPitchDetails:: salePersCode : [" + salePersCode + "] scCode :[" + scCode +"] wrkDate:["+wrkDate+"]");

			if ( wrkDate != null )
			{
				wrkDateInDbFmt = genericUtility.getValidDateString( wrkDate , getApplDateFormat()  , getDBDateFormat() );
			}
			System.out.println("wrkDateInDbFmt:["+wrkDateInDbFmt+"]");
			String wrkDBDate =  genericUtility.getValidDateTimeString( wrkDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
			System.out.println("wrkDBDate:["+wrkDBDate+"]");
			int rsRowCnt = 0;
			boolean isbrandAct = false;
			boolean isbrandPrd = false;
			String brandActCnt = "SELECT COUNT(*) AS COUNT " +
					"FROM STRG_BRAND_ACT SBA, STRG_BRAND_ACT_DET SBD, BRAND BR , PERIOD PR  " +
					"WHERE SBA.TRAN_ID = SBD.TRAN_ID AND SBD.BRAND_CODE = BR.BRAND_CODE  AND SBA.PRD_CODE = PR.CODE " +
					"AND SBA.SALES_PERS = ?  AND SBD.SC_CODE = '"+scCode+"'  " +
					"AND SBA.CONFIRMED = 'Y' AND  ?  BETWEEN PR.FR_DATE AND PR.TO_DATE " +
					"ORDER BY BR.DESCRIPTION ";

			pstmt = connectionObject.prepareStatement(brandActCnt);
			pstmt.setString(1,salePersCode);
			pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( wrkDBDate ) );
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				rsRowCnt = rs.getInt(1);
				System.out.println("STRG_BRAND_ACT rsRowCnt:["+rsRowCnt+"]");
				if(rsRowCnt > 0)
				{
					isbrandAct = true;
				}
			}
			if (rs !=null )
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}

			String brandPrdCnt = "SELECT COUNT(*) AS COUNT " +
					"FROM  STRG_PRODUCT SPR , BRAND BR  WHERE SPR.BRAND_CODE = BR.BRAND_CODE " +
					"AND SPR.SALES_PERS = ? AND SPR.SC_CODE = '"+scCode+"'  " +
					"AND ?  BETWEEN SPR.VALID_FROM AND SPR.VALID_TO ORDER BY BR.DESCRIPTION ";

			pstmt = connectionObject.prepareStatement(brandPrdCnt);
			pstmt.setString(1,salePersCode);
			pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( wrkDBDate ) );
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				rsRowCnt = rs.getInt(1);
				System.out.println("STRG_PRODUCT rsRowCnt:["+rsRowCnt+"]");
				if(rsRowCnt > 0)
				{
					isbrandPrd = true;
				}
			}
			if (rs !=null )
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}

			System.out.println("isbrandAct:["+isbrandAct+"] isbrandPrd:["+isbrandPrd+"]");
			if(isbrandAct)
			{
				brandSql = "SELECT BR.BRAND_CODE, BR.DESCRIPTION , SBD.PITCH_PRIORITY " +
						"FROM STRG_BRAND_ACT SBA, STRG_BRAND_ACT_DET SBD, BRAND BR , PERIOD PR  " +
						"WHERE SBA.TRAN_ID = SBD.TRAN_ID AND SBD.BRAND_CODE = BR.BRAND_CODE  AND SBA.PRD_CODE = PR.CODE " +
						"AND SBA.SALES_PERS = ?  AND SBD.SC_CODE = '"+scCode+"'  " +
						"AND SBA.CONFIRMED = 'Y' AND  ?  BETWEEN PR.FR_DATE AND PR.TO_DATE " +
						"ORDER BY BR.DESCRIPTION ";
				pstmt = connectionObject.prepareStatement(brandSql);
				pstmt.setString(1,salePersCode);
				pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( wrkDBDate ) );
			}
			else if(isbrandPrd)
			{

				brandSql = "SELECT BR.BRAND_CODE, BR.DESCRIPTION  , SPR.PITCH_PRIORITY " +
						"FROM  STRG_PRODUCT SPR , BRAND BR  WHERE SPR.BRAND_CODE = BR.BRAND_CODE " +
						"AND SPR.SALES_PERS = ? AND SPR.SC_CODE = '"+scCode+"'  " +
						"AND  ?  BETWEEN SPR.VALID_FROM AND SPR.VALID_TO ORDER BY BR.DESCRIPTION ";

				pstmt = connectionObject.prepareStatement(brandSql);
				pstmt.setString(1,salePersCode);
				pstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( wrkDBDate ) );
			}
			else
			{
				brandSql = " SELECT BRAND.BRAND_CODE, BRAND.DESCRIPTION , BRAND.PITCH_PRIORITY " +
						" FROM BRAND BRAND, SALES_PERS SALES_PERS "+
						" WHERE SALES_PERS.ITEM_SER = BRAND.ITEM_SER AND SALES_PERS.SALES_PERS = ? ORDER BY BRAND.DESCRIPTION ";
				pstmt = connectionObject.prepareStatement(brandSql);
				pstmt.setString(1,salePersCode);
			}

			System.out.println("getPitchDetails :: brandSql::::=["+brandSql+"]");
			valueXmlString.append( "<Root>\r\n" );

			List<String> brandCodeList = new ArrayList<String>();
			List<String> pitchDetailList = new ArrayList<String>();

			System.out.println("callOutcome ::["+callOutcome+"]");
			//pitchDetData = getCallOutcomePitch(callOutcome, connectionObject);
			System.out.println("pitchDetData ::["+pitchDetData+"]");
			String brandCodeVals = "" , pitchDetailVals = "";
			String scCodeExt = "'"+scCode+"'";
			String existingBrand = getExistingPitchForDoctor( salePersCode, wrkDate, scCodeExt, objNameDefault, callOutcome, currentFormNo,formName, connectionObject );

			System.out.println("existingBrand ::["+existingBrand+"]");
			//Added By Bhushan on 28-11-16 :START
			String brandCodeExt = "", pitchSeqExt="", currDet = "",
					pitchSeq="", pitchDetDescr="", tranId ="",tranIdExt ="", tranIdBrd ="", dcrIdExt ="", dcrIdBrd ="" ;
			HashMap pitchMap = new HashMap();
			HashMap pitchMapTranId = new HashMap();
			if( existingBrand != null && existingBrand.length() > 0 )
			{
				existingBrand = "<Root>" + existingBrand + "</Root>";
				currDet = "Detail"+currentFormNo;
				System.out.println(" currDet ::::["+currDet+"]");
				NodeList itemNodeList = ( genericUtility.parseString( existingBrand ) ).getElementsByTagName(currDet);
				int nodeListLen = itemNodeList.getLength();
				for ( int i=0; i < nodeListLen ; i++ )
				{
					NodeList innerNodeList = itemNodeList.item( i ).getChildNodes();
					int innerNodeListLen = innerNodeList.getLength();
					String itemTypeSel = "";
					for ( int j = 0; j < innerNodeListLen; j++ )
					{
						Node currNode = innerNodeList.item( j );

						//System.out.println("COLUMN NAME ["+ currNode.getNodeName()+"] COLUMN VALUE["+currNode.getFirstChild()+"] ");

						if("brand_code".equals( currNode.getNodeName() ))
						{
							if(currNode.getFirstChild() != null)
							{
								brandCodeExt = currNode.getFirstChild().getNodeValue().trim();
								brandCodeList.add( brandCodeExt );
							}
						}
						else if ( "pitch_sequence".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild() != null )
							{
								pitchSeqExt = currNode.getFirstChild().getNodeValue().trim();
							}
						}
						else if ( "tran_id".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild() != null )
							{
								tranIdExt = currNode.getFirstChild().getNodeValue().trim();
							}
						}
						else if ( "dcr_id".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild() != null )
							{
								dcrIdExt = currNode.getFirstChild().getNodeValue().trim();
							}
						}

					}
					System.out.println(" brandCode["+brandCodeExt+"] pitch_sequence["+pitchSeqExt+"] dcrIdExt["+dcrIdExt+"]" );
					pitchMap.put( brandCodeExt, pitchSeqExt);
					pitchMapTranId.put( brandCodeExt, dcrIdExt);


				}
				System.out.println("existingBrand  pitchMap ::::["+pitchMap+"]");
				System.out.println("existingBrand  pitchMapTranId :::: "+pitchMapTranId);
			}
			tranId = getPitchTranId(connectionObject);
			System.out.println("PitchDetails tranId ::::["+tranId+"]");
			//Added By Bhushan on 28-11-16 :END


			rs = pstmt.executeQuery();

			while(rs.next())
			{
				//String item = checkNull(rs.getString("DESCR"));
				String brand = checkNull(rs.getString("DESCRIPTION"));
				String brandCode = checkNull( rs.getString("BRAND_CODE") );
				//String itemCode = checkNull( rs.getString("ITEM_CODE") );
				System.out.println("brandCode :: ["+brandCode+"]" + " Exist brandCodeList :: " + brandCodeList+"");
				pitchSeq="";
				pitchDetDescr="";
				tranIdBrd="";
				dcrIdBrd="";
				if ( brandCodeList.contains( brandCode ) )
				{
					int pos = brandCodeList.indexOf(brandCode);
					//System.out.println("if :: pos["+pos+"]\n");

					if( pitchMap.get( brandCode.trim() ) != null )
					{
						pitchSeq = ( String ) pitchMap.get( brandCode.trim() );
						System.out.println(" pitchSeq ::::["+pitchSeq+"]");
					}

					if( pitchMapTranId.get( brandCode.trim() ) != null )
					{
						dcrIdBrd = ( String ) pitchMapTranId.get( brandCode.trim() );
						System.out.println("existing dcrIdBrd ::::["+dcrIdBrd+"]");
					}

					valueXmlString.append("<Detail"+currentFormNo+" dbID='' domID='"+ domID +"' objContext='"+currentFormNo+"' objName='"+objNameDefault+"' selected='Y' formName='"+formName+"'>\r\n" );
					//Changed By Bhushan on 06-10-16
					valueXmlString.append("<attribute pkNames='' status='O' updateFlag='E' selected='Y' />\r\n");
					//valueXmlString.append("<attribute pkNames='' status='N' updateFlag='A' selected='Y' />\r\n");
					valueXmlString.append("<selectbox><![CDATA[").append( "true" ).append("]]></selectbox>\n");
					valueXmlString.append("<work_date><![CDATA[" ).append(wrkDate).append( "]]></work_date>\r\n" );
					valueXmlString.append("<sales_pers><![CDATA[").append(checkNull(salePersCode)).append("]]></sales_pers>\n");
					valueXmlString.append("<sc_code><![CDATA[").append( checkNull( scCode ) ).append("]]></sc_code>\r\n");
					valueXmlString.append("<strg_code><![CDATA[").append( checkNull( scCode ) ).append("]]></strg_code>\r\n");

					valueXmlString.append("<brand_code><![CDATA[").append(checkNull(rs.getString("BRAND_CODE"))).append("]]></brand_code>\n");
					//valueXmlString.append("<pitch_detail><![CDATA[").append( checkNull( pos, pitchDetailList ) ).append("]]></pitch_detail>\r\n" );
					valueXmlString.append("<pitch_detail><![CDATA[").append( "" ).append("]]></pitch_detail>\r\n" );

					valueXmlString.append("<pitch_feedback><![CDATA[]]></pitch_feedback>\r\n" );
					valueXmlString.append("<pres_pattern><![CDATA[]]></pres_pattern>\r\n" );
					valueXmlString.append("<remarks><![CDATA[]]></remarks>\r\n" );
					valueXmlString.append("<line_no><![CDATA["+domID+"]]></line_no>\r\n" );

					valueXmlString.append("<pitch_priority><![CDATA[").append(checkNull(rs.getString("PITCH_PRIORITY"))).append("]]></pitch_priority>\n");
					valueXmlString.append("<pitch_sequence><![CDATA[").append(pitchSeq).append("]]></pitch_sequence>\n");

					valueXmlString.append("<item_code><![CDATA[").append(checkNull(rs.getString("BRAND_CODE"))).append("]]></item_code>\n");
					valueXmlString.append("<item_descr><![CDATA[").append("").append("]]></item_descr>\n");
					valueXmlString.append("<brand_descr><![CDATA[").append(brand).append("]]></brand_descr>\n");
					valueXmlString.append("<brand_type><![CDATA[]]></brand_type>\r\n" );
					valueXmlString.append("<cur_val><![CDATA[]]></cur_val>\r\n" );
					valueXmlString.append("<cur_nos><![CDATA[]]></cur_nos>\r\n" );
					valueXmlString.append("<source><![CDATA[]]></source>\r\n" );
					valueXmlString.append( "<pitch_detail_data><![CDATA[" ).append( pitchDetData ).append( "]]></pitch_detail_data>\r\n" );
					//Added By Bhushan on 17-11-16
					valueXmlString.append( "<tran_id><![CDATA[" ).append( tranId ).append( "]]></tran_id>\r\n" );
					valueXmlString.append( "<dcr_id><![CDATA[" ).append( dcrIdBrd ).append( "]]></dcr_id>\r\n" );
					valueXmlString.append( "<call_outcome_data><![CDATA[" ).append(callOutcome).append( "]]></call_outcome_data>\r\n" );
					valueXmlString.append( "<call_outcome><![CDATA[" ).append(callOutcome).append( "]]></call_outcome>\r\n" );
					valueXmlString.append( "<pitch_detail_descr><![CDATA[" ).append( pitchDetDescr ).append( "]]></pitch_detail_descr>\r\n" );
					valueXmlString.append( "<sc_code_pitch><![CDATA[" ).append( scCode ).append( "]]></sc_code_pitch>\r\n" );
					valueXmlString.append("</Detail"+currentFormNo+">\r\n" );
				}
				else
				{
					int pos = brandCodeList.indexOf(brandCode);
					//System.out.println("else :: pos["+pos+"]\n");
					System.out.println("Add Brand.....");
					valueXmlString.append("<Detail"+currentFormNo+" dbID='' domID='"+ domID +"' objContext='"+currentFormNo+"' objName='"+objNameDefault+"' selected='N' formName='"+formName+"'>\r\n" );
					valueXmlString.append("<attribute pkNames='' status='N' updateFlag='A' selected='N' />\r\n" );
					valueXmlString.append("<work_date><![CDATA[" ).append(wrkDate).append( "]]></work_date>\r\n" );
					valueXmlString.append("<sales_pers><![CDATA[").append(checkNull(salePersCode)).append("]]></sales_pers>\n");
					//Commented By Bhushan on 01-12-16 For All selection issues on previous condition  in Mobile DAR
					//valueXmlString.append("<sc_code><![CDATA[").append( checkNull( scCode ) ).append("]]></sc_code>\r\n");
					valueXmlString.append("<sc_code><![CDATA[").append( scCode ).append("]]></sc_code>\r\n");
					valueXmlString.append("<strg_code><![CDATA[").append( "" ).append("]]></strg_code>\r\n");

					valueXmlString.append("<brand_code><![CDATA[").append(checkNull(rs.getString("BRAND_CODE"))).append("]]></brand_code>\n");
					valueXmlString.append("<pitch_detail><![CDATA[]]></pitch_detail>\r\n" );
					valueXmlString.append("<pitch_feedback><![CDATA[]]></pitch_feedback>\r\n" );
					valueXmlString.append("<pres_pattern><![CDATA[]]></pres_pattern>\r\n" );
					valueXmlString.append("<remarks><![CDATA[]]></remarks>\r\n" );
					valueXmlString.append("<line_no><![CDATA["+domID+"]]></line_no>\r\n" );

					valueXmlString.append("<pitch_priority><![CDATA[").append(checkNull(rs.getString("PITCH_PRIORITY"))).append("]]></pitch_priority>\n");
					valueXmlString.append("<pitch_sequence><![CDATA[").append("").append("]]></pitch_sequence>\n");

					valueXmlString.append("<item_code><![CDATA[").append(checkNull(rs.getString("BRAND_CODE"))).append("]]></item_code>\n");
					valueXmlString.append("<item_descr><![CDATA[").append("").append("]]></item_descr>\n");
					valueXmlString.append("<brand_descr><![CDATA[").append(brand).append("]]></brand_descr>\n");
					valueXmlString.append("<brand_type><![CDATA[]]></brand_type>\r\n" );
					valueXmlString.append("<cur_val><![CDATA[]]></cur_val>\r\n" );
					valueXmlString.append("<cur_nos><![CDATA[]]></cur_nos>\r\n" );
					valueXmlString.append("<source><![CDATA[]]></source>\r\n" );
					valueXmlString.append( "<pitch_detail_data><![CDATA[" ).append( pitchDetData ).append( "]]></pitch_detail_data>\r\n" );
					//Added By Bhushan on 17-11-16
					valueXmlString.append( "<tran_id><![CDATA[" ).append( tranId ).append( "]]></tran_id>\r\n" );
					valueXmlString.append( "<dcr_id><![CDATA[" ).append( "" ).append( "]]></dcr_id>\r\n" );
					valueXmlString.append( "<call_outcome_data><![CDATA[" ).append(callOutcome).append( "]]></call_outcome_data>\r\n" );
					valueXmlString.append( "<call_outcome><![CDATA[" ).append(callOutcome).append( "]]></call_outcome>\r\n" );
					valueXmlString.append( "<pitch_detail_descr><![CDATA[" ).append( "" ).append( "]]></pitch_detail_descr>\r\n" );
					valueXmlString.append( "<sc_code_pitch><![CDATA[" ).append( scCode ).append( "]]></sc_code_pitch>\r\n" );
					valueXmlString.append("</Detail"+currentFormNo+">\r\n" );
				}
				domID++;
			}
			valueXmlString.append( "</Root>\r\n" );
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch(Exception e)
		{
			System.out.println( "Exception :SavexWizardEJB :defaultDataDAR(Document,String):" + e.getMessage() + ":" );
			e.printStackTrace();
			//valueXmlString = valueXmlString.append( genericUtility.createErrorString( e ) );
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if (rs !=null )
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}

			}
			catch(Exception e)
			{
				System.out.println( "Exception :SavexWizardEJB :defaultDataDAR :==>\n"+e.getMessage());
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return valueXmlString.toString();

	}

	public String getFormattedStringBuff( String data )
	{
		StringBuffer dataString = new StringBuffer();
		try
		{
			String[] dataArr = null;

			if ( data.indexOf(",") == -1 )
			{
				dataString.append( "'"+data+"'" );
			}
			else
			{
				dataArr = data.split(",");
				for (int i=0; i < dataArr.length; i++ )
				{
					if ( i == 0 )
					{
						dataString.append( "'"+dataArr[i]+"'" );
					}
					else
					{
						dataString.append( "," );
						dataString.append( "'"+dataArr[i]+"'" );
					}
				}
			}
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
		}
		return dataString.toString();
	}
	//Method to get SampleItem
	public String getSampleItemDetails( Document dom, Document dom2 , String salePersCode, String wrkDate , String scCode, String xtraParams, Connection connectionObject ,String formNo,String formName) throws ITMException //Chnaged by sachin satre on 09-nov-16
	{
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		int domID = 1;
		int num = 0;
		StringBuffer valueXmlString = new StringBuffer();
		String wrkDateInDbFmt = "";
		String selectedItem = "";
		String dcrId="";
		String sql="";
		String userId="";
		String dcrID="";
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		boolean isLocalConn =false;
		try
		{
			if(connectionObject ==  null )
			{
				connectionObject = getConnection();
				isLocalConn =true;
			}
			DateFormat dtFormat = new SimpleDateFormat(getApplDateFormat());
			java.util.Date date = Calendar.getInstance().getTime();
			String currDate = dtFormat.format( date );
			userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );
			if( "".equalsIgnoreCase( checkNull( salePersCode ) ) )
			{
				salePersCode = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginEmpCode" );
			}


			String [] temp = scCode.split(",");
			if ( preDomExists( dom2, formNo ))
			{
				selectedItem = getPrevFormValues( dom2, formNo, new ArrayList<String>(Arrays.asList(temp)), "strg_code" ) ;
			}
			else
			{
				String newScCode = "";
				if(scCode != null && scCode.trim().length() > 0 && scCode.indexOf("'") == -1)
				{
					newScCode = "'"+scCode+"'";
				}
				else
				{
					newScCode = scCode;
				}
				selectedItem = getSampleExistingItemsDetail( salePersCode, wrkDate , newScCode,formNo ,formName,connectionObject) ; //Chnaged by sachin satre on 09-nov-16
			}
			selectedItem = "<Root>" + selectedItem + "</Root>";
			System.out.println("selectedItem>>>"+selectedItem);
			String itemDetails = getSampleSalesPersItemList(dom, salePersCode, scCode, selectedItem, wrkDate,formNo,formName );

			System.out.println("itemDetails>>>"+itemDetails);
			valueXmlString.append(itemDetails);
		}
		catch(Exception e)
		{
			System.out.println( "Exception :StrgMeetITMMobileWizEJB:getItemDetails( Document dom2 , String salePersCode, String wrkDate , String scCode, String xtraParams):" + e.getMessage() + ":" );
			e.printStackTrace();
			valueXmlString = valueXmlString.append( genericUtility.createErrorString( e ) );
		}
		finally
		{
			try
			{
				if (rs !=null )
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if (isLocalConn && connectionObject != null)
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :StrgMeetITMMobileWizEJB:getItemDetails( Document dom2 , String salePersCode, String wrkDate , String scCode, String xtraParams):" + e.getMessage() + ":" );
				System.out.println( "Exception :StrgMeetITMMobileWizEJB:defaultDataDAR :==>\n"+e.getMessage());
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		System.out.println("Return valueXmlString===>"+valueXmlString);
		return valueXmlString.toString();

	}
	//Method to get Existing item details
	public String getSampleExistingItemsDetail( String salePersCode, String eventDate , String custList ,String formNo,String formName,Connection connectionObject) throws ITMException //Chnaged by sachin satre on 09-nov-16
	{

		ResultSet rs = null;
		//Connection connectionObject = null;
		PreparedStatement pstmt = null;
		int domID=1;
		StringBuffer valueXmlString = new StringBuffer();
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		boolean isLocalConn =false;
		try
		{
			if(connectionObject ==null )
			{
				/*ConnDriver connDriver = new ConnDriver();
				connectionObject = connDriver.getConnectDB( "DriverValidator" );*/
				connectionObject = getConnection();//chnged by sachin satre on [9-nov-16] to get connection
				isLocalConn =true;
			}
			String smiQuery = "";

			String dcrID = getDCRId(connectionObject,salePersCode, eventDate);
			System.out.println("dcrID>>>"+dcrID);

			//smiQuery = "SELECT ITEM.DESCR, LINE_NO, ITEM_POB, STRG_MEET_ITEMS.ITEM_CODE,STRG_MEET_ITEMS.SALES_PROD_GRP, STRG_CODE, ITEM.ITEM_TYPE, ITEM.ITEM_USAGE, ITEM.DESCR ,STRG_MEET_ITEMS.BRIEFED, STRG_MEET_ITEMS.QUANTITY, STRG_MEET_ITEMS.BRIEFED_DESCR,SALES_PROD_GRP.DESCR AS SPG_DESCR FROM STRG_MEET_ITEMS,ITEM ITEM ,SALES_PROD_GRP SALES_PROD_GRP  WHERE (STRG_MEET_ITEMS.ITEM_CODE = ITEM.ITEM_CODE (+)) AND (STRG_MEET_ITEMS.SALES_PROD_GRP = SALES_PROD_GRP.SALES_PROD_GRP (+)) AND STRG_MEET_ITEMS.DCR_ID= '"+dcrID+"' AND STRG_MEET_ITEMS.STRG_CODE IN (" + custList + ")";
			/*smiQuery = "SELECT ITEM.DESCR, LINE_NO, ITEM_POB, STRG_MEET_ITEMS.ITEM_CODE,STRG_MEET_ITEMS.SALES_PROD_GRP, STRG_CODE, ITEM.ITEM_TYPE, ITEM.ITEM_USAGE, ITEM.DESCR ,STRG_MEET_ITEMS.BRIEFED, STRG_MEET_ITEMS.QUANTITY, STRG_MEET_ITEMS.BRIEFED_DESCR,SALES_PROD_GRP.DESCR AS SPG_DESCR, STRG_MEET_ITEMS.DCR_ID " +
						"   FROM STRG_MEET_ITEMS LEFT OUTER JOIN ITEM ITEM ON (STRG_MEET_ITEMS.ITEM_CODE = ITEM.ITEM_CODE) LEFT OUTER JOIN SALES_PROD_GRP SALES_PROD_GRP ON (STRG_MEET_ITEMS.SALES_PROD_GRP = SALES_PROD_GRP.SALES_PROD_GRP )" +
						"   WHERE STRG_MEET_ITEMS.DCR_ID= '"+dcrID+"'" +
						"   AND STRG_MEET_ITEMS.STRG_CODE IN (" + custList + ")";*/

			//Changed by Poonam Gole for fetching from strg_meet_order
			smiQuery="SELECT SMO.LINE_NO,SMO.STRG_CODE,SMO.ITEM_CODE,SMO.QUANTITY, ITEM.DESCR AS ITEMDESCR,SMO.DCR_ID "
					+" FROM STRG_MEET_ITEMS SMO, ITEM ITEM"
					+" WHERE SMO.ITEM_CODE = ITEM.ITEM_CODE "
					+" AND SMO.DCR_ID =  '"+dcrID+"' "+
					"   AND SMO.STRG_CODE IN (" + custList + ")";




			//System.out.println(" StrgMeetSQL[ ---- >] "+smiQuery);
			pstmt = connectionObject.prepareStatement(smiQuery);
			rs = pstmt.executeQuery();
			while(rs.next())
			{

				String item = checkNull(rs.getString("ITEMDESCR"));
				//String sprogrp = checkNull(rs.getString("SPG_DESCR"));
				System.out.println("item["+item+"]");

				valueXmlString.append( "<Detail"+formNo+" domID='" + domID + "' selected = 'Y' formName='"+formName+"'>\r\n" );
				valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");//Gaurav Singh on 03/06/15
				if( !item.equals("") )
				{
					valueXmlString.append("<item_descr>").append( item ).append("</item_descr>\n");

				}

				valueXmlString.append("<quantity>").append(rs.getInt("QUANTITY")).append("</quantity>\n");//Gulzar
				valueXmlString.append("<item_code><![CDATA[").append(checkNull(rs.getString("ITEM_CODE"))).append("]]></item_code>\n");
				//valueXmlString.append("<sales_prod_grp><![CDATA[").append(checkNull(rs.getString("SALES_PROD_GRP"))).append("]]></sales_prod_grp>\n");
				//valueXmlString.append("<sales_prod_grp_descr><![CDATA[").append(checkNull(rs.getString("SPG_DESCR"))).append("]]></sales_prod_grp_descr>\n");
				valueXmlString.append("<strg_code><![CDATA[").append( checkNull(rs.getString("STRG_CODE")) ).append("]]></strg_code>\r\n");
				valueXmlString.append("<line_no><![CDATA[").append( checkNull(rs.getString("LINE_NO")) ).append("]]></line_no>\r\n");
				//valueXmlString.append("<scheme_code><![CDATA[").append(checkNull(rs.getString("SCHEME_CODE"))).append("]]></scheme_code>\n");
				//valueXmlString.append("<value>").append(checkNull(rs.getString("VALUE"))).append("</value>\n");
				//valueXmlString.append( "<item_type><![CDATA[" ).append( checkNull(rs.getString("ITEM_TYPE")) ).append( "]]></item_type>\r\n" );
				//valueXmlString.append( "<briefed><![CDATA[" ).append( checkNull(rs.getString("BRIEFED"))).append( "]]></briefed>\r\n" );
				//valueXmlString.append( "<item_pob><![CDATA[" ).append( checkNull(rs.getString("ITEM_POB")) ).append( "]]></item_pob>\r\n" );
				//valueXmlString.append( "<briefed_descr><![CDATA[" ).append( checkNull(rs.getString("BRIEFED_DESCR")) ).append( "]]></briefed_descr>\r\n" );
				//valueXmlString.append("<stockist_code><![CDATA[").append(checkNull(rs.getString("STOCKIST_CODE"))).append("]]></stockist_code>\n");
				valueXmlString.append( "<dcr_id><![CDATA[" ).append(checkNull(rs.getString("DCR_ID"))).append( "]]></dcr_id>\r\n" );
				valueXmlString.append( "</Detail"+formNo+">\r\n" );
				domID++;
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch(Exception e)
		{
			System.out.println( "Exception :WsfaDSRMobileWizardEJB :defaultDataWiz(Document,String):" + e.getMessage() + ":" );
			//valueXmlString = valueXmlString.append( genericUtility.createErrorString( e ) );
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if( isLocalConn && connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :WsfaDSRMobileWizardEJB :defaultDataWiz :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		return valueXmlString.toString();
	}
	//Method to get Sample item Details
	public String getSampleSalesPersItemList(Document dom, String sprsCode, String strgCode, String selectedItem, String eventDate,String formNo,String formName ) throws ITMException
	{
		//Form 4 defaultData()
		String sql = "";
		String sql1 = "";
		StringBuffer valueXmlString = new StringBuffer();
		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		boolean isMasterPitchFound = false;
		int maxLineNo = 0;
		String custTranID = null;
		StringBuffer selectedXmlString = new StringBuffer();
		StringBuffer unselectedString = new StringBuffer();
		try
		{
			valueXmlString.append( "<Root>\r\n" );
			connectionObject = getConnection();//chnged by sachin satre on [11-nov-16] to get connection


			strgCode = checkNull(strgCode);

			sql1 =" SELECT ITEM.ITEM_CODE AS ITEM_CODE ,ITEM.DESCR AS DESCR, ITEM.SH_DESCR AS SH_DESCR FROM  ITEM ITEM, STRG_CUSTOMER SC ," +
					"PRICELIST  PM "+
					"WHERE ITEM.ITEM_CODE = PM.ITEM_CODE AND SC.STATE_CODE = PM.PRICE_LIST "+
					"AND SC.SC_CODE= ? "+
					"ORDER BY ITEM.SH_DESCR ";

			String dcrID = getDCRId(connectionObject,sprsCode, eventDate);
			System.out.println("Value of dcr id is:- -"+dcrID);
			System.out.println(" selectedItem in dom vala parametr["+selectedItem+"]");
			HashMap itemMap = new HashMap();
			HashMap qtyMap = new HashMap();


			if ( selectedItem != null && selectedItem.trim().length() > 0 )
			{
				NodeList itemNodeList = ( genericUtility.parseString( selectedItem ) ).getElementsByTagName("Detail"+formNo+"");
				int nodeListLen = itemNodeList.getLength();
				for ( int i=0; i < nodeListLen ; i++ )
				{
					NodeList innerNodeList = itemNodeList.item( i ).getChildNodes();
					int innerNodeListLen = innerNodeList.getLength();
					String itemCode = "";
					String strgCodeSel = "";
					String lineNoSel = "";
					String pitch = "";
					String qty = "";
					String val = "";
					String columnValue = "";
					String itemDescr = "";
					for ( int j = 0; j < innerNodeListLen; j++ )
					{
						Node currNode = innerNodeList.item( j );
						System.out.println("COLUMNAME ["+ currNode.getNodeName()+"] COLUMKN VALUE["+currNode.getFirstChild()+"] ");
						if ( "item_code".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild() != null)
							{
								itemCode = currNode.getFirstChild().getNodeValue().trim() ;
							}
						}
						else if ( "strg_code".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild() != null)
							{
								strgCodeSel = currNode.getFirstChild().getNodeValue().trim() ;
							}
						}
						else if ( "quantity".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild().getNodeValue() != null )
							{
								qty = currNode.getFirstChild().getNodeValue().trim();
							}
						}
						else if ( "line_no".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild() != null)
							{
								lineNoSel = currNode.getFirstChild().getNodeValue().trim() ;
							}
						}
						else if ( "item_descr".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild() != null)
							{
								itemDescr = checkNull(currNode.getFirstChild().getNodeValue());
							}
						}

					}
					System.out.println("itemCode["+itemCode+"] " );
					itemMap.put( itemCode+"~"+strgCodeSel, lineNoSel);
					qtyMap.put( itemCode+"~"+strgCodeSel, qty);
					System.out.println(" itemMap ["+itemMap+"]");
				}
			}

			if(dcrID != null)
			{
				if(dcrID.length()>0)
				{
					String checkModeSql = " SELECT MAX(LINE_NO) AS MAXLINENO FROM STRG_MEET_ORDER WHERE DCR_ID= ?  AND STRG_CODE = ?";
					pstmt = connectionObject.prepareStatement(checkModeSql);
					pstmt.setString(1,dcrID);
					pstmt.setString(2,strgCode);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						maxLineNo = rs.getInt("MAXLINENO");
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
				}
			}
			String qty = "";
			String pitch = "";
			int num = 1;
			int lineNo=1;

			double value = 0d;
			double rate = 0d;


			pstmt =  connectionObject.prepareStatement( sql1 );
			pstmt.setString(1, strgCode);//changed by poonam
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				String itemCode = checkNull(rs.getString("ITEM_CODE"));
				System.out.println("itemCode["+itemCode+"]");
				String itemDescr = checkNull(rs.getString("DESCR"));
				String itemShDescr = checkNull(rs.getString("SH_DESCR"));
				System.out.println("itemMap.get( itemCode.trim()"+itemMap.get( itemCode.trim()));
				if ( itemMap.get( itemCode+"~"+strgCode ) != null )
				{

					String data = ( String ) itemMap.get( itemCode+"~"+strgCode );
					qty = ( String ) qtyMap.get( itemCode+"~"+strgCode );
					System.out.println("itemCode inside if["+itemCode+"]");
					System.out.println("Item value from map : - "+data);
					selectedXmlString.append("<Detail"+formNo+" domID='"+num+"' selected = 'Y' formName='"+formName+"'>\r\n" );
					selectedXmlString.append( "<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");//Gaurav Singh on 03-06-15
					selectedXmlString.append("<selectbox><![CDATA[").append( "true" ).append("]]></selectbox>\n");
					selectedXmlString.append("<item_code><![CDATA[").append( rs.getString("ITEM_CODE") ).append("]]></item_code>\r\n");
					selectedXmlString.append("<tooltip_descr><![CDATA[").append(itemDescr).append("]]></tooltip_descr>\r\n");
					selectedXmlString.append("<line_no><![CDATA["+data+"]]></line_no>\r\n");
					selectedXmlString.append("<quantity><![CDATA["+qty+"]]></quantity>\r\n");
					selectedXmlString.append( "<dcr_id><![CDATA["+dcrID+"]]></dcr_id>\r\n" );
					selectedXmlString.append("<sales_pers><![CDATA[").append(sprsCode).append("]]></sales_pers>\r\n");
					selectedXmlString.append("<strg_code><![CDATA[").append( strgCode ).append("]]></strg_code>\r\n");
					selectedXmlString.append("<item_descr><![CDATA[").append(rs.getString("DESCR")).append("]]></item_descr>\r\n");
					selectedXmlString.append( "</Detail"+formNo+">\r\n" );
					num++;
				}
				else
				{
					maxLineNo = maxLineNo +1;
					unselectedString.append("<Detail"+formNo+" domID='"+maxLineNo+"' selected = 'N' formName='"+formName+"'>\r\n" );
					unselectedString.append( "<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");//Gaurav Singh on 03-06-15
					unselectedString.append("<item_code><![CDATA[").append( rs.getString("ITEM_CODE") ).append("]]></item_code>\r\n");
					unselectedString.append("<tooltip_descr><![CDATA[").append(itemDescr).append("]]></tooltip_descr>\r\n");
					unselectedString.append("<line_no><![CDATA["+maxLineNo+"]]></line_no>\r\n");
					unselectedString.append( "<dcr_id><![CDATA["+dcrID+"]]></dcr_id>\r\n" );
					unselectedString.append("<sales_pers><![CDATA[").append(sprsCode).append("]]></sales_pers>\r\n");
					//unselectedString.append("<strg_code><![CDATA[").append( strgCode ).append("]]></strg_code>\r\n");
					unselectedString.append("<strg_code><![CDATA[").append( "" ).append("]]></strg_code>\r\n");
					unselectedString.append("<quantity><![CDATA[").append( "" ).append("]]></quantity>\r\n");
					unselectedString.append("<item_descr><![CDATA[").append(rs.getString("DESCR")).append("]]></item_descr>\r\n");
					unselectedString.append( "</Detail"+formNo+">\r\n" );
				}
			}//end of while
			valueXmlString.append(selectedXmlString);
			valueXmlString.append(unselectedString);
			System.out.println("outside detail  :- "+valueXmlString);
			if(rs != null)
			{
				rs.close(); rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close(); pstmt = null;
			}
			num = 1;
		}
		catch (Exception e)
		{
			e.printStackTrace();
			System.out.println( "Exception :ITMWizardStatefulEJB :getSalesPersItemList(String):" + e.getMessage() + ":" );
			//valueXmlString = valueXmlString.append( genericUtility.createErrorString( e ) );
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if( connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :ITMWizardStatefulEJB :getSalesPersItemList(String) :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		valueXmlString.append( "</Root>\r\n" );
		System.out.println( "\n****ValueXmlString :" + valueXmlString.toString() + ":********" );
		return valueXmlString.toString();
	}
	//For DND
	public String getDNDDetails( Document dom2 , String salePersCode, String wrkDate , String scCode, String localityDescr, String xtraParams,String formNo,String formName,Connection connectionObject ) throws ITMException
	{
		ResultSet rs = null;
		//Connection connectionObject = null; commented by mrunalini sinkar
		PreparedStatement pstmt = null;
		int domID = 1;
		int num = 0;
		StringBuffer valueXmlString = new StringBuffer();
		String wrkDateInDbFmt = "";
		String selectedItem = "";
		String dcrId="";
		String sql="";
		//String userId="";
		String dcrID="";
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		try
		{
			//ConnDriver connDriver = new ConnDriver();
			//connectionObject = connDriver.getConnectDB( "DriverValidator" );
			DateFormat dtFormat = new SimpleDateFormat(getApplDateFormat());
			java.util.Date date = Calendar.getInstance().getTime();
			String currDate = dtFormat.format( date );
			//userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );
			String loginEmpcode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");
			if( "".equalsIgnoreCase( checkNull( salePersCode ) ) )
			{
				salePersCode = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginEmpCode" );
			}

			String [] temp = scCode.split(",");
			if ( preDomExists( dom2, formNo ))
			{
				selectedItem = getPrevFormValues( dom2, formNo, new ArrayList<String>(Arrays.asList(temp)), "strg_code" ) ;
			}
			else
			{
				String newScCode = "";
				if(scCode != null && scCode.trim().length() > 0 && scCode.indexOf("'") == -1)
				{
					newScCode = "'"+scCode+"'";
				}
				else
				{
					newScCode = scCode;
				}
				//added by mrunalini sinkar to pass connection on 05-june-2018(start)
				//selectedItem = getDNDDetailList( salePersCode, wrkDate , newScCode, scCode, formNo,formName ) ;
				selectedItem = getDNDDetailList( salePersCode, wrkDate , newScCode, scCode, formNo,formName,connectionObject ) ;
				//added by mrunalini sinkar to pass connection on 05-june-2018(end)
			}
			//selectedItem = "<Root>" + selectedItem + "</Root>";
			//String itemDetails = getDNDItemList( salePersCode, scCode, selectedItem, wrkDate, localityDescr );
			//valueXmlString.append(itemDetails);
			valueXmlString.append(selectedItem);
		}
		catch(Exception e)
		{
			System.out.println( "Exception :getDNDDetails( Document dom2 , String salePersCode, String wrkDate , String scCode, String xtraParams):" + e.getMessage() + ":" );
			e.printStackTrace();
			//valueXmlString = valueXmlString.append( genericUtility.createErrorString( e ) );
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if (rs !=null )
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if (connectionObject != null)
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :getDNDDetails( Document dom2 , String salePersCode, String wrkDate , String scCode, String xtraParams):" + e.getMessage() + ":" );
				System.out.println( "Exception :getDNDDetails :==>\n"+e.getMessage());
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		System.out.println("Return valueXmlString===>"+valueXmlString);
		return valueXmlString.toString();

	}
	private String getDNDDetailList( String salePersCode, String eventDate, String custList, String scCode, String formNo,String formName,Connection connectionObject) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		//PreparedStatement pstmtParm = null;
		//ResultSet rsParm = null;
		//Connection connectionObject = null;
		int domID=0;
		//String parmVal = "";
		StringBuffer valueXmlString = new StringBuffer();

		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		try
		{
			//commentd by mrunalini sinkar on 05-june-2018(start)
			//ConnDriver connDriver = new ConnDriver();
			//connectionObject = connDriver.getConnectDB( "DriverValidator" );
			//commentd by mrunalini sinkar on 05-june-2018(end)
			valueXmlString.append( "<Root>\r\n" );

			String smiQuery = "";

			String dcrID = getDCRId(connectionObject,salePersCode, eventDate);

			/*String dndParmSql = " SELECT PARM_VALUE FROM SFAPARM WHERE PARM_NAME = 'STRG_ITEM_DISPLAY' ";
				pstmtParm = connectionObject.prepareStatement(dndParmSql);
				rsParm = pstmtParm.executeQuery();
				while(rsParm.next())
				{
					parmVal = rsParm.getString("PARM_VALUE");
				}
				System.out.println(" parmVal ["+parmVal+"]");*/

			if (custList == null || custList.trim().length() == 0)
			{
				smiQuery = " SELECT DCR_ID, LINE_NO, STRG_CODE, DOC_ID, DOC_ID_1, DISPLAY_AREA FROM STRG_ITEM_DISPLAY " +
						" WHERE DCR_ID = '"+dcrID+"' ";
			}
			else
			{
				smiQuery = " SELECT DCR_ID, LINE_NO, STRG_CODE, DOC_ID, DOC_ID_1, DISPLAY_AREA FROM STRG_ITEM_DISPLAY " +
						" WHERE DCR_ID = '"+dcrID+"'" + " AND STRG_CODE IN (" + custList + ")";
			}

			//if ( parmVal != null || parmVal.trim().length() > 0)
			//{
			pstmt = connectionObject.prepareStatement(smiQuery);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				domID++;
				valueXmlString.append("<Detail"+formNo+" domID='" + domID + "' selected = 'Y' formName='"+formName+"'>\r\n" );
				valueXmlString.append("<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");
				valueXmlString.append("<selectbox><![CDATA[").append( "true" ).append("]]></selectbox>\n");
				valueXmlString.append("<dcr_id><![CDATA[" ).append(checkNull(rs.getString("DCR_ID"))).append( "]]></dcr_id>\r\n" );
				valueXmlString.append("<line_no><![CDATA[").append(checkNull(rs.getString("LINE_NO"))).append("]]></line_no>\r\n");
				valueXmlString.append("<strg_code><![CDATA[").append(checkNull(rs.getString("STRG_CODE"))).append("]]></strg_code>\n");
				valueXmlString.append("<doc_id><![CDATA[").append(checkNull(rs.getString("DOC_ID"))).append("]]></doc_id>\n");
				valueXmlString.append("<doc_id_1><![CDATA[").append(checkNull(rs.getString("DOC_ID_1"))).append("]]></doc_id_1>\n");
				valueXmlString.append("<display_area><![CDATA[").append( checkNull(rs.getString("DISPLAY_AREA")) ).append("]]></display_area>\r\n");
				//valueXmlString.append("<display_area_no><![CDATA[" ).append( checkNull(rs.getString("DISPLAY_AREA_NO")) ).append( "]]></display_area_no>\r\n" );
				valueXmlString.append("</Detail"+formNo+">\r\n" );
			}
			else
			{
				domID++;
				valueXmlString.append("<Detail"+formNo+" domID='" + domID + "' selected = 'N' formName='"+formName+"'>\r\n" );
				valueXmlString.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");
				valueXmlString.append("<dcr_id><![CDATA[" ).append(dcrID).append( "]]></dcr_id>\r\n" );
				valueXmlString.append("<line_no><![CDATA[").append(domID).append("]]></line_no>\r\n");
				valueXmlString.append("<strg_code><![CDATA[").append(scCode).append("]]></strg_code>\n");
				valueXmlString.append("<doc_id><![CDATA[").append("").append("]]></doc_id>\n");
				valueXmlString.append("<doc_id_1><![CDATA[").append("").append("]]></doc_id_1>\n");
				valueXmlString.append("<display_area><![CDATA[").append( "" ).append("]]></display_area>\r\n");
				valueXmlString.append("</Detail"+formNo+">\r\n" );
			}
			/*for (int displayLine = domID ; displayLine < Integer.parseInt(parmVal) ; displayLine++)
					{
						domID++;
						valueXmlString.append("<Detail"+formNo+" domID='" + domID + "' selected = 'N'>\r\n" );
						valueXmlString.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");
						valueXmlString.append("<dcr_id><![CDATA[" ).append(dcrID).append( "]]></dcr_id>\r\n" );
						valueXmlString.append("<line_no><![CDATA[").append(domID).append("]]></line_no>\r\n");
						valueXmlString.append("<strg_code><![CDATA[").append(scCode).append("]]></strg_code>\n");
						valueXmlString.append("<doc_id><![CDATA[").append("").append("]]></doc_id>\n");
						valueXmlString.append("<display_area><![CDATA[").append( "" ).append("]]></display_area>\r\n");
						//valueXmlString.append("<display_area_no><![CDATA[" ).append( "" ).append( "]]></display_area_no>\r\n" );
						valueXmlString.append("</Detail"+formNo+">\r\n" );
					}*/

			//}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch(Exception e)
		{
			System.out.println( "Exception :StrgMeetOTCGwtWizardComp : getExistingDNDDetail(Document,String):" + e.getMessage() + ":" );
			//valueXmlString = valueXmlString.append( genericUtility.createErrorString( e ) );
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if( connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :StrgMeetOTCGwtWizardComp :getExistingDNDDetail :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		valueXmlString.append( "</Root>\r\n" );
		System.out.println( "\n****ValueXmlString :" + valueXmlString.toString() + ":********" );
		return valueXmlString.toString();
	}
	public String getExistingDndDetailDisplay( String spCode, String eventDate, Connection connectionObject,String formNo,String formName ) throws ITMException
	{
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		int domID=1;
		String sampleQuery="";
		StringBuffer valueXmlString = new StringBuffer();

		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		boolean isLocalConn = false;
		try
		{
			if(connectionObject == null)
			{
				ConnDriver connDriver = new ConnDriver();
				connectionObject = connDriver.getConnectDB("Driver");
				connDriver = null;
				isLocalConn = true;
			}

			String dcrID = getDCRIdList(connectionObject, spCode, eventDate);
			System.out.println(" dcrID :: ["+dcrID+"]");
			if ( dcrID != null && dcrID.trim().length() > 0 )
			{
				dcrID = "'" + dcrID.replaceAll(",", "','") + "'";
			}
			else
			{
				dcrID = "''";
			}
			//Added by Gaurav Singh on 05-MAY-2015[Start]
			if ( eventDate != null )
			{
				eventDate = genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ;
			}
			//Added by Gaurav Singh on 05-MAY-2015[End]

			sampleQuery = " SELECT DCR_ID, LINE_NO, STRG_CODE, DOC_ID, DOC_ID_1, DISPLAY_AREA FROM STRG_ITEM_DISPLAY " +
					" WHERE DCR_ID IN ("+dcrID+")";

			pstmt = connectionObject.prepareStatement(sampleQuery);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				valueXmlString.append("<Detail"+formNo+" domID='" + domID + "' selected = 'Y' formName='"+formName+"'>\r\n" );
				valueXmlString.append("<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");
				valueXmlString.append("<dcr_id><![CDATA[" ).append(checkNull(rs.getString("DCR_ID"))).append( "]]></dcr_id>\r\n" );
				valueXmlString.append("<line_no><![CDATA[").append(checkNull(rs.getString("LINE_NO"))).append("]]></line_no>\r\n");
				valueXmlString.append("<strg_code><![CDATA[").append(checkNull(rs.getString("STRG_CODE"))).append("]]></strg_code>\n");
				valueXmlString.append("<doc_id><![CDATA[").append(checkNull(rs.getString("DOC_ID"))).append("]]></doc_id>\n");
				valueXmlString.append("<doc_id_1><![CDATA[").append(checkNull(rs.getString("DOC_ID_1"))).append("]]></doc_id_1>\n");
				valueXmlString.append("<display_area><![CDATA[").append( checkNull(rs.getString("DISPLAY_AREA")) ).append("]]></display_area>\r\n");
				//valueXmlString.append("<display_area_no><![CDATA[" ).append( checkNull(rs.getString("DISPLAY_AREA_NO")) ).append( "]]></display_area_no>\r\n" );
				valueXmlString.append("</Detail"+formNo+">\r\n" );
				domID++;
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch(Exception e)
		{
			System.out.println( "Exception :StrgMeetOTCGwtWizardComp :getExistingDndDetailDisplay :" + e.getMessage() + ":" );
			//valueXmlString = valueXmlString.append( genericUtility.createErrorString( e ) );
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if( isLocalConn && connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
				}
				connectionObject = null;
			}
			catch(Exception e)
			{
				System.out.println( "Exception :StrgMeetOTCGwtWizardComp :defaultDataWiz :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		return valueXmlString.toString();
	}
	public String getDCRIdList(Connection conn, String spCode, String dcrDate) throws Exception
	{
		String dcrID = "";
		ArrayList dcrIdList = new  ArrayList();
		PreparedStatement pstmtDCRID = null;
		ResultSet rsDCRID = null;
		try
		{
			String activityCode = "";
			E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
			//Added by Gaurav Singh on 04-Dec-2015 [Start]
			/*if ( spCode != null && spCode.trim().length() > 0 )
				{
					spCode = "'" + spCode.replaceAll(",", "','") + "'";
				}*/
			/*else
				{
					spCode = "'" + sprsCode + "'";
				}*/
			//Added by Gaurav Singh on 04-Dec-2015 [End]
			System.out.println("spCode >>>>>>>>>>>>>> [" + spCode + "]");

			if(spCode != null && spCode.trim().length() > 0 && !spCode.startsWith("'"))
			{
				spCode = "'"+spCode+"'";
			}

			dcrDate = genericUtility.getValidDateTimeString( dcrDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );

			String dcrSql = "SELECT DCR_ID FROM SPRS_ACT_TRAN A, FIELDACTIVITY B WHERE A.ACTIVITY_CODE = B.ACTIVITY_CODE AND A.EVENT_DATE = ? AND A.SALES_PERS IN ("+ spCode +") AND B.ACTIVITY_TYPE ='PR'" ;

			pstmtDCRID = conn.prepareStatement( dcrSql );
			pstmtDCRID.setTimestamp(1, java.sql.Timestamp.valueOf(dcrDate));
			//pstmtDCRID.setString(2, salesPers);
			rsDCRID = pstmtDCRID.executeQuery();
			while( rsDCRID.next() )
			{
				dcrID = (rsDCRID.getString("DCR_ID") == null )?"":rsDCRID.getString("DCR_ID");
				dcrIdList.add(dcrID);
			}
			dcrID = dcrIdList.toString();
			dcrID = dcrID.replace("[", "");
			dcrID = dcrID.replace("]", "");
			dcrID = dcrID.replace(" ", "");

		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rsDCRID != null)
				{
					rsDCRID.close();
					rsDCRID = null;
				}
				if(pstmtDCRID !=null)
				{
					pstmtDCRID.close();
					pstmtDCRID = null;
				}
			}
			catch(Exception e1){}
		}
		System.out.println("dcrID =["+dcrID+"]");
		return dcrID;
	}

	public boolean isEmptyDOM(Document dom,String currentForm)
	{
		System.out.println("isEmptyDOM is called.........");
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		int ctr = 0;
		int noOfChilds = 0;
		int parentListLength = 0;
		boolean flg = true;
		try
		{
			parentList = dom.getElementsByTagName("Detail" + currentForm);
			parentListLength = parentList.getLength();
			if( parentListLength == 1 )
			{
				for (int prntCtr = 0; prntCtr < parentList.getLength(); prntCtr++ )
				{
					parentNode = parentList.item(prntCtr);
					System.out.println("parentList ........."+parentList.getLength());
					childList = parentNode.getChildNodes();
					noOfChilds = childList.getLength();
					System.out.println("noOfChilds ........."+noOfChilds);

					for(ctr = 0; ctr < noOfChilds; ctr++)
					{
						childNode = childList.item(ctr);
						if(childNode.getFirstChild() != null)
						{
							flg=false;
							break;
						}
					}
					if(!flg)
					{
						break;
					}
				}
			}
			else if( parentListLength > 1 )
			{
				flg=false;
			}
		}
		catch(Exception e)
		{
			System.err.println("Exception :isEmptyDOM :\n"+e.getMessage());
			e.printStackTrace();
		}
		return flg;
	}
	public String getObjNameFromDom( Document dom, String attribute , int currFormNo) throws ITMException
	{
		String objName = "";
		try
		{
			NodeList detailList = null;
			Node currDetail = null,reqDetail = null;
			int	detailListLength = 0;

			detailList = dom.getElementsByTagName("Detail" + currFormNo);
			detailListLength = detailList.getLength();
			for (int ctr = 0;ctr < detailListLength;ctr++)
			{
				currDetail = detailList.item(ctr);
				objName = currDetail.getAttributes().getNamedItem(attribute).getNodeValue();
				break;

			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		return objName;
	}
	public String getFormNo(String objName, String formName, Connection connectionObject) throws ITMException
	{
		PreparedStatement pStmt = null;
		ResultSet rs = null;
		String formNo = "";
		try
		{
			String winName = checkNull("w_"+objName);
			formName = checkNull(formName);
			System.out.println("winName =["+winName+"], formName=["+formName+"]");
			String sql = "SELECT FORM_NO FROM OBJ_FORMS WHERE WIN_NAME = ? AND FORM_NAME = ? ";
			pStmt = connectionObject.prepareStatement(sql);
			pStmt.setString(1, winName);
			pStmt.setString(2, formName);
			rs = pStmt.executeQuery();
			if( rs.next() )
			{
				formNo = checkNull(rs.getString("FORM_NO"));
			}
			if( rs !=null )
			{
				rs.close();
				rs = null;
			}
			if( pStmt !=null )
			{
				pStmt.close();
				pStmt = null;
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if( rs !=null )
				{
					rs.close();
					rs = null;
				}
				if( pStmt !=null )
				{
					pStmt.close();
					pStmt = null;
				}

			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		System.out.println("formNo =["+formNo+"]");
		return formNo;
	}

	public HashMap getSubForms(String formNo, String objName, Connection conn) throws ITMException
	{
		PreparedStatement pStmt = null;
		PreparedStatement pStmtInner = null;
		ResultSet rs = null;
		ResultSet rsInner = null;
		String formType = "";
		HashMap<String, String> SubFormMap = new HashMap<String,String>();
		try
		{
			String winName = "w_"+objName;
			String sql = "SELECT FORM_NO,FORM_TYPE FROM OBJ_FORMS WHERE WIN_NAME = ? AND FORM_NO = ?";
			pStmt = conn.prepareStatement(sql);
			pStmt.setString(1, winName);
			pStmt.setString(2, formNo);
			rs = pStmt.executeQuery();
			if( rs.next() )
			{
				formType = checkNull(rs.getString("FORM_TYPE"));
			}
			if( rs !=null )
			{
				rs.close();
				rs = null;
			}
			if( pStmt !=null )
			{
				pStmt.close();
				pStmt = null;
			}
			String[] nextArr = formType.split(":",3);
			String  nextForm= nextArr[2];
			//System.out.println("nextForm val is :-"+nextForm);
			int nextFormNo = 0;
			int currFormNo = 0;
			if( nextForm != null && nextForm.trim().length() > 0 )
			{
				nextFormNo = Integer.parseInt( nextForm );
			}
			if( formNo != null && formNo.trim().length() > 0 )
			{
				currFormNo = Integer.parseInt( formNo );
			}
			String formNameSql = "SELECT FORM_NO,FORM_NAME FROM OBJ_FORMS WHERE WIN_NAME = ? AND FORM_NO = ? ";
			pStmtInner = conn.prepareStatement(formNameSql);

			for(int i = (currFormNo+1) ; i< nextFormNo; i++)
			{
				pStmtInner.setString(1, winName);
				pStmtInner.setInt(2, i);

				rsInner = pStmtInner.executeQuery();

				if(rsInner.next())
				{
					String _formNo = checkNull(rsInner.getString("FORM_NO"));
					String _formName = checkNull(rsInner.getString("FORM_NAME"));
					SubFormMap.put( _formName,_formNo);
				}
				pStmtInner.clearParameters();
				if( rsInner !=null )
				{
					rsInner.close();
					rsInner = null;
				}
			}

		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if( rs !=null )
				{
					rs.close();
					rs = null;
				}
				if( pStmt !=null )
				{
					pStmt.close();
					pStmt = null;
				}
				if( pStmtInner !=null )
				{
					pStmtInner.close();
					pStmtInner = null;
				}

			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return SubFormMap;
	}
	public String getParentformNo(String subFormNo, String objName, Connection conn) throws ITMException
	{
		PreparedStatement pStmt = null;
		ResultSet rs = null;
		int subFormNum = 0;
		String formNumber = "";
		String formType = "";
		boolean isMainForm = false;
		//System.out.println("subFormNosubFormNo"+subFormNo+"objName"+objName);
		try
		{
			String winName = "w_"+objName;
			if(conn == null)
			{
				conn = getConnection();
			}
			if( subFormNo != null && subFormNo.trim().length() > 0 )
			{
				subFormNum = Integer.parseInt( subFormNo );
			}
			String sql  = "SELECT FORM_NO,FORM_TYPE FROM OBJ_FORMS WHERE WIN_NAME = ? AND TO_NUMBER(FORM_NO) = ? ";
			pStmt = conn.prepareStatement(sql);

			for(int j = subFormNum; j>=1; j--)
			{
				pStmt.setString(1, winName);
				pStmt.setString(2, ""+j);

				rs = pStmt.executeQuery();
				if(rs.next())
				{
					formNumber = checkNull(rs.getString("FORM_NO"));
					formType = checkNull(rs.getString("FORM_TYPE"));
					//System.out.println("Value for sub form["+j+"] is [formtype ["+formType+"] form no is ["+formNumber+"]");
					if(formType.indexOf("MP")>=0)
					{
						isMainForm = true;
					}
				}
				pStmt.clearParameters();
				if( rs !=null )
				{
					rs.close();
					rs = null;
				}
				if(isMainForm)
				{
					break;
				}
			}
			if( rs !=null )
			{
				rs.close();
				rs = null;
			}

		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if( rs !=null )
				{
					rs.close();
					rs = null;
				}
				if( pStmt !=null )
				{
					pStmt.close();
					pStmt = null;
				}

			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		//System.out.println("formNumaver val:- "+formNumber);
		return formNumber;
	}
	public String getPitchTranId(Connection conn)throws ITMException
	{
		String tranId ="";
		PreparedStatement pstmtNextSeq = null;
		ResultSet rsNextSeq = null;
		try
		{
			String nextSeq = "";
			String tempScCode = "0000000000";
			String getNextSeqSql = "SELECT SEQ_TRAN_ID.NEXTVAL AS NEXT_SEQ FROM DUAL";
			pstmtNextSeq = conn.prepareStatement(getNextSeqSql);
			rsNextSeq = pstmtNextSeq.executeQuery();
			if(rsNextSeq.next())
			{
				nextSeq = rsNextSeq.getString("NEXT_SEQ");
			}
			tempScCode = tempScCode + nextSeq;
			tranId = tempScCode.substring(tempScCode.length()-10);
		}
		catch(Exception e)
		{
			System.out.println("Exception getPitchTranId()::: "+ e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rsNextSeq != null)
				{
					rsNextSeq.close();
					rsNextSeq = null;
				}
				if (pstmtNextSeq != null)
				{
					pstmtNextSeq.close();
					pstmtNextSeq = null;
				}

			}
			catch(Exception e)
			{
				System.out.println("Exception getPitchTranId() "+ e.getMessage());
			}
		}
		return tranId;
	}
	private String getSplDescr(String strgCode,String sprsCode,Connection connectionObject) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		PreparedStatement pstmt1 = null;
		ResultSet rs1 = null;

		String splCode = "";
		String spclDescr = "";
		try
		{

			String sql  = "SELECT SPL_CODE FROM STRG_SERIES WHERE SC_CODE  = ? AND SALES_PERS = ?";
			pstmt = connectionObject.prepareStatement(sql);
			pstmt.setString(1, strgCode);
			pstmt.setString(2, sprsCode);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				splCode = checkNull(rs.getString("SPL_CODE"));
			}
			System.out.println("splCode splCode val:- "+splCode);
			if( rs !=null )
			{
				rs.close();
				rs = null;
			}
			if( pstmt !=null )
			{
				pstmt.close();
				pstmt = null;
			}

			if (splCode.length() > 0)
			{
				String sql1  = "SELECT DESCR FROM SPECIALITY WHERE SPL_CODE = ?";
				pstmt1 = connectionObject.prepareStatement(sql1);
				pstmt1.setString(1, splCode);
				rs1 = pstmt1.executeQuery();
				if(rs1.next())
				{
					spclDescr = checkNull(rs1.getString("DESCR"));
				}
				System.out.println("spclDescr spclDescr val:- "+spclDescr);
				if( rs1 !=null )
				{
					rs1.close();
					rs1 = null;
				}
				if( pstmt1 !=null )
				{
					pstmt1.close();
					pstmt1 = null;
				}
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if( rs !=null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt !=null )
				{
					pstmt.close();
					pstmt = null;
				}
				if( rs1 !=null )
				{
					rs1.close();
					rs1 = null;
				}
				if( pstmt1 !=null )
				{
					pstmt1.close();
					pstmt1 = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		System.out.println("spclDescr val:- "+spclDescr);
		return spclDescr;
	}
	public String geteventTime()
	{
		Date date = new Date();
		String strDateFormat = "hh:mm a";
		DateFormat dateFormat = new SimpleDateFormat(strDateFormat);
		String formattedDate= dateFormat.format(date);
		System.out.println("Current time of the day using Date - 12 hour format: " + formattedDate);
		return formattedDate;
	}
	//added by rupali on 08/03/18 for passing price_list [start]
	private double getLandingRate(String strgCode, String itemCode, String workDate, String sprsCode, String priceList,Connection connectionObject) throws Exception
	{
		System.out.println("Inside getLandingRate()::::::" );
		double rate = 0d;
		String sql = "";
		String stateCode = "";
		PreparedStatement pStmt = null;
		ResultSet rs = null;
		String listType = "";
		String lsUnit = "";
		String lsRefNo = "";
		Double mQty = 1d;
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		try
		{
			System.out.println("strgCode:::>>>>[" + strgCode +"]" );

			System.out.println("stateCode:::>>>>[" + stateCode +"]");
			DistCommon distComn = new DistCommon();
			sql = " select list_type from pricelist_mst where price_list = ? ";
			pStmt = connectionObject.prepareStatement(sql);
			pStmt.setString(1, priceList);
			rs = pStmt.executeQuery();
			if (rs.next())
			{
				listType = rs.getString("list_type");
			}
			rs.close();
			rs = null;
			pStmt.close();
			pStmt = null;
			System.out.println("List Type:-[" + listType + "]");

			sql = "select unit  from item where item_code = ?";
			pStmt = connectionObject.prepareStatement(sql);
			pStmt.setString(1, itemCode);
			rs = pStmt.executeQuery();
			if (rs.next()) {
				lsUnit = rs.getString("unit");
			}
			rs.close();
			rs = null;
			pStmt.close();
			pStmt = null;

			sql = "select max(ref_no) from pricelist where price_list  =? and item_code= ? and unit=? and list_type= ?"
					+ " and eff_from<=? and valid_upto>=? and min_qty<=? and max_qty>=? and (ref_no is not null)";
			pStmt = connectionObject.prepareStatement(sql);
			pStmt.setString(1, priceList);
			pStmt.setString(2, itemCode);
			pStmt.setString(3, lsUnit);
			pStmt.setString(4, listType);
			pStmt.setTimestamp(5, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString( workDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat())));
			pStmt.setTimestamp(6, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString( workDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat())));
			pStmt.setDouble(7, mQty);
			pStmt.setDouble(8, mQty);
			rs = pStmt.executeQuery();
			if (rs.next())
			{
				lsRefNo = checkNull(rs.getString(1));
			}
			System.out.println("inside getLandingRate lsRefNo is"+lsRefNo);
			rate = distComn.pickRateRefnoWise(priceList,workDate, itemCode, lsRefNo, listType,mQty, connectionObject);
			System.out.println("getLandingRate_RATE::>>>>["+itemCode+"] [" + rate +"]");
		}
		catch (Exception e)
		{
			e.printStackTrace();
			System.out.println( "Exception :getLandingRate(String):" + e.getMessage() + ":" );
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if( rs != null )
				{
					rs.close();
					rs = null;
				}

				if(pStmt != null )
				{
					pStmt.close();
					pStmt = null;
				}

			}
			catch(Exception e)
			{
				System.out.println( "Exception getLandingRate(String) :==>\n"+e.getMessage());
			}
		}

		return rate;
	}
	//added by rupali on 08/03/18 for passing price_list [end]
	//added by mrunalini sinkar to provide multiple locality selection on 17-nov-2018(start)

	public String getLocalityVisitHours(String strgCode,String salesPers,Connection conn) throws ITMException
	{
		String localityCode="";
		ResultSet rs=null;
		PreparedStatement pstmt=null;
		try
		{
			E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

			Date date= new Date();
			SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
			String time = sdf.format(date);
			System.out.println("det is:"+time);

			String query ="SELECT LOCALITY_CODE FROM STRG_VISIT_HOURS WHERE SC_CODE='"+strgCode+"' "+
					 "AND LOCALITY_CODE IN(SELECT LOCALITY_CODE FROM SPRS_ROUTE WHERE SPRS_CODE IN(SELECT EMP_CODE FROM ORG_STRUCTURE START WITH EMP_CODE = '"+salesPers+"' CONNECT BY PRIOR POS_CODE = POS_CODE__REPTO AND " +
					 " POS_CODE__REPTO IS NOT NULL  AND ACTIVE = 'Y' AND SYSDATE BETWEEN EFF_DATE AND VALID_UPTO) AND STATUS='Y') " +
						"AND '"+time+"' BETWEEN TO_CHAR(FROM_TIME,'HH24:MI:SS') AND TO_CHAR(TO_TIME,'HH24:MI:SS')  " ;
				pstmt=conn.prepareStatement(query);
				rs=pstmt.executeQuery();
				if(rs.next())
				{

					localityCode=checkNull(rs.getString("LOCALITY_CODE"));
				}
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}


		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}

		}
		return localityCode;
	}

	//added by mrunalini sinkar to provide multiple locality selection on 17-nov-2018(end)

}
