package ibase.webitm.ejb.wsfa.transactions;

import ibase.ejb.E12SMSComp;
import ibase.scheduler.utility.interfaces.Schedule;
import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.EMail;
import ibase.utility.UserInfoBean;
import ibase.webitm.bean.wsfa.DARCommonBean;
import ibase.webitm.notification.ejb.PublishPushNotificationEJB;
import ibase.webitm.notification.ejb.PublishPushNotificationRemote;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TransIDGenerator;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;

import javax.naming.InitialContext;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * Author : Nilesh Gunjal 
 * Date : 25-Sep-17
 * Provision for Auto scheduler notification.
 * */
public class SprsSampPlanSchedule implements Schedule
{
	String scheduleParamXML = "";
	public String schedule(HashMap map) throws Exception
    {
	 	System.out.println(schedule((String) map.get("PROCESS_NAME")));
	 	return schedule((String) map.get("PROCESS_NAME"));
    }

    public String schedule(String schedule) throws Exception
    {
    	System.out.println("^^^^^^^INSERTING INTO SprsSampPlanSchedule ^^^^^^^"+schedule);
    	this.scheduleParamXML = schedule;
    	this.createSchedule();
    	return schedule;
    }

    public String schedulePriority(String arg0) throws Exception
    {
    	return null;
    }
    private void createSchedule() throws Exception
    {
		Connection connection = null;
		boolean isError = false;
		Document dom = null;
		NodeList nodeList = null;
		
		try
		{
			DARCommonBean dARCommonBean=new DARCommonBean();
			E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
			HashMap< String, String> hashMap = new  HashMap<String, String>();
			genericUtility = new E12GenericUtility();
			// Used to get the formal parameter which we set in BaseApplication.xml 
			
			System.out.println("scheduleParamXML ::"+scheduleParamXML);
			dom = genericUtility.parseString(scheduleParamXML);
			nodeList = dom.getElementsByTagName("ACTUALPARAMETER");
			System.out.println("nodeList.getLength() ::"+nodeList.getLength());
			UserInfoBean userInfo = new UserInfoBean(scheduleParamXML);
			String loginCode = userInfo.getLoginCode();
			
			System.out.println("loginCode =["+loginCode+"]");
			String NOTIFY_BEFORE_LASTDATE = "";
			String DIVISION_CODE = "";
			String NOTIFY_WEEK_DAY = "";
			String NOTIFY_IN_ADVANCE_DAYS = "";
			String applDateFormat = "dd-MMM-yy";
			String submitdate_Dis="";
			String startdate_Dis="";
			String empType="";
			boolean notifyLastDate=false;
			boolean divisionCodeBoolean=false;
			PreparedStatement pstmt = null;
			ResultSet rs = null;
			PreparedStatement pstmt1 = null;
			ResultSet rs1 = null;
			PreparedStatement pstmt2 = null;
			String sql = "";
			String transDB="";
			AppConnectParm appConnectParm = null;
			InitialContext context = null;
			//commented by mrunalini sinkar for lookup changes on 21-aug-2018 - (start)
			//PublishPushNotificationRemote notificationRemote = null;
			PublishPushNotificationEJB notificationRemote = null;
			//commented by mrunalini sinkar for lookup changes on 21-aug-2018 - (end)
			appConnectParm = new AppConnectParm();
			context = new InitialContext(appConnectParm.getProperty());
			//commented by mrunalini sinkar for lookup changes on 21-aug-2018 - (start)
			//notificationRemote = (PublishPushNotificationRemote) context.lookup("ibase/PublishPushNotificationEJB/remote");
			notificationRemote = new PublishPushNotificationEJB();
			//commented by mrunalini sinkar for lookup changes on 21-aug-2018 - (end)
		
			//Added by mrunalini sinkar to remove hard code driver(start)
			//connection = connDriver.getConnectDB("Driver");
			if( userInfo != null && userInfo.getTransDB() != null )
			{
				transDB = E12GenericUtility.checkNull( userInfo.getTransDB() );
				System.out.println("transDB is:"+transDB);
				ConnDriver connDriver = new ConnDriver();
				connection = connDriver.getConnectDB(transDB);	
			}
			//Added by mrunalini sinkar to remove hard code driver(end)
	
			for(int i = 0 ; i < nodeList.getLength(); i ++)
			{
				Node childNode = nodeList.item(i);
				if( childNode.getNodeType() != Node.ELEMENT_NODE )
				{
					continue;
				}
				if(childNode !=null)
				{
					System.out.println("childNode=["+childNode+"]");
					notifyLastDate = getAttributeVal(childNode,"NOTIFY_DAYS");
					//divisionCodeBoolean = getAttributeVal(childNode,"DIVISION_CODE");
					System.out.println("notifyLastDate======="+notifyLastDate);
					System.out.println("divisionCodeBoolean======="+divisionCodeBoolean);
					
					if(notifyLastDate)
					{
						if(childNode.getAttributes().getNamedItem("name").getNodeValue().equalsIgnoreCase("NOTIFY_DAYS"))
						{
							NOTIFY_BEFORE_LASTDATE = checkNull(childNode.getFirstChild().getNodeValue());
							System.out.println("NOTIFY_BEFORE_LASTDATE =[====="+NOTIFY_BEFORE_LASTDATE+"]");
							hashMap.put("NOTIFY_BEFORE_LASTDATE", NOTIFY_BEFORE_LASTDATE);
							
							String mgrSql="SELECT TRAN_ID,SALES_PERS,EMP_CODE__APRV, PRD_QTR,ACCT_PRD FROM SPRS_SAMP_PLAN WHERE CONFIRMED ='Y' AND WORKFLOW_STATUS ='P' ";
							pstmt=connection.prepareStatement(mgrSql);
							rs=pstmt.executeQuery();
							while(rs.next())
							{
								int cnt=0;
								int wfPrcCnt=0;
								int wfPrcErrCnt=0,objSignTransCnt=0;
								String tranId="";
								tranId=checkNull(rs.getString("TRAN_ID"));
								String salesPerson=checkNull(rs.getString("SALES_PERS"));
								String reportTo=checkNull(rs.getString("EMP_CODE__APRV"));
								String prdQtr=checkNull(rs.getString("PRD_QTR"));
								String acctprd=checkNull(rs.getString("ACCT_PRD"));

								System.out.println("tranId ===="+tranId);
								System.out.println("prdQtr ===="+prdQtr);
								System.out.println("acctprd ===="+acctprd);
								System.out.println("salesPerson ===="+salesPerson);
								System.out.println("reportTo ===="+reportTo);
								
								String wfPrcSql="SELECT COUNT(*) AS COUNT FROM WF_PRC_STATUS WHERE REF_ID = ? AND REF_SER='S-PLN'";
								pstmt1=connection.prepareStatement(wfPrcSql);
								pstmt1.setString(1, tranId);
								rs1=pstmt1.executeQuery();
								System.out.println("wfPrcSql ==="+wfPrcSql);
								if(rs1.next())
								{
									wfPrcCnt=rs1.getInt("COUNT");
									System.out.println("DATA FOUND wfPrcCnt= "+wfPrcCnt); 
								}
								if(pstmt1!=null)
								{
									pstmt1.close();
									pstmt1 = null;
								}
								if(rs1!=null)
								{
									rs1.close();
									rs1=null;
								}
								
								if(wfPrcCnt > 0)
								{
									String wfPrcErrSql="SELECT COUNT(*) AS COUNT FROM WF_PRC_STATUS WHERE REF_ID = ? AND REF_SER='S-PLN' AND ERR_STATUS ='1'";
									pstmt1=connection.prepareStatement(wfPrcErrSql);
									pstmt1.setString(1, tranId);
									rs1=pstmt1.executeQuery();
									System.out.println("wfPrcErrSql ==="+wfPrcErrSql);
									if(rs1.next())
									{
										wfPrcErrCnt=rs1.getInt("COUNT");
										System.out.println("DATA FOUND wfPrcErrCnt= "+wfPrcErrCnt); 
									}
									if(pstmt1!=null)
									{
										pstmt1.close();
										pstmt1 = null;
									}
									if(rs1!=null)
									{
										rs1.close();
										rs1=null;
									}

									if(wfPrcErrCnt == 0)
									{
										String objSignSql="SELECT COUNT(*) AS CNT FROM OBJ_SIGN_TRANS WHERE REF_ID= ? AND SIGN_STATUS='U' AND REF_SER ='S-PLN' AND TRUNC(CREATE_DATE) > TRUNC(SYSDATE-'"+ NOTIFY_BEFORE_LASTDATE +"') ";
										pstmt1=connection.prepareStatement(objSignSql);
										pstmt1.setString(1, tranId);
										rs1=pstmt1.executeQuery();
										System.out.println("objSignSql ==="+objSignSql);
										if(rs1.next())
										{

											cnt=rs1.getInt("CNT");
											System.out.println("DATA FOUND = "+cnt); 
										}
										if(pstmt1!=null)
										{
											pstmt1.close();
											pstmt1 = null;
										}
										if(rs1!=null)
										{
											rs1.close();
											rs1=null;
										}
										System.out.println("Count === "+cnt); 
										if(cnt == 0)
										{
											String entityCode="";
											String objSignSql1="SELECT ENTITY_CODE FROM OBJ_SIGN_TRANS WHERE REF_ID= ? AND SIGN_STATUS='U' AND REF_SER ='S-PLN' ";
											pstmt1=connection.prepareStatement(objSignSql1);
											pstmt1.setString(1, tranId);
											rs1=pstmt1.executeQuery();
											System.out.println("objSignSql1 ==="+objSignSql1);
											if(rs1.next())
											{

												entityCode=checkNull(rs1.getString("ENTITY_CODE"));
												System.out.println("entityCode FOUND = "+entityCode); 
											}
											if(pstmt1!=null)
											{
												pstmt1.close();
												pstmt1 = null;
											}
											if(rs1!=null)
											{
												rs1.close();
												rs1=null;
											}
											
											
											String mobileNo="";
											String empDataSql= "select REPORT_TO, MOBILE_NO from employee where emp_code= ?";
											PreparedStatement pstmt8=connection.prepareStatement(empDataSql);
											pstmt8.setString(1, salesPerson);
											ResultSet rs8=pstmt8.executeQuery();
											if(rs8.next())
											{
												
												mobileNo=checkNull(rs8.getString("MOBILE_NO"));
												reportTo=checkNull(rs8.getString("REPORT_TO"));

											}
											if(pstmt8!=null)
											{
												pstmt8.close();
												pstmt8 = null;
											}
											if(rs8!=null)
											{
												rs8.close();
												rs8=null;
											}
											String reportToEmail="";
											String reportToSql= "select email_id_off from employee where emp_code= ?";
											PreparedStatement entPstmt=connection.prepareStatement(reportToSql);
											entPstmt.setString(1, reportTo);
											ResultSet entRs=entPstmt.executeQuery();
											if(entRs.next())
											{
												reportToEmail=E12GenericUtility.checkNull(entRs.getString("email_id_off"));
											}
											if(entPstmt!=null)
											{
												entPstmt.close();
												entPstmt = null;
											}
											if(entRs!=null)
											{
												entRs.close();
												entRs=null;
											}
											
											String salesPersonName="";
											String rspNameSql= "select SP_NAME from SALES_PERS where SALES_PERS= ?";
											PreparedStatement entPstmt2=connection.prepareStatement(rspNameSql);
											entPstmt2.setString(1, salesPerson);
											ResultSet entRs2=entPstmt2.executeQuery();
											if(entRs2.next())
											{
												salesPersonName=E12GenericUtility.checkNull(entRs2.getString("SP_NAME"));
											}
											if(entPstmt2!=null)
											{
												entPstmt2.close();
												entPstmt2 = null;
											}
											if(entRs2!=null)
											{
												entRs2.close();
												entRs2=null;
											}
											
											String hoUser = dARCommonBean.getSfaParmValueCommon(salesPerson,"SAMP_PLAN_ADM_APRVR",connection);
											String sql11="";

											String objName2="";
											String mailHeader2="";
											boolean isMailSend2 = false;
											String infoType2 = "ITM";
											String processInstanceId2 = "";
											String formatCode2 = "SAMP_PLAN_NOTIFY_MAIL";

											
											objName2="event_plan";
											mailHeader2 = "<ROOT>"+
													"<EMAIL_TYPE></EMAIL_TYPE>"+
													"<TRANS_INFO>"+
													"<OBJ_NAME>"+objName2+"</OBJ_NAME>"+
													"<REF_SER>"+"S-PLN"+"</REF_SER>"+
													"<LINE_NO>"+""+"</LINE_NO>"+
													"<XSL_FILE_NAME></XSL_FILE_NAME>"+
													"</TRANS_INFO>"+
													"<MAIL>"+
													"<ENTITY_CODE>"+entityCode+"</ENTITY_CODE>"+ 
													"<SUBJECT></SUBJECT>"+
													"<BODY_TEXT></BODY_TEXT>"+
													"<TO_ADD></TO_ADD>"+
													"<CC_ADD>"+reportToEmail+"</CC_ADD>"+
													"<FORMAT_CODE>"+formatCode2+"</FORMAT_CODE>"+
													"<LINK_ADDR></LINK_ADDR>"+
													"<ATTACHMENT><BODY></BODY><LOCATION></LOCATION></ATTACHMENT>"+
													"</MAIL>"+
													"<XML_DATA><ROOT><Detail1><emp_name>"+salesPersonName+"</emp_name><emp_code>"+salesPerson+"</emp_code><report_to_mail>"+reportToEmail+"</report_to_mail><prd_qtr>"+prdQtr+"</prd_qtr><acct_prd>"+acctprd+"</acct_prd></Detail1></ROOT></XML_DATA>"+
													"</ROOT>";
											System.out.println("custseries_upld_aprv APPROVER mailHeader ------- "+mailHeader2);
											isMailSend2 = true;
											isMailSend2 = sendMailStatus(mailHeader2, infoType2, processInstanceId2,connection);
											System.out.println("[CustSeriesUploadPos::process()] mail delivered successful" + isMailSend2);
											
											
											String enterprice="";
											String entSql="SELECT ENTERPRISE FROM USERS WHERE CODE=?";
											PreparedStatement entPstmt1=connection.prepareStatement(entSql);
											entPstmt1.setString(1, salesPerson);
											ResultSet entRs1=entPstmt1.executeQuery();
											if(entRs1.next())
											{
												enterprice=checkNull(entRs1.getString("ENTERPRISE"));

											}
											if(entPstmt1!=null)
											{
												entPstmt1.close();
												entPstmt1 = null;
											}
											if(entRs1!=null)
											{
												entRs1.close();
												entRs1=null;
											}
											
											
											
											/*StringBuffer xmlStrBuf = new StringBuffer();
											xmlStrBuf.append("<Root>");
											xmlStrBuf.append("<Detail1 objName='event_plan'>");
											xmlStrBuf.append("<sales_pers><![CDATA[").append(salesPerson).append("]]></sales_pers>\n");
											xmlStrBuf.append("<sp_name><![CDATA[").append(salesPersonName).append("]]></sp_name>\n");
											xmlStrBuf.append("<mobile_no><![CDATA[").append(mobileNo).append("]]></mobile_no>\n");
											xmlStrBuf.append("<report_to><![CDATA[").append(reportTo).append("]]></report_to>\n");
											xmlStrBuf.append("</Detail1>");
											xmlStrBuf.append("</Root>");
											String xmlString=xmlStrBuf.toString();
											String userInfoStr = "<UserInfo><transDB><![CDATA["+transDB+"]]></transDB><enterprise><![CDATA["+enterprice+"]]></enterprise></UserInfo>";
											userInfo = new UserInfoBean(userInfoStr); 
											String xtraParams = "loginCode="+salesPerson+"~~loginEmpCode"+salesPerson;
											if(salesPerson!=null && salesPerson.trim().length()>=0)
											{
												String formatCode ="SAMP_PLAN_MR_SMS";
												E12SMSComp e12SMSComp = new E12SMSComp();
												String retString = e12SMSComp.sendSMS(xmlString, formatCode, xtraParams, userInfo);
												System.out.println("retString>>>>>>>1184"+retString+"]");
											}
											if(reportTo!=null && reportTo.trim().length()>=0)
											{
												String formatCode ="SAMP_PLAN_MGR_SMS";
												E12SMSComp e12SMSComp = new E12SMSComp();
												String retString = e12SMSComp.sendSMS(xmlString, formatCode, xtraParams, userInfo);
												System.out.println("retString>>>>>>>1184"+retString+"]");
											}*/
										
											
											
										}
										
										
										
										
									}

								}
								
							}
														
						}
					}				
				}
			}
		        
		}
		catch(Exception e)
		{
			
			isError = true;
			System.out.println("DCREntrySchedule.generateDCR() :: "+e);
			e.printStackTrace();
			throw new ITMException(e); 
		}
		finally
		{
			try
			{
				if (connection != null && !connection.isClosed())
				{
					if ( !isError )
					{
						connection.commit();
					}
					else
					{
						connection.rollback();
					}
					connection.close();
					connection= null;
				}
			}
			catch(Exception e){}
		}
    }
	
	private String checkNull(String input)
	{
		if (input == null || "null".equalsIgnoreCase(input))
		{
			input= "";
		}
		return input;
	}
	private boolean getAttributeVal(Node childNode, String attribName)throws ITMException
 	{
 		boolean attribFound = false;
 		try
 		{
 			System.out.println("attribFound test= ["+childNode.getAttributes()+"]");
 			if(childNode != null && childNode.getAttributes() != null)
 			{
 				System.out.println("attribFound name= ["+childNode.getAttributes().getNamedItem("name").getNodeValue()+"]");
 				if(childNode.getAttributes().getNamedItem("name").getNodeValue().equalsIgnoreCase(attribName))
				{
 					attribFound = true;
 					
 					System.out.println("in if loop");
				}
 			}
 			
 		}
 		catch(Exception e)
 		{
 			throw new ITMException(e);
 		}
 		System.out.println("attribFound = ["+attribFound+"]");
 		return attribFound; 
 	}	
	public boolean sendMailStatus(String mailXMLStr, String infoType, String processInstanceId,Connection conn)
	{	
		boolean isSendMail = false;
		try 
		{
			System.out.println("mailXMLStr"+mailXMLStr);
			System.out.println("infotype::"+infoType);
			EMail em = new EMail();
			String returnstrFromSendMailMethod = em.sendMail(mailXMLStr, infoType,conn);
			System.out.println("@@@@ mail function called successfully : "+returnstrFromSendMailMethod);
			isSendMail = true;
		}
		catch (Exception e)
		{
			isSendMail = false;
			e.printStackTrace();
		}
		return isSendMail;		
	}
	public String getEmpname(String empCode, Connection connection) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String empCodeHO = "";
		String selectSql = "";
		String loginName ="";
		//Connection con = null;
		boolean isHO=false;
		try
		{
			//ConnDriver connDriver = new ConnDriver();
			//con = connDriver.getConnectDB(transDB);	
			selectSql = "SELECT  EMP_FNAME ||' '|| EMP_MNAME ||' '|| EMP_LNAME AS EMP_NAME " +
					" FROM EMPLOYEE WHERE EMP_CODE = ? ";		
			pstmt = connection.prepareStatement(selectSql);
			pstmt.setString(1, empCode);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				loginName =  rs.getString("EMP_NAME")   ==null ? "":rs.getString("EMP_NAME");
			}
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
		} 
		catch (Exception e)
		{
			throw new ITMException(e);
		} 
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				
			} 
			catch (Exception e1)
			{
			}
		}
		//return empCodeHO;
		
		return loginName;
	}
}
