/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.servlet;

import ibase.bean.EventLogInfoBean;
import ibase.ejb.CommonDBAccessEJB;
import ibase.system.config.AppConnectParm;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.RAHandler;
import ibase.utility.RAHandlerTO;
import ibase.utility.UserInfoBean;
import ibase.webitm.bean.ITMTransactionCoreModel;
import ibase.webitm.ejb.InfinispanLocal;
import ibase.webitm.notification.ejb.PublishPushNotificationEJB;
import ibase.webitm.servlet.ITMAuthenticateServlet;
import ibase.webitm.utility.ITMException;
import ibase.wrkflw.E12FollowUpActionEJB;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ITMValidatorServlet
extends ITMAuthenticateServlet {
    ServletContext servletContext = null;
    ServletConfig servletConfig = null;
    static InfinispanLocal infinispanLocalObj = null;
    static Hashtable jndiProperties = null;
    static InitialContext ctx = null;

    static {
        try {
            if (CommonConstants.CACHE_OPT != 0) {
                jndiProperties = new Hashtable();
                jndiProperties.put("java.naming.factory.url.pkgs", "org.jboss.ejb.client.naming");
                ctx = new InitialContext(jndiProperties);
                infinispanLocalObj = (InfinispanLocal)ctx.lookup("ibase/InfinispanEJB/local");
                BaseLogger.log("1", null, null, "ITMValidatorServlet infinispanLocalObj created.....");
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception in ITMValidatorServlet static block:[" + e.getMessage() + "]");
            e.printStackTrace();
        }
    }

    @Override
    public void init(ServletConfig servletConfig) throws ServletException {
        this.servletConfig = servletConfig;
        this.servletContext = servletConfig.getServletContext();
    }

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        this.doPost(request, response);
    }

    @Override
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        block25: {
            BaseLogger.log("2", null, null, " **************************** [In ITMValidatorServlet] ******************************* ");
            Object outputStream = null;
            String responseStr = "";
            try {
                String objName;
                if (!Boolean.valueOf(this.authenticate(request)).booleanValue()) break block25;
                HttpSession session = request.getSession();
                ITMTransactionCoreModel itmTransCoreMdl = null;
                String coreModelID = request.getParameter("CORE_MDL_ID");
                if ("null".equalsIgnoreCase(coreModelID) || "".equals(coreModelID) || coreModelID == null) {
                    responseStr = "Invalid Session Context";
                } else {
                    itmTransCoreMdl = (ITMTransactionCoreModel)session.getAttribute(coreModelID);
                }
                if (itmTransCoreMdl != null && itmTransCoreMdl.masterStateful != null) {
                    itmTransCoreMdl.masterStateful.setEditorId(coreModelID);
                }
                if ("null".equalsIgnoreCase(objName = request.getParameter("OBJ_NAME")) || "".equals(objName) || objName == null) {
                    objName = itmTransCoreMdl.getObjName();
                }
                final UserInfoBean userInfo = (UserInfoBean)session.getAttribute("USER_INFO");
                String enterprise = userInfo.getEnterprise();
                String callerInterface = request.getParameter("CALLER_INTERFACE");
                String currentSummaryXsl = new E12GenericUtility().getSummaryXSL(objName, callerInterface, enterprise);
                String chgXMLStr = request.getParameter("XML_STR");
                String action = request.getParameter("ACTION");
                responseStr = this.saveChanges(objName, chgXMLStr, itmTransCoreMdl);
                String saveLevel = null;
                Node saveLevelNode = new E12GenericUtility().parseString(chgXMLStr).getElementsByTagName("saveLevel").item(0);
                if (saveLevelNode != null && saveLevelNode.getFirstChild() != null) {
                    saveLevel = saveLevelNode.getFirstChild().getNodeValue();
                }
                if (saveLevel != null && responseStr != null && saveLevel.equals("1") && responseStr.indexOf("Success") != -1) {
                    if (itmTransCoreMdl.getUserInfo() != null) {
                        EventLogInfoBean eventLogInfoBean = new EventLogInfoBean(itmTransCoreMdl.getUserInfo().getLoginCode());
                        eventLogInfoBean.removeEditorActivity(objName, session.getId(), coreModelID, userInfo.getTransDB());
                    } else {
                        BaseLogger.log("3", userInfo, null, " ============ User info is null then never created event log in ITMValidatorServlet.java file");
                    }
                    itmTransCoreMdl.masterStateful.remove();
                    session.removeAttribute(coreModelID);
                    final String userId = userInfo.getLoginCode();
                    String sessionId = session.getId();
                    BaseLogger.log("3", userInfo, null, "**************************userId:[" + userId + "]");
                    BaseLogger.log("3", userInfo, null, "***********************sessionId:[" + sessionId + "]");
                    BaseLogger.log("3", userInfo, null, "*************************objName:[" + objName + "]");
                    String tranID = "";
                    try {
                        AppConnectParm appConnect = new AppConnectParm();
                        Properties p = appConnect.getProperty();
                        InitialContext ctx = new InitialContext(p);
                        BaseLogger.log("3", userInfo, null, "Looking Up for CommonDBAccess EJB with Properties==>\n" + p);
                        CommonDBAccessEJB commomDbAccess = new CommonDBAccessEJB();
                        Node tranIdNode = new E12GenericUtility().parseString(responseStr).getElementsByTagName("TranID").item(0);
                        if (tranIdNode != null && tranIdNode.getFirstChild() != null) {
                            tranID = tranIdNode.getFirstChild().getNodeValue();
                        }
                        BaseLogger.log("3", userInfo, null, "tranID - [" + tranID + "]");
                        String columnName = "WORKFLOW_OPT";
                        String tableName = "TRANSETUP";
                        String condition = " WHERE TRAN_WINDOW ='w_" + objName.trim() + "' ";
                        String workFlowOpt = E12GenericUtility.checkNull(commomDbAccess.getDBColumnValue(tableName, columnName, condition, userInfo.getTransDB()));
                        int workFlowOp = Integer.parseInt(workFlowOpt);
                        BaseLogger.log("3", userInfo, null, "workFlowOp::" + workFlowOp);
                        if (tranID != null && tranID.length() > 0 && workFlowOp > 0) {
                            this.addFollowUpAction(userId, coreModelID, tranID, objName, userInfo);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    final String finalKey = String.valueOf(objName) + "_" + tranID;
                    final String tranIDNew = tranID;
                    final String objNameWS = objName;
                    new Thread(){

                        @Override
                        public void run() {
                            try {
                                BaseLogger.log("3", userInfo, null, "Recent Activity: In run method");
                                ArrayList<Object> userIdList = new ArrayList();
                                String xmlData = "";
                                String webSocketXMLData = "";
                                if (CommonConstants.CACHE_OPT != 0) {
                                    BaseLogger.log("3", userInfo, null, "959 ----!!*** Recent Activity: In run method");
                                    if (infinispanLocalObj != null) {
                                        BaseLogger.log("3", userInfo, null, "ITMValidator : Getting values inside infinispan object [" + finalKey + "]");
                                        xmlData = infinispanLocalObj.getFormData(finalKey);
                                        infinispanLocalObj.remove(finalKey);
                                        userIdList = infinispanLocalObj.getUsers();
                                        BaseLogger.log("3", userInfo, null, "1068-----Data frm infi is [" + xmlData + "]");
                                        webSocketXMLData = new E12GenericUtility().editWebSocketXml(xmlData);
                                        xmlData = String.valueOf(objNameWS) + "~" + E12GenericUtility.checkNull(webSocketXMLData);
                                    }
                                } else {
                                    ArrayList<RAHandlerTO> raHandlerTOs;
                                    RAHandler raHandler = new RAHandler();
                                    if (RAHandler.getUserRATO().containsKey(userId) && (raHandlerTOs = RAHandler.getUserRATO().get(userId)) != null && !raHandlerTOs.isEmpty()) {
                                        RAHandlerTO raHandlerTO = new RAHandlerTO();
                                        raHandlerTO = raHandlerTOs.get(raHandlerTOs.size() - 1);
                                        String tranId = E12GenericUtility.checkNull(raHandlerTO.getTranId());
                                        String object = E12GenericUtility.checkNull(raHandlerTO.getObject());
                                        webSocketXMLData = new E12GenericUtility().editWebSocketXml(E12GenericUtility.checkNull(raHandlerTO.getData()));
                                        xmlData = String.valueOf(object) + "~" + E12GenericUtility.checkNull(webSocketXMLData);
                                        userIdList.add(userId);
                                        String string = "New Notification";
                                    }
                                }
                                if (userIdList != null && userIdList.contains(userId)) {
                                    String message = "New Notification";
                                    ArrayList<String> currentUserList = new ArrayList<String>();
                                    currentUserList.add(userId.trim());
                                    PublishPushNotificationEJB notificationRemote = new PublishPushNotificationEJB();
                                    notificationRemote.invockPushNotification(message, userId, "T", tranIDNew, currentUserList, xmlData, "", "", userId, 0, "C", userInfo, "1", CommonConstants.WebSocketMessageType.SUMMARY);
                                }
                            }
                            catch (Exception e) {
                                BaseLogger.log("0", userInfo, null, "ITMValidator : Exception in new thread::" + e.getMessage());
                            }
                        }
                    }.start();
                }
                if (responseStr != null && responseStr.trim().length() > 0) {
                    response.setBufferSize(1024);
                    response.setContentType("text/html; charset=" + CommonConstants.ENCODING);
                    if (action != null && action.length() > 0 && "LAYOUT_VALIDATION".equalsIgnoreCase(action)) {
                        Document currentDetailNode = new E12GenericUtility().parseString(responseStr);
                        String finalRespStr = "";
                        if (currentDetailNode != null && currentDetailNode.getElementsByTagName("Errors").item(0) != null) {
                            Node errorNode = currentDetailNode.getElementsByTagName("error").item(0);
                            Node typeNode = errorNode.getAttributes().getNamedItem("type");
                            String typeNodeValue = typeNode.getNodeValue();
                            BaseLogger.log("3", userInfo, null, "InE12EditorHandlerServlet typeNodeValue[" + typeNodeValue + "]");
                            if (!"P".equalsIgnoreCase(typeNodeValue) && !"W".equalsIgnoreCase(typeNodeValue)) {
                                finalRespStr = new E12GenericUtility().serializeDom(currentDetailNode.getElementsByTagName("Errors").item(0));
                            } else {
                                finalRespStr = "<Message type=\"" + typeNodeValue + "\">";
                                finalRespStr = String.valueOf(finalRespStr) + new E12GenericUtility().serializeDom(currentDetailNode.getElementsByTagName("message").item(0));
                                if (currentDetailNode.getElementsByTagName("description").item(0) != null) {
                                    finalRespStr = String.valueOf(finalRespStr) + new E12GenericUtility().serializeDom(currentDetailNode.getElementsByTagName("description").item(0));
                                }
                                finalRespStr = String.valueOf(finalRespStr) + "</Message>";
                            }
                            responseStr = finalRespStr;
                        }
                    }
                    responseStr = String.valueOf(responseStr) + "~#~" + currentSummaryXsl;
                    ServletOutputStream outStream = response.getOutputStream();
                    outStream.write(responseStr.getBytes());
                    outStream.flush();
                    outStream.close();
                }
            }
            catch (ITMException itme) {
                itme.printStackTrace();
                try {
                    PrintWriter writer = response.getWriter();
                    response.setContentType("text/html; charset=" + CommonConstants.ENCODING);
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    itme.printStackTrace(new PrintStream(baos));
                    response.setContentLength(baos.toString().length());
                    writer.println(baos.toString());
                    writer.flush();
                    writer.close();
                    baos.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    PrintWriter writer = response.getWriter();
                    response.setContentType("text/html; charset=" + CommonConstants.ENCODING);
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    e.printStackTrace(new PrintStream(baos));
                    String errMsg = "";
                    response.setContentLength(baos.toString().length());
                    writer.println("ERR_MSG :" + errMsg + "\n" + baos.toString());
                    writer.flush();
                    writer.close();
                    baos.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private String saveChanges(String objName, String xmlStr, ITMTransactionCoreModel itmTransCoreMdl) throws Exception, ITMException {
        String retVal = "";
        try {
            retVal = itmTransCoreMdl.masterStateful.validateAndPerformAction(xmlStr, "VAL_DATA");
        }
        catch (ITMException itme) {
            retVal = itme.getMessage();
        }
        catch (Exception e) {
            retVal = e.getMessage();
        }
        return retVal;
    }

    private void removeDocIdFromInprocessMap(String userId, String sessionId, String objName) throws Exception {
        String inProcessDocMapKey = String.valueOf(userId) + ":" + sessionId;
        String docId = "";
        String inProcessDocIds = "";
        Map mapList = new HashMap();
        try {
            if (this.servletContext.getAttribute("inProcessUnAllocDocMap") != null && (mapList = (Map)this.servletContext.getAttribute("inProcessUnAllocDocMap")) != null && !mapList.isEmpty()) {
                BaseLogger.info("--------------- In ITMValidatorServlet ---------------");
                ArrayList value = (ArrayList)mapList.get(inProcessDocMapKey);
                if (value != null && !value.isEmpty()) {
                    int i = 0;
                    while (i < value.size()) {
                        String[] inProcessDocMapValue;
                        BaseLogger.log("3", null, null, "********************** " + (String)value.get(i));
                        if (value.get(i) != null && (inProcessDocMapValue = ((String)value.get(i)).split(":"))[0] != null && inProcessDocMapValue[0].trim().equals(objName)) {
                            docId = (String)value.get(i);
                            if (value.remove(docId.trim())) {
                                BaseLogger.log("3", null, null, "From DocMapKey = [" + inProcessDocMapKey + "] DocId = [" + docId + "] Removed.");
                                BaseLogger.info("[" + userId + "] - [" + docId + "] : Document Processed");
                            } else {
                                BaseLogger.info("[" + userId + "] - [" + docId + "] : Not Removed from inProcessMap");
                            }
                        }
                        ++i;
                    }
                }
                if (this.servletContext.getAttribute("inProcessDocIds") != null) {
                    inProcessDocIds = (String)this.servletContext.getAttribute("inProcessDocIds");
                }
                BaseLogger.log("3", null, null, "inProcessDocIds = [" + inProcessDocIds + "]");
                if (docId != null && !docId.trim().equals("")) {
                    String[] inProcessDataValue = docId.split("\\:");
                    String removeString = "'" + inProcessDataValue[1] + "',";
                    BaseLogger.log("3", null, null, "removeString = [" + removeString + "]");
                    inProcessDocIds = inProcessDocIds.replace(removeString, "");
                    BaseLogger.log("3", null, null, "After remooving inProcessDocIds = [" + inProcessDocIds + "]");
                }
                this.servletContext.setAttribute("inProcessDocIds", (Object)inProcessDocIds);
                Map mapListUnAlloc = new HashMap();
                if (this.servletContext.getAttribute("unAllocDocMap") != null) {
                    mapListUnAlloc = (Map)this.servletContext.getAttribute("unAllocDocMap");
                }
                for (Map.Entry entry1 : mapListUnAlloc.entrySet()) {
                    BaseLogger.info("[Unalloc Map] ObjName = [" + (String)entry1.getKey() + "] DocumentIds = [" + entry1.getValue() + "]\n");
                }
                if (this.servletContext.getAttribute("inProcessUnAllocDocMap") != null) {
                    mapList = (Map)this.servletContext.getAttribute("inProcessUnAllocDocMap");
                }
                for (Map.Entry entry1 : mapList.entrySet()) {
                    BaseLogger.info("[Inprocess Map] ObjName = [" + (String)entry1.getKey() + "] DocumentIds = [" + entry1.getValue() + "]\n");
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception: removeDocIdFromInprocessMap: " + e.getMessage());
            BaseLogger.info("Exception: [" + e.getMessage() + "]");
            e.printStackTrace();
            throw new Exception(e);
        }
    }

    private void addFollowUpAction(String userId, String editorId, String tranId, String objName, UserInfoBean userInfo) {
        try {
            String pendingWrkflwMapKey = String.valueOf(userId) + "~" + editorId;
            String pendingWrkflwMapValue = String.valueOf(objName) + "~" + tranId;
            Map<String, String> pendingWrkflwMap = new HashMap();
            if (this.servletContext.getAttribute("pendingWrkflwMap") != null) {
                pendingWrkflwMap = (Map)this.servletContext.getAttribute("pendingWrkflwMap");
                if (pendingWrkflwMap != null) {
                    pendingWrkflwMap.put(pendingWrkflwMapKey, pendingWrkflwMapValue);
                }
                AppConnectParm appConnect = new AppConnectParm();
                InitialContext ctx = new InitialContext(appConnect.getProperty());
                E12FollowUpActionEJB followUpActionLocal = new E12FollowUpActionEJB();
                followUpActionLocal.followUpAction(pendingWrkflwMapKey, this.servletContext, userInfo);
            }
            BaseLogger.log("3", userInfo, editorId, "pendingWrkflwMap - " + this.servletContext.getAttribute("pendingWrkflwMap"));
        }
        catch (Exception e) {
            BaseLogger.log("0", userInfo, editorId, "Exception - " + e.getMessage());
            e.printStackTrace();
        }
    }

    private InitialContext getInitialContext() throws ITMException {
        InitialContext ctx = null;
        try {
            BaseLogger.log("3", null, null, "In try block of NotificationScheduleJB:getInitialContext Method.");
            AppConnectParm appConnect = new AppConnectParm();
            ctx = new InitialContext(appConnect.getProperty());
        }
        catch (ITMException itme) {
            BaseLogger.log("0", null, null, "ITMException : getInitialContext : " + itme.getMessage());
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception : getInitialContext : " + e.getMessage());
            throw new ITMException(e);
        }
        return ctx;
    }
}

