/**
 *
 */
package ibase.webService;


import java.io.File;	
import java.util.HashMap;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import org.json.JSONException;
import org.json.JSONObject;

import ibase.utility.BaseException;
import ibase.utility.BaseLogger;
import ibase.utility.CryptographyUtil;
import ibase.utility.UserInfoBean;
import ibase.webitm.angular.BuildAngularLayout;
import ibase.webitm.utility.E12ExtServiceUtility;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.RestAPIServiceUtility;
import ibase.webitm.utility.ViewReport;

/**
 * @author Prasad Raut
 * Changed the structure of class by Gagan B. To seperate logic from service file into a new utility file named E12ExtServiceUtility.
 */
@Path("/E12ExtService")
//Changed by Prasad on 20/12/2020 [Create a common class RestAPIService, for authentication related process]
public class E12ExtService extends RestAPIService
{
	/**
	 * Get External Service Data
	 *
	 * @param dataFor
	 * @param userCode
	 * @param password
	 * @param isPwdEncrypt
	 * @param serviceParam1
	 * @param serviceParam2
	 * @param serviceParam3
	 * @param serviceParam4
	 * @param request
	 * @return
	 * @throws BaseException
	 * @throws Exception
	 */
	@GET
	@Path("/getExtServiceData")
	@Produces(MediaType.APPLICATION_JSON)
	public Response getExtServiceData( @QueryParam("dataFor") String dataFor, @QueryParam("userCode") String userCode,
			@QueryParam("password") String password, @QueryParam("isPwdEncrypt") String isPwdEncrypt,
			@QueryParam("serviceParam1") String serviceParam1, @QueryParam("serviceParam2") String serviceParam2,
			@QueryParam("serviceParam3") String serviceParam3, @QueryParam("serviceParam4") String serviceParam4,
			@Context HttpServletRequest request ) throws BaseException, Exception
	{
		E12ExtServiceUtility E12ExtServiceUtility = new E12ExtServiceUtility();
		String result = E12ExtServiceUtility.getExtServiceData(dataFor, userCode, password, isPwdEncrypt, serviceParam1, serviceParam2, serviceParam3, serviceParam4, request);
		return Response.status(200).entity( result ).build();
	}

	/**
	 *
	 * @param dataFor
	 * @param userCode
	 * @param password
	 * @param isPwdEncrypt
	 * @param serviceParam1
	 * @param serviceParam2
	 * @param serviceParam3
	 * @param serviceParam4
	 * @param request
	 * @return
	 * @throws BaseException
	 * @throws Exception
	 */
	@POST
	@Path("/getExtServiceClient")
	@Produces(MediaType.APPLICATION_JSON)
	public Response getExtnServiceData( @FormParam("dataFor") String dataFor, @FormParam("userCode") String userCode,
			@FormParam("password") String password, @FormParam("isPwdEncrypt") String isPwdEncrypt,
			@FormParam("serviceParam1") String serviceParam1, @FormParam("serviceParam2") String serviceParam2,
			@FormParam("serviceParam3") String serviceParam3, @FormParam("serviceParam4") String serviceParam4,
			@Context HttpServletRequest request ) throws BaseException, Exception
	{
		E12ExtServiceUtility E12ExtServiceUtility = new E12ExtServiceUtility();
		String result = E12ExtServiceUtility.getExtnServiceData(dataFor, userCode, password, isPwdEncrypt, serviceParam1, serviceParam2, serviceParam3, serviceParam4, request);
		return Response.status(200).entity( result ).build();
	}

	//Added by Prasad on 07/03/16 [E-travel related services - T15JSUN001] START
	/**
	 * Used for authenticate user
	 *
	 * @param userCode
	 * @param password
	 * @param isPwdEncrypt
	 * @param dataFormat
	 * @param request
	 * @return
	 * @throws BaseException
	 * @throws Exception
	 */
	@GET
	@Path("/login")
	@Produces(MediaType.APPLICATION_JSON)
	public Response authenticateUser(@QueryParam("USER_CODE") String userCode, @QueryParam("PASSWORD") String password,
			@QueryParam("IS_PWD_ENCRYPT") String isPwdEncrypt, @QueryParam("DATA_FORMAT") String dataFormat,
			@QueryParam("IS_DESTROY_SESSION") boolean isDestroySession, @QueryParam("APP_ID") String appId, @Context HttpServletRequest request) throws BaseException, Exception
	{
		E12ExtServiceUtility E12ExtServiceUtility = new E12ExtServiceUtility();
		String result = E12ExtServiceUtility.authenticateUser(userCode, password, isPwdEncrypt, dataFormat, isDestroySession, appId, request);
		return Response.status(200).entity( result ).build();
	}

	/**
	 * Used for authenticate user
	 *
	 * @param userCode
	 * @param password
	 * @param isPwdEncrypt
	 * @param inputString
	 * @param dataFormat
	 * @param request
	 * @return
	 * @throws BaseException
	 * @throws Exception
	 */
	@POST
	@Path("/login")
	@Produces(MediaType.APPLICATION_JSON)
	public Response authenticateUserClient(@FormParam("USER_CODE") String userCode, @FormParam("PASSWORD") String password,
			@FormParam("IS_PWD_ENCRYPT") String isPwdEncrypt, @FormParam("INPUT_STR") String inputString,
			@FormParam("DATA_FORMAT") String dataFormat, @Context HttpServletRequest request,
			@FormParam("IS_DESTROY_SESSION") boolean isDestroySession, @FormParam("APP_ID") String appId ) throws BaseException, Exception
	{
		E12ExtServiceUtility E12ExtServiceUtility = new E12ExtServiceUtility();
		String result = E12ExtServiceUtility.authenticateUserClient(userCode, password, isPwdEncrypt, inputString, dataFormat, request, isDestroySession, appId);
		return Response.status(200).entity( result ).build();
	}

	/**
	 * Forgot Password
	 *
	 * @param userCode
	 * @param dataFormat
	 * @param request
	 * @return
	 * @throws BaseException
	 * @throws Exception
	 */
	@GET
	@Path("/forgot_password")
	@Produces(MediaType.APPLICATION_JSON)
	public Response forgotPassword(
		@QueryParam("USER_CODE") String userCode,
		@QueryParam("DATA_FORMAT") String dataFormat,
		@QueryParam("APP_HASH") String applicationHashCode, ////Added by Pravin k on 28-FEB-19 [For appHash] START
		@QueryParam("APP_ID") String appId,
		@Context HttpServletRequest request
	) throws BaseException, Exception
	{
		E12ExtServiceUtility E12ExtServiceUtility = new E12ExtServiceUtility();
		String result = E12ExtServiceUtility.forgotPassword(userCode, dataFormat, applicationHashCode, appId, request);
		return Response.status(200).entity( result ).build();
	}

	/**
	 * Forgot Password
	 *
	 * @param userCode
	 * @param dataFormat
	 * @param request
	 * @return
	 * @throws BaseException
	 * @throws Exception
	 */
	@POST
	@Path("/forgot_password")
	@Produces(MediaType.APPLICATION_JSON)
	public Response forgotPasswordClient(@FormParam("USER_CODE") String userCode, @FormParam("DATA_FORMAT") String dataFormat, @FormParam("APP_ID") String appId,
			@Context HttpServletRequest request) throws BaseException, Exception
	{
		E12ExtServiceUtility E12ExtServiceUtility = new E12ExtServiceUtility();
		String result = E12ExtServiceUtility.forgotPasswordClient(userCode, dataFormat, appId, request);
		return Response.status(200).entity( result ).build();
	}
	
	//Added By Ankush S on 04-DEC-2023[to get the Application list]START
		@GET
		@Path("/appllist")
		@Produces(MediaType.APPLICATION_JSON)
		public Response getDataModelsList(@Context HttpServletRequest request) {		
			BaseLogger.log("3", null, null,"calling API for getting data models==>");
			//return Response.status(200).entity(new E12ExtServiceUtility().getDatamodelList(request)).build();
			return Response.status(200).entity(new E12ExtServiceUtility().getApplList(request)).build();
			
		}
		//Added By Ankush S on 04-DEC-2023[to get the Application list]END
		//Added By Ankush S on 23-NOV-23 [to get response in JSON]START
		@POST
		@Path("/loginApp")
		@Produces(MediaType.APPLICATION_JSON)
		public Response authenticateUserClientLoginApp(
				@FormParam("USER_CODE") String userCode,
				@FormParam("PASSWORD") String password,
				@FormParam("IS_PWD_ENCRYPT") String isPwdEncrypt, 
				@FormParam("INPUT_STR") String inputString,
				@FormParam("DATA_FORMAT") String dataFormat, 
				@Context HttpServletRequest request,
				@FormParam("IS_DESTROY_SESSION") boolean isDestroySession,
				@FormParam("APP_ID") String appId ) throws BaseException, Exception
		{
			BaseLogger.log("3",null,null, "Calling new API for login");
			E12ExtServiceUtility E12ExtServiceUtility = new E12ExtServiceUtility();
			String result = E12ExtServiceUtility.authenticateUserClientJSON(userCode, password, isPwdEncrypt, inputString, dataFormat, request, isDestroySession, appId);		
			
			return Response.status(200).entity( result ).build();
		}
		//Added By Ankush S on 23-NOV-23 [to get response in JSON]START
		

	/**
	 * Change Password
	 *
	 * @param userCode
	 * @param oldPassword
	 * @param newPassword
	 * @param tokenId
	 * @param dataFormat
	 * @param request
	 * @return
	 * @throws BaseException
	 * @throws Exception
	 */
	@GET
	@Path("/change_password")
	@Produces(MediaType.APPLICATION_JSON)
	public Response changePassword(@QueryParam("USER_CODE") String userCode, @QueryParam("OLD_PASS") String oldPassword,
			@QueryParam("NEW_PASS") String newPassword, @QueryParam("TOKEN_ID") String tokenId,
			@QueryParam("DATA_FORMAT") String dataFormat, @QueryParam("APP_ID") String appId, @Context HttpServletRequest request) throws BaseException, Exception
	{
		E12ExtServiceUtility E12ExtServiceUtility = new E12ExtServiceUtility();
		String result = E12ExtServiceUtility.changePassword(userCode, oldPassword, newPassword, tokenId, dataFormat, appId, request);
		return Response.status(200).entity( result ).build();
	}

	/**
	 * Change Password
	 *
	 * @param userCode
	 * @param oldPassword
	 * @param newPassword
	 * @param tokenId
	 * @param dataFormat
	 * @param request
	 * @return
	 * @throws BaseException
	 * @throws Exception
	 */

	
// changes done by Amol S on 16-jan-23 to pass token id in header & body
	
	@POST
	@Path("/change_password")
	@Produces(MediaType.APPLICATION_JSON)
	public Response changePasswordClient(
	        @FormParam("USER_CODE") String userCode,
	        @FormParam("OLD_PASS") String oldPassword,
	        @FormParam("NEW_PASS") String newPassword,
	        @FormParam("DATA_FORMAT") String dataFormat,
	        @FormParam("APP_ID") String appId,
	        @HeaderParam("TOKEN_ID") String tokenIdHeader,
	        @FormParam("TOKEN_ID") String tokenIdBody,
	        @Context HttpServletRequest request) throws BaseException, Exception
	{

	    String tokenId = tokenIdHeader != null ? tokenIdHeader : tokenIdBody;

	    E12ExtServiceUtility e12ExtServiceUtility = new E12ExtServiceUtility();
	    String result = e12ExtServiceUtility.changePasswordClient(
	        userCode, oldPassword, newPassword, tokenId, dataFormat, appId, request);

	    return Response.status(200).entity(result).build();
	}


	/**
	 * Logout user session
	 *
	 * @param userCode
	 * @param tokenId
	 * @param dataFormat
	 * @param request
	 * @return
	 * @throws BaseException
	 * @throws Exception
	 */
	@GET
	@Path("/logout")
	@Produces(MediaType.APPLICATION_JSON)
	public Response logout(@QueryParam("USER_CODE") String userCode, @QueryParam("TOKEN_ID") String tokenId,
			@QueryParam("DATA_FORMAT") String dataFormat, @QueryParam("APP_ID") String appId, @Context HttpServletRequest request) throws BaseException, Exception
	{
		E12ExtServiceUtility E12ExtServiceUtility = new E12ExtServiceUtility();
		String result = E12ExtServiceUtility.logout(userCode, tokenId, dataFormat, appId, request);
		return Response.status(200).entity( result ).build();
	}

	/**
	 * Logout user session
	 *
	 * @param userCode
	 * @param tokenId
	 * @param dataFormat
	 * @param request
	 * @return
	 * @throws BaseException
	 * @throws Exception
	 */
	@POST
	@Path("/logout")
	@Produces(MediaType.APPLICATION_JSON)
	public Response logoutClient(
	        @FormParam("USER_CODE") String userCode,
	        @HeaderParam("TOKEN_ID") String tokenIdHeader,
	        @FormParam("TOKEN_ID") String tokenIdBody,
	        @FormParam("DATA_FORMAT") String dataFormat,
	        @FormParam("APP_ID") String appId,
	        @Context HttpServletRequest request
	) throws BaseException, Exception {

	    String tokenId = tokenIdHeader != null ? tokenIdHeader : tokenIdBody;

	    E12ExtServiceUtility e12ExtServiceUtility = new E12ExtServiceUtility();
	    String result = e12ExtServiceUtility.logoutClient(userCode, tokenId, dataFormat, appId, request);

	    return Response.status(200).entity(result).build();
	}

	/**
	 * Used for calling system actions for provided object
	 *
	 * @param objName - object Name
	 * @param action - actions to perform ('Add', 'Edit',...)
	 * @param xmlString - input Data
	 * @param tokenId -
	 * @param dataFormat
	 * @param request
	 * @return responseStr - respective response in provided data_format
	 * @throws BaseException
	 * @throws Exception
	 */
	@GET
	@Path("/callSystemAction")
	@Produces(MediaType.APPLICATION_JSON)
	public Response callSystemAction(@QueryParam("ACTION") String action, @QueryParam("OBJ_NAME") String objName,
			@QueryParam("INPUT_STR") String inputString, @QueryParam("TOKEN_ID") String tokenId, @QueryParam("DATA_FORMAT") String dataFormat,
			@QueryParam("APP_ID") String appId, @Context HttpServletRequest request, @Context ServletContext context) throws BaseException, Exception
	{
		E12ExtServiceUtility E12ExtServiceUtility = new E12ExtServiceUtility();
		String result = E12ExtServiceUtility.callSystemAction(action, objName, inputString, tokenId, dataFormat, appId, request, context);
		return Response.status(200).entity( result ).build();
	}

	/**
	 * Used for calling system actions for provided object
	 *
	 * @param objName - object Name
	 * @param action - actions to perform ('Add', 'Edit',...)
	 * @param xmlString - input Data
	 * @param tokenId -
	 * @param dataFormat
	 * @param request
	 * @return responseStr - respective response in provided data_format
	 * @throws BaseException
	 * @throws Exception
	 */
	@POST
	@Path("/callSystemAction")
	@Produces(MediaType.APPLICATION_JSON)
	public Response callSystemActionClient(
	        @FormParam("ACTION") String action,
	        @FormParam("OBJ_NAME") String objName,
	        @FormParam("INPUT_STR") String inputString,
	        @HeaderParam("TOKEN_ID") String tokenIdHeader,
	        @FormParam("TOKEN_ID") String tokenIdBody,
	        @FormParam("DATA_FORMAT") String dataFormat,
	        @FormParam("APP_ID") String appId,
	        @Context HttpServletRequest request,
	        @Context ServletContext context
	) throws BaseException, Exception {

	    String tokenId = tokenIdHeader != null ? tokenIdHeader : tokenIdBody;

	    E12ExtServiceUtility e12ExtServiceUtility = new E12ExtServiceUtility();
	    String result = e12ExtServiceUtility.callSystemActionClient(
	        action, objName, inputString, tokenId, dataFormat, appId, request, context);

	    return Response.status(200).entity(result).build();
	}


	/**
	 * Used for calling user defined events for provided object
	 *
	 * @param objName - object Name
	 * @param eventCode - events to perform ('Confirm a transaction', ...)
	 * @param xmlString - input data
	 * @param tokenId
	 * @param dataFormat
	 * @param request
	 * @return responseStr - respective response in provided data_format
	 * @throws BaseException
	 * @throws Exception
	 */
	@GET
	@Path("/callSystemEvent")
	@Produces(MediaType.APPLICATION_JSON)
	public Response callSystemEvent(@QueryParam("OBJ_NAME") String objName, @QueryParam("EVENT_CODE") String eventCode,
			@QueryParam("INPUT_STR") String inputString, @QueryParam("TOKEN_ID") String tokenId, @QueryParam("DATA_FORMAT") String dataFormat,
			@QueryParam("APP_ID") String appId, @Context HttpServletRequest request) throws BaseException, Exception
	{
		E12ExtServiceUtility E12ExtServiceUtility = new E12ExtServiceUtility();
		String result = E12ExtServiceUtility.callSystemEvent(objName, eventCode, inputString, tokenId, dataFormat, appId, request);
		return Response.status(200).entity( result ).build();
	}

	/**
	 * Used for calling user defined events for provided object
	 *
	 * @param objName - object Name
	 * @param eventCode - events to perform ('Confirm a transaction', ...)
	 * @param xmlString - input data
	 * @param tokenId
	 * @param dataFormat
	 * @param request
	 * @return responseStr - respective response in provided data_format
	 * @throws BaseException
	 * @throws Exception
	 */
	@POST
	@Path("/callSystemEvent")
	@Produces(MediaType.APPLICATION_JSON)
	public Response callSystemEventClient(
	        @FormParam("OBJ_NAME") String objName,
	        @FormParam("EVENT_CODE") String eventCode,
	        @FormParam("INPUT_STR") String inputString,
	        @HeaderParam("TOKEN_ID") String tokenIdHeader,
	        @FormParam("TOKEN_ID") String tokenIdBody,
	        @FormParam("DATA_FORMAT") String dataFormat,
	        @FormParam("APP_ID") String appId,
	        @Context HttpServletRequest request
	) throws BaseException, Exception {

	    String tokenId = tokenIdHeader != null ? tokenIdHeader : tokenIdBody;

	    E12ExtServiceUtility e12ExtServiceUtility = new E12ExtServiceUtility();
	    String result = e12ExtServiceUtility.callSystemEventClient(
	        objName, eventCode, inputString, tokenId, dataFormat, appId, request);

	    return Response.status(200).entity(result).build();
	}


	/**
	 * to get required data for provided object
	 *
	 * @param objName - Object Name
	 * @param refId - transaction Id
	 * @param tokenId - provided at login time
	 * @param dataFormat
	 * @param request
	 * @return responseStr - respective data in provided data_format
	 * @throws BaseException
	 * @throws Exception
	 */
	@GET
	@Path("/getData")
	@Produces(MediaType.APPLICATION_JSON)
	public Response getData( @QueryParam("OBJ_NAME") String objName, @QueryParam("REF_ID") String refId,
			@QueryParam("TOKEN_ID") String tokenId, @QueryParam("DATA_FORMAT") String dataFormat,
			@QueryParam("APP_ID") String appId, @Context HttpServletRequest request) throws BaseException, Exception
	{
		E12ExtServiceUtility E12ExtServiceUtility = new E12ExtServiceUtility();
		String result = E12ExtServiceUtility.getData(objName, refId, tokenId, dataFormat, appId, request);
		return Response.status(200).entity( result ).build();
	}

	/**
	 * to get required data for provided object
	 *
	 * @param objName - Object Name
	 * @param refId - transaction Id
	 * @param tokenId - provided at login time
	 * @param enterprise //Added By Gagan B. on 21-FEB-23
	 * @param dataFormat
	 * @param request
	 * @return responseStr - respective data in provided data_format
	 * @throws BaseException
	 * @throws Exception
	 */
	@POST
	@Path("/getData")
	@Produces(MediaType.APPLICATION_JSON)
	public Response getDataClient(
	        @FormParam("OBJ_NAME") String objName,
	        @FormParam("REF_ID") String refId,
	        @HeaderParam("TOKEN_ID") String tokenIdHeader,
	        @FormParam("TOKEN_ID") String tokenIdBody,
	        @FormParam("ENTERPRISE") String enterprise,
	        @FormParam("DATA_FORMAT") String dataFormat,
	        @FormParam("APP_ID") String appId,
	        @Context HttpServletRequest request
	) throws BaseException, Exception {

	    String tokenId = tokenIdHeader != null ? tokenIdHeader : tokenIdBody;

	    E12ExtServiceUtility e12ExtServiceUtility = new E12ExtServiceUtility();
	    String result = e12ExtServiceUtility.getDataClient(
	        objName, refId, tokenId, enterprise, dataFormat, appId, request);

	    return Response.status(200).entity(result).build();
	}

	//Added by Prasad on 07/03/16 [E-travel related services - T15JSUN001] END

	//Added by Prasad on 26/05/16 [Adding PopHelp, ItemChange, BrowData options- T15JSUN001] START
	/**
	 * Get Pophelp data
	 *
	 * @param objName
	 * @param fieldName
	 * @param inputString
	 * @param tokenId
	 * @param dataFormat
	 * @param request
	 * @return
	 * @throws BaseException
	 * @throws Exception
	 */
	@GET
	@Path("/fieldPophelp")
	@Produces(MediaType.APPLICATION_JSON)
	public Response getPopHelpData( @QueryParam("OBJ_NAME") String objName, @QueryParam("FIELDNAME") String fieldName,
			@QueryParam("INPUT_STR") String inputString, @QueryParam("TOKEN_ID") String tokenId, @QueryParam("DATA_FORMAT") String dataFormat,
			@QueryParam("INPUT_STR_ALL") String inputStringAllXml, @QueryParam("FORM_NO") String formNo, @QueryParam("REQ_PARAMS") String reqParams,
			@QueryParam("APP_ID") String appId, @Context HttpServletRequest request ) throws BaseException, Exception//Modified by Ahmed on 29-08-2020 to add input arguments as per required to fetch PopUp data 
	{
		E12ExtServiceUtility E12ExtServiceUtility = new E12ExtServiceUtility();
		String result = E12ExtServiceUtility.getPopHelpData(objName, fieldName, inputString, tokenId, dataFormat, inputStringAllXml, formNo, reqParams, appId, request);
		return Response.status(200).entity( result ).build();
	}

	/**
	 * Get Pophelp data
	 *
	 * @param objName
	 * @param fieldName
	 * @param inputString
	 * @param tokenId
	 * @param dataFormat
	 * @param request
	 * @return
	 * @throws BaseException
	 * @throws Exception
	 */
	@POST
	@Path("/fieldPophelp")
	@Produces(MediaType.APPLICATION_JSON)
	public Response getPopHelpDataClient(
	        @FormParam("OBJ_NAME") String objName,
	        @FormParam("FIELDNAME") String fieldName,
	        @FormParam("INPUT_STR") String inputString,
	        @HeaderParam("TOKEN_ID") String tokenIdHeader,
	        @FormParam("TOKEN_ID") String tokenIdBody,
	        @FormParam("DATA_FORMAT") String dataFormat,
	        @FormParam("INPUT_STR_ALL") String inputStringAllXml,
	        @FormParam("FORM_NO") String formNo,
	        @FormParam("REQ_PARAMS") String reqParams,
	        @FormParam("APP_ID") String appId,
	        @Context HttpServletRequest request
	) throws BaseException, Exception {

	    String tokenId = tokenIdHeader != null ? tokenIdHeader : tokenIdBody;

	    E12ExtServiceUtility e12ExtServiceUtility = new E12ExtServiceUtility();
	    String result = e12ExtServiceUtility.getPopHelpDataClient(
	        objName, fieldName, inputString, tokenId, dataFormat, inputStringAllXml, formNo, reqParams, appId, request);

	    return Response.status(200).entity(result).build();
	}


	/**
	 * Get Brow data
	 *
	 * @param objName
	 * @param argNames
	 * @param argValues
	 * @param argTypes
	 * @param advQuery
	 * @param searchParam
	 * @param tokenId
	 * @param dataFormat
	 * @param request
	 * @return
	 * @throws BaseException
	 * @throws Exception
	 */
	@GET
	@Path("/objectBrowse")
	@Produces(MediaType.APPLICATION_JSON)
	public Response getBrowData( @QueryParam("OBJ_NAME") String objName, @QueryParam("ARG_NAMES") String argNames,
			@QueryParam("ARG_VALUES") String argValues, @QueryParam("ARG_TYPES") String argTypes,
			@QueryParam("ADV_QRY") String advQuery, @QueryParam("SEARCH_PARAM") String searchParam,
			@QueryParam("TOKEN_ID") String tokenId, @QueryParam("DATA_FORMAT") String dataFormat,
			@QueryParam("APP_ID") String appId, @Context HttpServletRequest request ) throws BaseException, Exception
	{
		E12ExtServiceUtility E12ExtServiceUtility = new E12ExtServiceUtility();
		String result = E12ExtServiceUtility.getBrowData(objName, argNames, argValues, argTypes, advQuery, searchParam, tokenId, dataFormat, appId, request);
		return Response.status(200).entity( result ).build();
	}

	/**
	 * get brow data
	 *
	 * @param objName
	 * @param argNames
	 * @param argValues
	 * @param argTypes
	 * @param advQuery
	 * @param searchParam
	 * @param tokenId
	 * @param dataFormat
	 * @param request
	 * @return
	 * @throws BaseException
	 * @throws Exception
	 */
	@POST
	@Path("/objectBrowse")
	@Produces(MediaType.APPLICATION_JSON)
	public Response getBrowDataClient(
	        @FormParam("OBJ_NAME") String objName,
	        @FormParam("ARG_NAMES") String argNames,
	        @FormParam("ARG_VALUES") String argValues,
	        @FormParam("ARG_TYPES") String argTypes,
	        @FormParam("ADV_QRY") String advQuery,
	        @FormParam("SEARCH_PARAM") String searchParam,
	        @HeaderParam("TOKEN_ID") String tokenIdHeader,
	        @FormParam("TOKEN_ID") String tokenIdBody,
	        @FormParam("DATA_FORMAT") String dataFormat,
	        @FormParam("APP_ID") String appId,
	        @Context HttpServletRequest request
	) throws BaseException, Exception {

	    String tokenId = tokenIdHeader != null ? tokenIdHeader : tokenIdBody;

	    E12ExtServiceUtility e12ExtServiceUtility = new E12ExtServiceUtility();
	    String result = e12ExtServiceUtility.getBrowDataClient(
	        objName, argNames, argValues, argTypes, advQuery, searchParam, tokenId, dataFormat, appId, request);

	    return Response.status(200).entity(result).build();
	}


	/**
	 * Get itemchange data
	 *
	 * @param objName
	 * @param transDomStr
	 * @param detailDomStr
	 * @param domId
	 * @param tokenId
	 * @param dataFormat
	 * @param request
	 * @return
	 * @throws BaseException
	 * @throws Exception
	 */
	@GET
	@Path("/performItemChange")
	@Produces(MediaType.APPLICATION_JSON)
	public Response getItemChange( @QueryParam("OBJ_NAME") String objName, @QueryParam("TRANS_DOM") String transDomStr,
			@QueryParam("DETAIL_DOM") String detailDomStr, @QueryParam("DOM_ID") String domId,
			@QueryParam("TOKEN_ID") String tokenId, @QueryParam("DATA_FORMAT") String dataFormat,
			@QueryParam("APP_ID") String appId, @Context HttpServletRequest request ) throws BaseException, Exception
	{
		E12ExtServiceUtility E12ExtServiceUtility = new E12ExtServiceUtility();
		String result = E12ExtServiceUtility.getItemChange(objName, transDomStr, detailDomStr, domId, tokenId, dataFormat, appId, request);
		return Response.status(200).entity( result ).build();
	}

	/**
	 * get Itemchange data
	 *
	 * @param objName
	 * @param transDomStr
	 * @param detailDomStr
	 * @param domId
	 * @param tokenId
	 * @param dataFormat
	 * @param request
	 * @return
	 * @throws BaseException
	 * @throws Exception
	 */
	@POST
	@Path("/performItemChange")
	@Produces(MediaType.APPLICATION_JSON)
	public Response getItemChangeClient(
	        @FormParam("OBJ_NAME") String objName,
	        @FormParam("TRANS_DOM") String transDomStr,
	        @FormParam("DETAIL_DOM") String detailDomStr,
	        @FormParam("DOM_ID") String domId,
	        @HeaderParam("TOKEN_ID") String tokenIdHeader,
	        @FormParam("TOKEN_ID") String tokenIdBody,
	        @FormParam("DATA_FORMAT") String dataFormat,
	        @FormParam("APP_ID") String appId,
	        @Context HttpServletRequest request
	) throws BaseException, Exception {

	    String tokenId = tokenIdHeader != null ? tokenIdHeader : tokenIdBody;

	    E12ExtServiceUtility e12ExtServiceUtility = new E12ExtServiceUtility();
	    String result = e12ExtServiceUtility.getItemChangeClient(
	        objName, transDomStr, detailDomStr, domId, tokenId, dataFormat, appId, request);

	    return Response.status(200).entity(result).build();
	}

	//Added by Prasad on 26/05/16 [Adding PopHelp, ItemChange, BrowData options- T15JSUN001] END

	//Added by Prasad on 26/05/16 [Adding Workflow related options- T16CSUN001] START
	/**
	 * Get Inbox data of Workflow
	 *
	 * @param tokenId
	 * @param dataFormat
	 * @param request
	 * @return
	 * @throws BaseException
	 * @throws Exception
	 */
	@GET
	@Path("/getInbox")
	@Produces(MediaType.APPLICATION_JSON)
	public Response getWrkFlwInbox( @QueryParam("TOKEN_ID") String tokenId, @QueryParam("DATA_FORMAT") String dataFormat,
			@QueryParam("APP_ID") String appId, @Context HttpServletRequest request ) throws BaseException, Exception
	{
		E12ExtServiceUtility E12ExtServiceUtility = new E12ExtServiceUtility();
		String result = E12ExtServiceUtility.getWrkFlwInbox(tokenId, dataFormat, appId, request);
		return Response.status(200).entity( result ).build();
	}

	/**
	 * Get Inbox data of workflow
	 *
	 * @param tokenId
	 * @param dataFormat
	 * @param request
	 * @return
	 * @throws BaseException
	 * @throws Exception
	 */
	@POST
	@Path("/getInbox")
	@Produces(MediaType.APPLICATION_JSON)
	public Response getWrkFlwInboxClient(
	        @HeaderParam("TOKEN_ID") String tokenIdHeader,
	        @FormParam("TOKEN_ID") String tokenIdBody,
	        @FormParam("DATA_FORMAT") String dataFormat,
	        @FormParam("APP_ID") String appId,
	        @Context HttpServletRequest request
	) throws BaseException, Exception {

	    String tokenId = tokenIdHeader != null ? tokenIdHeader : tokenIdBody;

	    E12ExtServiceUtility e12ExtServiceUtility = new E12ExtServiceUtility();
	    String result = e12ExtServiceUtility.getWrkFlwInboxClient(tokenId, dataFormat, appId, request);

	    return Response.status(200).entity(result).build();
	}


	/**
	 * Get Approved data of workflow
	 *
	 * @param tokenId
	 * @param dataFormat
	 * @param request
	 * @return
	 * @throws BaseException
	 * @throws Exception
	 */
	@GET
	@Path("/getApproved")
	@Produces(MediaType.APPLICATION_JSON)
	public Response getWrkFlwApproved( @QueryParam("TOKEN_ID") String tokenId, @QueryParam("DATA_FORMAT") String dataFormat,
			@QueryParam("APP_ID") String appId, @Context HttpServletRequest request ) throws BaseException, Exception
	{
		E12ExtServiceUtility E12ExtServiceUtility = new E12ExtServiceUtility();
		String result = E12ExtServiceUtility.getWrkFlwApproved(tokenId, dataFormat, appId, request);
		return Response.status(200).entity( result ).build();
	}

	/**
	 * Get Approved data of workflow
	 *
	 * @param tokenId
	 * @param dataFormat
	 * @param request
	 * @return
	 * @throws BaseException
	 * @throws Exception
	 */
	@POST
	@Path("/getApproved")
	@Produces(MediaType.APPLICATION_JSON)
	public Response getWrkFlwApprovedClient(
	        @HeaderParam("TOKEN_ID") String tokenIdHeader,
	        @FormParam("TOKEN_ID") String tokenIdBody,
	        @FormParam("DATA_FORMAT") String dataFormat,
	        @FormParam("APP_ID") String appId,
	        @Context HttpServletRequest request
	) throws BaseException, Exception {

	    String tokenId = tokenIdHeader != null ? tokenIdHeader : tokenIdBody;

	    E12ExtServiceUtility e12ExtServiceUtility = new E12ExtServiceUtility();
	    String result = e12ExtServiceUtility.getWrkFlwApprovedClient(tokenId, dataFormat, appId, request);

	    return Response.status(200).entity(result).build();
	}


	/**
	 * Get Rejected data of workflow
	 *
	 * @param tokenId
	 * @param dataFormat
	 * @param request
	 * @return
	 * @throws BaseException
	 * @throws Exception
	 */
	@GET
	@Path("/getRejected")
	@Produces(MediaType.APPLICATION_JSON)
	public Response getWrkFlwRejected( @QueryParam("TOKEN_ID") String tokenId, @QueryParam("DATA_FORMAT") String dataFormat,
			@QueryParam("APP_ID") String appId, @Context HttpServletRequest request ) throws BaseException, Exception
	{
		E12ExtServiceUtility E12ExtServiceUtility = new E12ExtServiceUtility();
		String result = E12ExtServiceUtility.getWrkFlwRejected(tokenId, dataFormat, appId, request);
		return Response.status(200).entity( result ).build();
	}

	/**
	 * Get Rejected data of workflow
	 *
	 * @param tokenId
	 * @param dataFormat
	 * @param request
	 * @return
	 * @throws BaseException
	 * @throws Exception
	 */
	@POST
	@Path("/getRejected")
	@Produces(MediaType.APPLICATION_JSON)
	public Response getWrkFlwRejectedClient(
	        @HeaderParam("TOKEN_ID") String tokenIdHeader,
	        @FormParam("TOKEN_ID") String tokenIdBody,
	        @FormParam("DATA_FORMAT") String dataFormat,
	        @FormParam("APP_ID") String appId,
	        @Context HttpServletRequest request
	) throws BaseException, Exception {

	    String tokenId = tokenIdHeader != null ? tokenIdHeader : tokenIdBody;

	    E12ExtServiceUtility e12ExtServiceUtility = new E12ExtServiceUtility();
	    String result = e12ExtServiceUtility.getWrkFlwRejectedClient(tokenId, dataFormat, appId, request);

	    return Response.status(200).entity(result).build();
	}


	/**
	 * Get Sign transaction details
	 *
	 * @param refSer
	 * @param refId
	 * @param lineNo
	 * @param tokenId
	 * @param dataFormat
	 * @param request
	 * @return
	 * @throws BaseException
	 * @throws Exception
	 */
	@GET
	@Path("/getSignTransDet")
	@Produces(MediaType.APPLICATION_JSON)
	public Response getSignTransDet( @QueryParam("REF_SER") String refSer, @QueryParam("REF_ID") String refId,
			@QueryParam("LINE_NO") String lineNo, @QueryParam("TOKEN_ID") String tokenId, @QueryParam("DATA_FORMAT") String dataFormat,
			@QueryParam("APP_ID") String appId, @Context HttpServletRequest request ) throws BaseException, Exception
	{
		E12ExtServiceUtility E12ExtServiceUtility = new E12ExtServiceUtility();
		String result = E12ExtServiceUtility.getSignTransDet(refSer, refId, lineNo, tokenId, dataFormat, appId, request);
		return Response.status(200).entity( result ).build();
	}

	/**
	 * Get Sign transaction details
	 *
	 * @param refSer
	 * @param refId
	 * @param lineNo
	 * @param tokenId
	 * @param dataFormat
	 * @param request
	 * @return
	 * @throws BaseException
	 * @throws Exception
	 */
	@POST
	@Path("/getSignTransDet")
	@Produces(MediaType.APPLICATION_JSON)
	public Response getSignTransDetClient(
	        @FormParam("REF_SER") String refSer,
	        @FormParam("REF_ID") String refId,
	        @FormParam("LINE_NO") String lineNo,
	        @HeaderParam("TOKEN_ID") String tokenIdHeader,
	        @FormParam("TOKEN_ID") String tokenIdBody,
	        @FormParam("DATA_FORMAT") String dataFormat,
	        @FormParam("APP_ID") String appId,
	        @Context HttpServletRequest request
	) throws BaseException, Exception {

	    String tokenId = tokenIdHeader != null ? tokenIdHeader : tokenIdBody;

	    E12ExtServiceUtility e12ExtServiceUtility = new E12ExtServiceUtility();
	    String result = e12ExtServiceUtility.getSignTransDetClient(refSer, refId, lineNo, tokenId, dataFormat, appId, request);

	    return Response.status(200).entity(result).build();
	}

	/**
	 * Update Sign status (Approve/Reject)
	 *
	 * @param actionCode
	 * @param xmlString
	 * @param tokenId
	 * @param dataFormat
	 * @param request
	 * @return
	 * @throws BaseException
	 * @throws Exception
	 */
	@GET
	@Path("/updateSignStatus")
	@Produces(MediaType.APPLICATION_JSON)
	public Response updateSignStatus( @QueryParam("ACTION_CODE") String actionCode, @QueryParam("XML_STRING") String xmlString,
			@QueryParam("TOKEN_ID") String tokenId, @QueryParam("DATA_FORMAT") String dataFormat,  @QueryParam("UUID") String uuid,
			@QueryParam("APP_ID") String appId, @Context HttpServletRequest request, @Context ServletContext context ) throws BaseException, Exception
	{
		E12ExtServiceUtility E12ExtServiceUtility = new E12ExtServiceUtility();
		String result = E12ExtServiceUtility.updateSignStatus(actionCode, xmlString, tokenId, dataFormat, uuid, appId, request, context);
		return Response.status(200).entity( result ).build();
	}

	/**
	 * Update Sign status (Approve/Reject)
	 *
	 * @param actionCode
	 * @param xmlString
	 * @param tokenId
	 * @param dataFormat
	 * @param request
	 * @return
	 * @throws BaseException
	 * @throws Exception
	 */
	@POST
	@Path("/updateSignStatus")
	@Produces(MediaType.APPLICATION_JSON)
	public Response updateSignStatusClient(
	        @FormParam("ACTION_CODE") String actionCode,
	        @FormParam("XML_STRING") String xmlString,
	        @HeaderParam("TOKEN_ID") String tokenIdHeader,
	        @FormParam("TOKEN_ID") String tokenIdBody,
	        @FormParam("DATA_FORMAT") String dataFormat,
	        @FormParam("UUID") String uuid,
	        @FormParam("APP_ID") String appId,
	        @Context HttpServletRequest request,
	        @Context ServletContext context
	) throws BaseException, Exception {

	    String tokenId = tokenIdHeader != null ? tokenIdHeader : tokenIdBody;

	    E12ExtServiceUtility e12ExtServiceUtility = new E12ExtServiceUtility();
	    String result = e12ExtServiceUtility.updateSignStatusClient(
	        actionCode, xmlString, tokenId, dataFormat, uuid, appId, request, context);

	    return Response.status(200).entity(result).build();
	}

	//Added by Prasad on 26/05/16 [Adding Workflow related options- T16CSUN001] END

	//Added by Prasad on 26/05/16 [Adding User Image and Attachment related options- T16DSUN001] START
	/**
	 * Get User Image
	 *
	 * @param tokenId
	 * @param dataFormat
	 * @param request
	 * @param response
	 * @return
	 * @throws BaseException
	 * @throws Exception
	 */
	@GET
	@Path("/getUserImage")
	public Response getUserImage( @QueryParam("TOKEN_ID") String tokenId, @QueryParam("DATA_FORMAT") String dataFormat,
			@QueryParam("APP_ID") String appId, @Context HttpServletRequest request, @Context HttpServletResponse response ) throws BaseException, Exception
	{
		E12ExtServiceUtility E12ExtServiceUtility = new E12ExtServiceUtility();
		String result = E12ExtServiceUtility.getUserImage(tokenId, dataFormat, appId, request, response);
		return Response.status(200).entity( result ).build();
	}

	/**
	 * Get User Image
	 *
	 * @param tokenId
	 * @param dataFormat
	 * @param request
	 * @param response
	 * @return
	 * @throws BaseException
	 * @throws Exception
	 */
	@POST
	@Path("/getUserImage")
	public Response getUserImageClient(
	        @HeaderParam("TOKEN_ID") String tokenIdHeader,
	        @FormParam("TOKEN_ID") String tokenIdBody,
	        @FormParam("DATA_FORMAT") String dataFormat,
	        @FormParam("APP_ID") String appId,
	        @Context HttpServletRequest request,
	        @Context HttpServletResponse response
	) throws BaseException, Exception {

	    String tokenId = tokenIdHeader != null ? tokenIdHeader : tokenIdBody;

	    E12ExtServiceUtility e12ExtServiceUtility = new E12ExtServiceUtility();
	    String result = e12ExtServiceUtility.getUserImageClient(tokenId, dataFormat, appId, request, response);

	    return Response.status(200).entity(result).build();
	}

	/**
	 * Get Attachment of provided object name and refId
	 *
	 * @param objName
	 * @param refSer
	 * @param refId
	 * @param docType
	 * @param tokenId
	 * @param dataFormat
	 * @param request
	 * @param response
	 * @return
	 * @throws BaseException
	 * @throws Exception
	 */
	@GET
	@Path("/getAttachDocument")
	public Response getAttachDocument( @QueryParam("OBJ_NAME") String objName, @QueryParam("REF_SER") String refSer,
			@QueryParam("REF_ID") String refId, @QueryParam("DOC_TYPE") String docType,
			@QueryParam("TOKEN_ID") String tokenId, @QueryParam("DATA_FORMAT") String dataFormat,
			@QueryParam("APP_ID") String appId, @Context HttpServletRequest request, @Context HttpServletResponse response ) throws BaseException, Exception
	{
		E12ExtServiceUtility E12ExtServiceUtility = new E12ExtServiceUtility();
		String result = E12ExtServiceUtility.getAttachDocument(objName, refSer, refId, docType, tokenId, dataFormat, appId, request, response);
		return Response.status(200).entity( result ).build();
	}

	/**
	 * Get Attachment of provided object name and refId
	 *
	 * @param objName
	 * @param refSer
	 * @param refId
	 * @param docType
	 * @param tokenId
	 * @param dataFormat
	 * @param request
	 * @param response
	 * @return
	 * @throws BaseException
	 * @throws Exception
	 */
	@POST
	@Path("/getAttachDocument")
	public Response getAttachDocumentClient(
	        @FormParam("OBJ_NAME") String objName,
	        @FormParam("REF_SER") String refSer,
	        @FormParam("REF_ID") String refId,
	        @FormParam("DOC_TYPE") String docType,
	        @HeaderParam("TOKEN_ID") String tokenIdHeader,
	        @FormParam("TOKEN_ID") String tokenIdBody,
	        @FormParam("DATA_FORMAT") String dataFormat,
	        @FormParam("APP_ID") String appId,
	        @Context HttpServletRequest request,
	        @Context HttpServletResponse response
	) throws BaseException, Exception {

	    String tokenId = tokenIdHeader != null ? tokenIdHeader : tokenIdBody;

	    E12ExtServiceUtility e12ExtServiceUtility = new E12ExtServiceUtility();
	    String result = e12ExtServiceUtility.getAttachDocumentClient(
	        objName, refSer, refId, docType, tokenId, dataFormat, appId, request, response);

	    return Response.status(200).entity(result).build();
	}

	//Added by Prasad on 26/05/16 [Adding User Image and Attachment related options- T16DSUN001] END

	//Added by Prasad on 26/05/16 [For keep alive session] START
	/**
	 * Keep session alive
	 *
	 * @param tokenId
	 * @param request
	 * @return
	 * @throws BaseException
	 * @throws Exception
	 */
	@GET
	@Path("/keepAlive")
	public Response keepSessionAlive( @QueryParam("TOKEN_ID") String tokenId, @QueryParam("APP_ID") String appId, @Context HttpServletRequest request ) throws BaseException, Exception
	{
		E12ExtServiceUtility E12ExtServiceUtility = new E12ExtServiceUtility();
		String result = E12ExtServiceUtility.keepSessionAlive(tokenId, appId, request);
		return Response.status(200).entity( result ).build();
	}

	/**
	 * Keep session alive
	 *
	 * @param tokenId
	 * @param request
	 * @return
	 * @throws BaseException
	 * @throws Exception
	 */
	@POST
	@Path("/keepAlive")
	public Response keepSessionAliveClient(
	        @HeaderParam("TOKEN_ID") String tokenIdHeader,
	        @FormParam("TOKEN_ID") String tokenIdBody,
	        @FormParam("APP_ID") String appId,
	        @Context HttpServletRequest request
	) throws BaseException, Exception {

	    String tokenId = tokenIdHeader != null ? tokenIdHeader : tokenIdBody;

	    E12ExtServiceUtility e12ExtServiceUtility = new E12ExtServiceUtility();
	    String result = e12ExtServiceUtility.keepSessionAliveClient(tokenId, appId, request);

	    return Response.status(200).entity(result).build();
	}

	//Added by Prasad on 26/05/16 [For keep alive session] END

	//Added by Prasad on 25/05/18 [enterprise implementation in attachment] START
	/**
	 * Upload document
	 *
	 * @param tokenId
	 * @param request
	 * @return
	 * @throws BaseException
	 * @throws Exception
	 */
	@POST
	@Path("/uploadDocument")
	public Response upload( @Context HttpServletRequest request ) throws BaseException, Exception
	{
		E12ExtServiceUtility E12ExtServiceUtility = new E12ExtServiceUtility();
		String result = E12ExtServiceUtility.upload(request);
		return Response.status(200).entity( result ).build();
	}

	/**
	 * Get document from docId
	 *
	 * @param docId
	 * @param request
	 * @return byteArray of document
	 * @throws BaseException
	 * @throws Exception
	 */
	@POST
	@Path("/getDocument")
	public Response getDocument( @FormParam("DOC_ID") String docId, @FormParam("USER_INFO") String userInfoStr, @Context HttpServletRequest request ) throws BaseException, Exception
	{
		E12ExtServiceUtility E12ExtServiceUtility = new E12ExtServiceUtility();
		String result = E12ExtServiceUtility.getDocument(docId, userInfoStr, request);
		return Response.status(200).entity( result ).build();
	}

	/**
	 * Delete document from docId
	 *
	 * @param docId
	 * @param request
	 * @return byteArray of document
	 * @throws BaseException
	 * @throws Exception
	 */
	@POST
	@Path("/deleteDocument")
	public Response deleteDocument( @FormParam("DOC_ID") String docId, @FormParam("REF_ID") String refId, @FormParam("REF_SER") String refSer,
			@FormParam("REF_COL") String refCol, @FormParam("OBJ_NAME") String objName, @FormParam("USER_INFO") String userInfoStr, @Context HttpServletRequest request ) throws BaseException, Exception
	{
		E12ExtServiceUtility E12ExtServiceUtility = new E12ExtServiceUtility();
		String result = E12ExtServiceUtility.deleteDocument(docId, refId, refSer, refCol, objName, userInfoStr, request);
		return Response.status(200).entity( result ).build();
	}
	//Added by Prasad on 25/05/18 [enterprise implementation in attachment] END

	//Added by sunny soni on 07-May-18 for getting app survey information [start]
	/**
	 * getting App survey information from users
	 *
	 * @param USER_ID
	 * @param EASE_USE
	 * @param FUNC_COVERED
	 * @param PERFRMNCE
	 * @param FEEDBACK
	 * @param request
	 * @return
	 * @throws JSONException 
	 * @throws BaseException
	 * @throws Exception
	 */
	@SuppressWarnings("unchecked")
	@GET
	@Path("/getAppSurvey")
	public Response getAppsurveyInfo(@QueryParam("USER_ID") String userId, @QueryParam("APP_ID") String appId,
			@QueryParam("EASE_USE") String easeUse, @QueryParam("FUNC_COVERED") String funcCovered, @QueryParam("PERFORMANCE") String performance,
			@QueryParam("FEEDBACK") String feedback ) throws JSONException
	{
		E12ExtServiceUtility E12ExtServiceUtility = new E12ExtServiceUtility();
		JSONObject result = E12ExtServiceUtility.getAppsurveyInfo(userId, appId, easeUse, funcCovered, performance, feedback);
		return Response.status(200).entity( result ).build();
	}
	/**
	 * getting App survey information from users
	 *
	 * @param USER_ID
	 * @param EASE_USE
	 * @param FUNC_COVERED
	 * @param PERFRMNCE
	 * @param FEEDBACK
	 * @param request
	 * @return
	 * @throws JSONException 
	 * @throws BaseException
	 * @throws Exception
	 */
	@SuppressWarnings("unchecked")
	@POST
	@Path("/getAppSurvey")
	public Response getAppsurveyInformation(@FormParam("USER_ID") String userId, @FormParam("APP_ID") String appId,
			@FormParam("EASE_USE") String easeUse, @FormParam("FUNC_COVERED") String funcCovered, @FormParam("PERFORMANCE") String performance,
			@FormParam("FEEDBACK") String feedback ) throws JSONException
	{
		E12ExtServiceUtility E12ExtServiceUtility = new E12ExtServiceUtility();
		JSONObject result = E12ExtServiceUtility.getAppsurveyInformation(userId, appId, easeUse, funcCovered, performance, feedback);
		return Response.status(200).entity( result ).build();
	}
	//Added by sunny soni on 07-May-18 for getting app survey information [end]
	//Added by sunny soni for getting annotation data and saved annotation data[Start]
	@POST
	@Path("/saveAnnotationData")
	public Response saveAnnoataionData(@FormParam("USER_ID") String userId, @FormParam("DOC_ID") String docId, @FormParam("ANNOT_DATA") String annotationData, @Context HttpServletRequest request)
	{
		E12ExtServiceUtility E12ExtServiceUtility = new E12ExtServiceUtility();
		JSONObject result = E12ExtServiceUtility.saveAnnoataionData(userId, docId, annotationData, request);
		return Response.status(200).entity( result ).build();
	}
	//Added by sunny soni for getting annoatation data and saved annotation data[End]

	//Added by sunny soni on 03-Oct-19 for uploading CaptureImage from browser notification sent in attachments and return websocket message [Start]
	@POST
	@Path("/uploadCaptureImage")
	public Response uploadCaptureImage(@Context HttpServletRequest request)
	{
		E12ExtServiceUtility E12ExtServiceUtility = new E12ExtServiceUtility();
		JSONObject result = E12ExtServiceUtility.uploadCaptureImage(request);
		return Response.status(200).entity( result ).build();
	}
	
	//Added by Umakanta Das on 05/MAY/2017 [ A16LSUN004 ] [ Receive request from third party mobile app and return Pay slip data with json format ]Start
	/**
	 * This method return Pay slip data with json format.
	 *
	 * @param userCode
	 * @param password
	 * @param isPwdEncrypt
	 * @param dataFormat
	 * @param apiUrl
	 * @param token
	 * @param guid
	 * @param apIPwd
	 * @param imei
	 * @param appId
	 * @param projectName
	 * @return return Pay slip data with json format
	 * @throws BaseException
	 * @throws Exception
	 */
	@POST
	@Path("/getPaySlipData")
	@Produces(MediaType.APPLICATION_JSON)
	public Response getPaySlipDataClient(
	        @FormParam("USERCODE") String userCode,
	        @FormParam("PASSWORD") String password,
	        @FormParam("ISPWDENCRYPT") String isPwdEncrypt,
	        @FormParam("DATAFORMAT") String dataFormat,
	        @FormParam("URL") String apiUrl,
	        @HeaderParam("TOKEN") String tokenHeader,
	        @FormParam("TOKEN") String tokenBody,
	        @FormParam("GUID") String guid,
	        @FormParam("APIPwd") String apIPwd,
	        @FormParam("IMEI") String imei,
	        @FormParam("AppID") String appId,
	        @FormParam("ProjectName") String projectName,
	        @Context HttpServletRequest request
	) throws BaseException, Exception {

	    String token = tokenHeader != null ? tokenHeader : tokenBody;

	    E12ExtServiceUtility e12ExtServiceUtility = new E12ExtServiceUtility();
	    String result = e12ExtServiceUtility.getPaySlipDataClient(userCode, password, isPwdEncrypt, dataFormat, apiUrl, token, guid, apIPwd, imei, appId, projectName, request);

	    return Response.status(200).entity(result).build();
	}

	//Added by Umakanta Das on 05/MAY/2017 [ A16LSUN004 ] [ Receive request from third party mobile app and return Pay slip data with json format ]End
	

	//added by vishal pathare on 1.8.18 for[users licence related security]Start
	@GET
	@Path("/getHashCode")
	public Response getHashCode( @QueryParam("tranId") String tranId, @QueryParam("enterprise") String enterprise, @QueryParam("activeUsrCnt") String activeUsrCnt, @QueryParam("usrLicType") String usrLicType, @QueryParam("transDb") String transDb, @QueryParam("tokenId") String tokenId, @QueryParam("appId") String appId, @QueryParam("endPoint") String endPoint, @Context HttpServletRequest request) throws JSONException, ITMException
	{
		String result="";
		boolean response = false;
		E12ExtServiceUtility E12ExtServiceUtility = new E12ExtServiceUtility();
		//Added by Vaishali Patil 10/07/23 [provision to add validation to validate appId][start]
		response = E12ExtServiceUtility.validateLLT(tokenId, appId, endPoint);
		if(response)
		{
		      result = E12ExtServiceUtility.getHashCode(tranId, enterprise, activeUsrCnt, usrLicType, transDb, request);
		}
		return Response.status(200).entity( result ).build();
		//Added by Vaishali Patil 10/07/23 [provision to add validation to validate appId][end]

	}
	//added by vishal pathare on 1.8.18 for[users licence related security]End

	//START: Added by Arti: 09-Feb-23: For activate/deactivate the users 
	@GET
	@Path("/setToggleUserLock")
	public Response setToggleUserLock( @QueryParam("tranId") String tranId, @QueryParam("enterprise") String enterprise, @QueryParam("acctLock") String acctLock, @QueryParam("transDb") String transDb, @Context HttpServletRequest request) throws JSONException, ITMException
	{
		E12ExtServiceUtility E12ExtServiceUtility = new E12ExtServiceUtility();
		String result = E12ExtServiceUtility.setToggleUserLock(tranId, enterprise, acctLock, transDb, request);
		return Response.status(200).entity( result ).build();
	}
	//END: Added by Arti: 09-Feb-23: For activate/deactivate the users 
	
	//START: Added by Arti: 06-Mar-23: For getting Enterprise from proteusvision.com
	@GET
	@Path("/getEnterpriseCode")
	public Response getEnterpriseCode( @QueryParam("userId") String userId, @QueryParam("usrLicType") String usrLicType,@QueryParam("tokenId") String tokenId, @QueryParam("appId") String appId,@QueryParam("endPoint") String endPoint,@Context HttpServletRequest request) throws JSONException, ITMException
	{
		String result="";
		boolean response = false;
		E12ExtServiceUtility E12ExtServiceUtility = new E12ExtServiceUtility();
		//Added by Vaishali Patil 10/07/23 [provision to add validation to validate appId][start]
		response = E12ExtServiceUtility.validateLLT(tokenId, appId, endPoint);
		if(response)
		{
		      result = E12ExtServiceUtility.getEnterpriseCode(userId, usrLicType, request);
		}
		//Added by Vaishali Patil 10/07/23 [provision to add validation to validate appId][end]
		return Response.status(200).entity( result ).build();
	}
	//END: Added by Arti: 06-Mar-23: For getting Enterprise from proteusvision.com
	
	@GET
	@Path("/LicUserCount")
	public Response getLicUserCount( @QueryParam("enterprise") String enterprise, @QueryParam("usrLicType") String usrLicType ) throws JSONException, ITMException
	{
		E12ExtServiceUtility E12ExtServiceUtility = new E12ExtServiceUtility();
		String result = E12ExtServiceUtility.getLicUserCount(enterprise, usrLicType);
		return Response.status(200).entity( result ).build();

	}
	
	// Added by Gagan B. on 08-JUN-2022 for getReport (GET) - [START]	
	@GET
	@Path("/getReport")
	@Produces(MediaType.APPLICATION_OCTET_STREAM)
	public Response getReportGET(@QueryParam("USER_CODE") String userCode, @QueryParam("OBJ_NAME") String objName,
			@QueryParam("REPORT_SAVE_TYPE") String docType, @QueryParam("ARGUMENT") String reportArgument,
			@QueryParam("TOKEN_ID") String tokenId, @Context HttpServletRequest request, @Context HttpServletResponse response ) throws BaseException, Exception
	{
		UserInfoBean userInfo = null;
		RestAPIServiceUtility restapiserviceutility = new RestAPIServiceUtility();
		String key = "a3edd11a09ea4e0ccd09c6cd2828021b";
		HashMap<String, String> jwtData = CryptographyUtil.parseBase64EncodedJWTToken( tokenId, key );
		userInfo = restapiserviceutility.createUserInfo( jwtData );
		
		BaseLogger.log("3", userInfo,null,"Inside getReportGET method GSB from E12ExtService...");
		File file = null;
		String filePath = null;
		// setting the values of variable here because they are essential for POJO and are not required from the user. 
		String backgrndProcess = "false";
		String deviceType = ""; // to check whether device is mobile.
		String fromSqlTimeOut = ""; // if sqlTimeOut error comes then it is set true in getReportErrorResponse method.
		String fromBackgrounServer = "false"; // to check whether file is to be downloaded in background or not.
		String browserType = null; // to check from where it is accessed, IE browser etc.
		String notifyBy = null; //used in various places like notifyUsers method to determine mode of notifying like email, sms etc.
		String remoteAddress = request.getRemoteAddr(); //for getting the remote address.
		String isExplore = ""; // to check the isExplore condition, if it is yes directly report is viewed by writing bytes there itself.
		boolean isConfirmReprint = false;
		try 
		{
			BaseLogger.log("3", userInfo,null,"Inside VIEW_REPORT GSB from E12ExtService 09082022...");
			ViewReport viewReport = new ViewReport();
			viewReport.getReport(docType, objName, backgrndProcess, deviceType, reportArgument, fromSqlTimeOut, fromBackgrounServer, userCode, isExplore, isConfirmReprint, browserType, notifyBy, remoteAddress);
			BaseLogger.log("3", userInfo,null,"Executed POJO from E12ExtService...");				
							
			filePath = viewReport.getFilePath();
			file = new File(filePath);
			BaseLogger.log("3", userInfo, null, "filePath:::["+ viewReport.getFilePath()  +"]");	
		}
		catch (Exception e) 
		{
			BaseLogger.log("0",null,null,"Exception: E12ExtService: getReportGET:==>\n"+e.getMessage());
		}
		if(filePath.length() < 0 || filePath.equals("") || filePath.equals(null) || file == null)
		{
			JSONObject resultJson = new JSONObject();
			resultJson.put( "status", "No data found!" );
			return Response.ok(resultJson, MediaType.APPLICATION_JSON)
					.header("Access-Control-Allow-Origin", "*")
					.header("Access-Control-Allow-Methods", "GET, POST, DELETE, PUT, OPTIONS, HEAD")
					.build();
		}
		
		E12ExtServiceUtility E12ExtServiceUtility = new E12ExtServiceUtility();
		E12ExtServiceUtility.writeAPICallLog("getReportGET ( /getReport )", null, null, null, request, userInfo);
		return Response.ok(file, MediaType.APPLICATION_OCTET_STREAM)
				.header("Access-Control-Allow-Origin", "*")
				.header("Access-Control-Allow-Methods", "GET, POST, DELETE, PUT, OPTIONS, HEAD")
				.header( "Content-disposition", "attachment; filename = \"" + file.getName().trim() + "\"")
				.build();
	
	}		
	// Added by Gagan B. on 08-JUN-2022 for getReport (GET) - [END]
				
				
	// Added by Gagan B. on 28-JUN-2022 for getReport (POST) - [START]	
	@POST
	@Path("/getReport")
	@Produces(MediaType.APPLICATION_OCTET_STREAM)
	public Response getReportPOST(@FormParam("USER_CODE") String userCode, @FormParam("OBJ_NAME") String objName,
	        @FormParam("REPORT_SAVE_TYPE") String docType, @FormParam("ARGUMENT") String reportArgument,
	        @HeaderParam("TOKEN_ID") String tokenIdHeader,
	        @FormParam("TOKEN_ID") String tokenIdBody,
	        @Context HttpServletRequest request, @Context HttpServletResponse response) throws BaseException, Exception {

	    String tokenId = tokenIdHeader != null ? tokenIdHeader : tokenIdBody;

	    UserInfoBean userInfo = null;
	    RestAPIServiceUtility restapiserviceutility = new RestAPIServiceUtility();
	    String key = "a3edd11a09ea4e0ccd09c6cd2828021b";
	    HashMap<String, String> jwtData = CryptographyUtil.parseBase64EncodedJWTToken(tokenId, key);
	    userInfo = restapiserviceutility.createUserInfo(jwtData);

	    BaseLogger.log("3", userInfo, null, "Inside getReportPOST method GSB from E12ExtService...");
	    File file = null;
	    String filePath = null;
	    // setting the values of variable here because they are essential for POJO and are not required from the user.
	    String backgrndProcess = "false";
	    String deviceType = ""; // to check whether the device is mobile.
	    String fromSqlTimeOut = ""; // if sqlTimeOut error comes then it is set true in getReportErrorResponse method.
	    String fromBackgrounServer = "false"; // to check whether the file is to be downloaded in the background or not.
	    String browserType = null; // to check from where it is accessed, IE browser, etc.
	    String notifyBy = null; // used in various places like notifyUsers method to determine the mode of notifying like email, SMS, etc.
	    String remoteAddress = request.getRemoteAddr(); // for getting the remote address.
	    String isExplore = ""; // to check the isExplore condition, if it is yes directly the report is viewed by writing bytes there itself.
	    boolean isConfirmReprint = false;
	    try {
	        BaseLogger.log("3", userInfo, null, "Inside VIEW_REPORT GSB from E12ExtService 09082022...");
	        ViewReport viewReport = new ViewReport();
	        viewReport.getReport(docType, objName, backgrndProcess, deviceType, reportArgument, fromSqlTimeOut, fromBackgrounServer, userCode, isExplore, isConfirmReprint, browserType, notifyBy, remoteAddress);
	        BaseLogger.log("3", userInfo, null, "Executed POJO from E12ExtService...");

	        filePath = viewReport.getFilePath();
	        file = new File(filePath);
	        BaseLogger.log("3", userInfo, null, "filePath:::[" + viewReport.getFilePath() + "]");
	    } catch (Exception e) {
	        BaseLogger.log("0", null, null, "Exception: E12ExtService: getReportGET:==>\n" + e.getMessage());
	    }
	    if (filePath.length() < 0 || filePath.equals("") || filePath.equals(null) || file == null) {
	        JSONObject resultJson = new JSONObject();
	        resultJson.put("status", "No data found!");
	        return Response.ok(resultJson, MediaType.APPLICATION_JSON)
	                .header("Access-Control-Allow-Origin", "*")
	                .header("Access-Control-Allow-Methods", "GET, POST, DELETE, PUT, OPTIONS, HEAD")
	                .build();
	    }

	    E12ExtServiceUtility E12ExtServiceUtility = new E12ExtServiceUtility();
	    E12ExtServiceUtility.writeAPICallLog("getReportGET ( /getReport )", null, null, null, request, userInfo);
	    return Response.ok(file, MediaType.APPLICATION_OCTET_STREAM)
	            .header("Access-Control-Allow-Origin", "*")
	            .header("Access-Control-Allow-Methods", "GET, POST, DELETE, PUT, OPTIONS, HEAD")
	            .header("Content-disposition", "attachment; filename = \"" + file.getName().trim() + "\"")
	            .build();
	}
		
	// Added by Gagan B. on 28-JUN-2022 for getReport (POST) - [END]
					

	//Added by Sainath T. on 01-NOV-2019[Jasper report related implementation] -Start
	/**
	 * Get Report Arguments
	 *
	 * @param obJName
	 * @param request
	 * @return
	 * @throws BaseException
	 * @throws Exception
	 */
	@GET
	@Path("/getReportArg")
	public Response getReportArg(@QueryParam("OBJ_NAME") String objName,
			@QueryParam("USER_CODE") String userCode, @QueryParam("PASSWORD") String password, @QueryParam("IS_PWD_ENCRYPT") String isPwdEncrypt,
			@QueryParam("TOKEN_ID") String tokenId, @QueryParam("DATA_FORMAT") String dataFormat, @QueryParam("APP_ID") String appId, 
			@Context HttpServletRequest request)  throws BaseException, Exception
	{
		E12ExtServiceUtility E12ExtServiceUtility = new E12ExtServiceUtility();
		String result = E12ExtServiceUtility.getReportArg(objName, userCode, password, isPwdEncrypt, tokenId, dataFormat, appId, request);
		return Response.status(200).entity( result ).build();
	}

	/**
	 * Get Report Arguments
	 *
	 * @param obJName
	 * @param request
	 * @return
	 * @throws BaseException
	 * @throws Exception
	 */
	@POST
	@Path("/getReportArg")
	public Response getReportArgClient(
	        @FormParam("OBJ_NAME") String objName,
	        @FormParam("USER_CODE") String userCode,
	        @FormParam("PASSWORD") String password,
	        @FormParam("IS_PWD_ENCRYPT") String isPwdEncrypt,
	        @FormParam("DATA_FORMAT") String dataFormat,
	        @HeaderParam("TOKEN_ID") String tokenIdHeader,
	        @FormParam("TOKEN_ID") String tokenIdBody,
	        @FormParam("APP_ID") String appId,
	        @Context HttpServletRequest request
	) throws BaseException, Exception {

	   
	    String tokenId = tokenIdHeader != null ? tokenIdHeader : tokenIdBody;

	    E12ExtServiceUtility E12ExtServiceUtility = new E12ExtServiceUtility();
	    String result = E12ExtServiceUtility.getReportArgClient(
	            objName, userCode, password, isPwdEncrypt, dataFormat, tokenId, appId, request);

	    return Response.status(200).entity(result).build();
	}


	/**
	 * Get Report Arguments
	 *
	 * @param obJName
	 * @param reportArgStr
	 * @return
	 * @throws BaseException
	 * @throws Exception
	 */
	@GET
	@Path("/executeReport")
	public Response executeReport(@QueryParam("OBJ_NAME") String objName, @QueryParam("REPORT_ARG_STR") String reportArgStr,
			@QueryParam("USER_CODE") String userCode, @QueryParam("PASSWORD") String password, @QueryParam("IS_PWD_ENCRYPT") String isPwdEncrypt,
			@QueryParam("DATA_FORMAT") String dataFormat, @QueryParam("TOKEN_ID") String tokenId, @QueryParam("APP_ID") String appId,
			@Context HttpServletRequest request, @Context HttpServletResponse response ) throws BaseException, Exception
	{
		E12ExtServiceUtility E12ExtServiceUtility = new E12ExtServiceUtility();
		String result = E12ExtServiceUtility.executeReport(objName, reportArgStr, userCode, password, isPwdEncrypt, dataFormat, tokenId, appId, request, response);
		return Response.status(200).entity( result ).build();
	}

	/**
	 * Get Report Arguments
	 *
	 * @param obJName
	 * @param reportArgStr
	 * @return
	 * @throws BaseException
	 * @throws Exception
	 */
	@POST
	@Path("/executeReport")
	public Response executeReportClient(
	        @FormParam("OBJ_NAME") String objName,
	        @FormParam("REPORT_ARG_STR") String reportArgStr,
	        @FormParam("USER_CODE") String userCode,
	        @FormParam("PASSWORD") String password,
	        @FormParam("IS_PWD_ENCRYPT") String isPwdEncrypt,
	        @FormParam("DATA_FORMAT") String dataFormat,
	        @HeaderParam("TOKEN_ID") String tokenIdHeader,
	        @FormParam("TOKEN_ID") String tokenIdBody,
	        @FormParam("APP_ID") String appId,
	        @Context HttpServletRequest request,
	        @Context HttpServletResponse response
	) throws BaseException, Exception {

	    String tokenId = tokenIdHeader != null ? tokenIdHeader : tokenIdBody;

	    E12ExtServiceUtility E12ExtServiceUtility = new E12ExtServiceUtility();
	    String result = E12ExtServiceUtility.executeReportClient(
	            objName, reportArgStr, userCode, password, isPwdEncrypt, dataFormat, tokenId, appId, request, response);

	    return Response.status(200).entity(result).build();
	}


	//Added by Saiprasad G on 16-MAR-2020[Mail Jasper Report] START
	@POST
	@Path("/executeReportSendMail")
	@Produces({ "application/json" })
	@Consumes({ "application/json" })
	public Response executeReportAndSendMail(String data,
			@Context HttpServletRequest request, @Context HttpServletResponse response ) throws BaseException, Exception
	{
		E12ExtServiceUtility E12ExtServiceUtility = new E12ExtServiceUtility();
		String result = E12ExtServiceUtility.executeReportAndSendMail(data, request, response);
		return Response.status(200).entity( result ).build();
	}
	//Added by Saiprasad G on 16-MAR-2020[Mail Jasper Report] END
	@GET
	@Path("/buildAngComponent")
	@Produces(MediaType.APPLICATION_JSON)
	public Response buildAngComponent(@QueryParam("objName") String objName,@Context HttpServletRequest request) throws BaseException, Exception
	{
		JSONObject resultJson = new JSONObject();
		try {
			HashMap<String, String> propEditorInfoMap = new HashMap<String,String>();
			HttpSession session = request.getSession();
			BaseLogger.log( "3", null, null, "23012023 session : ["+ session +"]" );
			if(session != null)
			{
				UserInfoBean userInfoBean = (UserInfoBean) session.getAttribute("USER_INFO");
				BaseLogger.log( "3", userInfoBean, null, "23012023 userInfoBean : ["+ userInfoBean +"]" );
				
				if(userInfoBean != null)
				{
					propEditorInfoMap.put("PROFILE_ID_RES", userInfoBean.getProfileIdRes());
					propEditorInfoMap.put("ENTERPRISE_ID_RES", userInfoBean.getEnterprise());
					propEditorInfoMap.put("USER_ID", userInfoBean.getLoginCode());
					BaseLogger.log( "3", userInfoBean, null, "23012023 propEditorInfoMap : ["+ propEditorInfoMap +"]" );
				}
				BuildAngularLayout angLayout = new BuildAngularLayout();
				angLayout.buildANGComponent(objName, propEditorInfoMap, userInfoBean);
				resultJson.put("result", "success");
			}
			
		} catch (Exception e) {
			resultJson.put("result", "failure");
			BaseLogger.log( "3", null, null, "23012023 Exception buildANgComponent : ["+ e.getMessage() +"]" );
			throw new BaseException(e);
		}
		return Response.status(200).entity( resultJson.toString() ).build();
	}
	
	
}
