/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.bean;

import ibase.system.config.AppConnectParm;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.ejb.MasterStatefulRemote;
import ibase.webitm.utility.ITMException;
import java.io.File;
import java.io.FileOutputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.naming.InitialContext;

public class MasterBean {
    public MasterStatefulRemote masterRem;
    protected InitialContext initialContext = null;
    protected UserInfoBean userInfo = null;
    protected String advQuery = null;
    protected String argId = null;
    protected String objName = "NA";
    protected String objContext = "0";
    protected String editFlag = "V";
    protected String pageContext = "1";
    protected String argFieldNames = null;
    protected String argFieldTypes = null;
    protected String argFieldValues = null;
    protected String actionXmlStr = null;
    protected ArrayList contextTitlesList = null;
    protected ArrayList actionTitlesList = null;
    protected ArrayList actionServiceCodeList = null;
    protected String user_lang = "en";
    protected String user_country = "US";
    private String editor = "WebEditor";

    public String getEditor() {
        return this.editor;
    }

    public void setEditor(String editor) {
        this.editor = editor;
    }

    public MasterBean() {
        try {
            BaseLogger.log("3", this.userInfo, null, "Calling set MasterBean");
            this.setInitialContext();
            this.setMasterBean();
        }
        catch (ITMException itme) {
            BaseLogger.log("0", this.userInfo, null, "ITMException: MasterBean: setMasterBean: ==>\n" + itme);
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception: MasterBean: setMasterBean: ==>\n" + e);
        }
    }

    private void setInitialContext() throws ITMException {
        try {
            AppConnectParm appConnect = new AppConnectParm();
            this.initialContext = new InitialContext(appConnect.getProperty());
        }
        catch (ITMException itme) {
            BaseLogger.log("0", this.userInfo, null, "ITMException :MasterBean :setInitialContext :");
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception :MasterBean :setInitialContext :");
            throw new ITMException(e);
        }
    }

    public void setMasterBean() throws ITMException {
        try {
            this.masterRem = (MasterStatefulRemote)this.initialContext.lookup("ibase/MasterStatefulEJB/remote");
            BaseLogger.log("3", this.userInfo, null, "MasterStatefulEJB Reference :" + this.masterRem);
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception: MasterBean: setMasterBean: In getting the Initial Context ==>\n" + e);
            throw new ITMException(e);
        }
    }

    public void setUserInfo(UserInfoBean userInfo) throws ITMException {
        try {
            this.userInfo = userInfo;
            this.masterRem.setUserInfo(this.userInfo);
        }
        catch (Exception e) {
            BaseLogger.log("0", userInfo, null, "Exception: MasterBean: setUserInfo: In setting userInfo ==>\n" + e);
            throw new ITMException(e);
        }
    }

    public void setObjName(String objName) throws ITMException {
        try {
            BaseLogger.log("3", this.userInfo, null, "Setting Object Name in MasterBean");
            this.objName = objName;
            this.setContextTitlesList(this.masterRem.getContextTitlesList(objName));
        }
        catch (ITMException itme) {
            BaseLogger.log("0", this.userInfo, null, "ITMException: MasterBean: setObjName: In getting the Initial Context ==>\n" + itme);
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception: MasterBean: setObjName: In getting the Initial Context ==>\n" + e);
            throw new ITMException(e);
        }
    }

    public String getObjName() {
        return this.objName;
    }

    public void setPageContext(String pageContext) {
        this.pageContext = pageContext;
    }

    public String getPageContext() {
        return this.pageContext;
    }

    public void setObjContext(String objContext) {
        this.objContext = objContext;
    }

    public String getObjContext() {
        return this.objContext;
    }

    public void setEditFlag(String editFlag) {
        if (editFlag != null && editFlag.length() > 0) {
            this.editFlag = editFlag;
        }
    }

    public String getEditFlag() {
        return this.editFlag;
    }

    public void setArgFieldNames(String argFieldNames) throws ITMException {
        try {
            if (argFieldNames != null && argFieldNames.length() > 0 && !argFieldNames.equalsIgnoreCase(this.getArgFieldNames())) {
                BaseLogger.log("3", this.userInfo, null, "Setting ArgField Names");
                this.argFieldNames = argFieldNames;
                this.masterRem.setArgFieldNames(argFieldNames);
            }
        }
        catch (ITMException itme) {
            BaseLogger.log("0", this.userInfo, null, "ITMException: MasterBean: setArgFieldNames: In getting the Initial Context ==>\n" + itme);
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception: MasterBean: setArgFieldNames: In getting the Initial Context ==>\n" + e);
            throw new ITMException(e);
        }
    }

    private String getArgFieldNames() {
        return this.argFieldNames;
    }

    public void setArgFieldTypes(String argFieldTypes) throws ITMException {
        BaseLogger.log("2", this.userInfo, null, "In setArgFieldTypes()..");
        try {
            if (argFieldTypes != null && argFieldTypes.length() > 0 && !argFieldTypes.equalsIgnoreCase(this.getArgFieldTypes())) {
                BaseLogger.log("3", this.userInfo, null, "Setting ArgField Types");
                this.argFieldTypes = argFieldTypes;
                this.masterRem.setArgFieldTypes(argFieldTypes);
            }
        }
        catch (ITMException itme) {
            BaseLogger.log("0", this.userInfo, null, "ITMException: MasterBean: setArgFieldTypes: In getting the Initial Context ==>\n" + itme);
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception: MasterBean: setArgFieldTypes: In getting the Initial Context ==>\n" + e);
            throw new ITMException(e);
        }
    }

    private String getArgFieldTypes() {
        return this.argFieldTypes;
    }

    public void setArgFieldValues(String argFieldValues) throws ITMException {
        try {
            if (argFieldValues != null && argFieldValues.length() > 0 && !argFieldValues.equals(this.getArgFieldValues())) {
                BaseLogger.log("3", this.userInfo, null, "setting ArgFieldValues . . . ");
                this.argFieldValues = argFieldValues;
                this.masterRem.setArgFieldValues(argFieldValues);
            }
        }
        catch (ITMException itme) {
            BaseLogger.log("0", this.userInfo, null, "ITMException: MasterBean: setArgFieldValues: In getting the Initial Context ==>\n");
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception: MasterBean: setArgFieldValues: In getting the Initial Context ==>\n" + e);
            throw new ITMException(e);
        }
    }

    public String getArgFieldValues() {
        return this.argFieldValues;
    }

    public void setAdvQuery(String advQuery) throws ITMException {
        try {
            if (advQuery != null && !advQuery.equalsIgnoreCase(this.getAdvQuery())) {
                this.advQuery = advQuery;
                this.masterRem.setAdvQuery(advQuery);
            }
        }
        catch (ITMException itme) {
            BaseLogger.log("0", this.userInfo, null, "ITMException: MasterBean: setAdvQuery: In getting the Initial Context ==>\n" + itme);
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception: MasterBean: setAdvQuery: In getting the Initial Context ==>\n" + e);
            throw new ITMException(e);
        }
    }

    public String getAdvQuery() {
        return this.advQuery;
    }

    public void setAccFilterQuery(String accFilterQuery) throws ITMException {
        try {
            BaseLogger.log("3", this.userInfo, null, "In MasterBean's setAccFilterQuery() with accFilter:" + accFilterQuery + ":");
            if (accFilterQuery != null) {
                this.masterRem.setAccFilterQuery(accFilterQuery);
            }
        }
        catch (ITMException itme) {
            BaseLogger.log("3", this.userInfo, null, "ITMException: MasterBean: setAccFilterQuery: ==>\n" + itme);
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("3", this.userInfo, null, "Exception: MasterBean: setAccFilterQuery: ==>\n" + e);
            throw new ITMException(e);
        }
    }

    private void setContextTitlesList(ArrayList contextTitlesList) throws ITMException {
        BaseLogger.log("3", this.userInfo, null, "Setting Context List");
        try {
            this.contextTitlesList = new ArrayList(contextTitlesList);
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception :MasterBean :setContextList :" + e);
            throw new ITMException(e);
        }
    }

    public ArrayList getContextTitlesList() throws ITMException {
        return this.contextTitlesList;
    }

    private String getDefaultPath() {
        String defaultPath = null;
        BaseLogger.log("2", this.userInfo, null, "CommonConstants.APPLICATION_CONTEXT :" + CommonConstants.APPLICATION_CONTEXT + ":");
        if (CommonConstants.APPLICATION_CONTEXT != null) {
            BaseLogger.log("3", this.userInfo, null, "In If");
            defaultPath = String.valueOf(CommonConstants.APPLICATION_CONTEXT) + "webitm" + File.separator;
        } else {
            BaseLogger.log("3", this.userInfo, null, "In ELse");
            defaultPath = ".." + File.separator + "webapps" + File.separator + "ibase" + File.separator + "webitm" + File.separator;
        }
        return defaultPath;
    }

    public String getXSL(String pageContext, String objContext, String editFlag) throws ITMException {
        String result = null;
        try {
            if (objContext != null) {
                this.setObjContext(objContext);
            }
            if (editFlag != null) {
                this.setEditFlag(editFlag);
            }
            if (pageContext != null) {
                this.setPageContext(pageContext);
            }
            result = this.getXSLFileName();
        }
        catch (ITMException itme) {
            BaseLogger.log("0", this.userInfo, null, "ITMException :MasterBean :getXSL==>");
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception :MasterBean :getXSL==>");
            throw new ITMException(e);
        }
        return result;
    }

    private String getXSLFileName() throws ITMException {
        String retFileName = null;
        try {
            String defaultPath = "";
            String fileName = String.valueOf(this.getObjName()) + this.getPageContext() + this.getObjContext() + "_" + this.user_lang + "_" + this.user_country + "_" + this.getEditFlag() + ".xsl";
            HashMap<String, String> propEditorInfoMap = new HashMap<String, String>();
            if (this.userInfo != null) {
                propEditorInfoMap.put("PROFILE_ID_RES", this.userInfo.getProfileIdRes());
                propEditorInfoMap.put("ENTERPRISE_ID_RES", this.userInfo.getEnterprise());
                propEditorInfoMap.put("USER_ID", this.userInfo.getLoginCode());
            }
            propEditorInfoMap.put("EDITOR", this.getEditor());
            defaultPath = new E12GenericUtility().getWebEditorXslPath(propEditorInfoMap, this.userInfo.getTransDB());
            File xslFile = new File(defaultPath, fileName);
            String profileIdRes = "";
            if (this.userInfo != null) {
                profileIdRes = this.userInfo.getProfileIdRes();
            }
            if (xslFile.exists()) {
                BaseLogger.log("3", this.userInfo, null, "XSL File Exists At :" + xslFile.getAbsolutePath());
                retFileName = xslFile.getName();
            } else {
                BaseLogger.log("3", this.userInfo, null, "XSL File doesn't Exist At :" + defaultPath + "xsl");
                this.masterRem.setEditor(this.getEditor());
                String xslString = this.masterRem.toXSL(this.getObjName(), this.getPageContext(), this.getObjContext(), this.getEditFlag(), CommonConstants.APPLICATION_CONTEXT, profileIdRes, this.userInfo.getTransDB());
                if (!xslString.endsWith(".xsl")) {
                    byte[] buffer = xslString.getBytes();
                    int bytes = buffer.length;
                    FileOutputStream fos = new FileOutputStream(xslFile);
                    fos.write(buffer, 0, bytes);
                    fos.flush();
                    fos.close();
                    fos = null;
                    retFileName = xslFile.getName();
                } else {
                    retFileName = xslString;
                }
            }
        }
        catch (ITMException itme) {
            BaseLogger.log("0", this.userInfo, null, "ITMException: MasterBean: getXSLFileName:==>" + itme);
            retFileName = null;
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception: MasterBean: getXSLFileName:==>" + e);
            retFileName = null;
            e.printStackTrace();
            throw new ITMException(e);
        }
        BaseLogger.log("2", this.userInfo, null, "Returning XSL File Name :" + retFileName);
        return retFileName;
    }

    public String getXSLForTax(String pageContext, String objContext, String editFlag) throws ITMException {
        String taxRetFileName = null;
        try {
            String taxXslString = null;
            String defaultPath = "";
            String taxFileName = "Taxtran_" + this.user_lang + "_" + this.user_country + "_" + editFlag + ".xsl";
            HashMap<String, String> propEditorInfoMap = new HashMap<String, String>();
            if (this.userInfo != null) {
                propEditorInfoMap.put("PROFILE_ID_RES", this.userInfo.getProfileIdRes());
                propEditorInfoMap.put("ENTERPRISE_ID_RES", this.userInfo.getEnterprise());
                propEditorInfoMap.put("USER_ID", this.userInfo.getLoginCode());
            }
            propEditorInfoMap.put("EDITOR", this.getEditor());
            defaultPath = new E12GenericUtility().getWebEditorXslPath(propEditorInfoMap, this.userInfo.getTransDB());
            File taxXslFile = new File(defaultPath, taxFileName);
            String profileIdRes = "";
            if (this.userInfo != null) {
                profileIdRes = this.userInfo.getProfileIdRes();
            }
            if (taxXslFile.exists()) {
                BaseLogger.log("3", this.userInfo, null, "TaxTRAN XSL File Exists At :" + taxXslFile.getAbsolutePath());
            } else {
                BaseLogger.log("3", this.userInfo, null, " Taxtran XSL File Doesn't Exist At :" + defaultPath + "xsl");
                this.masterRem.setEditor(this.getEditor());
                taxXslString = this.masterRem.toXSL("Taxtran", pageContext, objContext, editFlag, CommonConstants.APPLICATION_CONTEXT, profileIdRes, this.userInfo.getTransDB());
                byte[] bufferTax = taxXslString.getBytes();
                int bytesTax = bufferTax.length;
                FileOutputStream fosTax = new FileOutputStream(taxXslFile);
                fosTax.write(bufferTax, 0, bytesTax);
                fosTax.flush();
                fosTax.close();
                fosTax = null;
            }
            taxRetFileName = taxXslFile.getName();
        }
        catch (ITMException itme) {
            BaseLogger.log("0", this.userInfo, null, "ITMException: MasterBean: getXSLFileName:==>" + itme);
            taxRetFileName = null;
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception: MasterBean: getXSLFileName:==>" + e);
            taxRetFileName = null;
            e.printStackTrace();
            throw new ITMException(e);
        }
        return taxRetFileName;
    }

    public String getXML(String col_name, String order, String datatype, String domID, boolean refreshMode, boolean isAbort) throws RemoteException, ITMException {
        String retString = null;
        try {
            if (this.getPageContext().equalsIgnoreCase("1")) {
                retString = this.masterRem.getXMLDataForBrow(this.getObjContext(), refreshMode, col_name, order, datatype);
            } else if (this.getPageContext().equalsIgnoreCase("2")) {
                retString = this.masterRem.getXMLDataForDetail(this.getObjContext(), this.getEditFlag(), domID);
            }
        }
        catch (ITMException itme) {
            BaseLogger.log("0", this.userInfo, null, "ITMException: MasterBean: getXML: ==>");
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception: MasterBean: getXML: ==>");
            throw new ITMException(e);
        }
        BaseLogger.log("2", this.userInfo, null, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        return retString;
    }

    public String getTaxXML(String objContext, String domID) throws RemoteException, ITMException {
        String taxString = null;
        try {
            taxString = this.masterRem.getTaxXMLString(objContext, domID);
        }
        catch (ITMException itme) {
            BaseLogger.log("0", this.userInfo, null, "ITMException: MasterBean: getXML: ==>");
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception: MasterBean: getXML: ==>");
            throw new ITMException(e);
        }
        return taxString;
    }

    public ArrayList getServiceCodeList() {
        return this.actionServiceCodeList;
    }

    public String getDraftEditXml(String userID, String objName, String draftLineNo) throws ITMException {
        String retDraftEditXML = "";
        try {
            DBAccessEJB dbAccess = new DBAccessEJB();
            UserInfoBean userInfo = dbAccess.createUserInfo(userID);
            retDraftEditXML = dbAccess.getDraftEditXml(userID, objName, Integer.parseInt(draftLineNo), userInfo.toString());
            dbAccess = null;
        }
        catch (ITMException itme) {
            BaseLogger.log("0", this.userInfo, null, "ITMException :MasterBean :getDraftEditXml :==>" + itme.getMessage());
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception :MasterBean :getDraftEditXml :==>" + e.getMessage());
            throw new ITMException(e);
        }
        return retDraftEditXML;
    }
}

