
package ibase.webitm.ejb.wsfa.masters;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ibase.system.config.ConnDriver;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.utility.ITMException;


public class DndDealAprv implements DndDealAprvLocal,DndDealAprvRemote
{
	E12GenericUtility genericUtility = new E12GenericUtility();
	public String dndDealApprove(String tranID, String salesPers, String refSer,String userInfostr) throws ITMException
	{
		System.out.println("Inside dndDealApprove()....." );
		String sql = "";
		PreparedStatement pStmt = null;
		ResultSet rs = null;
		String retString = "";
		String reportTo = "";

		ConnDriver connDriver = null;
		Connection conn = null;

		boolean isError = false;

		try
		{
			UserInfoBean userInfo = new UserInfoBean(userInfostr);
			if( userInfo != null && userInfo.getTransDB() != null )
			{
				String transDB = E12GenericUtility.checkNull( userInfo.getTransDB() );
				connDriver = new ConnDriver();
				conn = connDriver.getConnectDB(transDB);
			}
			conn.setAutoCommit(false);
			connDriver = null;
			System.out.println("\nTRAN_ID = ["+tranID+"]SALES_PERS=["+salesPers+"]");

			//String getReportToSql = "SELECT REPORT_TO FROM EMPLOYEE WHERE EMP_CODE = ?";
			String getReportToSql = "select report_to from employee where emp_code = ( select report_to from employee where emp_code=? )";// Changed by Sachin Satre on [21-Jan-19]
			pStmt = conn.prepareStatement(getReportToSql);
			pStmt.setString(1, salesPers);
			rs = pStmt.executeQuery();
			if(rs.next())
			{
				reportTo = checkNull(rs.getString("REPORT_TO"));
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pStmt != null)
			{
				pStmt.close();
				pStmt = null;
			}

			System.out.println("reportTo =["+reportTo+"]");
			
			DateFormat dtFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
			java.util.Date date = Calendar.getInstance().getTime();
			String currDate = dtFormat.format( date );
			currDate = genericUtility.getValidDateTimeString( currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
			
			String updStrgCustSql = "UPDATE DND_DEAL SET APRV_STAT = 'A', EMP_CODE__APRV = ? ,STATUS_DATE = ? WHERE TRAN_ID = ? ";

			pStmt = conn.prepareStatement(updStrgCustSql);
			pStmt.setString(1, reportTo);
			pStmt.setTimestamp(2,java.sql.Timestamp.valueOf(currDate));
			pStmt.setString(3, tranID);
			int updCnt = pStmt.executeUpdate();
			if(pStmt != null)
			{
				pStmt.close();
				pStmt = null;
			}

			System.out.println("updCnt[dndDealApprove] =["+updCnt+"]");
		}
		catch (Exception e)
		{
			isError = true;
			try
			{
				conn.rollback();
			}
			catch(Exception ee)
			{

			}
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if(pStmt != null )
				{
					pStmt.close();
					pStmt = null;
				}
				if(conn != null )
				{
					if(!isError)
					{
						conn.commit();
					}
					conn.close();
					conn = null;
				}

			}
			catch(Exception e)
			{
				System.out.println( "Exception dndDealApprove(String) :==>\n"+e.getMessage());
			}
		}

		return retString;
	}
	public String dndDealReject(String tranID, String salesPers, String refSer,String userInfostr , String xmlString) throws ITMException
	{
		System.out.println("Inside dndDealReject()......["+xmlString+"]" );
		String sql = "";
		PreparedStatement pStmt = null;
		ResultSet rs = null;
		String retString = "";

		ConnDriver connDriver = null;
		Connection conn = null;

		String signRemarks = "";
		boolean isError = false;
		//Added by Sachin Satre on [21-Jan-19] start
		NodeList parentNodeList = null;
		Node parentNode = null;
		NodeList childNodeList = null;
		int childNodeListLength = 0;
		Node childNode = null;
		String childNodeName = "";
        Element nodeElement = null;
		int parentNodeListLength = 0;
		Document dom =null;
		String signRemarkNew = "";
		//Added by Sachin Satre on [21-Jan-19] end
		try
		{
			//Added by Sachin Satre on [21-Jan-19] start
			if (xmlString.trim().length() > 0 )
			{
				dom = genericUtility.parseString(xmlString);
			}
			parentNodeList = dom.getElementsByTagName("WRKFLW_REMARKS");
			parentNodeListLength = parentNodeList.getLength(); 
			System.out.println(":::WRKFLW_REMARKS>>::"+parentNodeListLength);
			for (int selectedRow = 0; selectedRow < parentNodeListLength; selectedRow++)
			{				
				parentNode = parentNodeList.item(selectedRow);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				System.out.println("WRKFLW_REMARKS .....childNodeListLength::: sasa>>>"+ childNodeListLength+"\n");
				
				for (int childRow = 0; childRow < childNodeListLength; childRow++)
				{
					System.out.println("childNodeListLengthchildNodeListLength:sdfds:"+ childNodeListLength);
					childNode = childNodeList.item(childRow);
					childNodeName = childNode.getNodeName();
					System.out.println("childNodeName::["+childNodeName+"]");
					genericUtility.removeWhitespaceInner(childNode, null);
					if (childNodeName.equalsIgnoreCase("REMARKS"))
					{
						if(childNode.getFirstChild()!=null)
						{
							signRemarkNew = childNode.getFirstChild().getNodeValue();
						}
						System.out.println("REMARKS::["+signRemarkNew+"]");
					}
					
				} 
			}
			System.out.println("signRemarkNew::["+signRemarkNew+"]");
			//Added by Sachin Satre on [21-Jan-19] end
			
			UserInfoBean userInfo = new UserInfoBean(userInfostr);

			if( userInfo != null && userInfo.getTransDB() != null )
			{
				String transDB = E12GenericUtility.checkNull( userInfo.getTransDB() );
				connDriver = new ConnDriver();
				conn = connDriver.getConnectDB(transDB);
			}
			conn.setAutoCommit(false);
			connDriver = null;

			String getReportToSql = "SELECT SIGN_REMARKS FROM OBJ_SIGN_TRANS WHERE REF_SER = ? AND REF_ID = ? ";
			pStmt = conn.prepareStatement(getReportToSql);
			pStmt.setString(1, refSer);
			pStmt.setString(2, tranID);
			rs = pStmt.executeQuery();
			if(rs.next())
			{
				signRemarks = checkNull(rs.getString("SIGN_REMARKS"));
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pStmt != null)
			{
				pStmt.close();
				pStmt = null;
			}
			
			System.out.println("signRemarks =["+signRemarks+"]");

			String updStrgCustSql = "UPDATE DND_DEAL SET APRV_STAT = 'R', REMARKS = ? WHERE TRAN_ID = ? ";

			pStmt = conn.prepareStatement(updStrgCustSql);
			//pStmt.setString(1, signRemarks);
			pStmt.setString(1, signRemarkNew);// Changed by Sachin Satre on [21-Jan-19]
			pStmt.setString(2, tranID);
			int updCnt = pStmt.executeUpdate();
			if(pStmt != null)
			{
				pStmt.close();
				pStmt = null;
			}
			System.out.println("updCnt>>>["+updCnt+"]");

		}
		catch (Exception e)
		{
			isError = true;
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if(pStmt != null )
				{
					pStmt.close();
					pStmt = null;
				}
				if(conn != null )
				{
					if(!isError)
					{
						conn.commit();
					}
					conn.close();
					conn = null;
				}

			}
			catch(Exception e)
			{
				System.out.println( "Exception dndDealReject(String) :==>\n"+e.getMessage());
			}
		}

		return retString;
	}
	
	public String checkNull(String input)
	{
		if (input == null || "null".equalsIgnoreCase(input))
		{
			input= "";
		}
		return input.trim();
	}
}
