/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.ejb;

import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.ejb.DBAccessLocal;
import ibase.webitm.ejb.ITMActionsLocal;
import ibase.webitm.ejb.ITMActionsRemote;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import javax.annotation.Resource;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.naming.InitialContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Stateless
public class ITMActionsEJB
implements ITMActionsRemote,
ITMActionsLocal {
    SessionContext cSessionContext;
    String actionStr = "";
    public DBAccessLocal ejbObj = null;
    @Resource
    private SessionContext sessionContext;

    public void ejbCreate() {
    }

    public void ejbRemove() {
    }

    public void ejbActivate() {
    }

    public void ejbPassivate() {
    }

    @Override
    public String getFilteredActions(String objName, String objContext, String editFlag, String profileId, String userLevel, String objType, UserInfoBean userInfo) throws RemoteException, ITMException {
        String filteredActionStr = "";
        try {
            profileId = userInfo.getProfileId();
            userLevel = userInfo.getUserLevel();
            int contextTitlesListLen = this.getContextSize(objName, userInfo);
            String actionXmlStr = this.getAllActionsString(objName, profileId, userLevel, userInfo);
            Object transDB = null;
            E12GenericUtility genericUtility = new E12GenericUtility();
            Document allActionDom = genericUtility.parseString(actionXmlStr);
            Document filteredDom = genericUtility.parseString("<ACTIONS></ACTIONS>");
            if (Integer.parseInt(objContext) != 0) {
                Element serviceCodeElement;
                NodeList actnNodeChildList = allActionDom.getElementsByTagName("action");
                int noOfActions = actnNodeChildList.getLength();
                BaseLogger.log("3", userInfo, null, "No. of Actions in All Action Dom :[" + noOfActions + "]");
                ArrayList<Node> selectedNodesList = new ArrayList<Node>();
                int addIndex = -1;
                int editIndex = -1;
                int delIndex = -1;
                int saveIndex = -1;
                int actCtr = 0;
                while (actCtr < noOfActions) {
                    Node currActionNode = actnNodeChildList.item(actCtr);
                    if (currActionNode != null) {
                        String valActionObjContext = currActionNode.getAttributes().getNamedItem("obj_context").getNodeValue();
                        String valActionId = currActionNode.getAttributes().getNamedItem("id").getNodeValue();
                        if (valActionId.equalsIgnoreCase("A")) {
                            selectedNodesList.add(currActionNode);
                            addIndex = selectedNodesList.size() - 1;
                        } else if (valActionId.equalsIgnoreCase("E")) {
                            selectedNodesList.add(currActionNode);
                            editIndex = selectedNodesList.size() - 1;
                        } else if (valActionId.equalsIgnoreCase("D")) {
                            selectedNodesList.add(currActionNode);
                            delIndex = selectedNodesList.size() - 1;
                        } else if (valActionId.equalsIgnoreCase("S") && objType.equalsIgnoreCase("P")) {
                            selectedNodesList.add(currActionNode);
                            saveIndex = selectedNodesList.size() - 1;
                        } else if (!"V".equalsIgnoreCase(editFlag) && objContext.equals(valActionObjContext)) {
                            selectedNodesList.add(currActionNode);
                        }
                    }
                    ++actCtr;
                }
                BaseLogger.log("3", userInfo, null, "addIndex :[" + addIndex + "] editIndex :[" + editIndex + "]");
                BaseLogger.log("3", userInfo, null, "selectedNodesList :" + selectedNodesList);
                if (Integer.parseInt(objContext) == 1) {
                    if (!objType.equalsIgnoreCase("P")) {
                        Element viewElement = filteredDom.createElement("action");
                        viewElement.setAttribute("id", "V");
                        viewElement.setAttribute("enabled", "1");
                        viewElement.setAttribute("title", "View");
                        viewElement.setAttribute("interactive", "a");
                        viewElement.setAttribute("image", "vdata~normal.gif");
                        viewElement.setAttribute("action_type", "S");
                        viewElement.setAttribute("obj_context", "1");
                        viewElement.setAttribute("service_handler", "0");
                        viewElement.setAttribute("placement", "0");
                        serviceCodeElement = filteredDom.createElement("service_code");
                        serviceCodeElement.setAttribute("cmpType", "");
                        serviceCodeElement.setAttribute("cmpName", "");
                        serviceCodeElement.setAttribute("metName", "");
                        serviceCodeElement.setAttribute("cmpType", "");
                        serviceCodeElement.setAttribute("argVal", "");
                        serviceCodeElement.appendChild(filteredDom.createCDATASection("V"));
                        viewElement.appendChild(serviceCodeElement);
                        filteredDom.getDocumentElement().appendChild(viewElement);
                    } else {
                        Element viewElement = filteredDom.createElement("action");
                        serviceCodeElement = filteredDom.createElement("service_code");
                        boolean isViewAction = this.getViewActionForProcess(objName, userInfo);
                        if (isViewAction) {
                            viewElement.setAttribute("id", "G");
                            viewElement.setAttribute("enabled", "1");
                            viewElement.setAttribute("title", "View");
                            viewElement.setAttribute("interactive", "a");
                            viewElement.setAttribute("image", "vdata~normal.gif");
                            viewElement.setAttribute("action_type", "S");
                            viewElement.setAttribute("obj_context", "1");
                            viewElement.setAttribute("service_handler", "0");
                            viewElement.setAttribute("placement", "0");
                            serviceCodeElement.setAttribute("cmpType", "");
                            serviceCodeElement.setAttribute("cmpName", "");
                            serviceCodeElement.setAttribute("metName", "");
                            serviceCodeElement.setAttribute("cmpType", "");
                            serviceCodeElement.setAttribute("argVal", "");
                            serviceCodeElement.appendChild(filteredDom.createCDATASection("V"));
                            viewElement.appendChild(serviceCodeElement);
                            filteredDom.getDocumentElement().appendChild(viewElement);
                            viewElement = filteredDom.createElement("action");
                            serviceCodeElement = filteredDom.createElement("service_code");
                        }
                        viewElement.setAttribute("id", "P");
                        viewElement.setAttribute("enabled", "1");
                        viewElement.setAttribute("title", "process");
                        viewElement.setAttribute("interactive", "a");
                        viewElement.setAttribute("image", "process~normal.gif");
                        viewElement.setAttribute("action_type", "S");
                        viewElement.setAttribute("obj_context", "1");
                        viewElement.setAttribute("service_handler", "0");
                        viewElement.setAttribute("placement", "0");
                        serviceCodeElement.setAttribute("cmpType", "");
                        serviceCodeElement.setAttribute("cmpName", "");
                        serviceCodeElement.setAttribute("metName", "");
                        serviceCodeElement.setAttribute("cmpType", "");
                        serviceCodeElement.setAttribute("argVal", "");
                        serviceCodeElement.appendChild(filteredDom.createCDATASection("P"));
                        viewElement.appendChild(serviceCodeElement);
                        filteredDom.getDocumentElement().appendChild(viewElement);
                    }
                } else if (!("V".equalsIgnoreCase(editFlag) || addIndex == -1 && editIndex == -1)) {
                    if (addIndex != -1) {
                        Node toAppendNode = (Node)selectedNodesList.get(addIndex);
                        ((Element)toAppendNode).setAttribute("obj_context", objContext);
                        Node importedNode = filteredDom.importNode(toAppendNode, true);
                        filteredDom.getDocumentElement().appendChild(importedNode);
                    }
                    Element viewElement = filteredDom.createElement("action");
                    serviceCodeElement = filteredDom.createElement("service_code");
                    viewElement.setAttribute("id", "D");
                    viewElement.setAttribute("enabled", "1");
                    viewElement.setAttribute("title", "delete");
                    viewElement.setAttribute("interactive", "a");
                    viewElement.setAttribute("image", "delete~normal.gif");
                    viewElement.setAttribute("action_type", "S");
                    viewElement.setAttribute("obj_context", objContext);
                    viewElement.setAttribute("service_handler", "0");
                    viewElement.setAttribute("placement", "0");
                    serviceCodeElement.setAttribute("cmpType", "");
                    serviceCodeElement.setAttribute("cmpName", "");
                    serviceCodeElement.setAttribute("metName", "");
                    serviceCodeElement.setAttribute("cmpType", "");
                    serviceCodeElement.setAttribute("argVal", "");
                    viewElement.appendChild(serviceCodeElement);
                    filteredDom.getDocumentElement().appendChild(viewElement);
                }
                int noOfSelNodes = selectedNodesList.size();
                int selActCtr = 0;
                while (selActCtr < noOfSelNodes) {
                    if (Integer.parseInt(objContext) == 1 || selActCtr != addIndex && selActCtr != editIndex && selActCtr != delIndex) {
                        Node toAppendNode = (Node)selectedNodesList.get(selActCtr);
                        Node importedNode = filteredDom.importNode(toAppendNode, true);
                        filteredDom.getDocumentElement().appendChild(importedNode);
                    }
                    ++selActCtr;
                }
                filteredActionStr = genericUtility.serializeDom(filteredDom);
            }
        }
        catch (ITMException itme) {
            throw itme;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ITMException(e);
        }
        BaseLogger.log("2", userInfo, null, "Returning Filtered Action String :[" + filteredActionStr + "]");
        return filteredActionStr;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getAllActionsString(String objName, String profileID, String userLevel, UserInfoBean userInfo) throws ITMException {
        Connection mConnection = null;
        Statement mStmt = null;
        ResultSet mRs = null;
        StringBuffer allActStrBuff = new StringBuffer("<ACTIONS>");
        String mQuery = null;
        String mQuery1 = null;
        String strRights = "";
        String compName = "";
        String compType = "";
        String methodName = "";
        String transDB = "";
        boolean isSysTypeOverwritten = false;
        try {
            try {
                AppConnectParm appConnect = new AppConnectParm();
                Properties p = appConnect.getProperty();
                InitialContext ctx = new InitialContext(p);
                this.ejbObj = new DBAccessEJB();
                String tableName = "OBJ_FORMS";
                String columnName = "max(CAST(form_no AS INT)) ~AS~ max_form_no";
                String winName = "w_" + objName.trim();
                String condition = "win_name = '" + winName + "'";
                String noOfForms = this.ejbObj.getDBColumnValue(tableName, columnName, condition, userInfo.getTransDB());
                int totForms = 0;
                if (!"".equalsIgnoreCase(noOfForms)) {
                    totForms = Integer.parseInt(noOfForms);
                }
                BaseLogger.log("3", userInfo, null, "noOfForms [" + noOfForms + "] totForms [" + totForms + "]");
                transDB = userInfo.getTransDB();
                ConnDriver mConnDriver = new ConnDriver();
                mConnection = mConnDriver.getConnectDB(transDB);
                if ("0".equals(userLevel)) {
                    strRights = "*";
                } else {
                    mQuery1 = "SELECT RIGHTS FROM USER_RIGHTS WHERE PROFILE_ID IN " + E12GenericUtility.getFormattedProfileId(profileID) + " AND OBJ_NAME ='" + objName + "'";
                    mStmt = mConnection.createStatement();
                    mRs = mStmt.executeQuery(mQuery1);
                    while (mRs.next()) {
                        strRights = String.valueOf(strRights) + mRs.getString("RIGHTS");
                    }
                    mRs.close();
                    mStmt.close();
                    mStmt = null;
                }
                if (strRights != null && strRights.length() > 0) {
                    if ((strRights.indexOf("A") != -1 || strRights.indexOf("E") != -1) && strRights.indexOf("S") == -1) {
                        strRights = String.valueOf(strRights) + "S";
                    }
                    mQuery = "SELECT FORM_NO, RIGHTS_CHAR, TITLE, INTERACTIVE, SERVICE_CODE, IMAGE, SERVICE_HANDLER, PLACEMENT, ACTION_TYPE FROM OBJ_ACTIONS WHERE OBJ_NAME='" + objName + "' ORDER BY ACTION_TYPE, LINE_NO ";
                    mStmt = mConnection.createStatement();
                    mRs = mStmt.executeQuery(mQuery);
                    while (mRs.next()) {
                        String formNo = mRs.getString("FORM_NO");
                        String rightsChar = mRs.getString("RIGHTS_CHAR");
                        String title = mRs.getString("TITLE");
                        String interactive = mRs.getString("INTERACTIVE");
                        String serviceCode = mRs.getString("SERVICE_CODE");
                        String image = mRs.getString("IMAGE");
                        String serviceHandler = mRs.getString("SERVICE_HANDLER");
                        String placement = mRs.getString("PLACEMENT");
                        String actionType = mRs.getString("ACTION_TYPE");
                        serviceHandler = serviceHandler == null || "NULL".equalsIgnoreCase(serviceHandler) ? "0" : serviceHandler;
                        placement = placement == null || "NULL".equalsIgnoreCase(placement) ? "0" : placement;
                        Statement stmt = null;
                        ResultSet rs = null;
                        String query = "";
                        String argValue = "";
                        int currentForm = Integer.parseInt(formNo);
                        if (currentForm > totForms) continue;
                        if (serviceHandler != null && (serviceHandler.equals("1") || serviceHandler.equals("2"))) {
                            if (serviceCode == null || serviceCode.length() <= 0) throw new Exception("Invalid Service Code :[" + serviceCode + "] in OBJ_ACTIONS Cannot be empty");
                            query = "SELECT A.COMP_TYPE, A.COMP_NAME, B.SERVICE_URI, B.METHOD_NAME FROM SYSTEM_EVENTS A, SYSTEM_EVENT_SERVICES B WHERE A.SERVICE_CODE=B.SERVICE_CODE AND A.OBJ_NAME='" + objName + "' AND A.EVENT_CODE='" + serviceCode + "'";
                            stmt = mConnection.createStatement();
                            rs = stmt.executeQuery(query);
                            while (rs.next()) {
                                compType = rs.getString("COMP_TYPE");
                                compName = rs.getString("COMP_NAME");
                                serviceCode = rs.getString("SERVICE_URI");
                                methodName = rs.getString("METHOD_NAME");
                            }
                            if (rs != null) {
                                rs.close();
                                rs = null;
                            }
                            if (stmt != null) {
                                stmt.close();
                                stmt = null;
                            }
                            if (serviceCode == null || serviceCode.length() <= 0) throw new Exception("Invalid Service Code :[" + serviceCode + "] in SYSTEM_EVENT_SERVICES Cannot be empty");
                            if (!serviceCode.startsWith("http")) {
                                if (CommonConstants.TOMCAT_HOME == null || CommonConstants.TOMCAT_HOME.length() == 0) {
                                    CommonConstants.setIBASEHOME();
                                }
                                if (serviceCode.indexOf(".jsp") <= 0) {
                                    serviceCode = String.valueOf(CommonConstants.TOMCAT_HOME) + serviceCode;
                                } else if (!serviceCode.contains(".asmx")) {
                                    serviceCode = String.valueOf(CommonConstants.TOMCAT_HOME) + "/ibase/" + "webitm" + "/jsp/" + serviceCode;
                                }
                            }
                        } else if (serviceHandler != null && serviceHandler.equals("5")) {
                            if (serviceCode == null || serviceCode.length() <= 0) throw new Exception("Invalid Service Code :[" + serviceCode + "] in OBJ_ACTIONS Cannot be empty");
                            query = "SELECT B.ARG_VALUE FROM SYSTEM_EVENTS A, SYSTEM_SERVICE_ARGS B WHERE A.SERVICE_CODE=B.SERVICE_CODE AND A.OBJ_NAME='" + objName + "' AND A.EVENT_CODE='" + serviceCode + "' AND B.ARG_MODE='F'";
                            stmt = mConnection.createStatement();
                            rs = stmt.executeQuery(query);
                            if (rs.next()) {
                                argValue = rs.getString("ARG_VALUE");
                            }
                            rs.close();
                            stmt.close();
                        }
                        if (strRights.indexOf(rightsChar) == -1 && strRights.indexOf("*") == -1) continue;
                        allActStrBuff.append("\n<action id='" + rightsChar + "' enabled='1' title ='" + title + "' interactive='" + interactive + "' image='" + image + "' action_type='" + actionType + "' obj_context='" + (actionType.equalsIgnoreCase("S") ? "1" : formNo) + "' service_handler='" + serviceHandler + "' placement='" + placement + "'>");
                        allActStrBuff.append("<service_code cmpType='" + compType + "' cmpName='" + compName + "' metName='" + methodName + "' argVal='" + argValue + "'><![CDATA[" + serviceCode + "]]></service_code>");
                        allActStrBuff.append("</action>");
                    }
                    mRs.close();
                    mStmt.close();
                    mStmt = null;
                    allActStrBuff.append("\n</ACTIONS>");
                    return allActStrBuff.toString();
                } else {
                    allActStrBuff.append("\n</ACTIONS>");
                    BaseLogger.log("3", userInfo, null, "No rights defined for profileID [" + profileID + "] for OBJ_NAME [" + objName + "]");
                }
                return allActStrBuff.toString();
            }
            catch (ITMException itme) {
                System.err.println("ITMException: ITMActionsEJB: getAllActionsString:");
                throw itme;
            }
            catch (Exception e) {
                System.err.println("Exception: ITMActionsEJB: getAllActionsString:" + e);
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (mConnection != null) {
                    if (mStmt != null) {
                        mStmt.close();
                        mStmt = null;
                    }
                    mConnection.close();
                    mConnection = null;
                }
            }
            catch (Exception e) {
                System.err.println("Exception: DBAccess: getAllActionsString \n" + e);
                throw new ITMException(e);
            }
        }
    }

    private boolean getViewActionForProcess(String objName, UserInfoBean userInfo) throws ITMException {
        Connection mConnection = null;
        Statement mStmt = null;
        ResultSet mRs = null;
        String mQuery = null;
        boolean isViewAction = false;
        String transDB = null;
        try {
            try {
                transDB = userInfo.getTransDB();
                ConnDriver mConnDriver = new ConnDriver();
                mConnection = mConnDriver.getConnectDB(transDB);
                mQuery = "SELECT RIGHTS_CHAR FROM OBJ_ACTIONS WHERE OBJ_NAME='" + objName + "' ORDER BY LINE_NO ";
                mStmt = mConnection.createStatement();
                mRs = mStmt.executeQuery(mQuery);
                while (mRs.next()) {
                    if (!mRs.getString("RIGHTS_CHAR").equalsIgnoreCase("V")) continue;
                    isViewAction = true;
                }
                mRs.close();
                mRs = null;
                mStmt.close();
                mStmt = null;
            }
            catch (ITMException itme) {
                System.err.println("ITMException: ITMActionsEJB: getViewActionForProcess:");
                throw itme;
            }
            catch (Exception e) {
                System.err.println("Exception: ITMActionsEJB: getViewActionForProcess:" + e);
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (mConnection != null) {
                    if (mStmt != null) {
                        mStmt.close();
                        mStmt = null;
                    }
                    mConnection.close();
                    mConnection = null;
                }
            }
            catch (Exception e) {
                System.err.println("Exception: DBAccess: getViewActionForProcess \n" + e);
                throw new ITMException(e);
            }
        }
        System.err.println("getViewActionForProcess:: isViewAction::[" + isViewAction + "]");
        return isViewAction;
    }

    @Override
    public int getContextSize(String objName, UserInfoBean userInfo) throws ITMException {
        BaseLogger.log("2", userInfo, null, "Getting Context size for objName :[" + objName + "]");
        int noOfForms = 0;
        try {
            AppConnectParm appConnect = new AppConnectParm();
            Properties p = appConnect.getProperty();
            InitialContext ctx = new InitialContext(p);
            this.ejbObj = new DBAccessEJB();
            ArrayList objFormsDetailList = this.ejbObj.getObjFormsDetailList(objName, userInfo);
            noOfForms = objFormsDetailList.size();
        }
        catch (ITMException itme) {
            throw itme;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ITMException(e);
        }
        BaseLogger.log("2", userInfo, null, "Returning Context size for objName :[" + objName + "] noOfForms :[" + noOfForms + "]");
        return noOfForms;
    }
}

