/*
 * Decompiled with CFR 0.152.
 */
package ibase.webService;

import ibase.hibernate.bean.PlaceTimeEntity;
import ibase.hibernate.dao.EntityDAO;
import ibase.hibernate.dao.PlaceTimeEntityDAO;
import ibase.system.config.AppConnectParm;
import ibase.utility.BaseException;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.notification.ejb.PublishPushNotificationEJB;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.InitialContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.json.JSONArray;
import org.json.XML;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Path(value="/PTEService")
public class PTEService {
    @GET
    @Path(value="/getAllPTEData")
    @Produces(value={"application/json"})
    public Response getAllPTEData(@Context HttpServletRequest request) throws Exception {
        org.json.JSONObject resultJson = new org.json.JSONObject();
        String authStatus = "";
        UserInfoBean userInfo = (UserInfoBean)request.getSession().getAttribute("USER_INFO");
        BaseLogger.log((String)"2", null, null, (Object)("In getAllPTEData method:userInfo:" + userInfo));
        if (userInfo != null) {
            authStatus = "VALID";
        }
        if ("VALID".equalsIgnoreCase(authStatus)) {
            List placeTimeEntityList = new ArrayList();
            JSONArray objActionArray = new JSONArray();
            try {
                BaseLogger.log((String)"3", null, null, (Object)"In getAllPTEData method!!!!!!!!!!!");
                PlaceTimeEntityDAO placeTimeEntityDAO = new PlaceTimeEntityDAO(userInfo);
                placeTimeEntityList = placeTimeEntityDAO.getAllPteData();
                objActionArray = placeTimeEntityDAO.getUserActions(userInfo);
                for (PlaceTimeEntity placeTimeEntity : placeTimeEntityList) {
                    String entityDescr = this.getEntityName(placeTimeEntity.getEntityType(), placeTimeEntity.getEntityCode(), userInfo);
                    placeTimeEntity.setEntityDescr(entityDescr);
                    BaseLogger.log((String)"3", null, null, (Object)("getAllPTEData::::" + placeTimeEntity.toString()));
                    String objName = placeTimeEntity.getEntityCode().trim();
                    String fldValue = placeTimeEntity.getEntityCode().trim();
                    String altFldValue = placeTimeEntity.getEntityDescr().trim();
                    String object = this.getObject(placeTimeEntity.getEntityType());
                    BaseLogger.log((String)"3", null, null, (Object)("objName" + objName + "fldValue" + fldValue + "altFldValue" + altFldValue + "object" + object));
                    String userImagePath = "";
                    userImagePath = "H".equalsIgnoreCase(placeTimeEntity.getEntityType()) ? this.getUserImageURL(userInfo) : this.getCustomImageURL(objName, fldValue, altFldValue, object);
                    BaseLogger.log((String)"3", null, null, (Object)("userImagePath in   getAllPTEData " + userImagePath));
                    placeTimeEntity.setImgUrl(userImagePath);
                    BaseLogger.log((String)"3", null, null, (Object)("getAllPTEData in DAO::::" + placeTimeEntity.toString()));
                }
                BaseLogger.log((String)"3", null, null, (Object)("In getAllPTEData method!!!!!!!!!!!placeTimeEntityList => " + placeTimeEntityList));
            }
            catch (Exception e) {
                BaseLogger.log((String)"0", null, null, (Object)("In PTEService :: getAllPTEData : " + e.getMessage()));
                e.printStackTrace();
                throw new Exception(e);
            }
            resultJson.put("status", placeTimeEntityList);
            resultJson.put("userRights", (Object)objActionArray);
        } else {
            resultJson.put("status", (Object)"error");
        }
        return Response.status((int)200).entity((Object)resultJson.toString()).build();
    }

    @POST
    @Path(value="/savePTEData/{ismobile}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response savePTEData(@PathParam(value="ismobile") Boolean isMobileApk, PlaceTimeEntity placeTimeEntity, @Context HttpServletRequest request) throws Exception {
        BaseLogger.log((String)"2", null, null, (Object)("===IN savePTEData method === > " + isMobileApk + " placeTimeEntity [" + placeTimeEntity + "] request[" + request + "]"));
        org.json.JSONObject resultJson = new org.json.JSONObject();
        String authStatus = "";
        String editFlag = "A";
        UserInfoBean userInfo = (UserInfoBean)request.getSession().getAttribute("USER_INFO");
        if (userInfo != null) {
            authStatus = "VALID";
        }
        if ("VALID".equalsIgnoreCase(authStatus)) {
            try {
                BaseLogger.log((String)"3", null, null, (Object)("savePTEData::::" + placeTimeEntity.toString()));
                PlaceTimeEntityDAO placeTimeEntityDAO = new PlaceTimeEntityDAO(userInfo);
                if (placeTimeEntity.getPteId() != null && placeTimeEntity.getPteId().length() > 0 && !placeTimeEntity.getPteId().equalsIgnoreCase("null")) {
                    editFlag = "E";
                } else {
                    placeTimeEntity.setAddUser(userInfo.getLoginCode());
                    placeTimeEntity.setAddTerm(userInfo.getRemoteHost());
                    placeTimeEntity.setAddDate(new Date());
                    placeTimeEntity.setUserId(userInfo.getLoginCode());
                }
                placeTimeEntity.setChgUser(userInfo.getLoginCode());
                placeTimeEntity.setChgTerm(userInfo.getRemoteHost());
                placeTimeEntity.setChgDate(new Date());
                placeTimeEntity = placeTimeEntityDAO.insertOrUpdate(placeTimeEntity, editFlag);
                JSONParser jsonParser = new JSONParser();
                JSONObject actJsonObj = null;
                String pteActionFilePath = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "resource" + File.separator + "PTE_ACTIONS" + File.separator;
                String fileName = String.valueOf(placeTimeEntity.getEntityType()) + "_" + placeTimeEntity.getLocationType() + ".json";
                BaseLogger.log((String)"3", null, null, (Object)("savePTEData :: pteActionFilePath" + pteActionFilePath + fileName));
                File actonsFile = new File(pteActionFilePath, fileName);
                if (actonsFile.exists()) {
                    Object actionFileObj = jsonParser.parse((Reader)new FileReader(String.valueOf(pteActionFilePath) + fileName));
                    actJsonObj = (JSONObject)actionFileObj;
                    List actionslist = (List)actJsonObj.get((Object)"actions");
                    List<Object> newActionList = new ArrayList();
                    newActionList = this.updateActionParams(actionslist, placeTimeEntity.getEntityCode());
                    actJsonObj.put((Object)"actions", newActionList);
                    actJsonObj.put((Object)"default", (Object)this.updateDefaultActionParams((String)actJsonObj.get((Object)"default"), placeTimeEntity.getEntityCode()));
                } else {
                    actJsonObj = new JSONObject();
                }
                BaseLogger.log((String)"3", null, null, (Object)("getAllPTEData::::" + placeTimeEntity.toString()));
                String objName = placeTimeEntity.getEntityCode().trim();
                String fldValue = placeTimeEntity.getEntityCode().trim();
                String altFldValue = placeTimeEntity.getEntityDescr().trim();
                String object = this.getObject(placeTimeEntity.getEntityType());
                BaseLogger.log((String)"3", null, null, (Object)("objName" + objName + "fldValue" + fldValue + "altFldValue" + altFldValue + "object" + object));
                String userImagePath = CommonConstants.TOMCAT_HOME;
                userImagePath = "H".equalsIgnoreCase(placeTimeEntity.getEntityType()) ? String.valueOf(userImagePath) + this.getUserImageURL(userInfo) : String.valueOf(userImagePath) + this.getCustomImageURL(objName, fldValue, altFldValue, object);
                BaseLogger.log((String)"3", null, null, (Object)("userImagePath in   savePTEData " + userImagePath));
                String[] geoPos = placeTimeEntity.getGeoPos().split(",");
                actJsonObj.put((Object)"imgURL", (Object)userImagePath);
                actJsonObj.put((Object)"latitude", (Object)geoPos[0]);
                actJsonObj.put((Object)"longitude", (Object)geoPos[1]);
                actJsonObj.put((Object)"GEOFENCE_REQUEST_ID", (Object)placeTimeEntity.getPteId());
                actJsonObj.put((Object)"message", (Object)placeTimeEntity.getDescr());
                SimpleDateFormat localDateFormat = new SimpleDateFormat("HH:mm:ss");
                String startTime = "";
                String endTime = "";
                if (placeTimeEntity.getFromTime() != null) {
                    startTime = localDateFormat.format(placeTimeEntity.getFromTime());
                }
                if (placeTimeEntity.getToTime() != null) {
                    endTime = localDateFormat.format(placeTimeEntity.getToTime());
                }
                actJsonObj.put((Object)"start_time", (Object)startTime);
                actJsonObj.put((Object)"end_time", (Object)endTime);
                BaseLogger.log((String)"3", null, null, (Object)("PTEService :: savePTEData :: GEOFENCE_REQUEST_JSON" + actJsonObj.toString()));
                if (!isMobileApk.booleanValue()) {
                    AppConnectParm appConnect = new AppConnectParm();
                    InitialContext ctx = new InitialContext(appConnect.getProperty());
                    PublishPushNotificationEJB publishNotification = new PublishPushNotificationEJB();
                    ArrayList<String> userIdList = new ArrayList<String>();
                    userIdList.add(userInfo.getLoginCode());
                    publishNotification.invockPushNotification("New place marker is created, tap here to register. This would assist you in location based events.", userInfo.getEmpName(), "P", placeTimeEntity.getPteId(), userIdList, actJsonObj.toString(), userInfo);
                } else {
                    ArrayList<org.json.JSONObject> geofenceArr = new ArrayList<org.json.JSONObject>();
                    org.json.JSONObject geofenceJson = new org.json.JSONObject();
                    geofenceJson.put("XMLData", (Map)actJsonObj);
                    geofenceJson.put("openTarget", (Object)"P");
                    geofenceJson.put("category", (Object)"transpush");
                    geofenceJson.put("message", (Object)placeTimeEntity.getDescr());
                    geofenceArr.add(geofenceJson);
                    resultJson.put("geofence", geofenceArr);
                }
            }
            catch (Exception e) {
                BaseLogger.log((String)"0", null, null, (Object)("Exception in  PTEService :: savePTEData : " + e.getMessage()));
                e.printStackTrace();
                throw new Exception(e);
            }
            resultJson.put("status", (Object)placeTimeEntity);
        } else {
            resultJson.put("status", (Object)"error");
        }
        return Response.status((int)200).entity((Object)resultJson.toString()).build();
    }

    @DELETE
    @Path(value="/deletePTEData/{pteid}")
    @Produces(value={"application/json"})
    public Response deletePTEData(@PathParam(value="pteid") String pteId, @Context HttpServletRequest request) throws Exception {
        org.json.JSONObject resultJson = new org.json.JSONObject();
        String authStatus = "";
        String editFlag = "";
        List placeTimeEntityList = new ArrayList();
        UserInfoBean userInfo = (UserInfoBean)request.getSession().getAttribute("USER_INFO");
        if (userInfo != null) {
            authStatus = "VALID";
        }
        if ("VALID".equalsIgnoreCase(authStatus)) {
            try {
                BaseLogger.log((String)"3", null, null, (Object)("deletePTEData::::" + pteId));
                PlaceTimeEntityDAO placeTimeEntityDAO = new PlaceTimeEntityDAO(userInfo);
                if (pteId != null && pteId.length() > 0) {
                    placeTimeEntityDAO.deletePteData(pteId);
                }
                placeTimeEntityList = placeTimeEntityDAO.getAllPteData();
                for (PlaceTimeEntity placeTimeEntity : placeTimeEntityList) {
                    String entityDescr = this.getEntityName(placeTimeEntity.getEntityType(), placeTimeEntity.getEntityCode(), userInfo);
                    placeTimeEntity.setEntityDescr(entityDescr);
                    BaseLogger.log((String)"3", null, null, (Object)("deletePTEData::::" + placeTimeEntity.toString()));
                    String objName = placeTimeEntity.getEntityCode().trim();
                    String fldValue = placeTimeEntity.getEntityCode().trim();
                    String altFldValue = placeTimeEntity.getEntityDescr().trim();
                    String object = this.getObject(placeTimeEntity.getEntityType());
                    BaseLogger.log((String)"3", null, null, (Object)("objName" + objName + "fldValue" + fldValue + "altFldValue" + altFldValue + "object" + object));
                    String userImagePath = "";
                    userImagePath = "H".equalsIgnoreCase(placeTimeEntity.getEntityType()) ? this.getUserImageURL(userInfo) : this.getCustomImageURL(objName, fldValue, altFldValue, object);
                    BaseLogger.log((String)"3", null, null, (Object)(" <===  userImagePath in deletePTEData method === >" + userImagePath));
                    placeTimeEntity.setImgUrl(userImagePath);
                }
            }
            catch (Exception e) {
                BaseLogger.log((String)"0", null, null, (Object)("In PTEService :: deletePTEData : " + e.getMessage()));
                e.printStackTrace();
                throw new Exception(e);
            }
            BaseLogger.log((String)"3", null, null, (Object)(" <===  placeTimeEntityList in deletePTEData method === >" + placeTimeEntityList));
            resultJson.put("status", placeTimeEntityList);
        } else {
            resultJson.put("status", (Object)"error");
        }
        return Response.status((int)200).entity((Object)resultJson.toString()).build();
    }

    @GET
    @Path(value="/getEntityData/{entityType}/{searchParam: .*}")
    @Produces(value={"application/json"})
    public Response getEntityData(@PathParam(value="entityType") String entityType, @PathParam(value="searchParam") String searchParam, @Context HttpServletRequest request) throws Exception {
        org.json.JSONObject resultJson = new org.json.JSONObject();
        String authStatus = "";
        UserInfoBean userInfo = (UserInfoBean)request.getSession().getAttribute("USER_INFO");
        if (userInfo != null) {
            authStatus = "VALID";
        }
        if ("VALID".equalsIgnoreCase(authStatus)) {
            List<Object> entityList = new ArrayList();
            String objName = "users";
            String docTypeAttach = "Profile Image";
            String imgUrl = "";
            try {
                BaseLogger.log((String)"3", null, null, (Object)"In getEntityData method!!!!!!!!!!!");
                entityList = this.getEntityInfoData(entityType, searchParam, userInfo);
                BaseLogger.log((String)"3", null, null, (Object)("entityList.isEmpty() ==> " + entityList.isEmpty()));
                if (!entityList.isEmpty()) {
                    String entityCode = (String)((HashMap)entityList.get(0)).get("CODE");
                    String entityDescr = this.getEntityName(entityType, entityCode.trim(), userInfo);
                    imgUrl = "/ibase/CustomMenuImageServlet?fldValue=<CODE>&objName=" + objName + "&docAttachType=" + docTypeAttach + "&ALT_FLD_VALUE=<DESCR>";
                    BaseLogger.log((String)"3", null, null, (Object)("imgUrl ==  > " + imgUrl + "entityCode == > " + entityCode + "entityDescr == > " + entityDescr));
                }
            }
            catch (Exception e) {
                BaseLogger.log((String)"0", null, null, (Object)("In PTEService :: getEntityData : " + e.getMessage()));
                e.printStackTrace();
                throw new Exception(e);
            }
            resultJson.put("imgUrl", (Object)imgUrl);
            resultJson.put("chipMetadata", (Object)"<DESCR>");
            resultJson.put("suggestMetadata", (Object)"<DESCR>");
            resultJson.put("valueFields", (Object)"CODE");
            resultJson.put("details", entityList);
        } else {
            resultJson.put("status", (Object)"error");
        }
        return Response.status((int)200).entity((Object)resultJson.toString()).build();
    }

    @GET
    @Path(value="/getUserInfo")
    public Response getUserInfo(@Context HttpServletRequest request) throws Exception {
        String authStatus = "";
        org.json.JSONObject resultJson = new org.json.JSONObject();
        UserInfoBean userInfo = (UserInfoBean)request.getSession().getAttribute("USER_INFO");
        ArrayList placeTimeEntityList = new ArrayList();
        if (userInfo != null) {
            authStatus = "VALID";
            resultJson.put("result", (Object)"ERROR");
        }
        if ("VALID".equalsIgnoreCase(authStatus)) {
            String userInfoString = userInfo.toString();
            org.json.JSONObject userInfoObject = XML.toJSONObject((String)userInfoString);
            BaseLogger.log((String)"3", null, null, (Object)userInfoObject);
            resultJson.put("result", (Object)userInfoObject);
        }
        return Response.status((int)200).entity((Object)resultJson.toString()).build();
    }

    @POST
    @Path(value="/syncPTENotification")
    public Response syncPTENotification(@Context HttpServletRequest request) throws Exception {
        org.json.JSONObject resultJson = new org.json.JSONObject();
        String authStatus = "";
        String editFlag = "A";
        UserInfoBean userInfo = (UserInfoBean)request.getSession().getAttribute("USER_INFO");
        List placeTimeEntityList = new ArrayList();
        if (userInfo != null) {
            authStatus = "VALID";
        }
        if ("VALID".equalsIgnoreCase(authStatus)) {
            try {
                BaseLogger.log((String)"3", null, null, (Object)" < == syncNotification method in service == > ");
                PlaceTimeEntityDAO placeTimeEntityDAO = new PlaceTimeEntityDAO(userInfo);
                placeTimeEntityDAO.updateRecStatus(userInfo.getLoginCode());
                placeTimeEntityList = placeTimeEntityDAO.getActivePteData(userInfo.getLoginCode());
                ArrayList<org.json.JSONObject> geofenceArr = new ArrayList<org.json.JSONObject>();
                for (PlaceTimeEntity placeTimeEntity : placeTimeEntityList) {
                    JSONParser jsonParser = new JSONParser();
                    String pteActionFilePath = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "resource" + File.separator + "PTE_ACTIONS" + File.separator;
                    String fileName = String.valueOf(placeTimeEntity.getEntityType()) + "_" + placeTimeEntity.getLocationType() + ".json";
                    BaseLogger.log((String)"3", null, null, (Object)(" PTEService :: savePTEData :: pteActionFilePath" + pteActionFilePath + fileName));
                    File actonsFile = new File(pteActionFilePath, fileName);
                    JSONObject actJsonObj = null;
                    if (actonsFile.exists()) {
                        Object actionFileObj = jsonParser.parse((Reader)new FileReader(String.valueOf(pteActionFilePath) + fileName));
                        actJsonObj = (JSONObject)actionFileObj;
                        List actionslist = (List)actJsonObj.get((Object)"actions");
                        List<Object> newActionList = new ArrayList();
                        newActionList = this.updateActionParams(actionslist, placeTimeEntity.getEntityCode());
                        actJsonObj.put((Object)"actions", newActionList);
                        actJsonObj.put((Object)"default", (Object)this.updateDefaultActionParams((String)actJsonObj.get((Object)"default"), placeTimeEntity.getEntityCode()));
                    } else {
                        actJsonObj = new JSONObject();
                        actJsonObj.put((Object)"radius", (Object)"100");
                    }
                    String[] geoPos = placeTimeEntity.getGeoPos().split(",");
                    String entityDescr = this.getEntityName(placeTimeEntity.getEntityType(), placeTimeEntity.getEntityCode(), userInfo);
                    placeTimeEntity.setEntityDescr(entityDescr);
                    BaseLogger.log((String)"3", null, null, (Object)("getAllPTEData::::" + placeTimeEntity.toString()));
                    String objName = placeTimeEntity.getEntityCode().trim();
                    String fldValue = placeTimeEntity.getEntityCode().trim();
                    String altFldValue = placeTimeEntity.getEntityDescr().trim();
                    String object = this.getObject(placeTimeEntity.getEntityType());
                    BaseLogger.log((String)"3", null, null, (Object)("objName" + objName + "fldValue" + fldValue + "altFldValue" + altFldValue + "object" + object));
                    String userImagePath = CommonConstants.TOMCAT_HOME;
                    userImagePath = "H".equalsIgnoreCase(placeTimeEntity.getEntityType()) ? String.valueOf(userImagePath) + this.getUserImageURL(userInfo) : String.valueOf(userImagePath) + this.getCustomImageURL(objName, fldValue, altFldValue, object);
                    BaseLogger.log((String)"3", null, null, (Object)("userImagePath in   syncPTENotification " + userImagePath));
                    actJsonObj.put((Object)"imgURL", (Object)userImagePath);
                    actJsonObj.put((Object)"latitude", (Object)geoPos[0]);
                    actJsonObj.put((Object)"longitude", (Object)geoPos[1]);
                    actJsonObj.put((Object)"GEOFENCE_REQUEST_ID", (Object)placeTimeEntity.getPteId());
                    actJsonObj.put((Object)"message", (Object)placeTimeEntity.getDescr());
                    SimpleDateFormat localDateFormat = new SimpleDateFormat("HH:mm:ss");
                    String startTime = "";
                    String endTime = "";
                    if (placeTimeEntity.getFromTime() != null) {
                        startTime = localDateFormat.format(placeTimeEntity.getFromTime());
                    }
                    if (placeTimeEntity.getToTime() != null) {
                        endTime = localDateFormat.format(placeTimeEntity.getToTime());
                    }
                    actJsonObj.put((Object)"start_time", (Object)startTime);
                    actJsonObj.put((Object)"end_time", (Object)endTime);
                    BaseLogger.log((String)"3", null, null, (Object)("syncPTENotification :: GEOFENCE_REQUEST_JSON" + actJsonObj.toString()));
                    org.json.JSONObject geofenceJson = new org.json.JSONObject();
                    geofenceJson.put("XMLData", (Map)actJsonObj);
                    geofenceJson.put("openTarget", (Object)"P");
                    geofenceJson.put("category", (Object)"transpush");
                    geofenceJson.put("message", (Object)placeTimeEntity.getDescr());
                    geofenceArr.add(geofenceJson);
                }
                resultJson.put("geofence", geofenceArr);
            }
            catch (Exception e) {
                BaseLogger.log((String)"0", null, null, (Object)("In in PTEService :: syncPTENotification : " + e.getMessage()));
                e.printStackTrace();
                throw new Exception(e);
            }
            resultJson.put("status", (Object)"success");
        } else {
            resultJson.put("status", (Object)"error");
        }
        return Response.status((int)200).entity((Object)resultJson.toString()).build();
    }

    public List<HashMap<String, String>> getEntityInfoData(String entityType, String searchParam, UserInfoBean userInfo) throws Exception {
        ArrayList<HashMap<String, String>> entityList = new ArrayList();
        try {
            EntityDAO entityDAO = new EntityDAO(userInfo);
            entityList = entityDAO.getEntityList(entityType, searchParam);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        return entityList;
    }

    private String getEntityName(String entityType, String entityCode, UserInfoBean userInfo) {
        EntityDAO entityDAO = new EntityDAO(userInfo);
        if ("H".equalsIgnoreCase(entityType)) {
            return userInfo.getEmpName();
        }
        return entityDAO.getEntityName(entityType, entityCode);
    }

    private List<String> updateActionParams(List<String> actionslist, String entityCode) throws BaseException {
        ArrayList<String> newActionList = new ArrayList<String>();
        try {
            for (String string : actionslist) {
                Document dom = new E12GenericUtility().parseString(string);
                NodeList strgCustNode = dom.getElementsByTagName("strg_code");
                if (strgCustNode != null && strgCustNode.item(0) != null) {
                    if (strgCustNode.item(0).getFirstChild() != null) {
                        strgCustNode.item(0).getFirstChild().setNodeValue(entityCode);
                    } else {
                        strgCustNode.item(0).setTextContent(entityCode);
                    }
                }
                newActionList.add(new E12GenericUtility().serializeDom((Node)dom));
            }
        }
        catch (Exception e) {
            BaseLogger.log((String)"0", null, null, (Object)("updateActionParams:actionslist:" + actionslist));
            return actionslist;
        }
        BaseLogger.log((String)"2", null, null, (Object)("updateActionParams:newActionList:" + newActionList));
        return newActionList;
    }

    private String updateDefaultActionParams(String actionXml, String entityCode) throws BaseException {
        String newActionXml = "";
        try {
            Document dom = new E12GenericUtility().parseString(actionXml);
            NodeList strgCustNode = dom.getElementsByTagName("strg_code");
            if (strgCustNode != null && strgCustNode.item(0) != null) {
                if (strgCustNode.item(0).getFirstChild() != null) {
                    strgCustNode.item(0).getFirstChild().setNodeValue(entityCode);
                } else {
                    strgCustNode.item(0).setTextContent(entityCode);
                }
            }
            newActionXml = new E12GenericUtility().serializeDom((Node)dom);
        }
        catch (Exception e) {
            BaseLogger.log((String)"0", null, null, (Object)("updateDefaultActionParams:newActionXml:" + newActionXml));
            return newActionXml;
        }
        BaseLogger.log((String)"2", null, null, (Object)("updateDefaultActionParams:newActionXml:" + newActionXml));
        return newActionXml;
    }

    private String getObject(String entityType) {
        String object = "";
        if (entityType.equalsIgnoreCase("C")) {
            object = "wsfa_strg_customer";
        } else if (entityType.equalsIgnoreCase("S")) {
            object = "supplier";
        } else if (entityType.equalsIgnoreCase("E")) {
            object = "employee";
        } else if (entityType.equalsIgnoreCase("P")) {
            object = "slpers";
        }
        return object;
    }

    private String getCustomImageURL(String objName, String fldValue, String altFldValue, String object) {
        String imageURL = "/ibase/CustomMenuImageServlet?fldValue=" + fldValue + "&ALT_FLD_VALUE=" + altFldValue + "&objName=" + objName + "&object=" + object;
        BaseLogger.log((String)"2", null, null, (Object)("imageURL getCustomImageURL:" + imageURL));
        return imageURL;
    }

    private String getUserImageURL(UserInfoBean userInfo) {
        if (userInfo != null) {
            return "/ibase/resource/images/users/" + E12GenericUtility.checkNull((String)userInfo.getLoginCode()) + ".png";
        }
        return "";
    }
}

