/*
 * Decompiled with CFR 0.152.
 */
package ibase.system.config;

import ibase.system.config.StatementMonitor;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.webitm.ejb.InfinispanLocal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import javax.naming.InitialContext;

public class ConnectionMonitor {
    private String userId;
    private String transDB;
    private Date startTime;
    private Date endTime;
    private String connectionId;
    private String status;
    private String clientIP;
    private String className;
    private String methodName;
    private int lineNo;
    private String stackTrace;
    private HashMap<String, StatementMonitor> statementMap = new HashMap();
    SimpleDateFormat dateFormat = new SimpleDateFormat(CommonConstants.APPL_DATETIME_FORMAT);
    static InfinispanLocal infinispanLocalObj = null;
    static Hashtable jndiProperties = null;
    static InitialContext ctx = null;

    static {
        try {
            if (CommonConstants.CACHE_OPT != 0) {
                jndiProperties = new Hashtable();
                jndiProperties.put("java.naming.factory.url.pkgs", "org.jboss.ejb.client.naming");
                ctx = new InitialContext(jndiProperties);
                infinispanLocalObj = (InfinispanLocal)ctx.lookup("ibase/InfinispanEJB/local");
                BaseLogger.log("3", null, null, "ConnectionMonitor infinispanLocalObj created.....");
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception in ConnectionMonitor static block:[" + e.getMessage() + "]");
            e.printStackTrace();
        }
    }

    public ConnectionMonitor() {
    }

    public ConnectionMonitor(String userId, String transDB, Date startTime, Date endTime, String connectionId, String status, String clientIP, String className, String methodName, int lineNo, String stackTrace) {
        this.userId = userId;
        this.transDB = transDB;
        this.startTime = startTime;
        this.endTime = endTime;
        this.connectionId = connectionId;
        this.status = status;
        this.clientIP = clientIP;
        this.className = className;
        this.methodName = methodName;
        this.lineNo = lineNo;
        this.stackTrace = stackTrace;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String gettransDB() {
        return this.transDB;
    }

    public void settransDB(String transDB) {
        this.transDB = transDB;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public void setConnectionId(String connectionId) {
        this.connectionId = connectionId;
    }

    public HashMap<String, StatementMonitor> getStatementMap() {
        return this.statementMap;
    }

    public void setStatementMap(HashMap<String, StatementMonitor> statementMap) {
        this.statementMap = statementMap;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getClientIP() {
        return this.clientIP;
    }

    public void setClientIP(String clientIP) {
        this.clientIP = clientIP;
    }

    public String getTransDB() {
        return this.transDB;
    }

    public void setTransDB(String transDB) {
        this.transDB = transDB;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public int getLineNo() {
        return this.lineNo;
    }

    public void setLineNo(int lineNo) {
        this.lineNo = lineNo;
    }

    public String getStackTrace() {
        return this.stackTrace;
    }

    public void setStackTrace(String stackTrace) {
        this.stackTrace = stackTrace;
    }

    public void updateConnectionMonitorDetails() {
        try {
            if (CommonConstants.CACHE_OPT != 0 && infinispanLocalObj != null) {
                if (infinispanLocalObj.containsConnInfo(this.connectionId)) {
                    ConnectionMonitor oldConnenctionInfoObj;
                    ConnectionMonitor newConnenctionInfoObj = oldConnenctionInfoObj = infinispanLocalObj.getConnInfo(this.connectionId);
                    newConnenctionInfoObj.setEndTime(this.endTime);
                    newConnenctionInfoObj.setStatus(this.status);
                    if (oldConnenctionInfoObj != null) {
                        HashMap<String, StatementMonitor> stateMentMap = oldConnenctionInfoObj.getStatementMap();
                        Iterator<String> iterator = stateMentMap.keySet().iterator();
                        String statementStatus = "clean";
                        while (iterator.hasNext()) {
                            String status = "";
                            String statementId = iterator.next();
                            StatementMonitor statementMonitor = stateMentMap.get(statementId);
                            if (statementMonitor != null && "dirty".equalsIgnoreCase(status = statementMonitor.getStatus())) {
                                statementStatus = "dirty";
                                break;
                            }
                            statementMonitor = null;
                        }
                        if ("clean".equalsIgnoreCase(statementStatus) && "clean".equalsIgnoreCase(this.status)) {
                            infinispanLocalObj.remove(this.connectionId);
                        } else {
                            infinispanLocalObj.putConnInfo(this.connectionId, newConnenctionInfoObj);
                        }
                        newConnenctionInfoObj = null;
                        oldConnenctionInfoObj = null;
                        Object var3_4 = null;
                    }
                } else {
                    infinispanLocalObj.putConnInfo(this.connectionId, this);
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception in updateConnectionMonitorDetails:[" + e.getMessage() + "]");
            e.printStackTrace();
        }
    }

    public String toString() {
        String startTime = "";
        String endTime = "";
        if (this.startTime != null) {
            startTime = this.dateFormat.format(this.startTime);
        }
        if (this.endTime != null) {
            endTime = this.dateFormat.format(this.endTime);
        }
        StringBuffer connectionMonitorDetailsBuf = new StringBuffer();
        connectionMonitorDetailsBuf.append("<connectionDetails status=\"" + this.status + "\" clientIP=\"" + this.clientIP + "\" connectionId=\"" + this.connectionId + "\" >");
        connectionMonitorDetailsBuf.append("<userId>");
        connectionMonitorDetailsBuf.append("<![CDATA[").append(this.userId).append("]]>");
        connectionMonitorDetailsBuf.append("</userId>");
        connectionMonitorDetailsBuf.append("<transDB>");
        connectionMonitorDetailsBuf.append("<![CDATA[").append(this.transDB).append("]]>");
        connectionMonitorDetailsBuf.append("</transDB>");
        connectionMonitorDetailsBuf.append("<startTime>");
        connectionMonitorDetailsBuf.append("<![CDATA[").append(startTime).append("]]>");
        connectionMonitorDetailsBuf.append("</startTime>");
        connectionMonitorDetailsBuf.append("<endTime>");
        connectionMonitorDetailsBuf.append("<![CDATA[").append(endTime).append("]]>");
        connectionMonitorDetailsBuf.append("</endTime>");
        connectionMonitorDetailsBuf.append("<className>");
        connectionMonitorDetailsBuf.append("<![CDATA[").append(this.className).append("]]>");
        connectionMonitorDetailsBuf.append("</className>");
        connectionMonitorDetailsBuf.append("<methodName>");
        connectionMonitorDetailsBuf.append("<![CDATA[").append(this.methodName).append("]]>");
        connectionMonitorDetailsBuf.append("</methodName>");
        connectionMonitorDetailsBuf.append("<lineNo>");
        connectionMonitorDetailsBuf.append("<![CDATA[").append(this.lineNo).append("]]>");
        connectionMonitorDetailsBuf.append("</lineNo>");
        connectionMonitorDetailsBuf.append("<stackTrace>");
        connectionMonitorDetailsBuf.append("<![CDATA[").append(this.stackTrace).append("]]>");
        connectionMonitorDetailsBuf.append("</stackTrace>");
        Set<String> setMap = this.statementMap.keySet();
        for (String key : setMap) {
            StatementMonitor monitor = this.statementMap.get(key);
            connectionMonitorDetailsBuf.append("<statementDetails status=\"" + monitor.getStatus() + "\" statementId=\"" + monitor.getStatementId() + "\" statementType=\"" + monitor.getStatementType() + "\" >");
            connectionMonitorDetailsBuf.append(monitor.toString());
            connectionMonitorDetailsBuf.append("</statementDetails>");
        }
        connectionMonitorDetailsBuf.append("</connectionDetails>");
        return connectionMonitorDetailsBuf.toString();
    }
}

